-- Fragment begins: 1 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (1, 'Main', NOW(), 'dbdeploy', '1-initial_schema.sql');
--
SET NAMES 'utf8';

CREATE TABLE IF NOT EXISTS `video`(
    `id` int NOT NULL auto_increment,
    `owner` varchar(64) NOT NULL default '',
    `name` varchar(255) NOT NULL default '',
    `old_name` varchar(255) NOT NULL default '',
    `o_name` varchar(255) NOT NULL default '',
    `fname` varchar(128) NOT NULL default '',
    `description` text,
    `pic` varchar(128) NOT NULL default '',
    `cost` int NOT NULL default 0,
    `time` varchar(64) NOT NULL default '',
    `file` varchar(128) NOT NULL default '',
    `path` varchar(255) NOT NULL default '',
    `protocol` varchar(64) NOT NULL default 'nfs',
    `rtsp_url` varchar(255) NOT NULL default '',
    `censored` tinyint default 0, /* 0-off, 1-on */
    `hd` tinyint default 0,
    `series` text NOT NULL,
    `volume_correction` int NOT NULL default 0,
    `category_id` int NOT NULL default 0,
    `genre_id` int NOT NULL default 0,
    `genre_id_1` int NOT NULL default 0,
    `genre_id_2` int NOT NULL default 0,
    `genre_id_3` int NOT NULL default 0,
    `genre_id_4` int NOT NULL default 0,
    `cat_genre_id_1` int NOT NULL default 0,
    `cat_genre_id_2` int NOT NULL default 0,
    `cat_genre_id_3` int NOT NULL default 0,
    `cat_genre_id_4` int NOT NULL default 0,
    `director` varchar(128) NOT NULL default '',
    `actors` varchar(255) NOT NULL default '',
    `year` varchar(128) NOT NULL default '',
    `accessed` tinyint default 0, /* 0-off, 1-on */
    `status` tinyint default 0, /* 0-red, 1-green */
    `disable_for_hd_devices` tinyint default 0,
    `added` datetime,
    `count` int  NOT NULL default 0,
    `count_first_0_5` int  NOT NULL default 0,
    `count_second_0_5` int  NOT NULL default 0,
    `vote_sound_good` int NOT NULL default 0,
    `vote_sound_bad` int NOT NULL default 0,
    `vote_video_good` int NOT NULL default 0,
    `vote_video_bad` int NOT NULL default 0,
    `rate` text NOT NULL,
    `last_rate_update` date,
    `last_played` date,
    PRIMARY KEY (`id`),
    KEY `path` (`path`),
    KEY `genre_id` (`genre_id`),
    KEY `genre_id_1` (`genre_id_1`),
    KEY `genre_id_2` (`genre_id_2`),
    KEY `genre_id_3` (`genre_id_3`),
    KEY `genre_id_4` (`genre_id_4`),
    KEY `status` (`status`),
    KEY `accessed` (`accessed`),
    KEY `hd` (`hd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `genre`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    `category_id` int(11) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `genre` VALUES (1,'Action',0),(2,'Detective',0),(3,'Documentary',0),(4,'Drama',0),(5,'Historical',0),(6,'Clips',0),(7,'Comedy',0),(8,'Melodrama',0),(24,'Humour',0),(10,'Adventures',0),(11,'Thriller',0),(12,'Horrors',0),(13,'Fiction',0),(14,'Erotica',0),(15,'Fantasy',0),(16,'Animation',0),(17,'Childrens',0),(18,'Musical',0),(19,'Western',0),(21,'Serial',0),(22,'Sports',0),(23,'Teach',0),(25,'Information',0);

CREATE TABLE IF NOT EXISTS `cat_genre`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    `category_alias` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`),
    KEY `category_alias` (`category_alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `cat_genre`
VALUES (1, 'Action', 'movies'),
  (2, 'Adventure', 'movies'),
  (3, 'Documentary', 'movies'),
  (4, 'Drama', 'movies'),
  (5, 'Comedy', 'movies'),
  (6, 'Family', 'movies'),
  (7, 'Musical', 'movies'),
  (8, 'Horror', 'movies'),
  (9, 'Action', 'tv_shows'),
  (10, 'Adventure', 'tv_shows'),
  (11, 'Documentary', 'tv_shows'),
  (12, 'Drama', 'tv_shows'),
  (13, 'Comedy', 'tv_shows'),
  (14, 'Family', 'tv_shows'),
  (15, 'Musical', 'tv_shows'),
  (16, 'Horror', 'tv_shows'),
  (17, 'Action', 'cartoons'),
  (18, 'Adventure', 'cartoons'),
  (19, 'Drama', 'cartoons'),
  (20, 'Comedy', 'cartoons'),
  (21, 'Family', 'cartoons'),
  (22, 'Musical', 'cartoons'),
  (23, 'Horror', 'cartoons'),
  (24, 'Clips', 'music_videos'),
  (25, 'Concerts', 'music_videos');

CREATE TABLE IF NOT EXISTS `itv`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `number` int NOT NULL default 0,
    `censored` tinyint default 0,
    `cmd` varchar(128) NOT NULL default '',
    `descr` text NOT NULL,
    `cost` int NOT NULL default 0,
    `count` int  NOT NULL default 0,
    `status` tinyint unsigned NOT NULL default 1,
    `tv_genre_id` int NOT NULL default 0,
    `base_ch` tinyint default 0, /* 1 - base channel */
    `hd` tinyint default 0,
    `xmltv_id` varchar(128) NOT NULL default '',
    `service_id` varchar(32) NOT NULL default '',
    `bonus_ch` tinyint default 0, /* 1 - bonus channel */
    `volume_correction` int NOT NULL default 0,
    `use_http_tmp_link` tinyint default 0,
    `mc_cmd` varchar(128) NOT NULL default '',
    PRIMARY KEY (`id`),
    UNIQUE KEY `name` (`name`),
    KEY `status` (`status`),
    KEY `tv_genre_id` (`tv_genre_id`),
    KEY `status_3` (`status`,`number`,`hd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `itv` (`name`, `number`, `cmd`, `tv_genre_id`, `base_ch`) VALUES ('Test channel', 1, 'rtp rtp://239.1.1.1:1234', 1, 1);

CREATE TABLE IF NOT EXISTS `tv_genre`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    PRIMARY KEY (`id`),
    UNIQUE KEY (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `tv_genre`
VALUES (1, 'Documentary'), (2, 'Entertainment'), (3, 'For Kids'),
  (4, 'Movies'), (5, 'Music'), (6, 'News'),
  (7, 'Nature'), (8, 'Sports'), (19, 'For Adults');

CREATE TABLE IF NOT EXISTS `last_id`(
    `id` int NOT NULL auto_increment,
    `ident` varchar(64) NOT NULL default '',
    `last_id` int unsigned NOT NULL default 0,
    UNIQUE KEY (`ident`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `screenshots`(
    `id` int NOT NULL auto_increment,
    `name` varchar(64) NOT NULL default '',
    `size` varchar(255) NOT NULL default '',
    `type` varchar(255) NOT NULL default '',
    `media_id` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`),
    KEY `media_id` (`media_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `epg`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `time` timestamp not null,
    `time_to` timestamp not null,
    `duration` int NOT NULL default 0,
    `name` varchar(128) NOT NULL default '',
    `descr` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`),
    KEY `ch_id_time` (`ch_id`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `karaoke`(
    `id` int NOT NULL auto_increment,
    `owner` varchar(64) NOT NULL default '',
    `name` varchar(128) NOT NULL default '',
    `fname` varchar(128) NOT NULL default '',
    `description` text,
    `protocol` varchar(64) NOT NULL default 'nfs',
    `rtsp_url` varchar(255) NOT NULL default '',
    `pic` varchar(128) NOT NULL default '',
    `cost` int NOT NULL default 0,
    `time` varchar(64) NOT NULL default '',
    `file` varchar(128) NOT NULL default '',
    `path` varchar(128) NOT NULL default '',
    `genre_id` int NOT NULL default 0,
    `singer` varchar(128) NOT NULL default '',
    `author` varchar(128) NOT NULL default '',
    `year` varchar(128) NOT NULL default '',
    `accessed` tinyint default 0,
    `status` tinyint default 0,
    `added` datetime,
    `add_by` int NOT NULL default 0,
    `done` tinyint default 0,
    `done_time` datetime,
    `archived` tinyint default 0,
    `archived_time` datetime,
    `returned` tinyint default 0,
    `reason` varchar(255) NOT NULL default '',
    `count` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `karaoke_genre`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    PRIMARY KEY (`id`),
    UNIQUE KEY (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `karaoke_genre` VALUES (1,'Pop'),(2,'Rock'),(3,'Chanson'),(4,'From cartoon films'),(5,'Nurseries'),(6,'National'),(7,'Jazz'),(8,'From films'); 

CREATE TABLE IF NOT EXISTS `user_log`(
    `id` int NOT NULL auto_increment,
    `mac` varchar(128) NOT NULL default '',
    `uid` int NOT NULL default 0,
    `action` varchar(128) NOT NULL default '',
    `param` varchar(128) NOT NULL default '',
    `time` datetime,
    `type` tinyint(4) default '0',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `users`(
    `id` int NOT NULL auto_increment,
    `name` varchar(64) NOT NULL default '',
    `sname` varchar(64) NOT NULL default '',
    `pass` varchar(64) NOT NULL default '',
    `parent_password` varchar(64) NOT NULL default '0000',
    `bright` varchar(64) NOT NULL default '200',
    `contrast` varchar(64) NOT NULL default '127',
    `saturation` varchar(64) NOT NULL default '127',
    `aspect` int NOT NULL default 16,
    `video_out` varchar(64) NOT NULL default 'rca',
    `volume` varchar(64) NOT NULL default '100',
    `playback_buffer_bytes` int NOT NULL default 0,
    `playback_buffer_size` int NOT NULL default 0,
    `audio_out` int NOT NULL default 0,
    `mac` varchar(64) NOT NULL default '',
    `ip` varchar(128) NOT NULL default '',
    `ls` int not null default 0,
    `version` varchar(255) NOT NULL default '',
    `lang` varchar(32) NOT NULL default '',
    `locale` varchar(32) NOT NULL default '',
    `city_id` int NOT NULL default 0,
    `status` tinyint default 0,
    `hd` tinyint default 0,
    `main_notify` tinyint default 1,
    `fav_itv_on` tinyint default 0,
    `now_playing_start` timestamp default 0,
    `now_playing_type` tinyint default 0,
    `now_playing_content` varchar(255) NOT NULL default '',
    `additional_services_on` tinyint default 1,
    `time_last_play_tv` timestamp default 0,
    `time_last_play_video` timestamp default 0,
    `operator_id` int NOT NULL default 0,
    `storage_name` varchar(255) NOT NULL default '',
    `hd_content` tinyint default 0,
    `image_version` varchar(255) NOT NULL default '0',
    `last_change_status` timestamp default 0,
    `last_start` timestamp default 0,
    `last_active` timestamp default 0,
    `keep_alive` timestamp default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY `mac` (`mac`),
    KEY `keep_alive` (`keep_alive`),
    KEY `status` (`status`,`keep_alive`,`storage_name`,`hd_content`),
    KEY `keep_alive_2` (`keep_alive`,`now_playing_type`,`storage_name`,`hd_content`),
    KEY `now_playing_type` (`now_playing_type`,`storage_name`,`hd_content`),
    KEY `now_playing_type_2` (`now_playing_type`,`hd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `moderators` (
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `mac` varchar(64) NOT NULL default '',
    `status` tinyint default 1,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`mac`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `events`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `type` varchar(128) NOT NULL default '',
    `event` varchar(128) NOT NULL default '',
    `msg` text NOT NULL,
    `rec_id` int NOT NULL default 0,
    `sended` tinyint default 0,
    `need_confirm` tinyint default 0,
    `confirmed` tinyint default 0,
    `ended` tinyint default 0,
    `reboot_after_ok` tinyint default 0,
    `priority` tinyint default 2, /* 1-system events, 2-system message */
    `addtime` datetime,
    `eventtime` timestamp default 0,
    PRIMARY KEY (`id`),
    KEY `eventtime` (`eventtime`),
    KEY `uid` (`uid`),
    KEY `ended` (`ended`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `fav_itv`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `fav_ch` text NOT NULL,
    `addtime` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `audio`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `singer_id` int NOT NULL default 0,
    `album_id` int NOT NULL default 0,
    `time` int NOT NULL default 0,
    `count` int NOT NULL default 0,
    `lang` tinyint default 0, /*0-rus, 1-eng, 2-num*/
    `status` tinyint default 0,
    `addtime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `singer`(
    `id` int NOT NULL auto_increment,
    `singer` varchar(128) NOT NULL default '',
    `path` varchar(128) NOT NULL default '',
    `lang` tinyint default 0, /*0-rus, 1-eng, 2-num*/
    `addtime` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`singer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `album`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `singer_id` int NOT NULL default 0,
    `year` int NOT NULL default 0,
    `addtime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `playlist`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `tracks` text NOT NULL,
    `addtime` datetime,
    `edittime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `radio`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `number` int NOT NULL default 0,
    `cmd` varchar(128) NOT NULL default '',
    `count` int  NOT NULL default 0,
    `status` tinyint unsigned NOT NULL default 1,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`name`),
    KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `fav_vclub`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `fav_video` text NOT NULL,
    `addtime` datetime,
    `edittime` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `administrators`(
    `id` int NOT NULL auto_increment,
    `login` varchar(128) NOT NULL default '',
    `pass`  varchar(128) NOT NULL default '',
    `name` varchar(128) NOT NULL default '',
    `fname` varchar(128) NOT NULL default '',
    `access` tinyint default 0, /*1-admin, 2-moderator, 3-subscribe moderator*/
    `operator_id` int NOT NULL default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`login`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `administrators` (`login`, `pass`, `access`) values ('admin', md5('1'), 0);

CREATE TABLE IF NOT EXISTS `video_log`(
    `id` int NOT NULL auto_increment,
    `moderator_id` int NOT NULL default 0,
    `action` varchar(128) NOT NULL default '',
    `video_id` int NOT NULL default 0,
    `actiontime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `played_video`(
    `id` int NOT NULL auto_increment,
    `video_id` int NOT NULL default 0,
    `storage` int NOT NULL default 0,
    `uid` int NOT NULL default 0,
    `playtime` timestamp not null,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `played_itv`(
    `id` int NOT NULL auto_increment,
    `itv_id` int NOT NULL default 0,
    `uid` int NOT NULL default 0,
    `playtime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `video_records`(
    `id` int NOT NULL auto_increment,
    `descr` varchar(255) NOT NULL default '',
    `cmd` varchar(255) NOT NULL default '',
    `status` tinyint default 1, /* 1-on, 0-off */
    `accessed` tinyint default 0, /* 0-off, 1-on */
    `addtime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `rec_files`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `t_start` timestamp default 0,
    `t_stop`  timestamp default 0,
    `atrack`  varchar(32) NOT NULL default '',
    `vtrack`  varchar(32) NOT NULL default '',
    `length` int NOT NULL default 0,
    `ended`  tinyint default 0, /* 0-not ended, 1-ended */
    `storage_name` varchar(128) NOT NULL default '',
    `file_name` varchar(128) NOT NULL default '',
    `local` tinyint default 0,
    `uid` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `users_rec`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `program` varchar(64) NOT NULL default '',
    `program_id` int NOT NULL default 0,
    `uid` int NOT NULL default 0,
    `file_id` int NOT NULL default 0,
    `t_start` timestamp default 0,
    `t_stop` timestamp default 0,
    `end_record` timestamp default 0,
    `atrack` varchar(32) NOT NULL default '',
    `vtrack` varchar(32) NOT NULL default '',
    `length` int NOT NULL default 0,
    `last_play` datetime default 0,
    `ended` tinyint default 0, /* 0-not ended, 1-ended */
    `started` tinyint default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `pvr`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `t_start` timestamp default 0,
    `t_stop`  timestamp default 0,
    `atrack`  varchar(32) NOT NULL default '',
    `vtrack`  varchar(32) NOT NULL default '',
    `length` int NOT NULL default 0,
    `ended`  tinyint default 0, /* 0-not ended, 1-ended */
    `uid` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `moderator_tasks`(
    `id` int NOT NULL auto_increment,
    `to_usr` int NOT NULL default 0,
    `media_type` int NOT NULL default 0,
    `media_id` int NOT NULL default 0,
    `media_length` int NOT NULL default 0,
    `start_time` datetime,
    `end_time` datetime,
    `ended` tinyint default 0,
    `rejected` tinyint default 0, /* 1 - rejected, 0 - ended */
    `archived` tinyint default 0,
    `archived_time` datetime default 0,
    PRIMARY KEY (`id`),
    KEY `to_user` (`ended`,`archived`,`to_usr`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `moderators_history`(
    `id` int NOT NULL auto_increment,
    `task_id` int NOT NULL default 0,
    `from_usr` int NOT NULL default 0,
    `to_usr` int NOT NULL default 0,
    `comment` text NOT NULL,
    `send_time` datetime,
    `readed` tinyint default 0,
    `reply_to` int NOT NULL default 0,
    `read_time` datetime,
    PRIMARY KEY (`id`),
    KEY `msqs` (`task_id`,`to_usr`,`readed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `tasks_archive`(
    `id` int NOT NULL auto_increment,
    `date` date NOT NULL default 0,
    `year` int NOT NULL default 0,
    `month` tinyint default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `daily_played_video`(
    `id` int NOT NULL auto_increment,
    `date` date NOT NULL default 0,
    `count` int NOT NULL default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `itv_subscription`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `sub_ch` text NOT NULL,
    `bonus_ch` text NOT NULL,
    `addtime` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `storages`(
    `id` int NOT NULL auto_increment,
    `storage_name` varchar(128) NOT NULL default '',
    `storage_ip` varchar(128) NOT NULL default '',
    `nfs_home_path` varchar(128) NOT NULL default '',
    `max_online` int NOT NULL default 0,
    `status` tinyint default 1,
    `for_moderator` tinyint default 0,
    `for_records` tinyint default 0,
    UNIQUE KEY (`storage_name`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `stream_error`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `mac` varchar(128) NOT NULL default '',
    `error_time` timestamp not null,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `karaoke_archive`(
    `id` int NOT NULL auto_increment,
    `date` datetime NOT NULL default 0,
    `year` int NOT NULL default 0,
    `month` tinyint default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `permitted_video`(
    `id` int NOT NULL auto_increment,
    `o_name` varchar(255) NOT NULL default '',
    `year` int not null default 0,
    `genre` tinyint default 0,
    `added` datetime NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `video_clips`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) NOT NULL default '',
    `singer` varchar(128) NOT NULL default '',
    `censored` tinyint default 0, /* 0-off, 1-on */
    `genre_id` int NOT NULL default 0,
    `accessed` tinyint default 0,
    `status` tinyint default 0,
    `added` datetime,
    `add_by` int NOT NULL default 0,
    `done` tinyint default 0,
    `done_time` datetime,
    `archived` tinyint default 0,
    `archived_time` datetime,
    `returned` tinyint default 0,
    `reason` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `video_clip_genres`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    PRIMARY KEY (`id`),
    UNIQUE KEY (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `vclub_paused`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `mac` varchar(128) NOT NULL default '',
    `pause_time` timestamp not null,
    PRIMARY KEY (`id`),
    KEY `mac` (`mac`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `storage_deny`(
    `id` int NOT NULL auto_increment,
    `name` varchar(255) NOT NULL default '',
    `counter` int NOT NULL default 0,
    `updated` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `rss_cache_weather`(
    `id` int NOT NULL auto_increment,
    `url` varchar(255) NOT NULL default '',
    `content` text not NULL,
    `crc` varchar(64) NOT NULL default '',
    `updated` datetime,
    UNIQUE KEY (`crc`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `rss_cache_horoscope`(
    `id` int NOT NULL auto_increment,
    `url` varchar(255) NOT NULL default '',
    `content` text not NULL,
    `crc` varchar(64) NOT NULL default '',
    `updated` datetime,
    UNIQUE KEY (`crc`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `media_category`(
    `id` int NOT NULL auto_increment,
    `category_name` varchar(255) NOT NULL default '',
    `category_alias` varchar(255) NOT NULL default '',
    `num` int NOT NULL default 0,
    UNIQUE KEY (`category_name`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `media_category`
VALUES (1, 'Movies', 'movies', 1),
  (2, 'TV shows', 'tv_shows', 2),
  (3, 'Cartoons', 'cartoons', 3),
  (4, 'Music videos', 'music_videos', 4);

CREATE TABLE IF NOT EXISTS `main_city_info`(
    `id` int NOT NULL auto_increment,
    `num` int NOT NULL default 0,
    `title` varchar(255) NOT NULL default '',
    `number` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `other_city_info`(
    `id` int NOT NULL auto_increment,
    `num` int NOT NULL default 0,
    `title` varchar(255) NOT NULL default '',
    `number` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `help_city_info`(
    `id` int NOT NULL auto_increment,
    `num` int NOT NULL default 0,
    `title` varchar(255) NOT NULL default '',
    `number` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `anec`(
    `id` int NOT NULL auto_increment,
    `title` varchar(255) NOT NULL default '',
    `anec_body` text NOT NULL,
    `added` datetime,
    PRIMARY KEY (`id`),
    KEY `added` (`added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `readed_anec`(
    `id` int NOT NULL auto_increment,
    `mac` varchar(64) NOT NULL default '',
    `readed` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `anec_bookmark`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `anec_id` int NOT NULL default 0,
    UNIQUE KEY (`uid`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `anec_rating`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `anec_id` int NOT NULL default 0,
    PRIMARY KEY (`id`),
    KEY `uid` (`uid`,`anec_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `loading_fail`(
    `id` int NOT NULL auto_increment,
    `mac` varchar(64) NOT NULL default '',
    `ff_crash` int NOT NULL default 0,
    `added` timestamp not null,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gapi_cache_cur_weather`(
    `id` int NOT NULL auto_increment,
    `url` varchar(255) NOT NULL default '',
    `content` text not NULL,
    `crc` varchar(64) NOT NULL default '',
    `updated` datetime,
    UNIQUE KEY (`crc`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gismeteo_day_weather`(
    `id` int NOT NULL auto_increment,
    `url` varchar(255) NOT NULL default '',
    `content` text not NULL,
    `crc` varchar(64) NOT NULL default '',
    `updated` datetime,
    UNIQUE KEY (`crc`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `updated_places`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `anec` int NOT NULL default 0,
    `vclub` int NOT NULL default 0,
    UNIQUE KEY (`uid`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mastermind_wins`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `tries` int NOT NULL default 0,
    `total_time` int NOT NULL default 0,
    `points` int NOT NULL default 0,
    `added` timestamp not null,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `vclub_not_ended`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `video_id` int NOT NULL default 0,
    `series` int NOT NULL default 0,
    `end_time` int NOT NULL default 0,
    `added` datetime,
    PRIMARY KEY (`id`),
    KEY `uid` (`uid`,`video_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `course_cache`(
    `id` int NOT NULL auto_increment,
    `url` varchar(255) NOT NULL default '',
    `content` text not NULL,
    `crc` varchar(64) NOT NULL default '',
    `updated` datetime,
    UNIQUE KEY (`crc`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `recipe_cats`(
    `id` int NOT NULL auto_increment,
    `title` varchar(128) NOT NULL default '',
    `num` int NOT NULL default 0,
    UNIQUE KEY (`title`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `recipes`(
    `id` int NOT NULL auto_increment,
    `recipe_cat_id_1` int NOT NULL default 0,
    `recipe_cat_id_2` int NOT NULL default 0,
    `recipe_cat_id_3` int NOT NULL default 0,
    `recipe_cat_id_4` int NOT NULL default 0,
    `name` varchar(255) NOT NULL default '',
    `descr` text not NULL,
    `ingredients` text not NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `fav_recipes`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `fav_recipes` text NOT NULL,
    `addtime` datetime,
    `edittime` datetime,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `stb_played_video`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `video_id` int NOT NULL default 0,
    `playtime` timestamp default 0,
    PRIMARY KEY (`id`),
    KEY `uid_video_id` (`uid`,`video_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `storage_cache`(
    `id` int NOT NULL auto_increment,
    `cache_key` varchar(64) NOT NULL default '',
    `media_type` varchar(64) NOT NULL default '',
    `media_id` int NOT NULL default 0,
    `storage_name` varchar(255) NOT NULL default '',
    `storage_data` text NOT NULL,
    `status` tinyint default 1,
    `changed` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`cache_key`),
    KEY `media_id_status_type` (`media_id`,`status`,`media_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `master_log`(
    `id` int NOT NULL auto_increment,
    `log_txt` varchar(255) NOT NULL default '',
    `added` datetime,
    PRIMARY KEY (`id`),
    INDEX(`added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `media_claims`(
    `id` int NOT NULL auto_increment,
    `media_type` varchar(64) NOT NULL default '',
    `media_id` int NOT NULL default 0,
    `sound_counter` int NOT NULL default 0,
    `video_counter` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `media_claims_log`(
    `id` int NOT NULL auto_increment,
    `media_type` varchar(64) NOT NULL default '',
    `media_id` int NOT NULL default 0,
    `type` varchar(128) NOT NULL default '',
    `uid` int NOT NULL default 0,
    `added` timestamp not null,
    PRIMARY KEY (`id`),
    INDEX(`added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `daily_media_claims`(
    `id` int NOT NULL auto_increment,
    `date` date NOT NULL default 0,
    `vclub_sound` int NOT NULL default 0,
    `vclub_video` int NOT NULL default 0,
    `itv_sound` int NOT NULL default 0,
    `itv_video` int NOT NULL default 0,
    `karaoke_sound` int NOT NULL default 0,
    `karaoke_video` int NOT NULL default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `epg_setting`(
    `id` int NOT NULL auto_increment,
    `uri` varchar(255) NOT NULL default '',
    `etag` varchar(255) NOT NULL default '',
    `updated` datetime,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `stb_groups`(
    `id` int NOT NULL auto_increment,
    `name` varchar(255) NOT NULL default '',
    PRIMARY KEY (`id`),
    UNIQUE KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `stb_in_group`(
    `id` int NOT NULL auto_increment,
    `stb_group_id` int NOT NULL default 0,
    `uid` int NOT NULL default 0,
    `mac` varchar(64) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `playlists`(
    `id` int NOT NULL auto_increment,
    `name` varchar(255) NOT NULL default '',
    `group_id` int NOT NULL default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `playlist_members`(
    `id` int NOT NULL auto_increment,
    `playlist_id` int NOT NULL default 0,
    `time` int NOT NULL default -1, /* minutes from day beginning */
    `video_id` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `testers`(
    `id` int NOT NULL auto_increment,
    `mac` varchar(64) NOT NULL default '',
    `status` tinyint default 1,
    UNIQUE KEY (`mac`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `generation_time`(
    `time` varchar(32),
    `counter` int unsigned NOT NULL default 0,
    KEY `time` (`time`)
) ENGINE=MEMORY;

INSERT INTO `generation_time` (`time`) values ('0ms'), ('100ms'), ('200ms'), ('300ms'), ('400ms'), ('500ms');

CREATE TABLE IF NOT EXISTS `weatherco_cache`(
    `id` int NOT NULL auto_increment,
    `city_id` int NOT NULL default 0,
    `current` text,
    `forecast` text,
    `updated` datetime,
    UNIQUE KEY (`city_id`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `tv_reminder`(
    `id` int NOT NULL auto_increment,
    `mac` varchar(64) NOT NULL default '',
    `ch_id` int NOT NULL default 0,
    `tv_program_id` int NOT NULL default 0,
    `fire_time` timestamp not null,
    `added` datetime,
    PRIMARY KEY (`id`),
    KEY `tv_program_id` (`tv_program_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `countries`(
    `id` int NOT NULL,
    `iso2` varchar(8) NOT NULL default '',
    `iso3` varchar(8) NOT NULL default '',
    `name` varchar(64) NOT NULL default '',
    `name_en` varchar(64) NOT NULL default '',
    `region` varchar(64) NOT NULL default '',
    `region_id` int NOT NULL default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cities`(
    `id` int NOT NULL,
    `name` varchar(64) NOT NULL default '',
    `name_en` varchar(64) NOT NULL default '',
    `region` varchar(64) NOT NULL default '',
    `country` varchar(64) NOT NULL default '',
    `country_id` int NOT NULL default 0,
    `timezone` varchar(64) NOT NULL default '',
    PRIMARY KEY (`id`),
    KEY `country_id` (`country_id`),
    KEY `timezone` (`timezone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 1
	                         AND delta_set = 'Main';
-- Fragment ends: 1 --
-- Fragment begins: 2 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (2, 'Main', NOW(), 'dbdeploy', '2-cities.sql');
--
SET NAMES UTF8;
INSERT INTO `countries` VALUES (166,'CC','CCK','Islands','Islands','Океания',5),(422,'LB','LBN','Lebanon','Lebanon','Азия',4),(438,'LI','LIE','Liechtenstein','Liechtenstein','Европа',3),(442,'LU','LUX','Luxembourg','Luxembourg','Европа',3),(484,'MX','MEX','Mexico','Mexico','Америка',2),(492,'MC','MCO','Monaco','Monaco','Европа',3),(634,'QA','QAT','Qatar','Qatar','Азия',4),(748,'SZ','SWZ','Swaziland','Swaziland','Африка',1),(158,'TW','TWN','Taiwan','Taiwan','Океания',5),(834,'TZ','TZA','United Rep. Of Tanzania','United Rep. Of Tanzania','Африка',1),(36,'AU','AUS','Австралия','Australia','Океания',5),(40,'AT','AUT','Австрия','Austria','Европа',3),(31,'AZ','AZE','Азербайджан','Azerbaijan','Азия',4),(8,'AL','ALB','Албания','Albania','Европа',3),(12,'DZ','DZA','Алжир','Algeria','Африка',1),(24,'AO','AGO','Ангола','Angola','Африка',1),(32,'AR','ARG','Аргентина','Argentina','Америка',2),(51,'AM','ARM','Армения','Armenia','Азия',4),(4,'AF','AFG','Афганистан','Afghanistan','Азия',4),(50,'BD','BGD','Бангладеш','Bangladesh','Азия',4),(52,'BB','BRB','Барбадос','Barbados','Америка',2),(112,'BY','BLR','Беларусь','Belarus','Европа',3),(84,'BZ','BLZ','Белиз','Belize','Америка',2),(56,'BE','BEL','Бельгия','Belgium','Европа',3),(204,'BJ','BEN','Бенин','Benin','Африка',1),(100,'BG','BGR','Болгария','Bulgaria','Европа',3),(68,'BO','BOL','Боливия','Bolivia','Америка',2),(70,'BA','BIH','Босния и Герцеговина','Bosnia And Herzegovina','Европа',3),(72,'BW','BWA','Ботсвана','Botswana','Африка',1),(76,'BR','BRA','Бразилия','Brazil','Америка',2),(93,'VG','VGB','Британские Виргинские о-ва','British Virgin Islands','Океания',5),(854,'BF','BFA','Буркина-Фасо','Burkina Faso','Африка',1),(108,'BI','BDI','Бурунди','Burundi','Африка',1),(826,'GB','GBR','Великобритания','United Kingdom','Европа',3),(348,'HU','HUN','Венгрия','Hungary','Европа',3),(704,'VN','VNM','Вьетнам','Vietnam','Азия',4),(266,'GA','GAB','Габон','Gabon','Африка',1),(324,'GN','GIN','Гвинея','Guinea','Африка',1),(276,'DE','DEU','Германия','Germany','Европа',3),(528,'NL','NLD','Голландия','Netherlands','Европа',3),(304,'GL','GRL','Гренландия','Greenland','Америка',2),(300,'GR','GRC','Греция','Greece','Европа',3),(268,'GE','GEO','Грузия','Georgia','Азия',4),(208,'DK','DNK','Дания','Denmark','Европа',3),(214,'DO','DOM','Доминикана','Dominican Republic','Америка',2),(818,'EG','EGY','Египет','Egypt','Африка',1),(894,'ZM','ZMB','Замбия','Zambia','Африка',1),(732,'EH','ESH','Западная Сахара','Western Sahara','Африка',1),(716,'ZW','ZWE','Зимбабве','Zimbabwe','Африка',1),(376,'IL','ISR','Израиль','Israel','Азия',4),(356,'IN','IND','Индия','India','Азия',4),(360,'ID','IDN','Индонезия','Indonesia','Азия',4),(400,'JO','JOR','Иордания','Jordan','Азия',4),(368,'IQ','IRQ','Ирак','Iraq','Азия',4),(364,'IR','IRN','Иран','Iran','Азия',4),(372,'IE','IRL','Ирландия','Ireland','Европа',3),(352,'IS','ISL','Исландия','Iceland','Европа',3),(724,'ES','ESP','Испания','Spain','Европа',3),(380,'IT','ITA','Италия','Italy','Европа',3),(887,'YE','YEM','Йемен','Yemen','Азия',4),(132,'CV','CPV','Кабо-Верде','Cape Verde','Африка',1),(398,'KZ','KAZ','Казахстан','Kazakhstan','Азия',4),(116,'KH','KHM','Камбоджа','Cambodia','Азия',4),(120,'CM','CMR','Камерун','Cameroon','Африка',1),(124,'CA','CAN','Канада','Canada','Америка',2),(404,'KE','KEN','Кения','Kenya','Африка',1),(196,'CY','CYP','Кипр','Cyprus','Азия',4),(156,'CN','CHN','Китай','China','Азия',4),(385,'CI','CIV','Кот-д\'Ивуар','Côte d\'Ivoire','Океания',5),(192,'CU','CUB','Куба','Cuba','Америка',2),(417,'KG','KGZ','Кыргызстан','Kyrgyzstan','Азия',4),(428,'LV','LVA','Латвия','Latvia','Европа',3),(426,'LS','LSO','Лесото','Lesotho','Африка',1),(440,'LT','LTU','Литва','Lithuania','Европа',3),(480,'MU','MUS','Маврикий','Mauritius','Африка',1),(478,'MR','MRT','Мавритания','Mauritania','Африка',1),(450,'MG','MDG','Мадагаскар','Madagascar','Африка',1),(454,'MW','MWI','Малави','Malawi','Африка',1),(458,'MY','MYS','Малайзия','Malaysia','Азия',4),(466,'ML','MLI','Мали','Mali','Африка',1),(462,'MV','MDV','Мальдивы','Maldives','Азия',4),(504,'MA','MAR','Марокко','Morocco','Африка',1),(508,'MZ','MOZ','Мозамбик','Mozambique','Африка',1),(498,'MD','MDA','Молдова','Moldova','Европа',3),(496,'MN','MNG','Монголия','Mongolia','Азия',4),(104,'MM','MMR','Мьянма','Myanmar','Азия',4),(516,'NA','NAM','Намибия','Namibia','Африка',1),(524,'NP','NPL','Непал','Nepal','Азия',4),(562,'NE','NER','Нигер','Niger','Африка',1),(566,'NG','NGA','Нигерия','Nigeria','Африка',1),(578,'NO','NOR','Норвегия','Norway','Европа',3),(784,'AE','ARE','ОАЭ','United Arab Emirates','Азия',4),(512,'OM','OMN','Оман','Oman','Азия',4),(586,'PK','PAK','Пакистан','Pakistan','Азия',4),(616,'PL','POL','Польша','Poland','Европа',3),(620,'PT','PRT','Португалия','Portugal','Европа',3),(643,'RU','RUS','Россия','Russia','Европа',3),(646,'RW','RWA','Руанда','Rwanda','Африка',1),(642,'RO','ROU','Румыния','Romania','Европа',3),(638,'RE','REU','Рэюньен','Reunion','Африка',1),(678,'ST','STP','Сан-Томе и Принсипи','Sao Tome And Principe','Африка',1),(682,'SA','SAU','Саудовская Аравия','Saudi Arabia','Азия',4),(686,'SN','SEN','Сенегал','Senegal','Африка',1),(688,'RS','SRB','Сербия','Serbia','Европа',3),(891,'CS','SCG','Сербия и Черногория','Serbia And Montenegro','Океания',5),(702,'SG','SGP','Сингапур','Singapore','Азия',4),(760,'SY','SYR','Сирийская Арабская Республика','Syrian Arab Republic','Азия',4),(703,'SK','SVK','Словакия','Slovakia','Европа',3),(705,'SI','SVN','Словения','Slovenia','Европа',3),(840,'US','USA','Соединенные Штаты Америки','United States Of America','Америка',2),(706,'SO','SOM','Сомали','Somalia','Африка',1),(736,'SD','SDN','Судан','Sudan','Африка',1),(694,'SL','SLE','Сьерра Леоне','Sierra Leone','Африка',1),(762,'TJ','TJK','Таджикистан','Tajikistan','Азия',4),(764,'TH','THA','Тайланд','Thailand','Азия',4),(768,'TG','TGO','Того','Togo','Африка',1),(788,'TN','TUN','Тунис','Tunisia','Африка',1),(795,'TM','TKM','Туркменистан','Turkmenistan','Азия',4),(792,'TR','TUR','Турция','Turkey','Азия',4),(800,'UG','UGA','Уганда','Uganda','Африка',1),(860,'UZ','UZB','Узбекистан','Uzbekistan','Азия',4),(804,'UA','UKR','Украина','Ukraine','Европа',3),(246,'FI','FIN','Финляндия','Finland','Европа',3),(250,'FR','FRA','Франция','France','Европа',3),(191,'HR','HRV','Хорватия','Croatia','Европа',3),(140,'CF','CAF','Центральная Африканская Республика','Central African Republic','Африка',1),(148,'TD','TCD','Чад','Chad','Африка',1),(499,'ME','MNE','Черногория','Montenegro','Европа',3),(203,'CZ','CZE','Чехия','Czech Republic','Европа',3),(756,'CH','CHE','Швейцария','Switzerland','Европа',3),(752,'SE','SWE','Швеция','Sweden','Европа',3),(144,'LK','LKA','Шри Ланка','Sri Lanka','Азия',4),(226,'GQ','GNQ','Экваториальная Гвинея','Equatorial Guinea','Африка',1),(233,'EE','EST','Эстония','Estonia','Европа',3),(231,'ET','ETH','Эфиопия','Ethiopia','Африка',1),(710,'ZA','ZAF','ЮАР','South Africa','Африка',1),(411,'KR','KOR','Южная Корея','South Korea','Океания',5),(388,'JM','JAM','Ямайка','Jamaica','Америка',2),(392,'JP','JPN','Япония','Japan','Азия',4);
INSERT INTO `cities` VALUES (53699,'Акюрейри','Akureyri','','Islands',166,'Atlantic/Reykjavik'),(7099,'Бейрут','Beyrouth','','Lebanon',422,'Asia/Beirut'),(7098,'Триполи','Tripoli','','Lebanon',422,'Asia/Beirut'),(7095,'Хоуч- Аль - Омара','Houche-Al-Oumara','','Lebanon',422,'Asia/Beirut'),(7105,'Вадуц','Vaduz','','Liechtenstein',438,'Europe/Vaduz'),(7130,'Люксембург','Luxembourg','','Luxembourg',442,'Europe/Luxembourg'),(17459,'Acajete','Acajete','','Mexico',484,'America/Mexico_City'),(17453,'Acatic','Acatic','','Mexico',484,'America/Mexico_City'),(17443,'Agua Dulce','Agua Dulce','','Mexico',484,'America/Mexico_City'),(17535,'Ajalpan','Ajalpan','','Mexico',484,'America/Mexico_City'),(17467,'Aldama','Aldama','','Mexico',484,'America/Mexico_City'),(17473,'Altepexi','Altepexi','','Mexico',484,'America/Mexico_City'),(17475,'Altotonga','Altotonga','','Mexico',484,'America/Mexico_City'),(17479,'Ameca','Ameca','','Mexico',484,'America/Mexico_City'),(17485,'Anahuac','Anahuac','','Mexico',484,'America/Matamoros'),(17487,'Angel R. Cabada','Angel R. Cabada','','Mexico',484,'America/Mexico_City'),(17507,'Apodaca','Apodaca','','Mexico',484,'America/Monterrey'),(17509,'Arandas','Arandas','','Mexico',484,'America/Mexico_City'),(17515,'Arcelia','Arcelia','','Mexico',484,'America/Mexico_City'),(17517,'Asuncion Nochixtlan','Asuncion Nochixtlan','','Mexico',484,'America/Mexico_City'),(17523,'Atlautla','Atlautla','','Mexico',484,'America/Mexico_City'),(17543,'Banderilla','Banderilla','','Mexico',484,'America/Mexico_City'),(17545,'Benito Juarez','Benito Juarez','','Mexico',484,'America/Cancun'),(17547,'Berriozabal','Berriozabal','','Mexico',484,'America/Mexico_City'),(17551,'Bochil','Bochil','','Mexico',484,'America/Mexico_City'),(17563,'Cacahoatan','Cacahoatan','','Mexico',484,'America/Mexico_City'),(17573,'Calpulalpan','Calpulalpan','','Mexico',484,'America/Mexico_City'),(17583,'Canatlan','Canatlan','','Mexico',484,'America/Monterrey'),(17587,'Capulhuac','Capulhuac','','Mexico',484,'America/Mexico_City'),(17591,'Casimiro Castillo','Casimiro Castillo','','Mexico',484,'America/Mexico_City'),(17667,'Cerritos','Cerritos','','Mexico',484,'America/Mexico_City'),(17669,'Cerro Azul','Cerro Azul','','Mexico',484,'America/Mexico_City'),(17727,'Chapala','Chapala','','Mexico',484,'America/Mexico_City'),(17735,'Charcas','Charcas','','Mexico',484,'America/Mexico_City'),(17731,'Chemax','Chemax','','Mexico',484,'America/Merida'),(17733,'Cheran','Cheran','','Mexico',484,'America/Mexico_City'),(17745,'Chiconcuac','Chiconcuac','','Mexico',484,'America/Mexico_City'),(17741,'Chignahuapan','Chignahuapan','','Mexico',484,'America/Mexico_City'),(17673,'Cihuatlan','Cihuatlan','','Mexico',484,'America/Mexico_City'),(17711,'Ciudad Fernandez','Ciudad Fernandez','','Mexico',484,'America/Mexico_City'),(17683,'Ciudad Guzman','Ciudad Guzman','','Mexico',484,'America/Mexico_City'),(17597,'Coacalco','Coacalco','','Mexico',484,'America/Mexico_City'),(17605,'Coatzintla','Coatzintla','','Mexico',484,'America/Mexico_City'),(17613,'Cocula','Cocula','','Mexico',484,'America/Mexico_City'),(17619,'Colotlan','Colotlan','','Mexico',484,'America/Mexico_City'),(17621,'Comalcalco','Comalcalco','','Mexico',484,'America/Mexico_City'),(17629,'Contla','Contla','','Mexico',484,'America/Mexico_City'),(17611,'Coquimatlan','Coquimatlan','','Mexico',484,'America/Mexico_City'),(17637,'Cosoleacaque','Cosoleacaque','','Mexico',484,'America/Mexico_City'),(17607,'Coyotepec','Coyotepec','','Mexico',484,'America/Mexico_City'),(17651,'Cuautlancingo','Cuautlancingo','','Mexico',484,'America/Mexico_City'),(17657,'Cuitlahuac','Cuitlahuac','','Mexico',484,'America/Mexico_City'),(17659,'Culiacan','Culiacan','','Mexico',484,'America/Mazatlan'),(17661,'Cunduacan','Cunduacan','','Mexico',484,'America/Mexico_City'),(17757,'Degollado','Degollado','','Mexico',484,'America/Mexico_City'),(17765,'Ecatepec','Ecatepec','','Mexico',484,'America/Mexico_City'),(17767,'El Grullo','El Grullo','','Mexico',484,'America/Mexico_City'),(17777,'El Mante','El Mante','','Mexico',484,'America/Monterrey'),(17801,'Etzatlan','Etzatlan','','Mexico',484,'America/Mexico_City'),(17831,'General Escobedo','General Escobedo','','Mexico',484,'America/Monterrey'),(17819,'Guadalupe','Guadalupe','','Mexico',484,'America/Mexico_City'),(17835,'Guanajuato','Guanajuato','','Mexico',484,'America/Mexico_City'),(17837,'Gustavo Diaz Ordaz','Gustavo Diaz Ordaz','','Mexico',484,'America/Mexico_City'),(17839,'Gutierrez Zamora','Gutierrez Zamora','','Mexico',484,'America/Mexico_City'),(17851,'Huauchinango','Huauchinango','','Mexico',484,'America/Mexico_City'),(17857,'Huejotzingo','Huejotzingo','','Mexico',484,'America/Mexico_City'),(17867,'Huimanguillo','Huimanguillo','','Mexico',484,'America/Mexico_City'),(17863,'Huixtla','Huixtla','','Mexico',484,'America/Mexico_City'),(17871,'Hunucma','Hunucma','','Mexico',484,'America/Merida'),(17885,'Ixtaczoquitlan','Ixtaczoquitlan','','Mexico',484,'America/Mexico_City'),(17905,'Jalacingo','Jalacingo','','Mexico',484,'America/Mexico_City'),(17903,'Jalapa Enriquez','Jalapa Enriquez','','Mexico',484,'America/Mexico_City'),(17907,'Jalatlaco','Jalatlaco','','Mexico',484,'America/Mexico_City'),(17909,'Jalostotitlan','Jalostotitlan','','Mexico',484,'America/Mexico_City'),(17911,'Jalpa','Jalpa','','Mexico',484,'America/Mexico_City'),(17915,'Jamay','Jamay','','Mexico',484,'America/Mexico_City'),(17929,'Jocotepec','Jocotepec','','Mexico',484,'America/Mexico_City'),(17935,'Juan Rodriguez Clara','Juan Rodriguez Clara','','Mexico',484,'America/Mexico_City'),(17943,'La Barca','La Barca','','Mexico',484,'America/Mexico_City'),(17949,'La Cruz','La Cruz','','Mexico',484,'America/Mazatlan'),(17973,'Las Choapas','Las Choapas','','Mexico',484,'America/Mexico_City'),(17983,'Libres','Libres','','Mexico',484,'America/Mexico_City'),(17985,'Linares','Linares','','Mexico',484,'America/Monterrey'),(18001,'Macuspana','Macuspana','','Mexico',484,'America/Mexico_City'),(18003,'Maltrata','Maltrata','','Mexico',484,'America/Mexico_City'),(18011,'Maravatio','Maravatio','','Mexico',484,'America/Mexico_City'),(18017,'Matamoros','Matamoros','','Mexico',484,'America/Matamoros'),(18021,'Matias Romero','Matias Romero','','Mexico',484,'America/Mexico_City'),(18037,'Miguel Auza','Miguel Auza','','Mexico',484,'America/Mexico_City'),(18047,'Misantla','Misantla','','Mexico',484,'America/Mexico_City'),(18039,'Mixquiahuala','Mixquiahuala','','Mexico',484,'America/Mexico_City'),(18051,'Monclova','Monclova','','Mexico',484,'America/Monterrey'),(18053,'Montemorelos','Montemorelos','','Mexico',484,'America/Monterrey'),(18065,'Muna','Muna','','Mexico',484,'America/Merida'),(18071,'Nanacamilpa','Nanacamilpa','','Mexico',484,'America/Mexico_City'),(18079,'Nealtican','Nealtican','','Mexico',484,'America/Mexico_City'),(18081,'Nextlalpan','Nextlalpan','','Mexico',484,'America/Mexico_City'),(18083,'Nicolas Romero','Nicolas Romero','','Mexico',484,'America/Mexico_City'),(18107,'Ocotlan','Ocotlan','','Mexico',484,'America/Mexico_City'),(18101,'Ocoyoacac','Ocoyoacac','','Mexico',484,'America/Mexico_City'),(18121,'Ojinaga','Ojinaga','','Mexico',484,'America/Ojinaga'),(18111,'Oluta','Oluta','','Mexico',484,'America/Mexico_City'),(18113,'Ometepec','Ometepec','','Mexico',484,'America/Mexico_City'),(18119,'Oteapan','Oteapan','','Mexico',484,'America/Mexico_City'),(18127,'Panotla','Panotla','','Mexico',484,'America/Mexico_City'),(18129,'Panuco','Panuco','','Mexico',484,'America/Mexico_City'),(18131,'Papalotla','Papalotla','','Mexico',484,'America/Mexico_City'),(18135,'Paraiso','Paraiso','','Mexico',484,'America/Mexico_City'),(18151,'Perote','Perote','','Mexico',484,'America/Mexico_City'),(18153,'Petatlan','Petatlan','','Mexico',484,'America/Mexico_City'),(18161,'Pichucalco','Pichucalco','','Mexico',484,'America/Mexico_City'),(18157,'Piedras Negras','Piedras Negras','','Mexico',484,'America/Matamoros'),(18163,'Platon Sanchez','Platon Sanchez','','Mexico',484,'America/Mexico_City'),(18167,'Poanas','Poanas','','Mexico',484,'America/Monterrey'),(18169,'Poncitlan','Poncitlan','','Mexico',484,'America/Mexico_City'),(18187,'Purepero','Purepero','','Mexico',484,'America/Mexico_City'),(18197,'Quiroga','Quiroga','','Mexico',484,'America/Mexico_City'),(18201,'Rafael Lara Grajales','Rafael Lara Grajales','','Mexico',484,'America/Mexico_City'),(18203,'Reynosa','Reynosa','','Mexico',484,'America/Matamoros'),(18209,'Rio Blanco','Rio Blanco','','Mexico',484,'America/Mexico_City'),(18211,'Rio Bravo','Rio Bravo','','Mexico',484,'America/Monterrey'),(18215,'Rio Grande','Rio Grande','','Mexico',484,'America/Mexico_City'),(18213,'Rio Verde','Rio Verde','','Mexico',484,'America/Mexico_City'),(18223,'Ruiz','Ruiz','','Mexico',484,'America/Mazatlan'),(18225,'Sabinas','Sabinas','','Mexico',484,'America/Monterrey'),(18253,'San Buenaventura','San Buenaventura','','Mexico',484,'America/Monterrey'),(18259,'San Carlos','San Carlos','','Mexico',484,'America/Hermosillo'),(18291,'San Fernando','San Fernando','','Mexico',484,'America/Monterrey'),(18257,'San Gabriel Chilac','San Gabriel Chilac','','Mexico',484,'America/Mexico_City'),(18297,'San Julian','San Julian','','Mexico',484,'America/Mexico_City'),(18267,'San Lucas','San Lucas','','Mexico',484,'America/Mexico_City'),(18273,'San Matias Tlalancaleca','San Matias Tlalancaleca','','Mexico',484,'America/Mexico_City'),(18329,'San Miguel Xoxtla','San Miguel Xoxtla','','Mexico',484,'America/Mexico_City'),(18371,'Santa Ana','Santa Ana','','Mexico',484,'America/Hermosillo'),(18379,'Santa Barbara','Santa Barbara','','Mexico',484,'America/Chihuahua'),(18383,'Santa Catarina','Santa Catarina','','Mexico',484,'America/Monterrey'),(18405,'Santiago','Santiago','','Mexico',484,'America/Monterrey'),(18407,'Santiago Ixcuintla','Santiago Ixcuintla','','Mexico',484,'America/Mazatlan'),(18409,'Santiago Miahuatlan','Santiago Miahuatlan','','Mexico',484,'America/Mexico_City'),(18421,'Santiago Tulantepec','Santiago Tulantepec','','Mexico',484,'America/Mexico_City'),(18419,'Santiago Tuxtla','Santiago Tuxtla','','Mexico',484,'America/Mexico_City'),(18427,'Saucillo','Saucillo','','Mexico',484,'America/Chihuahua'),(18229,'Sayula','Sayula','','Mexico',484,'America/Mexico_City'),(18445,'Tala','Tala','','Mexico',484,'America/Mexico_City'),(18449,'Tamazunchale','Tamazunchale','','Mexico',484,'America/Mexico_City'),(18457,'Tantoyuca','Tantoyuca','','Mexico',484,'America/Mexico_City'),(18459,'Tapachula','Tapachula','','Mexico',484,'America/Mexico_City'),(18467,'Tecalitlan','Tecalitlan','','Mexico',484,'America/Mexico_City'),(18471,'Tecate','Tecate','','Mexico',484,'America/Tijuana'),(18481,'Tecoman','Tecoman','','Mexico',484,'America/Mexico_City'),(18489,'Teloloapan','Teloloapan','','Mexico',484,'America/Mexico_City'),(18491,'Temascalcingo','Temascalcingo','','Mexico',484,'America/Mexico_City'),(18499,'Tenancingo','Tenancingo','','Mexico',484,'America/Mexico_City'),(18505,'Teocaltiche','Teocaltiche','','Mexico',484,'America/Mexico_City'),(18509,'Teopisca','Teopisca','','Mexico',484,'America/Mexico_City'),(18513,'Tepalcingo','Tepalcingo','','Mexico',484,'America/Mexico_City'),(18521,'Tepeaca','Tepeaca','','Mexico',484,'America/Mexico_City'),(18523,'Tepeapulco','Tepeapulco','','Mexico',484,'America/Mexico_City'),(18479,'Tequisquiapan','Tequisquiapan','','Mexico',484,'America/Mexico_City'),(18537,'Tezoyuca','Tezoyuca','','Mexico',484,'America/Mexico_City'),(18545,'Tianguistenco','Tianguistenco','','Mexico',484,'America/Mexico_City'),(18561,'Tihuatlan','Tihuatlan','','Mexico',484,'America/Mexico_City'),(18555,'Tizayuca','Tizayuca','','Mexico',484,'America/Mexico_City'),(18589,'Tlapacoyan','Tlapacoyan','','Mexico',484,'America/Mexico_City'),(18565,'Tlaquepaque','Tlaquepaque','','Mexico',484,'America/Mexico_City'),(18575,'Tlaxcoapan','Tlaxcoapan','','Mexico',484,'America/Mexico_City'),(18595,'Tonala','Tonala','','Mexico',484,'America/Mexico_City'),(18599,'Tototlan','Tototlan','','Mexico',484,'America/Mexico_City'),(18617,'Union Hidalgo','Union Hidalgo','','Mexico',484,'America/Mexico_City'),(18627,'Valle Hermoso','Valle Hermoso','','Mexico',484,'America/Monterrey'),(18629,'Valparaiso','Valparaiso','','Mexico',484,'America/Mexico_City'),(18635,'Venustiano Carranza','Venustiano Carranza','','Mexico',484,'America/Mexico_City'),(18637,'Veracruz','Veracruz','','Mexico',484,'America/Mexico_City'),(18647,'Villa Juarez','Villa Juarez','','Mexico',484,'America/Mexico_City'),(18651,'Villa Union','Villa Union','','Mexico',484,'America/Mazatlan'),(18653,'Villagran','Villagran','','Mexico',484,'America/Mexico_City'),(18657,'Villanueva','Villanueva','','Mexico',484,'America/Mexico_City'),(18671,'Xonacatlan','Xonacatlan','','Mexico',484,'America/Mexico_City'),(18669,'Xoxocotla','Xoxocotla','','Mexico',484,'America/Mexico_City'),(18681,'Yahualica','Yahualica','','Mexico',484,'America/Mexico_City'),(18685,'Yajalon','Yajalon','','Mexico',484,'America/Mexico_City'),(18675,'Yurecuaro','Yurecuaro','','Mexico',484,'America/Mexico_City'),(18691,'Zacatelco','Zacatelco','','Mexico',484,'America/Mexico_City'),(18699,'Zacualtipan','Zacualtipan','','Mexico',484,'America/Mexico_City'),(18703,'Zapopan','Zapopan','','Mexico',484,'America/Mexico_City'),(18705,'Zapotiltic','Zapotiltic','','Mexico',484,'America/Mexico_City'),(18707,'Zapotlanejo','Zapotlanejo','','Mexico',484,'America/Mexico_City'),(18709,'Zaragoza','Zaragoza','','Mexico',484,'America/Ojinaga'),(18711,'Zimapan','Zimapan','','Mexico',484,'America/Mexico_City'),(18715,'Zinapecuaro','Zinapecuaro','','Mexico',484,'America/Mexico_City'),(17441,'Агуаскальентес','Aguascalientes','','Mexico',484,'America/Mexico_City'),(17491,'Аоме','Ahome','','Mexico',484,'America/Mazatlan'),(18655,'Вильяэрмоса','Villahermosa','','Mexico',484,'America/Mexico_City'),(17815,'Гвадалахара','Guadalajara','','Mexico',484,'America/Mexico_City'),(17689,'Идальго','Villa Hidalgo','','Mexico',484,'America/Monterrey'),(17895,'Ирапуато','Irapuato','','Mexico',484,'America/Mexico_City'),(17575,'Камарго','Camargo','','Mexico',484,'America/Chihuahua'),(17691,'Камарго','Ciudad Camargo','','Mexico',484,'America/Chihuahua'),(17577,'Кампече','Campeche','','Mexico',484,'America/Merida'),(17585,'Канкун','Cancun','','Mexico',484,'America/Cancun'),(18195,'Керетаро','Queretaro','','Mexico',484,'America/Mexico_City'),(17603,'Коацакоалькос','Coatzacoalcos','','Mexico',484,'America/Mexico_City'),(17615,'Колима','Colima','','Mexico',484,'America/Mexico_City'),(17663,'Куэрнавака','Cuernavaca','','Mexico',484,'America/Mexico_City'),(17961,'Ла-Пас','La Paz','','Mexico',484,'America/Monterrey'),(17977,'Леон','Leon','','Mexico',484,'America/Mexico_City'),(17989,'Лос-Мочис','Los Mochis','','Mexico',484,'America/Mazatlan'),(17997,'Мадера','Madera','','Mexico',484,'America/Chihuahua'),(18007,'Мансанильо','Manzanillo','','Mexico',484,'America/Mexico_City'),(18015,'Масатлан','Mazatlan','','Mexico',484,'America/Mazatlan'),(18027,'Мерида','Merida','','Mexico',484,'America/Merida'),(18031,'Мехикали','Mexicali','','Mexico',484,'America/Tijuana'),(18033,'Мехико','Mexico','','Mexico',484,'America/New_York'),(18055,'Монтеррей','Monterrey','','Mexico',484,'America/Monterrey'),(18057,'Морелия','Morelia','','Mexico',484,'America/Mexico_City'),(17877,'Ногалес','Nogales','','Mexico',484,'America/Hermosillo'),(18091,'Нуэво-Ларедо','Nuevo Laredo','','Mexico',484,'America/Matamoros'),(18115,'Орисаба','Orizaba','','Mexico',484,'America/Mexico_City'),(18155,'Пето','Peto','','Mexico',484,'America/Merida'),(18181,'Пуэрто-Вальярта','Puerto Vallarta','','Mexico',484,'America/Mexico_City'),(18233,'Саламанка','Salamanca','','Mexico',484,'America/Mexico_City'),(18241,'Сальтильо','Saltillo','','Mexico',484,'America/Monterrey'),(18307,'Сан-Луис-Потоси','San Luis Potosi','','Mexico',484,'America/Mexico_City'),(18263,'Сан-Луис-Рио-Колорадо','San Luis Rio Colorado','','Mexico',484,'America/Hermosillo'),(18271,'Сан-Маркос','San Marcos','','Mexico',484,'America/Guatemala'),(17665,'Селая','Celaya','','Mexico',484,'America/Mexico_City'),(18429,'Силао','Silao','','Mexico',484,'America/Mexico_City'),(17721,'Сьюдад-Виктория','Ciudad Victoria','','Mexico',484,'America/Monterrey'),(17705,'Сьюдад-Обрегон','Ciudad Obregon','','Mexico',484,'America/Hermosillo'),(17713,'Сьюдад-Хуарес','Juarez','','Mexico',484,'America/Ojinaga'),(18451,'Тампико','Tampico','','Mexico',484,'America/Monterrey'),(18527,'Тепик','Tepic','','Mexico',484,'America/Mazatlan'),(18563,'Тихуана','Tijuana','','Mexico',484,'America/Tijuana'),(18597,'Торреон','Torreon','','Mexico',484,'America/Monterrey'),(18607,'Тула','Tula de Allende','','Mexico',484,'America/Mexico_City'),(18615,'Тустла-Гутьеррес','Tuxtla Gutierrez','','Mexico',484,'America/Mexico_City'),(18663,'Хико','Xico','','Mexico',484,'America/Mexico_City'),(17737,'Четумаль','Chetumal','','Mexico',484,'America/Cancun'),(17751,'Чиуауа','Chihuahua','','Mexico',484,'America/Chihuahua'),(17793,'Энсенада','Ensenada','','Mexico',484,'America/Tijuana'),(17873,'Эрмосильо','Hermosillo','','Mexico',484,'America/Hermosillo'),(96066,'Монте-Карло','Monte-Carlo','','Monaco',492,'Europe/Monaco'),(7815,'Доха','Doha','','Qatar',634,'Asia/Qatar'),(8341,'Манзини','Manzini','','Swaziland',748,'Africa/Mbabane'),(8572,'Илан','Ilan','','Taiwan',158,'Asia/Taipei'),(8556,'Синьчжу','Hsinchu','','Taiwan',158,'Asia/Taipei'),(115180,'Тайбэй','Taipei','','Taiwan',158,'Asia/Taipei'),(8570,'Хуалянь','Hua-Lien City','','Taiwan',158,''),(115157,'Хуалянь','Hua-lien','','Taiwan',158,'Asia/Taipei'),(8569,'Хэньчунь','Hengchun','','Taiwan',158,'Asia/Taipei'),(9000,'Аруша','Arusha','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9001,'Букоба','Bukoba','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9003,'Додома','Dodoma','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9021,'Занзибар','Zanzibar / Kisauni','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9004,'Иринга','Iringa','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9005,'Кигома','Kigoma','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9008,'Мбея','Mbeya','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9014,'Мванза','Mwanza','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9010,'Морогоро','Morogoro','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9011,'Моши','Moshi','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9012,'Мтвара','Mtwara','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9013,'Мусома','Musoma','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9016,'Пемба','Pemba / Karume Airport','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9019,'Табора','Tabora Airport','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(9020,'Танга','Tanga','','United Rep. Of Tanzania',834,'Africa/Dar_es_Salaam'),(17181,'Аделаида','Adelaide','','Australia',36,'Australia/Adelaide'),(17251,'Дарвин','Darwin','','Australia',36,'Australia/Darwin'),(17233,'Канберра','Canberra','','Australia',36,'Australia/Sydney'),(17243,'Кэрнс','Cairns','','Australia',36,'Australia/Brisbane'),(17329,'Мельбурн','Melbourne','','Australia',36,'Australia/Melbourne'),(17351,'Ньюкасл','Newcastle','','Australia',36,'Australia/Sydney'),(17357,'Перт','Perth','','Australia',36,'Australia/Perth'),(17391,'Сидней','Sydney','','Australia',36,'Australia/Sydney'),(17399,'Тари','Taree','','Australia',36,'Australia/Sydney'),(17285,'Хобарт','Hobart','','Australia',36,'Australia/Hobart'),(3733,'Айген (Энсталь)','Aigen Im Ennstal','','Austria',40,'Europe/Vienna'),(3752,'Айзенштадт','Eisenstadt','','Austria',40,'Europe/Vienna'),(3736,'Амштеттен','Amstetten','','Austria',40,'Europe/Vienna'),(3742,'Бад Ишль','Bad Ischl','','Austria',40,'Europe/Vienna'),(3740,'Бад-Гаштайн','Badgastein','','Austria',40,'Europe/Vienna'),(3741,'Бад-Глайхенберг','Bad Gleichenberg','','Austria',40,'Europe/Vienna'),(3743,'Бад-Миттерндорф','Bad Mitterndorf','','Austria',40,'Europe/Vienna'),(3744,'Бад-Радкерсбург','Bad Radkersburg','','Austria',40,'Europe/Vienna'),(13893,'Баден','Baden','','Austria',40,'Europe/Vienna'),(13895,'Бергхайм','Bergheim','','Austria',40,'Europe/Vienna'),(3745,'Бишофсхофен','Bischofshofen','','Austria',40,'Europe/Vienna'),(13901,'Блуденц','Bludenz','','Austria',40,'Europe/Vienna'),(3746,'Брегенц','Bregenz','','Austria',40,'Europe/Vienna'),(3747,'Бреннер','Brenner','','Austria',40,'Europe/Vienna'),(3748,'Брук-на-Муре','Bruck an der Mur','','Austria',40,'Europe/Vienna'),(86925,'Вайдхофен-на-Ибсе','Waidhofen an der Ybbs','','Austria',40,'Europe/Vienna'),(3854,'Варт','Warth','','Austria',40,'Europe/Vienna'),(3857,'Вельс','Wels','','Austria',40,'Europe/Vienna'),(3858,'Вена','Vienna','','Austria',40,'Europe/Vienna'),(3877,'Вена','Wien / City','','Austria',40,'Europe/Vienna'),(3860,'Виндишгарстен','Windischgarsten','','Austria',40,'Europe/Vienna'),(3859,'Винер-Нойштадт','Wiener Neustadt','','Austria',40,'Europe/Vienna'),(86928,'Вольфсберг','Wolfsberg','','Austria',40,'Europe/Vienna'),(86900,'Гмунден','Gmunden','','Austria',40,'Europe/Vienna'),(3761,'Гмюнд','Gmund','','Austria',40,'Europe/Vienna'),(3762,'Грац','Graz','','Austria',40,'Europe/Vienna'),(3750,'Дорнбирн','Dornbirn','','Austria',40,'Europe/Vienna'),(3834,'Зальцбург','Salzburg','','Austria',40,'Europe/Vienna'),(14089,'Зёльден','S?lden','','Austria',40,''),(3771,'Инсбрук','Innsbruck','','Austria',40,'Europe/Vienna'),(3773,'Ишгль','Ischgl','','Austria',40,'Europe/Vienna'),(13436,'Капрун','Kaprun','','Austria',40,'Europe/Vienna'),(14011,'Капфенберг','Kapfenberg','','Austria',40,'Europe/Vienna'),(13437,'Кицбюэль','Kitzbuhel','','Austria',40,'Europe/Vienna'),(13438,'Клагенфурт','Klagenfurt','','Austria',40,'Europe/Vienna'),(14023,'Клостернойбург','Klosterneuburg','','Austria',40,'Europe/Vienna'),(14025,'Книттельфельд','Knittelfeld','','Austria',40,'Europe/Vienna'),(14027,'Корнойбург','Korneuburg','','Austria',40,'Europe/Vienna'),(3779,'Кремс-на-Дунае','Krems an der Donau','','Austria',40,'Europe/Vienna'),(3782,'Куфштайн','Kufstein','','Austria',40,'Europe/Vienna'),(3783,'Ландек','Landeck','','Austria',40,'Europe/Vienna'),(14047,'Леобен','Leoben','','Austria',40,'Europe/Vienna'),(14049,'Леондинг','Leonding','','Austria',40,'Europe/Vienna'),(86905,'Лех','Lech','','Austria',40,'Europe/Vienna'),(3786,'Лиенц','Lienz','','Austria',40,'Europe/Vienna'),(3788,'Линц','Linz','','Austria',40,'Europe/Vienna'),(3797,'Майрхофен','Mayrhofen','','Austria',40,'Europe/Vienna'),(3792,'Мальниц','Mallnitz','','Austria',40,'Europe/Vienna'),(3794,'Мариацелль','Mariazell','','Austria',40,'Europe/Vienna'),(3796,'Маутерндорф','Mauterndorf','','Austria',40,'Europe/Vienna'),(14067,'Мёдлинг','Modling','','Austria',40,'Europe/Vienna'),(3800,'Мурау','Murau','','Austria',40,'Europe/Vienna'),(3802,'Нойзидль-ам-Зее','Neusiedl am See','','Austria',40,'Europe/Vienna'),(14543,'Нойнкирхен','Neunkirchen','','Austria',40,'Europe/Vienna'),(3811,'Пучберг','Puchberg','','Austria',40,'Europe/Vienna'),(3820,'Райхенау','Reichenau','','Austria',40,'Europe/Vienna'),(3818,'Раурис','Rauris','','Austria',40,'Europe/Vienna'),(3822,'Рец','Retz','','Austria',40,'Europe/Vienna'),(3824,'Рид','Ried im Innkreis','','Austria',40,'Europe/Vienna'),(3823,'Ройтте','Reutte','','Austria',40,'Europe/Vienna'),(3825,'Рорбах','Rohrbach','','Austria',40,'Europe/Vienna'),(14573,'Рум','Rum','','Austria',40,'Europe/Vienna'),(3827,'Санкт-Антон','Saint Anton','','Austria',40,'Europe/Vienna'),(3833,'Санкт-Вольфганг','Saint Wolfgang','','Austria',40,'Europe/Vienna'),(3831,'Санкт-Пёльтен','Saint Poelten','','Austria',40,'Europe/Vienna'),(14151,'Траун','Traun','','Austria',40,'Europe/Vienna'),(3848,'Тульн-на-Дунае','Tulln','','Austria',40,'Europe/Vienna'),(14159,'Фёклабрук','Vocklabruck','','Austria',40,'Europe/Vienna'),(3755,'Фельдкирх','Feldkirch','','Austria',40,'Europe/Vienna'),(14163,'Фёлькермаркт','Volkermarkt','','Austria',40,'Europe/Vienna'),(3850,'Филлах','Villach','','Austria',40,'Europe/Vienna'),(3757,'Фрайштадт','Freistadt','','Austria',40,'Europe/Vienna'),(13951,'Фюрстенфельд','Furstenfeld','','Austria',40,'Europe/Vienna'),(13977,'Халлайн','Hallein','','Austria',40,'Europe/Vienna'),(13985,'Хард','Hard','','Austria',40,'Europe/Vienna'),(13999,'Хорн','Horn','','Austria',40,'Europe/Vienna'),(3769,'Хоэнемс','Hohenems','','Austria',40,'Europe/Vienna'),(3864,'Цветль','Zwettl','','Austria',40,'Europe/Vienna'),(3862,'Целль-ам-Зее','Zell am See','','Austria',40,'Europe/Vienna'),(3863,'Цельтвег','Zeltweg','','Austria',40,'Europe/Vienna'),(86930,'Цюрс','Zurs','','Austria',40,'Europe/Vienna'),(3839,'Швац','Schwaz','','Austria',40,'Europe/Vienna'),(13439,'Шладминг','Schladming','','Austria',40,'Europe/Vienna'),(86917,'Шпитталь','Spittal an der Drau','','Austria',40,'Europe/Vienna'),(3844,'Шпитталь-ан-дер-Драу','Spittal / Drau-Kleinsass','','Austria',40,'Europe/Vienna'),(14127,'Штайр','Steyr','','Austria',40,'Europe/Vienna'),(14131,'Штоккерау','Stockerau','','Austria',40,'Europe/Vienna'),(13929,'Энс','Enns','','Austria',40,'Europe/Vienna'),(3670,'Shubany','Shubany','','Azerbaijan',31,'Asia/Baku'),(3664,'Агдам','Agdam','','Azerbaijan',31,'Asia/Baku'),(3666,'Алат','Alat','','Azerbaijan',31,'Asia/Ashgabat'),(3669,'Астара','Astara','','Azerbaijan',31,'Asia/Tehran'),(3671,'Баку','Baku','','Azerbaijan',31,'Asia/Baku'),(3672,'Барда','Barda','','Azerbaijan',31,'Asia/Baku'),(3674,'Билясувар','Bilasuvar','','Azerbaijan',31,''),(3706,'Гобустан','Maraza','','Azerbaijan',31,'Asia/Baku'),(3684,'Гянджа','Gyanja','','Azerbaijan',31,''),(3678,'Евлах','Evlakh Airport','','Azerbaijan',31,'Asia/Baku'),(3728,'Закаталы','Zakatala','','Azerbaijan',31,'Asia/Baku'),(3687,'Имишли','Imishly','','Azerbaijan',31,''),(3688,'Исмаиллы','Ismailly','','Azerbaijan',31,'Asia/Baku'),(3693,'Кабала','Kabala','','Azerbaijan',31,'Asia/Baku'),(3701,'Куба','Kuba','','Azerbaijan',31,'Asia/Baku'),(3703,'Лачин','Lachin','','Azerbaijan',31,'Asia/Yerevan'),(3704,'Ленкорань','Lankaran','','Azerbaijan',31,'Asia/Ashgabat'),(3705,'Лерик','Lerik','','Azerbaijan',31,'Asia/Tehran'),(3708,'Мингечаур','Mingachevir','','Azerbaijan',31,'Asia/Baku'),(3711,'Нахичеванская Автономная Республика','Nakhchivan','','Azerbaijan',31,'Asia/Baku'),(3715,'Ордубад','Ordubad','','Azerbaijan',31,'Asia/Baku'),(3725,'Сумгаит','Sumgait','','Azerbaijan',31,'Asia/Baku'),(3726,'Тертер','Tartar','','Azerbaijan',31,'Asia/Baku'),(3697,'Ханкенди','Khankandy','','Azerbaijan',31,''),(3699,'Ходжалы','Khojaly Airport','','Azerbaijan',31,''),(3720,'Шеки','Shaki','','Azerbaijan',31,'Asia/Baku'),(3721,'Шемаха','Shamakhy','','Azerbaijan',31,'Asia/Baku'),(3724,'Шуша','Shusha','','Azerbaijan',31,'Asia/Yerevan'),(2699,'Бухара','Buhara','','Albania',8,'Asia/Karachi'),(2710,'Каракуль','Karakul','','Albania',8,'Asia/Samarkand'),(2711,'Карши','Karshi','','Albania',8,'Asia/Samarkand'),(2718,'Навои','Navoi','','Albania',8,'Asia/Samarkand'),(2717,'Наманган','Namangan','','Albania',8,'Asia/Tashkent'),(2719,'Нукус','Nukus','','Albania',8,'Asia/Samarkand'),(2723,'Самарканд','Samarkand','','Albania',8,'Asia/Samarkand'),(2727,'Ташкент','Tashkent','','Albania',8,'Asia/Tashkent'),(2728,'Термез','Termez','','Albania',8,'Asia/Samarkand'),(2729,'Ургенч','Urgench','','Albania',8,'Asia/Samarkand'),(2705,'Фергана','Fergana','','Albania',8,'Asia/Tashkent'),(2733,'Алжир','Alger','','Algeria',12,'Africa/Algiers'),(109122,'Алжир','Algiers','','Algeria',12,'Africa/Algiers'),(2734,'Аннаба','Annaba','','Algeria',12,'Africa/Algiers'),(2738,'Батна','Batna','','Algeria',12,'Africa/Algiers'),(2740,'Беджаия','Bejaia','','Algeria',12,'Africa/Algiers'),(2739,'Бешар','Bechar','','Algeria',12,'Africa/Algiers'),(2743,'Бискра','Biskra','','Algeria',12,'Africa/Algiers'),(2744,'Борж Боу Арреридж','Bordj Bou Arreridj','','Algeria',12,'Africa/Algiers'),(2759,'Делис','Dellys','','Algeria',12,'Africa/Algiers'),(2758,'Касабланка','Dar-El-Beida','','Algeria',12,'Africa/Algiers'),(2757,'Константин','Constantine','','Algeria',12,'Africa/Algiers'),(2791,'Оран','Oran / Es Senia','','Algeria',12,'Africa/Algiers'),(109127,'Оран','Oran','','Algeria',12,'Africa/Algiers'),(2798,'Сетиф','Setif','','Algeria',12,'Africa/Algiers'),(2801,'Скикда','Skikda','','Algeria',12,'Africa/Algiers'),(2804,'Тебесса','Tebessa','','Algeria',12,'Africa/Algiers'),(2806,'Тиарет','Tiaret','','Algeria',12,'Africa/Algiers'),(2821,'Луанда','Luanda','','Angola',24,'Africa/Luanda'),(2822,'Лубанго','Lubango','','Angola',24,'Africa/Luanda'),(2824,'Маланж','Malange','','Angola',24,'Africa/Luanda'),(111486,'Аллен','Allen','','Argentina',32,'America/Argentina/Salta'),(111469,'Альберти','Alberti','','Argentina',32,'America/Argentina/Buenos_Aires'),(111471,'Альсира','Alcira','','Argentina',32,'America/Argentina/Cordoba'),(111517,'Андерсон','Anderson','','Argentina',32,'America/Argentina/Buenos_Aires'),(111535,'Ария','Arias','','Argentina',32,'America/Argentina/Cordoba'),(111531,'Аркадия','Arcadia','','Argentina',32,'America/Argentina/Tucuman'),(111554,'Астра','Astra','','Argentina',32,'America/Argentina/Salta'),(111561,'Аякучо','Ayacucho','','Argentina',32,'America/Argentina/Buenos_Aires'),(111587,'Барроу','Barrow','','Argentina',32,'America/Argentina/Buenos_Aires'),(111635,'Буэнос-Айрес','Buenos Aires','','Argentina',32,'America/Argentina/Buenos_Aires'),(113291,'Вашингтон','Washington','','Argentina',32,'America/Argentina/Cordoba'),(113159,'Виктория','Victoria','','Argentina',32,'America/Argentina/Cordoba'),(113234,'Вильянуэва','Villanueva','','Argentina',32,'America/Argentina/Buenos_Aires'),(112014,'Гранерос','Graneros','','Argentina',32,'America/Argentina/Tucuman'),(111705,'Игуасу','Cataratas del Iguazu','','Argentina',32,'America/Argentina/Cordoba'),(112055,'Игуасу','Iguazu','','Argentina',32,'America/Sao_Paulo'),(111660,'Кампу-Гранди','Campo Grande','','Argentina',32,'America/Argentina/Cordoba'),(111670,'Канал','Canals','','Argentina',32,'America/Argentina/Cordoba'),(111780,'Консепсьон','Concepcion','','Argentina',32,'America/Argentina/Catamarca'),(111793,'Кордова','Cordoba','','Argentina',32,'America/Argentina/Cordoba'),(111809,'Корпус','Corpus','','Argentina',32,'America/Argentina/Cordoba'),(112132,'Ла-Пас','La Paz','','Argentina',32,'America/Argentina/Cordoba'),(112133,'Ла-Плата','La Plata','','Argentina',32,'America/Argentina/Buenos_Aires'),(112772,'Ла-Плата','River Plate Estuary','','Argentina',32,''),(112138,'Ла-Риоха','La Rioja','','Argentina',32,'America/Argentina/La_Rioja'),(112190,'Леон','Leon','','Argentina',32,'America/Argentina/Jujuy'),(112195,'Лима','Lima','','Argentina',32,'America/Argentina/Buenos_Aires'),(112196,'Линкольн','Lincoln','','Argentina',32,'America/Argentina/Buenos_Aires'),(112207,'Лос-Анджелес','Los Angeles','','Argentina',32,'America/Argentina/Catamarca'),(112304,'Мар-дель-Плата','Mar del Plata','','Argentina',32,'America/Argentina/Buenos_Aires'),(112330,'Мендоса','Mendoza','','Argentina',32,'America/Argentina/Mendoza'),(112331,'Мерседес','Mercedes','','Argentina',32,'America/Argentina/San_Luis'),(112339,'Миранда','Miranda','','Argentina',32,'America/Argentina/La_Rioja'),(112353,'Монте-Карло','Montecarlo','','Argentina',32,'America/Argentina/Cordoba'),(112356,'Морено','Moreno','','Argentina',32,'America/Argentina/Buenos_Aires'),(112358,'Моррисон','Morrison','','Argentina',32,'America/Argentina/Cordoba'),(112437,'Нельсон','Nelson','','Argentina',32,'America/Argentina/Cordoba'),(112438,'Неукен','Neuquen','','Argentina',32,'America/Argentina/Salta'),(112494,'Олива','Oliva','','Argentina',32,'America/Argentina/Cordoba'),(112508,'Оран','Oran','','Argentina',32,'America/Argentina/Salta'),(112512,'Оренсе','Orense','','Argentina',32,'America/Argentina/Buenos_Aires'),(112584,'Парана','Parana','','Argentina',32,'America/Argentina/Cordoba'),(112763,'Рио-Гранде','Rio Grande','','Argentina',32,'America/Argentina/Ushuaia'),(112778,'Росарио','Rosario','','Argentina',32,'America/Argentina/Cordoba'),(112844,'Сальта','Salta','','Argentina',32,'America/Argentina/Salta'),(112845,'Сальто','Salto','','Argentina',32,'America/Argentina/Buenos_Aires'),(112864,'Сан-Кристобаль','San Cristobal','','Argentina',32,'America/Argentina/Cordoba'),(112884,'Сан-Луис','San Luis','','Argentina',32,'America/Argentina/San_Luis'),(112894,'Сан-Педро','San Pedro','','Argentina',32,'America/Argentina/Cordoba'),(112898,'Сан-Роке','San Roque','','Argentina',32,'America/Argentina/Cordoba'),(112899,'Сан-Сальвадор','San Salvador','','Argentina',32,'America/Argentina/Cordoba'),(112869,'Сан-Франциско','San Francisco','','Argentina',32,'America/Argentina/Cordoba'),(112877,'Сан-Хосе','San Jose','','Argentina',32,'America/Argentina/Cordoba'),(112880,'Сан-Хуан','San Juan','','Argentina',32,'America/Argentina/San_Juan'),(112921,'Санта-Роза','Santa Rosa','','Argentina',32,'America/Argentina/Salta'),(112908,'Санта-Фе','Santa Fe','','Argentina',32,'America/Argentina/Cordoba'),(112934,'Санто-Доминго','Santo Domingo','','Argentina',32,'America/Argentina/Cordoba'),(113023,'Тама','Tama','','Argentina',32,'America/Argentina/La_Rioja'),(113041,'Толедо','Toledo','','Argentina',32,'America/Argentina/Cordoba'),(112891,'Тукуман','San Miguel de Tucuman','','Argentina',32,'America/Argentina/Tucuman'),(113058,'Тукуман','Tucuman','','Argentina',32,'America/Argentina/Tucuman'),(111929,'Флорида','Florida','','Argentina',32,'America/Argentina/Buenos_Aires'),(111930,'Фонтана','Fontana','','Argentina',32,'America/Argentina/Cordoba'),(111936,'Фортуна','Fortuna','','Argentina',32,'America/Argentina/Cordoba'),(111941,'Франклин','Franklin','','Argentina',32,'America/Argentina/Buenos_Aires'),(112028,'Хендерсон','Henderson','','Argentina',32,'America/Argentina/Buenos_Aires'),(112029,'Херефорд','Hereford','','Argentina',32,'America/Argentina/Buenos_Aires'),(111885,'Эльдорадо','Eldorado','','Argentina',32,'America/Argentina/Cordoba'),(111902,'Энсенада','Ensenada','','Argentina',32,'America/Argentina/Buenos_Aires'),(52993,'Абовян','Abovyan','','Armenia',51,'Asia/Yerevan'),(3885,'Армавир','Armavir','','Armenia',51,'Asia/Yerevan'),(3886,'Арташат','Artashat','','Armenia',51,'Asia/Yerevan'),(3888,'Берд','Berd','','Armenia',51,'Asia/Yerevan'),(53011,'Вайк','Vayk','','Armenia',51,'Asia/Yerevan'),(3903,'Ванадзор','Vanadzor','','Armenia',51,'Asia/Yerevan'),(3892,'Гюмри','Gumri','','Armenia',51,'Asia/Yerevan'),(53017,'Гюмри','Gyumri','','Armenia',51,'Asia/Yerevan'),(3904,'Ереван','Yerevan','','Armenia',51,'Asia/Yerevan'),(3893,'Иджеван','Ijevan','','Armenia',51,'Asia/Yerevan'),(3894,'Камо','Kamo','','Armenia',51,'Asia/Yerevan'),(3895,'Капан','Kapan','','Armenia',51,'Asia/Yerevan'),(3898,'Мегри','Meghri','','Armenia',51,'Asia/Yerevan'),(3899,'Раздан','Hrazdan','','Armenia',51,'Asia/Yerevan'),(3900,'Севан','Sevan','','Armenia',51,'Asia/Yerevan'),(2656,'Буст','Bust','','Afghanistan',4,'Europe/Paris'),(2669,'Джелалабад','Jalalabad','','Afghanistan',4,'Asia/Kabul'),(2670,'Кабул','Kabul','','Afghanistan',4,'Asia/Kabul'),(2678,'Кая','Mimana','','Afghanistan',4,'Asia/Kabul'),(2677,'Мазари-Шариф','Mazar-I-Sharif','','Afghanistan',4,'Asia/Kabul'),(2681,'Обе','Obe','','Afghanistan',4,'Asia/Kabul'),(3914,'','Cox','','Bangladesh',50,'Europe/Paris'),(3906,'Барисал','Barisal','','Bangladesh',50,'Asia/Dhaka'),(3908,'Богра','Bogra','','Bangladesh',50,'Asia/Dhaka'),(3915,'Дакка','Dhaka','','Bangladesh',50,'Asia/Dhaka'),(3928,'Джамалпур','Jamalpur','','Bangladesh',50,'Asia/Dhaka'),(3930,'Джессур','Jessore','','Bangladesh',50,'Asia/Dhaka'),(3918,'Динайпур','Dinajpur','','Bangladesh',50,'Asia/Dhaka'),(3913,'Комилла','Comilla','','Bangladesh',50,'Asia/Dhaka'),(3937,'Кхулна','Khulna','','Bangladesh',50,'Asia/Dhaka'),(3954,'Райшахи','Rajshahi','','Bangladesh',50,'Asia/Dhaka'),(3956,'Рангпур','Rangpur','','Bangladesh',50,'Asia/Dhaka'),(3957,'Саидпур','Saidpur','','Bangladesh',50,'Asia/Dhaka'),(3921,'Фени','Feni','','Bangladesh',50,'Asia/Dhaka'),(3909,'Чандпур','Chandpur','','Bangladesh',50,'Asia/Dhaka'),(3910,'Читтагонг','Chittagong','','Bangladesh',50,'Asia/Dhaka'),(108706,'Бриджтаун','Bridgetown','','Barbados',52,'America/Barbados'),(13617,'','Берёзовка','','Belarus',112,'Europe/Minsk'),(13627,'','Любань','','Belarus',112,'Europe/Minsk'),(3981,'Барановичи','Baranovichi','','Belarus',112,'Europe/Minsk'),(4003,'Барань','Barany','','Belarus',112,'Europe/Minsk'),(3982,'Белоозёрск','Belaazyorsk','','Belarus',112,'Europe/Minsk'),(4110,'Белыничи','Belynichy','','Belarus',112,''),(3983,'Берёза','Biaroza','','Belarus',112,'Europe/Minsk'),(4005,'Березино','Berazino','','Belarus',112,'Europe/Minsk'),(4083,'Березино','Berezino','','Belarus',112,'Europe/Minsk'),(4084,'Бобр','Bobr','','Belarus',112,'Europe/Minsk'),(4111,'Бобруйск','Babruysk','','Belarus',112,'Europe/Minsk'),(4085,'Борисов','Barysaw','','Belarus',112,'Europe/Minsk'),(4038,'Брагин','Bragin','','Belarus',112,''),(4008,'Браслав','Braslaw','','Belarus',112,'Europe/Minsk'),(3984,'Брест','Brest','','Belarus',112,'Europe/Minsk'),(4112,'Быхов','Bykhaw','','Belarus',112,'Europe/Minsk'),(4040,'Василевичи','Vasilevichy','','Belarus',112,'Europe/Minsk'),(4041,'Васильевка','Vasilyevka','','Belarus',112,'Europe/Moscow'),(4009,'Верхнедвинск','Verhnedvinsk','','Belarus',112,''),(4042,'Ветка','Vetka','','Belarus',112,'Europe/Minsk'),(4086,'Вилейка','Vileyka','','Belarus',112,'Europe/Minsk'),(4012,'Витебск','Vitebsk','','Belarus',112,'Europe/Minsk'),(4063,'Волковыск','Vawkavysk','','Belarus',112,'Europe/Minsk'),(4087,'Воложин','Valozhyn','','Belarus',112,'Europe/Minsk'),(3985,'Высокое','Vysokaye','','Belarus',112,'Europe/Minsk'),(3986,'Ганцевичи','Hantsavichy','','Belarus',112,'Europe/Minsk'),(4014,'Глубокое','Hlybokaye','','Belarus',112,'Europe/Minsk'),(4043,'Гомель','Gomel','','Belarus',112,'Europe/Minsk'),(3987,'Городище','Gorodishe','','Belarus',112,'Europe/Moscow'),(4015,'Городок','Haradok','','Belarus',112,'Europe/Minsk'),(4115,'Горький','Gorky','','Belarus',112,'Europe/Minsk'),(4065,'Гродно','Hrodna','','Belarus',112,'Europe/Minsk'),(3988,'Давид-Городок','Davyd-Haradok','','Belarus',112,'Europe/Minsk'),(4089,'Дзержинск','Dzerginsk','','Belarus',112,''),(4044,'Добруш','Dobrush','','Belarus',112,'Europe/Minsk'),(4017,'Докшицы','Dokshicy','','Belarus',112,''),(3990,'Дрогичин','Drahichyn','','Belarus',112,'Europe/Minsk'),(4020,'Езерище','Ezerishe','','Belarus',112,'Europe/Minsk'),(4117,'Елизово','Elizovo','','Belarus',112,'Europe/Minsk'),(4045,'Ельск','Yelsk','','Belarus',112,'Europe/Minsk'),(3991,'Жабинка','Zhabinka','','Belarus',112,'Europe/Minsk'),(4046,'Житковичи','Zhytkavichy','','Belarus',112,'Europe/Minsk'),(4047,'Жлобин','Zhlobin','','Belarus',112,'Europe/Minsk'),(4090,'Жодино','Zhodzina','','Belarus',112,'Europe/Minsk'),(13623,'Иваново','Ivanava','','Belarus',112,'Europe/Minsk'),(3992,'Ивацевичи','Ivatsevichy','','Belarus',112,'Europe/Minsk'),(4048,'Калинковичи','Kalinkavichy','','Belarus',112,'Europe/Minsk'),(3993,'Каменец','Kamyanyets','','Belarus',112,'Europe/Minsk'),(4118,'Кировск','Kirovsk','','Belarus',112,'Europe/Moscow'),(4094,'Клецк','Kletsk','','Belarus',112,'Europe/Minsk'),(4119,'Климовичи','Klimavichy','','Belarus',112,'Europe/Minsk'),(4120,'Кличев','Klicev','','Belarus',112,''),(3994,'Кобрин','Kobryn','','Belarus',112,'Europe/Minsk'),(86947,'Кобрин','Kobrin','','Belarus',112,'Europe/Minsk'),(4049,'Корма','Korma','','Belarus',112,'Europe/Minsk'),(4121,'Костюковичи','Kostiukovicy','','Belarus',112,''),(4122,'Краснополье','Krasnopolye','','Belarus',112,'Europe/Moscow'),(4123,'Кричев','Krychaw','','Belarus',112,'Europe/Minsk'),(4096,'Крупки','Krupky','','Belarus',112,'Europe/Prague'),(4050,'Лельчицы','Lelycicy','','Belarus',112,''),(4021,'Лепель','Lepiel','','Belarus',112,'Europe/Minsk'),(4072,'Лида','Lida','','Belarus',112,'Europe/Minsk'),(4097,'Логойск','Lahojsk','','Belarus',112,'Europe/Minsk'),(3995,'Лунинец','Luninets','','Belarus',112,'Europe/Minsk'),(4023,'Лынтупы','Lyntupy','','Belarus',112,'Europe/Minsk'),(3996,'Ляховичи','Lyakhavichy','','Belarus',112,'Europe/Minsk'),(3997,'Малорита','Malaryta','','Belarus',112,'Europe/Minsk'),(4098,'Марьина Горка','Maryina Gorka','','Belarus',112,''),(3998,'Микашевичи','Mikashevicy','','Belarus',112,'Europe/Minsk'),(4133,'Минск','Minsk','','Belarus',112,'Europe/Minsk'),(4024,'Миоры','Miory','','Belarus',112,'Europe/Minsk'),(4125,'Могилев','Mahilyow','','Belarus',112,'Europe/Minsk'),(4052,'Мозырь','Mazyr','','Belarus',112,'Europe/Minsk'),(86950,'Мозырь','Mozyr','','Belarus',112,'Europe/Minsk'),(4099,'Молодечно','Maladzyechna','','Belarus',112,'Europe/Minsk'),(4073,'Мосты','Mosty','','Belarus',112,'Europe/Minsk'),(4126,'Мстиславль','Mstsislaw','','Belarus',112,'Europe/Minsk'),(4100,'Мядель','Myadzel','','Belarus',112,'Europe/Minsk'),(4101,'Несвиж','Nesvizh','','Belarus',112,'Europe/Minsk'),(4074,'Новогрудок','Navahrudak','','Belarus',112,'Europe/Minsk'),(4025,'Новополоцк','Navapolatsk','','Belarus',112,'Europe/Minsk'),(4054,'Октябрьский','Oktiabryskiy','','Belarus',112,''),(4026,'Орша','Orsha','','Belarus',112,'Europe/Minsk'),(4127,'Осиповичи','Osipovochy','','Belarus',112,'Europe/Minsk'),(4076,'Островец','Ostrovec','','Belarus',112,'Europe/Prague'),(4077,'Ошмяны','Ashmyany','','Belarus',112,'Europe/Minsk'),(4055,'Петриков','Petrykaw','','Belarus',112,''),(3999,'Пинск','Pinsk','','Belarus',112,'Europe/Minsk'),(4027,'Полоцк','Polotsk','','Belarus',112,'Europe/Minsk'),(4028,'Поставы','Pastavy','','Belarus',112,'Europe/Minsk'),(4000,'Пружаны','Pruzhany','','Belarus',112,'Europe/Minsk'),(4056,'Речица','Rechytsa','','Belarus',112,'Europe/Minsk'),(86961,'Речица','Rechitsa','','Belarus',112,'Europe/Minsk'),(4057,'Рогачёв','Rahachow','','Belarus',112,'Europe/Minsk'),(4029,'Россоны','Rossony','','Belarus',112,'Europe/Minsk'),(4058,'Светлогорск','Svetlahorsk','','Belarus',112,'Europe/Minsk'),(4030,'Сенно','Senno','','Belarus',112,'Europe/Minsk'),(4128,'Славгород','Savgorod','','Belarus',112,'Europe/Minsk'),(4079,'Слоним','Slonim','','Belarus',112,'Europe/Minsk'),(4102,'Слуцк','Slutsk','','Belarus',112,'Europe/Minsk'),(4103,'Смолевичи','Smolevichy','','Belarus',112,'Europe/Minsk'),(4080,'Сморгонь','Smarhon','','Belarus',112,'Europe/Minsk'),(4104,'Солигорск','Salihorsk','','Belarus',112,'Europe/Minsk'),(4105,'Старые Дороги','Starye Dorogy','','Belarus',112,''),(4106,'Столбцы','Sto?ptsy','','Belarus',112,''),(4001,'Столин','Stolin','','Belarus',112,'Europe/Minsk'),(4031,'Толочин','Talachyn','','Belarus',112,'Europe/Minsk'),(4107,'Узда','Uzda','','Belarus',112,'Europe/Minsk'),(4032,'Ушачи','Ushacy','','Belarus',112,''),(4059,'Хойники','Khoiniki','','Belarus',112,'Europe/Minsk'),(4130,'Чаусы','Chavusy','','Belarus',112,'Europe/Minsk'),(4033,'Чашники','Chashniki','','Belarus',112,'Europe/Minsk'),(4131,'Чериков','Cherikov','','Belarus',112,''),(4060,'Чечерск','Chachersk','','Belarus',112,'Europe/Minsk'),(4034,'Шарковщина','Sharkovshina','','Belarus',112,''),(4132,'Шклов','Shklo?','','Belarus',112,'Europe/Uzhgorod'),(4082,'Щучин','Shchuchyn','','Belarus',112,'Europe/Minsk'),(108554,'Белиз','Belize City','','Belize',84,'America/Belize'),(108555,'Бельмопан','Belmopan','','Belize',84,'America/Belize'),(14211,'Ans','Ans','','Belgium',56,'Europe/Brussels'),(14229,'Aywaille','Aywaille','','Belgium',56,'Europe/Brussels'),(14609,'Diest','Diest','','Belgium',56,'Europe/Brussels'),(14339,'Herstal','Herstal','','Belgium',56,'Europe/Brussels'),(14403,'Lokeren','Lokeren','','Belgium',56,'Europe/Brussels'),(14447,'Saint-Nicolas','Saint-Nicolas','','Belgium',56,'Europe/Brussels'),(14451,'Seraing','Seraing','','Belgium',56,'Europe/Brussels'),(14457,'Sint-Niklaas','Sint-Niklaas','','Belgium',56,'Europe/Brussels'),(14749,'Vilvoorde','Vilvoorde','','Belgium',56,'Europe/Brussels'),(86932,'Андерлехт','Anderlecht','','Belgium',56,'Europe/Brussels'),(4134,'Антверпен','Antwerpen','','Belgium',56,'Europe/Brussels'),(86933,'Антверпен','Antwerp','','Belgium',56,'Europe/Brussels'),(4135,'Беаувичамн','Beauvechain','','Belgium',56,'Europe/Brussels'),(14277,'Брюгге','Brugge','','Belgium',56,'Europe/Brussels'),(4139,'Брюссель','Brussel','','Belgium',56,'Europe/Brussels'),(86934,'Брюссель','Brussels','','Belgium',56,'Europe/Brussels'),(14455,'Вавр','Wavre','','Belgium',56,'Europe/Brussels'),(14515,'Ватерлоо','Waterloo','','Belgium',56,'Europe/Brussels'),(86935,'Галле','Halle','','Belgium',56,'Europe/Brussels'),(4144,'Генк','Genk','','Belgium',56,'Europe/Brussels'),(4145,'Гент','Gent','','Belgium',56,'Europe/Brussels'),(14603,'Дендермонде','Dendermonde','','Belgium',56,'Europe/Brussels'),(14615,'Дилбек','Dilbeek','','Belgium',56,'Europe/Brussels'),(14343,'Ипр','Ieper','','Belgium',56,'Europe/Brussels'),(4147,'Кляйне Брогел','Kleine Brogel','','Belgium',56,'Europe/Brussels'),(4148,'Коксижде','Koksijde','','Belgium',56,'Europe/Brussels'),(14375,'Кортрейк','Kortrijk','','Belgium',56,'Europe/Brussels'),(14413,'Льеж','Liege','','Belgium',56,'Europe/Brussels'),(14679,'Мехелен','Mechelen','','Belgium',56,'Europe/Brussels'),(14685,'Монс','Mons','','Belgium',56,'Europe/Brussels'),(4151,'Мунте','Munte','','Belgium',56,'Europe/Brussels'),(14697,'Намюр','Namur','','Belgium',56,'Europe/Brussels'),(4152,'Остенде','Oostende','','Belgium',56,'Europe/Brussels'),(4155,'Синт-Труиден','Sint-Truiden','','Belgium',56,'Europe/Brussels'),(4156,'Спа','Spa','','Belgium',56,'Europe/Brussels'),(4157,'Ст-Хуберт','St-Hubert','','Belgium',56,'Europe/Brussels'),(4158,'Уккел','Uccle','','Belgium',56,'Europe/Brussels'),(4143,'Флереннес','Florennes','','Belgium',56,'Europe/Brussels'),(14319,'Хасселт','Hasselt','','Belgium',56,'Europe/Brussels'),(4140,'Шарлеруа','Charleroi','','Belgium',56,'Europe/Brussels'),(4142,'Эсленборн','Elsenborn','','Belgium',56,'Europe/Brussels'),(14341,'Юи','Huy','','Belgium',56,'Europe/Brussels'),(4160,'Бохикон','Bohicon','','Benin',204,'Africa/Porto-Novo'),(4162,'Канди','Kandi','','Benin',204,'Africa/Porto-Novo'),(4161,'Котону','Cotonou','','Benin',204,'Africa/Porto-Novo'),(4163,'Натитингу','Natitingou','','Benin',204,'Africa/Porto-Novo'),(4164,'Параку','Parakou','','Benin',204,'Africa/Porto-Novo'),(4165,'Саве','Save','','Benin',204,'Africa/Porto-Novo'),(97,'Албена','Albena','','Bulgaria',100,'Europe/Sofia'),(14787,'Благоевград','Blagoevgrad','','Bulgaria',100,'Europe/Sofia'),(2845,'Бургас','Burgas','','Bulgaria',100,'Europe/Sofia'),(2873,'Варна','Varna','','Bulgaria',100,'Europe/Sofia'),(86943,'Велико-Тырново','Turnovo','','Bulgaria',100,'Europe/Sofia'),(2875,'Видин','Vidin','','Bulgaria',100,'Europe/Sofia'),(2876,'Враца','Vratsa','','Bulgaria',100,'Europe/Sofia'),(98,'Золотые Пески','Golden sand','','Bulgaria',100,'Europe/Sofia'),(14807,'Каварна','Kavarna','','Bulgaria',100,'Europe/Sofia'),(2852,'Кырджали','Kurdjali','','Bulgaria',100,'Europe/Sofia'),(2853,'Кюстендил','Kyustendil','','Bulgaria',100,'Europe/Sofia'),(2855,'Ловеч','Lovech','','Bulgaria',100,'Europe/Sofia'),(2854,'Лом','Lom','','Bulgaria',100,'Europe/Sofia'),(2856,'Монтана','Montana','','Bulgaria',100,'Europe/Sofia'),(14831,'Пазарджик','Pazardzhik','','Bulgaria',100,'Europe/Sofia'),(14835,'Перник','Pernik','','Bulgaria',100,'Europe/Sofia'),(2861,'Плевен','Pleven','','Bulgaria',100,'Europe/Sofia'),(2862,'Пловдив','Plovdiv','','Bulgaria',100,'Europe/Sofia'),(2863,'Разград','Razgrad','','Bulgaria',100,'Europe/Sofia'),(2864,'Русе','Rousse','','Bulgaria',100,'Europe/Sofia'),(2865,'Сандански','Sandanski','','Bulgaria',100,'Europe/Sofia'),(2867,'Силистра','Silistra','','Bulgaria',100,'Europe/Sofia'),(2868,'Сливен','Sliven','','Bulgaria',100,'Europe/Sofia'),(99,'Солнечный берег','Sunny beach','','Bulgaria',100,'Europe/Sofia'),(2870,'София','Sofia','','Bulgaria',100,'Europe/Sofia'),(14865,'Стара-Загора','Stara Zagora','','Bulgaria',100,'Europe/Sofia'),(14879,'Тырговиште','Turgovishte','','Bulgaria',100,'Europe/Sofia'),(2866,'Шабла','Shabla','','Bulgaria',100,'Europe/Sofia'),(112560,'Консепсьон','Concepcion','','Bolivia',68,'America/La_Paz'),(112558,'Кочабамба','Cochabamba','','Bolivia',68,'America/La_Paz'),(112692,'Ла-Пас','La Paz','','Bolivia',68,'America/La_Paz'),(113084,'Санта-Крус-де-ла-Сьерра','Santa Cruz de la Sierra','','Bolivia',68,'America/La_Paz'),(113088,'Сукре','Sucre','','Bolivia',68,'America/La_Paz'),(113123,'Тринидад','Trinidad','','Bolivia',68,'America/La_Paz'),(4166,'Баня-Лука','Banja Luka','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4167,'Бихач','Bihac','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4169,'Бугойно','Bugojno','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4175,'Зеница','Zenica','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4171,'Ливно','Livno','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4172,'Мостар','Mostar','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4173,'Сараево','Sarajevo','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4174,'Тузла','Tuzla','','Bosnia And Herzegovina',70,'Europe/Sarajevo'),(4177,'Габороне','Gaborone','','Botswana',72,'Africa/Gaborone'),(4178,'Ганзи','Ghanzi','','Botswana',72,'Africa/Gaborone'),(4185,'Маун','Maun','','Botswana',72,'Africa/Gaborone'),(4176,'Франкистаун','Francistown','','Botswana',72,'Africa/Gaborone'),(37403,'Acajutiba','Acajutiba','','Brazil',76,'America/Bahia'),(37415,'Acopiara','Acopiara','','Brazil',76,'America/Fortaleza'),(37395,'Agrestina','Agrestina','','Brazil',76,'America/Recife'),(37423,'Agua Preta','Agua Preta','','Brazil',76,'America/Recife'),(37419,'Aguas Belas','Aguas Belas','','Brazil',76,'America/Recife'),(37429,'Alagoa Grande','Alagoa Grande','','Brazil',76,'America/Fortaleza'),(37437,'Alem Paraiba','Alem Paraiba','','Brazil',76,'America/Sao_Paulo'),(37439,'Alhandra','Alhandra','','Brazil',76,'America/Fortaleza'),(37449,'Almirante Tamandare','Almirante Tamandare','','Brazil',76,'America/Sao_Paulo'),(37461,'Alto Parana','Alto Parana','','Brazil',76,'America/Sao_Paulo'),(37463,'Alto Piquiri','Alto Piquiri','','Brazil',76,'America/Sao_Paulo'),(37469,'Amaraji','Amaraji','','Brazil',76,'America/Recife'),(37467,'Amarante do Maranhao','Amarante do Maranhao','','Brazil',76,'America/Fortaleza'),(37471,'Amargosa','Amargosa','','Brazil',76,'America/Bahia'),(37473,'America Dourada','America Dourada','','Brazil',76,'America/Bahia'),(37497,'Anicuns','Anicuns','','Brazil',76,'America/Sao_Paulo'),(37499,'Antonina','Antonina','','Brazil',76,'America/Sao_Paulo'),(37507,'Apodi','Apodi','','Brazil',76,'America/Fortaleza'),(37547,'Araci','Araci','','Brazil',76,'America/Bahia'),(37521,'Aracoiaba','Aracoiaba','','Brazil',76,'America/Recife'),(37525,'Aracruz','Aracruz','','Brazil',76,'America/Sao_Paulo'),(37539,'Arari','Arari','','Brazil',76,'America/Fortaleza'),(37541,'Araripe','Araripe','','Brazil',76,'America/Fortaleza'),(37553,'Areia','Areia','','Brazil',76,'America/Fortaleza'),(37561,'Aripuana','Aripuana','','Brazil',76,'America/Cuiaba'),(37581,'Assare','Assare','','Brazil',76,'America/Fortaleza'),(37589,'Atalaia','Atalaia','','Brazil',76,'America/Maceio'),(37593,'Augusto Correa','Augusto Correa','','Brazil',76,'America/Santarem'),(37597,'Aurora','Aurora','','Brazil',76,'America/Fortaleza'),(37613,'Baixo Guandu','Baixo Guandu','','Brazil',76,'America/Sao_Paulo'),(37623,'Barauna','Barauna','','Brazil',76,'America/Fortaleza'),(37625,'Barbalha','Barbalha','','Brazil',76,'America/Fortaleza'),(37633,'Barra','Barra','','Brazil',76,'America/Bahia'),(37635,'Barra Bonita','Barra Bonita','','Brazil',76,'America/Sao_Paulo'),(37639,'Barra da Estiva','Barra da Estiva','','Brazil',76,'America/Bahia'),(37645,'Barra do Bugres','Barra do Bugres','','Brazil',76,'America/Cuiaba'),(37649,'Barra do Corda','Barra do Corda','','Brazil',76,'America/Fortaleza'),(37663,'Barreirinhas','Barreirinhas','','Brazil',76,'America/Fortaleza'),(37697,'Bela Cruz','Bela Cruz','','Brazil',76,'America/Fortaleza'),(37691,'Bela Vista','Bela Vista','','Brazil',76,'America/Campo_Grande'),(37695,'Bela Vista do Paraiso','Bela Vista do Paraiso','','Brazil',76,'America/Sao_Paulo'),(37701,'Belem de Sao Francisco','Belem de Sao Francisco','','Brazil',76,'America/Recife'),(37711,'Benevides','Benevides','','Brazil',76,'America/Santarem'),(37721,'Biguacu','Biguacu','','Brazil',76,'America/Sao_Paulo'),(37819,'Boa Viagem','Boa Viagem','','Brazil',76,'America/Fortaleza'),(37741,'Bocaiuva','Bocaiuva','','Brazil',76,'America/Sao_Paulo'),(37757,'Bom Conselho','Bom Conselho','','Brazil',76,'America/Recife'),(37745,'Bom Despacho','Bom Despacho','','Brazil',76,'America/Sao_Paulo'),(37759,'Bom Sucesso','Bom Sucesso','','Brazil',76,'America/Sao_Paulo'),(37769,'Borda da Mata','Borda da Mata','','Brazil',76,'America/Sao_Paulo'),(37771,'Botelhos','Botelhos','','Brazil',76,'America/Sao_Paulo'),(37783,'Braco do Norte','Braco do Norte','','Brazil',76,'America/Sao_Paulo'),(37781,'Brasilia de Minas','Brasilia de Minas','','Brazil',76,'America/Sao_Paulo'),(37789,'Brejo','Brejo','','Brazil',76,'America/Fortaleza'),(37791,'Brejo da Madre de Deus','Brejo da Madre de Deus','','Brazil',76,'America/Recife'),(37793,'Brejo Santo','Brejo Santo','','Brazil',76,'America/Fortaleza'),(37787,'Breves','Breves','','Brazil',76,'America/Santarem'),(37805,'Buerarema','Buerarema','','Brazil',76,'America/Bahia'),(37807,'Buique','Buique','','Brazil',76,'America/Recife'),(37813,'Buriti Bravo','Buriti Bravo','','Brazil',76,'America/Fortaleza'),(37825,'Cabedelo','Cabedelo','','Brazil',76,'America/Noronha'),(37827,'Cabo','Cabo','','Brazil',76,'America/Recife'),(37843,'Cacador','Cacador','','Brazil',76,'America/Sao_Paulo'),(38051,'Cafarnaum','Cafarnaum','','Brazil',76,'America/Bahia'),(38059,'Cajati','Cajati','','Brazil',76,'America/Sao_Paulo'),(38057,'Cajazeiras','Cajazeiras','','Brazil',76,'America/Fortaleza'),(37867,'Camamu','Camamu','','Brazil',76,'America/Bahia'),(37865,'Camaqua','Camaqua','','Brazil',76,'America/Sao_Paulo'),(37873,'Cambara','Cambara','','Brazil',76,'America/Sao_Paulo'),(37875,'Cambe','Cambe','','Brazil',76,'America/Sao_Paulo'),(37877,'Cambui','Cambui','','Brazil',76,'America/Sao_Paulo'),(37881,'Cameta','Cameta','','Brazil',76,'America/Santarem'),(37885,'Camocim de Sao Felix','Camocim de Sao Felix','','Brazil',76,'America/Recife'),(37907,'Campo Formoso','Campo Formoso','','Brazil',76,'America/Bahia'),(37903,'Campo Largo','Campo Largo','','Brazil',76,'America/Sao_Paulo'),(37905,'Campo Mourao','Campo Mourao','','Brazil',76,'America/Sao_Paulo'),(37887,'Campo Verde','Campo Verde','','Brazil',76,'America/Cuiaba'),(37929,'Canarana','Canarana','','Brazil',76,'America/Bahia'),(37925,'Canavieiras','Canavieiras','','Brazil',76,'America/Bahia'),(37931,'Canguaretama','Canguaretama','','Brazil',76,'America/Fortaleza'),(37947,'Canhotinho','Canhotinho','','Brazil',76,'America/Recife'),(37941,'Caninde','Caninde','','Brazil',76,'America/Fortaleza'),(37953,'Canto do Buriti','Canto do Buriti','','Brazil',76,'America/Fortaleza'),(37955,'Capanema','Capanema','','Brazil',76,'America/Sao_Paulo'),(37959,'Capao da Canoa','Capao da Canoa','','Brazil',76,'America/Sao_Paulo'),(37969,'Capim Grosso','Capim Grosso','','Brazil',76,'America/Bahia'),(37971,'Capinopolis','Capinopolis','','Brazil',76,'America/Sao_Paulo'),(37973,'Capinzal','Capinzal','','Brazil',76,'America/Sao_Paulo'),(37975,'Capitao Poco','Capitao Poco','','Brazil',76,'America/Santarem'),(37993,'Caraubas','Caraubas','','Brazil',76,'America/Fortaleza'),(37997,'Carinhanha','Carinhanha','','Brazil',76,'America/Bahia'),(38001,'Caririacu','Caririacu','','Brazil',76,'America/Fortaleza'),(38007,'Carmo','Carmo','','Brazil',76,'America/Sao_Paulo'),(38011,'Carmo do Paranaiba','Carmo do Paranaiba','','Brazil',76,'America/Sao_Paulo'),(38019,'Carutapera','Carutapera','','Brazil',76,'America/Fortaleza'),(38047,'Catole do Rocha','Catole do Rocha','','Brazil',76,'America/Fortaleza'),(38075,'Cedro','Cedro','','Brazil',76,'America/Fortaleza'),(38225,'Chapada dos Guimaraes','Chapada dos Guimaraes','','Brazil',76,'America/Cuiaba'),(38235,'Chopinzinho','Chopinzinho','','Brazil',76,'America/Sao_Paulo'),(38219,'Cicero Dantas','Cicero Dantas','','Brazil',76,'America/Bahia'),(38217,'Cipo','Cipo','','Brazil',76,'America/Bahia'),(38077,'Clevelandia','Clevelandia','','Brazil',76,'America/Sao_Paulo'),(38079,'Coaraci','Coaraci','','Brazil',76,'America/Bahia'),(38103,'Conceicao da Feira','Conceicao da Feira','','Brazil',76,'America/Bahia'),(38105,'Conceicao das Alagoas','Conceicao das Alagoas','','Brazil',76,'America/Sao_Paulo'),(38107,'Conceicao do Araguaia','Conceicao do Araguaia','','Brazil',76,'America/Santarem'),(38109,'Conceicao do Coite','Conceicao do Coite','','Brazil',76,'America/Bahia'),(38115,'Conceicao do Jacuipe','Conceicao do Jacuipe','','Brazil',76,'America/Bahia'),(38127,'Coracao de Jesus','Coracao de Jesus','','Brazil',76,'America/Sao_Paulo'),(38129,'Corbelia','Corbelia','','Brazil',76,'America/Sao_Paulo'),(38135,'Coreau','Coreau','','Brazil',76,'America/Fortaleza'),(38137,'Coremas','Coremas','','Brazil',76,'America/Fortaleza'),(38141,'Coroata','Coroata','','Brazil',76,'America/Fortaleza'),(38145,'Coronel Vivida','Coronel Vivida','','Brazil',76,'America/Sao_Paulo'),(38149,'Correia Pinto','Correia Pinto','','Brazil',76,'America/Sao_Paulo'),(38155,'Corupa','Corupa','','Brazil',76,'America/Sao_Paulo'),(38159,'Cosmopolis','Cosmopolis','','Brazil',76,'America/Sao_Paulo'),(38175,'Cruz Alta','Cruz Alta','','Brazil',76,'America/Sao_Paulo'),(38181,'Cruzeiro do Oeste','Cruzeiro do Oeste','','Brazil',76,'America/Sao_Paulo'),(38183,'Cruzilia','Cruzilia','','Brazil',76,'America/Sao_Paulo'),(38187,'Cuite','Cuite','','Brazil',76,'America/Fortaleza'),(38197,'Currais Novos','Currais Novos','','Brazil',76,'America/Fortaleza'),(38199,'Curuca','Curuca','','Brazil',76,'America/Santarem'),(38201,'Cururupu','Cururupu','','Brazil',76,'America/Fortaleza'),(38037,'Custodia','Custodia','','Brazil',76,'America/Recife'),(38271,'Elesbao Veloso','Elesbao Veloso','','Brazil',76,'America/Fortaleza'),(38275,'Eloi Mendes','Eloi Mendes','','Brazil',76,'America/Sao_Paulo'),(38283,'Entre Rios','Entre Rios','','Brazil',76,'America/Bahia'),(38295,'Esperanca','Esperanca','','Brazil',76,'America/Fortaleza'),(38297,'Esperantina','Esperantina','','Brazil',76,'America/Fortaleza'),(38299,'Esperantinopolis','Esperantinopolis','','Brazil',76,'America/Fortaleza'),(38305,'Esplanada','Esplanada','','Brazil',76,'America/Bahia'),(38311,'Estancia Velha','Estancia Velha','','Brazil',76,'America/Sao_Paulo'),(38315,'Estreito','Estreito','','Brazil',76,'America/Fortaleza'),(38269,'Extremoz','Extremoz','','Brazil',76,'America/Fortaleza'),(38321,'Faxinal','Faxinal','','Brazil',76,'America/Sao_Paulo'),(38343,'Florestopolis','Florestopolis','','Brazil',76,'America/Sao_Paulo'),(38345,'Floriano','Floriano','','Brazil',76,'America/Fortaleza'),(38349,'Fonte Boa','Fonte Boa','','Brazil',76,'America/Manaus'),(38373,'Francisco Sa','Francisco Sa','','Brazil',76,'America/Sao_Paulo'),(38379,'Fundao','Fundao','','Brazil',76,'America/Sao_Paulo'),(38383,'Gandu','Gandu','','Brazil',76,'America/Bahia'),(38391,'Gaspar','Gaspar','','Brazil',76,'America/Sao_Paulo'),(38445,'Gloria do Goita','Gloria do Goita','','Brazil',76,'America/Recife'),(38449,'Goiana','Goiana','','Brazil',76,'America/Sao_Paulo'),(38455,'Goianinha','Goianinha','','Brazil',76,'America/Fortaleza'),(38397,'Guaiuba','Guaiuba','','Brazil',76,'America/Fortaleza'),(38403,'Guanhaes','Guanhaes','','Brazil',76,'America/Sao_Paulo'),(38411,'Guapore','Guapore','','Brazil',76,'America/Sao_Paulo'),(38429,'Guaraciaba do Norte','Guaraciaba do Norte','','Brazil',76,'America/Fortaleza'),(38417,'Guaramirim','Guaramirim','','Brazil',76,'America/Sao_Paulo'),(38419,'Guaranesia','Guaranesia','','Brazil',76,'America/Sao_Paulo'),(38399,'Guaxupe','Guaxupe','','Brazil',76,'America/Sao_Paulo'),(38443,'Guiratinga','Guiratinga','','Brazil',76,'America/Cuiaba'),(38477,'Hidrolandia','Hidrolandia','','Brazil',76,'America/Fortaleza'),(38483,'Humaita','Humaita','','Brazil',76,'America/Manaus'),(38487,'Iacu','Iacu','','Brazil',76,'America/Bahia'),(38489,'Ibaiti','Ibaiti','','Brazil',76,'America/Sao_Paulo'),(38495,'Ibicarai','Ibicarai','','Brazil',76,'America/Bahia'),(38497,'Ibicui','Ibicui','','Brazil',76,'America/Bahia'),(38499,'Ibimirim','Ibimirim','','Brazil',76,'America/Recife'),(38501,'Ibipeba','Ibipeba','','Brazil',76,'America/Bahia'),(38503,'Ibipora','Ibipora','','Brazil',76,'America/Sao_Paulo'),(38505,'Ibirama','Ibirama','','Brazil',76,'America/Sao_Paulo'),(38507,'Ibirataia','Ibirataia','','Brazil',76,'America/Bahia'),(38511,'Ibiruba','Ibiruba','','Brazil',76,'America/Sao_Paulo'),(38525,'Igarape','Igarape','','Brazil',76,'America/Sao_Paulo'),(38535,'Iguai','Iguai','','Brazil',76,'America/Bahia'),(38741,'Ijui','Ijui','','Brazil',76,'America/Sao_Paulo'),(38553,'Imbituva','Imbituva','','Brazil',76,'America/Sao_Paulo'),(38557,'Inhambupe','Inhambupe','','Brazil',76,'America/Bahia'),(38567,'Ipaba','Ipaba','','Brazil',76,'America/Sao_Paulo'),(38579,'Ipira','Ipira','','Brazil',76,'America/Bahia'),(38581,'Ipora','Ipora','','Brazil',76,'America/Sao_Paulo'),(38585,'Ipubi','Ipubi','','Brazil',76,'America/Recife'),(38587,'Ipueiras','Ipueiras','','Brazil',76,'America/Fortaleza'),(38595,'Iraucuba','Iraucuba','','Brazil',76,'America/Fortaleza'),(38597,'Irece','Irece','','Brazil',76,'America/Bahia'),(38605,'Itaberaba','Itaberaba','','Brazil',76,'America/Bahia'),(38713,'Itagi','Itagi','','Brazil',76,'America/Bahia'),(38621,'Itaiba','Itaiba','','Brazil',76,'America/Recife'),(38623,'Itaitinga','Itaitinga','','Brazil',76,'America/Fortaleza'),(38719,'Itajuipe','Itajuipe','','Brazil',76,'America/Bahia'),(38641,'Itamaraju','Itamaraju','','Brazil',76,'America/Bahia'),(38645,'Itambe','Itambe','','Brazil',76,'America/Bahia'),(38651,'Itanhem','Itanhem','','Brazil',76,'America/Bahia'),(38659,'Itapage','Itapage','','Brazil',76,'America/Fortaleza'),(38665,'Itapecuru Mirim','Itapecuru Mirim','','Brazil',76,'America/Fortaleza'),(38669,'Itapemirim','Itapemirim','','Brazil',76,'America/Sao_Paulo'),(38679,'Itapetinga','Itapetinga','','Brazil',76,'America/Bahia'),(38633,'Itaquitinga','Itaquitinga','','Brazil',76,'America/Recife'),(38697,'Itarantim','Itarantim','','Brazil',76,'America/Bahia'),(38701,'Itatiaia','Itatiaia','','Brazil',76,'America/Sao_Paulo'),(38709,'Itauna','Itauna','','Brazil',76,'America/Sao_Paulo'),(38723,'Itirucu','Itirucu','','Brazil',76,'America/Bahia'),(38727,'Itubera','Itubera','','Brazil',76,'America/Bahia'),(38735,'Itupiranga','Itupiranga','','Brazil',76,'America/Santarem'),(38767,'Jacarezinho','Jacarezinho','','Brazil',76,'America/Sao_Paulo'),(38801,'Jaciara','Jaciara','','Brazil',76,'America/Cuiaba'),(38769,'Jacobina','Jacobina','','Brazil',76,'America/Bahia'),(38773,'Jacutinga','Jacutinga','','Brazil',76,'America/Sao_Paulo'),(38751,'Jaguaquara','Jaguaquara','','Brazil',76,'America/Bahia'),(38753,'Jaguarari','Jaguarari','','Brazil',76,'America/Bahia'),(38755,'Jaguariaiva','Jaguariaiva','','Brazil',76,'America/Sao_Paulo'),(38757,'Jaguaribe','Jaguaribe','','Brazil',76,'America/Fortaleza'),(38761,'Jaguaruana','Jaguaruana','','Brazil',76,'America/Fortaleza'),(38763,'Jaguaruna','Jaguaruna','','Brazil',76,'America/Sao_Paulo'),(38777,'Janauba','Janauba','','Brazil',76,'America/Sao_Paulo'),(38791,'Jardim','Jardim','','Brazil',76,'America/Fortaleza'),(38793,'Jardim de Piranhas','Jardim de Piranhas','','Brazil',76,'America/Fortaleza'),(38803,'Jatai','Jatai','','Brazil',76,'America/Sao_Paulo'),(38805,'Jataizinho','Jataizinho','','Brazil',76,'America/Sao_Paulo'),(38813,'Jeremoabo','Jeremoabo','','Brazil',76,'America/Bahia'),(38815,'Jitauna','Jitauna','','Brazil',76,'America/Bahia'),(38821,'Joao Alfredo','Joao Alfredo','','Brazil',76,'America/Recife'),(38823,'Joao Monlevade','Joao Monlevade','','Brazil',76,'America/Sao_Paulo'),(38827,'Joao Pinheiro','Joao Pinheiro','','Brazil',76,'America/Sao_Paulo'),(38833,'Jose de Freitas','Jose de Freitas','','Brazil',76,'America/Fortaleza'),(38841,'Jucas','Jucas','','Brazil',76,'America/Fortaleza'),(38847,'Jucurutu','Jucurutu','','Brazil',76,'America/Fortaleza'),(38855,'Juruti','Juruti','','Brazil',76,'America/Santarem'),(38861,'Lagarto','Lagarto','','Brazil',76,'America/Maceio'),(38863,'Lago da Pedra','Lago da Pedra','','Brazil',76,'America/Fortaleza'),(38881,'Lapa','Lapa','','Brazil',76,'America/Sao_Paulo'),(38883,'Lapao','Lapao','','Brazil',76,'America/Bahia'),(38887,'Laranjeiras do Sul','Laranjeiras do Sul','','Brazil',76,'America/Sao_Paulo'),(38859,'Lavras da Mangabeira','Lavras da Mangabeira','','Brazil',76,'America/Fortaleza'),(38909,'Limoeiro','Limoeiro','','Brazil',76,'America/Fortaleza'),(38911,'Limoeiro do Norte','Limoeiro do Norte','','Brazil',76,'America/Fortaleza'),(38905,'Livramento do Brumado','Livramento do Brumado','','Brazil',76,'America/Bahia'),(38915,'Loanda','Loanda','','Brazil',76,'America/Sao_Paulo'),(38929,'Luzilandia','Luzilandia','','Brazil',76,'America/Fortaleza'),(39089,'Macaiba','Macaiba','','Brazil',76,'America/Fortaleza'),(39097,'Macaubas','Macaubas','','Brazil',76,'America/Bahia'),(39185,'Machado','Machado','','Brazil',76,'America/Sao_Paulo'),(39099,'Mamanguape','Mamanguape','','Brazil',76,'America/Fortaleza'),(39109,'Mandaguacu','Mandaguacu','','Brazil',76,'America/Sao_Paulo'),(39111,'Mandaguari','Mandaguari','','Brazil',76,'America/Sao_Paulo'),(39131,'Maracana','Maracana','','Brazil',76,'America/Manaus'),(39135,'Maracas','Maracas','','Brazil',76,'America/Bahia'),(39123,'Maragogipe','Maragogipe','','Brazil',76,'America/Bahia'),(39125,'Maraial','Maraial','','Brazil',76,'America/Recife'),(39139,'Marapanim','Marapanim','','Brazil',76,'America/Santarem'),(39147,'Marechal Candido Rondon','Marechal Candido Rondon','','Brazil',76,'America/Sao_Paulo'),(39149,'Marialva','Marialva','','Brazil',76,'America/Sao_Paulo'),(39167,'Mascote','Mascote','','Brazil',76,'America/Bahia'),(39169,'Mata de Sao Joao','Mata de Sao Joao','','Brazil',76,'America/Bahia'),(39173,'Matelandia','Matelandia','','Brazil',76,'America/Sao_Paulo'),(39177,'Matias Barbosa','Matias Barbosa','','Brazil',76,'America/Sao_Paulo'),(39179,'Matozinhos','Matozinhos','','Brazil',76,'America/Sao_Paulo'),(39085,'Maua','Maua','','Brazil',76,'America/Sao_Paulo'),(39187,'Medeiros Neto','Medeiros Neto','','Brazil',76,'America/Bahia'),(39197,'Miguel Alves','Miguel Alves','','Brazil',76,'America/Fortaleza'),(39199,'Miguel Calmon','Miguel Calmon','','Brazil',76,'America/Bahia'),(39203,'Milagres','Milagres','','Brazil',76,'America/Fortaleza'),(39205,'Mimoso do Sul','Mimoso do Sul','','Brazil',76,'America/Sao_Paulo'),(39217,'Missao Velha','Missao Velha','','Brazil',76,'America/Fortaleza'),(39219,'Mocajuba','Mocajuba','','Brazil',76,'America/Santarem'),(39275,'Moju','Moju','','Brazil',76,'America/Santarem'),(39223,'Mombaca','Mombaca','','Brazil',76,'America/Fortaleza'),(39227,'Montanha','Montanha','','Brazil',76,'America/Sao_Paulo'),(39241,'Monte Carmelo','Monte Carmelo','','Brazil',76,'America/Manaus'),(39247,'Monte Siao','Monte Siao','','Brazil',76,'America/Sao_Paulo'),(39249,'Monteiro','Monteiro','','Brazil',76,'America/Fortaleza'),(39255,'Morada Nova','Morada Nova','','Brazil',76,'America/Fortaleza'),(39257,'Morrinhos','Morrinhos','','Brazil',76,'America/Sao_Paulo'),(39279,'Mundo Novo','Mundo Novo','','Brazil',76,'America/Campo_Grande'),(39285,'Muritiba','Muritiba','','Brazil',76,'America/Bahia'),(39289,'Mutuipe','Mutuipe','','Brazil',76,'America/Bahia'),(39287,'Muzambinho','Muzambinho','','Brazil',76,'America/Sao_Paulo'),(39301,'Nazare','Nazare','','Brazil',76,'America/Bahia'),(39327,'Nova Cruz','Nova Cruz','','Brazil',76,'America/Fortaleza'),(39335,'Nova Olimpia','Nova Olimpia','','Brazil',76,'America/Cuiaba'),(39343,'Nova Russas','Nova Russas','','Brazil',76,'America/Fortaleza'),(39345,'Nova Soure','Nova Soure','','Brazil',76,'America/Bahia'),(39321,'Nova Vicosa','Nova Vicosa','','Brazil',76,'America/Bahia'),(39355,'Novo Oriente','Novo Oriente','','Brazil',76,'America/Fortaleza'),(39367,'Oeiras','Oeiras','','Brazil',76,'America/Fortaleza'),(39369,'Oeiras do Para','Oeiras do Para','','Brazil',76,'America/Santarem'),(39377,'Olindina','Olindina','','Brazil',76,'America/Bahia'),(39371,'Oliveira','Oliveira','','Brazil',76,'America/Sao_Paulo'),(39379,'Oriximina','Oriximina','','Brazil',76,'America/Santarem'),(39389,'Otacilio Costa','Otacilio Costa','','Brazil',76,'America/Sao_Paulo'),(39391,'Ouricuri','Ouricuri','','Brazil',76,'America/Recife'),(39411,'Pacajus','Pacajus','','Brazil',76,'America/Fortaleza'),(39403,'Padre Paraiso','Padre Paraiso','','Brazil',76,'America/Sao_Paulo'),(39421,'Palmeira das Missoes','Palmeira das Missoes','','Brazil',76,'America/Sao_Paulo'),(39415,'Palotina','Palotina','','Brazil',76,'America/Sao_Paulo'),(39433,'Pao de Acucar','Pao de Acucar','','Brazil',76,'America/Maceio'),(39455,'Paracatu','Paracatu','','Brazil',76,'America/Sao_Paulo'),(39457,'Paracuru','Paracuru','','Brazil',76,'America/Fortaleza'),(39443,'Paragominas','Paragominas','','Brazil',76,'America/Santarem'),(39447,'Paraibano','Paraibano','','Brazil',76,'America/Fortaleza'),(39459,'Parambu','Parambu','','Brazil',76,'America/Fortaleza'),(39469,'Paratinga','Paratinga','','Brazil',76,'America/Bahia'),(39471,'Parelhas','Parelhas','','Brazil',76,'America/Fortaleza'),(39481,'Parnarama','Parnarama','','Brazil',76,'America/Fortaleza'),(39483,'Parobe','Parobe','','Brazil',76,'America/Sao_Paulo'),(39487,'Passira','Passira','','Brazil',76,'America/Recife'),(39493,'Pastos Bons','Pastos Bons','','Brazil',76,'America/Fortaleza'),(39509,'Peabiru','Peabiru','','Brazil',76,'America/Sao_Paulo'),(39529,'Penalva','Penalva','','Brazil',76,'America/Fortaleza'),(39527,'Penha','Penha','','Brazil',76,'America/Sao_Paulo'),(39535,'Pentecoste','Pentecoste','','Brazil',76,'America/Fortaleza'),(39537,'Perdoes','Perdoes','','Brazil',76,'America/Sao_Paulo'),(39549,'Pianco','Pianco','','Brazil',76,'America/Fortaleza'),(39555,'Picui','Picui','','Brazil',76,'America/Fortaleza'),(39567,'Pindare Mirim','Pindare Mirim','','Brazil',76,'America/Fortaleza'),(39569,'Pindobacu','Pindobacu','','Brazil',76,'America/Bahia'),(39577,'Pinheiro Machado','Pinheiro Machado','','Brazil',76,'America/Sao_Paulo'),(39579,'Pio XII','Pio XII','','Brazil',76,'America/Fortaleza'),(39585,'Piracaia','Piracaia','','Brazil',76,'America/Sao_Paulo'),(39591,'Piracuruca','Piracuruca','','Brazil',76,'America/Fortaleza'),(39583,'Pirai do Sul','Pirai do Sul','','Brazil',76,'America/Sao_Paulo'),(39589,'Piraquara','Piraquara','','Brazil',76,'America/Sao_Paulo'),(39611,'Piripiri','Piripiri','','Brazil',76,'America/Fortaleza'),(39613,'Piritiba','Piritiba','','Brazil',76,'America/Bahia'),(39617,'Pitangui','Pitangui','','Brazil',76,'America/Sao_Paulo'),(39619,'Piui','Piui','','Brazil',76,'America/Fortaleza'),(39623,'Planaltina','Planaltina','','Brazil',76,'America/Sao_Paulo'),(39629,'Pocao de Pedras','Pocao de Pedras','','Brazil',76,'America/Fortaleza'),(39633,'Pocoes','Pocoes','','Brazil',76,'America/Bahia'),(39635,'Pocone','Pocone','','Brazil',76,'America/Cuiaba'),(39661,'Pontes e Lacerda','Pontes e Lacerda','','Brazil',76,'America/Cuiaba'),(39669,'Portao','Portao','','Brazil',76,'America/Sao_Paulo'),(39675,'Porto Belo','Porto Belo','','Brazil',76,'America/Sao_Paulo'),(39689,'Porto Franco','Porto Franco','','Brazil',76,'America/Araguaina'),(39639,'Poxoreo','Poxoreo','','Brazil',76,'America/Cuiaba'),(39711,'Presidente Dutra','Presidente Dutra','','Brazil',76,'America/Fortaleza'),(39715,'Presidente Olegario','Presidente Olegario','','Brazil',76,'America/Sao_Paulo'),(39721,'Princesa Isabel','Princesa Isabel','','Brazil',76,'America/Fortaleza'),(39727,'Prudentopolis','Prudentopolis','','Brazil',76,'America/Sao_Paulo'),(39059,'Queimadas','Queimadas','','Brazil',76,'America/Fortaleza'),(39069,'Quipapa','Quipapa','','Brazil',76,'America/Recife'),(39067,'Quixere','Quixere','','Brazil',76,'America/Fortaleza'),(39745,'Reriutaba','Reriutaba','','Brazil',76,'America/Fortaleza'),(39751,'Resplendor','Resplendor','','Brazil',76,'America/Sao_Paulo'),(39761,'Ribeira do Pombal','Ribeira do Pombal','','Brazil',76,'America/Bahia'),(39763,'Ribeirao','Ribeirao','','Brazil',76,'America/Recife'),(39779,'Rio Branco do Sul','Rio Branco do Sul','','Brazil',76,'America/Sao_Paulo'),(39791,'Rio do Sul','Rio do Sul','','Brazil',76,'America/Sao_Paulo'),(39811,'Rio Formoso','Rio Formoso','','Brazil',76,'America/Recife'),(39799,'Rio Negrinho','Rio Negrinho','','Brazil',76,'America/Sao_Paulo'),(39805,'Rio Pomba','Rio Pomba','','Brazil',76,'America/Sao_Paulo'),(39807,'Rio Real','Rio Real','','Brazil',76,'America/Bahia'),(39809,'Rio Tinto','Rio Tinto','','Brazil',76,'America/Fortaleza'),(39815,'Rolandia','Rolandia','','Brazil',76,'America/Sao_Paulo'),(39827,'Rosario do Sul','Rosario do Sul','','Brazil',76,'America/Sao_Paulo'),(39821,'Rosario Oeste','Rosario Oeste','','Brazil',76,'America/Cuiaba'),(39825,'Russas','Russas','','Brazil',76,'America/Fortaleza'),(39835,'Salinopolis','Salinopolis','','Brazil',76,'America/Santarem'),(39839,'Salto','Salto','','Brazil',76,'America/Sao_Paulo'),(39933,'Santa Cruz Cabralia','Santa Cruz Cabralia','','Brazil',76,'America/Bahia'),(39927,'Santa Cruz do Capibaribe','Santa Cruz do Capibaribe','','Brazil',76,'America/Recife'),(39905,'Santa Helena','Santa Helena','','Brazil',76,'America/Sao_Paulo'),(39911,'Santa Ines','Santa Ines','','Brazil',76,'America/Fortaleza'),(39909,'Santa Isabel','Santa Isabel','','Brazil',76,'America/Sao_Paulo'),(40187,'Tabatinga','Tabatinga','','Brazil',76,'America/Fortaleza'),(40189,'Taboao da Serra','Taboao da Serra','','Brazil',76,'America/Sao_Paulo'),(40191,'Taiobeiras','Taiobeiras','','Brazil',76,'America/Sao_Paulo'),(40207,'Tamboril','Tamboril','','Brazil',76,'America/Fortaleza'),(40209,'Tanabi','Tanabi','','Brazil',76,'America/Sao_Paulo'),(40215,'Tapejara','Tapejara','','Brazil',76,'America/Sao_Paulo'),(40193,'Taquara','Taquara','','Brazil',76,'America/Sao_Paulo'),(40197,'Taquaritinga','Taquaritinga','','Brazil',76,'America/Sao_Paulo'),(40201,'Taquarituba','Taquarituba','','Brazil',76,'America/Sao_Paulo'),(40217,'Tarauaca','Tarauaca','','Brazil',76,'America/Rio_Branco'),(40219,'Taruma','Taruma','','Brazil',76,'America/Sao_Paulo'),(40221,'Tatui','Tatui','','Brazil',76,'America/Sao_Paulo'),(40223,'Taubate','Taubate','','Brazil',76,'America/Sao_Paulo'),(40243,'Tefe','Tefe','','Brazil',76,'America/Manaus'),(40225,'Telemaco Borba','Telemaco Borba','','Brazil',76,'America/Sao_Paulo'),(40227,'Teodoro Sampaio','Teodoro Sampaio','','Brazil',76,'America/Bahia'),(40229,'Teofilo Otoni','Teofilo Otoni','','Brazil',76,'America/Sao_Paulo'),(40233,'Teresopolis','Teresopolis','','Brazil',76,'America/Sao_Paulo'),(40237,'Terra Rica','Terra Rica','','Brazil',76,'America/Sao_Paulo'),(40241,'Terra Santa','Terra Santa','','Brazil',76,'America/Santarem'),(40245,'Tiangua','Tiangua','','Brazil',76,'America/Fortaleza'),(40247,'Tibagi','Tibagi','','Brazil',76,'America/Sao_Paulo'),(40311,'Tiete','Tiete','','Brazil',76,'America/Sao_Paulo'),(40249,'Timbauba','Timbauba','','Brazil',76,'America/Recife'),(40251,'Timbiras','Timbiras','','Brazil',76,'America/Fortaleza'),(40253,'Timon','Timon','','Brazil',76,'America/Fortaleza'),(40257,'Tobias Barreto','Tobias Barreto','','Brazil',76,'America/Maceio'),(40261,'Toritama','Toritama','','Brazil',76,'America/Recife'),(40265,'Trairi','Trairi','','Brazil',76,'America/Fortaleza'),(40269,'Tremembe','Tremembe','','Brazil',76,'America/Sao_Paulo'),(40281,'Tres Passos','Tres Passos','','Brazil',76,'America/Sao_Paulo'),(40289,'Triunfo','Triunfo','','Brazil',76,'America/Sao_Paulo'),(40291,'Tubarao','Tubarao','','Brazil',76,'America/Sao_Paulo'),(40293,'Tucuma','Tucuma','','Brazil',76,'America/Santarem'),(40295,'Tucurui','Tucurui','','Brazil',76,'America/Santarem'),(40297,'Tuntum','Tuntum','','Brazil',76,'America/Fortaleza'),(40307,'Turiacu','Turiacu','','Brazil',76,'America/Fortaleza'),(40309,'Tutoia','Tutoia','','Brazil',76,'America/Fortaleza'),(39009,'Uaua','Uaua','','Brazil',76,'America/Bahia'),(39013,'Ubaitaba','Ubaitaba','','Brazil',76,'America/Bahia'),(39019,'Ubajara','Ubajara','','Brazil',76,'America/Fortaleza'),(39015,'Ubata','Ubata','','Brazil',76,'America/Bahia'),(39031,'Una','Una','','Brazil',76,'America/Bahia'),(39041,'Urbano Santos','Urbano Santos','','Brazil',76,'America/Fortaleza'),(39045,'Uruburetama','Uruburetama','','Brazil',76,'America/Fortaleza'),(39051,'Urucuca','Urucuca','','Brazil',76,'America/Bahia'),(39049,'Urucui','Urucui','','Brazil',76,'America/Fortaleza'),(39057,'Urussanga','Urussanga','','Brazil',76,'America/Sao_Paulo'),(38937,'Valenca do Piaui','Valenca do Piaui','','Brazil',76,'America/Fortaleza'),(38939,'Valente','Valente','','Brazil',76,'America/Bahia'),(38945,'Varzea Alegre','Varzea Alegre','','Brazil',76,'America/Fortaleza'),(38947,'Varzea da Palma','Varzea da Palma','','Brazil',76,'America/Sao_Paulo'),(38967,'Veranopolis','Veranopolis','','Brazil',76,'America/Sao_Paulo'),(38973,'Viana','Viana','','Brazil',76,'America/Sao_Paulo'),(38991,'Vicencia','Vicencia','','Brazil',76,'America/Recife'),(38981,'Vicosa do Ceara','Vicosa do Ceara','','Brazil',76,'America/Fortaleza'),(38975,'Vigia','Vigia','','Brazil',76,'America/Santarem'),(37445,'Алворада','Alvorada','','Brazil',76,'America/Sao_Paulo'),(112374,'Александрия','Alexandria','','Brazil',76,'America/Fortaleza'),(112383,'Алмейрин','Almeirim','','Brazil',76,'America/Santarem'),(37475,'Американа','Americana','','Brazil',76,'America/Sao_Paulo'),(37481,'Ананиндеуа','Ananindeua','','Brazil',76,'America/Santarem'),(37483,'Анаполис','Anapolis','','Brazil',76,'America/Sao_Paulo'),(37501,'Апаресида','Aparecida','','Brazil',76,'America/Sao_Paulo'),(37509,'Апукарана','Apucarana','','Brazil',76,'America/Sao_Paulo'),(112495,'Арагуаина','Araguaina','','Brazil',76,'America/Araguaina'),(37515,'Аракажу','Aracaju','','Brazil',76,'America/Maceio'),(37531,'Арапирака','Arapiraca','','Brazil',76,'America/Maceio'),(112522,'Араракуара','Araraquara','','Brazil',76,'America/Sao_Paulo'),(112537,'Арес','Ares','','Brazil',76,'America/Fortaleza'),(37417,'Асу','Acu','','Brazil',76,'America/Fortaleza'),(112703,'Байё','Bayeux','','Brazil',76,'America/Fortaleza'),(37627,'Барбасена','Barbacena','','Brazil',76,'America/Sao_Paulo'),(37631,'Баркарена','Barcarena','','Brazil',76,'America/Santarem'),(37655,'Барра-Манса','Barra Mansa','','Brazil',76,'America/Sao_Paulo'),(37659,'Баррейрас','Barreiras','','Brazil',76,'America/Bahia'),(112685,'Барро','Barro','','Brazil',76,'America/Fortaleza'),(112670,'Барселона','Barcelona','','Brazil',76,'America/Fortaleza'),(37683,'Бауру','Bauru','','Brazil',76,'America/Sao_Paulo'),(37699,'Белен','Belem','','Brazil',76,'America/Santarem'),(37707,'Белу-Оризонти','Belo Horizonte','','Brazil',76,'America/Sao_Paulo'),(37729,'Блуменау','Blumenau','','Brazil',76,'America/Sao_Paulo'),(37731,'Боа-Виста','Boa Vista','','Brazil',76,'America/Boa_Vista'),(112733,'Бодо','Bodo','','Brazil',76,'America/Fortaleza'),(114189,'Боль','Pains','','Brazil',76,'America/Sao_Paulo'),(37773,'Ботукату','Botucatu','','Brazil',76,'America/Sao_Paulo'),(112802,'Брага','Braga','','Brazil',76,'America/Sao_Paulo'),(37779,'Бразилиа','Brasilia','','Brazil',76,'America/Sao_Paulo'),(112810,'Брауна','Brauna','','Brazil',76,'America/Recife'),(37809,'Бури','Buri','','Brazil',76,'America/Sao_Paulo'),(112823,'Буэнос-Айрес','Buenos Aires','','Brazil',76,'America/Recife'),(114780,'Визеу','Viseu','','Brazil',76,'America/Santarem'),(38985,'Вильена','Vilhena','','Brazil',76,'America/Porto_Velho'),(38997,'Витория','Vitoria','','Brazil',76,'America/Sao_Paulo'),(38385,'Гараньюнс','Garanhuns','','Brazil',76,'America/Recife'),(113574,'Гимарайнш','Guimaraes','','Brazil',76,'America/Fortaleza'),(38447,'Говернадор-Валадарис','Governador Valadares','','Brazil',76,'America/Sao_Paulo'),(38463,'Гояния','Goiania','','Brazil',76,'America/Sao_Paulo'),(38465,'Гравата','Gravata','','Brazil',76,'America/Recife'),(38467,'Граватаи','Gravatai','','Brazil',76,'America/Sao_Paulo'),(113552,'Гуадалупе','Guadalupe','','Brazil',76,'America/Fortaleza'),(38423,'Гуарапуава','Guarapuava','','Brazil',76,'America/Sao_Paulo'),(38243,'Диадема','Diadema','','Brazil',76,'America/Sao_Paulo'),(38249,'Дивинополис','Divinopolis','','Brazil',76,'America/Sao_Paulo'),(38259,'Дорадус','Dourados','','Brazil',76,'America/Campo_Grande'),(114608,'Дуранго','Tabira','','Brazil',76,'America/Recife'),(38765,'Жакареи','Jacarei','','Brazil',76,'America/Sao_Paulo'),(38787,'Жарагуа','Jaragua','','Brazil',76,'America/Sao_Paulo'),(38789,'Жарагуа-ду-Сул','Jaragua do Sul','','Brazil',76,'America/Sao_Paulo'),(38799,'Жару','Jaru','','Brazil',76,'America/Porto_Velho'),(38807,'Жау','Jau','','Brazil',76,'America/Sao_Paulo'),(38743,'Жуан-Песоа','Joao Pessoa','','Brazil',76,'America/Fortaleza'),(38839,'Жуис-ди-Фора','Juiz de Fora','','Brazil',76,'America/Sao_Paulo'),(38509,'Ибирите','Ibirite','','Brazil',76,'America/Sao_Paulo'),(38549,'Ильеус','Ilheus','','Brazil',76,'America/Bahia'),(38555,'Императрис','Imperatriz','','Brazil',76,'America/Fortaleza'),(38571,'Ипатинга','Ipatinga','','Brazil',76,'America/Sao_Paulo'),(38613,'Итабораи','Itaborai','','Brazil',76,'America/Sao_Paulo'),(38615,'Итабуна','Itabuna','','Brazil',76,'America/Bahia'),(113704,'Итапе','Itape','','Brazil',76,'America/Bahia'),(38663,'Итапеви','Itapevi','','Brazil',76,'America/Sao_Paulo'),(113707,'Итапетин','Itapetim','','Brazil',76,'America/Recife'),(38725,'Иту','Itu','','Brazil',76,'America/Sao_Paulo'),(37829,'Кабу-Фриу','Cabo Frio','','Brazil',76,'America/Sao_Paulo'),(112973,'Калдас','Caldas','','Brazil',76,'America/Sao_Paulo'),(37897,'Кампинас','Campinas','','Brazil',76,'America/Sao_Paulo'),(37923,'Кампу-Гранди','Campo Grande','','Brazil',76,'America/Campo_Grande'),(37939,'Канела','Canela','','Brazil',76,'America/Sao_Paulo'),(37985,'Карапикуиба','Carapicuiba','','Brazil',76,'America/Sao_Paulo'),(113099,'Кариасика','Cariacica','','Brazil',76,'America/Sao_Paulo'),(113117,'Каролина','Carolina','','Brazil',76,'America/Fortaleza'),(38017,'Каруару','Caruaru','','Brazil',76,'America/Recife'),(38027,'Каскавел','Cascavel','','Brazil',76,'America/Sao_Paulo'),(113136,'Кастро','Castro','','Brazil',76,'America/Sao_Paulo'),(37857,'Касу','Cacu','','Brazil',76,'America/Sao_Paulo'),(38043,'Катандува','Catanduva','','Brazil',76,'America/Sao_Paulo'),(113142,'Кату','Catu','','Brazil',76,'America/Bahia'),(38049,'Каукая','Caucaia','','Brazil',76,'America/Fortaleza'),(37855,'Кашиас-ду-Сул','Caxias do Sul','','Brazil',76,'America/Sao_Paulo'),(113247,'Коимбра','Coimbra','','Brazil',76,'America/Sao_Paulo'),(113253,'Коломбо','Colombo','','Brazil',76,'America/Sao_Paulo'),(113256,'Колорадо','Colorado','','Brazil',76,'America/Sao_Paulo'),(113252,'Колумбия','Colombia','','Brazil',76,'America/Sao_Paulo'),(38171,'Крисиума','Criciuma','','Brazil',76,'America/Sao_Paulo'),(38193,'Куритиба','Curitiba','','Brazil',76,'America/Sao_Paulo'),(38203,'Куяба','Cuiaba','','Brazil',76,'America/Cuiaba'),(38877,'Лагуна','Laguna','','Brazil',76,'America/Sao_Paulo'),(38895,'Лажис','Lages','','Brazil',76,'America/Sao_Paulo'),(38899,'Леми','Leme','','Brazil',76,'America/Sao_Paulo'),(38907,'Лимейра','Limeira','','Brazil',76,'America/Sao_Paulo'),(38917,'Лондрина','Londrina','','Brazil',76,'America/Sao_Paulo'),(113888,'Лурд','Lourdes','','Brazil',76,'America/Sao_Paulo'),(38923,'Лус','Luz','','Brazil',76,'America/Sao_Paulo'),(113890,'Лусена','Lucena','','Brazil',76,'America/Noronha'),(113962,'Мадура','Maruda','','Brazil',76,'America/Santarem'),(39091,'Макапа','Macapa','','Brazil',76,'America/Belem'),(39103,'Манаус','Manaus','','Brazil',76,'America/Manaus'),(39105,'Манга','Manga','','Brazil',76,'America/Sao_Paulo'),(39119,'Мараба','Maraba','','Brazil',76,'America/Santarem'),(39133,'Мараканау','Maracanau','','Brazil',76,'America/Fortaleza'),(39159,'Маринга','Maringa','','Brazil',76,'America/Sao_Paulo'),(39165,'Масейо','Maceio','','Brazil',76,'America/Maceio'),(39171,'Матан','Matao','','Brazil',76,'America/Sao_Paulo'),(39191,'Медина','Medina','','Brazil',76,'America/Sao_Paulo'),(39211,'Миранда','Miranda','','Brazil',76,'America/Campo_Grande'),(114041,'Монте-Карло','Monte Carlo','','Brazil',76,'America/Sao_Paulo'),(114049,'Монтевидео','Montevideo','','Brazil',76,'America/Fortaleza'),(39253,'Монтис-Кларус','Montes Claros','','Brazil',76,'America/Sao_Paulo'),(114054,'Морено','Moreno','','Brazil',76,'America/Recife'),(114087,'Наблус','Neopolis','','Brazil',76,'America/Maceio'),(39305,'Натал','Natal','','Brazil',76,'America/Fortaleza'),(39347,'Нова-Фрибургу','Nova Friburgo','','Brazil',76,'America/Sao_Paulo'),(39373,'Оливейра','Olimpia','','Brazil',76,'America/Sao_Paulo'),(39375,'Олинда','Olinda','','Brazil',76,'America/Recife'),(114169,'Орлеан','Orleans','','Brazil',76,'America/Sao_Paulo'),(114173,'Оурен','Ourem','','Brazil',76,'America/Santarem'),(39405,'Пайсанду','Paicandu','','Brazil',76,'America/Sao_Paulo'),(39413,'Палмас','Palmas','','Brazil',76,'America/Araguaina'),(114192,'Пальма','Palma','','Brazil',76,'America/Bahia'),(114211,'Панама','Panama','','Brazil',76,'America/Sao_Paulo'),(39431,'Панорама','Panorama','','Brazil',76,'America/Sao_Paulo'),(114221,'Парана','Parana','','Brazil',76,'America/Araguaina'),(39463,'Паранагуа','Paranagua','','Brazil',76,'America/Sao_Paulo'),(114222,'Паранаиба','Paranaiba','','Brazil',76,'America/Campo_Grande'),(39477,'Парнаиба','Parnaiba','','Brazil',76,'America/Fortaleza'),(39489,'Пасу-Фунду','Passo Fundo','','Brazil',76,'America/Sao_Paulo'),(114245,'Пату','Patu','','Brazil',76,'America/Fortaleza'),(39499,'Патус-ди-Минас','Patos de Minas','','Brazil',76,'America/Sao_Paulo'),(39505,'Паулиста','Paulista','','Brazil',76,'America/Recife'),(39525,'Пелотас','Pelotas','','Brazil',76,'America/Sao_Paulo'),(39545,'Петролина','Petrolina','','Brazil',76,'America/Recife'),(39547,'Петрополис','Petropolis','','Brazil',76,'America/Sao_Paulo'),(114379,'Порталегре','Portalegre','','Brazil',76,'America/Fortaleza'),(114383,'Порту','Porto','','Brazil',76,'America/Fortaleza'),(39693,'Порту-Алегри','Porto Alegre','','Brazil',76,'America/Sao_Paulo'),(39695,'Порту-Велью','Porto Velho','','Brazil',76,'America/Porto_Velho'),(39717,'Президенти-Пруденти','Presidente Prudente','','Brazil',76,'America/Sao_Paulo'),(39749,'Ресифи','Recife','','Brazil',76,'America/Recife'),(114479,'Рибейра','Ribeira','','Brazil',76,'America/Sao_Paulo'),(39771,'Рибейран-Прету','Ribeirao Preto','','Brazil',76,'America/Sao_Paulo'),(114499,'Рио-Гранде','Rio Grande','','Brazil',76,'America/Sao_Paulo'),(39813,'Рио-де-Жанейро','Rio de Janeiro','','Brazil',76,'America/Sao_Paulo'),(39777,'Риу-Бранку','Rio Branco','','Brazil',76,'America/Rio_Branco'),(39819,'Рондонополис','Rondonopolis','','Brazil',76,'America/Cuiaba'),(114531,'Росарио','Rosario','','Brazil',76,'America/Fortaleza'),(114553,'Сакраменто','Sacramento','','Brazil',76,'America/Sao_Paulo'),(39833,'Салинас','Salinas','','Brazil',76,'America/Sao_Paulo'),(39831,'Сальвадор','Salvador','','Brazil',76,'America/Bahia'),(39851,'Сан-Луис','Sao Luis','','Brazil',76,'America/Fortaleza'),(39869,'Сан-Паулу','Sao Paulo','','Brazil',76,'America/Sao_Paulo'),(114578,'Санта-Барбара','Santa Barbara','','Brazil',76,'America/Sao_Paulo'),(39941,'Санта-Роза','Santa Rosa','','Brazil',76,'America/Sao_Paulo'),(114587,'Санта-Фе','Santa Fe','','Brazil',76,'America/Rio_Branco'),(40231,'Терезина','Teresina','','Brazil',76,'America/Fortaleza'),(114665,'Тирус','Tiros','','Brazil',76,'America/Sao_Paulo'),(114668,'Толедо','Toledo','','Brazil',76,'America/Sao_Paulo'),(39011,'Уба','Uba','','Brazil',76,'America/Sao_Paulo'),(39021,'Убераба','Uberaba','','Brazil',76,'America/Sao_Paulo'),(114727,'Умари','Umari','','Brazil',76,'America/Fortaleza'),(113460,'Фатима','Fatima','','Brazil',76,'America/Sao_Paulo'),(38347,'Флорианополис','Florianopolis','','Brazil',76,'America/Sao_Paulo'),(38337,'Флорис','Flores','','Brazil',76,'America/Fortaleza'),(38355,'Формига','Formiga','','Brazil',76,'America/Sao_Paulo'),(38361,'Форталеза','Fortaleza','','Brazil',76,'America/Fortaleza'),(113492,'Фортуна','Fortuna','','Brazil',76,'America/Fortaleza'),(38363,'Фос-ду-Игуасу','Foz do Iguacu','','Brazil',76,'America/Sao_Paulo'),(38365,'Франка','Franca','','Brazil',76,'America/Sao_Paulo'),(112261,'Эдирне','Adrianopolis','','Brazil',76,'America/Sao_Paulo'),(113416,'Эльдорадо','Eldorado','','Brazil',76,'America/Sao_Paulo'),(108704,'Род-Таун','Road Town','','British Virgin Islands',93,'America/Tortola'),(4198,'','Fada N','','Burkina Faso',854,'Africa/Ouagadougou'),(4194,'Бобо-Диуласо','Bobo-Dioulasso','','Burkina Faso',854,'Africa/Ouagadougou'),(4197,'Дори','Dori','','Burkina Faso',854,'Africa/Ouagadougou'),(4204,'По','Po','','Burkina Faso',854,'Africa/Ouagadougou'),(4202,'Уагадугу','Ouagadougou','','Burkina Faso',854,'Africa/Ouagadougou'),(4205,'Бужумбура','Bujumbura','','Burundi',108,'Africa/Bujumbura'),(4206,'Муйинга','Muyinga','','Burundi',108,'Africa/Bujumbura'),(8943,'','Saint Catherine','','United Kingdom',826,'Europe/London'),(8949,'','Scilly, Saint Mary','','United Kingdom',826,'Europe/London'),(14887,'Aberaeron','Aberaeron','','United Kingdom',826,'Europe/London'),(14907,'Aberfeldy','Aberfeldy','','United Kingdom',826,'Europe/London'),(14889,'Abergavenny','Abergavenny','','United Kingdom',826,'Europe/London'),(14891,'Abergele','Abergele','','United Kingdom',826,'Europe/London'),(14903,'Abertillery','Abertillery','','United Kingdom',826,'Europe/London'),(14909,'Abingdon','Abingdon','','United Kingdom',826,'Europe/London'),(14923,'Accrington','Accrington','','United Kingdom',826,'Europe/London'),(14919,'Addlestone','Addlestone','','United Kingdom',826,'Europe/London'),(15091,'Airdrie','Airdrie','','United Kingdom',826,'Europe/London'),(15071,'Alcester','Alcester','','United Kingdom',826,'Europe/London'),(15061,'Aldeburgh','Aldeburgh','','United Kingdom',826,'Europe/London'),(15067,'Aldershot','Aldershot','','United Kingdom',826,'Europe/London'),(14953,'Alford','Alford','','United Kingdom',826,'Europe/London'),(14955,'Alfreton','Alfreton','','United Kingdom',826,'Europe/London'),(14943,'Alness','Alness','','United Kingdom',826,'Europe/London'),(14941,'Alnwick','Alnwick','','United Kingdom',826,'Europe/London'),(14945,'Alresford','Alresford','','United Kingdom',826,'Europe/London'),(14949,'Alton','Alton','','United Kingdom',826,'Europe/London'),(14951,'Altrincham','Altrincham','','United Kingdom',826,'Europe/London'),(14957,'Alva','Alva','','United Kingdom',826,'Europe/London'),(14935,'Alyth','Alyth','','United Kingdom',826,'Europe/London'),(14961,'Ambleside','Ambleside','','United Kingdom',826,'Europe/London'),(14963,'Amersham','Amersham','','United Kingdom',826,'Europe/London'),(14965,'Amesbury','Amesbury','','United Kingdom',826,'Europe/London'),(14967,'Ammanford','Ammanford','','United Kingdom',826,'Europe/London'),(14969,'Ampthill','Ampthill','','United Kingdom',826,'Europe/London'),(14971,'Andover','Andover','','United Kingdom',826,'Europe/London'),(14975,'Annan','Annan','','United Kingdom',826,'Europe/London'),(14981,'Anstruther','Anstruther','','United Kingdom',826,'Europe/London'),(14983,'Antrim','Antrim','','United Kingdom',826,'Europe/London'),(14999,'Arlesey','Arlesey','','United Kingdom',826,'Europe/London'),(15009,'Arnold','Arnold','','United Kingdom',826,'Europe/London'),(14991,'Arundel','Arundel','','United Kingdom',826,'Europe/London'),(15017,'Ascot','Ascot','','United Kingdom',826,'Europe/London'),(15041,'Ashbourne','Ashbourne','','United Kingdom',826,'Europe/London'),(15051,'Ashford','Ashford','','United Kingdom',826,'Europe/London'),(15045,'Ashington','Ashington','','United Kingdom',826,'Europe/London'),(15049,'Ashton-under-Lyne','Ashton-under-Lyne','','United Kingdom',826,'Europe/London'),(15019,'Astwood Bank','Astwood Bank','','United Kingdom',826,'Europe/London'),(15029,'Atherstone','Atherstone','','United Kingdom',826,'Europe/London'),(15031,'Atherton','Atherton','','United Kingdom',826,'Europe/London'),(15025,'Attleborough','Attleborough','','United Kingdom',826,'Europe/London'),(15081,'Auchterarder','Auchterarder','','United Kingdom',826,'Europe/London'),(15083,'Auchtermuchty','Auchtermuchty','','United Kingdom',826,'Europe/London'),(14927,'Axbridge','Axbridge','','United Kingdom',826,'Europe/London'),(14929,'Axminster','Axminster','','United Kingdom',826,'Europe/London'),(15305,'Bacup','Bacup','','United Kingdom',826,'Europe/London'),(15291,'Bagshot','Bagshot','','United Kingdom',826,'Europe/London'),(15321,'Bakewell','Bakewell','','United Kingdom',826,'Europe/London'),(15323,'Bala','Bala','','United Kingdom',826,'Europe/London'),(15619,'Baldock','Baldock','','United Kingdom',826,'Europe/London'),(15327,'Ballycastle','Ballycastle','','United Kingdom',826,'Europe/London'),(15625,'Ballyclare','Ballyclare','','United Kingdom',826,'Europe/London'),(15329,'Ballymena','Ballymena','','United Kingdom',826,'Europe/London'),(15331,'Ballymoney','Ballymoney','','United Kingdom',826,'Europe/London'),(15627,'Ballynahinch','Ballynahinch','','United Kingdom',826,'Europe/London'),(15345,'Banbridge','Banbridge','','United Kingdom',826,'Europe/London'),(15343,'Banbury','Banbury','','United Kingdom',826,'Europe/London'),(15359,'Banchory','Banchory','','United Kingdom',826,'Europe/London'),(15347,'Banwell','Banwell','','United Kingdom',826,'Europe/London'),(15361,'Bargoed','Bargoed','','United Kingdom',826,'Europe/London'),(15379,'Barmouth','Barmouth','','United Kingdom',826,'Europe/London'),(15381,'Barnard Castle','Barnard Castle','','United Kingdom',826,'Europe/London'),(15385,'Barnoldswick','Barnoldswick','','United Kingdom',826,'Europe/London'),(15387,'Barnsley','Barnsley','','United Kingdom',826,'Europe/London'),(15389,'Barnstaple','Barnstaple','','United Kingdom',826,'Europe/London'),(15299,'Basildon','Basildon','','United Kingdom',826,'Europe/London'),(15301,'Basingstoke','Basingstoke','','United Kingdom',826,'Europe/London'),(15421,'Bathgate','Bathgate','','United Kingdom',826,'Europe/London'),(15423,'Batley','Batley','','United Kingdom',826,'Europe/London'),(15519,'Beaconsfield','Beaconsfield','','United Kingdom',826,'Europe/London'),(15533,'Beaminster','Beaminster','','United Kingdom',826,'Europe/London'),(15485,'Bearsden','Bearsden','','United Kingdom',826,'Europe/London'),(15459,'Beaumaris','Beaumaris','','United Kingdom',826,'Europe/London'),(15427,'Bebington','Bebington','','United Kingdom',826,'Europe/London'),(15445,'Beccles','Beccles','','United Kingdom',826,'Europe/London'),(15439,'Bedale','Bedale','','United Kingdom',826,'Europe/London'),(15435,'Bedlington','Bedlington','','United Kingdom',826,'Europe/London'),(15437,'Bedworth','Bedworth','','United Kingdom',826,'Europe/London'),(15443,'Beith','Beith','','United Kingdom',826,'Europe/London'),(15451,'Belper','Belper','','United Kingdom',826,'Europe/London'),(15453,'Bembridge','Bembridge','','United Kingdom',826,'Europe/London'),(15429,'Beverley','Beverley','','United Kingdom',826,'Europe/London'),(15799,'Bewdley','Bewdley','','United Kingdom',826,'Europe/London'),(15447,'Bexhill','Bexhill','','United Kingdom',826,'Europe/London'),(15515,'Bicester','Bicester','','United Kingdom',826,'Europe/London'),(15513,'Bideford','Bideford','','United Kingdom',826,'Europe/London'),(15505,'Biggar','Biggar','','United Kingdom',826,'Europe/London'),(15507,'Biggin Hill','Biggin Hill','','United Kingdom',826,'Europe/London'),(15509,'Biggleswade','Biggleswade','','United Kingdom',826,'Europe/London'),(15521,'Billericay','Billericay','','United Kingdom',826,'Europe/London'),(15529,'Billingham','Billingham','','United Kingdom',826,'Europe/London'),(15525,'Billingshurst','Billingshurst','','United Kingdom',826,'Europe/London'),(15469,'Birkenhead','Birkenhead','','United Kingdom',826,'Europe/London'),(15547,'Bishop Auckland','Bishop Auckland','','United Kingdom',826,'Europe/London'),(15561,'Bishopton','Bishopton','','United Kingdom',826,'Europe/London'),(15577,'Blackwood','Blackwood','','United Kingdom',826,'Europe/London'),(15597,'Blairgowrie','Blairgowrie','','United Kingdom',826,'Europe/London'),(15581,'Blandford Forum','Blandford Forum','','United Kingdom',826,'Europe/London'),(15585,'Bletchley','Bletchley','','United Kingdom',826,'Europe/London'),(15573,'Blyth','Blyth','','United Kingdom',826,'Europe/London'),(15611,'Bodmin','Bodmin','','United Kingdom',826,'Europe/London'),(15607,'Bognor Regis','Bognor Regis','','United Kingdom',826,'Europe/London'),(15639,'Bolton','Bolton','','United Kingdom',826,'Europe/London'),(15645,'Bonnybridge','Bonnybridge','','United Kingdom',826,'Europe/London'),(15647,'Bonnyrigg','Bonnyrigg','','United Kingdom',826,'Europe/London'),(15653,'Borehamwood','Borehamwood','','United Kingdom',826,'Europe/London'),(15663,'Bothwell','Bothwell','','United Kingdom',826,'Europe/London'),(15675,'Bow Street','Bow Street','','United Kingdom',826,'Europe/London'),(15709,'Brackley','Brackley','','United Kingdom',826,'Europe/London'),(15781,'Braintree','Braintree','','United Kingdom',826,'Europe/London'),(15719,'Brandon','Brandon','','United Kingdom',826,'Europe/London'),(15763,'Braunton','Braunton','','United Kingdom',826,'Europe/London'),(15727,'Brecon','Brecon','','United Kingdom',826,'Europe/London'),(15737,'Bridge of Weir','Bridge of Weir','','United Kingdom',826,'Europe/London'),(15691,'Bridgnorth','Bridgnorth','','United Kingdom',826,'Europe/London'),(15693,'Bridport','Bridport','','United Kingdom',826,'Europe/London'),(15733,'Brigg','Brigg','','United Kingdom',826,'Europe/London'),(15685,'Brighouse','Brighouse','','United Kingdom',826,'Europe/London'),(15749,'Broadstairs','Broadstairs','','United Kingdom',826,'Europe/London'),(15755,'Brockenhurst','Brockenhurst','','United Kingdom',826,'Europe/London'),(15761,'Bromyard','Bromyard','','United Kingdom',826,'Europe/London'),(15753,'Broseley','Broseley','','United Kingdom',826,'Europe/London'),(15745,'Brough','Brough','','United Kingdom',826,'Europe/London'),(15765,'Broughton','Broughton','','United Kingdom',826,'Europe/London'),(15757,'Broxburn','Broxburn','','United Kingdom',826,'Europe/London'),(15775,'Bruton','Bruton','','United Kingdom',826,'Europe/London'),(15317,'Buckfastleigh','Buckfastleigh','','United Kingdom',826,'Europe/London'),(15787,'Buckingham','Buckingham','','United Kingdom',826,'Europe/London'),(15795,'Bude','Bude','','United Kingdom',826,'Europe/London'),(15295,'Budleigh Salterton','Budleigh Salterton','','United Kingdom',826,'Europe/London'),(15785,'Builth Wells','Builth Wells','','United Kingdom',826,'Europe/London'),(15349,'Bungay','Bungay','','United Kingdom',826,'Europe/London'),(15355,'Buntingford','Buntingford','','United Kingdom',826,'Europe/London'),(15801,'Burgess Hill','Burgess Hill','','United Kingdom',826,'Europe/London'),(15475,'Burnley','Burnley','','United Kingdom',826,'Europe/London'),(15479,'Burntwood','Burntwood','','United Kingdom',826,'Europe/London'),(15397,'Burry Port','Burry Port','','United Kingdom',826,'Europe/London'),(15495,'Burton upon Trent','Burton upon Trent','','United Kingdom',826,'Europe/London'),(15365,'Bury','Bury','','United Kingdom',826,'Europe/London'),(15793,'Bushey','Bushey','','United Kingdom',826,'Europe/London'),(15313,'Buxton','Buxton','','United Kingdom',826,'Europe/London'),(29507,'Caernarfon','Caernarfon','','United Kingdom',826,'Europe/London'),(29349,'Callander','Callander','','United Kingdom',826,'Europe/London'),(29491,'Calne','Calne','','United Kingdom',826,'Europe/London'),(29187,'Camelford','Camelford','','United Kingdom',826,'Europe/London'),(29195,'Cannock','Cannock','','United Kingdom',826,'Europe/London'),(29205,'Carluke','Carluke','','United Kingdom',826,'Europe/London'),(29211,'Carnforth','Carnforth','','United Kingdom',826,'Europe/London'),(29209,'Carnoustie','Carnoustie','','United Kingdom',826,'Europe/London'),(29217,'Carrickfergus','Carrickfergus','','United Kingdom',826,'Europe/London'),(29219,'Carterton','Carterton','','United Kingdom',826,'Europe/London'),(29225,'Castle Cary','Castle Cary','','United Kingdom',826,'Europe/London'),(29223,'Castle Douglas','Castle Douglas','','United Kingdom',826,'Europe/London'),(29235,'Castleford','Castleford','','United Kingdom',826,'Europe/London'),(29227,'Castlewellan','Castlewellan','','United Kingdom',826,'Europe/London'),(29559,'Chapeltown','Chapeltown','','United Kingdom',826,'Europe/London'),(29537,'Chard','Chard','','United Kingdom',826,'Europe/London'),(29549,'Chatteris','Chatteris','','United Kingdom',826,'Europe/London'),(29551,'Cheddar','Cheddar','','United Kingdom',826,'Europe/London'),(29563,'Chelmsford','Chelmsford','','United Kingdom',826,'Europe/London'),(29569,'Chepstow','Chepstow','','United Kingdom',826,'Europe/London'),(29571,'Chertsey','Chertsey','','United Kingdom',826,'Europe/London'),(29581,'Chesham','Chesham','','United Kingdom',826,'Europe/London'),(29583,'Cheshunt','Cheshunt','','United Kingdom',826,'Europe/London'),(29577,'Chester-le-Street','Chester-le-Street','','United Kingdom',826,'Europe/London'),(29579,'Chesterfield','Chesterfield','','United Kingdom',826,'Europe/London'),(29511,'Chigwell','Chigwell','','United Kingdom',826,'Europe/London'),(29523,'Chinnor','Chinnor','','United Kingdom',826,'Europe/London'),(29525,'Chippenham','Chippenham','','United Kingdom',826,'Europe/London'),(29589,'Chipping Campden','Chipping Campden','','United Kingdom',826,'Europe/London'),(29591,'Chipping Norton','Chipping Norton','','United Kingdom',826,'Europe/London'),(29595,'Chipping Sodbury','Chipping Sodbury','','United Kingdom',826,'Europe/London'),(29605,'Chorley','Chorley','','United Kingdom',826,'Europe/London'),(29585,'Church Stretton','Church Stretton','','United Kingdom',826,'Europe/London'),(29501,'Cirencester','Cirencester','','United Kingdom',826,'Europe/London'),(29267,'Clacton-on-Sea','Clacton-on-Sea','','United Kingdom',826,'Europe/London'),(29271,'Clapham','Clapham','','United Kingdom',826,'Europe/London'),(29287,'Cleator Moor','Cleator Moor','','United Kingdom',826,'Europe/London'),(29279,'Cleckheaton','Cleckheaton','','United Kingdom',826,'Europe/London'),(29289,'Cleethorpes','Cleethorpes','','United Kingdom',826,'Europe/London'),(29273,'Clevedon','Clevedon','','United Kingdom',826,'Europe/London'),(29261,'Clitheroe','Clitheroe','','United Kingdom',826,'Europe/London'),(29259,'Clydebank','Clydebank','','United Kingdom',826,'Europe/London'),(29299,'Coalville','Coalville','','United Kingdom',826,'Europe/London'),(29307,'Cobham','Cobham','','United Kingdom',826,'Europe/London'),(29325,'Cockermouth','Cockermouth','','United Kingdom',826,'Europe/London'),(29345,'Coleford','Coleford','','United Kingdom',826,'Europe/London'),(29355,'Coleraine','Coleraine','','United Kingdom',826,'Europe/London'),(29329,'Colinton','Colinton','','United Kingdom',826,'Europe/London'),(29331,'Colwyn Bay','Colwyn Bay','','United Kingdom',826,'Europe/London'),(29347,'Colyton','Colyton','','United Kingdom',826,'Europe/London'),(29361,'Comber','Comber','','United Kingdom',826,'Europe/London'),(29371,'Congleton','Congleton','','United Kingdom',826,'Europe/London'),(29381,'Consett','Consett','','United Kingdom',826,'Europe/London'),(29369,'Conwy','Conwy','','United Kingdom',826,'Europe/London'),(29485,'Cookstown','Cookstown','','United Kingdom',826,'Europe/London'),(29389,'Corbridge','Corbridge','','United Kingdom',826,'Europe/London'),(29393,'Corsham','Corsham','','United Kingdom',826,'Europe/London'),(29403,'Cowbridge','Cowbridge','','United Kingdom',826,'Europe/London'),(29435,'Craigavon','Craigavon','','United Kingdom',826,'Europe/London'),(29423,'Cramlington','Cramlington','','United Kingdom',826,'Europe/London'),(29425,'Cranbrook','Cranbrook','','United Kingdom',826,'Europe/London'),(29427,'Cranleigh','Cranleigh','','United Kingdom',826,'Europe/London'),(29447,'Crawley','Crawley','','United Kingdom',826,'Europe/London'),(29433,'Crediton','Crediton','','United Kingdom',826,'Europe/London'),(29477,'Crewe','Crewe','','United Kingdom',826,'Europe/London'),(29481,'Crewkerne','Crewkerne','','United Kingdom',826,'Europe/London'),(29413,'Criccieth','Criccieth','','United Kingdom',826,'Europe/London'),(29449,'Cromer','Cromer','','United Kingdom',826,'Europe/London'),(29467,'Crowborough','Crowborough','','United Kingdom',826,'Europe/London'),(29471,'Crowthorne','Crowthorne','','United Kingdom',826,'Europe/London'),(29179,'Cullompton','Cullompton','','United Kingdom',826,'Europe/London'),(29185,'Cumbernauld','Cumbernauld','','United Kingdom',826,'Europe/London'),(29189,'Cumnock','Cumnock','','United Kingdom',826,'Europe/London'),(29487,'Cupar','Cupar','','United Kingdom',826,'Europe/London'),(29251,'Cwmbran','Cwmbran','','United Kingdom',826,'Europe/London'),(15115,'Dalbeattie','Dalbeattie','','United Kingdom',826,'Europe/London'),(15117,'Dalry','Dalry','','United Kingdom',826,'Europe/London'),(15171,'Darfield','Darfield','','United Kingdom',826,'Europe/London'),(15165,'Dartmouth','Dartmouth','','United Kingdom',826,'Europe/London'),(15159,'Darvel','Darvel','','United Kingdom',826,'Europe/London'),(15157,'Darwen','Darwen','','United Kingdom',826,'Europe/London'),(15187,'Daventry','Daventry','','United Kingdom',826,'Europe/London'),(15239,'Dawlish','Dawlish','','United Kingdom',826,'Europe/London'),(15189,'Denbigh','Denbigh','','United Kingdom',826,'Europe/London'),(15283,'Denny','Denny','','United Kingdom',826,'Europe/London'),(15193,'Denton','Denton','','United Kingdom',826,'Europe/London'),(15181,'Devizes','Devizes','','United Kingdom',826,'Europe/London'),(15281,'Dewsbury','Dewsbury','','United Kingdom',826,'Europe/London'),(15107,'Didcot','Didcot','','United Kingdom',826,'Europe/London'),(15217,'Dingwall','Dingwall','','United Kingdom',826,'Europe/London'),(15227,'Diss','Diss','','United Kingdom',826,'Europe/London'),(15237,'Dolgellau','Dolgellau','','United Kingdom',826,'Europe/London'),(15243,'Dollar','Dollar','','United Kingdom',826,'Europe/London'),(15245,'Donaghadee','Donaghadee','','United Kingdom',826,'Europe/London'),(15253,'Dorking','Dorking','','United Kingdom',826,'Europe/London'),(15257,'Doune','Doune','','United Kingdom',826,'Europe/London'),(15261,'Downham Market','Downham Market','','United Kingdom',826,'Europe/London'),(15173,'Downpatrick','Downpatrick','','United Kingdom',826,'Europe/London'),(15265,'Driffield','Driffield','','United Kingdom',826,'Europe/London'),(15271,'Droitwich','Droitwich','','United Kingdom',826,'Europe/London'),(15275,'Dromore','Dromore','','United Kingdom',826,'Europe/London'),(15277,'Dronfield','Dronfield','','United Kingdom',826,'Europe/London'),(15273,'Droylsden','Droylsden','','United Kingdom',826,'Europe/London'),(15109,'Dukinfield','Dukinfield','','United Kingdom',826,'Europe/London'),(15127,'Dunblane','Dunblane','','United Kingdom',826,'Europe/London'),(15129,'Dungannon','Dungannon','','United Kingdom',826,'Europe/London'),(15149,'Dunoon','Dunoon','','United Kingdom',826,'Europe/London'),(15141,'Duns','Duns','','United Kingdom',826,'Europe/London'),(15145,'Dunstable','Dunstable','','United Kingdom',826,'Europe/London'),(15201,'Dursley','Dursley','','United Kingdom',826,'Europe/London'),(15223,'Dyce','Dyce','','United Kingdom',826,'Europe/London'),(29615,'Earlston','Earlston','','United Kingdom',826,'Europe/London'),(29633,'East Grinstead','East Grinstead','','United Kingdom',826,'Europe/London'),(29639,'East Kilbride','East Kilbride','','United Kingdom',826,'Europe/London'),(29643,'East Linton','East Linton','','United Kingdom',826,'Europe/London'),(29657,'Eastleigh','Eastleigh','','United Kingdom',826,'Europe/London'),(29669,'Ebbw Vale','Ebbw Vale','','United Kingdom',826,'Europe/London'),(29697,'Eccles','Eccles','','United Kingdom',826,'Europe/London'),(29683,'Edenbridge','Edenbridge','','United Kingdom',826,'Europe/London'),(29743,'Egham','Egham','','United Kingdom',826,'Europe/London'),(29679,'Egremont','Egremont','','United Kingdom',826,'Europe/London'),(29709,'Elland','Elland','','United Kingdom',826,'Europe/London'),(29711,'Ellesmere','Ellesmere','','United Kingdom',826,'Europe/London'),(29713,'Ellesmere Port','Ellesmere Port','','United Kingdom',826,'Europe/London'),(29715,'Ellon','Ellon','','United Kingdom',826,'Europe/London'),(29729,'Emsworth','Emsworth','','United Kingdom',826,'Europe/London'),(29735,'Epping','Epping','','United Kingdom',826,'Europe/London'),(29741,'Esher','Esher','','United Kingdom',826,'Europe/London'),(29675,'Evesham','Evesham','','United Kingdom',826,'Europe/London'),(29859,'Failsworth','Failsworth','','United Kingdom',826,'Europe/London'),(29861,'Fairlight','Fairlight','','United Kingdom',826,'Europe/London'),(29749,'Fakenham','Fakenham','','United Kingdom',826,'Europe/London'),(29753,'Falmouth','Falmouth','','United Kingdom',826,'Europe/London'),(29773,'Fareham','Fareham','','United Kingdom',826,'Europe/London'),(29755,'Faringdon','Faringdon','','United Kingdom',826,'Europe/London'),(29763,'Farnham','Farnham','','United Kingdom',826,'Europe/London'),(29761,'Farnworth','Farnworth','','United Kingdom',826,'Europe/London'),(29769,'Faversham','Faversham','','United Kingdom',826,'Europe/London'),(29775,'Felling','Felling','','United Kingdom',826,'Europe/London'),(29779,'Ferndale','Ferndale','','United Kingdom',826,'Europe/London'),(29785,'Ferryhill','Ferryhill','','United Kingdom',826,'Europe/London'),(29787,'Filey','Filey','','United Kingdom',826,'Europe/London'),(29801,'Fishguard','Fishguard','','United Kingdom',826,'Europe/London'),(29815,'Fleet','Fleet','','United Kingdom',826,'Europe/London'),(29813,'Fleetwood','Fleetwood','','United Kingdom',826,'Europe/London'),(29811,'Flint','Flint','','United Kingdom',826,'Europe/London'),(29823,'Fordingbridge','Fordingbridge','','United Kingdom',826,'Europe/London'),(29825,'Forest Row','Forest Row','','United Kingdom',826,'Europe/London'),(29827,'Formby','Formby','','United Kingdom',826,'Europe/London'),(29829,'Forres','Forres','','United Kingdom',826,'Europe/London'),(29767,'Fowey','Fowey','','United Kingdom',826,'Europe/London'),(29841,'Fraserburgh','Fraserburgh','','United Kingdom',826,'Europe/London'),(29853,'Freshwater','Freshwater','','United Kingdom',826,'Europe/London'),(29845,'Frinton-on-Sea','Frinton-on-Sea','','United Kingdom',826,'Europe/London'),(29843,'Frizington','Frizington','','United Kingdom',826,'Europe/London'),(29855,'Frodsham','Frodsham','','United Kingdom',826,'Europe/London'),(29857,'Frome','Frome','','United Kingdom',826,'Europe/London'),(30005,'Gainsborough','Gainsborough','','United Kingdom',826,'Europe/London'),(29885,'Gateshead','Gateshead','','United Kingdom',826,'Europe/London'),(30013,'Gillingham','Gillingham','','United Kingdom',826,'Europe/London'),(30019,'Girvan','Girvan','','United Kingdom',826,'Europe/London'),(29907,'Glossop','Glossop','','United Kingdom',826,'Europe/London'),(29915,'Godalming','Godalming','','United Kingdom',826,'Europe/London'),(29919,'Godstone','Godstone','','United Kingdom',826,'Europe/London'),(29995,'Goodwick','Goodwick','','United Kingdom',826,'Europe/London'),(29999,'Goole','Goole','','United Kingdom',826,'Europe/London'),(29927,'Gorebridge','Gorebridge','','United Kingdom',826,'Europe/London'),(29937,'Gosforth','Gosforth','','United Kingdom',826,'Europe/London'),(29935,'Gosport','Gosport','','United Kingdom',826,'Europe/London'),(29921,'Gourock','Gourock','','United Kingdom',826,'Europe/London'),(29943,'Grangemouth','Grangemouth','','United Kingdom',826,'Europe/London'),(29945,'Grantham','Grantham','','United Kingdom',826,'Europe/London'),(29939,'Gravesend','Gravesend','','United Kingdom',826,'Europe/London'),(29949,'Grays','Grays','','United Kingdom',826,'Europe/London'),(29971,'Great Missenden','Great Missenden','','United Kingdom',826,'Europe/London'),(29973,'Great Sankey','Great Sankey','','United Kingdom',826,'Europe/London'),(29997,'Guisborough','Guisborough','','United Kingdom',826,'Europe/London'),(29867,'Gullane','Gullane','','United Kingdom',826,'Europe/London'),(29875,'Gunnislake','Gunnislake','','United Kingdom',826,'Europe/London'),(30103,'Haddington','Haddington','','United Kingdom',826,'Europe/London'),(30367,'Hailsham','Hailsham','','United Kingdom',826,'Europe/London'),(30141,'Halesowen','Halesowen','','United Kingdom',826,'Europe/London'),(30227,'Halesworth','Halesworth','','United Kingdom',826,'Europe/London'),(30089,'Halifax','Halifax','','United Kingdom',826,'Europe/London'),(30143,'Halstead','Halstead','','United Kingdom',826,'Europe/London'),(30145,'Haltwhistle','Haltwhistle','','United Kingdom',826,'Europe/London'),(30177,'Harleston','Harleston','','United Kingdom',826,'Europe/London'),(30181,'Harpenden','Harpenden','','United Kingdom',826,'Europe/London'),(30185,'Harrogate','Harrogate','','United Kingdom',826,'Europe/London'),(30193,'Hartlepool','Hartlepool','','United Kingdom',826,'Europe/London'),(30173,'Harwich','Harwich','','United Kingdom',826,'Europe/London'),(30199,'Haslemere','Haslemere','','United Kingdom',826,'Europe/London'),(30095,'Havant','Havant','','United Kingdom',826,'Europe/London'),(30223,'Haverhill','Haverhill','','United Kingdom',826,'Europe/London'),(30365,'Hayle','Hayle','','United Kingdom',826,'Europe/London'),(30361,'Haywards Heath','Haywards Heath','','United Kingdom',826,'Europe/London'),(30281,'Heanor','Heanor','','United Kingdom',826,'Europe/London'),(30217,'Hebden Bridge','Hebden Bridge','','United Kingdom',826,'Europe/London'),(30237,'Heckmondwike','Heckmondwike','','United Kingdom',826,'Europe/London'),(30253,'Hemel Hempstead','Hemel Hempstead','','United Kingdom',826,'Europe/London'),(30375,'Henfield','Henfield','','United Kingdom',826,'Europe/London'),(30373,'Henlow','Henlow','','United Kingdom',826,'Europe/London'),(30255,'Hereford','Hereford','','United Kingdom',826,'Europe/London'),(30377,'Herne Bay','Herne Bay','','United Kingdom',826,'Europe/London'),(30195,'Hertford','Hertford','','United Kingdom',826,'Europe/London'),(30261,'Heswall','Heswall','','United Kingdom',826,'Europe/London'),(30239,'Hexham','Hexham','','United Kingdom',826,'Europe/London'),(30221,'Heywood','Heywood','','United Kingdom',826,'Europe/London'),(30113,'High Wycombe','High Wycombe','','United Kingdom',826,'Europe/London'),(30279,'Hinckley','Hinckley','','United Kingdom',826,'Europe/London'),(30277,'Hindhead','Hindhead','','United Kingdom',826,'Europe/London'),(30275,'Hindley','Hindley','','United Kingdom',826,'Europe/London'),(30287,'Hitchin','Hitchin','','United Kingdom',826,'Europe/London'),(30299,'Hockley','Hockley','','United Kingdom',826,'Europe/London'),(30291,'Hoddesdon','Hoddesdon','','United Kingdom',826,'Europe/London'),(30313,'Holsworthy','Holsworthy','','United Kingdom',826,'Europe/London'),(30307,'Holyhead','Holyhead','','United Kingdom',826,'Europe/London'),(30301,'Holywell','Holywell','','United Kingdom',826,'Europe/London'),(30303,'Holywood','Holywood','','United Kingdom',826,'Europe/London'),(30317,'Honiton','Honiton','','United Kingdom',826,'Europe/London'),(30331,'Horncastle','Horncastle','','United Kingdom',826,'Europe/London'),(30333,'Hornsea','Hornsea','','United Kingdom',826,'Europe/London'),(30341,'Horsham','Horsham','','United Kingdom',826,'Europe/London'),(30343,'Houghton le Spring','Houghton le Spring','','United Kingdom',826,'Europe/London'),(30101,'Huddersfield','Huddersfield','','United Kingdom',826,'Europe/London'),(30157,'Hungerford','Hungerford','','United Kingdom',826,'Europe/London'),(30163,'Hunstanton','Hunstanton','','United Kingdom',826,'Europe/London'),(30165,'Huntingdon','Huntingdon','','United Kingdom',826,'Europe/London'),(30167,'Huntly','Huntly','','United Kingdom',826,'Europe/London'),(30121,'Hyde','Hyde','','United Kingdom',826,'Europe/London'),(30271,'Hythe','Hythe','','United Kingdom',826,'Europe/London'),(30041,'Ilfracombe','Ilfracombe','','United Kingdom',826,'Europe/London'),(30035,'Ilkeston','Ilkeston','','United Kingdom',826,'Europe/London'),(30037,'Ilkley','Ilkley','','United Kingdom',826,'Europe/London'),(30039,'Ilminster','Ilminster','','United Kingdom',826,'Europe/London'),(30045,'Immingham','Immingham','','United Kingdom',826,'Europe/London'),(30053,'Ingatestone','Ingatestone','','United Kingdom',826,'Europe/London'),(30063,'Innerleithen','Innerleithen','','United Kingdom',826,'Europe/London'),(30069,'Insch','Insch','','United Kingdom',826,'Europe/London'),(30047,'Inverurie','Inverurie','','United Kingdom',826,'Europe/London'),(30027,'Iver','Iver','','United Kingdom',826,'Europe/London'),(30029,'Ivybridge','Ivybridge','','United Kingdom',826,'Europe/London'),(15839,'Jarrow','Jarrow','','United Kingdom',826,'Europe/London'),(15845,'Johnstone','Johnstone','','United Kingdom',826,'Europe/London'),(30455,'Keighley','Keighley','','United Kingdom',826,'Europe/London'),(30531,'Keith','Keith','','United Kingdom',826,'Europe/London'),(30399,'Kelty','Kelty','','United Kingdom',826,'Europe/London'),(30409,'Kendal','Kendal','','United Kingdom',826,'Europe/London'),(30411,'Kenilworth','Kenilworth','','United Kingdom',826,'Europe/London'),(30429,'Kettering','Kettering','','United Kingdom',826,'Europe/London'),(30439,'Kidderminster','Kidderminster','','United Kingdom',826,'Europe/London'),(30441,'Kidlington','Kidlington','','United Kingdom',826,'Europe/London'),(30443,'Kidsgrove','Kidsgrove','','United Kingdom',826,'Europe/London'),(30437,'Kidwelly','Kidwelly','','United Kingdom',826,'Europe/London'),(30465,'Kilmacolm','Kilmacolm','','United Kingdom',826,'Europe/London'),(30473,'Kilsyth','Kilsyth','','United Kingdom',826,'Europe/London'),(30453,'Kilwinning','Kilwinning','','United Kingdom',826,'Europe/London'),(30481,'Kings Langley','Kings Langley','','United Kingdom',826,'Europe/London'),(30485,'Kingsbridge','Kingsbridge','','United Kingdom',826,'Europe/London'),(30487,'Kingswood','Kingswood','','United Kingdom',826,'Europe/London'),(30497,'Kington','Kington','','United Kingdom',826,'Europe/London'),(30501,'Kinross','Kinross','','United Kingdom',826,'Europe/London'),(30511,'Kirkby','Kirkby','','United Kingdom',826,'Europe/London'),(30515,'Kirkby Stephen','Kirkby Stephen','','United Kingdom',826,'Europe/London'),(30421,'Kirkcaldy','Kirkcaldy','','United Kingdom',826,'Europe/London'),(30423,'Kirkcudbright','Kirkcudbright','','United Kingdom',826,'Europe/London'),(30523,'Kirkliston','Kirkliston','','United Kingdom',826,'Europe/London'),(30525,'Kirknewton','Kirknewton','','United Kingdom',826,'Europe/London'),(30535,'Knebworth','Knebworth','','United Kingdom',826,'Europe/London'),(30533,'Knighton','Knighton','','United Kingdom',826,'Europe/London'),(30537,'Knottingley','Knottingley','','United Kingdom',826,'Europe/London'),(30539,'Knutsford','Knutsford','','United Kingdom',826,'Europe/London'),(30553,'Lampeter','Lampeter','','United Kingdom',826,'Europe/London'),(30555,'Lanark','Lanark','','United Kingdom',826,'Europe/London'),(30559,'Langholm','Langholm','','United Kingdom',826,'Europe/London'),(30561,'Langport','Langport','','United Kingdom',826,'Europe/London'),(30573,'Larkhall','Larkhall','','United Kingdom',826,'Europe/London'),(30767,'Launceston','Launceston','','United Kingdom',826,'Europe/London'),(30769,'Laurencekirk','Laurencekirk','','United Kingdom',826,'Europe/London'),(30679,'Leatherhead','Leatherhead','','United Kingdom',826,'Europe/London'),(30583,'Ledbury','Ledbury','','United Kingdom',826,'Europe/London'),(30631,'Leek','Leek','','United Kingdom',826,'Europe/London'),(30615,'Leigh','Leigh','','United Kingdom',826,'Europe/London'),(30661,'Leighton Buzzard','Leighton Buzzard','','United Kingdom',826,'Europe/London'),(30593,'Leiston','Leiston','','United Kingdom',826,'Europe/London'),(30603,'Leominster','Leominster','','United Kingdom',826,'Europe/London'),(30613,'Letchworth','Letchworth','','United Kingdom',826,'Europe/London'),(30581,'Leven','Leven','','United Kingdom',826,'Europe/London'),(30797,'Lewes','Lewes','','United Kingdom',826,'Europe/London'),(30589,'Leyland','Leyland','','United Kingdom',826,'Europe/London'),(30633,'Limavady','Limavady','','United Kingdom',826,'Europe/London'),(30643,'Lingfield','Lingfield','','United Kingdom',826,'Europe/London'),(30681,'Liphook','Liphook','','United Kingdom',826,'Europe/London'),(30655,'Liskeard','Liskeard','','United Kingdom',826,'Europe/London'),(30659,'Liss','Liss','','United Kingdom',826,'Europe/London'),(30675,'Littlehampton','Littlehampton','','United Kingdom',826,'Europe/London'),(30621,'Livingston','Livingston','','United Kingdom',826,'Europe/London'),(30697,'Llandeilo','Llandeilo','','United Kingdom',826,'Europe/London'),(30703,'Llandovery','Llandovery','','United Kingdom',826,'Europe/London'),(30705,'Llandrindod Wells','Llandrindod Wells','','United Kingdom',826,'Europe/London'),(30701,'Llandudno','Llandudno','','United Kingdom',826,'Europe/London'),(30707,'Llanelli','Llanelli','','United Kingdom',826,'Europe/London'),(30723,'Llanfairfechan','Llanfairfechan','','United Kingdom',826,'Europe/London'),(30693,'Llangefni','Llangefni','','United Kingdom',826,'Europe/London'),(30695,'Llangollen','Llangollen','','United Kingdom',826,'Europe/London'),(30687,'Llanidloes','Llanidloes','','United Kingdom',826,'Europe/London'),(30711,'Llanrwst','Llanrwst','','United Kingdom',826,'Europe/London'),(30715,'Llantwit Major','Llantwit Major','','United Kingdom',826,'Europe/London'),(30729,'Loanhead','Loanhead','','United Kingdom',826,'Europe/London'),(30785,'Lochgelly','Lochgelly','','United Kingdom',826,'Europe/London'),(30783,'Lochwinnoch','Lochwinnoch','','United Kingdom',826,'Europe/London'),(30741,'Long Eaton','Long Eaton','','United Kingdom',826,'Europe/London'),(30765,'Longfield','Longfield','','United Kingdom',826,'Europe/London'),(30791,'Looe','Looe','','United Kingdom',826,'Europe/London'),(30771,'Lostwithiel','Lostwithiel','','United Kingdom',826,'Europe/London'),(30579,'Loughborough','Loughborough','','United Kingdom',826,'Europe/London'),(30577,'Louth','Louth','','United Kingdom',826,'Europe/London'),(30547,'Ludlow','Ludlow','','United Kingdom',826,'Europe/London'),(30575,'Lutterworth','Lutterworth','','United Kingdom',826,'Europe/London'),(30625,'Lydd','Lydd','','United Kingdom',826,'Europe/London'),(30635,'Lymington','Lymington','','United Kingdom',826,'Europe/London'),(30639,'Lymm','Lymm','','United Kingdom',826,'Europe/London'),(30645,'Lyndhurst','Lyndhurst','','United Kingdom',826,'Europe/London'),(30819,'Macclesfield','Macclesfield','','United Kingdom',826,'Europe/London'),(30821,'Machynlleth','Machynlleth','','United Kingdom',826,'Europe/London'),(30807,'Maesteg','Maesteg','','United Kingdom',826,'Europe/London'),(30803,'Maghera','Maghera','','United Kingdom',826,'Europe/London'),(30805,'Magherafelt','Magherafelt','','United Kingdom',826,'Europe/London'),(30913,'Maidenhead','Maidenhead','','United Kingdom',826,'Europe/London'),(30997,'Maldon','Maldon','','United Kingdom',826,'Europe/London'),(30835,'Malmesbury','Malmesbury','','United Kingdom',826,'Europe/London'),(30833,'Malton','Malton','','United Kingdom',826,'Europe/London'),(30837,'Mangotsfield','Mangotsfield','','United Kingdom',826,'Europe/London'),(30845,'Manningtree','Manningtree','','United Kingdom',826,'Europe/London'),(30847,'Mansfield','Mansfield','','United Kingdom',826,'Europe/London'),(30895,'March','March','','United Kingdom',826,'Europe/London'),(30851,'Margate','Margate','','United Kingdom',826,'Europe/London'),(30863,'Market Drayton','Market Drayton','','United Kingdom',826,'Europe/London'),(30869,'Market Harborough','Market Harborough','','United Kingdom',826,'Europe/London'),(30867,'Market Rasen','Market Rasen','','United Kingdom',826,'Europe/London'),(30879,'Marlborough','Marlborough','','United Kingdom',826,'Europe/London'),(30881,'Marlow','Marlow','','United Kingdom',826,'Europe/London'),(30893,'Martock','Martock','','United Kingdom',826,'Europe/London'),(30855,'Maryport','Maryport','','United Kingdom',826,'Europe/London'),(30905,'Matlock','Matlock','','United Kingdom',826,'Europe/London'),(31021,'Mauchline','Mauchline','','United Kingdom',826,'Europe/London'),(31023,'Maybole','Maybole','','United Kingdom',826,'Europe/London'),(31027,'Mayfield','Mayfield','','United Kingdom',826,'Europe/London'),(30921,'Melksham','Melksham','','United Kingdom',826,'Europe/London'),(30929,'Melton Mowbray','Melton Mowbray','','United Kingdom',826,'Europe/London'),(30933,'Menai Bridge','Menai Bridge','','United Kingdom',826,'Europe/London'),(30917,'Mexborough','Mexborough','','United Kingdom',826,'Europe/London'),(30951,'Middleton','Middleton','','United Kingdom',826,'Europe/London'),(30953,'Middlewich','Middlewich','','United Kingdom',826,'Europe/London'),(30957,'Midhurst','Midhurst','','United Kingdom',826,'Europe/London'),(30811,'Millom','Millom','','United Kingdom',826,'Europe/London'),(30971,'Milnthorpe','Milnthorpe','','United Kingdom',826,'Europe/London'),(30975,'Minehead','Minehead','','United Kingdom',826,'Europe/London'),(30981,'Mirfield','Mirfield','','United Kingdom',826,'Europe/London'),(31019,'Moffat','Moffat','','United Kingdom',826,'Europe/London'),(31001,'Montrose','Montrose','','United Kingdom',826,'Europe/London'),(31003,'Morecambe','Morecambe','','United Kingdom',826,'Europe/London'),(31007,'Morley','Morley','','United Kingdom',826,'Europe/London'),(31009,'Morpeth','Morpeth','','United Kingdom',826,'Europe/London'),(31011,'Mossley','Mossley','','United Kingdom',826,'Europe/London'),(30909,'Much Wenlock','Much Wenlock','','United Kingdom',826,'Europe/London'),(31029,'Muir of Ord','Muir of Ord','','United Kingdom',826,'Europe/London'),(31039,'Nantwich','Nantwich','','United Kingdom',826,'Europe/London'),(31041,'Narberth','Narberth','','United Kingdom',826,'Europe/London'),(31071,'Neath','Neath','','United Kingdom',826,'Europe/London'),(31055,'Nelson','Nelson','','United Kingdom',826,'Europe/London'),(31057,'Neston','Neston','','United Kingdom',826,'Europe/London'),(31113,'New Tredegar','New Tredegar','','United Kingdom',826,'Europe/London'),(31145,'Newbiggin-by-the-Sea','Newbiggin-by-the-Sea','','United Kingdom',826,'Europe/London'),(31143,'Newburn','Newburn','','United Kingdom',826,'Europe/London'),(31119,'Newcastle Emlyn','Newcastle Emlyn','','United Kingdom',826,'Europe/London'),(31149,'Newent','Newent','','United Kingdom',826,'Europe/London'),(31159,'Newmilns','Newmilns','','United Kingdom',826,'Europe/London'),(31121,'Newport Pagnell','Newport Pagnell','','United Kingdom',826,'Europe/London'),(31155,'Newquay','Newquay','','United Kingdom',826,'Europe/London'),(31133,'Newton Abbot','Newton Abbot','','United Kingdom',826,'Europe/London'),(31171,'Newton Aycliffe','Newton Aycliffe','','United Kingdom',826,'Europe/London'),(31131,'Newton Stewart','Newton Stewart','','United Kingdom',826,'Europe/London'),(31173,'Newton-le-Willows','Newton-le-Willows','','United Kingdom',826,'Europe/London'),(31163,'Newtown','Newtown','','United Kingdom',826,'Europe/London'),(31127,'Newtownabbey','Newtownabbey','','United Kingdom',826,'Europe/London'),(31129,'Newtownards','Newtownards','','United Kingdom',826,'Europe/London'),(31085,'North Ferriby','North Ferriby','','United Kingdom',826,'Europe/London'),(31087,'North Shields','North Shields','','United Kingdom',826,'Europe/London'),(31083,'North Walsham','North Walsham','','United Kingdom',826,'Europe/London'),(31091,'Northallerton','Northallerton','','United Kingdom',826,'Europe/London'),(31095,'Northwich','Northwich','','United Kingdom',826,'Europe/London'),(31037,'Nuneaton','Nuneaton','','United Kingdom',826,'Europe/London'),(31193,'Oakham','Oakham','','United Kingdom',826,'Europe/London'),(31195,'Okehampton','Okehampton','','United Kingdom',826,'Europe/London'),(31207,'Oldham','Oldham','','United Kingdom',826,'Europe/London'),(31211,'Olney','Olney','','United Kingdom',826,'Europe/London'),(31217,'Ormskirk','Ormskirk','','United Kingdom',826,'Europe/London'),(31221,'Ossett','Ossett','','United Kingdom',826,'Europe/London'),(31219,'Oswestry','Oswestry','','United Kingdom',826,'Europe/London'),(31225,'Otley','Otley','','United Kingdom',826,'Europe/London'),(31199,'Oxted','Oxted','','United Kingdom',826,'Europe/London'),(31237,'Padstow','Padstow','','United Kingdom',826,'Europe/London'),(31427,'Paignton','Paignton','','United Kingdom',826,'Europe/London'),(31255,'Par','Par','','United Kingdom',826,'Europe/London'),(31319,'Peebles','Peebles','','United Kingdom',826,'Europe/London'),(31279,'Pembroke','Pembroke','','United Kingdom',826,'Europe/London'),(31281,'Pembroke Dock','Pembroke Dock','','United Kingdom',826,'Europe/London'),(31283,'Penarth','Penarth','','United Kingdom',826,'Europe/London'),(31287,'Penicuik','Penicuik','','United Kingdom',826,'Europe/London'),(31299,'Penrith','Penrith','','United Kingdom',826,'Europe/London'),(31297,'Penryn','Penryn','','United Kingdom',826,'Europe/London'),(31285,'Penzance','Penzance','','United Kingdom',826,'Europe/London'),(31309,'Perranporth','Perranporth','','United Kingdom',826,'Europe/London'),(31313,'Peterlee','Peterlee','','United Kingdom',826,'Europe/London'),(31315,'Petersfield','Petersfield','','United Kingdom',826,'Europe/London'),(31317,'Petworth','Petworth','','United Kingdom',826,'Europe/London'),(31431,'Pewsey','Pewsey','','United Kingdom',826,'Europe/London'),(31323,'Pickering','Pickering','','United Kingdom',826,'Europe/London'),(31353,'Pontefract','Pontefract','','United Kingdom',826,'Europe/London'),(31359,'Pontypridd','Pontypridd','','United Kingdom',826,'Europe/London'),(31423,'Poole','Poole','','United Kingdom',826,'Europe/London'),(31365,'Port Glasgow','Port Glasgow','','United Kingdom',826,'Europe/London'),(31377,'Porthcawl','Porthcawl','','United Kingdom',826,'Europe/London'),(31383,'Porthmadog','Porthmadog','','United Kingdom',826,'Europe/London'),(31385,'Portree','Portree','','United Kingdom',826,'Europe/London'),(31393,'Portstewart','Portstewart','','United Kingdom',826,'Europe/London'),(31395,'Potters Bar','Potters Bar','','United Kingdom',826,'Europe/London'),(31401,'Prescot','Prescot','','United Kingdom',826,'Europe/London'),(31403,'Prestatyn','Prestatyn','','United Kingdom',826,'Europe/London'),(31413,'Prestonpans','Prestonpans','','United Kingdom',826,'Europe/London'),(31417,'Princes Risborough','Princes Risborough','','United Kingdom',826,'Europe/London'),(31421,'Prudhoe','Prudhoe','','United Kingdom',826,'Europe/London'),(31235,'Pudsey','Pudsey','','United Kingdom',826,'Europe/London'),(31245,'Pulborough','Pulborough','','United Kingdom',826,'Europe/London'),(31265,'Pwllheli','Pwllheli','','United Kingdom',826,'Europe/London'),(15831,'Queenborough','Queenborough','','United Kingdom',826,'Europe/London'),(31439,'Radcliffe','Radcliffe','','United Kingdom',826,'Europe/London'),(31445,'Radlett','Radlett','','United Kingdom',826,'Europe/London'),(31457,'Ramsgate','Ramsgate','','United Kingdom',826,'Europe/London'),(31555,'Rawtenstall','Rawtenstall','','United Kingdom',826,'Europe/London'),(31481,'Redcar','Redcar','','United Kingdom',826,'Europe/London'),(31479,'Redditch','Redditch','','United Kingdom',826,'Europe/London'),(31485,'Redhill','Redhill','','United Kingdom',826,'Europe/London'),(31489,'Reigate','Reigate','','United Kingdom',826,'Europe/London'),(31497,'Retford','Retford','','United Kingdom',826,'Europe/London'),(31589,'Rhayader','Rhayader','','United Kingdom',826,'Europe/London'),(31543,'Rhondda','Rhondda','','United Kingdom',826,'Europe/London'),(31503,'Rickmansworth','Rickmansworth','','United Kingdom',826,'Europe/London'),(31505,'Ringwood','Ringwood','','United Kingdom',826,'Europe/London'),(31525,'Robertsbridge','Robertsbridge','','United Kingdom',826,'Europe/London'),(31573,'Rochester','Rochester','','United Kingdom',826,'Europe/London'),(31575,'Rochford','Rochford','','United Kingdom',826,'Europe/London'),(31539,'Romsey','Romsey','','United Kingdom',826,'Europe/London'),(31557,'Rotherham','Rotherham','','United Kingdom',826,'Europe/London'),(31565,'Rowlands Gill','Rowlands Gill','','United Kingdom',826,'Europe/London'),(31577,'Royal Tunbridge Wells','Royal Tunbridge Wells','','United Kingdom',826,'Europe/London'),(31533,'Royston','Royston','','United Kingdom',826,'Europe/London'),(31473,'Rugby','Rugby','','United Kingdom',826,'Europe/London'),(31581,'Rugeley','Rugeley','','United Kingdom',826,'Europe/London'),(31463,'Runcorn','Runcorn','','United Kingdom',826,'Europe/London'),(31583,'Rushden','Rushden','','United Kingdom',826,'Europe/London'),(31449,'Ryde','Ryde','','United Kingdom',826,'Europe/London'),(31513,'Ryton','Ryton','','United Kingdom',826,'Europe/London'),(31695,'Saffron Walden','Saffron Walden','','United Kingdom',826,'Europe/London'),(31745,'Saint Austell','Saint Austell','','United Kingdom',826,'Europe/London'),(31749,'Saint Helens','Saint Helens','','United Kingdom',826,'Europe/London'),(31813,'Salcombe','Salcombe','','United Kingdom',826,'Europe/London'),(31723,'Sale','Sale','','United Kingdom',826,'Europe/London'),(31621,'Saltash','Saltash','','United Kingdom',826,'Europe/London'),(31623,'Saltburn-by-the-Sea','Saltburn-by-the-Sea','','United Kingdom',826,'Europe/London'),(31625,'Saltcoats','Saltcoats','','United Kingdom',826,'Europe/London'),(31635,'Sandbach','Sandbach','','United Kingdom',826,'Europe/London'),(31633,'Sandown','Sandown','','United Kingdom',826,'Europe/London'),(31733,'Sandwich','Sandwich','','United Kingdom',826,'Europe/London'),(31735,'Sandy','Sandy','','United Kingdom',826,'Europe/London'),(31639,'Sanquhar','Sanquhar','','United Kingdom',826,'Europe/London'),(31823,'Saundersfoot','Saundersfoot','','United Kingdom',826,'Europe/London'),(31619,'Saxmundham','Saxmundham','','United Kingdom',826,'Europe/London'),(31781,'Scarborough','Scarborough','','United Kingdom',826,'Europe/London'),(31779,'Scunthorpe','Scunthorpe','','United Kingdom',826,'Europe/London'),(31773,'Seaford','Seaford','','United Kingdom',826,'Europe/London'),(31775,'Seaham','Seaham','','United Kingdom',826,'Europe/London'),(31765,'Seascale','Seascale','','United Kingdom',826,'Europe/London'),(31767,'Seaton','Seaton','','United Kingdom',826,'Europe/London'),(31755,'Seaview','Seaview','','United Kingdom',826,'Europe/London'),(31725,'Selby','Selby','','United Kingdom',826,'Europe/London'),(31751,'Settle','Settle','','United Kingdom',826,'Europe/London'),(31713,'Seven Sisters','Seven Sisters','','United Kingdom',826,'Europe/London'),(31715,'Sevenoaks','Sevenoaks','','United Kingdom',826,'Europe/London'),(31973,'Shaftesbury','Shaftesbury','','United Kingdom',826,'Europe/London'),(31983,'Shepperton','Shepperton','','United Kingdom',826,'Europe/London'),(31603,'Shepton Mallet','Shepton Mallet','','United Kingdom',826,'Europe/London'),(31991,'Sherborne','Sherborne','','United Kingdom',826,'Europe/London'),(31995,'Sheringham','Sheringham','','United Kingdom',826,'Europe/London'),(32015,'Shifnal','Shifnal','','United Kingdom',826,'Europe/London'),(31999,'Shildon','Shildon','','United Kingdom',826,'Europe/London'),(32003,'Shipley','Shipley','','United Kingdom',826,'Europe/London'),(31771,'Sittingbourne','Sittingbourne','','United Kingdom',826,'Europe/London'),(31783,'Skegness','Skegness','','United Kingdom',826,'Europe/London'),(31787,'Skelmersdale','Skelmersdale','','United Kingdom',826,'Europe/London'),(31789,'Skelmorlie','Skelmorlie','','United Kingdom',826,'Europe/London'),(31803,'Sleaford','Sleaford','','United Kingdom',826,'Europe/London'),(31801,'Slough','Slough','','United Kingdom',826,'Europe/London'),(31807,'Snodland','Snodland','','United Kingdom',826,'Europe/London'),(31811,'Solihull','Solihull','','United Kingdom',826,'Europe/London'),(31819,'Somerton','Somerton','','United Kingdom',826,'Europe/London'),(31665,'South Brent','South Brent','','United Kingdom',826,'Europe/London'),(31673,'South Molton','South Molton','','United Kingdom',826,'Europe/London'),(31677,'South Ockendon','South Ockendon','','United Kingdom',826,'Europe/London'),(31679,'South Petherton','South Petherton','','United Kingdom',826,'Europe/London'),(31687,'South Shields','South Shields','','United Kingdom',826,'Europe/London'),(31691,'Southend-on-Sea','Southend-on-Sea','','United Kingdom',826,'Europe/London'),(31689,'Southgate','Southgate','','United Kingdom',826,'Europe/London'),(31835,'Southminster','Southminster','','United Kingdom',826,'Europe/London'),(31693,'Southport','Southport','','United Kingdom',826,'Europe/London'),(31831,'Southwell','Southwell','','United Kingdom',826,'Europe/London'),(31839,'Southwold','Southwold','','United Kingdom',826,'Europe/London'),(31849,'Spalding','Spalding','','United Kingdom',826,'Europe/London'),(31847,'Spennymoor','Spennymoor','','United Kingdom',826,'Europe/London'),(31845,'Spilsby','Spilsby','','United Kingdom',826,'Europe/London'),(31871,'Stafford','Stafford','','United Kingdom',826,'Europe/London'),(31959,'Staines','Staines','','United Kingdom',826,'Europe/London'),(31855,'Stalybridge','Stalybridge','','United Kingdom',826,'Europe/London'),(31859,'Stamford','Stamford','','United Kingdom',826,'Europe/London'),(31879,'Staveley','Staveley','','United Kingdom',826,'Europe/London'),(31873,'Stevenage','Stevenage','','United Kingdom',826,'Europe/London'),(31877,'Steyning','Steyning','','United Kingdom',826,'Europe/London'),(31907,'Stockport','Stockport','','United Kingdom',826,'Europe/London'),(31909,'Stockton-on-Tees','Stockton-on-Tees','','United Kingdom',826,'Europe/London'),(31917,'Stonehaven','Stonehaven','','United Kingdom',826,'Europe/London'),(31913,'Stonehouse','Stonehouse','','United Kingdom',826,'Europe/London'),(31895,'Stourbridge','Stourbridge','','United Kingdom',826,'Europe/London'),(31929,'Stowmarket','Stowmarket','','United Kingdom',826,'Europe/London'),(31931,'Strabane','Strabane','','United Kingdom',826,'Europe/London'),(31937,'Strathaven','Strathaven','','United Kingdom',826,'Europe/London'),(31949,'Street','Street','','United Kingdom',826,'Europe/London'),(31945,'Stretford','Stretford','','United Kingdom',826,'Europe/London'),(31951,'Stromness','Stromness','','United Kingdom',826,'Europe/London'),(31955,'Strood','Strood','','United Kingdom',826,'Europe/London'),(31953,'Stroud','Stroud','','United Kingdom',826,'Europe/London'),(31887,'Sturminster Newton','Sturminster Newton','','United Kingdom',826,'Europe/London'),(31661,'Sutton Coldfield','Sutton Coldfield','','United Kingdom',826,'Europe/London'),(31699,'Swadlincote','Swadlincote','','United Kingdom',826,'Europe/London'),(31709,'Swaffham','Swaffham','','United Kingdom',826,'Europe/London'),(31703,'Swanage','Swanage','','United Kingdom',826,'Europe/London'),(31707,'Swanscombe','Swanscombe','','United Kingdom',826,'Europe/London'),(32031,'Tadcaster','Tadcaster','','United Kingdom',826,'Europe/London'),(32033,'Tadley','Tadley','','United Kingdom',826,'Europe/London'),(32069,'Tamworth','Tamworth','','United Kingdom',826,'Europe/London'),(32053,'Tarporley','Tarporley','','United Kingdom',826,'Europe/London'),(32029,'Tavistock','Tavistock','','United Kingdom',826,'Europe/London'),(32075,'Tenterden','Tenterden','','United Kingdom',826,'Europe/London'),(32087,'Tetbury','Tetbury','','United Kingdom',826,'Europe/London'),(32177,'Tewkesbury','Tewkesbury','','United Kingdom',826,'Europe/London'),(32059,'Thatcham','Thatcham','','United Kingdom',826,'Europe/London'),(32035,'Thirsk','Thirsk','','United Kingdom',826,'Europe/London'),(32135,'Thornhill','Thornhill','','United Kingdom',826,'Europe/London'),(32083,'Thurso','Thurso','','United Kingdom',826,'Europe/London'),(32105,'Tilbury','Tilbury','','United Kingdom',826,'Europe/London'),(32103,'Tillicoultry','Tillicoultry','','United Kingdom',826,'Europe/London'),(32093,'Tiverton','Tiverton','','United Kingdom',826,'Europe/London'),(32113,'Todmorden','Todmorden','','United Kingdom',826,'Europe/London'),(32117,'Tonbridge','Tonbridge','','United Kingdom',826,'Europe/London'),(32141,'Torpoint','Torpoint','','United Kingdom',826,'Europe/London'),(32143,'Totnes','Totnes','','United Kingdom',826,'Europe/London'),(32147,'Totton','Totton','','United Kingdom',826,'Europe/London'),(32149,'Towcester','Towcester','','United Kingdom',826,'Europe/London'),(32159,'Tranent','Tranent','','United Kingdom',826,'Europe/London'),(32157,'Tredegar','Tredegar','','United Kingdom',826,'Europe/London'),(32163,'Tring','Tring','','United Kingdom',826,'Europe/London'),(32081,'Turriff','Turriff','','United Kingdom',826,'Europe/London'),(32101,'Tyldesley','Tyldesley','','United Kingdom',826,'Europe/London'),(15813,'Uckfield','Uckfield','','United Kingdom',826,'Europe/London'),(15815,'Ulverston','Ulverston','','United Kingdom',826,'Europe/London'),(15809,'Urmston','Urmston','','United Kingdom',826,'Europe/London'),(15817,'Usk','Usk','','United Kingdom',826,'Europe/London'),(15819,'Uttoxeter','Uttoxeter','','United Kingdom',826,'Europe/London'),(15825,'Ventnor','Ventnor','','United Kingdom',826,'Europe/London'),(15827,'Verwood','Verwood','','United Kingdom',826,'Europe/London'),(32411,'Wadebridge','Wadebridge','','United Kingdom',826,'Europe/London'),(32413,'Wadhurst','Wadhurst','','United Kingdom',826,'Europe/London'),(32465,'Wakefield','Wakefield','','United Kingdom',826,'Europe/London'),(32343,'Walkden','Walkden','','United Kingdom',826,'Europe/London'),(32423,'Wallasey','Wallasey','','United Kingdom',826,'Europe/London'),(32349,'Wallingford','Wallingford','','United Kingdom',826,'Europe/London'),(32351,'Wallsend','Wallsend','','United Kingdom',826,'Europe/London'),(32427,'Walsall','Walsall','','United Kingdom',826,'Europe/London'),(32433,'Waltham Abbey','Waltham Abbey','','United Kingdom',826,'Europe/London'),(32187,'Ware','Ware','','United Kingdom',826,'Europe/London'),(32339,'Wareham','Wareham','','United Kingdom',826,'Europe/London'),(32353,'Warminster','Warminster','','United Kingdom',826,'Europe/London'),(32445,'Warrington','Warrington','','United Kingdom',826,'Europe/London'),(32463,'Watchet','Watchet','','United Kingdom',826,'Europe/London'),(32453,'Waterlooville','Waterlooville','','United Kingdom',826,'Europe/London'),(32455,'Watlington','Watlington','','United Kingdom',826,'Europe/London'),(32193,'Wellingborough','Wellingborough','','United Kingdom',826,'Europe/London'),(32471,'Welshpool','Welshpool','','United Kingdom',826,'Europe/London'),(32399,'Welwyn Garden City','Welwyn Garden City','','United Kingdom',826,'Europe/London'),(32197,'Wembury','Wembury','','United Kingdom',826,'Europe/London'),(32199,'Wemyss Bay','Wemyss Bay','','United Kingdom',826,'Europe/London'),(32205,'West Bridgford','West Bridgford','','United Kingdom',826,'Europe/London'),(32477,'West Bromwich','West Bromwich','','United Kingdom',826,'Europe/London'),(32211,'West Calder','West Calder','','United Kingdom',826,'Europe/London'),(32209,'West Kilbride','West Kilbride','','United Kingdom',826,'Europe/London'),(32215,'West Linton','West Linton','','United Kingdom',826,'Europe/London'),(32219,'West Malling','West Malling','','United Kingdom',826,'Europe/London'),(32225,'Westerham','Westerham','','United Kingdom',826,'Europe/London'),(32481,'Weston-super-Mare','Weston-super-Mare','','United Kingdom',826,'Europe/London'),(32237,'Wetherby','Wetherby','','United Kingdom',826,'Europe/London'),(32307,'Whitefield','Whitefield','','United Kingdom',826,'Europe/London'),(32309,'Whitehaven','Whitehaven','','United Kingdom',826,'Europe/London'),(32313,'Whitley Bay','Whitley Bay','','United Kingdom',826,'Europe/London'),(32251,'Wickford','Wickford','','United Kingdom',826,'Europe/London'),(32247,'Widnes','Widnes','','United Kingdom',826,'Europe/London'),(32403,'Wigan','Wigan','','United Kingdom',826,'Europe/London'),(32179,'Wigton','Wigton','','United Kingdom',826,'Europe/London'),(32269,'Wilmslow','Wilmslow','','United Kingdom',826,'Europe/London'),(32285,'Wincanton','Wincanton','','United Kingdom',826,'Europe/London'),(32279,'Windermere','Windermere','','United Kingdom',826,'Europe/London'),(32283,'Windlesham','Windlesham','','United Kingdom',826,'Europe/London'),(32277,'Wingate','Wingate','','United Kingdom',826,'Europe/London'),(32289,'Winsford','Winsford','','United Kingdom',826,'Europe/London'),(32405,'Wishaw','Wishaw','','United Kingdom',826,'Europe/London'),(32299,'Witham','Witham','','United Kingdom',826,'Europe/London'),(32329,'Withernsea','Withernsea','','United Kingdom',826,'Europe/London'),(32315,'Witney','Witney','','United Kingdom',826,'Europe/London'),(32415,'Woking','Woking','','United Kingdom',826,'Europe/London'),(32417,'Wokingham','Wokingham','','United Kingdom',826,'Europe/London'),(32361,'Woodbridge','Woodbridge','','United Kingdom',826,'Europe/London'),(32369,'Woodhall Spa','Woodhall Spa','','United Kingdom',826,'Europe/London'),(32377,'Wooler','Wooler','','United Kingdom',826,'Europe/London'),(32441,'Workington','Workington','','United Kingdom',826,'Europe/London'),(32443,'Worksop','Worksop','','United Kingdom',826,'Europe/London'),(32475,'Worthing','Worthing','','United Kingdom',826,'Europe/London'),(32459,'Wotton-under-Edge','Wotton-under-Edge','','United Kingdom',826,'Europe/London'),(32259,'Wylam','Wylam','','United Kingdom',826,'Europe/London'),(32275,'Wymondham','Wymondham','','United Kingdom',826,'Europe/London'),(8753,'Абердарон','Aberdare','','United Kingdom',826,'Europe/London'),(8754,'Абердин','Aberdeen','','United Kingdom',826,'Europe/London'),(8756,'Аберпорс','Aberporth','','United Kingdom',826,'Europe/London'),(8765,'Авемор','Aviemore','','United Kingdom',826,'Europe/London'),(101812,'Александрия','Alexandria','','United Kingdom',826,'Europe/London'),(15073,'Аллоа','Alloa','','United Kingdom',826,'Europe/London'),(8759,'Алтнахарра','Altnaharra','','United Kingdom',826,'Europe/London'),(8760,'Амлвч','Amlwch','','United Kingdom',826,'Europe/London'),(8761,'Аонач Мор','Aonach Mor','','United Kingdom',826,'Europe/London'),(14995,'Арброт','Arbroath','','United Kingdom',826,'Europe/London'),(101894,'Ардроссан','Ardrossan','','United Kingdom',826,'Europe/London'),(15001,'Арма','Armagh','','United Kingdom',826,'Europe/London'),(8762,'Аспатрия','Aspatria','','United Kingdom',826,'Europe/London'),(8763,'Аугтон','Aughton','','United Kingdom',826,'Europe/London'),(8764,'Аултбея','Aultbea','','United Kingdom',826,'Europe/London'),(15309,'Баки','Buckie','','United Kingdom',826,'Europe/London'),(8766,'Балликелли','Ballykelly','','United Kingdom',826,'Europe/London'),(8767,'Баллипатрик Форест','Ballypatrick Forest','','United Kingdom',826,'Europe/London'),(8768,'Балтасаунд','Baltasound','','United Kingdom',826,'Europe/London'),(8769,'Бангор','Bangor','','United Kingdom',826,'Europe/London'),(15357,'Банфф','Banff','','United Kingdom',826,'Europe/London'),(8770,'Барборне','Barbourne','','United Kingdom',826,'Europe/London'),(101975,'Барнс','Barnes','','United Kingdom',826,'Europe/London'),(8771,'Барра','Barra','','United Kingdom',826,'Europe/London'),(15395,'Барри','Barry','','United Kingdom',826,'Europe/London'),(101978,'Барроу-ин-Фарнесс','Barrow-in-Furness','','United Kingdom',826,'Europe/London'),(8792,'Бат','Butt','','United Kingdom',826,'Europe/London'),(8773,'Бедфорд','Bedford','','United Kingdom',826,'Europe/London'),(15449,'Беллшилл','Bellshill','','United Kingdom',826,'Europe/London'),(8748,'Белфаст','Belfast','','United Kingdom',826,'Europe/London'),(102072,'Бельведер','Belvedere','','United Kingdom',826,'Europe/London'),(8774,'Бенбекула','Benbecula','','United Kingdom',826,'Europe/London'),(8775,'Бенсон','Benson','','United Kingdom',826,'Europe/London'),(8776,'Бервик-апон-Твид','Berwick Upon Tweed','','United Kingdom',826,'Europe/London'),(15471,'Беркли','Berkeley','','United Kingdom',826,'Europe/London'),(8777,'Бинглей','Bingley','','United Kingdom',826,'Europe/London'),(8778,'Бирмингем','Birmingham','','United Kingdom',826,'Europe/London'),(15549,'Бишопбриггс','Bishopbriggs','','United Kingdom',826,'Europe/London'),(15595,'Блэкберн','Blackburn','','United Kingdom',826,'Europe/London'),(8779,'Блэкпул','Blackpool','','United Kingdom',826,'Europe/London'),(8782,'Болмер','Boulmer','','United Kingdom',826,'Europe/London'),(8780,'Болтшопе Парк','Boltshope Park','','United Kingdom',826,'Europe/London'),(8783,'Борнмут','Bournemouth','','United Kingdom',826,'Europe/London'),(8781,'Боскомбе Даун','Boscombe Down','','United Kingdom',826,'Europe/London'),(102177,'Бостон','Boston','','United Kingdom',826,'Europe/London'),(102181,'Боулинг','Bowling','','United Kingdom',826,'Europe/London'),(15707,'Брайтон','Brighton','','United Kingdom',826,'Europe/London'),(8784,'Бракнел','Bracknell','','United Kingdom',826,'Europe/London'),(102185,'Брамптон','Brampton','','United Kingdom',826,'Europe/London'),(8785,'Бреде','Brede','','United Kingdom',826,'Europe/London'),(15729,'Брентвуд','Brentwood','','United Kingdom',826,'Europe/London'),(102190,'Бридженд','Bridgend','','United Kingdom',826,'Europe/London'),(8789,'Бризе','Brize Norton','','United Kingdom',826,'Europe/London'),(8788,'Бриксхам','Brixham','','United Kingdom',826,'Europe/London'),(8786,'Брингстон Мрск','Bridlington','','United Kingdom',826,'Europe/London'),(8787,'Бристоль','Bristol','','United Kingdom',826,'Europe/London'),(15777,'Брэдфорд','Bradford','','United Kingdom',826,'Europe/London'),(15791,'Бутл','Bootle','','United Kingdom',826,'Europe/London'),(8984,'Ваддингтон','Waddington','','United Kingdom',826,'Europe/London'),(8985,'Вайнтфлит','Wainfleet','','United Kingdom',826,'Europe/London'),(8983,'Валлей','Valley','','United Kingdom',826,'Europe/London'),(8986,'Валней Остров','Walney Island','','United Kingdom',826,'Europe/London'),(105082,'Вашингтон','Washington','','United Kingdom',826,'Europe/London'),(8992,'Вейборн','Weybourne','','United Kingdom',826,'Europe/London'),(105086,'Веллингтон','Wellington','','United Kingdom',826,'Europe/London'),(105100,'Вестминстер','Westminster','','United Kingdom',826,'Europe/London'),(8995,'Вик','Wick','','United Kingdom',826,'Europe/London'),(105184,'Виндзор','Windsor','','United Kingdom',826,'Europe/London'),(105182,'Винчестер','Winchester','','United Kingdom',826,'Europe/London'),(8997,'Витеринг','Wittering','','United Kingdom',826,'Europe/London'),(32319,'Витстабл','Whitstable','','United Kingdom',826,'Europe/London'),(8989,'Вотерстейн','Waterstein','','United Kingdom',826,'Europe/London'),(8990,'Воттишам','Wattisham','','United Kingdom',826,'Europe/London'),(32367,'Вудсток','Woodstock','','United Kingdom',826,'Europe/London'),(32375,'Вулвергемптон','Wolverhampton','','United Kingdom',826,'Europe/London'),(32381,'Вустер','Worcester','','United Kingdom',826,'Europe/London'),(8842,'Галашилс','Galashiels','','United Kingdom',826,'Europe/London'),(30091,'Гамильтон','Hamilton','','United Kingdom',826,'Europe/London'),(30093,'Гастингс','Hastings','','United Kingdom',826,'Europe/London'),(29887,'Гилдфорд','Guildford','','United Kingdom',826,'Europe/London'),(29609,'Глаз','Eye','','United Kingdom',826,'Europe/London'),(8844,'Глазго','Glasgow','','United Kingdom',826,'Europe/London'),(8845,'Глен Огл','Glen Ogle','','United Kingdom',826,'Europe/London'),(8846,'Гленен','Glenanne','','United Kingdom',826,'Europe/London'),(8847,'Гленливет','Glenlivet','','United Kingdom',826,'Europe/London'),(29905,'Гленротс','Glenrothes','','United Kingdom',826,'Europe/London'),(29909,'Глостер','Gloucester','','United Kingdom',826,'Europe/London'),(8848,'Гоф','Gough Island','','United Kingdom',826,'Europe/London'),(8850,'Грейт Дун Фел','Great Dun Fell','','United Kingdom',826,'Europe/London'),(8851,'Грейт Малверн','Great Malvern','','United Kingdom',826,'Europe/London'),(29991,'Грейт Ярмут','Great Yarmouth','','United Kingdom',826,'Europe/London'),(102951,'Гринвич','Greenwich','','United Kingdom',826,'Europe/London'),(8852,'Гринок','Greenock','','United Kingdom',826,'Europe/London'),(15105,'Дадли','Dudley','','United Kingdom',826,'Europe/London'),(15121,'Дамбартон','Dumbarton','','United Kingdom',826,'Europe/London'),(8826,'Дамфрис','Dumfries / Drungans','','United Kingdom',826,'Europe/London'),(102627,'Дамфрис','Dumfries','','United Kingdom',826,'Europe/London'),(15133,'Данди','Dundee','','United Kingdom',826,'Europe/London'),(8827,'Дандреннан','Dundrennan','','United Kingdom',826,'Europe/London'),(15151,'Данфермлин','Dunfermline','','United Kingdom',826,'Europe/London'),(15161,'Дарем','Durham','','United Kingdom',826,'Europe/London'),(15163,'Дарлингтон','Darlington','','United Kingdom',826,'Europe/London'),(15169,'Дартфорд','Dartford','','United Kingdom',826,'Europe/London'),(15197,'Дерби','Derby','','United Kingdom',826,'Europe/London'),(103534,'Дерри','Londonderry','','United Kingdom',826,'Europe/London'),(8867,'Джерси','Jersey Airport','','United Kingdom',826,'Europe/Jersey'),(103346,'Джерси','Jersey','','United Kingdom',826,'Europe/Jersey'),(15251,'Донкастер','Doncaster','','United Kingdom',826,'Europe/London'),(8823,'Донна Нук','Donna Nook','','United Kingdom',826,'Europe/London'),(8824,'Друмалбин','Drumalbin','','United Kingdom',826,'Europe/London'),(8825,'Друмбугх','Drumburgh','','United Kingdom',826,'Europe/London'),(102620,'Дувр','Dover','','United Kingdom',826,'Europe/London'),(8829,'Изингтон','Easington','','United Kingdom',826,'Europe/London'),(29705,'Или','Ely','','United Kingdom',826,'Europe/London'),(8862,'Инверберви','Inverbervie','','United Kingdom',826,'Europe/London'),(8863,'Инвергордон','Invergordon','','United Kingdom',826,'Europe/London'),(8864,'Инвернесс','Inverness','','United Kingdom',826,'Europe/London'),(30073,'Ипсуич','Ipswich','','United Kingdom',826,'Europe/London'),(30075,'Ирвин','Irvine','','United Kingdom',826,'Europe/London'),(29655,'Истборн','Eastbourne','','United Kingdom',826,'Europe/London'),(8999,'Йовилтон','Yeovil','','United Kingdom',826,'Europe/London'),(15097,'Йорк','York','','United Kingdom',826,'Europe/London'),(8794,'Каирнвел','Cairnwell','','United Kingdom',826,'Europe/London'),(8795,'Камборн','Camborne','','United Kingdom',826,'Europe/London'),(8796,'Капе Враш','Cape Wrath','','United Kingdom',826,'Europe/London'),(8797,'Капел Кюриг','Capel Curig','','United Kingdom',826,'Europe/London'),(8799,'Кардинхам','Cardinham','','United Kingdom',826,'Europe/London'),(8749,'Кардифф','Cardiff','','United Kingdom',826,'Europe/London'),(8800,'Карлайл','Carlisle','','United Kingdom',826,'Europe/London'),(29207,'Кармартен','Carmarthen','','United Kingdom',826,'Europe/London'),(8802,'Картерхаус','Carterhouse','','United Kingdom',826,'Europe/London'),(8803,'Кастледерг','Castlederg','','United Kingdom',826,'Europe/London'),(102358,'Кембридж','Cambridge','','United Kingdom',826,'Europe/London'),(103405,'Кенсингтон','Kensington','','United Kingdom',826,'Europe/London'),(103406,'Кент','Kent','','United Kingdom',826,'Europe/London'),(29253,'Кентербери','Canterbury','','United Kingdom',826,'Europe/London'),(8869,'Кентли','Kenley','','United Kingdom',826,'Europe/London'),(103421,'Керкуолл','Kirkwall Airport','','United Kingdom',826,'Europe/London'),(8870,'Кесвик','Keswick','','United Kingdom',826,'Europe/London'),(30467,'Килмарнок','Kilmarnock','','United Kingdom',826,'Europe/London'),(8873,'Килмори','Kilmory','','United Kingdom',826,'Europe/London'),(30495,'Кингстон-апон-Халл','Kingston upon Hull','','United Kingdom',826,'Europe/London'),(8874,'Кинлосс','Kinloss','','United Kingdom',826,'Europe/London'),(8875,'Кирквол','Kirkwall','','United Kingdom',826,'Europe/London'),(29309,'Ковентри','Coventry','','United Kingdom',826,'Europe/London'),(8812,'Колтишал','Coltishall','','United Kingdom',826,'Europe/London'),(29357,'Колчестер','Colchester','','United Kingdom',826,'Europe/London'),(29387,'Корби','Corby','','United Kingdom',826,'Europe/London'),(8814,'Коргари','Corgary','','United Kingdom',826,'Europe/London'),(102462,'Корнуолл','Cornwall','','United Kingdom',826,'Europe/London'),(8815,'Коттесморе','Cottesmore','','United Kingdom',826,'Europe/London'),(29421,'Крайстчёрч','Christchurch','','United Kingdom',826,'Europe/London'),(8817,'Кранвель','Cranwell','','United Kingdom',826,'Europe/London'),(8818,'Кросбей','Crosby','','United Kingdom',826,'Europe/London'),(8819,'Кулдрос','Culdrose','','United Kingdom',826,'Europe/London'),(8899,'Лайбстер','Lybster','','United Kingdom',826,'Europe/London'),(8900,'Лайнехам','Lyneham','','United Kingdom',826,'Europe/London'),(30567,'Ланкастер','Lancaster','','United Kingdom',826,'Europe/London'),(8880,'Ларкхилл','Larkhill','','United Kingdom',826,'Europe/London'),(8881,'Ларн','Larne','','United Kingdom',826,'Europe/London'),(103437,'Лейт','Leith','','United Kingdom',826,'Europe/London'),(8885,'Леминг','Leeming','','United Kingdom',826,'Europe/London'),(8886,'Леруик','Lerwick','','United Kingdom',826,'Europe/London'),(30607,'Лестер','Leicester','','United Kingdom',826,'Europe/London'),(8887,'Леучарс','Leuchars','','United Kingdom',826,'Europe/London'),(103434,'Ли','Lee','','United Kingdom',826,'Europe/London'),(30619,'Ливерпуль','Liverpool','','United Kingdom',826,'Europe/London'),(8884,'Лидс','Leeds','','United Kingdom',826,'Europe/London'),(103445,'Линкольн','Lincoln','','United Kingdom',826,'Europe/London'),(30651,'Лисберн','Lisburn','','United Kingdom',826,'Europe/London'),(8889,'Лискомбе','Liscombe','','United Kingdom',826,'Europe/London'),(8890,'Литтле Риссингтон','Little Rissington','','United Kingdom',826,'Europe/London'),(30685,'Личфилд','Lichfield','','United Kingdom',826,'Europe/London'),(8892,'Лок Гласканч','Loch Glascanoch','','United Kingdom',826,''),(8750,'Лондон','London','','United Kingdom',826,'Europe/London'),(8897,'Лоссимут','Lossiemouth','','United Kingdom',826,'Europe/London'),(30777,'Лоустофт','Lowestoft','','United Kingdom',826,'Europe/London'),(8898,'Лох Феа','Lough Fea','','United Kingdom',826,'Europe/London'),(30793,'Лутон','Luton','','United Kingdom',826,'Europe/London'),(103265,'Льюис','Isle of Lewis','','United Kingdom',826,'Europe/London'),(8882,'Лэконфилд','Leconfield','','United Kingdom',826,'Europe/London'),(8879,'Лэнгдон Бай','Langdon Bay','','United Kingdom',826,'Europe/London'),(8913,'Макл-Холм','Muckle Holm','','United Kingdom',826,'Europe/London'),(8903,'Малверн','Malvern','','United Kingdom',826,'Europe/London'),(8905,'Манстон','Manston','','United Kingdom',826,'Europe/London'),(8904,'Манчестер','manchester','','United Kingdom',826,'Europe/London'),(8906,'Мархам','Marham','','United Kingdom',826,'Europe/London'),(30903,'Массельбург','Musselburgh','','United Kingdom',826,'Europe/London'),(8901,'Махриханиш','Machrihanish','','United Kingdom',826,'Europe/London'),(30923,'Мелроуз','Melrose','','United Kingdom',826,'Europe/London'),(30941,'Мертир-Тидвил','Merthyr Tydfil','','United Kingdom',826,'Europe/London'),(103685,'Мертир-Тидвил','Merthyr','','United Kingdom',826,'Europe/London'),(8907,'Мидл  Вэллоп','Middle Wallop','','United Kingdom',826,'Europe/London'),(30955,'Мидлсбро','Middlesbrough','','United Kingdom',826,'Europe/London'),(8908,'Милденхол','Mildenhall','','United Kingdom',826,'Europe/London'),(30973,'Милтон-Кинс','Milton Keynes','','United Kingdom',826,'Europe/London'),(8909,'Милфорд Хевен','Milford Haven','','United Kingdom',826,'Europe/London'),(103694,'Монтгомери','Montgomery','','United Kingdom',826,'Europe/London'),(31015,'Мотеруэлл','Motherwell','','United Kingdom',826,'Europe/London'),(8914,'Мюмблес','Mumbles','','United Kingdom',826,'Europe/London'),(8923,'Норидж','Norwich','','United Kingdom',826,'Europe/London'),(31105,'Нортгемптон','Northampton','','United Kingdom',826,'Europe/London'),(103855,'Норфолк','Norfolk','','United Kingdom',826,'Europe/London'),(8922,'Носвуд','Northwood','','United Kingdom',826,'Europe/London'),(8921,'Носхольт','Northolt','','United Kingdom',826,'Europe/London'),(8924,'Ноттингем','Nottingham','','United Kingdom',826,'Europe/London'),(103843,'Ньюарк','Newark','','United Kingdom',826,'Europe/London'),(31141,'Ньюбери','Newbury','','United Kingdom',826,'Europe/London'),(8751,'Ньюкасл-апон-Тайн','Newcastle','','United Kingdom',826,'Europe/London'),(103846,'Ньюкасл-апон-Тайн','Newcastle upon Tyne','','United Kingdom',826,'Europe/London'),(31157,'Ньюмаркет','Newmarket','','United Kingdom',826,'Europe/London'),(29237,'Ньюпорт','Newport','','United Kingdom',826,'Europe/London'),(31125,'Ньюри','Newry','','United Kingdom',826,'Europe/London'),(8917,'Ньюхевен','Newhaven','','United Kingdom',826,'Europe/London'),(8925,'Обан','Oban','','United Kingdom',826,'Europe/London'),(8926,'Одихем','Odiham','','United Kingdom',826,'Europe/London'),(31201,'Оксфорд','Oxford','','United Kingdom',826,'Europe/London'),(31271,'Пейсли','Paisley','','United Kingdom',826,'Europe/London'),(8928,'Пембрей Сендс','Pembrey Sands','','United Kingdom',826,''),(31311,'Перт','Perth','','United Kingdom',826,'Europe/London'),(8931,'Першоре','Pershore','','United Kingdom',826,'Europe/London'),(8932,'Петерхед Хабор','Peterhead','','United Kingdom',826,'Europe/London'),(31331,'Питерборо','Peterborough','','United Kingdom',826,'Europe/London'),(8933,'Плимут','Plymouth','','United Kingdom',826,'Europe/London'),(31341,'Полмонт','Polmont','','United Kingdom',826,'Europe/London'),(8935,'Портгленон','Portglenone','','United Kingdom',826,'Europe/London'),(8936,'Портленд','Portland / Rnas','','United Kingdom',826,'Europe/London'),(104086,'Портленд','Portland','','United Kingdom',826,'Europe/London'),(8937,'Портраш','Portrush','','United Kingdom',826,'Europe/London'),(31389,'Портсмут','Portsmouth','','United Kingdom',826,'Europe/London'),(8752,'Прествик','Prestwick','','United Kingdom',826,'Europe/London'),(31411,'Престон','Preston','','United Kingdom',826,'Europe/London'),(31447,'Рай','Rye','','United Kingdom',826,'Europe/London'),(8938,'Раквик','Rackwick','','United Kingdom',826,'Europe/London'),(8939,'Редесдаль','Redesdale','','United Kingdom',826,'Europe/London'),(31477,'Рединг','Reading','','United Kingdom',826,'Europe/London'),(104293,'Рипли','Ripley','','United Kingdom',826,'Europe/London'),(31519,'Ричмонд','Richmond','','United Kingdom',826,'Europe/London'),(31571,'Рочдейл','Rochdale','','United Kingdom',826,'Europe/London'),(8940,'Рхул','Rhyl','','United Kingdom',826,'Europe/London'),(104614,'Садбери','Sudbury','','United Kingdom',826,'Europe/London'),(8973,'Сандерленд','Sunderland','','United Kingdom',826,'Europe/London'),(8948,'Саугхол','Saughall','','United Kingdom',826,'Europe/London'),(8964,'Саутгемптон','Southampton','','United Kingdom',826,'Europe/London'),(8946,'Сеинт Мавген','Saint Mawgan','','United Kingdom',826,'Europe/London'),(8951,'Селла Нес','Sella Ness','','United Kingdom',826,'Europe/London'),(8952,'Сенибридж','Sennybridge','','United Kingdom',826,'Europe/London'),(31747,'Сент-Олбанс','Saint Albans','','United Kingdom',826,'Europe/London'),(104503,'Сент-Олбанс','St Albans','','United Kingdom',826,'Europe/London'),(104507,'Сент-Олбанс','St. Albans','','United Kingdom',826,'Europe/London'),(8945,'Сент-Хелиер','Saint Helier','','United Kingdom',826,'Europe/Jersey'),(104504,'Сент-Хелиер','St Helier','','United Kingdom',826,'Europe/Jersey'),(104509,'Сент-Эндрюс','St. Andrews','','United Kingdom',826,'Europe/London'),(103278,'Скай','Isle of Skye','','United Kingdom',826,'Europe/London'),(8959,'Скиптон','Skipton','','United Kingdom',826,'Europe/London'),(31815,'Солсбери','Salisbury','','United Kingdom',826,'Europe/London'),(31817,'Солфорд','Salford','','United Kingdom',826,'Europe/London'),(8965,'Спадедам','Spadeadam','','United Kingdom',826,'Europe/London'),(31885,'Стерлинг','Stirling','','United Kingdom',826,'Europe/London'),(8968,'Сторновей','Stornoway','','United Kingdom',826,'Europe/London'),(31947,'Стратфорд-на-Эйвоне','Stratford-upon-Avon','','United Kingdom',826,'Europe/London'),(8969,'Страшалан','Strathallan','','United Kingdom',826,'Europe/London'),(104538,'Стэнли','Stanley','','United Kingdom',826,'Europe/London'),(8971,'Сюл Скерри','Sule Skerry','','United Kingdom',826,'Europe/London'),(8977,'Тири','Tiree','','United Kingdom',826,'Europe/London'),(32121,'Тонтон','Taunton','','United Kingdom',826,'Europe/London'),(104077,'Тополь','Poplar','','United Kingdom',826,'Europe/London'),(32125,'Торки','Torquay','','United Kingdom',826,'Europe/London'),(8976,'Торни остров','Thorney Island','','United Kingdom',826,'Europe/London'),(8979,'Травскед','Trawscoed','','United Kingdom',826,'Europe/London'),(32167,'Троубридж','Trowbridge','','United Kingdom',826,'Europe/London'),(32171,'Труро','Truro','','United Kingdom',826,'Europe/London'),(8981,'Туллоч Бридж','Tulloch Bridge','','United Kingdom',826,'Europe/London'),(8974,'Тьян Генж','Tain','','United Kingdom',826,'Europe/London'),(105173,'Уайтхолл','Whitehall','','United Kingdom',826,'Europe/London'),(8993,'Уитби','Whitby','','United Kingdom',826,'Europe/London'),(32439,'Уорик','Warwick','','United Kingdom',826,'Europe/London'),(32461,'Уотфорд','Watford','','United Kingdom',826,'Europe/London'),(32467,'Уэймут','Weymouth','','United Kingdom',826,'Europe/London'),(32401,'Уэллс','Wells','','United Kingdom',826,'Europe/London'),(8838,'Фае Несс','Fife Ness','','United Kingdom',826,'Europe/London'),(8841,'Файлингдейлс','Fylingdales','','United Kingdom',826,'Europe/London'),(8837,'Фанборо','Farnborough','','United Kingdom',826,'Europe/London'),(8835,'Фаэр Айсл','Fair Isle','','United Kingdom',826,'Europe/London'),(8840,'Фоерс','Foyers','','United Kingdom',826,'Europe/London'),(29819,'Фолкерк','Falkirk','','United Kingdom',826,'Europe/London'),(29821,'Фолкстон','Folkestone','','United Kingdom',826,'Europe/London'),(29837,'Форфар','Forfar','','United Kingdom',826,'Europe/London'),(8839,'Фоула','Foula','','United Kingdom',826,'Europe/London'),(8854,'Хаварден','Hawarden','','United Kingdom',826,'Europe/London'),(103184,'Халл','Hull','','United Kingdom',826,'Europe/London'),(30179,'Харлоу','Harlow','','United Kingdom',826,'Europe/London'),(103255,'Харрис','Isle of Harris','','United Kingdom',826,'Europe/London'),(8855,'Хемсби','Hemsby','','United Kingdom',826,'Europe/London'),(8856,'Херстмонсо','Herstmonceux','','United Kingdom',826,'Europe/London'),(8858,'Хиллсборо','Hillsborough','','United Kingdom',826,'Europe/London'),(8859,'Холбич','Holbeach','','United Kingdom',826,'Europe/London'),(30347,'Хоув','Hove','','United Kingdom',826,'Europe/London'),(8806,'Чартерхол','Charterhall','','United Kingdom',826,'Europe/London'),(8810,'Чарч Лэвфорд','Church Lawford','','United Kingdom',826,'Europe/London'),(8809,'Чарч Фентон','Church Fenton','','United Kingdom',826,'Europe/London'),(29547,'Чатем','Chatham','','United Kingdom',826,'Europe/London'),(102380,'Челси','Chelsea','','United Kingdom',826,'Europe/London'),(29565,'Челтенхем','Cheltenham','','United Kingdom',826,'Europe/London'),(29575,'Честер','Chester','','United Kingdom',826,'Europe/London'),(8808,'Чивенор','Chivenor','','United Kingdom',826,'Europe/London'),(29527,'Чичестер','Chichester','','United Kingdom',826,'Europe/London'),(8954,'Шавбури','Shawbury','','United Kingdom',826,'Europe/London'),(8953,'Шап','Shap','','United Kingdom',826,'Europe/London'),(8955,'Шернесс','Sheerness','','United Kingdom',826,'Europe/London'),(31997,'Шеффилд','Sheffield','','United Kingdom',826,'Europe/London'),(104410,'Ширли','Shirley','','United Kingdom',826,'Europe/London'),(8956,'Шобдон','Shobdon','','United Kingdom',826,'Europe/London'),(8957,'Шоебюрнес','Shoeburyness','','United Kingdom',826,'Europe/London'),(32023,'Шрусбери','Shrewsbury','','United Kingdom',826,'Europe/London'),(8757,'Эбойне','Aboyne','','United Kingdom',826,'Europe/London'),(103251,'Эгг','Isle of Eigg','','United Kingdom',826,'Europe/London'),(8830,'Эдинбург','Edinburgh','','United Kingdom',826,'Europe/London'),(15085,'Эйлсбери','Aylesbury','','United Kingdom',826,'Europe/London'),(15089,'Эйр','Ayr','','United Kingdom',826,'Europe/London'),(8834,'Эксетер','Exeter','','United Kingdom',826,'Europe/London'),(8831,'Эмлей Мур','Emley Moor','','United Kingdom',826,'Europe/London'),(102770,'Энфилд','Enfield','','United Kingdom',826,'Europe/London'),(8832,'Эскдалемур','Eskdalemuir','','United Kingdom',826,'Europe/London'),(8833,'Эскмилс','Eskmeals','','United Kingdom',826,'Europe/London'),(91449,'Балатонбоглар','Balatonboglar','','Hungary',348,'Europe/Budapest'),(50995,'Будапешт','Budapest','','Hungary',348,'Europe/Budapest'),(51311,'Вац','Vac','','Hungary',348,'Europe/Budapest'),(51029,'Дебрецен','Debrecen','','Hungary',348,'Europe/Budapest'),(51035,'Дорог','Dorog','','Hungary',348,'Europe/Budapest'),(51039,'Дунауйварош','Dunaujvaros','','Hungary',348,'Europe/Budapest'),(51065,'Дьёр','Gyor','','Hungary',348,'Europe/Budapest'),(51119,'Кестхей','Keszthely','','Hungary',348,'Europe/Budapest'),(51121,'Кечкемет','Kecskemet','','Hungary',348,'Europe/Budapest'),(51157,'Мако','Mako','','Hungary',348,'Europe/Budapest'),(51171,'Мишкольц','Miskolc','','Hungary',348,'Europe/Budapest'),(51185,'Надьканижа','Nagykanizsa','','Hungary',348,'Europe/Budapest'),(51195,'Ньиредьхаза','Nyiregyhaza','','Hungary',348,'Europe/Budapest'),(51201,'Орошхаза','Oroshaza','','Hungary',348,'Europe/Budapest'),(51209,'Пасто','Paszto','','Hungary',348,'Europe/Budapest'),(51213,'Печ','Pecs','','Hungary',348,'Europe/Budapest'),(51227,'Сегед','Szeged','','Hungary',348,'Europe/Budapest'),(51231,'Секешфехервар','Szekesfehervar','','Hungary',348,'Europe/Budapest'),(51251,'Сольнок','Szolnok','','Hungary',348,'Europe/Budapest'),(51253,'Сомбатхей','Szombathely','','Hungary',348,'Europe/Budapest'),(51283,'Тапольца','Tapolca','','Hungary',348,'Europe/Budapest'),(51285,'Тата','Tata','','Hungary',348,'Europe/Budapest'),(51287,'Татабанья','Tatabanya','','Hungary',348,'Europe/Budapest'),(51289,'Тисавашвари','Tiszavasvari','','Hungary',348,'Europe/Budapest'),(92446,'Томпа','Tompa','','Hungary',348,'Europe/Budapest'),(51307,'Уйфехерто','Ujfeherto','','Hungary',348,'Europe/Budapest'),(51013,'Цеглед','Cegled','','Hungary',348,'Europe/Budapest'),(51011,'Чорна','Csorna','','Hungary',348,'Europe/Budapest'),(51273,'Шиофок','Siofok','','Hungary',348,'Europe/Budapest'),(51041,'Эгер','Eger','','Hungary',348,'Europe/Budapest'),(51045,'Энч','Encs','','Hungary',348,'Europe/Budapest'),(51049,'Эрд','Erd','','Hungary',348,'Europe/Budapest'),(9060,'Бач Лонг Ви','Bach Long Vi','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9089,'Винх','Vinh','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9065,'Дананг','Da Nang','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9066,'Донгхой','Dong Hoi','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9062,'Ка Мау','Ca Mau','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9063,'Као Банг','Cao Bang','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9064,'Кон Сон','Con Son','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9081,'Куинён','Quy Nhon','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9072,'Ланг Сон','Lang Son','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9073,'Лао Каи','Lao Cai','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9075,'Намдинь','Nam Dinh','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9076,'Нячанг','Nha Trang','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9087,'Острова Спратли','Truong Sa','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9084,'Сонг Ту Тау Саус Вест Кау','Song Tu Tay South West Cay','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9071,'Тон','Hue','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9086,'Тханьхоа','Thanh Hoa','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9077,'Фантхьет','Phan Thiet','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9085,'Хаи Нгуен','Thai Nguyen','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9067,'Ханой','Ha Noi','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9069,'Хо Ши Мин','Ho Chi Minh','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9079,'Ху Куок','Phu Quoc','','Vietnam',704,'Asia/Ho_Chi_Minh'),(9078,'Ху Лиен','Phu Lien','','Vietnam',704,'Asia/Ho_Chi_Minh'),(5322,'Либревиль','Libreville','','Gabon',266,'Africa/Libreville'),(5329,'Порт-Жантиль','Port-Gentil','','Gabon',266,'Africa/Libreville'),(5815,'Маму','Mamou','','Guinea',324,'Africa/Conakry'),(5817,'Сигири','Siguiri','','Guinea',324,'Africa/Conakry'),(18739,'Adelsdorf','Adelsdorf','','Germany',276,'Europe/Berlin'),(19785,'Bietigheim','Bietigheim','','Germany',276,'Europe/Berlin'),(19825,'Blankenburg','Blankenburg','','Germany',276,'Europe/Berlin'),(19841,'Blekendorf','Blekendorf','','Germany',276,'Europe/Berlin'),(19853,'Blumberg','Blumberg','','Germany',276,'Europe/Berlin'),(19901,'Bockenheim','Bockenheim','','Germany',276,'Europe/Berlin'),(19913,'Bollschweil','Bollschweil','','Germany',276,'Europe/Berlin'),(20013,'Breitengussbach','Breitengussbach','','Germany',276,'Europe/Berlin'),(20259,'Burgstadt','Burgstadt','','Germany',276,'Europe/Berlin'),(21023,'Cornberg','Cornberg','','Germany',276,'Europe/Berlin'),(21719,'Ehningen','Ehningen','','Germany',276,'Europe/Berlin'),(21651,'Elster','Elster','','Germany',276,'Europe/Berlin'),(22047,'Frankleben','Frankleben','','Germany',276,'Europe/Berlin'),(20317,'Geisingen','Geisingen','','Germany',276,'Europe/Berlin'),(20499,'Gerzen','Gerzen','','Germany',276,'Europe/Berlin'),(20629,'Gossnitz','Gossnitz','','Germany',276,'Europe/Berlin'),(20627,'Gossweinstein','Gossweinstein','','Germany',276,'Europe/Berlin'),(20679,'Grafenberg','Grafenberg','','Germany',276,'Europe/Berlin'),(20721,'Greppin','Greppin','','Germany',276,'Europe/Berlin'),(20851,'Grossorner','Grossorner','','Germany',276,'Europe/Berlin'),(20855,'Grossposna','Grossposna','','Germany',276,'Europe/Berlin'),(20861,'Grossrinderfeld','Grossrinderfeld','','Germany',276,'Europe/Berlin'),(20291,'Grossrohrsdorf','Grossrohrsdorf','','Germany',276,'Europe/Berlin'),(22443,'Hassbergen','Hassbergen','','Germany',276,'Europe/Berlin'),(22459,'Hattenhofen','Hattenhofen','','Germany',276,'Europe/Berlin'),(22801,'Heubach','Heubach','','Germany',276,'Europe/Berlin'),(22743,'Hirschfelde','Hirschfelde','','Germany',276,'Europe/Berlin'),(22673,'Hochberg','Hochberg','','Germany',276,'Europe/Berlin'),(22181,'Holzweissig','Holzweissig','','Germany',276,'Europe/Berlin'),(22957,'Hufingen','Hufingen','','Germany',276,'Europe/Berlin'),(23141,'Kappeln','Kappeln','','Germany',276,'Europe/Berlin'),(23177,'Kaulsdorf','Kaulsdorf','','Germany',276,'Europe/Berlin'),(23703,'Langweid','Langweid','','Germany',276,'Europe/Berlin'),(23797,'Lathen','Lathen','','Germany',276,'Europe/Berlin'),(23801,'Lauben','Lauben','','Germany',276,'Europe/Berlin'),(23907,'Lensahn','Lensahn','','Germany',276,'Europe/Berlin'),(24031,'Leutenbach','Leutenbach','','Germany',276,'Europe/Berlin'),(23943,'Liederbach','Liederbach','','Germany',276,'Europe/Berlin'),(24177,'Lutzelbach','Lutzelbach','','Germany',276,'Europe/Berlin'),(24405,'Mauer','Mauer','','Germany',276,'Europe/Berlin'),(24491,'Mering','Mering','','Germany',276,'Europe/Berlin'),(24625,'Mosbach','Mosbach','','Germany',276,'Europe/Berlin'),(25401,'Oberthal','Oberthal','','Germany',276,'Europe/Berlin'),(25287,'Oelsnitz','Oelsnitz','','Germany',276,'Europe/Berlin'),(25643,'Offenbach','Offenbach','','Germany',276,'Europe/Berlin'),(25513,'Opfingen','Opfingen','','Germany',276,'Europe/Berlin'),(25607,'Ottenbach','Ottenbach','','Germany',276,'Europe/Berlin'),(92459,'Perl','Perl','','Germany',276,'Europe/Berlin'),(26107,'Reichenau','Reichenau','','Germany',276,'Europe/Berlin'),(26097,'Reisbach','Reisbach','','Germany',276,'Europe/Berlin'),(26353,'Rittersgrun','Rittersgrun','','Germany',276,'Europe/Berlin'),(26563,'Ruhstorf','Ruhstorf','','Germany',276,'Europe/Berlin'),(27229,'Schlema','Schlema','','Germany',276,'Europe/Berlin'),(27291,'Schobull','Schobull','','Germany',276,'Europe/Berlin'),(27335,'Schonefeld','Schonefeld','','Germany',276,'Europe/Berlin'),(26719,'Seehausen','Seehausen','','Germany',276,'Europe/Berlin'),(26953,'Sussen','Sussen','','Germany',276,'Europe/Berlin'),(27695,'Tarp','Tarp','','Germany',276,'Europe/Berlin'),(27737,'Tennenbronn','Tennenbronn','','Germany',276,'Europe/Berlin'),(27685,'Thannhausen','Thannhausen','','Germany',276,'Europe/Berlin'),(27847,'Triebes','Triebes','','Germany',276,'Europe/Berlin'),(28051,'Uehlfeld','Uehlfeld','','Germany',276,'Europe/Berlin'),(28167,'Vreden','Vreden','','Germany',276,'Europe/Berlin'),(28563,'Waldkirch','Waldkirch','','Germany',276,'Europe/Berlin'),(28705,'Wedel','Wedel','','Germany',276,'Europe/Berlin'),(28415,'Weiler','Weiler','','Germany',276,'Europe/Berlin'),(28799,'Wertheim','Wertheim','','Germany',276,'Europe/Berlin'),(28885,'Wiesenbach','Wiesenbach','','Germany',276,'Europe/Berlin'),(28979,'Winningen','Winningen','','Germany',276,'Europe/Berlin'),(29057,'Wolmirstedt','Wolmirstedt','','Germany',276,'Europe/Berlin'),(29121,'Wulften','Wulften','','Germany',276,'Europe/Berlin'),(29155,'Wunnenberg','Wunnenberg','','Germany',276,'Europe/Berlin'),(28325,'Zscherndorf','Zscherndorf','','Germany',276,'Europe/Berlin'),(18721,'Аален','Aalen','','Germany',276,'Europe/Berlin'),(18723,'Аах','Aach','','Germany',276,'Europe/Berlin'),(18725,'Абенберг','Abenberg','','Germany',276,'Europe/Berlin'),(18727,'Абенсберг','Abensberg','','Germany',276,'Europe/Berlin'),(18729,'Абтсгмюнд','Abtsgmund','','Germany',276,'Europe/Berlin'),(18731,'Абштат','Abstatt','','Germany',276,'Europe/Berlin'),(18733,'Агластерхаузен','Aglasterhausen','','Germany',276,'Europe/Berlin'),(18735,'Адельберг','Adelberg','','Germany',276,'Europe/Berlin'),(18737,'Адельмансфельден','Adelmannsfelden','','Germany',276,'Europe/Berlin'),(21451,'Айзенхюттенштадт','Eisenhuttenstadt','','Germany',276,'Europe/Berlin'),(21471,'Айзлинген','Eislingen','','Germany',276,'Europe/Berlin'),(21457,'Айленбург','Eilenburg','','Germany',276,'Europe/Berlin'),(21465,'Айнбек','Einbeck','','Germany',276,'Europe/Berlin'),(87507,'Айслинген','Aislingen','','Germany',276,'Europe/Berlin'),(21481,'Айторф','Eitorf','','Germany',276,'Europe/Berlin'),(18783,'Айхах','Aichach','','Germany',276,'Europe/Berlin'),(18795,'Ален','Ahlen','','Germany',276,'Europe/Berlin'),(18837,'Альбштадт','Albstadt','','Germany',276,'Europe/Berlin'),(18859,'Альсдорф','Alsdorf','','Germany',276,'Europe/Berlin'),(18861,'Альсдорф','Ahlsdorf','','Germany',276,'Europe/Berlin'),(18873,'Альтдорф','Altdorf','','Germany',276,'Europe/Berlin'),(18881,'Альтена','Altena','','Germany',276,'Europe/Berlin'),(87575,'Альтенбург','Altenburg','','Germany',276,'Europe/Berlin'),(18951,'Альфельд','Alfeld','','Germany',276,'Europe/Berlin'),(18953,'Альфтер','Alfter','','Germany',276,'Europe/Berlin'),(18963,'Амберг','Amberg','','Germany',276,'Europe/Berlin'),(18979,'Амштеттен','Amstetten','','Germany',276,'Europe/Berlin'),(18981,'Ангермюнде','Angermunde','','Germany',276,'Europe/Berlin'),(18985,'Андернах','Andernach','','Germany',276,'Europe/Berlin'),(18987,'Анклам','Anklam','','Germany',276,'Europe/Berlin'),(18993,'Аннаберг-Буххольц','Annaberg-Buchholz','','Germany',276,'Europe/Berlin'),(19003,'Ансбах','Ansbach','','Germany',276,'Europe/Berlin'),(19015,'Апольда','Apolda','','Germany',276,'Europe/Berlin'),(19019,'Аппен','Appen','','Germany',276,'Europe/Berlin'),(19031,'Аренсбург','Ahrensburg','','Germany',276,'Europe/Berlin'),(19039,'Арнсберг','Arnsberg','','Germany',276,'Europe/Berlin'),(19045,'Арнштадт','Arnstadt','','Germany',276,'Europe/Berlin'),(19075,'Аттендорн','Attendorn','','Germany',276,'Europe/Berlin'),(19079,'Аттинг','Atting','','Germany',276,'Europe/Berlin'),(87679,'Ау','Au','','Germany',276,'Europe/Berlin'),(19091,'Аугсбург','Augsburg','','Germany',276,'Europe/Berlin'),(19109,'Аурих','Aurich','','Germany',276,'Europe/Berlin'),(19097,'Ауэ','Aue','','Germany',276,'Europe/Berlin'),(19099,'Ауэрбах','Auerbach','','Germany',276,'Europe/Berlin'),(19123,'Ахаус','Ahaus','','Germany',276,'Europe/Berlin'),(87488,'Ахен','Aachen','','Germany',276,'Europe/Berlin'),(19125,'Ахерн','Achern','','Germany',276,'Europe/Berlin'),(19127,'Ахим','Achim','','Germany',276,'Europe/Berlin'),(19139,'Аша','Ascha','','Germany',276,'Europe/Berlin'),(19145,'Ашаффенбург','Aschaffenburg','','Germany',276,'Europe/Berlin'),(19147,'Ашеберг','Ascheberg','','Germany',276,'Europe/Berlin'),(19149,'Ашерслебен','Aschersleben','','Germany',276,'Europe/Berlin'),(19159,'Бабенхаузен','Babenhausen','','Germany',276,'Europe/Berlin'),(19165,'Бад-Айблинг','Bad Aibling','','Germany',276,'Europe/Berlin'),(19175,'Бад-Бентхайм','Bad Bentheim','','Germany',276,'Europe/Berlin'),(19181,'Бад-Берлебург','Bad Berleburg','','Germany',276,'Europe/Berlin'),(19207,'Бад-Вильдунген','Bad Wildungen','','Germany',276,'Europe/Berlin'),(19371,'Бад-Гарцбург','Bad Harzburg','','Germany',276,'Europe/Berlin'),(19229,'Бад-Дрибург','Bad Driburg','','Germany',276,'Europe/Berlin'),(19235,'Бад-Дюркхайм','Bad Durkheim','','Germany',276,'Europe/Berlin'),(19247,'Бад-Зальцунген','Bad Salzungen','','Germany',276,'Europe/Berlin'),(19249,'Бад-Зальцуфлен','Bad Salzuflen','','Germany',276,'Europe/Berlin'),(19255,'Бад-Зегеберг','Bad Segeberg','','Germany',276,'Europe/Berlin'),(19349,'Бад-Зоден','Bad Soden am Taunus','','Germany',276,'Europe/Berlin'),(19273,'Бад-Киссинген','Bad Kissingen','','Germany',276,'Europe/Berlin'),(19285,'Бад-Кройцнах','Bad Kreuznach','','Germany',276,'Europe/Berlin'),(19305,'Бад-Липшпринге','Bad Lippspringe','','Germany',276,'Europe/Berlin'),(19309,'Бад-Мергентхайм','Bad Mergentheim','','Germany',276,'Europe/Berlin'),(19317,'Бад-Мюнстерайфель','Bad Munstereifel','','Germany',276,'Europe/Berlin'),(19319,'Бад-Наухайм','Bad Nauheim','','Germany',276,'Europe/Berlin'),(19323,'Бад-Нойенар-Арвайлер','Bad Neuenahr-Ahrweiler','','Germany',276,'Europe/Berlin'),(19329,'Бад-Ольдеслоэ','Bad Oldesloe','','Germany',276,'Europe/Berlin'),(19335,'Бад-Пирмонт','Bad Pyrmont','','Germany',276,'Europe/Berlin'),(19339,'Бад-Раппенау','Bad Rappenau','','Germany',276,'Europe/Berlin'),(19203,'Бад-Фильбель','Bad Vilbel','','Germany',276,'Europe/Berlin'),(19375,'Бад-Херсфельд','Bad Hersfeld','','Germany',276,'Europe/Berlin'),(19377,'Бад-Хомбург','Bad Homburg vor der Hohe','','Germany',276,'Europe/Berlin'),(87826,'Бад-Хомбург','Bad Homburg','','Germany',276,'Europe/Berlin'),(87828,'Бад-Хоннеф','Bad Honnef','','Germany',276,'Europe/Berlin'),(19381,'Бад-Цвишенан','Bad Zwischenahn','','Germany',276,'Europe/Berlin'),(19387,'Бад-Швартау','Bad Schwartau','','Germany',276,'Europe/Berlin'),(19327,'Бад-Эйнхаузен','Bad Oeynhausen','','Germany',276,'Europe/Berlin'),(19401,'Бад-Эссен','Bad Essen','','Germany',276,'Europe/Berlin'),(19407,'Баден-Баден','Baden-Baden','','Germany',276,'Europe/Berlin'),(19441,'Байройт','Bayreuth','','Germany',276,'Europe/Berlin'),(19537,'Бакнанг','Backnang','','Germany',276,'Europe/Berlin'),(19445,'Балинген','Balingen','','Germany',276,'Europe/Berlin'),(19447,'Балинген','Bahlingen','','Germany',276,'Europe/Berlin'),(19457,'Бамберг','Bamberg','','Germany',276,'Europe/Berlin'),(19461,'Бан','Bann','','Germany',276,'Europe/Berlin'),(19155,'Бар','Baar','','Germany',276,'Europe/Berlin'),(19501,'Барзингхаузен','Barsinghausen','','Germany',276,'Europe/Berlin'),(19505,'Барт','Barth','','Germany',276,'Europe/Berlin'),(19519,'Бассум','Bassum','','Germany',276,'Europe/Berlin'),(19527,'Баунаталь','Baunatal','','Germany',276,'Europe/Berlin'),(19531,'Баутцен','Bautzen','','Germany',276,'Europe/Berlin'),(19859,'Бёбинг','Bobing','','Germany',276,'Europe/Berlin'),(19541,'Бебра','Bebra','','Germany',276,'Europe/Berlin'),(19549,'Бедбург','Bedburg','','Germany',276,'Europe/Berlin'),(19573,'Беккум','Beckum','','Germany',276,'Europe/Berlin'),(19571,'Бексбах','Bexbach','','Germany',276,'Europe/Berlin'),(19553,'Белен','Beelen','','Germany',276,'Europe/Berlin'),(19909,'Бёлен','Bohlen','','Germany',276,'Europe/Berlin'),(19577,'Белль','Bell','','Germany',276,'Europe/Berlin'),(19585,'Бельм','Belm','','Germany',276,'Europe/Berlin'),(19595,'Бендорф','Bendorf','','Germany',276,'Europe/Berlin'),(19599,'Бендорф','Benndorf','','Germany',276,'Europe/Berlin'),(19611,'Бенсхайм','Bensheim','','Germany',276,'Europe/Berlin'),(19621,'Берга','Berga','','Germany',276,'Europe/Berlin'),(19627,'Берге','Berge','','Germany',276,'Europe/Berlin'),(19629,'Берген','Bergen','','Germany',276,'Europe/Berlin'),(19633,'Бергкамен','Bergkamen','','Germany',276,'Europe/Berlin'),(19639,'Бергнойштадт','Bergneustadt','','Germany',276,'Europe/Berlin'),(19643,'Бергхайм','Bergheim','','Germany',276,'Europe/Berlin'),(19651,'Беринген','Behringen','','Germany',276,'Europe/Berlin'),(19657,'Берлин','Berlin','','Germany',276,'Europe/Berlin'),(88085,'Берн','Berne','','Germany',276,'Europe/Berlin'),(19493,'Бернау','Barnau','','Germany',276,'Europe/Berlin'),(88084,'Бернау','Bernau bei Berlin','','Germany',276,'Europe/Berlin'),(19667,'Бернбург','Bernburg','','Germany',276,'Europe/Berlin'),(19695,'Берхтесгаден','Berchtesgaden','','Germany',276,'Europe/Berlin'),(19413,'Бесвайлер','Baesweiler','','Germany',276,'Europe/Berlin'),(19711,'Биберах','Biberach','','Germany',276,'Europe/Berlin'),(19713,'Биберах-на-Рисе','Biberach an der Riss','','Germany',276,'Europe/Berlin'),(5406,'Билефельд','Bielefeld','','Germany',276,'Europe/Berlin'),(19739,'Бинген','Bingen','','Germany',276,'Europe/Berlin'),(19741,'Бинген-на-Рейне','Bingen am Rhein','','Germany',276,'Europe/Berlin'),(88188,'Биннинген','Binningen','','Germany',276,'Europe/Berlin'),(19751,'Бире','Biere','','Germany',276,'Europe/Berlin'),(19771,'Бисмарк','Bismark','','Germany',276,'Europe/Berlin'),(19787,'Битигхайм-Биссинген','Bietigheim-Bissingen','','Germany',276,'Europe/Berlin'),(19789,'Биттерфельд','Bitterfeld','','Germany',276,'Europe/Berlin'),(19849,'Блискастель','Blieskastel','','Germany',276,'Europe/Berlin'),(19851,'Бломберг','Blomberg','','Germany',276,'Europe/Berlin'),(19861,'Бобинген','Bobingen ','','Germany',276,'Europe/Berlin'),(5410,'Бонн','Bonn','','Germany',276,'Europe/Berlin'),(19945,'Боппард','Boppard','','Germany',276,'Europe/Berlin'),(19961,'Боркен','Borken','','Germany',276,'Europe/Berlin'),(19965,'Борна','Borna','','Germany',276,'Europe/Berlin'),(19969,'Борнхайм','Bornheim','','Germany',276,'Europe/Berlin'),(19941,'Бос','Boos','','Germany',276,'Europe/Berlin'),(19989,'Ботроп','Bottrop','','Germany',276,'Europe/Berlin'),(19995,'Бохольт','Bocholt','','Germany',276,'Europe/Berlin'),(19997,'Бохум','Bochum','','Germany',276,'Europe/Berlin'),(20025,'Бракель','Brakel','','Germany',276,'Europe/Berlin'),(20031,'Брамше','Bramsche','','Germany',276,'Europe/Berlin'),(88367,'Бранденбург','Brandenburg','','Germany',276,'Europe/Berlin'),(20039,'Брандис','Brandis','','Germany',276,'Europe/Berlin'),(5416,'Брауншвейг','Braunschweig','','Germany',276,'Europe/Berlin'),(20067,'Бремен','Bremen','','Germany',276,'Europe/Berlin'),(20071,'Бремерхафен','Bremerhaven','','Germany',276,'Europe/Berlin'),(88366,'Бренд','Brand','','Germany',276,'Europe/Berlin'),(20077,'Бреттен','Bretten','','Germany',276,'Europe/Berlin'),(20087,'Брилон','Brilon','','Germany',276,'Europe/Berlin'),(20111,'Брук','Bruck','','Germany',276,'Europe/Berlin'),(20113,'Брук','Bruck in der Oberpfalz','','Germany',276,'Europe/Berlin'),(20119,'Брухзаль','Bruchsal','','Germany',276,'Europe/Berlin'),(20121,'Брухкёбель','Bruchkobel','','Germany',276,'Europe/Berlin'),(20273,'Брюгген','Bruggen','','Germany',276,'Europe/Berlin'),(20281,'Брюль','Bruhl','','Germany',276,'Europe/Berlin'),(20145,'Букстехуде','Buxtehude','','Germany',276,'Europe/Berlin'),(20153,'Бунде','Bunde','','Germany',276,'Europe/Berlin'),(20159,'Бург','Burg','','Germany',276,'Europe/Berlin'),(20161,'Бург','Burg bei Magdeburg','','Germany',276,'Europe/Berlin'),(88476,'Бургведель','Burgwedel','','Germany',276,'Europe/Berlin'),(20175,'Бургдорф','Burgdorf','','Germany',276,'Europe/Berlin'),(20193,'Бургхаузен','Burghausen','','Germany',276,'Europe/Berlin'),(19991,'Бус','Bous','','Germany',276,'Europe/Berlin'),(20253,'Бухгольц','Buchholz','','Germany',276,'Europe/Berlin'),(20255,'Бухгольц-ин-дер-Нордхайде','Buchholz in der Nordheide','','Germany',276,'Europe/Berlin'),(20227,'Буцбах','Butzbach','','Germany',276,'Europe/Berlin'),(20133,'Бюдинген','Budingen','','Germany',276,'Europe/Berlin'),(20139,'Бюккебург','Buckeburg','','Germany',276,'Europe/Berlin'),(28355,'Вагхойзель','Waghausel','','Germany',276,'Europe/Berlin'),(28357,'Вадгассен','Wadgassen','','Germany',276,'Europe/Berlin'),(28359,'Вадерн','Wadern','','Germany',276,'Europe/Berlin'),(28373,'Вайблинген','Waiblingen','','Germany',276,'Europe/Berlin'),(28381,'Вайден','Weiden','','Germany',276,'Europe/Berlin'),(28393,'Вайдхофен','Waidhofen','','Germany',276,'Europe/Berlin'),(28421,'Вайлерсвист','Weilerswist','','Germany',276,'Europe/Berlin'),(28425,'Вайль','Weil','','Germany',276,'Europe/Berlin'),(28423,'Вайль-дер-Штадт','Weil der Stadt','','Germany',276,'Europe/Berlin'),(28429,'Вайль-на-Рейне','Weil am Rhein','','Germany',276,'Europe/Berlin'),(28439,'Вайльхайм','Weilheim','','Germany',276,'Europe/Berlin'),(28447,'Вайн','Wain','','Germany',276,'Europe/Berlin'),(28453,'Вайнгартен','Weingarten','','Germany',276,'Europe/Berlin'),(28459,'Вайнхайм','Weinheim','','Germany',276,'Europe/Berlin'),(94840,'Вайнштадт','Weinstadt','','Germany',276,'Europe/Berlin'),(28467,'Вайсвассер','Weisswasser','','Germany',276,'Europe/Berlin'),(28721,'Вайсенфельс','Weissenfels','','Germany',276,'Europe/Berlin'),(28481,'Вайтерштадт','Weiterstadt','','Germany',276,'Europe/Berlin'),(28509,'Валленхорст','Wallenhorst','','Germany',276,'Europe/Berlin'),(28347,'Валь','Waal','','Germany',276,'Europe/Berlin'),(28527,'Вальд','Wald','','Germany',276,'Europe/Berlin'),(28567,'Вальдкрайбург','Waldkraiburg','','Germany',276,'Europe/Berlin'),(28505,'Вальдсхут-Тинген','Waldshut-Tiengen','','Germany',276,'Europe/Zurich'),(28593,'Вальсроде','Walsrode','','Germany',276,'Europe/Berlin'),(28599,'Вальтроп','Waltrop','','Germany',276,'Europe/Berlin'),(28607,'Ванг','Wang','','Germany',276,'Europe/Berlin'),(28611,'Ванген','Wangen','','Germany',276,'Europe/Berlin'),(28613,'Ванген','Wangen im Allgau','','Germany',276,'Europe/Berlin'),(94725,'Варберг','Warberg','','Germany',276,'Europe/Berlin'),(28633,'Варбург','Warburg','','Germany',276,'Europe/Berlin'),(28635,'Варденбург','Wardenburg','','Germany',276,'Europe/Berlin'),(28637,'Варен','Waren','','Germany',276,'Europe/Berlin'),(28639,'Варендорф','Warendorf','','Germany',276,'Europe/Berlin'),(28659,'Варштайн','Warstein','','Germany',276,'Europe/Berlin'),(28663,'Вассенберг','Wassenberg','','Germany',276,'Europe/Berlin'),(28689,'Вахтберг','Wachtberg','','Germany',276,'Europe/Berlin'),(28697,'Вегберг','Wegberg','','Germany',276,'Europe/Berlin'),(94734,'Ведемарк','Wedemark','','Germany',276,'Europe/Berlin'),(28713,'Везель','Wesel','','Germany',276,'Europe/Berlin'),(28443,'Веймар','Weimar','','Germany',276,'Europe/Berlin'),(28743,'Вендельштайн','Wendelstein','','Germany',276,'Europe/Berlin'),(28745,'Венден','Wenden','','Germany',276,'Europe/Berlin'),(28707,'Венер','Weener','','Germany',276,'Europe/Berlin'),(28757,'Вер','Wehr','','Germany',276,'Europe/Berlin'),(28763,'Верда','Werda','','Germany',276,'Europe/Berlin'),(28765,'Вердау','Werdau','','Germany',276,'Europe/Berlin'),(95087,'Вёрден','Wohrden','','Germany',276,'Europe/Berlin'),(28767,'Вердер','Werder','','Germany',276,'Europe/Berlin'),(28769,'Вердоль','Werdohl','','Germany',276,'Europe/Berlin'),(28773,'Верль','Werl','','Germany',276,'Europe/Berlin'),(28777,'Вермельскирхен','Wermelskirchen','','Germany',276,'Europe/Berlin'),(94921,'Верне','Werne','','Germany',276,'Europe/Berlin'),(28787,'Вернигероде','Wernigerode','','Germany',276,'Europe/Berlin'),(28709,'Вес','Wees','','Germany',276,'Europe/Berlin'),(28803,'Весселинг','Wesseling','','Germany',276,'Europe/Berlin'),(94922,'Весте','Weste','','Germany',276,'Europe/Berlin'),(28831,'Вестерстеде','Westerstede','','Germany',276,'Europe/Berlin'),(94929,'Вестоферлединген','Westoverledingen','','Germany',276,'Europe/Berlin'),(28841,'Веттер','Wetter (Ruhr)','','Germany',276,'Europe/Berlin'),(28843,'Веттин','Wettin','','Germany',276,'Europe/Berlin'),(28853,'Вецлар','Wetzlar','','Germany',276,'Europe/Berlin'),(28873,'Вида','Wieda','','Germany',276,'Europe/Berlin'),(28915,'Виллих','Willich','','Germany',276,'Europe/Berlin'),(29149,'Виль','Wyhl','','Germany',276,'Europe/Berlin'),(94940,'Виль','Wiehl','','Germany',276,'Europe/Berlin'),(28949,'Вильгельмсхафен','Wilhelmshaven','','Germany',276,'Europe/Berlin'),(28933,'Вильнсдорф','Wilnsdorf','','Germany',276,'Europe/Berlin'),(95030,'Виндек','Windeck','','Germany',276,'Europe/Berlin'),(28981,'Винзен','Winsen','','Germany',276,'Europe/Berlin'),(28977,'Винненден','Winnenden','','Germany',276,'Europe/Berlin'),(28999,'Випперфюрт','Wipperfurth','','Germany',276,'Europe/Berlin'),(95000,'Вис','Wies','','Germany',276,'Europe/Berlin'),(28883,'Висбаден','Wiesbaden','','Germany',276,'Europe/Berlin'),(28899,'Вислох','Wiesloch','','Germany',276,'Europe/Berlin'),(28901,'Висмар','Wismar','','Germany',276,'Europe/Berlin'),(29029,'Витмунд','Wittmund','','Germany',276,'Europe/Berlin'),(29015,'Виттен','Witten','','Germany',276,'Europe/Berlin'),(95073,'Виттенберг','Wittenberg','','Germany',276,'Europe/Berlin'),(29017,'Виттенберге','Wittenberge','','Germany',276,'Europe/Berlin'),(29027,'Виттлих','Wittlich','','Germany',276,'Europe/Berlin'),(29035,'Витце','Wietze','','Germany',276,'Europe/Berlin'),(29037,'Витцен','Wietzen','','Germany',276,'Europe/Berlin'),(29041,'Витценхаузен','Witzenhausen','','Germany',276,'Europe/Berlin'),(29073,'Вольфен','Wolfen','','Germany',276,'Europe/Berlin'),(29075,'Вольфенбюттель','Wolfenbuttel','','Germany',276,'Europe/Berlin'),(29085,'Вольфратсхаузен','Wolfratshausen','','Germany',276,'Europe/Berlin'),(29087,'Вольфсбург','Wolfsburg','','Germany',276,'Europe/Berlin'),(29101,'Вормс','Worms','','Germany',276,'Europe/Berlin'),(29105,'Ворт','Worth','','Germany',276,'Europe/Berlin'),(29125,'Вунсторф','Wunstorf','','Germany',276,'Europe/Berlin'),(95112,'Вупперталь','Wuppertal','','Germany',276,'Europe/Berlin'),(29137,'Вурцен','Wurzen','','Germany',276,'Europe/Berlin'),(95110,'Вюльфрат','Wulfrath','','Germany',276,'Europe/Berlin'),(29159,'Вюрзелен','Wurselen','','Germany',276,'Europe/Berlin'),(29161,'Вюрцбург','Wurzburg','','Germany',276,'Europe/Berlin'),(20297,'Гаггенау','Gaggenau','','Germany',276,'Europe/Berlin'),(20319,'Гайленкирхен','Geilenkirchen','','Germany',276,'Europe/Berlin'),(20333,'Гайслинген','Geislingen','','Germany',276,'Europe/Berlin'),(5483,'Галле','Halle','','Germany',276,'Europe/Berlin'),(5485,'Гамбург','Hamburg','','Germany',276,'Europe/Berlin'),(20347,'Гандеркезее','Ganderkesee','','Germany',276,'Europe/Berlin'),(90106,'Ганновер','Hannover','','Germany',276,'Europe/Berlin'),(90105,'Ганновер-Мюнден','Hann. Munden','','Germany',276,'Europe/Berlin'),(20355,'Гармиш-Партенкирхен','Garmisch-Partenkirchen','','Germany',276,'Europe/Berlin'),(89593,'Гармиш-Партенкирхен','Garmisch','','Germany',276,'Europe/Berlin'),(20383,'Гаутинг','Gauting','','Germany',276,'Europe/Berlin'),(20401,'Гезеке','Geseke','','Germany',276,'Europe/Berlin'),(20409,'Гельдерн','Geldern','','Germany',276,'Europe/Berlin'),(89604,'Гельзенкирхен','Gelsenkirchen','','Germany',276,'Europe/Berlin'),(20415,'Гельнхаузен','Gelnhausen','','Germany',276,'Europe/Berlin'),(20441,'Георгсмариенхютте','Georgsmarienhutte','','Germany',276,'Europe/Berlin'),(20611,'Гёппинген','Goppingen','','Germany',276,'Europe/Berlin'),(5471,'Гера','Gera','','Germany',276,'Europe/Berlin'),(20455,'Герде','Gehrde','','Germany',276,'Europe/Berlin'),(89766,'Гёрде','Gohrde','','Germany',276,'Europe/Berlin'),(20459,'Геретсрид','Geretsried','','Germany',276,'Europe/Berlin'),(20463,'Герлинген','Gerlingen','','Germany',276,'Europe/Berlin'),(20617,'Гёрлиц','Gorlitz','','Germany',276,'Europe/Berlin'),(89765,'Гёрлиц','Goerlitz','','Germany',276,'Europe/Berlin'),(20465,'Гермеринг','Germering','','Germany',276,'Europe/Berlin'),(20467,'Гермерсхайм','Germersheim','','Germany',276,'Europe/Berlin'),(20491,'Герстофен','Gersthofen','','Germany',276,'Europe/Berlin'),(20399,'Гестахт','Geesthacht','','Germany',276,'Europe/Berlin'),(89776,'Гёттинген','Gottingen','','Germany',276,'Europe/Berlin'),(20393,'Гефельсберг','Gevelsberg','','Germany',276,'Europe/Berlin'),(20515,'Гешер','Gescher','','Germany',276,'Europe/Berlin'),(89693,'Гинген-на-Бренце','Giengen','','Germany',276,'Europe/Berlin'),(20535,'Гинсхайм-Густавсбург','Ginsheim-Gustavsburg','','Germany',276,'Europe/Berlin'),(20539,'Гиссен','Giessen','','Germany',276,'Europe/Berlin'),(20543,'Гифхорн','Gifhorn','','Germany',276,'Europe/Berlin'),(20545,'Гладбек','Gladbeck','','Germany',276,'Europe/Berlin'),(20565,'Глаухау','Glauchau','','Germany',276,'Europe/Berlin'),(20567,'Глинде','Glinde','','Germany',276,'Europe/Berlin'),(87612,'Гнев','Anger','','Germany',276,'Europe/Berlin'),(20625,'Гослар','Goslar','','Germany',276,'Europe/Berlin'),(20633,'Гота','Gotha','','Germany',276,'Europe/Berlin'),(20641,'Гох','Goch','','Germany',276,'Europe/Berlin'),(20651,'Грабов','Grabow','','Germany',276,'Europe/Berlin'),(89849,'Грайфсвальд','Greifswald','','Germany',276,'Europe/Berlin'),(20661,'Грайц','Greiz','','Germany',276,'Europe/Berlin'),(20707,'Гревен','Greven','','Germany',276,'Europe/Berlin'),(20709,'Гревенброх','Grevenbroich','','Germany',276,'Europe/Berlin'),(20753,'Грёнинген','Groningen','','Germany',276,'Europe/Berlin'),(20725,'Грефрат','Grefrath','','Germany',276,'Europe/Berlin'),(20727,'Гримма','Grimma','','Germany',276,'Europe/Berlin'),(20731,'Грисхайм','Griesheim','','Germany',276,'Europe/Berlin'),(20751,'Гронау','Gronau','','Germany',276,'Europe/Berlin'),(20781,'Грос-Герау','Gross-Gerau','','Germany',276,'Europe/Berlin'),(20785,'Грос-Умштадт','Gross-Umstadt','','Germany',276,'Europe/Berlin'),(20889,'Груб','Grub','','Germany',276,'Europe/Berlin'),(89936,'Грубе','Grube','','Germany',276,'Europe/Berlin'),(20911,'Губен','Guben','','Germany',276,'Europe/Berlin'),(20919,'Гуммерсбах','Gummersbach','','Germany',276,'Europe/Berlin'),(20953,'Гюнцбург','Gunzburg','','Germany',276,'Europe/Berlin'),(20957,'Гюстров','Gustrow','','Germany',276,'Europe/Berlin'),(20959,'Гютерсло','Gutersloh','','Germany',276,'Europe/Berlin'),(89941,'Гютерсло','Guetersloh','','Germany',276,'Europe/Berlin'),(21095,'Дамме','Damme','','Germany',276,'Europe/Berlin'),(21101,'Дан','Dahn','','Germany',276,'Europe/Berlin'),(21113,'Дармштадт','Darmstadt','','Germany',276,'Europe/Berlin'),(21121,'Даттельн','Datteln','','Germany',276,'Europe/Berlin'),(21125,'Даун','Daun','','Germany',276,'Europe/Berlin'),(21129,'Дахау','Dachau','','Germany',276,'Europe/Berlin'),(21407,'Дёбельн','Dobeln','','Germany',276,'Europe/Berlin'),(21133,'Деггендорф','Deggendorf','','Germany',276,'Europe/Berlin'),(21143,'Делич','Delitzsch','','Germany',276,'Europe/Berlin'),(21147,'Дельбрюк','Delbruck','','Germany',276,'Europe/Berlin'),(21149,'Дельменхорст','Delmenhorst','','Germany',276,'Europe/Berlin'),(21177,'Дессау','Dessau','','Germany',276,'Europe/Berlin'),(88698,'Детмольд','Detmold','','Germany',276,'Europe/Berlin'),(21191,'Дибург','Dieburg','','Germany',276,'Europe/Berlin'),(21197,'Дилленбург','Dillenburg','','Germany',276,'Europe/Berlin'),(21199,'Диллинген','Dillingen','','Germany',276,'Europe/Berlin'),(88778,'Диллинген','Dillingen/Saar','','Germany',276,'Europe/Berlin'),(21215,'Динслакен','Dinslaken','','Germany',276,'Europe/Berlin'),(21263,'Дитценбах','Dietzenbach','','Germany',276,'Europe/Berlin'),(21265,'Дитцинген','Ditzingen','','Germany',276,'Europe/Berlin'),(21267,'Диц','Diez','','Germany',276,'Europe/Berlin'),(21271,'Добель','Dobel','','Germany',276,'Europe/Berlin'),(21293,'Дома','Dohma','','Germany',276,'Europe/Berlin'),(21301,'Дона','Dohna','','Germany',276,'Europe/Berlin'),(21305,'Донауэшинген','Donaueschingen','','Germany',276,'Europe/Berlin'),(21315,'Дормаген','Dormagen','','Germany',276,'Europe/Berlin'),(21331,'Дорстен','Dorsten','','Germany',276,'Europe/Berlin'),(21333,'Дортмунд','Dortmund','','Germany',276,'Europe/Berlin'),(21355,'Драйайх','Dreieich','','Germany',276,'Europe/Berlin'),(21371,'Дрезден','Dresden','','Germany',276,'Europe/Berlin'),(21385,'Дудерштадт','Duderstadt','','Germany',276,'Europe/Berlin'),(21389,'Дуйсбург','Duisburg','','Germany',276,'Europe/Berlin'),(21409,'Дюльмен','Dulmen','','Germany',276,'Europe/Berlin'),(21413,'Дюрен','Duren','','Germany',276,'Europe/Berlin'),(21423,'Дюссельдорф','Duesseldorf','','Germany',276,'Europe/Berlin'),(88828,'Дюссельдорф','Dusseldorf','','Germany',276,'Europe/Berlin'),(26585,'Заальфельд','Saalfeld','','Germany',276,'Europe/Berlin'),(26609,'Зальц','Salz','','Germany',276,'Europe/Berlin'),(26615,'Зальцведель','Salzwedel','','Germany',276,'Europe/Berlin'),(26617,'Зальцкоттен','Salzkotten','','Germany',276,'Europe/Berlin'),(26631,'Зангерхаузен','Sangerhausen','','Germany',276,'Europe/Berlin'),(26961,'Зара','Saara','','Germany',276,'Europe/Berlin'),(26651,'Зарштедт','Sarstedt','','Germany',276,'Europe/Berlin'),(26695,'Зеветаль','Seevetal','','Germany',276,'Europe/Berlin'),(26697,'Зег','Seeg','','Germany',276,'Europe/Berlin'),(26715,'Зеехайм-Югенхайм','Seeheim-Jugenheim','','Germany',276,'Europe/Berlin'),(26701,'Зезен','Seesen','','Germany',276,'Europe/Berlin'),(26723,'Зелигенштадт','Seligenstadt','','Germany',276,'Europe/Berlin'),(26727,'Зельб','Selb','','Germany',276,'Europe/Berlin'),(26767,'Зёльде','Sohlde','','Germany',276,'Europe/Berlin'),(93746,'Зёльден','Solden','','Germany',276,'Europe/Berlin'),(26733,'Зельм','Selm','','Germany',276,'Europe/Berlin'),(26709,'Зельце','Seelze','','Germany',276,'Europe/Berlin'),(26865,'Зёммерда','Sommerda','','Germany',276,'Europe/Berlin'),(26743,'Зенде','Sehnde','','Germany',276,'Europe/Berlin'),(26745,'Зенден','Senden','','Germany',276,'Europe/Berlin'),(26753,'Зенфтенберг','Senftenberg','','Germany',276,'Europe/Berlin'),(26775,'Зигбург','Siegburg','','Germany',276,'Europe/Berlin'),(26781,'Зиген','Siegen','','Germany',276,'Europe/Berlin'),(26783,'Зигмаринген','Sigmaringen','','Germany',276,'Europe/Berlin'),(26791,'Зик','Siek','','Germany',276,'Europe/Berlin'),(26941,'Зике','Syke','','Germany',276,'Europe/Berlin'),(26805,'Зиммерат','Simmerath','','Germany',276,'Europe/Berlin'),(26817,'Зинген','Singen','','Germany',276,'Europe/Berlin'),(26821,'Зиндельфинген','Sindelfingen','','Germany',276,'Europe/Berlin'),(26825,'Зинсхайм','Sinsheim','','Germany',276,'Europe/Berlin'),(26827,'Зинциг','Sinzig','','Germany',276,'Europe/Berlin'),(26855,'Золинген','Solingen','','Germany',276,'Europe/Berlin'),(26863,'Зольтау','Soltau','','Germany',276,'Europe/Berlin'),(26869,'Зондерсхаузен','Sondershausen','','Germany',276,'Europe/Berlin'),(26871,'Зоннеберг','Sonneberg','','Germany',276,'Europe/Berlin'),(26887,'Зонтхофен','Sonthofen','','Germany',276,'Europe/Berlin'),(93998,'Зуль','Suhl','','Germany',276,'Europe/Berlin'),(26907,'Зульцбах','Sulzbach','','Germany',276,'Europe/Berlin'),(94006,'Зульцбах','Sulzbach/Saar','','Germany',276,'Europe/Berlin'),(26913,'Зульцбах-Розенберг','Sulzbach-Rosenberg','','Germany',276,'Europe/Berlin'),(26925,'Зундерн','Sundern','','Germany',276,'Europe/Berlin'),(22963,'Иббенбюрен','Ibbenburen','','Germany',276,'Europe/Berlin'),(22975,'Идар-Оберштайн','Idar-Oberstein','','Germany',276,'Europe/Berlin'),(22977,'Идштайн','Idstein','','Germany',276,'Europe/Berlin'),(22983,'Изерлон','Iserlohn','','Germany',276,'Europe/Berlin'),(90672,'Изернхаген','Isernhagen','','Germany',276,'Europe/Berlin'),(22995,'Иллинген','Illingen','','Germany',276,'Europe/Berlin'),(90632,'Илов','Ihlow','','Germany',276,'Europe/Berlin'),(90642,'Ильменау','Ilmenau','','Germany',276,'Europe/Berlin'),(28053,'Ильцен','Uelzen','','Germany',276,'Europe/Berlin'),(90655,'Ингельхайм-на-Рейне','Ingelheim','','Germany',276,'Europe/Berlin'),(5506,'Ингольштадт','Ingolstadt','','Germany',276,'Europe/Berlin'),(23057,'Ирш','Irsch','','Germany',276,'Europe/Berlin'),(28059,'Итце','Uetze','','Germany',276,'Europe/Berlin'),(23083,'Итцехоэ','Itzehoe','','Germany',276,'Europe/Berlin'),(90776,'Йена','Jena','','Germany',276,'Europe/Berlin'),(90814,'Йорк','Jork','','Germany',276,'Europe/Berlin'),(90820,'Йюхен','Juchen','','Germany',276,'Europe/Berlin'),(23097,'Кайзерслаутерн','Kaiserslautern','','Germany',276,'Europe/Berlin'),(23103,'Кала','Kahla','','Germany',276,'Europe/Berlin'),(90892,'Каллеталь','Kalletal','','Germany',276,'Europe/Berlin'),(20977,'Кальв','Calw','','Germany',276,'Europe/Berlin'),(23117,'Кальтенкирхен','Kaltenkirchen','','Germany',276,'Europe/Berlin'),(23123,'Камен','Kamen','','Germany',276,'Europe/Berlin'),(23125,'Каменц','Kamenz','','Germany',276,'Europe/Berlin'),(23131,'Камп-Линтфорт','Kamp-Lintfort','','Germany',276,'Europe/Berlin'),(23145,'Карбен','Karben','','Germany',276,'Europe/Berlin'),(90900,'Карлсбад','Karlsbad','','Germany',276,'Europe/Berlin'),(23149,'Карлскрон','Karlskron','','Germany',276,'Europe/Berlin'),(23151,'Карлсруэ','Karlsruhe','','Germany',276,'Europe/Berlin'),(23153,'Карлсфельд','Karlsfeld','','Germany',276,'Europe/Berlin'),(23157,'Карлштадт','Karlstadt','','Germany',276,'Europe/Berlin'),(23089,'Карст','Kaarst','','Germany',276,'Europe/Berlin'),(5514,'Кассель','Kassel','','Germany',276,'Europe/Berlin'),(23171,'Кастль','Kastl','','Germany',276,'Europe/Berlin'),(20991,'Кастроп-Рауксель','Castrop-Rauxel','','Germany',276,'Europe/Berlin'),(26017,'Кведлинбург','Quedlinburg','','Germany',276,'Europe/Berlin'),(24307,'Квидзын','Marienwerder','','Germany',276,'Europe/Berlin'),(26023,'Квикборн','Quickborn','','Germany',276,'Europe/Berlin'),(23193,'Кевелар','Kevelaer','','Germany',276,'Europe/Berlin'),(23201,'Кель','Kehl','','Germany',276,'Europe/Berlin'),(23207,'Келькхайм','Kelkheim (Taunus)','','Germany',276,'Europe/Berlin'),(90905,'Келькхайм','Kelkheim','','Germany',276,'Europe/Berlin'),(5520,'Кёльн','Koeln','','Germany',276,'Europe/Berlin'),(88606,'Кёльн','Cologne','','Germany',276,'Europe/Berlin'),(23211,'Кельхайм','Kelheim','','Germany',276,'Europe/Berlin'),(21061,'Кемниц','Chemnitz','','Germany',276,'Europe/Berlin'),(23219,'Кемпен','Kempen','','Germany',276,'Europe/Berlin'),(23223,'Кемптен','Kempten (Allgaeu)','','Germany',276,'Europe/Berlin'),(90971,'Кемптен','Kempten','','Germany',276,'Europe/Berlin'),(23225,'Кен','Kenn','','Germany',276,'Europe/Berlin'),(23255,'Кёнигс-Вустерхаузен','Konigs Wusterhausen','','Germany',276,'Europe/Berlin'),(23261,'Кёнигсбрунн','Konigsbrunn','','Germany',276,'Europe/Berlin'),(23267,'Кёнигсвинтер','Konigswinter','','Germany',276,'Europe/Berlin'),(23275,'Кёнигштайн','Konigstein','','Germany',276,'Europe/Berlin'),(23229,'Керпен','Kerpen','','Germany',276,'Europe/Berlin'),(23283,'Кётен','Kothen','','Germany',276,'Europe/Berlin'),(23243,'Кеч','Ketsch','','Germany',276,'Europe/Berlin'),(5516,'Киль','Kiel','','Germany',276,'Europe/Berlin'),(23303,'Кирн','Kirn','','Germany',276,'Europe/Berlin'),(23307,'Кирспе','Kierspe','','Germany',276,'Europe/Berlin'),(23353,'Кирхгайм','Kirchheim','','Germany',276,'Europe/Berlin'),(23351,'Кирхгайм-унтер-Тек','Kirchheim unter Teck','','Germany',276,'Europe/Berlin'),(23345,'Кирхленгерн','Kirchlengern','','Germany',276,'Europe/Berlin'),(23389,'Китцинген','Kitzingen','','Germany',276,'Europe/Berlin'),(23395,'Клеве','Kleve','','Germany',276,'Europe/Berlin'),(21007,'Клоппенбург','Cloppenburg','','Germany',276,'Europe/Berlin'),(23449,'Кобленц','Koblenz','','Germany',276,'Europe/Berlin'),(21009,'Кобург','Coburg','','Germany',276,'Europe/Berlin'),(23455,'Кольмар','Kollmar','','Germany',276,'Europe/Berlin'),(23475,'Констанц','Konstanz','','Germany',276,'Europe/Zurich'),(23477,'Конц','Konz','','Germany',276,'Europe/Berlin'),(87984,'Кора','Bark','','Germany',276,'Europe/Berlin'),(23481,'Корб','Korb','','Germany',276,'Europe/Berlin'),(23483,'Корбах','Korbach','','Germany',276,'Europe/Berlin'),(21063,'Корин','Chorin','','Germany',276,'Europe/Berlin'),(23487,'Корнвестхайм','Kornwestheim','','Germany',276,'Europe/Berlin'),(23493,'Коршенбройх','Korschenbroich','','Germany',276,'Europe/Berlin'),(21025,'Косвиг','Coswig','','Germany',276,'Europe/Berlin'),(21027,'Котбус','Cottbus','','Germany',276,'Europe/Berlin'),(21033,'Крайльсхайм','Crailsheim','','Germany',276,'Europe/Berlin'),(93014,'Красные','Rodt','','Germany',276,'Europe/Berlin'),(23539,'Крёф','Krov','','Germany',276,'Europe/Berlin'),(91094,'Крефельд','Krefeld','','Germany',276,'Europe/Berlin'),(21041,'Криммичау','Crimmitschau','','Germany',276,'Europe/Berlin'),(91101,'Крин','Krien','','Germany',276,'Europe/Berlin'),(23549,'Кройцау','Kreuzau','','Germany',276,'Europe/Berlin'),(23553,'Кройцталь','Kreuztal','','Germany',276,'Europe/Berlin'),(23561,'Кронах','Kronach','','Germany',276,'Europe/Berlin'),(23563,'Кронберг','Kronberg','','Germany',276,'Europe/Berlin'),(23571,'Кроп','Kropp','','Germany',276,'Europe/Berlin'),(25273,'Ксантен','Xanten','','Germany',276,'Europe/Berlin'),(21053,'Куксхафен','Cuxhaven','','Germany',276,'Europe/Berlin'),(23595,'Кульмбах','Kulmbach','','Germany',276,'Europe/Berlin'),(23645,'Кюртен','Kurten','','Germany',276,'Europe/Berlin'),(91196,'Кюстен','Kusten','','Germany',276,'Europe/Berlin'),(23665,'Лабё','Laboe','','Germany',276,'Europe/Berlin'),(23657,'Лаге','Laage','','Germany',276,'Europe/Berlin'),(23669,'Лаге','Lage','','Germany',276,'Europe/Berlin'),(24189,'Лаймен','Leimen','','Germany',276,'Europe/Berlin'),(24199,'Лайнфельден-Эхтердинген','Leinfelden-Echterdingen','','Germany',276,'Europe/Berlin'),(23679,'Лайхинген','Laichingen','','Germany',276,'Europe/Berlin'),(24209,'Лайхлинген','Leichlingen','','Germany',276,'Europe/Berlin'),(23695,'Лампертхайм','Lampertheim','','Germany',276,'Europe/Berlin'),(23713,'Ланген','Langen','','Germany',276,'Europe/Berlin'),(23747,'Лангенфельд','Langenfeld','','Germany',276,'Europe/Berlin'),(23749,'Лангенхаген','Langenhagen','','Germany',276,'Europe/Berlin'),(23771,'Ландау','Landau in der Pfalz','','Germany',276,'Europe/Berlin'),(91285,'Ландау','Landau/Pfalz','','Germany',276,'Europe/Berlin'),(23777,'Ландсберг','Landsberg','','Germany',276,'Europe/Berlin'),(23781,'Ландсхут','Landshut','','Germany',276,'Europe/Berlin'),(23659,'Лар','Laar','','Germany',276,'Europe/Berlin'),(23793,'Лар','Lahr','','Germany',276,'Europe/Berlin'),(91282,'Лар','Lahr/Schwarzwald','','Germany',276,'Europe/Berlin'),(23661,'Латцен','Laatzen','','Germany',276,'Europe/Berlin'),(23817,'Лауда-Кёнигсхофен','Lauda-Konigshofen','','Germany',276,'Europe/Berlin'),(23819,'Лаупхайм','Laupheim','','Germany',276,'Europe/Berlin'),(91369,'Лаута','Lauta','','Germany',276,'Europe/Berlin'),(23837,'Лауф','Lauf','','Germany',276,'Europe/Berlin'),(23849,'Лауха','Laucha','','Germany',276,'Europe/Berlin'),(24213,'Лебах','Lebach','','Germany',276,'Europe/Berlin'),(23867,'Леверкузен','Leverkusen','','Germany',276,'Europe/Berlin'),(23875,'Лезе','Leese','','Germany',276,'Europe/Berlin'),(23885,'Лейпциг','Leipzig','','Germany',276,'Europe/Berlin'),(24211,'Лек','Leck','','Germany',276,'Europe/Berlin'),(23891,'Лемго','Lemgo','','Germany',276,'Europe/Berlin'),(23903,'Ленгерих','Lengerich','','Germany',276,'Europe/Berlin'),(23909,'Леннештадт','Lennestadt','','Germany',276,'Europe/Berlin'),(23917,'Леонберг','Leonberg','','Germany',276,'Europe/Berlin'),(23877,'Лер','Leer','','Germany',276,'Europe/Berlin'),(24071,'Лёррах','Lorrach','','Germany',276,'Europe/Berlin'),(23927,'Лерте','Lehrte','','Germany',276,'Europe/Berlin'),(23947,'Лимбах','Limbach','','Germany',276,'Europe/Berlin'),(23949,'Лимбах-Оберфрона','Limbach-Oberfrohna','','Germany',276,'Europe/Berlin'),(91393,'Лимбург','Limburg','','Germany',276,'Europe/Berlin'),(23955,'Линген','Lingen','','Germany',276,'Europe/Berlin'),(23959,'Линдау','Lindau','','Germany',276,'Europe/Berlin'),(23969,'Линдлар','Lindlar','','Germany',276,'Europe/Berlin'),(91404,'Линц','Linz','','Germany',276,'Europe/Berlin'),(23983,'Липпштадт','Lippstadt','','Germany',276,'Europe/Berlin'),(23989,'Лист','List','','Germany',276,'Europe/Berlin'),(23991,'Лих','Lich','','Germany',276,'Europe/Berlin'),(24173,'Лихен','Lychen','','Germany',276,'Europe/Berlin'),(23993,'Лихте','Lichte','','Germany',276,'Europe/Berlin'),(24001,'Лихтенфельс','Lichtenfels','','Germany',276,'Europe/Berlin'),(24019,'Лоза','Lohsa','','Germany',276,'Europe/Berlin'),(24041,'Лойткирх','Leutkirch im Allgau','','Germany',276,'Europe/Berlin'),(24053,'Ломар','Lohmar','','Germany',276,'Europe/Berlin'),(24059,'Лоне','Lohne','','Germany',276,'Europe/Berlin'),(24107,'Лука','Lucka','','Germany',276,'Europe/Berlin'),(24111,'Луккенвальде','Luckenwalde','','Germany',276,'Europe/Berlin'),(24131,'Люббекке','Lubbecke','','Germany',276,'Europe/Berlin'),(24133,'Люббен','Lubben','','Germany',276,'Europe/Berlin'),(24135,'Люббенау','Lubbenau','','Germany',276,'Europe/Berlin'),(24137,'Любек','Lubeck','','Germany',276,'Europe/Berlin'),(24147,'Людвигсбург','Ludwigsburg','','Germany',276,'Europe/Berlin'),(24151,'Людвигсфельде','Ludwigsfelde','','Germany',276,'Europe/Berlin'),(24155,'Людвигсхафен','Ludwigshafen','','Germany',276,'Europe/Berlin'),(24159,'Люденшайд','Ludenscheid','','Germany',276,'Europe/Berlin'),(24129,'Людингхаузен','Ludinghausen','','Germany',276,'Europe/Berlin'),(24163,'Люнебург','Luneburg','','Germany',276,'Europe/Berlin'),(24165,'Люнен','Lunen','','Germany',276,'Europe/Berlin'),(24217,'Магдебург','Magdeburg','','Germany',276,'Europe/Berlin'),(24223,'Майен','Mayen','','Germany',276,'Europe/Berlin'),(91607,'Майне','Meine','','Germany',276,'Europe/Berlin'),(24243,'Майнерцхаген','Meinerzhagen','','Germany',276,'Europe/Berlin'),(24245,'Майнинген','Meiningen','','Germany',276,'Europe/Berlin'),(24249,'Майнталь','Maintal','','Germany',276,'Europe/Berlin'),(24253,'Майнц','Mainz','','Germany',276,'Europe/Berlin'),(24287,'Мангейм','Mannheim','','Germany',276,'Europe/Berlin'),(24297,'Марбург','Marburg an der Lahn','','Germany',276,'Europe/Berlin'),(91579,'Марбург','Marburg','','Germany',276,'Europe/Berlin'),(91586,'Марклеберг','Markkleeberg','','Germany',276,'Europe/Berlin'),(24359,'Марктобердорф','Marktoberdorf','','Germany',276,'Europe/Berlin'),(24361,'Марктредвиц','Marktredwitz','','Germany',276,'Europe/Berlin'),(24375,'Марль','Marl','','Germany',276,'Europe/Berlin'),(5550,'Марниц','Marnitz','','Germany',276,'Europe/Berlin'),(24387,'Марсберг','Marsberg','','Germany',276,'Europe/Berlin'),(91580,'Март','March','','Germany',276,'Europe/Berlin'),(24431,'Мейсен','Meissen','','Germany',276,'Europe/Berlin'),(24437,'Меккенхайм','Meckenheim','','Germany',276,'Europe/Berlin'),(24445,'Мелле','Melle','','Germany',276,'Europe/Berlin'),(24643,'Мёльн','Molln','','Germany',276,'Europe/Berlin'),(24463,'Мемминген','Memmingen','','Germany',276,'Europe/Berlin'),(24475,'Менден','Menden','','Germany',276,'Europe/Berlin'),(5559,'Мёнхенгладбах','Moenchengladbach','','Germany',276,'Europe/Berlin'),(24669,'Мёнхенгладбах','Monchengladbach','','Germany',276,'Europe/Berlin'),(24483,'Меппен','Meppen','','Germany',276,'Europe/Berlin'),(24427,'Мербуш','Meerbusch','','Germany',276,'Europe/Berlin'),(91605,'Мерен','Mehren','','Germany',276,'Europe/Berlin'),(24489,'Мерзебург','Merseburg','','Germany',276,'Europe/Berlin'),(24623,'Мёрс','Moers','','Germany',276,'Europe/Berlin'),(24707,'Мёрфельден-Вальдорф','Morfelden-Walldorf','','Germany',276,'Europe/Berlin'),(24513,'Мерциг','Merzig','','Germany',276,'Europe/Berlin'),(24709,'Мёссинген','Mossingen','','Germany',276,'Europe/Berlin'),(24535,'Меттман','Mettmann','','Germany',276,'Europe/Berlin'),(91774,'Мётцинг','Motzing','','Germany',276,'Europe/Berlin'),(24539,'Метцинген','Metzingen','','Germany',276,'Europe/Berlin'),(24717,'Мётцинген','Motzingen','','Germany',276,'Europe/Berlin'),(24537,'Мехерних','Mechernich','','Germany',276,'Europe/Berlin'),(24541,'Мешеде','Meschede','','Germany',276,'Europe/Berlin'),(24553,'Мила','Mihla','','Germany',276,'Europe/Berlin'),(24569,'Минден','Minden','','Germany',276,'Europe/Berlin'),(24577,'Мисте','Mieste','','Germany',276,'Europe/Berlin'),(24601,'Миттенвальд','Mittenwald','','Germany',276,'Europe/Berlin'),(24689,'Мос','Moos','','Germany',276,'Europe/Berlin'),(24679,'Мосбах','Moosbach','','Germany',276,'Europe/Berlin'),(91789,'Мур','Muhr','','Germany',276,'Europe/Berlin'),(24741,'Мург','Murg','','Germany',276,'Europe/Berlin'),(24751,'Мух','Much','','Germany',276,'Europe/Berlin'),(24759,'Мюлакер','Muhlacker','','Germany',276,'Europe/Berlin'),(24769,'Мюльхайм','Mullheim','','Germany',276,'Europe/Berlin'),(91855,'Мюльхайм-на-Руре','Mulheim/Ruhr','','Germany',276,'Europe/Berlin'),(24783,'Мюльхаузен','Muhlhausen','','Germany',276,'Europe/Berlin'),(24787,'Мюнзинг','Munsing','','Germany',276,'Europe/Berlin'),(24789,'Мюнзинген','Munsingen','','Germany',276,'Europe/Berlin'),(24793,'Мюнстер','Munster','','Germany',276,'Europe/Berlin'),(24807,'Мюнхен','Muenchen','','Germany',276,'Europe/Berlin'),(91858,'Мюнхен','Munchen','','Germany',276,'Europe/Berlin'),(91862,'Мюнхен','Munich','','Germany',276,'Europe/Berlin'),(24827,'Нагольд','Nagold','','Germany',276,'Europe/Berlin'),(91934,'Нассау','Nassau','','Germany',276,'Europe/Berlin'),(24855,'Наумбург','Naumburg','','Germany',276,'Europe/Berlin'),(24851,'Науэн','Nauen','','Germany',276,'Europe/Berlin'),(24871,'Невель','Newel','','Germany',276,'Europe/Berlin'),(24881,'Неккарзульм','Neckarsulm','','Germany',276,'Europe/Berlin'),(24911,'Нетпхен','Netphen','','Germany',276,'Europe/Berlin'),(24909,'Неттеталь','Nettetal','','Germany',276,'Europe/Berlin'),(24919,'Нидда','Nidda','','Germany',276,'Europe/Berlin'),(24921,'Ниддерау','Nidderau','','Germany',276,'Europe/Berlin'),(24953,'Нидеркассель','Niederkassel','','Germany',276,'Europe/Berlin'),(24997,'Нинбург','Nienburg','','Germany',276,'Europe/Berlin'),(92155,'Нинбург','Nienburg/Weser','','Germany',276,'Europe/Berlin'),(92043,'Нове Замки','Neuhausel','','Germany',276,'Europe/Berlin'),(25037,'Новый Ульм','Neu-Ulm','','Germany',276,'Europe/Berlin'),(25033,'Ной-Анспах','Neu-Anspach','','Germany',276,'Europe/Berlin'),(25027,'Ной-Вульмсторф','Neu Wulmstorf','','Germany',276,'Europe/Berlin'),(91949,'Ной-Изенбург','Neu-Isenburg','','Germany',276,'Europe/Berlin'),(25047,'Нойбранденбург','Neubrandenburg','','Germany',276,'Europe/Berlin'),(25061,'Нойвид','Neuwied','','Germany',276,'Europe/Berlin'),(25103,'Нойкирх','Neukirch','','Germany',276,'Europe/Berlin'),(92053,'Нойкирхен','Neukirchen/Pleisse','','Germany',276,'Europe/Berlin'),(25117,'Ноймарк','Neumark','','Germany',276,'Europe/Berlin'),(25115,'Ноймаркт','Neumarkt in der Oberpfalz','','Germany',276,'Europe/Berlin'),(25121,'Ноймюнстер','Neumunster','','Germany',276,'Europe/Berlin'),(25127,'Нойнкирхен','Neunkirchen','','Germany',276,'Europe/Berlin'),(25139,'Нойруппин','Neuruppin','','Germany',276,'Europe/Berlin'),(25143,'Нойс','Neuss','','Germany',276,'Europe/Berlin'),(25179,'Нойштадт','Neustadt','','Germany',276,'Europe/Berlin'),(25181,'Нойштадт','Neustadt in Holstein','','Germany',276,'Europe/Berlin'),(25189,'Нойштадт','Neustadt an der Weinstrasse','','Germany',276,'Europe/Berlin'),(25207,'Норден','Norden','','Germany',276,'Europe/Berlin'),(25211,'Норденхам','Nordenham','','Germany',276,'Europe/Berlin'),(25213,'Нордерштедт','Norderstedt','','Germany',276,'Europe/Berlin'),(25223,'Нордхаузен','Nordhausen','','Germany',276,'Europe/Berlin'),(25229,'Нордхорн','Nordhorn','','Germany',276,'Europe/Berlin'),(25247,'Ноттульн','Nottuln','','Germany',276,'Europe/Berlin'),(25265,'Нюмбрехт','Numbrecht','','Germany',276,'Europe/Berlin'),(25269,'Нюрнберг','Nurnberg','','Germany',276,'Europe/Berlin'),(25271,'Нюртинген','Nurtingen','','Germany',276,'Europe/Berlin'),(25305,'Обер-Рамштадт','Ober-Ramstadt','','Germany',276,'Europe/Berlin'),(25311,'Оберасбах','Oberasbach','','Germany',276,'Europe/Berlin'),(25351,'Оберкирх','Oberkirch','','Germany',276,'Europe/Berlin'),(25441,'Оберстдорф','Oberstdorf','','Germany',276,'Europe/Berlin'),(25411,'Обертсхаузен','Obertshausen','','Germany',276,'Europe/Berlin'),(25415,'Оберурзель','Oberursel','','Germany',276,'Europe/Berlin'),(25423,'Оберхаузен','Oberhausen','','Germany',276,'Europe/Berlin'),(25455,'Овен','Owen','','Germany',276,'Europe/Berlin'),(25457,'Оверат','Overath','','Germany',276,'Europe/Berlin'),(21503,'Ойскирхен','Euskirchen','','Germany',276,'Europe/Berlin'),(25471,'Ойтен','Oyten','','Germany',276,'Europe/Berlin'),(25285,'Ольде','Oelde','','Germany',276,'Europe/Berlin'),(25479,'Ольденбург','Oldenburg in Holstein','','Germany',276,'Europe/Berlin'),(92417,'Ольденбург','Oldenburg','','Germany',276,'Europe/Berlin'),(25485,'Ольпе','Olpe','','Germany',276,'Europe/Berlin'),(25489,'Ольсберг','Olsberg','','Germany',276,'Europe/Berlin'),(25493,'Ольхинг','Olching','','Germany',276,'Europe/Berlin'),(25517,'Ораниенбург','Oranienburg','','Germany',276,'Europe/Berlin'),(25541,'Оснабрюк','Osnabruck','','Germany',276,'Europe/Berlin'),(25551,'Остен','Osten','','Germany',276,'Europe/Berlin'),(25567,'Остерхольц-Шармбек','Osterholz-Scharmbeck','','Germany',276,'Europe/Berlin'),(25593,'Остфильдерн','Ostfildern','','Germany',276,'Europe/Berlin'),(25647,'Оффенбург','Offenburg','','Germany',276,'Europe/Berlin'),(25681,'Падерборн','Paderborn','','Germany',276,'Europe/Berlin'),(25685,'Пайне','Peine','','Germany',276,'Europe/Berlin'),(92450,'Пален','Pahlen','','Germany',276,'Europe/Berlin'),(25703,'Папенбург','Papenburg','','Germany',276,'Europe/Berlin'),(25721,'Пархим','Parchim','','Germany',276,'Europe/Berlin'),(25725,'Пассау','Passau','','Germany',276,'Europe/Berlin'),(25749,'Пенцберг','Penzberg','','Germany',276,'Europe/Berlin'),(25765,'Петерсхаген','Petershagen','','Germany',276,'Europe/Berlin'),(25781,'Пиннеберг','Pinneberg','','Germany',276,'Europe/Berlin'),(25789,'Пирмазенс','Pirmasens','','Germany',276,'Europe/Berlin'),(25791,'Пирна','Pirna','','Germany',276,'Europe/Berlin'),(25817,'Плауэ','Plaue','','Germany',276,'Europe/Berlin'),(25819,'Плауэн','Plauen','','Germany',276,'Europe/Berlin'),(25825,'Плеттенберг','Plettenberg','','Germany',276,'Europe/Berlin'),(25869,'Порта-Вестфалика','Porta Westfalica','','Germany',276,'Europe/Berlin'),(25875,'Потсдам','Potsdam','','Germany',276,'Europe/Berlin'),(25893,'Пренцлау','Prenzlau','','Germany',276,'Europe/Berlin'),(25889,'Прец','Preetz','','Germany',276,'Europe/Berlin'),(25941,'Пульхайм','Pulheim','','Germany',276,'Europe/Berlin'),(25971,'Пфаффенхофен','Pfaffenhofen','','Germany',276,'Europe/Berlin'),(25987,'Пфорцгейм','Pforzheim','','Germany',276,'Europe/Berlin'),(25997,'Пфунгштадт','Pfungstadt','','Germany',276,'Europe/Berlin'),(92534,'Пщина','Pless','','Germany',276,'Europe/Berlin'),(26003,'Пютлинген','Puttlingen','','Germany',276,'Europe/Berlin'),(26031,'Равенсбург','Ravensburg','','Germany',276,'Europe/Berlin'),(26039,'Радеберг','Radeberg','','Germany',276,'Europe/Berlin'),(26041,'Радебойль','Radebeul','','Germany',276,'Europe/Berlin'),(26047,'Раден','Rahden','','Germany',276,'Europe/Berlin'),(26045,'Радеформвальд','Radevormwald','','Germany',276,'Europe/Berlin'),(92790,'Радольфцелль','Radolfzell','','Germany',276,'Europe/Berlin'),(26061,'Райн','Rain','','Germany',276,'Europe/Berlin'),(26065,'Райнбах','Rheinbach','','Germany',276,'Europe/Berlin'),(26067,'Райнбек','Reinbek','','Germany',276,'Europe/Berlin'),(26069,'Райнберг','Rheinberg','','Germany',276,'Europe/Berlin'),(26075,'Райне','Rheine','','Germany',276,'Europe/Berlin'),(26085,'Райнфельд','Reinfeld','','Germany',276,'Europe/Berlin'),(26087,'Райнфельден','Rheinfelden','','Germany',276,'Europe/Berlin'),(26095,'Райнштеттен','Rheinstetten','','Germany',276,'Europe/Berlin'),(26101,'Райт-им-Винкль','Reit im Winkl','','Germany',276,'Europe/Berlin'),(26109,'Райхенбах','Reichenbach','','Germany',276,'Europe/Berlin'),(26123,'Райшах','Reischach','','Germany',276,'Europe/Berlin'),(26155,'Растеде','Rastede','','Germany',276,'Europe/Berlin'),(26161,'Ратекау','Ratekau','','Germany',276,'Europe/Berlin'),(26163,'Ратенов','Rathenow','','Germany',276,'Europe/Berlin'),(26165,'Ратинген','Ratingen','','Germany',276,'Europe/Berlin'),(92923,'Раудерфен','Rhauderfehn','','Germany',276,'Europe/Berlin'),(26191,'Раштатт','Rastatt','','Germany',276,'Europe/Berlin'),(26195,'Реген','Regen','','Germany',276,'Europe/Berlin'),(26197,'Регенсбург','Regensburg','','Germany',276,'Europe/Berlin'),(26205,'Реда-Виденбрюк','Rheda-Wiedenbruck','','Germany',276,'Europe/Berlin'),(26209,'Реде','Rhede','','Germany',276,'Europe/Berlin'),(26211,'Реден','Rehden','','Germany',276,'Europe/Berlin'),(26225,'Реклингхаузен','Recklinghausen','','Germany',276,'Europe/Berlin'),(26227,'Релинг','Rehling','','Germany',276,'Europe/Berlin'),(26233,'Ремаген','Remagen','','Germany',276,'Europe/Berlin'),(26241,'Ремшайд','Remscheid','','Germany',276,'Europe/Berlin'),(26243,'Рена','Rehna','','Germany',276,'Europe/Berlin'),(26247,'Рендсбург','Rendsburg','','Germany',276,'Europe/Berlin'),(26253,'Реннинген','Renningen','','Germany',276,'Europe/Berlin'),(26213,'Рес','Rees','','Germany',276,'Europe/Berlin'),(26447,'Рёсрат','Rosrath','','Germany',276,'Europe/Berlin'),(26469,'Рёта','Rotha','','Germany',276,'Europe/Berlin'),(26293,'Рибниц-Дамгартен','Ribnitz-Damgarten','','Germany',276,'Europe/Berlin'),(26295,'Ригель','Riegel','','Germany',276,'Europe/Berlin'),(26297,'Ригельсберг','Riegelsberg','','Germany',276,'Europe/Berlin'),(26299,'Рид','Ried','','Germany',276,'Europe/Berlin'),(26317,'Ридштадт','Riedstadt','','Germany',276,'Europe/Berlin'),(26319,'Риза','Riesa','','Germany',276,'Europe/Berlin'),(26341,'Ринтельн','Rinteln','','Germany',276,'Europe/Berlin'),(26351,'Ритберг','Rietberg','','Germany',276,'Europe/Berlin'),(26373,'Родгау','Rodgau','','Germany',276,'Europe/Berlin'),(26385,'Розенберг','Rosenberg','','Germany',276,'Europe/Berlin'),(26393,'Розенхайм','Rosenheim','','Germany',276,'Europe/Berlin'),(26403,'Ройт','Reut','','Germany',276,'Europe/Berlin'),(26405,'Ройтлинген','Reutlingen','','Germany',276,'Europe/Berlin'),(26427,'Ронненберг','Ronnenberg','','Germany',276,'Europe/Berlin'),(26453,'Росла','Rossla','','Germany',276,'Europe/Berlin'),(26463,'Росток','Rostock','','Germany',276,'Europe/Berlin'),(26465,'Рот','Roth','','Germany',276,'Europe/Berlin'),(93149,'Ротвайль','Rottweil','','Germany',276,'Europe/Berlin'),(26479,'Ротенбург','Rothenburg','','Germany',276,'Europe/Berlin'),(26481,'Ротенбург','Rotenburg','','Germany',276,'Europe/Berlin'),(26491,'Ротт','Rott','','Germany',276,'Europe/Berlin'),(93155,'Рудерсдорф','Rudersdorf','','Germany',276,'Europe/Berlin'),(26531,'Рудольштадт','Rudolstadt','','Germany',276,'Europe/Berlin'),(26555,'Руст','Rust','','Germany',276,'Europe/Berlin'),(26577,'Рюссельсхайм','Russelsheim','','Germany',276,'Europe/Berlin'),(26963,'Саарбрюккен','Saarbrucken','','Germany',276,'Europe/Berlin'),(26969,'Саарлуис','Saarlouis','','Germany',276,'Europe/Berlin'),(26977,'Санкт-Августин','Sankt Augustin','','Germany',276,'Europe/Berlin'),(26981,'Санкт-Вендель','Sankt Wendel','','Germany',276,'Europe/Berlin'),(26973,'Санкт-Вольфганг','Sankt Wolfgang','','Germany',276,'Europe/Berlin'),(26989,'Санкт-Ингберт','Sankt Ingbert','','Germany',276,'Europe/Berlin'),(27001,'Санкт-Петер','Sankt Peter','','Germany',276,'Europe/Berlin'),(93330,'Сейлем','Salem','','Germany',276,'Europe/Berlin'),(93630,'Сек','Seck','','Germany',276,'Europe/Berlin'),(93865,'Ставерн','Stavern','','Germany',276,'Europe/Berlin'),(93868,'Стейн','Stein','','Germany',276,'Europe/Berlin'),(27635,'Таверн','Tawern','','Germany',276,'Europe/Berlin'),(27653,'Тале','Thale','','Germany',276,'Europe/Berlin'),(27699,'Таунусштайн','Taunusstein','','Germany',276,'Europe/Berlin'),(27701,'Таура','Taura','','Germany',276,'Europe/Berlin'),(27703,'Тауфкирхен','Taufkirchen','','Germany',276,'Europe/Berlin'),(27725,'Тельгте','Telgte','','Germany',276,'Europe/Berlin'),(27727,'Тельтов','Teltow','','Germany',276,'Europe/Berlin'),(27731,'Темплин','Templin','','Germany',276,'Europe/Berlin'),(27799,'Тёнисфорст','Tonisvorst','','Germany',276,'Europe/Berlin'),(94140,'Терес','Theres','','Germany',276,'Europe/Berlin'),(27749,'Теттнанг','Tettnang','','Germany',276,'Europe/Berlin'),(94164,'Тольк','Tolk','','Germany',276,'Europe/Berlin'),(27805,'Торгау','Torgau','','Germany',276,'Europe/Berlin'),(27825,'Траунройт','Traunreut','','Germany',276,'Europe/Berlin'),(27827,'Траунштайн','Traunstein','','Germany',276,'Europe/Berlin'),(27855,'Трир','Trier','','Germany',276,'Europe/Berlin'),(27865,'Тройсдорф','Troisdorf','','Germany',276,'Europe/Berlin'),(27875,'Троссинген','Trossingen','','Germany',276,'Europe/Berlin'),(27889,'Тум','Thum','','Germany',276,'Europe/Berlin'),(27905,'Тутлинген','Tuttlingen','','Germany',276,'Europe/Berlin'),(27909,'Тюбинген','Tubingen','','Germany',276,'Europe/Berlin'),(94375,'Ульм','Ulm','','Germany',276,'Europe/Berlin'),(27951,'Унна','Unna','','Germany',276,'Europe/Berlin'),(27997,'Унтерхахинг','Unterhaching','','Germany',276,'Europe/Berlin'),(27999,'Унтершлайсхайм','Unterschleissheim','','Germany',276,'Europe/Berlin'),(28027,'Услар','Uslar','','Germany',276,'Europe/Berlin'),(94533,'Фале','Vaale','','Germany',276,'Europe/Berlin'),(21899,'Фалькенберг','Falkenberg','','Germany',276,'Europe/Berlin'),(21901,'Фалькензе','Falkensee','','Germany',276,'Europe/Berlin'),(28073,'Фарель','Varel','','Germany',276,'Europe/Berlin'),(28075,'Фатерштеттен','Vaterstetten','','Germany',276,'Europe/Berlin'),(21923,'Фелльбах','Fellbach','','Germany',276,'Europe/Berlin'),(28121,'Фёль','Vohl','','Germany',276,'Europe/Berlin'),(28087,'Фельберт','Velbert','','Germany',276,'Europe/Berlin'),(21931,'Фельдкирхен','Feldkirchen','','Germany',276,'Europe/Berlin'),(28195,'Фёльклинген','Volklingen','','Germany',276,'Europe/Berlin'),(89391,'Фельм','Felm','','Germany',276,'Europe/Berlin'),(28085,'Фельмар','Vellmar','','Germany',276,'Europe/Berlin'),(28123,'Фёрде','Voerde','','Germany',276,'Europe/Berlin'),(28101,'Ферден','Verden','','Germany',276,'Europe/Berlin'),(21943,'Фёрен','Fohren','','Germany',276,'Europe/Berlin'),(28105,'Ферль','Verl','','Germany',276,'Europe/Berlin'),(28107,'Ферсмольд','Versmold','','Germany',276,'Europe/Berlin'),(28115,'Фехельде','Vechelde','','Germany',276,'Europe/Berlin'),(28117,'Фехта','Vechta','','Germany',276,'Europe/Berlin'),(26007,'Филипсбург','Philippsburg','','Germany',276,'Europe/Berlin'),(28127,'Филлинген-Швеннинген','Villingen-Schwenningen','','Germany',276,'Europe/Berlin'),(21947,'Фильдерштадт','Filderstadt','','Germany',276,'Europe/Berlin'),(21951,'Финнентроп','Finnentrop','','Germany',276,'Europe/Berlin'),(21957,'Финстервальде','Finsterwalde','','Germany',276,'Europe/Berlin'),(28177,'Фирзен','Viersen','','Germany',276,'Europe/Berlin'),(28175,'Фирнхайм','Viernheim','','Germany',276,'Europe/Berlin'),(21979,'Фленсбург','Flensburg','','Germany',276,'Europe/Berlin'),(89418,'Флёрсхайм-на-Майне','Florsheim am Main','','Germany',276,'Europe/Berlin'),(28149,'Флото','Vlotho','','Germany',276,'Europe/Berlin'),(22005,'Форбах','Forbach','','Germany',276,'Europe/Berlin'),(94544,'Форбах','Vorbach','','Germany',276,'Europe/Berlin'),(22007,'Форст','Forst','','Germany',276,'Europe/Berlin'),(22013,'Форхгайм','Forchheim','','Germany',276,'Europe/Berlin'),(22017,'Фрайберг','Freiberg','','Germany',276,'Europe/Berlin'),(5455,'Фрайбург','Freiburg','','Germany',276,'Europe/Berlin'),(89440,'Фрайбург','Freiburg/Elbe','','Germany',276,'Europe/Berlin'),(22027,'Фрайзинг','Freising','','Germany',276,'Europe/Berlin'),(22021,'Фрайлассинг','Freilassing','','Germany',276,'Europe/Berlin'),(22029,'Фрайталь','Freital','','Germany',276,'Europe/Berlin'),(22043,'Франкенталь','Frankenthal','','Germany',276,'Europe/Berlin'),(89428,'Франкфурт-на-Майне','Frankfurt','','Germany',276,'Europe/Berlin'),(89429,'Франкфурт-на-Майне','Frankfurt/Main','','Germany',276,'Europe/Berlin'),(22063,'Фреден','Freden','','Germany',276,'Europe/Berlin'),(22127,'Фрёнденберг-на-Руре','Frondenberg','','Germany',276,'Europe/Berlin'),(28169,'Фрес','Vrees','','Germany',276,'Europe/Berlin'),(22075,'Фрехен','Frechen','','Germany',276,'Europe/Berlin'),(22077,'Фридберг','Friedberg','','Germany',276,'Europe/Berlin'),(22093,'Фридрихсдорф','Friedrichsdorf','','Germany',276,'Europe/Berlin'),(22097,'Фридрихсхафен','Friedrichshafen','','Germany',276,'Europe/Berlin'),(22111,'Фризойте','Friesoythe','','Germany',276,'Europe/Berlin'),(22131,'Фройденберг','Freudenberg','','Germany',276,'Europe/Berlin'),(22137,'Фройденштадт','Freudenstadt','','Germany',276,'Europe/Berlin'),(89490,'Фульда','Fulda','','Germany',276,'Europe/Berlin'),(22157,'Фюрстенвальде','Furstenwalde','','Germany',276,'Europe/Berlin'),(89500,'Фюрстенфельдбрук','Furstenfeldbruck','','Germany',276,'Europe/Berlin'),(22169,'Фюссен','Fussen','','Germany',276,'Europe/Berlin'),(22205,'Хаг','Haag in Oberbayern','','Germany',276,'Europe/Berlin'),(22221,'Хаге','Hage','','Germany',276,'Europe/Berlin'),(22227,'Хаген','Hagen','','Germany',276,'Europe/Berlin'),(90132,'Хазель','Hasel','','Germany',276,'Europe/Berlin'),(22247,'Хайгер','Haiger','','Germany',276,'Europe/Berlin'),(22253,'Хайде','Heide','','Germany',276,'Europe/Berlin'),(90201,'Хайдельберг','Heidelberg','','Germany',276,'Europe/Berlin'),(22257,'Хайден','Heiden','','Germany',276,'Europe/Berlin'),(22259,'Хайденау','Heidenau','','Germany',276,'Europe/Berlin'),(22261,'Хайденхайм-на-Бренце','Heidenheim','','Germany',276,'Europe/Berlin'),(22275,'Хайлигенхаус','Heiligenhaus','','Germany',276,'Europe/Berlin'),(90212,'Хайльбронн','Heilbronn','','Germany',276,'Europe/Berlin'),(22317,'Хайнсберг','Heinsberg','','Germany',276,'Europe/Berlin'),(22319,'Хайст','Heist','','Germany',276,'Europe/Berlin'),(22327,'Хальбе','Halbe','','Germany',276,'Europe/Berlin'),(22339,'Хальберштадт','Halberstadt','','Germany',276,'Europe/Berlin'),(22347,'Хальденслебен','Haldensleben','','Germany',276,'Europe/Berlin'),(22351,'Хальстенбек','Halstenbek','','Germany',276,'Europe/Berlin'),(22353,'Хальтерн-ам-Зее','Haltern','','Germany',276,'Europe/Berlin'),(22363,'Хамельн','Hameln','','Germany',276,'Europe/Berlin'),(21057,'Хамм','Hamm','','Germany',276,'Europe/Berlin'),(22365,'Хамма','Hammah','','Germany',276,'Europe/Berlin'),(22371,'Хамминкельн','Hamminkeln','','Germany',276,'Europe/Berlin'),(22209,'Хан','Haan','','Germany',276,'Europe/Berlin'),(90103,'Ханау','Hanau','','Germany',276,'Europe/Berlin'),(22211,'Хар','Haar','','Germany',276,'Europe/Berlin'),(22407,'Харен','Haren','','Germany',276,'Europe/Berlin'),(22415,'Харзевинкель','Harsewinkel','','Germany',276,'Europe/Berlin'),(22449,'Хаслох','Hassloch','','Germany',276,'Europe/Berlin'),(90136,'Хаслох','Hasloch','','Germany',276,'Europe/Berlin'),(22461,'Хаттерсхайм-на-Майне','Hattersheim','','Germany',276,'Europe/Berlin'),(22465,'Хаттинген','Hattingen','','Germany',276,'Europe/Berlin'),(22179,'Хёкстер','Hoxter','','Germany',276,'Europe/Berlin'),(22663,'Хелен','Hehlen','','Germany',276,'Europe/Berlin'),(22529,'Хельмштедт','Helmstedt','','Germany',276,'Europe/Berlin'),(22541,'Хемер','Hemer','','Germany',276,'Europe/Berlin'),(22543,'Хемминген','Hemmingen','','Germany',276,'Europe/Berlin'),(22855,'Хён','Hohn','','Germany',276,'Europe/Berlin'),(22557,'Хеннеф','Hennef','','Germany',276,'Europe/Berlin'),(22559,'Хеннигсдорф','Hennigsdorf','','Germany',276,'Europe/Berlin'),(22561,'Хенштедт','Hennstedt','','Germany',276,'Europe/Berlin'),(22565,'Хенштедт-Ульцбург','Henstedt-Ulzburg','','Germany',276,'Europe/Berlin'),(90249,'Хеппенхайм','Heppenheim','','Germany',276,'Europe/Berlin'),(22573,'Херборн','Herborn','','Germany',276,'Europe/Berlin'),(22585,'Хердекке','Herdecke','','Germany',276,'Europe/Berlin'),(90194,'Хере','Heere','','Germany',276,'Europe/Berlin'),(22605,'Херне','Herne','','Germany',276,'Europe/Berlin'),(22611,'Херренберг','Herrenberg','','Germany',276,'Europe/Berlin'),(22623,'Хертен','Herten','','Germany',276,'Europe/Berlin'),(22625,'Херфорд','Herford','','Germany',276,'Europe/Berlin'),(22633,'Херцогенаурах','Herzogenaurach','','Germany',276,'Europe/Berlin'),(22635,'Херцогенрат','Herzogenrath','','Germany',276,'Europe/Berlin'),(22639,'Хеспе','Hespe','','Germany',276,'Europe/Berlin'),(22647,'Хессиш-Ольдендорф','Hessisch Oldendorf','','Germany',276,'Europe/Berlin'),(22661,'Хехинген','Hechingen','','Germany',276,'Europe/Berlin'),(22683,'Хидденхаузен','Hiddenhausen','','Germany',276,'Europe/Berlin'),(22685,'Хилле','Hille','','Germany',276,'Europe/Berlin'),(22699,'Хильден','Hilden','','Germany',276,'Europe/Berlin'),(22703,'Хильдесхайм','Hildesheim','','Germany',276,'Europe/Berlin'),(5429,'Химинг','Chieming','','Germany',276,'Europe/Berlin'),(22727,'Хинте','Hinte','','Germany',276,'Europe/Berlin'),(22803,'Хойерсверда','Hoyerswerda','','Germany',276,'Europe/Berlin'),(91084,'Хойнице','Konitz','','Germany',276,'Europe/Berlin'),(22805,'Хойсвайлер','Heusweiler','','Germany',276,'Europe/Berlin'),(22819,'Хоккенхайм','Hockenheim','','Germany',276,'Europe/Berlin'),(22821,'Холле','Holle','','Germany',276,'Europe/Berlin'),(22835,'Хольм','Holm','','Germany',276,'Europe/Berlin'),(22843,'Хольцкирхен','Holzkirchen','','Germany',276,'Europe/Berlin'),(22847,'Хольцминден','Holzminden','','Germany',276,'Europe/Berlin'),(22853,'Хомбург','Homburg','','Germany',276,'Europe/Berlin'),(90408,'Хоне','Hohne','','Germany',276,'Europe/Berlin'),(90487,'Хорб-на-Неккаре','Horb','','Germany',276,'Europe/Berlin'),(90490,'Хорн-Бад-Майнберг','Horn-Bad Meinberg','','Germany',276,'Europe/Berlin'),(22885,'Хорст','Horst','','Germany',276,'Europe/Berlin'),(22893,'Хоф','Hof','','Germany',276,'Europe/Berlin'),(22897,'Хофгайсмар','Hofgeismar','','Germany',276,'Europe/Berlin'),(22901,'Хофхайм','Hofheim am Taunus','','Germany',276,'Europe/Berlin'),(22903,'Хофхайм','Hofheim in Unterfranken','','Germany',276,'Europe/Berlin'),(22755,'Хоэн-Нойендорф','Hohen Neuendorf','','Germany',276,'Europe/Berlin'),(22935,'Хузум','Husum','','Germany',276,'Europe/Berlin'),(22941,'Хюккельхофен','Huckelhoven','','Germany',276,'Europe/Berlin'),(22949,'Хюнфельд','Hunfeld','','Germany',276,'Europe/Berlin'),(22951,'Хюрт','Hurth','','Germany',276,'Europe/Berlin'),(28219,'Цайц','Zeitz','','Germany',276,'Europe/Berlin'),(28235,'Цвайбрюккен','Zweibrucken','','Germany',276,'Europe/Berlin'),(28243,'Цвиккау','Zwickau','','Germany',276,'Europe/Berlin'),(21065,'Целле','Celle','','Germany',276,'Europe/Berlin'),(28261,'Целль','Zell','','Germany',276,'Europe/Berlin'),(28271,'Цербст','Zerbst','','Germany',276,'Europe/Berlin'),(28295,'Цирндорф','Zirndorf','','Germany',276,'Europe/Berlin'),(28297,'Циттау','Zittau','','Germany',276,'Europe/Berlin'),(28335,'Цюльпих','Zulpich','','Germany',276,'Europe/Berlin'),(27057,'Швабах','Schwabach','','Germany',276,'Europe/Berlin'),(27077,'Швайнфурт','Schweinfurt','','Germany',276,'Europe/Berlin'),(27091,'Швальмталь','Schwalmtal','','Germany',276,'Europe/Berlin'),(27055,'Шван','Schwaan','','Germany',276,'Europe/Berlin'),(93615,'Швандорф','Schwandorf','','Germany',276,'Europe/Berlin'),(27101,'Шваневеде','Schwanewede','','Germany',276,'Europe/Berlin'),(27115,'Шварценберг','Schwarzenberg','','Germany',276,'Europe/Berlin'),(27061,'Швебиш-Гмюнд','Schwabisch Gmund','','Germany',276,'Europe/Berlin'),(27063,'Швебиш-Халль','Schwabisch Hall','','Germany',276,'Europe/Berlin'),(93626,'Шведт','Schwedt','','Germany',276,'Europe/Berlin'),(27127,'Швельм','Schwelm','','Germany',276,'Europe/Berlin'),(27137,'Шверин','Schwerin','','Germany',276,'Europe/Berlin'),(27139,'Шверте','Schwerte','','Germany',276,'Europe/Berlin'),(27141,'Шветцинген','Schwetzingen','','Germany',276,'Europe/Berlin'),(27327,'Шёнебек','Schonebeck','','Germany',276,'Europe/Berlin'),(27331,'Шёнек','Schoneck','','Germany',276,'Europe/Berlin'),(27161,'Шенефельд','Schenefeld','','Germany',276,'Europe/Berlin'),(27151,'Шер','Scheer','','Germany',276,'Europe/Berlin'),(27203,'Шифферштадт','Schifferstadt','','Germany',276,'Europe/Berlin'),(27227,'Шлезвиг','Schleswig','','Germany',276,'Europe/Berlin'),(93421,'Шлос-Хольте-Штукенброк','Schloss Holte-Stukenbrock','','Germany',276,'Europe/Berlin'),(27255,'Шлюхтерн','Schluchtern','','Germany',276,'Europe/Berlin'),(27257,'Шмалленберг','Schmallenberg','','Germany',276,'Europe/Berlin'),(27263,'Шмельц','Schmelz','','Germany',276,'Europe/Berlin'),(27353,'Шоп','Schopp','','Germany',276,'Europe/Berlin'),(27361,'Шопфхайм','Schopfheim','','Germany',276,'Europe/Berlin'),(27363,'Шорндорф','Schorndorf','','Germany',276,'Europe/Berlin'),(27367,'Шортенс','Schortens','','Germany',276,'Europe/Berlin'),(27375,'Шпейер','Speyer','','Germany',276,'Europe/Berlin'),(27391,'Шпенге','Spenge','','Germany',276,'Europe/Berlin'),(27409,'Шпремберг','Spremberg','','Germany',276,'Europe/Berlin'),(27413,'Шпринге','Springe','','Germany',276,'Europe/Berlin'),(27017,'Шпрокхёфель','Sprockhovel','','Germany',276,'Europe/Berlin'),(27415,'Шрамберг','Schramberg','','Germany',276,'Europe/Berlin'),(27421,'Шробенхаузен','Schrobenhausen','','Germany',276,'Europe/Berlin'),(27425,'Штаде','Stade','','Germany',276,'Europe/Berlin'),(27429,'Штадталлендорф','Stadtallendorf','','Germany',276,'Europe/Berlin'),(27441,'Штадтлон','Stadtlohn','','Germany',276,'Europe/Berlin'),(27449,'Штадтхаген','Stadthagen','','Germany',276,'Europe/Berlin'),(27487,'Штайнфурт','Steinfurt','','Germany',276,'Europe/Berlin'),(27513,'Штарнберг','Starnberg','','Germany',276,'Europe/Berlin'),(27515,'Штасфурт','Stassfurt','','Germany',276,'Europe/Berlin'),(27537,'Штендаль','Stendal','','Germany',276,'Europe/Berlin'),(27553,'Штоках','Stockach','','Germany',276,'Europe/Berlin'),(27563,'Штольберг','Stolberg','','Germany',276,'Europe/Berlin'),(27565,'Штольберг','Stollberg','','Germany',276,'Europe/Berlin'),(93972,'Штральзунд','Stralsund','','Germany',276,'Europe/Berlin'),(27591,'Штраубинг','Straubing','','Germany',276,'Europe/Berlin'),(27593,'Штраусберг','Strausberg','','Germany',276,'Europe/Berlin'),(27611,'Штур','Stuhr','','Germany',276,'Europe/Berlin'),(27613,'Штутгарт','Stuttgart','','Germany',276,'Europe/Berlin'),(21517,'Эбербах','Eberbach','','Germany',276,'Europe/Berlin'),(88916,'Эберсвальде','Eberswalde','','Germany',276,'Europe/Berlin'),(21585,'Эдевехт','Edewecht','','Germany',276,'Europe/Berlin'),(21445,'Эйзенах','Eisenach','','Germany',276,'Europe/Berlin'),(21605,'Эккернфёрде','Eckernforde','','Germany',276,'Europe/Berlin'),(89036,'Эльба','Elbe','','Germany',276,'Europe/Berlin'),(21621,'Эльванген','Ellwangen','','Germany',276,'Europe/Berlin'),(21637,'Эльмсхорн','Elmshorn','','Germany',276,'Europe/Berlin'),(21641,'Эльсдорф','Elsdorf','','Germany',276,'Europe/Berlin'),(21679,'Эмден','Emden','','Germany',276,'Europe/Berlin'),(21687,'Эммендинген','Emmendingen','','Germany',276,'Europe/Berlin'),(21691,'Эммерих-на-Рейне','Emmerich','','Germany',276,'Europe/Berlin'),(21697,'Эмсдеттен','Emsdetten','','Germany',276,'Europe/Berlin'),(21709,'Энгельскирхен','Engelskirchen','','Germany',276,'Europe/Berlin'),(21713,'Энгер','Enger','','Germany',276,'Europe/Berlin'),(21725,'Эннепеталь','Ennepetal','','Germany',276,'Europe/Berlin'),(21729,'Эннигерло','Ennigerloh','','Germany',276,'Europe/Berlin'),(21733,'Эппельборн','Eppelborn','','Germany',276,'Europe/Berlin'),(21743,'Эппинген','Eppingen','','Germany',276,'Europe/Berlin'),(89129,'Эрдинг','Erding','','Germany',276,'Europe/Berlin'),(21773,'Эринг','Ering','','Germany',276,'Europe/Berlin'),(25521,'Эринген','Ohringen','','Germany',276,'Europe/Berlin'),(21779,'Эркеленц','Erkelenz','','Germany',276,'Europe/Berlin'),(21785,'Эркрат','Erkrath','','Germany',276,'Europe/Berlin'),(21791,'Эрланген','Erlangen','','Germany',276,'Europe/Berlin'),(21817,'Эрфтштадт','Erftstadt','','Germany',276,'Europe/Berlin'),(5447,'Эрфурт','Erfurt','','Germany',276,'Europe/Berlin'),(21825,'Эспелькамп','Espelkamp','','Germany',276,'Europe/Berlin'),(21831,'Эссен','Essen','','Germany',276,'Europe/Berlin'),(21839,'Эсслинген-на-Неккаре','Esslingen','','Germany',276,'Europe/Berlin'),(21851,'Эттлинген','Ettlingen','','Germany',276,'Europe/Berlin'),(21863,'Эхинг','Eching','','Germany',276,'Europe/Berlin'),(21601,'Эхинген','Ehingen','','Germany',276,'Europe/Berlin'),(89247,'Эш','Esch','','Germany',276,'Europe/Berlin'),(21873,'Эшборн','Eschborn','','Germany',276,'Europe/Berlin'),(21875,'Эшвайлер','Eschweiler','','Germany',276,'Europe/Berlin'),(21877,'Эшвеге','Eschwege','','Germany',276,'Europe/Berlin'),(86670,'Алкмар','Alkmaar','','Netherlands',528,'Europe/Amsterdam'),(7457,'Амстердам','Amsterdam','','Netherlands',528,'America/Marigot'),(86672,'Ассен','Assen','','Netherlands',528,'Europe/Amsterdam'),(13480,'Бреда','Breda','','Netherlands',528,'Europe/Amsterdam'),(86697,'Вассенаар','Wassenaar','','Netherlands',528,'Europe/Amsterdam'),(13481,'Гаага','Hague','','Netherlands',528,'Europe/Amsterdam'),(86691,'Гаага','The Hague','','Netherlands',528,'Europe/Amsterdam'),(86679,'Гауда','Gouda','','Netherlands',528,'Europe/Amsterdam'),(7469,'Гилзе-Рижен','Gilze-Rijen','','Netherlands',528,'Europe/Amsterdam'),(86680,'Гронинген','Groningen','','Netherlands',528,'Europe/Amsterdam'),(7464,'Де Билт','De Bilt','','Netherlands',528,'Europe/Amsterdam'),(7465,'Де Коу','De Kooy','','Netherlands',528,'Europe/Amsterdam'),(86674,'Делфт','Delft','','Netherlands',528,'Europe/Amsterdam'),(86676,'Дордрехт','Dordrecht','','Netherlands',528,'Europe/Amsterdam'),(86687,'Лейден','Leiden','','Netherlands',528,'Europe/Amsterdam'),(7483,'Лелистад','Lelystad','','Netherlands',528,'Europe/Amsterdam'),(7482,'Леуварден','Leeuwarden','','Netherlands',528,'Europe/Amsterdam'),(86688,'Маастрихт','Maastricht','','Netherlands',528,'Europe/Amsterdam'),(7458,'Роттердам','Rotterdam','','Netherlands',528,'Europe/Amsterdam'),(86690,'Стадсканал','Stadskanaal','','Netherlands',528,'Europe/Amsterdam'),(7496,'Твентхе','Twenthe','','Netherlands',528,'Europe/Amsterdam'),(86692,'Тилбург','Tilburg','','Netherlands',528,'Europe/Amsterdam'),(7499,'Флиссинген','Vlissingen','','Netherlands',528,'Europe/Amsterdam'),(86682,'Хертогенбос','Hertogenbosch','','Netherlands',528,'Europe/Amsterdam'),(7473,'Хоек Ван  Холланд','Hoek Van Holland','','Netherlands',528,'Europe/Amsterdam'),(86686,'Хоорн','Hoorn','','Netherlands',528,'Europe/Amsterdam'),(7467,'Эйндховен','Eindhoven','','Netherlands',528,'Europe/Amsterdam'),(86678,'Эммелорд','Emmeloord','','Netherlands',528,'Europe/Amsterdam'),(5772,'Атту','Attu','','Greenland',304,'America/Godthab'),(5792,'Кулусук','Kulusuk','','Greenland',304,'America/Godthab'),(2926,'Агринион','Agrinion','','Greece',300,'Europe/Athens'),(51401,'Александруполис','Alexandroupolis','','Greece',300,'Europe/Athens'),(2931,'Андравида Аэропорт','Andravida Airport','','Greece',300,'Europe/Athens'),(88806,'Аргос','Argos','','Greece',300,'Europe/Athens'),(2933,'Арта','Arta','','Greece',300,'Europe/Athens'),(100,'Афины','Athenes','','Greece',300,'Europe/Athens'),(52349,'Волос','Volos','','Greece',300,'Europe/Athens'),(51525,'Драма','Drama','','Greece',300,'Europe/Athens'),(90644,'Закинф','Zakinthos','','Greece',300,'Europe/Athens'),(2941,'Иерапетра','Ierapetra','','Greece',300,'Europe/Athens'),(2940,'Ираклион','Irakleion','','Greece',300,'Europe/Athens'),(51649,'Итака','Ithaki','','Greece',300,'Europe/Athens'),(51657,'Кавала','Kavala','','Greece',300,'Europe/Athens'),(51671,'Каламата','Kalamata','','Greece',300,'Europe/Athens'),(51703,'Кардица','Karditsa','','Greece',300,'Europe/Athens'),(51717,'Кастория','Kastoria','','Greece',300,'Europe/Athens'),(51719,'Катерини','Katerini','','Greece',300,'Europe/Athens'),(13443,'Керкира','Kerkyra','','Greece',300,'Europe/Athens'),(88906,'Керкира','Corfu','','Greece',300,'Europe/Athens'),(51767,'Козани','Kozani','','Greece',300,'Europe/Athens'),(51779,'Комотини','Komotini','','Greece',300,'Europe/Athens'),(51507,'Коринф','Corinth','','Greece',300,'Europe/Athens'),(52369,'Ксанти','Xanthi','','Greece',300,'Europe/Athens'),(2952,'Ламия','Lamia','','Greece',300,'Europe/Athens'),(2953,'Лариса','Larisa','','Greece',300,'Europe/Athens'),(2954,'Лемнос','Limnos','','Greece',300,'Europe/Athens'),(51935,'Мегара','Megara','','Greece',300,'Europe/Athens'),(2955,'Месони','Methoni','','Greece',300,'Europe/Athens'),(2956,'Милос','Milos','','Greece',300,'Europe/Athens'),(2958,'Наксос','Naxos','','Greece',300,'Europe/Athens'),(51989,'Нафплион','Nafplio','','Greece',300,'Europe/Athens'),(89863,'Нафплион','Navplion','','Greece',300,'Europe/Athens'),(89974,'Патмос','Patmos','','Greece',300,'Europe/Athens'),(2959,'Патры','Patrai','','Greece',300,'Europe/Athens'),(52157,'Перистери','Peristerion','','Greece',300,'Europe/Athens'),(2960,'Пирей','Piraeus','','Greece',300,'Europe/Athens'),(2961,'Ретимнон','Rethymnon','','Greece',300,'Europe/Athens'),(2962,'Родос','Rhodes','','Greece',300,'Europe/Athens'),(2970,'Салоники','Thessaloniki','','Greece',300,'Europe/Athens'),(90193,'Салоники','Salonica','','Greece',300,'Europe/Athens'),(52237,'Самос','Samos','','Greece',300,'Europe/Athens'),(2971,'Санторини','Thira','','Greece',300,'Europe/Athens'),(2964,'Серре','Serrai','','Greece',300,'Europe/Athens'),(52291,'Спарта','Sparta','','Greece',300,'Europe/Athens'),(90210,'Спарта','Sparti','','Greece',300,'Europe/Athens'),(2972,'Трикала','Trikala','','Greece',300,'Europe/Athens'),(90376,'Триполи','Tripolis','','Greece',300,'Europe/Athens'),(101,'Халкида','Khalkis','','Greece',300,'Europe/Athens'),(51519,'Хиос','Chios','','Greece',300,'Europe/Athens'),(51653,'Янина','Ioannina','','Greece',300,'Europe/Athens'),(53069,'Батуми','Batumi','','Georgia',268,'Asia/Tbilisi'),(53075,'Вале','Vale Georgia','','Georgia',268,'Asia/Tbilisi'),(53077,'Вани','Vani','','Georgia',268,'Asia/Tbilisi'),(53081,'Гори','Gori','','Georgia',268,'Asia/Tbilisi'),(53103,'Кутаиси','Kutaisi','','Georgia',268,'Asia/Tbilisi'),(53119,'Они','Oni Georgia','','Georgia',268,'Asia/Tbilisi'),(53123,'Рустави','Rustavi','','Georgia',268,'Asia/Tbilisi'),(53137,'Тбилиси','Tbilisi','','Georgia',268,'Asia/Tbilisi'),(52433,'Биллунн','Billund','','Denmark',208,'Europe/Copenhagen'),(52953,'Вайле','Vejle','','Denmark',208,'Europe/Copenhagen'),(52651,'Калуннборг','Kalundborg','','Denmark',208,'Europe/Copenhagen'),(52469,'Копенгаген','Copenhagen','','Denmark',208,'Europe/Copenhagen'),(52743,'Нюкёбинг Фальстер','Nykobing','','Denmark',208,'Europe/Copenhagen'),(5008,'Оденсе','Odense','','Denmark',208,'Europe/Copenhagen'),(87001,'Ольборг','Aalborg','','Denmark',208,'Europe/Copenhagen'),(52427,'Орхус','Arhus','','Denmark',208,'Europe/Copenhagen'),(52771,'Раннерс','Randers','','Denmark',208,'Europe/Copenhagen'),(52777,'Рённе','Ronne','','Denmark',208,'Europe/Copenhagen'),(52787,'Роскилле','Roskilde','','Denmark',208,'Europe/Copenhagen'),(52865,'Скаген','Skagen','','Denmark',208,'Europe/Copenhagen'),(87060,'Торсхавн','Thorshavn','','Denmark',208,'Europe/Copenhagen'),(52515,'Фредериксхавн','Frederikshavn','','Denmark',208,'Europe/Copenhagen'),(52517,'Фредерисия','Fredericia','','Denmark',208,'Europe/Copenhagen'),(52563,'Хадерслев','Haderslev','','Denmark',208,'Europe/Copenhagen'),(52593,'Хельсингёр','Helsingor','','Denmark',208,'Europe/Copenhagen'),(52625,'Хорсенс','Horsens','','Denmark',208,'Europe/Copenhagen'),(52487,'Эсбьерг','Esbjerg','','Denmark',208,'Europe/Copenhagen'),(55465,'Санто-Доминго','Santo Domingo','','Dominican Republic',214,'America/Santo_Domingo'),(2882,'Александрия','Alexandria','','Egypt',818,'Africa/Cairo'),(2883,'Асуан','Aswan','','Egypt',818,'Africa/Cairo'),(2884,'Асьют','Asyut','','Egypt',818,'Africa/Cairo'),(2887,'Балтим','Baltim','','Egypt',818,'Africa/Cairo'),(2902,'Исмаилия','Ismailia','','Egypt',818,'Africa/Cairo'),(151,'Каир','Cairo','','Egypt',818,'Africa/Cairo'),(2889,'Каир','Cairo Airport','','Egypt',818,'Africa/Cairo'),(106585,'Кена','Qena','','Egypt',818,'Africa/Cairo'),(89,'Луксор','Luxor','','Egypt',818,'Africa/Cairo'),(2911,'Порт-Саид','Port Said','','Egypt',818,'Africa/Cairo'),(13441,'Сафага','Safaga','','Egypt',818,'Africa/Cairo'),(2920,'Сива','Siwa','','Egypt',818,'Africa/Cairo'),(2921,'Сохаг','Suhaj','','Egypt',818,'Africa/Cairo'),(13442,'Суэц','Suez','','Egypt',818,'Africa/Cairo'),(106591,'Фивы','Thebes','','Egypt',818,'Africa/Cairo'),(87,'Хургада','Hurghada','','Egypt',818,'Africa/Cairo'),(88,'Шарм-эль-Шейх','Sharm El Sheikh','','Egypt',818,'Africa/Cairo'),(106588,'Шибин-эль-Ком','Shibin el-Kom','','Egypt',818,'Africa/Cairo'),(106571,'Эль-Ариш','El Arish','','Egypt',818,'Africa/Cairo'),(9117,'Кабве','Kabwe','','Zambia',894,'Africa/Lusaka'),(9121,'Касама','Kasama','','Zambia',894,'Africa/Lusaka'),(9124,'Ливингстон','Livingstone','','Zambia',894,'Africa/Lusaka'),(9126,'Лусака','Lusaka','','Zambia',894,'Africa/Lusaka'),(9128,'Манса','Mansa','','Zambia',894,'Africa/Lusaka'),(9133,'Монгу','Mongu','','Zambia',894,'Africa/Lusaka'),(9139,'Ндола','Ndola','','Zambia',894,'Africa/Lusaka'),(9144,'Солвези','Solwezi','','Zambia',894,'Africa/Lusaka'),(9113,'Чипата','Chipata','','Zambia',894,'Africa/Lusaka'),(9185,'Дахла','Villa Cisneros','','Western Sahara',732,'Africa/El_Aaiun'),(9184,'Эль-Аюн','El Aayoune','','Western Sahara',732,''),(9146,'Булавайо','Bulawayo','','Zimbabwe',716,'Africa/Harare'),(9178,'Виктория','Victoria Falls','','Zimbabwe',716,'Africa/Harare'),(9159,'Гверу','Gweru','','Zimbabwe',716,'Africa/Harare'),(9182,'Зака','Zaka','','Zimbabwe',716,'Africa/Harare'),(9183,'Звишаване','Zvishavane','','Zimbabwe',716,'Africa/Harare'),(9162,'Кадома','Kadoma','','Zimbabwe',716,'Africa/Harare'),(9164,'Кариба','Kariba','','Zimbabwe',716,'Africa/Harare'),(9167,'Квекве','Kwekwe','','Zimbabwe',716,'Africa/Harare'),(9168,'Масвинго','Masvingo','','Zimbabwe',716,'Africa/Harare'),(9177,'Тули','Tuli','','Zimbabwe',716,'Africa/Harare'),(9147,'Хараре','Harare','','Zimbabwe',716,'Africa/Harare'),(9161,'Хванге','Hwange','','Zimbabwe',716,'Africa/Harare'),(9152,'Чинхойи','Chinhoyi','','Zimbabwe',716,'Africa/Harare'),(53345,'Арад','Arad','','Israel',376,'Asia/Jerusalem'),(53353,'Ашкелон','Ashqelon','','Israel',376,'Asia/Jerusalem'),(13499,'Иерусалим','Jerusalem','','Israel',376,'Asia/Gaza'),(53401,'Лод','Lod','','Israel',376,'Asia/Jerusalem'),(53463,'Тверия','Tiberias','','Israel',376,'Asia/Jerusalem'),(53461,'Тель-Авив','Tel Aviv','','Israel',376,'Asia/Jerusalem'),(53387,'Хадера','Hadera','','Israel',376,'Asia/Jerusalem'),(53389,'Хайфа','Haifa','','Israel',376,'Asia/Jerusalem'),(53369,'Эйлат','Elat','','Israel',376,'Asia/Jerusalem'),(32545,'Akola','Akola','','India',356,'Asia/Kolkata'),(32585,'Alleppey','Alleppey','','India',356,'Asia/Kolkata'),(32617,'Ambala','Ambala','','India',356,'Asia/Kolkata'),(32643,'Amravati','Amravati','','India',356,'Asia/Kolkata'),(32655,'Anakapalle','Anakapalle','','India',356,'Asia/Kolkata'),(32657,'Anand','Anand','','India',356,'Asia/Kolkata'),(32663,'Anantapur','Anantapur','','India',356,'Asia/Kolkata'),(32705,'Ara','Ara','','India',356,'Asia/Kolkata'),(32739,'Aruppukkottai','Aruppukkottai','','India',356,'Asia/Kolkata'),(32771,'Auraiya','Auraiya','','India',356,'Asia/Kolkata'),(32523,'Azamgarh','Azamgarh','','India',356,'Asia/Kolkata'),(33279,'Baharampur','Baharampur','','India',356,'Asia/Kolkata'),(33099,'Balasore','Balasore','','India',356,'Asia/Kolkata'),(33143,'Banda','Banda','','India',356,'Asia/Kolkata'),(33157,'Bankura','Bankura','','India',356,'Asia/Kolkata'),(33211,'Barddhaman','Barddhaman','','India',356,'Asia/Kolkata'),(33269,'Batala','Batala','','India',356,'Asia/Kolkata'),(33535,'Bhandara','Bhandara','','India',356,'Asia/Kolkata'),(33551,'Bharuch','Bharuch','','India',356,'Asia/Kolkata'),(33557,'Bhatinda','Bhatinda','','India',356,'Asia/Kolkata'),(33559,'Bhatkal','Bhatkal','','India',356,'Asia/Kolkata'),(33561,'Bhatpara','Bhatpara','','India',356,'Asia/Kolkata'),(33503,'Bhavani','Bhavani','','India',356,'Asia/Kolkata'),(33507,'Bhavnagar','Bhavnagar','','India',356,'Asia/Kolkata'),(33583,'Bhind','Bhind','','India',356,'Asia/Kolkata'),(33569,'Bhiwandi','Bhiwandi','','India',356,'Asia/Kolkata'),(33571,'Bhiwani','Bhiwani','','India',356,'Asia/Kolkata'),(33603,'Bhongir','Bhongir','','India',356,'Asia/Kolkata'),(33365,'Bidar','Bidar','','India',356,'Asia/Kolkata'),(33433,'Bihar Sharif','Bihar Sharif','','India',356,'Asia/Kolkata'),(33379,'Bikaner','Bikaner','','India',356,'Asia/Kolkata'),(33393,'Bilaspur','Bilaspur','','India',356,'Asia/Kolkata'),(33459,'Bokaro','Bokaro','','India',356,'Asia/Kolkata'),(33485,'Bulandshahr','Bulandshahr','','India',356,'Asia/Kolkata'),(33483,'Buxar','Buxar','','India',356,'Asia/Kolkata'),(32891,'Chamba','Chamba','','India',356,'Asia/Kolkata'),(32901,'Chandannagar','Chandannagar','','India',356,'Asia/Kolkata'),(32833,'Chavakkad','Chavakkad','','India',356,'Asia/Kolkata'),(33015,'Chhindwara','Chhindwara','','India',356,'Asia/Kolkata'),(32865,'Chitradurga','Chitradurga','','India',356,'Asia/Kolkata'),(32817,'Cuddalore','Cuddalore','','India',356,'Asia/Kolkata'),(32831,'Cuttack','Cuttack','','India',356,'Asia/Kolkata'),(33725,'Daman','Daman','','India',356,'Asia/Kolkata'),(33741,'Darbhanga','Darbhanga','','India',356,'Asia/Kolkata'),(33759,'Daund','Daund','','India',356,'Asia/Kolkata'),(33781,'Dewas','Dewas','','India',356,'Asia/Kolkata'),(33915,'Dhanbad','Dhanbad','','India',356,'Asia/Kolkata'),(33981,'Dhule','Dhule','','India',356,'Asia/Kolkata'),(33847,'Dindigul','Dindigul','','India',356,'Asia/Kolkata'),(33861,'Dod Ballapur','Dod Ballapur','','India',356,'Asia/Kolkata'),(33901,'Durgapur','Durgapur','','India',356,'Asia/Kolkata'),(33769,'Dwarka','Dwarka','','India',356,'Asia/Kolkata'),(33633,'Elamanchili','Elamanchili','','India',356,'Asia/Kolkata'),(33649,'Erode','Erode','','India',356,'Asia/Kolkata'),(33653,'Etawah','Etawah','','India',356,'Asia/Kolkata'),(33659,'Faizabad','Faizabad','','India',356,'Asia/Kolkata'),(33665,'Faridkot','Faridkot','','India',356,'Asia/Kolkata'),(33687,'Fatehpur','Fatehpur','','India',356,'Asia/Kolkata'),(33691,'Firozabad','Firozabad','','India',356,'Asia/Kolkata'),(33985,'Gadag','Gadag','','India',356,'Asia/Kolkata'),(34063,'Gaya','Gaya','','India',356,'Asia/Kolkata'),(34047,'Ghaziabad','Ghaziabad','','India',356,'Asia/Kolkata'),(33997,'Ghazipur','Ghazipur','','India',356,'Asia/Kolkata'),(34083,'Godhra','Godhra','','India',356,'Asia/Kolkata'),(34099,'Gondia','Gondia','','India',356,'Asia/Kolkata'),(34133,'Gudivada','Gudivada','','India',356,'Asia/Kolkata'),(34143,'Gulbarga','Gulbarga','','India',356,'Asia/Kolkata'),(34159,'Guntur','Guntur','','India',356,'Asia/Kolkata'),(34163,'Gurgaon','Gurgaon','','India',356,'Asia/Kolkata'),(34125,'Guwahati','Guwahati','','India',356,'Asia/Kolkata'),(34223,'Hamirpur','Hamirpur','','India',356,'Asia/Kolkata'),(34235,'Haora','Haora','','India',356,'Asia/Kolkata'),(34241,'Hardoi','Hardoi','','India',356,'Asia/Kolkata'),(34245,'Haridwar','Haridwar','','India',356,'Asia/Kolkata'),(34271,'Hathras','Hathras','','India',356,'Asia/Kolkata'),(34299,'Hisar','Hisar','','India',356,'Asia/Kolkata'),(34313,'Honavar','Honavar','','India',356,'Asia/Kolkata'),(34331,'Hoshiarpur','Hoshiarpur','','India',356,'Asia/Kolkata'),(34335,'Hubli','Hubli','','India',356,'Asia/Kolkata'),(34429,'Kakinada','Kakinada','','India',356,'Asia/Kolkata'),(34463,'Kalka','Kalka','','India',356,'Asia/Kolkata'),(34479,'Kalyan','Kalyan','','India',356,'Asia/Kolkata'),(34497,'Kamthi','Kamthi','','India',356,'Asia/Kolkata'),(34577,'Karimnagar','Karimnagar','','India',356,'Asia/Kolkata'),(34585,'Karnal','Karnal','','India',356,'Asia/Kolkata'),(34599,'Kasaragod','Kasaragod','','India',356,'Asia/Kolkata'),(34905,'Khadki','Khadki','','India',356,'Asia/Kolkata'),(34921,'Khambhat','Khambhat','','India',356,'Asia/Kolkata'),(34925,'Khammam','Khammam','','India',356,'Asia/Kolkata'),(34881,'Kharagpur','Kharagpur','','India',356,'Asia/Kolkata'),(34703,'Kodaikanal','Kodaikanal','','India',356,'Asia/Kolkata'),(34711,'Kolar','Kolar','','India',356,'Asia/Kolkata'),(34725,'Kolhapur','Kolhapur','','India',356,'Asia/Kolkata'),(34757,'Koregaon','Koregaon','','India',356,'Asia/Kolkata'),(34783,'Kottayam','Kottayam','','India',356,'Asia/Kolkata'),(34687,'Kovur','Kovur','','India',356,'Asia/Kolkata'),(35167,'Machilipatnam','Machilipatnam','','India',356,'Asia/Kolkata'),(35339,'Mahbubnagar','Mahbubnagar','','India',356,'Asia/Kolkata'),(35183,'Malegaon','Malegaon','','India',356,'Asia/Kolkata'),(35251,'Mandi','Mandi','','India',356,'Asia/Kolkata'),(35259,'Mandya','Mandya','','India',356,'Asia/Kolkata'),(35221,'Mangalagiri','Mangalagiri','','India',356,'Asia/Kolkata'),(35413,'Meerut','Meerut','','India',356,'Asia/Kolkata'),(35411,'Mirzapur','Mirzapur','','India',356,'Asia/Kolkata'),(35419,'Moga','Moga','','India',356,'Asia/Kolkata'),(35451,'Motihari','Motihari','','India',356,'Asia/Kolkata'),(35531,'Murshidabad','Murshidabad','','India',356,'Asia/Kolkata'),(35389,'Murud','Murud','','India',356,'Asia/Kolkata'),(35535,'Mussoorie','Mussoorie','','India',356,'Asia/Kolkata'),(35479,'Muzaffarnagar','Muzaffarnagar','','India',356,'Asia/Kolkata'),(35481,'Muzaffarpur','Muzaffarpur','','India',356,'Asia/Kolkata'),(35605,'Nadiad','Nadiad','','India',356,'Asia/Kolkata'),(35597,'Nagercoil','Nagercoil','','India',356,'Asia/Kolkata'),(35621,'Nalgonda','Nalgonda','','India',356,'Asia/Kolkata'),(35637,'Nangal','Nangal','','India',356,'Asia/Kolkata'),(35563,'Nawabganj','Nawabganj','','India',356,'Asia/Kolkata'),(35735,'Nellore','Nellore','','India',356,'Asia/Kolkata'),(35725,'Neyyattinkara','Neyyattinkara','','India',356,'Asia/Kolkata'),(35747,'Nizamabad','Nizamabad','','India',356,'Asia/Kolkata'),(35827,'Osmanabad','Osmanabad','','India',356,'Asia/Kolkata'),(35863,'Palwal','Palwal','','India',356,'Asia/Kolkata'),(35901,'Panipat','Panipat','','India',356,'Asia/Kolkata'),(35887,'Panvel','Panvel','','India',356,'Asia/Kolkata'),(35963,'Patan','Patan','','India',356,'Asia/Kolkata'),(35967,'Pathankot','Pathankot','','India',356,'Asia/Kolkata'),(36115,'Porbandar','Porbandar','','India',356,'Asia/Kolkata'),(36217,'Quilon','Quilon','','India',356,'Asia/Kolkata'),(36397,'Rae Bareli','Rae Bareli','','India',356,'Asia/Kolkata'),(36297,'Raichur','Raichur','','India',356,'Asia/Kolkata'),(36287,'Raigarh','Raigarh','','India',356,'Asia/Kolkata'),(36247,'Rajapalaiyam','Rajapalaiyam','','India',356,'Asia/Kolkata'),(36355,'Ranchi','Ranchi','','India',356,'Asia/Kolkata'),(36369,'Ratlam','Ratlam','','India',356,'Asia/Kolkata'),(36371,'Ratnagiri','Ratnagiri','','India',356,'Asia/Kolkata'),(36421,'Rishikesh','Rishikesh','','India',356,'Asia/Kolkata'),(36431,'Rohtak','Rohtak','','India',356,'Asia/Kolkata'),(36439,'Roorkee','Roorkee','','India',356,'Asia/Kolkata'),(36623,'Saharanpur','Saharanpur','','India',356,'Asia/Kolkata'),(36499,'Samastipur','Samastipur','','India',356,'Asia/Kolkata'),(36503,'Sambalpur','Sambalpur','','India',356,'Asia/Kolkata'),(36525,'Sanwer','Sanwer','','India',356,'Asia/Kolkata'),(36569,'Saraipali','Saraipali','','India',356,'Asia/Kolkata'),(36597,'Satara','Satara','','India',356,'Asia/Kolkata'),(36601,'Satna','Satna','','India',356,'Asia/Kolkata'),(36651,'Sehore','Sehore','','India',356,'Asia/Kolkata'),(36897,'Shahjahanpur','Shahjahanpur','','India',356,'Asia/Kolkata'),(36923,'Shertallai','Shertallai','','India',356,'Asia/Kolkata'),(36695,'Silchar','Silchar','','India',356,'Asia/Kolkata'),(36757,'Sitapur','Sitapur','','India',356,'Asia/Kolkata'),(36659,'Sivakasi','Sivakasi','','India',356,'Asia/Kolkata'),(36661,'Siwan','Siwan','','India',356,'Asia/Kolkata'),(36777,'Solapur','Solapur','','India',356,'Asia/Kolkata'),(36799,'Sonipat','Sonipat','','India',356,'Asia/Kolkata'),(36825,'Srikakulam','Srikakulam','','India',356,'Asia/Kolkata'),(36843,'Sultanpur','Sultanpur','','India',356,'Asia/Kolkata'),(37049,'Tezpur','Tezpur','','India',356,'Asia/Kolkata'),(37013,'Thane','Thane','','India',356,'Asia/Kolkata'),(37097,'Tinsukia','Tinsukia','','India',356,'Asia/Kolkata'),(37155,'Tonk','Tonk','','India',356,'Asia/Kolkata'),(37177,'Tumkur','Tumkur','','India',356,'Asia/Kolkata'),(37253,'Valsad','Valsad','','India',356,'Asia/Kolkata'),(37281,'Vellore','Vellore','','India',356,'Asia/Kolkata'),(37291,'Veraval','Veraval','','India',356,'Asia/Kolkata'),(37303,'Vidisha','Vidisha','','India',356,'Asia/Kolkata'),(37331,'Virudunagar','Virudunagar','','India',356,'Asia/Kolkata'),(37307,'Vizianagaram','Vizianagaram','','India',356,'Asia/Kolkata'),(37367,'Warangal','Warangal','','India',356,'Asia/Kolkata'),(37371,'Wardha','Wardha','','India',356,'Asia/Kolkata'),(37199,'Zahirabad','Zahirabad','','India',356,'Asia/Kolkata'),(32497,'Агартала','Agartala','','India',356,'Asia/Kolkata'),(32499,'Агра','Agra','','India',356,'Asia/Kolkata'),(5948,'Аджмер','Ajmer','','India',356,'Asia/Kolkata'),(32575,'Алигарх','Aligarh','','India',356,'Asia/Kolkata'),(32581,'Аллахабад','Allahabad','','India',356,'Asia/Kolkata'),(5961,'Амритсар','Amritsar','','India',356,'Asia/Kolkata'),(32743,'Асансол','Asansol','','India',356,'Asia/Kolkata'),(32773,'Аурангабад','Aurangabad','','India',356,'Asia/Kolkata'),(5980,'Бангалор','Bengalooru','','India',356,'Asia/Kolkata'),(5986,'Барели','Bareilly','','India',356,'Asia/Kolkata'),(6006,'Биджапур','Bijapur','','India',356,'Asia/Kolkata'),(33605,'Бхопал','Bhopal','','India',356,'Asia/Kolkata'),(6003,'Бхубанешвар','Bhubaneshwar','','India',356,'Asia/Kolkata'),(33609,'Бхубанешвар','Bhuban','','India',356,'Asia/Kolkata'),(37239,'Вадодара','Vadodara','','India',356,'Asia/Kolkata'),(33337,'Варанаси','Benares','','India',356,'Asia/Kolkata'),(6352,'Виджаявада','Vijayawada','','India',356,'Asia/Kolkata'),(6354,'Вишакхапатнам','Vishakhapatnam','','India',356,'Asia/Kolkata'),(34015,'Гангток','Gangtok','','India',356,'Asia/Kolkata'),(6102,'Гвалияр','Gwalior','','India',356,'Asia/Kolkata'),(13427,'Гоа','Goa','','India',356,'Asia/Kolkata'),(6098,'Горахпур','Gorakhpur','','India',356,'Asia/Kolkata'),(13426,'Дели','Delhi','','India',356,'Asia/Kolkata'),(6118,'Джабалпур','Jabalpur','','India',356,'Asia/Kolkata'),(6120,'Джайпур','Jaipur','','India',356,'Asia/Kolkata'),(6122,'Джалгаон','Jalgaon','','India',356,'Asia/Kolkata'),(6125,'Джамму','Jammu','','India',356,'Asia/Kolkata'),(6126,'Джамнагар','Jamnagar','','India',356,'Asia/Kolkata'),(6127,'Джамшедпур','Jamshedpur','','India',356,'Asia/Kolkata'),(6132,'Джанси','Jhansi','','India',356,'Asia/Kolkata'),(6134,'Джодхпур','Jodhpur','','India',356,'Asia/Kolkata'),(33843,'Димапур','Dimapur','','India',356,'Asia/Kolkata'),(33855,'Диспур','Dispur','','India',356,'Asia/Kolkata'),(33857,'Диу','Diu','','India',356,'Asia/Kolkata'),(6116,'Имфал','Imphal','','India',356,'Asia/Kolkata'),(34369,'Индаур','Indore','','India',356,'Asia/Kolkata'),(34385,'Итанагар','Itanagar','','India',356,'Asia/Kolkata'),(34477,'Калькутта','Kolkata','','India',356,'Asia/Kolkata'),(34537,'Канпур','Kanpur','','India',356,'Asia/Kolkata'),(6171,'Кожикоде','Kozhikode','','India',356,'Asia/Kolkata'),(34789,'Кохима','Kohima','','India',356,'Asia/Kolkata'),(6177,'Лакхнау','Lucknow','','India',356,'Asia/Kolkata'),(35093,'Лудхияна','Ludhiana','','India',356,'Asia/Kolkata'),(6184,'Мадурай','Madurai','','India',356,'Asia/Kolkata'),(35157,'Майсур','Mysore','','India',356,'Asia/Kolkata'),(6198,'Мангалор','Mangalore','','India',356,'Asia/Kolkata'),(33629,'Мумбаи','Bombay','','India',356,'Asia/Kolkata'),(6206,'Мурадабад','Moradabad','','India',356,'Asia/Kolkata'),(35591,'Нагпур','Nagpur','','India',356,'Asia/Kolkata'),(6230,'Нашик','Nasik','','India',356,'Asia/Kolkata'),(6233,'Нью-Дели','New Delhi','','India',356,'Asia/Kolkata'),(6253,'Патиала','Patiala','','India',356,'Asia/Kolkata'),(35979,'Патна','Patna','','India',356,'Asia/Kolkata'),(36147,'Пуна','Pune','','India',356,'Asia/Kolkata'),(36167,'Пури','Puri','','India',356,'Asia/Kolkata'),(6277,'Раджкот','Rajkot','','India',356,'Asia/Kolkata'),(36293,'Райпур','Raipur','','India',356,'Asia/Kolkata'),(36863,'Сурат','Surat','','India',356,'Asia/Kolkata'),(6324,'Танджавур','Thanjavur','','India',356,'Asia/Kolkata'),(6325,'Тируванантапурам','Thiruvananthapuram','','India',356,'Asia/Kolkata'),(6328,'Тирупати','Tirupathi','','India',356,'Asia/Kolkata'),(6340,'Удайпур','Udaipur','','India',356,'Asia/Kolkata'),(6342,'Удджайн','Ujjain','','India',356,'Asia/Kolkata'),(33669,'Фаридабад','Faridabad','','India',356,'Asia/Kolkata'),(34207,'Хайдарабад','Hyderabad','','India',356,'Asia/Kolkata'),(6110,'Хисар','Hissar','','India',356,'Asia/Kolkata'),(32911,'Чандигарх','Chandigarh','','India',356,'Asia/Kolkata'),(6028,'Чандрапур','Chandrapur','','India',356,'Asia/Kolkata'),(32953,'Ченнаи','Chennai','','India',356,'Asia/Kolkata'),(36935,'Шиллонг','Shillong','','India',356,'Asia/Kolkata'),(36937,'Шимла','Shimla','','India',356,'Asia/Kolkata'),(13498,'Денпасар','Denpasar','','Indonesia',360,'Asia/Makassar'),(6839,'','Ma','','Jordan',400,'Asia/Amman'),(108900,'Акаба','Al Aqabah','','Jordan',400,'Asia/Amman'),(108901,'Амман','Amman','','Jordan',400,'Asia/Amman'),(6359,'Амара','Amarah','','Iraq',368,'Asia/Baghdad'),(6370,'Кербела','Karbalaa','','Iraq',368,'Asia/Baghdad'),(6373,'Мосул','Mosul','','Iraq',368,'Asia/Baghdad'),(6383,'Сулеймания','Sulaimaniya','','Iraq',368,'Asia/Baghdad'),(6404,'Абадан','Abadan','','Iran',364,'Asia/Tehran'),(6418,'Бирдженд','Birjand','','Iran',364,'Asia/Tehran'),(6447,'Мешхед','Mashhad','','Iran',364,'Asia/Tehran'),(6457,'Себзевар','Sabzevar','','Iran',364,'Asia/Tehran'),(6471,'Тебриз','Tabriz','','Iran',364,'Asia/Tehran'),(6472,'Тегеран','Tehran','','Iran',364,'Asia/Tehran'),(53487,'Атлон','Athlone','','Ireland',372,'Europe/Dublin'),(53529,'Балтимор','Baltimore','','Ireland',372,'Europe/Dublin'),(92628,'Голуэй','Galway','','Ireland',372,'Europe/Dublin'),(53683,'Дублин','Dublin','','Ireland',372,'Europe/Dublin'),(92899,'Килкенни','Kilkenny','','Ireland',372,'Europe/Dublin'),(92901,'Килларни','Killarney','','Ireland',372,'Europe/Dublin'),(53641,'Корк','Cork','','Ireland',372,'Europe/Dublin'),(93070,'Лимерик','Limerick','','Ireland',372,'Europe/Dublin'),(93936,'Трали','Tralee','','Ireland',372,'Europe/Dublin'),(93940,'Туам','Tuam','','Ireland',372,'Europe/Dublin'),(94142,'Уотерфорд','Waterford','','Ireland',372,'Europe/Dublin'),(5872,'Акюрейри','Akureyri','','Iceland',352,'Atlantic/Reykjavik'),(92256,'Вестманнаэйяр','Vestmannaeyjar','','Iceland',352,'Atlantic/Reykjavik'),(5919,'Рейкьявик','Reykjavik','','Iceland',352,'Atlantic/Reykjavik'),(2997,'','Benasque,','','Spain',724,'Europe/Madrid'),(3003,'','Candanchu,','','Spain',724,'Europe/Madrid'),(3006,'','Cerler,','','Spain',724,'Europe/Madrid'),(3013,'','Fanlo,','','Spain',724,'Europe/Madrid'),(3024,'','Isaba,','','Spain',724,'Europe/Madrid'),(3051,'','Panticosa,','','Spain',724,'Europe/Madrid'),(3059,'','Sallent De Gallego,','','Spain',724,'Europe/Madrid'),(3074,'','Valdelinares,','','Spain',724,'Europe/Madrid'),(2993,'Авила','Avila','','Spain',724,'Europe/Madrid'),(53727,'Авилес','Aviles','','Spain',724,'Europe/Madrid'),(53729,'Авиньо','Avinyo','','Spain',724,'Europe/Madrid'),(53791,'Аламеда','Alameda','','Spain',724,'Europe/Madrid'),(2990,'Аликанте','Alicante','','Spain',724,'Europe/Madrid'),(2989,'Альбасете','Albacete','','Spain',724,'Europe/Madrid'),(53879,'Алькала-де-Гвадаира','Alcala de Guadaira','','Spain',724,'Europe/Madrid'),(53883,'Алькала-де-Энарес','Alcala de Henares','','Spain',724,'Europe/Madrid'),(53903,'Алькасар-де-Сан-Хуан','Alcazar de San Juan','','Spain',724,'Europe/Madrid'),(53911,'Алькобендас','Alcobendas','','Spain',724,'Europe/Madrid'),(53915,'Алькой','Alcoi','','Spain',724,'Europe/Madrid'),(53927,'Алькоркон','Alcorcon','','Spain',724,'Europe/Madrid'),(53937,'Альманса','Almansa','','Spain',724,'Europe/Madrid'),(2991,'Альмерия','Almeria','','Spain',724,'Europe/Madrid'),(99588,'Альсира','Alcira','','Spain',724,'Europe/Madrid'),(54015,'Альхесирас','Algeciras','','Spain',724,'Europe/Madrid'),(54023,'Амес','Ames','','Spain',724,'Europe/Madrid'),(54039,'Андорра','Andorra','','Spain',724,'Europe/Andorra'),(54045,'Андухар','Andujar','','Spain',724,'Europe/Madrid'),(54047,'Анна','Anna','','Spain',724,'Europe/Madrid'),(54053,'Антекера','Antequera','','Spain',724,'Europe/Madrid'),(54065,'Аранхуэс','Aranjuez','','Spain',724,'Europe/Madrid'),(54071,'Арбо','Arbo','','Spain',724,'Europe/Madrid'),(55255,'Аро','Haro','','Spain',724,'Europe/Madrid'),(54115,'Арресифе','Arrecife','','Spain',724,'Atlantic/Canary'),(54131,'Арта','Arta','','Spain',724,'Europe/Madrid'),(54161,'Аско','Asco','','Spain',724,'Europe/Madrid'),(54169,'Аспе','Aspe','','Spain',724,'Europe/Madrid'),(54199,'Бадалона','Badalona','','Spain',724,'Europe/Madrid'),(2994,'Бадахос','Badajoz','','Spain',724,'Europe/Madrid'),(2995,'Бакейра','Baqueira','','Spain',724,'Europe/Madrid'),(99661,'Баракальдо','Baracaldo','','Spain',724,'Europe/Madrid'),(152,'Барселона','Barcelona','','Spain',724,'Europe/Madrid'),(54251,'Баса','Baza','','Spain',724,'Europe/Madrid'),(54329,'Бенидорм','Benidorm','','Spain',724,'Europe/Madrid'),(54355,'Берга','Berga','','Spain',724,'Europe/Madrid'),(2998,'Бильбао','Bilbao','','Spain',724,'Europe/Madrid'),(54405,'Бланес','Blanes','','Spain',724,'Europe/Madrid'),(3000,'Бургос','Burgos','','Spain',724,'Europe/Madrid'),(3075,'Валенсия','Valencia','','Spain',724,'Europe/Madrid'),(3076,'Вальядолид','Valladolid','','Spain',724,'Europe/Madrid'),(3077,'Виго','Vigo','','Spain',724,'Europe/Madrid'),(100984,'Вильена','Villena','','Spain',724,'Europe/Madrid'),(3078,'Витория','Vitoria','','Spain',724,'Europe/Madrid'),(55190,'Гава','Gava','','Spain',724,'Europe/Madrid'),(55195,'Гальдар','Galdar','','Spain',724,'Atlantic/Canary'),(55198,'Гандиа','Gandia','','Spain',724,'Europe/Madrid'),(3019,'Гвадалахара','Guadalajara','','Spain',724,'Europe/Madrid'),(55210,'Гвадикс','Guadix','','Spain',724,'Europe/Madrid'),(55221,'Гондомар','Gondomar','','Spain',724,'Europe/Madrid'),(3018,'Гранада','Granada','','Spain',724,'Europe/Madrid'),(55047,'Дева','Deba','','Spain',724,'Europe/Madrid'),(55058,'Дос-Эрманас','Dos Hermanas','','Spain',724,'Europe/Madrid'),(55064,'Дуранго','Durango','','Spain',724,'Europe/Madrid'),(91,'Ивиса','Ibiza','','Spain',724,'Europe/Madrid'),(55302,'Ирун','Irun','','Spain',724,'Europe/Madrid'),(54523,'Кадис','Cadiz','','Spain',724,'Europe/Madrid'),(3002,'Каламоча','Calamocha','','Spain',724,'Europe/Madrid'),(54541,'Калатаюд','Calatayud','','Spain',724,'Europe/Madrid'),(54571,'Камас','Camas','','Spain',724,'Europe/Madrid'),(54575,'Камбре','Cambre','','Spain',724,'Europe/Madrid'),(54707,'Картахена','Cartagena','','Spain',724,'Europe/Madrid'),(3001,'Касерес','Caceres','','Spain',724,'Europe/Madrid'),(54735,'Каспе','Caspe','','Spain',724,'Europe/Madrid'),(54745,'Кастельдефельс','Castelldefels','','Spain',724,'Europe/Madrid'),(3004,'Кастельон','Castellon','','Spain',724,'Europe/Madrid'),(99747,'Кастельон-де-ла-Плана','Castellon de la Plana','','Spain',724,'Europe/Madrid'),(3009,'Кордова','Cordoba','','Spain',724,'Europe/Madrid'),(54819,'Кош','Cox','','Spain',724,'Europe/Madrid'),(3010,'Куэнка','Cuenca','','Spain',724,'Europe/Madrid'),(3028,'Ла-Корунья','La Coruna','','Spain',724,'Europe/Madrid'),(3029,'Ла-Молина','La Molina','','Spain',724,'Europe/Madrid'),(55382,'Лалин','Lalin','','Spain',724,'Europe/Madrid'),(3031,'Лансароте','Lanzarote','','Spain',724,'Atlantic/Canary'),(55387,'Ларедо','Laredo','','Spain',724,'Europe/Madrid'),(55395,'Лас-Пальмас-де-Гран-Канария','Las Palmas','','Spain',724,'Atlantic/Canary'),(55400,'Леганес','Leganes','','Spain',724,'Europe/Madrid'),(3032,'Леон','Leon','','Spain',724,'Europe/Madrid'),(55404,'Лепе','Lepe','','Spain',724,'Europe/Madrid'),(3033,'Лерида','Lleida','','Spain',724,'Europe/Madrid'),(3034,'Логроньо','Logrono','','Spain',724,'Europe/Madrid'),(55421,'Лорка','Lorca','','Spain',724,'Europe/Madrid'),(55437,'Лоха','Loja','','Spain',724,'Europe/Madrid'),(3035,'Луго','Lugo','','Spain',724,'Europe/Madrid'),(55443,'Лусена','Lucena','','Spain',724,'Europe/Madrid'),(55413,'Льорет-де-Мар','Lloret de Mar','','Spain',724,'Europe/Madrid'),(3036,'Мадрид','Madrid','','Spain',724,'Europe/Madrid'),(3037,'Малага','Malaga / Aeropuerto','','Spain',724,'Europe/Madrid'),(100344,'Малага','Malaga','','Spain',724,'Europe/Madrid'),(100345,'Манакор','Manacor','','Spain',724,'Europe/Madrid'),(100346,'Манреса','Manresa','','Spain',724,'Europe/Madrid'),(100343,'Маон','Mahon','','Spain',724,'Europe/Madrid'),(100348,'Марбелья','Marbella','','Spain',724,'Europe/Madrid'),(3038,'Марин','Marin','','Spain',724,'Europe/Madrid'),(3039,'Маселла','Masella','','Spain',724,'Europe/Madrid'),(100349,'Матаро','Mataro','','Spain',724,'Europe/Madrid'),(3040,'Мелилья','Melilla','','Spain',724,'Africa/Ceuta'),(3041,'Менорка','Menorca','','Spain',724,'Europe/Madrid'),(100350,'Мерида','Merida','','Spain',724,'Europe/Madrid'),(3042,'Молина Де Арагон','Molina De Aragon','','Spain',724,'Europe/Madrid'),(100356,'Мостолес','Mostoles','','Spain',724,'Europe/Madrid'),(100358,'Мотриль','Motril','','Spain',724,'Europe/Madrid'),(3045,'Мурсия','Murcia','','Spain',724,'Europe/Madrid'),(3046,'Навасеррада','Navacerrada','','Spain',724,'Europe/Madrid'),(3049,'Овьедо','Oviedo','','Spain',724,'Europe/Madrid'),(100503,'Олот','Olot','','Spain',724,'Europe/Madrid'),(3048,'Оренсе','Orense','','Spain',724,'Europe/Madrid'),(100601,'Паленсия','Palencia','','Spain',724,'Europe/Madrid'),(90,'Пальма','Palma de Mallorca','','Spain',724,'Europe/Madrid'),(3030,'Пальма','La Palma','','Spain',724,'Atlantic/Canary'),(100602,'Памплона','Pamplona','','Spain',724,'Europe/Madrid'),(100603,'Патерна','Paterna','','Spain',724,'Europe/Madrid'),(3053,'Понтеведра','Pontevedra','','Spain',724,'Europe/Madrid'),(3052,'Понферрада','Ponferrada','','Spain',724,'Europe/Madrid'),(100608,'Посуэло-де-Аларкон','Pozuelo de Alarcon','','Spain',724,'Europe/Madrid'),(100609,'Премиа-де-Мар','Premia de Mar','','Spain',724,'Europe/Madrid'),(100610,'Прьего','Priego','','Spain',724,'Europe/Madrid'),(100612,'Пуэрто-дель-Росарио','Puerto del Rosario','','Spain',724,'Atlantic/Canary'),(100614,'Рейноса','Reinosa','','Spain',724,'Europe/Madrid'),(3056,'Реус','Reus / Aeropuerto','','Spain',724,'Europe/Madrid'),(100617,'Реус','Reus','','Spain',724,'Europe/Madrid'),(100623,'Ронда','Ronda','','Spain',724,'Europe/Madrid'),(3057,'Рота','Rota','','Spain',724,'Europe/Madrid'),(100688,'Сабадель','Sabadell','','Spain',724,'Europe/Madrid'),(100696,'Саламанка','Salamanca','','Spain',724,'Europe/Madrid'),(3079,'Самора','Zamora','','Spain',724,'Europe/Madrid'),(3060,'Сан Себастьян','San Sebastian / Fuenterrabia','','Spain',724,'Europe/Madrid'),(99867,'Сан-Себастьян','Donostia-San Sebastian','','Spain',724,'Europe/Madrid'),(100712,'Санлукар-де-Баррамеда','Sanlucar de Barrameda','','Spain',724,'Europe/Madrid'),(100714,'Санта-Колома-де-Граманет','Santa Coloma de Gramanet','','Spain',724,'Europe/Madrid'),(100716,'Санта-Крус-де-Тенерифе','Santa Cruz de Tenerife','','Spain',724,'Atlantic/Canary'),(100718,'Санта-Пола','Santa Pola','','Spain',724,'Europe/Madrid'),(3062,'Сантандер','Santander','','Spain',724,'Europe/Madrid'),(3080,'Сарагоса','Zaragoza / Aeropuerto','','Spain',724,'Europe/Madrid'),(3065,'Севилья','Sevilla','','Spain',724,'Europe/Madrid'),(100725,'Севилья','Seville','','Spain',724,'Europe/Madrid'),(3064,'Сеговия','Segovia','','Spain',724,'Europe/Madrid'),(100723,'Сестао','Sestao','','Spain',724,'Europe/Madrid'),(3007,'Сеута','Ceuta','','Spain',724,'Africa/Ceuta'),(3066,'Сория','Soria','','Spain',724,'Europe/Madrid'),(3067,'Сорт','Sort','','Spain',724,'Europe/Madrid'),(100727,'Сьерра-Невада','Sierra Nevada','','Spain',724,'Europe/Madrid'),(54997,'Сьеса','Cieza','','Spain',724,'Europe/Madrid'),(3008,'Сьюдад-Реаль','Ciudad Real','','Spain',724,'Europe/Madrid'),(3068,'Талар','Talar','','Spain',724,'America/Argentina/Jujuy'),(3069,'Тарифа','Tarifa','','Spain',724,'Europe/Madrid'),(100750,'Таррагона','Tarragona','','Spain',724,'Europe/Madrid'),(92,'Тенерифе','Tenerife','','Spain',724,'Atlantic/Canary'),(3071,'Теруэль','Teruel','','Spain',724,'Europe/Madrid'),(3072,'Толедо','Toledo','','Spain',724,'Europe/Madrid'),(100752,'Торо','Toro','','Spain',724,'Europe/Madrid'),(100753,'Торрелавега','Torrelavega','','Spain',724,'Europe/Madrid'),(3073,'Тортоса','Tortosa','','Spain',724,'Europe/Madrid'),(100754,'Трухильо','Trujillo','','Spain',724,'Europe/Madrid'),(100900,'Утрера','Utrera','','Spain',724,'Europe/Madrid'),(3022,'Уэльва','Huelva','','Spain',724,'Europe/Madrid'),(3023,'Уэска','Huesca','','Spain',724,'Europe/Madrid'),(55283,'Уэте','Huete','','Spain',724,'Europe/Madrid'),(3012,'Ферроль','El Ferrol','','Spain',724,'Europe/Madrid'),(55156,'Фос','Foz','','Spain',724,'Europe/Madrid'),(55164,'Фуэнлабрада','Fuenlabrada','','Spain',724,'Europe/Madrid'),(3014,'Фуэртевентура','Fuerteventura','','Spain',724,'Atlantic/Canary'),(101054,'Хатива','Xativa','','Spain',724,'Europe/Madrid'),(3026,'Хаэн','Jaen','','Spain',724,'Europe/Madrid'),(3027,'Херес-де-ла-Фронтера','Jerez de la Frontera','','Spain',724,'Europe/Madrid'),(100179,'Херес-де-ла-Фронтера','Jerez','','Spain',724,'Europe/Madrid'),(3015,'Херона','Girona','','Spain',724,'Europe/Madrid'),(55248,'Хетафе','Getafe','','Spain',724,'Europe/Madrid'),(3016,'Хихон','Gijon','','Spain',724,'Europe/Madrid'),(55009,'Честе','Cheste','','Spain',724,'Europe/Madrid'),(55069,'Эйбар','Eibar','','Spain',724,'Europe/Madrid'),(55095,'Эль-Пасо','El Paso','','Spain',724,'Atlantic/Canary'),(55099,'Эль-Пуэрто-де-Санта-Мария','El Puerto de Santa Maria','','Spain',724,'Europe/Madrid'),(55107,'Эль-Эхидо','El Ejido','','Spain',724,'Europe/Madrid'),(55256,'Эльин','Hellin','','Spain',724,'Europe/Madrid'),(99940,'Эльче','Elche','','Spain',724,'Europe/Madrid'),(55116,'Эсиха','Ecija','','Spain',724,'Europe/Madrid'),(92720,'Аверса','Aversa','','Italy',380,'Europe/Rome'),(92721,'Авеццано','Avezzano','','Italy',380,'Europe/Rome'),(92706,'Алессандрия','Alessandria','','Italy',380,'Europe/Rome'),(92705,'Алькамо','Alcamo','','Italy',380,'Europe/Rome'),(92708,'Альтамура','Altamura','','Italy',380,'Europe/Rome'),(92709,'Амальфи','Amalfi','','Italy',380,'Europe/Rome'),(92713,'Анцьо','Anzio','','Italy',380,'Europe/Rome'),(92714,'Аоста','Aosta','','Italy',380,'Europe/Rome'),(92716,'Ареццо','Arezzo','','Italy',380,'Europe/Rome'),(92717,'Асколи-Пичено','Ascoli Piceno','','Italy',380,'Europe/Rome'),(92718,'Ассизи','Assisi','','Italy',380,'Europe/Rome'),(92719,'Асти','Asti','','Italy',380,'Europe/Rome'),(92702,'Ачиреале','Acireale','','Italy',380,'Europe/Rome'),(92784,'Багерия','Bagheria','','Italy',380,'Europe/Rome'),(92789,'Бари','Bari','','Italy',380,'Europe/Rome'),(92791,'Барлетта','Barletta','','Italy',380,'Europe/Rome'),(92794,'Беллуно','Belluno','','Italy',380,'Europe/Rome'),(92796,'Бергамо','Bergamo','','Italy',380,'Europe/Rome'),(92803,'Болонья','Bologna','','Italy',380,'Europe/Rome'),(92804,'Больцано','Bolzano','','Italy',380,'Europe/Rome'),(92807,'Бормио','Bormio','','Italy',380,'Europe/Rome'),(6498,'Брешия','Brescia','','Italy',380,'Europe/Rome'),(92809,'Бриндизи','Brindisi','','Italy',380,'Europe/Rome'),(92815,'Бусто-Арсицио','Busto Arsizio','','Italy',380,'Europe/Rome'),(95042,'Варезе','Varese','','Italy',380,'Europe/Rome'),(95044,'Васто','Vasto','','Italy',380,'Europe/Rome'),(95045,'Ватикан','Vatican City','','Italy',380,'Europe/Vatican'),(95047,'Венеция','Venice','','Italy',380,'Europe/Rome'),(95048,'Вентимилья','Ventimiglia','','Italy',380,'Europe/Rome'),(95049,'Верона','Verona','','Italy',380,'Europe/Rome'),(95051,'Виареджо','Viareggio','','Italy',380,'Europe/Rome'),(95052,'Вибо-Валентия','Vibo Valentia','','Italy',380,'Europe/Rome'),(95058,'Витербо','Viterbo','','Italy',380,'Europe/Rome'),(95054,'Виченца','Vicenza','','Italy',380,'Europe/Rome'),(93552,'Гарда','Garda','','Italy',380,'Europe/Rome'),(93558,'Генуя','Genoa','','Italy',380,'Europe/Rome'),(93565,'Гориция','Gorizia','','Italy',380,'Europe/Rome'),(93571,'Гроссето','Grosseto','','Italy',380,'Europe/Rome'),(93573,'Гуальдо-Тадино','Gualdo Tadino','','Italy',380,'Europe/Rome'),(93170,'Дезенцано-дель-Гарда','Desenzano','','Italy',380,'Europe/Rome'),(93554,'Джела','Gela','','Italy',380,'Europe/Rome'),(93650,'Имола','Imola','','Italy',380,'Europe/Rome'),(93652,'Империя','Imperia','','Italy',380,'Europe/Rome'),(93026,'Казерта','Caserta','','Italy',380,'Europe/Rome'),(92994,'Кальтаджироне','Caltagirone','','Italy',380,'Europe/Rome'),(92997,'Кальтаниссетта','Caltanissetta','','Italy',380,'Europe/Rome'),(92992,'Кальяри','Cagliari','','Italy',380,'Europe/Rome'),(93002,'Кампобассо','Campobasso','','Italy',380,'Europe/Rome'),(93033,'Кассино','Cassino','','Italy',380,'Europe/Rome'),(93039,'Кастельветрано','Castelvetrano','','Italy',380,'Europe/Rome'),(93044,'Катандзаро','Catanzaro','','Italy',380,'Europe/Rome'),(93043,'Катания','Catania','','Italy',380,'Europe/Rome'),(93060,'Комо','Como','','Italy',380,'Europe/Rome'),(93062,'Кортона','Cortona','','Italy',380,'Europe/Rome'),(93065,'Кремона','Cremona','','Italy',380,'Europe/Rome'),(93066,'Кротоне','Crotone','','Italy',380,'Europe/Rome'),(93067,'Кунео','Cuneo','','Italy',380,'Europe/Rome'),(93837,'Лайвес','Laives','','Italy',380,'Europe/Rome'),(93840,'Ланчано','Lanciano','','Italy',380,'Europe/Rome'),(93845,'Лекко','Lecco','','Italy',380,'Europe/Rome'),(93846,'Лена','Lenna','','Italy',380,'Europe/Rome'),(6544,'Лечче','Lecce','','Italy',380,'Europe/Rome'),(93849,'Ливиньо','Livigno','','Italy',380,'Europe/Rome'),(93850,'Ливорно','Livorno','','Italy',380,'Europe/Rome'),(93848,'Ликата','Licata','','Italy',380,'Europe/Rome'),(93853,'Лукка','Lucca','','Italy',380,'Europe/Rome'),(93985,'Марсала','Marsala','','Italy',380,'Europe/Rome'),(93987,'Масса','Massa','','Italy',380,'Europe/Rome'),(93992,'Матера','Matera','','Italy',380,'Europe/Rome'),(93993,'Мерано','Merano','','Italy',380,'Europe/Rome'),(93994,'Мессина','Messina','','Italy',380,'Europe/Rome'),(93997,'Милан','Milan','','Italy',380,'Europe/Rome'),(94637,'Минтурно','Scauri','','Italy',380,'Europe/Rome'),(94004,'Модена','Modena','','Italy',380,'Europe/Rome'),(94005,'Модика','Modica','','Italy',380,'Europe/Rome'),(94009,'Мольфетта','Molfetta','','Italy',380,'Europe/Rome'),(94011,'Мондрагоне','Mondragone','','Italy',380,'Europe/Rome'),(94010,'Монкальери','Moncalieri','','Italy',380,'Europe/Rome'),(94022,'Монтезильвано','Montesilvano','','Italy',380,'Europe/Rome'),(94024,'Монца','Monza','','Italy',380,'Europe/Rome'),(6557,'Неаполь','Napoli','','Italy',380,'Europe/Rome'),(94122,'Неаполь','Naples','','Italy',380,'Europe/Rome'),(94124,'Новара','Novara','','Italy',380,'Europe/Rome'),(94125,'Нуоро','Nuoro','','Italy',380,'Europe/Rome'),(94147,'Ольбия','Olbia','','Italy',380,'Europe/Rome'),(94148,'Орвието','Orvieto','','Italy',380,'Europe/Rome'),(94286,'Падуя','Padova','','Italy',380,'Europe/Rome'),(94284,'Пакино','Pachino','','Italy',380,'Europe/Rome'),(94290,'Палермо','Palermo','','Italy',380,'Europe/Rome'),(94294,'Палми','Palmi','','Italy',380,'Europe/Rome'),(94296,'Парма','Parma','','Italy',380,'Europe/Rome'),(94304,'Пезаро','Pesaro','','Italy',380,'Europe/Rome'),(6570,'Перуджа','Perugia','','Italy',380,'Europe/Rome'),(94306,'Пескара','Pescara','','Italy',380,'Europe/Rome'),(6574,'Пиза','Pisa','','Italy',380,'Europe/Rome'),(94319,'Поджибонси','Poggibonsi','','Italy',380,'Europe/Rome'),(94337,'Позитано','Positano','','Italy',380,'Europe/Rome'),(94320,'Поликоро','Policoro','','Italy',380,'Europe/Rome'),(94323,'Помпеи','Pompei','','Italy',380,'Europe/Rome'),(94329,'Порденоне','Pordenone','','Italy',380,'Europe/Rome'),(94335,'Порт-Эмпедокле','Porto Empedocle','','Italy',380,'Europe/Rome'),(94339,'Потенца','Potenza','','Italy',380,'Europe/Rome'),(94341,'Прато','Prato','','Italy',380,'Europe/Rome'),(94314,'Пьомбино','Piombino','','Italy',380,'Europe/Rome'),(94310,'Пьяченца','Piacenza','','Italy',380,'Europe/Rome'),(94458,'Равенна','Ravenna','','Italy',380,'Europe/Rome'),(94455,'Рагуза','Ragusa','','Italy',380,'Europe/Rome'),(94460,'Реджо-ди-Калабрия','Reggio Calabria','','Italy',380,'Europe/Rome'),(94461,'Реджо-ди-Калабрия','Reggio di Calabria','','Italy',380,'Europe/Rome'),(94464,'Риети','Rieti','','Italy',380,'Europe/Rome'),(13501,'Рим','Rome','','Italy',380,'Europe/Rome'),(94465,'Римини','Rimini','','Italy',380,'Europe/Rome'),(94470,'Ровиго','Rovigo','','Italy',380,'Europe/Rome'),(94636,'Савона','Savona','','Italy',380,'Europe/Rome'),(94613,'Салерно','Salerno','','Italy',380,'Europe/Rome'),(94614,'Сало','Salo','','Italy',380,'Europe/Rome'),(94634,'Сассари','Sassari','','Italy',380,'Europe/Rome'),(94641,'Сидерно','Siderno','','Italy',380,'Europe/Rome'),(94642,'Сиена','Siena','','Italy',380,'Europe/Rome'),(94645,'Сирмионе','Sirmione','','Italy',380,'Europe/Rome'),(94646,'Сорренто','Sorrento','','Italy',380,'Europe/Rome'),(93836,'Специя','La Spezia','','Italy',380,'Europe/Rome'),(94649,'Сполето','Spoleto','','Italy',380,'Europe/Rome'),(13503,'Таранто','Taranto','','Italy',380,'Europe/Rome'),(94808,'Таурианова','Taurianova','','Italy',380,'Europe/Rome'),(94810,'Терамо','Teramo','','Italy',380,'Europe/Rome'),(94813,'Терни','Terni','','Italy',380,'Europe/Rome'),(94814,'Террачина','Terracina','','Italy',380,'Europe/Rome'),(94819,'Тоди','Todi','','Italy',380,'Europe/Rome'),(94821,'Торре-дель-Греко','Torre del Greco','','Italy',380,'Europe/Rome'),(94823,'Трапани','Trapani','','Italy',380,'Europe/Rome'),(94825,'Тревизо','Treviso','','Italy',380,'Europe/Rome'),(94824,'Тренто','Trento','','Italy',380,'Europe/Rome'),(94826,'Триест','Trieste','','Italy',380,'Europe/Rome'),(94827,'Турин','Turin','','Italy',380,'Europe/Rome'),(94816,'Тьене','Thiene','','Italy',380,'Europe/Rome'),(94942,'Удине','Udine','','Italy',380,'Europe/Rome'),(93422,'Феррара','Ferrara','','Italy',380,'Europe/Rome'),(93424,'Флоренция','Florence','','Italy',380,'Europe/Rome'),(93427,'Формия','Formia','','Italy',380,'Europe/Rome'),(93431,'Фрозиноне','Frosinone','','Italy',380,'Europe/Rome'),(6512,'Червиа','Cervia','','Italy',380,'Europe/Rome'),(93047,'Чертальдо','Certaldo','','Italy',380,'Europe/Rome'),(93056,'Чивитавеккья','Civitavecchia','','Italy',380,'Europe/Rome'),(94638,'Шакка','Sciacca','','Italy',380,'Europe/Rome'),(93250,'Эмполи','Empoli','','Italy',380,'Europe/Rome'),(9108,'','Sana','','Yemen',887,'Asia/Aden'),(9091,'Аден','Aden','','Yemen',887,'Asia/Aden'),(9097,'Атак','Ataq','','Yemen',887,'Asia/Aden'),(9098,'Дамар','Dhamar','','Yemen',887,'Asia/Aden'),(9101,'Ибб','Ibb','','Yemen',887,'Asia/Aden'),(9103,'Мариб','Marib','','Yemen',887,'Asia/Aden'),(9104,'Моха','Mokha','','Yemen',887,'Asia/Aden'),(9107,'Саада','Saada','','Yemen',887,'Asia/Aden'),(9111,'Таиз','Taiz','','Yemen',887,'Asia/Aden'),(9100,'Ходейда','Hodeidah','','Yemen',887,'Asia/Aden'),(4235,'Минделу','Mindelo','','Cape Verde',132,'Atlantic/Cape_Verde'),(4236,'Прая','Praia','','Cape Verde',132,'Atlantic/Cape_Verde'),(4237,'Сал','Sal','','Cape Verde',132,'Atlantic/Cape_Verde'),(13655,'','Атбасар','','Kazakhstan',398,'Asia/Almaty'),(13693,'','Капчагай','','Kazakhstan',398,'Asia/Almaty'),(13715,'','Ленгер','','Kazakhstan',398,'Asia/Almaty'),(13717,'','Лисаковск','','Kazakhstan',398,'Asia/Qyzylorda'),(13739,'','Сергеевка','','Kazakhstan',398,'Asia/Almaty'),(13757,'','Темир','','Kazakhstan',398,'Asia/Aqtobe'),(13785,'','Щучинск','','Kazakhstan',398,'Asia/Almaty'),(13639,'Аксу','Aksu','','Kazakhstan',398,'Asia/Almaty'),(13641,'Актау','Aktau','','Kazakhstan',398,'Asia/Aqtau'),(13647,'Алматы','Almaty','','Kazakhstan',398,'Asia/Almaty'),(13651,'Аркалык','Arkalyk','','Kazakhstan',398,'Asia/Almaty'),(13653,'Астана','Astana','','Kazakhstan',398,'Asia/Almaty'),(13657,'Атырау','Atyrau','','Kazakhstan',398,'Asia/Oral'),(6959,'Байконур','Baikonur','','Kazakhstan',398,'Asia/Almaty'),(13661,'Балхаш','Balqash','','Kazakhstan',398,'Asia/Almaty'),(13681,'Жезказган','Zhezkazgan','','Kazakhstan',398,'Asia/Almaty'),(6947,'Жетикара','Getigara','','Kazakhstan',398,''),(13695,'Караганда','Karaganda','','Kazakhstan',398,'Asia/Almaty'),(13705,'Кокшетау','Kokshetau','','Kazakhstan',398,'Asia/Almaty'),(13713,'Кызылорда','Kyzylorda','','Kazakhstan',398,'Asia/Qyzylorda'),(13723,'Павлодар','Pavlodar','','Kazakhstan',398,'Asia/Almaty'),(13725,'Петропавловск','Petropavl','','Kazakhstan',398,'Asia/Almaty'),(13729,'Риддер','Ridder','','Kazakhstan',398,'Asia/Almaty'),(13737,'Семипалатинск','Semey','','Kazakhstan',398,'Asia/Almaty'),(13743,'Степногорск','Stepnogorsk','','Kazakhstan',398,'Asia/Almaty'),(13753,'Тараз','Taraz','','Kazakhstan',398,'Asia/Almaty'),(13759,'Темиртау','Temirtau','','Kazakhstan',398,'Asia/Almaty'),(13761,'Туркестан','Turkestan','','Kazakhstan',398,'Asia/Almaty'),(13763,'Уральск','Oral','','Kazakhstan',398,'Asia/Oral'),(13765,'Усть-Каменогорск','Oskemen','','Kazakhstan',398,'Asia/Almaty'),(13781,'Шу','Shu','','Kazakhstan',398,'Asia/Almaty'),(13783,'Шымкент','Shymkent','','Kazakhstan',398,'Asia/Almaty'),(4207,'Баттамбанг','Battambang','','Cambodia',116,'Asia/Phnom_Penh'),(4208,'Кампот','Kampot','','Cambodia',116,'Asia/Phnom_Penh'),(4212,'Пномпень','Phnom-Penh','','Cambodia',116,'Asia/Phnom_Penh'),(4218,'Баменда','Bamenda','','Cameroon',120,'Africa/Douala'),(4223,'Гаруа','Garoua','','Cameroon',120,'Africa/Douala'),(4222,'Дуала','Douala','','Cameroon',120,'Africa/Douala'),(4234,'Йоко','Yoko','','Cameroon',120,'Africa/Douala'),(4225,'Криби','Kribi','','Cameroon',120,'Africa/Douala'),(4228,'Маруа','Maroua','','Cameroon',120,'Africa/Douala'),(4231,'Нконгсамба','Nkongsamba','','Cameroon',120,'Africa/Douala'),(4233,'Яунде','Yaounde','','Cameroon',120,'Africa/Douala'),(109165,'Абердин','Aberdeen','','Canada',124,'America/Regina'),(109244,'Авола','Avola','','Canada',124,'America/Vancouver'),(109240,'Аврора','Aurora','','Canada',124,'America/Toronto'),(109184,'Александр','Alexander','','Canada',124,'America/Cambridge_Bay'),(109185,'Александрия','Alexandria','','Canada',124,'America/Toronto'),(109206,'Ангус','Angus','','Canada',124,'America/Toronto'),(109216,'Ардроссан','Ardrossan','','Canada',124,'America/Edmonton'),(109221,'Арма','Armagh','','Canada',124,'America/Montreal'),(109228,'Асбест','Asbestos','','Canada',124,'America/Montreal'),(109175,'Аякс','Ajax','','Canada',124,'America/Toronto'),(109251,'Баден','Baden','','Canada',124,'America/Toronto'),(109268,'Банфф','Banff','','Canada',124,'America/Edmonton'),(109270,'Барон','Barons','','Canada',124,'America/Edmonton'),(109278,'Бассано','Bassano','','Canada',124,'America/Edmonton'),(109311,'Бедфорд','Bedford','','Canada',124,'America/Montreal'),(109320,'Бельвиль','Belleville','','Canada',124,'America/Toronto'),(109321,'Бельвю','Bellevue','','Canada',124,'America/Edmonton'),(109328,'Берген','Bergen','','Canada',124,'America/Edmonton'),(109428,'Бёрлингтон','Burlington','','Canada',124,'America/Toronto'),(109429,'Бернаби','Burnaby','','Canada',124,'America/Vancouver'),(109387,'Бойл','Boyle','','Canada',124,'America/Edmonton'),(109373,'Болтон','Bolton','','Canada',124,'America/Toronto'),(109402,'Брайтон','Brighton','','Canada',124,'America/Toronto'),(109391,'Брамптон','Brampton','','Canada',124,'America/Toronto'),(109399,'Бриджтаун','Bridgetown','','Canada',124,'America/Halifax'),(109413,'Брукс','Brooks','','Canada',124,'America/Edmonton'),(109418,'Бруно','Bruno','','Canada',124,'America/Regina'),(109389,'Брэдфорд','Bradford','','Canada',124,'America/Toronto'),(111418,'Вайоминг','Wyoming','','Canada',124,'America/Toronto'),(111271,'Ванкувер','Vancouver','','Canada',124,'America/Vancouver'),(111333,'Ватерлоо','Waterloo','','Canada',124,'America/Toronto'),(110455,'Вашингтон','Mount Washington','','Canada',124,'America/Vancouver'),(111282,'Верден','Verdun','','Canada',124,'America/Montreal'),(111288,'Верона','Verona','','Canada',124,'America/Toronto'),(111290,'Виктория','Victoria','','Canada',124,'America/Vancouver'),(111296,'Вильнюс','Vilna','','Canada',124,'America/Edmonton'),(111392,'Виндзор','Windsor','','Canada',124,'America/Toronto'),(111396,'Виннипег','Winnipeg','','Canada',124,'America/Winnipeg'),(111390,'Винчестер','Winchester','','Canada',124,'America/Toronto'),(111411,'Вудсток','Woodstock','','Canada',124,'America/Toronto'),(111300,'Вулкан','Vulcan','','Canada',124,'America/Edmonton'),(109967,'Гаага','Hague','','Canada',124,'America/Regina'),(109974,'Гамильтон','Hamilton','','Canada',124,'America/Toronto'),(109878,'Ганг','Ganges','','Canada',124,'America/Vancouver'),(109980,'Ганновер','Hanover','','Canada',124,'America/Toronto'),(109993,'Гастингс','Hastings','','Canada',124,'America/Toronto'),(109932,'Гранд-Рапидс','Grand Rapids','','Canada',124,'America/Winnipeg'),(109710,'Дандолк','Dundalk','','Canada',124,'America/Toronto'),(109719,'Дарем','Durham','','Canada',124,'America/Toronto'),(109675,'Девон','Devon','','Canada',124,'America/Moncton'),(109659,'Дели','Delhi','','Canada',124,'America/Toronto'),(109662,'Делсон','Delson','','Canada',124,'America/Montreal'),(110076,'Джеймстаун','Jamestown','','Canada',124,'America/Toronto'),(109701,'Дрезден','Dresden','','Canada',124,'America/Toronto'),(109699,'Дувр','Dover','','Canada',124,'America/St_Johns'),(109709,'Дункан','Duncan','','Canada',124,'America/Toronto'),(110062,'Икалуит','Iqaluit','','Canada',124,'America/Iqaluit'),(111426,'Йеллоунайф','Yellowknife','','Canada',124,'America/Yellowknife'),(109443,'Калгари','Calgary','','Canada',124,'America/Edmonton'),(109442,'Каледония','Caledonia','','Canada',124,'America/Toronto'),(109634,'Камберленд','Cumberland','','Canada',124,'America/Vancouver'),(109492,'Карп','Carp','','Canada',124,'America/Toronto'),(109500,'Кастор','Castor','','Canada',124,'America/Edmonton'),(109502,'Каталина','Catalina','','Canada',124,'America/St_Johns'),(110741,'Квебек','Quebec','','Canada',124,'America/Montreal'),(110101,'Келоуна','Kelowna','','Canada',124,'America/Vancouver'),(109447,'Кембридж','Cambridge','','Canada',124,'America/Toronto'),(110109,'Кенсингтон','Kensington','','Canada',124,'America/Halifax'),(110117,'Килларни','Killarney','','Canada',124,'America/Winnipeg'),(110118,'Кимберли','Kimberley','','Canada',124,'America/Edmonton'),(110125,'Кингстон','Kingston','','Canada',124,'America/Toronto'),(110133,'Китченер','Kitchener','','Canada',124,'America/Toronto'),(109559,'Клермон','Clermont','','Canada',124,'America/Montreal'),(109561,'Клинтон','Clinton','','Canada',124,'America/Toronto'),(109585,'Коллингвуд','Collingwood','','Canada',124,'America/Toronto'),(109579,'Колчестер','Colchester','','Canada',124,'America/Toronto'),(109597,'Коннахт','Connaught','','Canada',124,'America/Toronto'),(109608,'Корнер-Брук','Corner Brook','','Canada',124,'America/St_Johns'),(109609,'Корнуолл','Cornwall','','Canada',124,'America/Toronto'),(109627,'Кремона','Cremona','','Canada',124,'America/Edmonton'),(110176,'Лакомб','Lacombe','','Canada',124,'America/Edmonton'),(110195,'Ланг','Lang','','Canada',124,'America/Regina'),(110192,'Ланкастер','Lancaster','','Canada',124,'America/Toronto'),(109821,'Лес','Forest','','Canada',124,'America/Toronto'),(110246,'Ливерпуль','Liverpool','','Canada',124,'America/Halifax'),(110235,'Лимерик','Limerick','','Canada',124,'America/Regina'),(109747,'Локоть','Elbow','','Canada',124,'America/Regina'),(110254,'Лондон','London','','Canada',124,'America/Toronto'),(110276,'Лунд','Lund','','Canada',124,'America/Vancouver'),(110266,'Лурд','Lourdes','','Canada',124,'America/Montreal'),(110223,'Львов','Lemberg','','Canada',124,'America/Regina'),(110380,'Майами','Miami','','Canada',124,'America/Winnipeg'),(110332,'Мальборо','Marlboro','','Canada',124,'America/Edmonton'),(110326,'Марафон','Marathon','','Canada',124,'America/Toronto'),(110398,'Минден','Minden','','Canada',124,'America/Toronto'),(110412,'Митчелл','Mitchell','','Canada',124,'America/Toronto'),(110427,'Монреаль','Montreal','','Canada',124,'America/Montreal'),(110443,'Морли','Morley','','Canada',124,'America/Edmonton'),(110445,'Моррис','Morris','','Canada',124,'America/Winnipeg'),(110485,'Нельсон','Nelson','','Canada',124,'America/Vancouver'),(110512,'Николе','Nicolet','','Canada',124,'America/Montreal'),(110535,'Норидж','Norwich','','Canada',124,'America/Toronto'),(110502,'Нью-Вестминстер','New Westminster','','Canada',124,'America/Vancouver'),(110505,'Ньюкасл','Newcastle','','Canada',124,'America/Toronto'),(110508,'Ньюпорт','Newport','','Canada',124,'America/Montreal'),(110552,'Ока','Oka','','Canada',124,'America/Montreal'),(110582,'Оксфорд','Oxford','','Canada',124,'America/Halifax'),(110569,'Орлеан','Orleans','','Canada',124,'America/Toronto'),(109241,'Остин','Austin','','Canada',124,'America/Winnipeg'),(110575,'Оттава','Ottawa','','Canada',124,'America/Toronto'),(110600,'Париж','Paris','','Canada',124,'America/Whitehorse'),(110588,'Пейсли','Paisley','','Canada',124,'America/Toronto'),(110623,'Перт','Perth','','Canada',124,'America/Toronto'),(110625,'Питерборо','Peterborough','','Canada',124,'America/Toronto'),(110707,'Порт-Стэнли','Port Stanley','','Canada',124,'America/Toronto'),(110722,'Прескотт','Prescott','','Canada',124,'America/Toronto'),(110723,'Престон','Preston','','Canada',124,'America/Halifax'),(110727,'Принс-Джордж','Prince George','','Canada',124,'America/Vancouver'),(110658,'Пуэнт-Нуар','Pointe Noire','','Canada',124,'America/Montreal'),(110595,'Рай','Paradise','','Canada',124,'America/St_Johns'),(110841,'Рассел','Russell','','Canada',124,'America/Winnipeg'),(110780,'Рейн','Rhein','','Canada',124,'America/Regina'),(110800,'Река','Rivers','','Canada',124,'America/Winnipeg'),(110807,'Ривьер-дю-Лу','Riviere-du-Loup','','Canada',124,'America/Montreal'),(110793,'Рипли','Ripley','','Canada',124,'America/Toronto'),(110785,'Ричмонд','Richmond','','Canada',124,'America/Vancouver'),(110783,'Ришельё','Richelieu','','Canada',124,'America/Montreal'),(110824,'Рондо','Rondeau','','Canada',124,'America/Detroit'),(111008,'Савона','Savona','','Canada',124,'America/Vancouver'),(111144,'Садбери','Sudbury','','Canada',124,'America/Toronto'),(111004,'Сарния','Sarnia','','Canada',124,'America/Toronto'),(111005,'Саскатун','Saskatoon','','Canada',124,'America/Regina'),(111085,'Саутгемптон','Southampton','','Canada',124,'America/Atikokan'),(110863,'Сен-Луи','Saint Louis','','Canada',124,'America/Regina'),(110932,'Сен-Мало','Saint-Malo','','Canada',124,'America/Winnipeg'),(111162,'Сидней','Sydney','','Canada',124,'America/Glace_Bay'),(111057,'Симпсон','Simpson','','Canada',124,'America/Regina'),(111011,'Скарборо','Scarborough','','Canada',124,'America/Toronto'),(111065,'Смит','Smith','','Canada',124,'America/Monterrey'),(110993,'Солсбери','Salisbury','','Canada',124,'America/Moncton'),(111079,'Сорренто','Sorrento','','Canada',124,'America/Vancouver'),(111089,'Спарта','Sparta','','Canada',124,'America/Toronto'),(111100,'Спрингфилд','Springfield','','Canada',124,'America/Halifax'),(111135,'Страсбург','Strasbourg','','Canada',124,'America/Regina'),(111113,'Стэнли','Stanley','','Canada',124,'America/Moncton'),(111146,'Султан','Sultan','','Canada',124,'America/Toronto'),(111154,'Суррей','Surrey','','Canada',124,'America/Vancouver'),(111204,'Тандер-Бей','Thunder Bay','','Canada',124,'America/Thunder_Bay'),(111173,'Танжер','Tangier','','Canada',124,'America/Halifax'),(111178,'Тейлор','Taylor','','Canada',124,'America/Los_Angeles'),(111179,'Текумсе','Tecumseh','','Canada',124,'America/Toronto'),(111198,'Томпсон','Thompson','','Canada',124,'America/Winnipeg'),(111220,'Торки','Torquay','','Canada',124,'America/Regina'),(111218,'Торонто','Toronto','','Canada',124,'America/Toronto'),(111224,'Трейси','Tracy','','Canada',124,'America/Moncton'),(111234,'Труа-Ривьер','Trois-Rivieres','','Canada',124,'America/Montreal'),(111237,'Труро','Truro','','Canada',124,'America/Halifax'),(111378,'Уитни','Whitney','','Canada',124,'America/Toronto'),(111404,'Уокинг','Woking','','Canada',124,'America/Edmonton'),(111325,'Уорик','Warwick','','Canada',124,'America/Montreal'),(111332,'Уотерфорд','Waterford','','Canada',124,'America/Toronto'),(111337,'Уотсон','Watson','','Canada',124,'America/Regina'),(111335,'Уотфорд','Watford','','Canada',124,'America/Toronto'),(109811,'Флеминг','Fleming','','Canada',124,'America/Regina'),(109814,'Флин-Флон','Flin Flon','','Canada',124,'America/Winnipeg'),(109859,'Фредериктон','Fredericton','','Canada',124,'America/Moncton'),(110041,'Халл','Hull','','Canada',124,'America/Montreal'),(110045,'Хантсвилл','Huntsville','','Canada',124,'America/Toronto'),(110007,'Хеврон','Hebron','','Canada',124,'America/Halifax'),(110036,'Хьюстон','Houston','','Canada',124,'America/Vancouver'),(109521,'Чаплин','Chaplin','','Canada',124,'America/Regina'),(109531,'Чатем','Chatham','','Canada',124,'America/Toronto'),(109537,'Честер','Chester','','Canada',124,'America/Halifax'),(109526,'Шарлоттаун','Charlottetown','','Canada',124,'America/Halifax'),(111045,'Шербрук','Sherbrooke','','Canada',124,'America/Montreal'),(109739,'Эдмонтон','Edmonton','','Canada',124,'America/Edmonton'),(109743,'Эдмундстон','Edmundston','','Canada',124,'America/Moncton'),(109744,'Эдсон','Edson','','Canada',124,'America/Edmonton'),(109248,'Эйр','Ayr','','Canada',124,'America/Toronto'),(109787,'Эксетер','Exeter','','Canada',124,'America/Toronto'),(109775,'Эссекс','Essex','','Canada',124,'America/Toronto'),(111429,'Янг','Young','','Canada',124,'America/Regina'),(111430,'Янгстаун','Youngstown','','Canada',124,'America/New_York'),(7016,'Гарисса','Garissa','','Kenya',404,'Africa/Nairobi'),(7017,'Какамега','Kakamega','','Kenya',404,'Africa/Nairobi'),(7020,'Кисуму','Kisumu','','Kenya',404,'Africa/Nairobi'),(7021,'Китале','Kitale','','Kenya',404,'Africa/Nairobi'),(7022,'Ламу','Lamu','','Kenya',404,'Africa/Nairobi'),(7028,'Меру','Meru','','Kenya',404,'Africa/Nairobi'),(7029,'Момбаса','Mombasa','','Kenya',404,'Africa/Nairobi'),(7037,'Найроби','Nairobi','','Kenya',404,'Africa/Nairobi'),(7032,'Накуру','Nakuru','','Kenya',404,'Africa/Nairobi'),(7034,'Ньери','Nyeri','','Kenya',404,'Africa/Nairobi'),(7014,'Элдорет','Eldoret','','Kenya',404,'Africa/Nairobi'),(94,'Ларнака','Larnaca','','Cyprus',196,'Asia/Nicosia'),(95,'Лимасол','Limassol','','Cyprus',196,'Asia/Nicosia'),(55578,'Никосия','Nicosia','','Cyprus',196,'Asia/Nicosia'),(96,'Пафос','Paphos','','Cyprus',196,'Asia/Nicosia'),(106595,'Пафос','Ktima','','Cyprus',196,'Asia/Nicosia'),(4338,'','Ching-T','','China',156,'Asia/Shanghai'),(4341,'','Ch','','China',156,'Asia/Shanghai'),(4475,'','Jian','','China',156,'Asia/Shanghai'),(4482,'','Ji','','China',156,'Asia/Shanghai'),(4514,'','Lai-Yen-Ch','','China',156,'Asia/Shanghai'),(4550,'','Long','','China',156,'Asia/Shanghai'),(4614,'','Pa-Erh-Lu-K','','China',156,'Asia/Kashgar'),(4626,'','P','','China',156,'Asia/Chongqing'),(4655,'','Ruo','','China',156,'Europe/Moscow'),(4273,'Алтай','Altay','','China',156,'Asia/Urumqi'),(4276,'Анда','Anda','','China',156,'Asia/Harbin'),(4278,'Анькан','Ankang','','China',156,'Asia/Chongqing'),(4279,'Аньцин','Anqing','','China',156,'Asia/Shanghai'),(4283,'Аньян','Anyang','','China',156,'Asia/Shanghai'),(4286,'Бабао','Babao','','China',156,'Asia/Chongqing'),(4294,'Баодин','Baoding','','China',156,'Asia/Shanghai'),(4295,'Баоцзи','Baoji','','China',156,'Asia/Chongqing'),(4308,'Бэнбу','Bengbu','','China',156,'Asia/Shanghai'),(4309,'Бэньси','Benxi','','China',156,'Asia/Shanghai'),(4756,'Вэйфан','Weifang','','China',156,'Asia/Shanghai'),(4399,'Ганьчжоу','Ganzhou','','China',156,'Asia/Shanghai'),(4413,'Гуанчжоу','Guangzhou','','China',156,'Asia/Shanghai'),(4414,'Гуйлинь','Guilin','','China',156,'Asia/Chongqing'),(4416,'Гуйян','Guiyang','','China',156,'Asia/Chongqing'),(4349,'Дали','Dali','','China',156,'Asia/Chongqing'),(4350,'Далянь','Dalian','','China',156,'Asia/Shanghai'),(4351,'Даньдун','Dandong','','China',156,'Asia/Shanghai'),(4356,'Датун','Datong','','China',156,'Asia/Shanghai'),(4651,'Жичжао','Rizhao','','China',156,'Asia/Shanghai'),(4833,'Инкоу','Yingkou','','China',156,'Asia/Shanghai'),(4831,'Иньчуань','Yinchuan','','China',156,'Asia/Chongqing'),(4502,'Каилу','Kailu','','China',156,'Asia/Shanghai'),(4504,'Карамай','Karamay','','China',156,'Asia/Urumqi'),(4505,'Каши','Kashi','','China',156,'Asia/Kashgar'),(4507,'Корла','Korla','','China',156,'Asia/Urumqi'),(4510,'Кука','Kuqa','','China',156,'Asia/Urumqi'),(4509,'Куньмин','Kunming','','China',156,'Asia/Chongqing'),(4519,'Ланьчжоу','Lanzhou','','China',156,'Asia/Chongqing'),(4536,'Линьхай','Linhai','','China',156,'Asia/Shanghai'),(4543,'Лиши','Lishi','','China',156,'Asia/Shanghai'),(4544,'Лишуи','Lishui','','China',156,'Asia/Shanghai'),(4523,'Лхаса','Lhasa','','China',156,'Asia/Urumqi'),(4547,'Лючжоу','Liuzhou','','China',156,'Asia/Chongqing'),(4563,'Ляоян','Luoyuan','','China',156,'Asia/Shanghai'),(4569,'Маньян','Ma-Jiang','','China',156,'Asia/Shanghai'),(4571,'Мачень','Macheng','','China',156,'Asia/Shanghai'),(4590,'Муданьцзян','Mudanjiang','','China',156,'Asia/Harbin'),(4598,'Нанкин','Nanjing','','China',156,'Asia/Shanghai'),(4599,'Наньнин','Nanning','','China',156,'Asia/Chongqing'),(4600,'Наньпин','Nanping','','China',156,'Asia/Shanghai'),(4592,'Наньчан','Nanchang','','China',156,'Asia/Shanghai'),(4609,'Нэйцзян','Nenjiang','','China',156,'Asia/Harbin'),(4307,'Пекин','Beijing','','China',156,'Asia/Shanghai'),(4620,'Пинлян','Pingliang','','China',156,'Asia/Chongqing'),(4696,'Синан','Sinan','','China',156,'Asia/Chongqing'),(4697,'Сыпин','Siping','','China',156,'Asia/Harbin'),(4706,'Сюйчжоу','Suizhong','','China',156,'Asia/Shanghai'),(4713,'Тайбэй','Taibei','','China',156,'Asia/Kashgar'),(4718,'Тайюань','Taiyuan','','China',156,'Asia/Shanghai'),(4749,'Урумчи','Urumqi','','China',156,'Asia/Urumqi'),(4395,'Фучжоу','Fuzhou','','China',156,'Asia/Shanghai'),(4393,'Фуян','Fuyang','','China',156,'Asia/Shanghai'),(4420,'Хайкоу','Haikou','','China',156,'Asia/Chongqing'),(4421,'Хайлар','Hailar','','China',156,'Asia/Shanghai'),(4427,'Хами','Hami','','China',156,'Asia/Urumqi'),(4429,'Ханчжоу','Hangzhou','','China',156,'Asia/Shanghai'),(4430,'Ханьчжун','Hanzhong','','China',156,'Asia/Chongqing'),(4437,'Ханьчжун','Hengchun','','China',156,'Asia/Taipei'),(4432,'Харбин','Harbin','','China',156,'Asia/Harbin'),(4453,'Хуадиан','Huadian','','China',156,'Asia/Harbin'),(4454,'Хуайхуа','Huaihua','','China',156,'Asia/Shanghai'),(4458,'Хуалянь','Hualian','','China',156,'Asia/Shanghai'),(4468,'Хума','Huma','','China',156,'Asia/Harbin'),(4446,'Хух-Хото','Hohhot','','China',156,'Asia/Chongqing'),(4435,'Хэфэй','Hefei','','China',156,'Asia/Shanghai'),(4483,'Цзинань','Jinan','','China',156,'Asia/Shanghai'),(4493,'Цзиньчжоу','Jinzhou','','China',156,'Asia/Shanghai'),(4497,'Цзиси','Jixi','','China',156,'Asia/Harbin'),(4637,'Циндао','Qingdao','','China',156,'Asia/Shanghai'),(4646,'Цитай','Qitai','','China',156,'Asia/Urumqi'),(4645,'Цицикар','Qiqihar','','China',156,'Asia/Harbin'),(4324,'Чандэ','Changde','','China',156,'Asia/Shanghai'),(4323,'Чанчунь','Changchun','','China',156,'Asia/Harbin'),(4326,'Чанша','Changsha','','China',156,'Asia/Shanghai'),(4329,'Чаоян','Chaoyang','','China',156,'Asia/Shanghai'),(4865,'Чжанцзякоу','Zhangjiakou','','China',156,'Asia/Shanghai'),(4870,'Чжанъе','Zhanyi','','China',156,'Asia/Chongqing'),(4869,'Чжаньцзян','Zhanjiang','','China',156,'Asia/Urumqi'),(4872,'Чжаотун','Zhaotong','','China',156,'Asia/Chongqing'),(4880,'Чжумадиан','Zhumadian','','China',156,'Asia/Shanghai'),(4874,'Чжэнчжоу','Zhengzhou','','China',156,'Asia/Shanghai'),(4339,'Чунцин','Chongqing','','China',156,'Asia/Chongqing'),(4343,'Чунцин','Chuxiong','','China',156,'Asia/Chongqing'),(4334,'Чэнду','Chengdu','','China',156,'Asia/Chongqing'),(4333,'Чэндэ','Chengde','','China',156,'Asia/Shanghai'),(4336,'Чэньчжоу','Chenzhou','','China',156,'Asia/Shanghai'),(4677,'Шаньвэй','Shanwei','','China',156,'Asia/Shanghai'),(4679,'Шаоу','Shaowu','','China',156,'Asia/Shanghai'),(4680,'Шаоян','Shaoyang','','China',156,'Asia/Shanghai'),(4686,'Шеньян','Sheyang','','China',156,'Asia/Shanghai'),(4689,'Шицзячжуан','Shijiazhuang','','China',156,'Asia/Shanghai'),(4685,'Шэньчжэнь','Shenzhen','','China',156,'Asia/Shanghai'),(4851,'Юэян','Yueyang','','China',156,'Asia/Shanghai'),(4820,'Яньцзи','Yanji','','China',156,'Asia/Harbin'),(4666,'Яркенд','Shache','','China',156,'Asia/Kashgar'),(4896,'Корого','Korhogo','','Cote d\'Ivoire',385,'Africa/Abidjan'),(55593,'Баямо','Bayamo','','Cuba',192,'America/Havana'),(55631,'Гавана','La Habana','','Cuba',192,'America/Havana'),(55599,'Камагуэй','Camaguey','','Cuba',192,'America/Havana'),(55632,'Лас-Тунас','Las Tunas','','Cuba',192,'America/Havana'),(55642,'Матансас','Matanzas','','Cuba',192,'America/Havana'),(55672,'Санта-Клара','Santa Clara','','Cuba',192,'America/Havana'),(55675,'Сантьяго-де-Куба','Santiago de Cuba','','Cuba',192,'America/Havana'),(55678,'Тринидад','Trinidad','','Cuba',192,'America/Havana'),(13795,'Баткен','Batken','','Kyrgyzstan',417,'Asia/Bishkek'),(7053,'Бишкек','Bishkek','','Kyrgyzstan',417,'Asia/Bishkek'),(7054,'Джалал-Абад','Jalal-Abad','','Kyrgyzstan',417,'Asia/Bishkek'),(13799,'Кант','Kant','','Kyrgyzstan',417,'Asia/Bishkek'),(13801,'Кара-Балта','Kara-Balta','','Kyrgyzstan',417,'Asia/Bishkek'),(13807,'Каракол','Karakol','','Kyrgyzstan',417,'Asia/Bishkek'),(7057,'Манас','Manas','','Kyrgyzstan',417,'Asia/Bishkek'),(7058,'Нарын','Naryn','','Kyrgyzstan',417,'Asia/Bishkek'),(7060,'Ош','Osh','','Kyrgyzstan',417,'Asia/Bishkek'),(7062,'Талас','Talas','','Kyrgyzstan',417,'Asia/Bishkek'),(7065,'Токмак','Tokmok','','Kyrgyzstan',417,'Asia/Bishkek'),(7064,'Тянь-Шань','Tian-Shan','','Kyrgyzstan',417,'Asia/Kashgar'),(7069,'Айнажи','Ainazi','','Latvia',428,'Europe/Riga'),(7070,'Алуксне','Aluksne','','Latvia',428,'Europe/Riga'),(7071,'Бауска','Bauska','','Latvia',428,'Europe/Riga'),(94545,'Валмиера','Valmiera','','Latvia',428,'Europe/Riga'),(7090,'Вентспилс','Ventspils','','Latvia',428,'Europe/Riga'),(7075,'Гулбене','Gulbene','','Latvia',428,'Europe/Riga'),(7072,'Дагда','Dagda','','Latvia',428,'Europe/Riga'),(7073,'Даугавпилс','Daugavpils','','Latvia',428,'Europe/Riga'),(7074,'Добеле','Dobele','','Latvia',428,'Europe/Riga'),(7076,'Елгава','Jelgava','','Latvia',428,'Europe/Riga'),(7078,'Лиепая','Liepaja','','Latvia',428,'Europe/Riga'),(7079,'Мерсрагс','Mersrags','','Latvia',428,'Europe/Riga'),(7082,'Резекне','Rezekne','','Latvia',428,'Europe/Riga'),(7083,'Рига','Riga','','Latvia',428,'Europe/Riga'),(7084,'Руйиена','Rujiena','','Latvia',428,'Europe/Riga'),(7085,'Салдус','Saldus','','Latvia',428,'Europe/Riga'),(7086,'Саулкрасты','Saulkrasti','','Latvia',428,'Europe/Riga'),(7089,'Стенде','Stende','','Latvia',428,'Europe/Riga'),(13444,'Юрмала','Jurmala','','Latvia',428,'Europe/Riga'),(7102,'','Qacha','','Lesotho',426,'Africa/Maseru'),(7100,'Масеру','Maseru','','Lesotho',426,'Africa/Maseru'),(7101,'Мокхотлонг','Mokhotlong','','Lesotho',426,'Africa/Maseru'),(13445,'Алитус','Alytus','','Lithuania',440,'Europe/Vilnius'),(13446,'Аникщяй','Anyksciai','','Lithuania',440,'Europe/Vilnius'),(7106,'Биржай','Birzai','','Lithuania',440,'Europe/Vilnius'),(7124,'Варена','Varena','','Lithuania',440,'Europe/Vilnius'),(13447,'Вилкавишкис','Vilkaviskis','','Lithuania',440,'Europe/Vilnius'),(7126,'Вильнюс','Vilnius','','Lithuania',440,'Europe/Vilnius'),(13448,'Висагинас','Visaginas','','Lithuania',440,'Europe/Vilnius'),(13449,'Гаргждай','Gargzdai','','Lithuania',440,'Europe/Vilnius'),(13450,'Друскининкай','Druskininkai','','Lithuania',440,'Europe/Vilnius'),(13451,'Зарасай','Zarasai','','Lithuania',440,'Europe/Vilnius'),(13452,'Игналина','Ignalina','','Lithuania',440,'Europe/Vilnius'),(13453,'Йонава','Jonava','','Lithuania',440,'Europe/Vilnius'),(13454,'Йонишкис','Joniskis','','Lithuania',440,'Europe/Vilnius'),(7109,'Каунас','Kaunas','','Lithuania',440,'Europe/Vilnius'),(13455,'Кедайняй','Kedainiai','','Lithuania',440,'Europe/Vilnius'),(13456,'Кельме','Kelme','','Lithuania',440,'Europe/Vilnius'),(7110,'Клайпеда','Klaipeda','','Lithuania',440,'Europe/Vilnius'),(13457,'Кретинга','Kretinga','','Lithuania',440,'Europe/Vilnius'),(13458,'Куршенай','Kursenai','','Lithuania',440,'Europe/Vilnius'),(7113,'Лаздияй','Lazdijai','','Lithuania',440,'Europe/Vilnius'),(13459,'Лентварис','Lentvaris','','Lithuania',440,'Europe/Vilnius'),(7114,'Мажейкяй','Mazeikiai','','Lithuania',440,'Europe/Vilnius'),(13460,'Мариямполе','Marijampole','','Lithuania',440,'Europe/Vilnius'),(95302,'Неменчине','Nemencine','','Lithuania',440,'Europe/Vilnius'),(7115,'Нида','Nida','','Lithuania',440,'Europe/Kaliningrad'),(7116,'Паланга','Palanga','','Lithuania',440,'Europe/Vilnius'),(7117,'Паневежис','Panevezys','','Lithuania',440,'Europe/Vilnius'),(13463,'Пасвалис','Pasvalys','','Lithuania',440,'Europe/Vilnius'),(13464,'Плунге','Plunge','','Lithuania',440,'Europe/Vilnius'),(7118,'Расейняй','Raseiniai','','Lithuania',440,'Europe/Vilnius'),(13466,'Рокишкис','Rokiskis','','Lithuania',440,'Europe/Vilnius'),(13467,'Скуодас','Skuodas','','Lithuania',440,'Europe/Vilnius'),(13468,'Таураге','Taurage','','Lithuania',440,'Europe/Vilnius'),(7121,'Тельшяй','Telsiai','','Lithuania',440,'Europe/Vilnius'),(13469,'Тракай','Trakai','','Lithuania',440,'Europe/Vilnius'),(7122,'Укмерге','Ukmerge','','Lithuania',440,'Europe/Vilnius'),(7123,'Утена','Utena','','Lithuania',440,'Europe/Vilnius'),(13470,'Шакяй','Sakiai','','Lithuania',440,'Europe/Vilnius'),(13472,'Шилале','Silale','','Lithuania',440,'Europe/Vilnius'),(7120,'Шилуте','Silute','','Lithuania',440,'Europe/Vilnius'),(13473,'Ширвинтос','Sirvintos','','Lithuania',440,'Europe/Vilnius'),(7119,'Шяуляй','Siauliai','','Lithuania',440,'Europe/Vilnius'),(13474,'Электренай','Elektrenai','','Lithuania',440,'Europe/Vilnius'),(13475,'Юрбаркас','Jurbarkas','','Lithuania',440,'Europe/Vilnius'),(7228,'Вакоас','Vacoas','','Mauritius',480,'Indian/Mauritius'),(7226,'Остров Родригес','Rodrigues','','Mauritius',480,'Indian/Mauritius'),(7210,'Алег','Aleg','','Mauritania',478,'Africa/Nouakchott'),(7211,'Атар','Atar','','Mauritania',478,'Africa/Nouakchott'),(7215,'Каэди','Kaedi','','Mauritania',478,'Africa/Nouakchott'),(7216,'Киффа','Kiffa','','Mauritania',478,'Africa/Nouakchott'),(7217,'Нема','Nema','','Mauritania',478,'Africa/Nouakchott'),(7218,'Нуадибу','Nouadhibou','','Mauritania',478,'Africa/Nouakchott'),(7219,'Нуакшот','Nouakchott','','Mauritania',478,'Africa/Nouakchott'),(7220,'Россо','Rosso','','Mauritania',478,'Africa/Nouakchott'),(7137,'Антананариву','Antananarivo','','Madagascar',450,'Indian/Antananarivo'),(7138,'Анцирабе','Antsirabe','','Madagascar',450,'Indian/Antananarivo'),(7154,'Санта-Мария','Sainte-Marie Aerodrome','','Madagascar',450,'Indian/Antananarivo'),(7157,'Тулиара','Tulear','','Madagascar',450,'Indian/Antananarivo'),(7145,'Фианаранцуа','Fianarantsoa','','Madagascar',450,'Indian/Antananarivo'),(7169,'Лилонгве','Lilongwe (International Airport)','','Malawi',454,'Africa/Blantyre'),(7176,'Мзузу','Mzuzu','','Malawi',454,'Africa/Blantyre'),(7181,'Салима','Salima','','Malawi',454,'Africa/Blantyre'),(102,'Куала-Лумпур','Kuala Lumpur','','Malaysia',458,'Asia/Kuala_Lumpur'),(103,'Лангкави','Langkawi','','Malaysia',458,'Asia/Kuala_Lumpur'),(7187,'Бамако','Bamako','','Mali',466,'Africa/Bamako'),(7190,'Гао','Gao','','Mali',466,'Africa/Bamako'),(7192,'Каес','Kayes','','Mali',466,'Africa/Bamako'),(7195,'Кита','Kita','','Mali',466,'Africa/Bamako'),(7196,'Кутиала','Koutiala','','Mali',466,'Africa/Bamako'),(7198,'Мопти','Mopti','','Mali',466,'Africa/Bamako'),(7199,'Нара','Nara','','Mali',466,'Africa/Bamako'),(7201,'Сан','San','','Mali',466,'Africa/Bamako'),(7202,'Сегу','Segou','','Mali',466,'Africa/Bamako'),(7203,'Сикассо','Sikasso','','Mali',466,'Africa/Bamako'),(7204,'Тессалит','Tessalit','','Mali',466,'Africa/Bamako'),(7205,'Томбукту','Tombouctou','','Mali',466,'Africa/Bamako'),(7183,'Ган','Gan','','Maldives',462,'Indian/Maldives'),(7186,'Мале','Male','','Maldives',462,'Indian/Maldives'),(7268,'Агадир','Agadir','','Morocco',504,'Africa/Casablanca'),(7270,'Бени-Меллаль','Beni-Mellal','','Morocco',504,'Africa/Casablanca'),(7290,'Варзазат','Ouarzazate','','Morocco',504,'Africa/Casablanca'),(7272,'Касабланка','Casablanca','','Morocco',504,'Africa/Casablanca'),(7280,'Касба-Табла','Kasba-Tadla','','Morocco',504,'Africa/Casablanca'),(7281,'Кенитра','Kenitra','','Morocco',504,'Africa/Casablanca'),(7283,'Лараче','Larache','','Morocco',504,'Africa/Casablanca'),(7284,'Марракеш','Marrakech','','Morocco',504,'Africa/Casablanca'),(7285,'Мекнес','Meknes','','Morocco',504,'Africa/Casablanca'),(7286,'Мидельт','Midelt','','Morocco',504,'Africa/Casablanca'),(7287,'Мохаммедия','Mohammedia','','Morocco',504,'Africa/Casablanca'),(7288,'Надор','Nador','','Morocco',504,'Africa/Casablanca'),(7289,'Ноуассер','Nouasseur','','Morocco',504,'Africa/Casablanca'),(7292,'Рабат','Rabat','','Morocco',504,'Africa/Casablanca'),(7293,'Сафи','Safi','','Morocco',504,'Africa/Casablanca'),(7294,'Сиди Инфи','Sidi Ifni','','Morocco',504,'Africa/Casablanca'),(7299,'Таза','Taza','','Morocco',504,'Africa/Casablanca'),(7297,'Танжер','Tanger Aerodrome','','Morocco',504,'Africa/Casablanca'),(7300,'Тетуан','Tetuan','','Morocco',504,'Africa/Casablanca'),(7291,'Уджда','Oujda','','Morocco',504,'Africa/Casablanca'),(7277,'Фес','Fes','','Morocco',504,'Africa/Casablanca'),(7274,'Эль-Джадида','El Jadida','','Morocco',504,'Africa/Casablanca'),(7269,'Эль-Хосейма','Al Hoceima','','Morocco',504,'Africa/Casablanca'),(7275,'Эррахидия','Errachidia','','Morocco',504,'Africa/Casablanca'),(7276,'Эс-Сувейра','Essaouira','','Morocco',504,'Africa/Casablanca'),(7303,'Ангоше','Angoche','','Mozambique',508,'Africa/Maputo'),(7304,'Бейра','Beira','','Mozambique',508,'Africa/Maputo'),(7305,'Кая','Caia','','Mozambique',508,'Africa/Maputo'),(7320,'Келимане','Quelimane','','Mozambique',508,'Africa/Maputo'),(7311,'Лишинга','Lichinga','','Mozambique',508,'Africa/Maputo'),(7313,'Мапуту','Maputo','','Mozambique',508,'Africa/Maputo'),(7317,'Нампула','Nampula','','Mozambique',508,'Africa/Maputo'),(7319,'Пемба','Pemba','','Mozambique',508,'Africa/Maputo'),(7321,'Тете','Tete','','Mozambique',508,'Africa/Maputo'),(7324,'Шаи-Шаи','Xai Xai','','Mozambique',508,'Africa/Maputo'),(7308,'Шимойо','Chimoio','','Mozambique',508,'Africa/Maputo'),(267,'Бельцы','B?l?i','','Moldova',498,'Europe/Chisinau'),(269,'Дубоссары','Dub?sari','','Moldova',498,''),(53197,'Каменка','Camenca','','Moldova',498,'Europe/Chisinau'),(170,'Кишинев','Chi?in?u','','Moldova',498,''),(95734,'Кишинёв','Kishinev','','Moldova',498,'Europe/Chisinau'),(270,'Комрат','Comrat','','Moldova',498,'Europe/Chisinau'),(2646,'Рыбница','R?bni?a','','Moldova',498,''),(173,'Тирасполь','Tiraspol','','Moldova',498,'Europe/Chisinau'),(272,'Чадыр-Лунга','Cead?r-Lunga','','Moldova',498,''),(7229,'Алтай','Altai','','Mongolia',496,'Asia/Ulaanbaatar'),(7230,'Арвайхээр','Arvaiheer','','Mongolia',496,'Asia/Ulaanbaatar'),(7231,'Байтаг','Baitag','','Mongolia',496,'Asia/Urumqi'),(7234,'Бариинтуруун','Baruunturuun','','Mongolia',496,'Asia/Ulaanbaatar'),(7232,'Баруун-Урт','Baruun-Urt','','Mongolia',496,'Asia/Choibalsan'),(7233,'Баруункхараа','Baruunkharaa','','Mongolia',496,''),(7237,'Баяеделгер','Bayandelger','','Mongolia',496,'Asia/Choibalsan'),(7235,'Баян-Ову','Bayan-Ovoo','','Mongolia',496,'Asia/Ulaanbaatar'),(7236,'Баянбулак','Bayanbulag','','Mongolia',496,'Asia/Ulaanbaatar'),(7238,'Баянхонгор','Bayanhongor','','Mongolia',496,'Asia/Ulaanbaatar'),(7239,'Булган','Bulgan','','Mongolia',496,'Asia/Ulaanbaatar'),(7244,'Гаиуут','Gaiuut','','Mongolia',496,''),(7242,'Даланзадгад','Dalanzadgad','','Mongolia',496,'Asia/Ulaanbaatar'),(7243,'Дашбалбар','Dashbalbar','','Mongolia',496,'Asia/Choibalsan'),(7267,'Замун-Ууд','Zamyn-Uud','','Mongolia',496,'Asia/Harbin'),(7250,'Маанти','Maanti','','Mongolia',496,''),(7251,'Мандалгови','Mandalgovi','','Mongolia',496,'Asia/Ulaanbaatar'),(7252,'Матад','Matad','','Mongolia',496,'Asia/Choibalsan'),(7253,'Мурен','Muren','','Mongolia',496,'Asia/Ulaanbaatar'),(7254,'Омно-Гоби','Omno-Gobi','','Mongolia',496,'Asia/Ulaanbaatar'),(7255,'Ринчинлхумбе','Rinchinlhumbe','','Mongolia',496,'Asia/Ulaanbaatar'),(7256,'Сайкхан-Ову','Saikhan-Ovoo','','Mongolia',496,'Asia/Ulaanbaatar'),(7258,'Тариалан','Tarialan','','Mongolia',496,'Asia/Ulaanbaatar'),(7259,'Тосонтсенгел','Tosontsengel','','Mongolia',496,'Asia/Ulaanbaatar'),(7260,'Тсетсерлег','Tsetserleg','','Mongolia',496,'Asia/Ulaanbaatar'),(7261,'Тсот-Ову','Tsogt-Ovoo','','Mongolia',496,'Asia/Ulaanbaatar'),(7264,'Улаангом','Ulaan-Gom','','Mongolia',496,'Asia/Ulaanbaatar'),(7263,'Улан-Батор','Ulaan-Baator','','Mongolia',496,'Asia/Ulaanbaatar'),(7265,'Улястай','Uliastai','','Mongolia',496,'Asia/Ulaanbaatar'),(7266,'Ундеркхаан','Underkhaan','','Mongolia',496,'Asia/Ulaanbaatar'),(7249,'Халхин-Гол','Khalkh-Gol','','Mongolia',496,''),(7245,'Хатгал','Hatgal','','Mongolia',496,'Asia/Ulaanbaatar'),(7246,'Ховд','Hovd','','Mongolia',496,'Asia/Ulaanbaatar'),(7241,'Хор','Choir','','Mongolia',496,'Asia/Ulaanbaatar'),(7247,'Худжирт','Hujirt','','Mongolia',496,'Asia/Ulaanbaatar'),(7248,'Хутаг','Hutag','','Mongolia',496,'Asia/Ulaanbaatar'),(7240,'Чойбалсан','Choibalsan','','Mongolia',496,'Asia/Choibalsan'),(7262,'Юги','Uigi','','Mongolia',496,''),(7326,'Баго','Bago','','Myanmar',104,'Asia/Rangoon'),(7327,'Бамо','Bhamo','','Myanmar',104,'Asia/Rangoon'),(7360,'Бассейн','Pathein','','Myanmar',104,'Asia/Rangoon'),(7331,'Гангав','Gangaw','','Myanmar',104,'Asia/Rangoon'),(7338,'Калева','Kalewa','','Myanmar',104,'Asia/Rangoon'),(7345,'Мандалай','Mandalay','','Myanmar',104,'Asia/Rangoon'),(7357,'Мьичина','Myitkyina','','Myanmar',104,'Asia/Rangoon'),(7365,'Пьинмана','Pyinmana','','Myanmar',104,'Asia/Rangoon'),(7369,'Ситуэ','Sittwe','','Myanmar',104,'Asia/Rangoon'),(7372,'Татон','Thaton','','Myanmar',104,'Asia/Rangoon'),(7373,'Таунгу','Toungoo','','Myanmar',104,'Asia/Rangoon'),(7370,'Таунджи','Taunggyi','','Myanmar',104,'Asia/Rangoon'),(7332,'Хензада','Henzada','','Myanmar',104,'Asia/Rangoon'),(7376,'Янгон','Yangon','','Myanmar',104,'Asia/Rangoon'),(7444,'Виндхук','Windhoek','','Namibia',516,'Africa/Windhoek'),(7431,'Гобабис','Gobabis','','Namibia',516,'Africa/Windhoek'),(7435,'Китмансхуп','Keetmanshoop','','Namibia',516,'Africa/Windhoek'),(7440,'Рунду','Rundu','','Namibia',516,'Africa/Windhoek'),(7442,'Уис','Uis','','Namibia',516,'Africa/Windhoek'),(7446,'Биратнагар','Biratnagar Airport','','Nepal',524,'Asia/Kathmandu'),(7450,'Катманду','Kathmandu Airport','','Nepal',524,'Asia/Kathmandu'),(104602,'Катманду','Kathmandu','','Nepal',524,'Asia/Kathmandu'),(7452,'Покхара','Pokhara Airport','','Nepal',524,'Asia/Kathmandu'),(7507,'','Birni-N','','Niger',562,'Africa/Niamey'),(7515,'','N','','Niger',562,'Africa/Niamey'),(7505,'Агадес','Agadez','','Niger',562,'Africa/Niamey'),(7506,'Бильма','Bilma','','Niger',562,'Africa/Niamey'),(7508,'Диффа','Diffa','','Niger',562,'Africa/Niamey'),(7518,'Зиндер','Zinder','','Niger',562,'Africa/Niamey'),(7511,'Магария','Magaria','','Niger',562,'Africa/Niamey'),(7512,'Маине-Сороа','Maine-Soroa','','Niger',562,'Africa/Niamey'),(7513,'Маради','Maradi','','Niger',562,'Africa/Niamey'),(7514,'Ниамей','Niamey','','Niger',562,'Africa/Niamey'),(7516,'Тахуа','Tahoua','','Niger',562,'Africa/Niamey'),(7517,'Тиллаберу','Tillabery','','Niger',562,'Africa/Niamey'),(7521,'Абуджа','Abuja','','Nigeria',566,'Africa/Lagos'),(7522,'Баучи','Bauchi','','Nigeria',566,'Africa/Lagos'),(7519,'Бенин','Benin','','Nigeria',566,'Africa/Lagos'),(7523,'Бида','Bida','','Nigeria',566,'Africa/Lagos'),(7547,'Варри','Warri','','Nigeria',566,'Africa/Lagos'),(7526,'Гусау','Gusau','','Nigeria',566,'Africa/Lagos'),(7531,'Джос','Jos','','Nigeria',566,'Africa/Lagos'),(7550,'Зариа','Zaria','','Nigeria',566,'Africa/Lagos'),(7527,'Ибадан','Ibadan','','Nigeria',566,'Africa/Lagos'),(7528,'Иби','Ibi','','Nigeria',566,'Africa/Lagos'),(7530,'Илорин','Ilorin','','Nigeria',566,'Africa/Lagos'),(7532,'Кадуна','Kaduna','','Nigeria',566,'Africa/Lagos'),(7524,'Калабар','Calabar','','Nigeria',566,'Africa/Lagos'),(7533,'Кано','Kano','','Nigeria',566,'Africa/Lagos'),(7534,'Кацина','Katsina','','Nigeria',566,'Africa/Lagos'),(7520,'Лагос','Lagos','','Nigeria',566,'Africa/Lagos'),(7536,'Майдугури','Maiduguri','','Nigeria',566,'Africa/Lagos'),(7537,'Макурди','Makurdi','','Nigeria',566,'Africa/Lagos'),(7538,'Минна','Minna','','Nigeria',566,'Africa/Lagos'),(7541,'Ондо','Ondo','','Nigeria',566,'Africa/Lagos'),(7542,'Онича','Onitsha','','Nigeria',566,'Africa/Lagos'),(7543,'Ошогбо','Oshogbo','','Nigeria',566,'Africa/Lagos'),(7544,'Порт-Харкорт','Port Harcourt','','Nigeria',566,'Africa/Lagos'),(7546,'Сокото','Sokoto','','Nigeria',566,'Africa/Lagos'),(7525,'Энугу','Enugu','','Nigeria',566,'Africa/Lagos'),(97036,'Арендал','Arendal','','Norway',578,'Europe/Oslo'),(7558,'Банак','Banak','','Norway',578,'Europe/Oslo'),(7559,'Бардуфосс','Bardufoss','','Norway',578,'Europe/Oslo'),(7551,'Берген','Bergen','','Norway',578,'Europe/Oslo'),(97104,'Бодо','Bodo','','Norway',578,'Europe/Oslo'),(7715,'Вадсё','Vadso','','Norway',578,'Europe/Oslo'),(7716,'Вангснес','Vangsnes','','Norway',578,'Europe/Oslo'),(7723,'Восс','Voss','','Norway',578,'Europe/Oslo'),(97170,'Драммен','Drammen','','Norway',578,'Europe/Oslo'),(7603,'Карасжок','Karasjok','','Norway',578,'Europe/Oslo'),(7608,'Кракенес','Krakenes','','Norway',578,'Europe/Oslo'),(7552,'Кристиансанн','Kristiansand','','Norway',578,'Europe/Oslo'),(7614,'Лекнес','Leknes','','Norway',578,'Europe/Oslo'),(7616,'Лиллехаммер','Lillehammer','','Norway',578,'Europe/Oslo'),(97706,'Мо','Mo','','Norway',578,'Europe/Oslo'),(7553,'Нарвик','Narvik','','Norway',578,'Europe/Oslo'),(7648,'Оксой Фюр','Oksoy Fyr','','Norway',578,'Europe/Oslo'),(7651,'Оппдал','Oppdal','','Norway',578,'Europe/Oslo'),(7652,'Орланд Ли','Orland Iii','','Norway',578,'Europe/Oslo'),(7554,'Осло','Oslo','','Norway',578,'Europe/Oslo'),(7660,'Рёрус','Roros','','Norway',578,'Europe/Oslo'),(7669,'Сауда','Sauda','','Norway',578,'Europe/Oslo'),(7696,'Свиной Фюр','Svinoy Fyr','','Norway',578,''),(7685,'Ставангер','Stavanger','','Norway',578,'Europe/Oslo'),(7690,'Струн','Stryn','','Norway',578,'Europe/Oslo'),(7691,'Сула','Sula','','Norway',578,'Europe/Oslo'),(7698,'Тафжорд','Tafjord','','Norway',578,'Europe/Oslo'),(7708,'Трисиль','Trysil','','Norway',578,'Europe/Oslo'),(7706,'Тромсё','Tromso','','Norway',578,'Europe/Oslo'),(7707,'Тронхейм','Trondheim','','Norway',578,'Europe/Oslo'),(7713,'Утсира Фюр','Utsira Fyr','','Norway',578,'Europe/Oslo'),(7575,'Фагернес','Fagernes','','Norway',578,'Europe/Oslo'),(7581,'Флоро','Floro','','Norway',578,'Europe/Oslo'),(7584,'Фортун','Fortun','','Norway',578,'Europe/Oslo'),(97308,'Фредрикстад','Fredrikstad','','Norway',578,'Europe/Oslo'),(97442,'Халден','Halden','','Norway',578,'Europe/Oslo'),(7590,'Хаммерфест','Hammerfest','','Norway',578,'Europe/Oslo'),(98002,'Шиен','Skien','','Norway',578,'Europe/Oslo'),(7573,'Эвенес','Evenes','','Norway',578,'Europe/Oslo'),(7571,'Эдж','Edgeoya','','Norway',578,'Europe/Oslo'),(104,'Абу-Даби','Abu Dhabi','','United Arab Emirates',784,'Asia/Dubai'),(55683,'Аджман','Ajman','','United Arab Emirates',784,'Asia/Dubai'),(105,'Дубай','Dubai','','United Arab Emirates',784,'Asia/Dubai'),(106601,'Рас-эль-Хайма','Ras Al Khaimah','','United Arab Emirates',784,'Asia/Dubai'),(55688,'Умм-Аль-Кайвайн','Umm al Qaywayn','','United Arab Emirates',784,'Asia/Dubai'),(154,'Фуджейра','Fujairah','','United Arab Emirates',784,'Asia/Dubai'),(106,'Шарджа','Sharjah','','United Arab Emirates',784,'Asia/Dubai'),(7726,'Бурайми','Buraimi','','Oman',512,'Asia/Muscat'),(7728,'Кхссаб','Khassab','','Oman',512,'Asia/Muscat'),(7729,'Мармул','Marmul','','Oman',512,'Asia/Muscat'),(7730,'Масираз','Masirah','','Oman',512,'Asia/Muscat'),(7733,'Саик','Saiq','','Oman',512,'Asia/Muscat'),(7734,'Салала','Salalah','','Oman',512,'Asia/Muscat'),(7736,'Сохар Мажис','Sohar Majis','','Oman',512,''),(7737,'Сур','Sur','','Oman',512,'Asia/Muscat'),(7738,'Тхимрайт','Thumrait','','Oman',512,'Asia/Muscat'),(7727,'Фахуд','Fahud','','Oman',512,'Asia/Muscat'),(7745,'Бахавалнагар','Bahawalnagar','','Pakistan',586,'Asia/Karachi'),(7746,'Бахавалпур','Bahawalpur','','Pakistan',586,'Asia/Karachi'),(7754,'Дера-Газихан','Dera Ghazi Khan','','Pakistan',586,'Asia/Karachi'),(7755,'Дера-Исмаилхан','Dera Ismail Khan','','Pakistan',586,'Asia/Karachi'),(7758,'Джейкобабад','Jacobabad','','Pakistan',586,'Asia/Karachi'),(7759,'Джелам','Jhelum','','Pakistan',586,'Asia/Karachi'),(7756,'Дир','Dir','','Pakistan',586,'Asia/Karachi'),(7740,'Исламабад','Islamabad','','Pakistan',586,'Asia/Karachi'),(7739,'Карачи','Karachi','','Pakistan',586,'Asia/Karachi'),(7743,'Кветта','Quetta','','Pakistan',586,'Asia/Karachi'),(7764,'Кохат','Kohat','','Pakistan',586,'Asia/Karachi'),(7742,'Лахор','Lahore','','Pakistan',586,'Asia/Karachi'),(7766,'Мултан','Multan','','Pakistan',586,'Asia/Karachi'),(7768,'Навабшах','Nawabshah','','Pakistan',586,'Asia/Karachi'),(7774,'Пешавар','Peshawar','','Pakistan',586,'Asia/Karachi'),(7778,'Саргода','Sargodha','','Pakistan',586,'Asia/Karachi'),(7780,'Сиби','Sibi','','Pakistan',586,'Asia/Karachi'),(7779,'Сиялкот','Sialkot','','Pakistan',586,'Asia/Karachi'),(7741,'Хайдарабад','Hyderabad','','Pakistan',586,'Asia/Karachi'),(15865,'Бартошице','Bartoszyce','','Poland',616,'Europe/Warsaw'),(2975,'Белз','Belsk','','Poland',616,'Europe/Warsaw'),(176,'Белосток','Bialystok','','Poland',616,'Europe/Warsaw'),(15873,'Белхатув','Belchatow','','Poland',616,'Europe/Warsaw'),(2596,'Бельско-Бяла','Bielsko-Biala','','Poland',616,'Europe/Warsaw'),(177,'Бжег','Brzeg','','Poland',616,'Europe/Warsaw'),(15891,'Билгорай','Bilgoraj','','Poland',616,'Europe/Warsaw'),(15907,'Бохня','Bochnia','','Poland',616,'Europe/Warsaw'),(2976,'Брвинув','Brwinow','','Poland',616,'Europe/Warsaw'),(15915,'Бродница','Brodnica','','Poland',616,'Europe/Warsaw'),(15923,'Быдгощ','Bydgoszcz','','Poland',616,'Europe/Warsaw'),(15927,'Бытом','Bytom','','Poland',616,'Europe/Warsaw'),(15939,'Бяла-Подляска','Biala Podlaska','','Poland',616,'Europe/Warsaw'),(16669,'Валбжих','Walbrzych','','Poland',616,'Europe/Warsaw'),(16671,'Валч','Walcz','','Poland',616,'Europe/Warsaw'),(16673,'Варка','Warka','','Poland',616,'Europe/Warsaw'),(227,'Варшава','Warsaw','','Poland',616,'Europe/Warsaw'),(2597,'Велюнь','Wielun','','Poland',616,'Europe/Warsaw'),(16691,'Вжесня','Wrzesnia','','Poland',616,'Europe/Warsaw'),(2598,'Влодава','Wlodawa','','Poland',616,'Europe/Warsaw'),(16705,'Влоцлавек','Wloclawek','','Poland',616,'Europe/Warsaw'),(16709,'Водзислав-Слёнски','Wodzislaw Slaski','','Poland',616,'Europe/Warsaw'),(16715,'Воломин','Wolomin','','Poland',616,'Europe/Warsaw'),(16717,'Волув','Wolow','','Poland',616,'Europe/Warsaw'),(16727,'Вонгровец','Wagrowiec','','Poland',616,'Europe/Warsaw'),(228,'Вроцлав','Wroclav','','Poland',616,'Europe/Warsaw'),(16739,'Вышкув','Wyszkow','','Poland',616,'Europe/Warsaw'),(182,'Гданьск','Gdansk','','Poland',616,'Europe/Warsaw'),(183,'Гданьск','Danzig','','Poland',616,'Europe/Warsaw'),(184,'Гдыня','Gdynia','','Poland',616,'Europe/Warsaw'),(16047,'Гижицко','Gizycko','','Poland',616,'Europe/Warsaw'),(2625,'Гливиц','glivich','','Poland',616,''),(16053,'Глогув','Glogow','','Poland',616,'Europe/Warsaw'),(16069,'Гнезно','Gniezno','','Poland',616,'Europe/Warsaw'),(187,'Гожув-Велькопольски','Gorzow Wlkp','','Poland',616,'Europe/Warsaw'),(202,'Гожув-Велькопольски','Gorzow Wielkopolski','','Poland',616,'Europe/Warsaw'),(185,'Голенюв','Goleniow','','Poland',616,'Europe/Warsaw'),(16077,'Горлице','Gorlice','','Poland',616,'Europe/Warsaw'),(16081,'Гостынин','Gostynin','','Poland',616,'Europe/Warsaw'),(16085,'Граево','Grajewo','','Poland',616,'Europe/Warsaw'),(16089,'Гродзиск-Мазовецки','Grodzisk Mazowiecki','','Poland',616,'Europe/Warsaw'),(16093,'Грудзёндз','Grudziadz','','Poland',616,'Europe/Warsaw'),(16099,'Грыфино','Gryfino','','Poland',616,'Europe/Warsaw'),(2977,'Демблин','Deblin','','Poland',616,'Europe/Warsaw'),(16017,'Дзялдово','Dzialdowo','','Poland',616,'Europe/Warsaw'),(2978,'Еленя-Гура','Jelenia Gora','','Poland',616,'Europe/Warsaw'),(16747,'Жары','Zary','','Poland',616,'Europe/Warsaw'),(13482,'Жешув','Rzeszow','','Poland',616,'Europe/Warsaw'),(2601,'Жешув-Есиока','rzeszow-jasion','','Poland',616,''),(16753,'Живец','Zywiec','','Poland',616,'Europe/Warsaw'),(16755,'Жирардув','Zyrardow','','Poland',616,'Europe/Warsaw'),(16761,'Жоры','Zory','','Poland',616,'Europe/Warsaw'),(229,'Забже','Zabrze','','Poland',616,'Europe/Warsaw'),(16771,'Заверце','Zawiercie','','Poland',616,'Europe/Warsaw'),(1236,'Закопане','Zakopane','','Poland',616,'Europe/Warsaw'),(16779,'Замбрув','Zambrow','','Poland',616,'Europe/Warsaw'),(230,'Замосць','Zamosc','','Poland',616,'Europe/Warsaw'),(16789,'Згеж','Zgierz','','Poland',616,'Europe/Warsaw'),(16797,'Здуньска-Воля','Zdunska Wola','','Poland',616,'Europe/Warsaw'),(231,'Зелёна-Гура','Zielona Gora','','Poland',616,'Europe/Warsaw'),(16119,'Илава','Ilawa','','Poland',616,'Europe/Warsaw'),(16127,'Иновроцлав','Inowroclaw','','Poland',616,'Europe/Warsaw'),(189,'Калиш','Kalisz','','Poland',616,'Europe/Warsaw'),(16167,'Каменна-Гура','Kamienna Gora','','Poland',616,'Europe/Warsaw'),(190,'Катовице','Katowice','','Poland',616,'Europe/Warsaw'),(16179,'Квидзын','Kwidzyn','','Poland',616,'Europe/Warsaw'),(192,'Кельце','Kielce','','Poland',616,'Europe/Warsaw'),(16183,'Кендзежин-Козле','Kedzierzyn-Kozle','','Poland',616,'Europe/Warsaw'),(191,'Кентшин','Ketrzyn','','Poland',616,'Europe/Warsaw'),(193,'Клодзко','Klodzko','','Poland',616,'Europe/Warsaw'),(16191,'Ключборк','Kluczbork','','Poland',616,'Europe/Warsaw'),(2603,'Козенице','Kozienice','','Poland',616,'Europe/Warsaw'),(2604,'Коло','Kolo','','Poland',616,'Europe/Warsaw'),(194,'Колобжег','Kolobrzeg','','Poland',616,'Europe/Warsaw'),(16209,'Конин','Konin','','Poland',616,'Europe/Warsaw'),(16215,'Коньске','Konskie','','Poland',616,'Europe/Warsaw'),(195,'Кошалин','Koszalin','','Poland',616,'Europe/Warsaw'),(196,'Краков','Krakow','','Poland',616,'Europe/Warsaw'),(16233,'Красник','Krasnik','','Poland',616,'Europe/Warsaw'),(16237,'Красныстав','Krasnystaw','','Poland',616,'Europe/Warsaw'),(16243,'Кросно','Krosno','','Poland',616,'Europe/Warsaw'),(16247,'Кротошин','Krotoszyn','','Poland',616,'Europe/Warsaw'),(16259,'Кутно','Kutno','','Poland',616,'Europe/Warsaw'),(197,'Леба','Leba','','Poland',616,'Europe/Warsaw'),(2981,'Легионово','Legionowo','','Poland',616,'Europe/Warsaw'),(198,'Легница','Legnica','','Poland',616,'Europe/Warsaw'),(2605,'Лемборк','Lebork','','Poland',616,'Europe/Warsaw'),(2606,'Леско','Lesko','','Poland',616,'Europe/Warsaw'),(2983,'Лешно','Leszno','','Poland',616,'Europe/Warsaw'),(16297,'Лович','Lowicz','','Poland',616,'Europe/Warsaw'),(199,'Лодзь','Lodz','','Poland',616,'Europe/Warsaw'),(16299,'Ломжа','Lomza','','Poland',616,'Europe/Warsaw'),(16305,'Лукув','Lukow','','Poland',616,'Europe/Warsaw'),(16313,'Любань','Luban','','Poland',616,'Europe/Warsaw'),(16319,'Любин','Lubin','','Poland',616,'Europe/Warsaw'),(200,'Люблин','Lublin','','Poland',616,'Europe/Warsaw'),(201,'Люблин Радавец','Lublin Radawiec','','Poland',616,'Europe/Warsaw'),(16321,'Люблинец','Lubliniec','','Poland',616,'Europe/Warsaw'),(16333,'Мальборк','Malbork','','Poland',616,'Europe/Warsaw'),(16335,'Марки','Marki','','Poland',616,'Europe/Warsaw'),(16337,'Мелец','Mielec','','Poland',616,'Europe/Warsaw'),(2608,'Миколайки','Mikolajki','','Poland',616,'Europe/Warsaw'),(16349,'Миколув','Mikolow','','Poland',616,'Europe/Warsaw'),(16355,'Миньск-Мазовецки','Minsk Mazowiecki','','Poland',616,'Europe/Warsaw'),(204,'Млава','Mlawa','','Poland',616,'Europe/Warsaw'),(16367,'Мронгово','Mragowo','','Poland',616,'Europe/Warsaw'),(16379,'Мышкув','Myszkow','','Poland',616,'Europe/Warsaw'),(16403,'Нова-Руда','Nowa Ruda','','Poland',616,'Europe/Warsaw'),(16405,'Нова-Суль','Nowa Sol','','Poland',616,'Europe/Warsaw'),(16415,'Новогруд','Nowogrod','','Poland',616,'Europe/Warsaw'),(2984,'Новы-Сонч','Nowy Sacz','','Poland',616,'Europe/Warsaw'),(16427,'Новы-Тарг','Nowy Targ','','Poland',616,'Europe/Warsaw'),(16429,'Ныса','Nysa','','Poland',616,'Europe/Warsaw'),(16447,'Озоркув','Ozorkow','','Poland',616,'Europe/Warsaw'),(16449,'Олава','Olawa','','Poland',616,'Europe/Warsaw'),(205,'Олесница','Olesnica','','Poland',616,'Europe/Warsaw'),(16455,'Олькуш','Olkusz','','Poland',616,'Europe/Warsaw'),(2610,'Ольштын','Olsztyn','','Poland',616,'Europe/Warsaw'),(2611,'Ополе','Opole','','Poland',616,'Europe/Warsaw'),(16465,'Опочно','Opoczno','','Poland',616,'Europe/Warsaw'),(16469,'Освенцим','Oswiecim','','Poland',616,'Europe/Warsaw'),(16471,'Островец-Свентокшиски','Ostrowiec Swietokrzyski','','Poland',616,'Europe/Warsaw'),(2612,'Остроленка','Ostroleka','','Poland',616,'Europe/Warsaw'),(16473,'Острув-Велькопольски','Ostrow Wielkopolski','','Poland',616,'Europe/Warsaw'),(16475,'Острув-Мазовецка','Ostrow Mazowiecka','','Poland',616,'Europe/Warsaw'),(206,'Отвоцк','Otwock','','Poland',616,'Europe/Warsaw'),(16483,'Пабьянице','Pabianice','','Poland',616,'Europe/Warsaw'),(16493,'Пекары-Слёнске','Piekary Slaskie','','Poland',616,'Europe/Warsaw'),(16505,'Пёнки','Pionki','','Poland',616,'Europe/Warsaw'),(212,'Перемышль','Przemysl','','Poland',616,'Europe/Warsaw'),(16507,'Пётркув-Трыбунальски','Piotrkow Trybunalski','','Poland',616,'Europe/Warsaw'),(2613,'Пила','Pila','','Poland',616,'Europe/Warsaw'),(207,'Плоцк','Plock','','Poland',616,'Europe/Warsaw'),(210,'Познань','Poznan','','Poland',616,'Europe/Warsaw'),(208,'Полице','Police','','Poland',616,'America/Toronto'),(16539,'Прудник','Prudnik','','Poland',616,'Europe/Warsaw'),(211,'Прушкув','Pruszkow','','Poland',616,'Europe/Warsaw'),(2985,'Пулавы','Pulawy','','Poland',616,'Europe/Warsaw'),(16561,'Пщина','Pszczyna','','Poland',616,'Europe/Warsaw'),(16567,'Пясечно','Piaseczno','','Poland',616,'Europe/Warsaw'),(2626,'Радом','Radom','','Poland',616,'Europe/Warsaw'),(16591,'Радомско','Radomsko','','Poland',616,'Europe/Warsaw'),(2614,'Рацибуж','Raciborz','','Poland',616,'Europe/Warsaw'),(16593,'Реда','Reda','','Poland',616,'Europe/Warsaw'),(2615,'Реско','resko','','Poland',616,'Europe/Warsaw'),(213,'Рыбник','Rybnik','','Poland',616,'Europe/Warsaw'),(16607,'Рыдултовы','Rydultowy','','Poland',616,'Europe/Warsaw'),(2616,'Сандомир','sandomierz','','Poland',616,'Europe/Warsaw'),(98207,'Свидница','Swidnica','','Poland',616,'Europe/Warsaw'),(222,'Свиноуйсьце','Swinoujscie','','Poland',616,'Europe/Warsaw'),(214,'Седльце','Siedlce','','Poland',616,'Europe/Warsaw'),(2618,'Слубице','slubice','','Poland',616,'Europe/Warsaw'),(215,'Снежка','Sniezka','','Poland',616,'Europe/Prague'),(216,'Сопот','Sopot','','Poland',616,'Europe/Warsaw'),(217,'Сосновец','Sosnowiec','','Poland',616,'Europe/Warsaw'),(98206,'Стараховице','Starachowice','','Poland',616,'Europe/Warsaw'),(220,'Старгард-Щециньски','Stargard Szczecinski','','Poland',616,'Europe/Warsaw'),(221,'Сувалки','Suwalki','','Poland',616,'Europe/Warsaw'),(2619,'Сулеюв','sulejow','','Poland',616,'Europe/Warsaw'),(16617,'Тарнобжег','Tarnobrzeg','','Poland',616,'Europe/Warsaw'),(16619,'Тарновске-Гуры','Tarnowskie Gory','','Poland',616,'Europe/Warsaw'),(224,'Тарнув','Tarnow','','Poland',616,'Europe/Warsaw'),(2620,'Тересполь','Terespol','','Poland',616,'Europe/Warsaw'),(16629,'Томашув-Мазовецки','Tomaszow Mazowiecki','','Poland',616,'Europe/Warsaw'),(225,'Торунь','Torun','','Poland',616,'Europe/Warsaw'),(16633,'Турек','Turek','','Poland',616,'Europe/Warsaw'),(16641,'Тчев','Tczew','','Poland',616,'Europe/Warsaw'),(226,'Тыхы','Tychy','','Poland',616,'Europe/Warsaw'),(2621,'Устка','Ustka','','Poland',616,'Europe/Warsaw'),(16113,'Хайнувка','Hajnowka','','Poland',616,'Europe/Warsaw'),(15945,'Хелм','Chelm','','Poland',616,'Europe/Warsaw'),(188,'Хель','Hel','','Poland',616,'Europe/Warsaw'),(15955,'Хмельник','Chmielnik','','Poland',616,'Europe/Warsaw'),(15959,'Хожув','Chorzow','','Poland',616,'Europe/Warsaw'),(178,'Хойнице','Chojnice','','Poland',616,'Europe/Warsaw'),(15971,'Хшанув','Chrzanow','','Poland',616,'Europe/Warsaw'),(15977,'Цеханув','Ciechanow','','Poland',616,'Europe/Warsaw'),(15981,'Цешин','Cieszyn','','Poland',616,'Europe/Warsaw'),(179,'Ченстохова','Czestochowa','','Poland',616,'Europe/Warsaw'),(2627,'Шклярска Поремба','Shklierska Poremba','','Poland',616,''),(223,'Щецин','Szczecin','','Poland',616,'Europe/Warsaw'),(2624,'Щецинек','szczecinek','','Poland',616,'Europe/Warsaw'),(16041,'Элк','Elk','','Poland',616,'Europe/Warsaw'),(181,'Эльблонг','Elblag','','Poland',616,'Europe/Warsaw'),(16139,'Явожно','Jaworzno','','Poland',616,'Europe/Warsaw'),(16141,'Явор','Jawor','','Poland',616,'Europe/Warsaw'),(16149,'Ярослав','Jaroslaw','','Poland',616,'Europe/Warsaw'),(16151,'Яроцин','Jarocin','','Poland',616,'Europe/Warsaw'),(16153,'Ясло','Jaslo','','Poland',616,'Europe/Warsaw'),(16159,'Ястшембе-Здруй','Jastrzebie Zdroj','','Poland',616,'Europe/Warsaw'),(7788,'Алверка-ду-Рибатежу','Alverca','','Portugal',620,'Europe/Lisbon'),(97567,'Алмада','Almada','','Portugal',620,'Europe/Lisbon'),(97573,'Амадора','Amadora','','Portugal',620,'Europe/Lisbon'),(7790,'Беджа','Beja','','Portugal',620,'Europe/Lisbon'),(97651,'Брага','Braga','','Portugal',620,'Europe/Lisbon'),(7791,'Браганса','Braganca','','Portugal',620,'Europe/Lisbon'),(98691,'Вендаш-Новаш','Vendas Novas','','Portugal',620,'Europe/Lisbon'),(7813,'Визеу','Viseu','','Portugal',620,'Europe/Lisbon'),(7812,'Вила Реаль','Vila Real','','Portugal',620,'Europe/Lisbon'),(98694,'Вила-Нова-де-Гайя','Vila Nova de Gaia','','Portugal',620,'Europe/Lisbon'),(97921,'Гондомар','Gondomar','','Portugal',620,'Europe/Lisbon'),(7792,'Кабу Карвуейру','Cabo Carvoeiro','','Portugal',620,'Europe/Lisbon'),(97755,'Кашкайш','Cascais','','Portugal',620,'Europe/Lisbon'),(7793,'Каштелу-Бранку','Castelo Branco','','Portugal',620,'Europe/Lisbon'),(7794,'Коимбра','Coimbra','','Portugal',620,'Europe/Lisbon'),(98136,'Лейрия','Leiria','','Portugal',620,'Europe/Lisbon'),(7785,'Лиссабон','Lisboa','','Portugal',620,'Europe/Lisbon'),(98138,'Лиссабон','Lisbon','','Portugal',620,'Europe/Lisbon'),(98208,'Матозиньюш','Matosinhos','','Portugal',620,'Europe/Lisbon'),(98210,'Мирандела','Mirandela','','Portugal',620,'Europe/Lisbon'),(7800,'Монтижу','Montijo','','Portugal',620,'Europe/Lisbon'),(98213,'Мора','Mora','','Portugal',620,'Europe/Lisbon'),(7802,'Овар','Ovar / Maceda','','Portugal',620,'Europe/Lisbon'),(98285,'Ольян','Olhao','','Portugal',620,'Europe/Lisbon'),(7786,'Понта-Делгада','Ponta Delgada','','Portugal',620,'Atlantic/Azores'),(7804,'Порталегре','Portalegre','','Portugal',620,'Europe/Lisbon'),(98350,'Портиман','Portimao','','Portugal',620,'Europe/Lisbon'),(7787,'Порту','Porto','','Portugal',620,'Europe/Lisbon'),(7805,'Порту-Санту','Porto Santo','','Portugal',620,'Atlantic/Azores'),(7806,'Сагрес','Sagres','','Portugal',620,'Europe/Lisbon'),(98560,'Сан-Висенте','Sao Vicente','','Portugal',620,'Atlantic/Madeira'),(98558,'Сан-Жуан-да-Мадейра','Sao Joao da Madeira','','Portugal',620,'Europe/Lisbon'),(7807,'Санта Мария Акорес','Santa Maria Acores','','Portugal',620,'Atlantic/Azores'),(98561,'Сезимбра','Sesimbra','','Portugal',620,'Europe/Lisbon'),(98562,'Сетубал','Setubal','','Portugal',620,'Europe/Lisbon'),(7809,'Синтра','Sintra / Granja','','Portugal',620,'Europe/Lisbon'),(98630,'Тавира','Tavira','','Portugal',620,'Europe/Lisbon'),(98631,'Томар','Tomar','','Portugal',620,'Europe/Lisbon'),(7782,'Фару','Faro','','Portugal',620,'Europe/Lisbon'),(97850,'Фафе','Fafe','','Portugal',620,'Europe/Lisbon'),(7797,'Флорес Акорес','Flores Acores','','Portugal',620,'Atlantic/Azores'),(7798,'Фуншал','Funchal','','Portugal',620,'Atlantic/Madeira'),(7783,'Хорта','Horta','','Portugal',620,'Atlantic/Azores'),(7796,'Эвора','Evora','','Portugal',620,'Europe/Lisbon'),(97843,'Эшторил','Estoril','','Portugal',620,'Europe/Lisbon'),(2413,'CERN','cern','','Russia',643,'Europe/Zurich'),(669,'ICA','ica','','Russia',643,'Europe/Moscow'),(9304,'ISA','Isa','','Russia',643,'America/New_York'),(795,'Kanon','kanon','','Russia',643,'Europe/Moscow'),(618,'Kellogg','kellog','','Russia',643,'Asia/Krasnoyarsk'),(9725,'Log','Log','','Russia',643,'Europe/Volgograd'),(1037,'Messerschmitt Me.323 Gigant','gigant','','Russia',643,'Europe/Moscow'),(928,'NEC','nec','','Russia',643,'Europe/Belgrade'),(13261,'SIM','Sim','','Russia',643,'Asia/Yekaterinburg'),(1632,'Абаза','baza','','Russia',643,'Asia/Yekaterinburg'),(11726,'Абай','Abay','','Russia',643,'Asia/Omsk'),(1407,'Абакан','abakan','','Russia',643,'Asia/Krasnoyarsk'),(589,'Абан','aban','','Russia',643,'Asia/Krasnoyarsk'),(1375,'Абатский','abatskij','','Russia',643,'Asia/Yekaterinburg'),(1633,'Абдулино','abdulino','','Russia',643,'Asia/Yekaterinburg'),(1636,'Абинск','Abinsk','','Russia',643,'Europe/Moscow'),(341,'Абрамовский маяк','abramovskij-maiak','','Russia',643,''),(9186,'Ага','Aga','','Russia',643,'Asia/Yakutsk'),(13192,'Аган','Agan','','Russia',643,'Asia/Yekaterinburg'),(2464,'Агаповка','Agapovka','','Russia',643,'Asia/Yekaterinburg'),(1590,'Агата','agata','','Russia',643,'Asia/Krasnoyarsk'),(1637,'Агвали','agvali','','Russia',643,'Europe/Moscow'),(993,'Агзу','agzu','','Russia',643,'Asia/Vladivostok'),(11738,'Агидель','Agidely','','Russia',643,'Asia/Yekaterinburg'),(377,'Агинское','aginskoe','','Russia',643,'Asia/Yakutsk'),(1638,'Агрыз','argiz','','Russia',643,''),(1639,'Адамовка','adamovka','','Russia',643,'Asia/Yekaterinburg'),(1641,'Адыгейск','adigeisk','','Russia',643,''),(1642,'Азнакаево','aznakaevo','','Russia',643,'Europe/Moscow'),(1643,'Азов','azov','','Russia',643,'Europe/Moscow'),(1644,'Азово','azovo','','Russia',643,'Asia/Omsk'),(1060,'Айхал','aihal','','Russia',643,'Asia/Yakutsk'),(12271,'Ак-Довурак','Ak-Dovurak','','Russia',643,'Asia/Krasnoyarsk'),(1645,'Акбулак','akbulak','','Russia',643,'Asia/Yekaterinburg'),(1646,'Аксай','Aksai','','Russia',643,'Europe/Moscow'),(1647,'Аксарка','aksarka','','Russia',643,'Asia/Yekaterinburg'),(1648,'Аксубаево','aksubaevo','','Russia',643,'Europe/Moscow'),(1649,'Акташ','aktash','','Russia',643,'Asia/Omsk'),(1517,'Акша','aksa','','Russia',643,'Asia/Yakutsk'),(378,'Акьяр','akjar','','Russia',643,'Europe/Copenhagen'),(1650,'Алагир','alagir','','Russia',643,'Europe/Moscow'),(1274,'Алапаевск','alapaevsk','','Russia',643,'Asia/Yekaterinburg'),(86700,'Алапаевск','Alapayevsk','','Russia',643,'Asia/Yekaterinburg'),(1499,'Алатырь','alatyr','','Russia',643,'Europe/Moscow'),(1061,'Алдан','aldan','','Russia',643,'Asia/Yakutsk'),(9190,'Алейск','Aleisk','','Russia',643,'Asia/Omsk'),(289,'Алейская','alejskaja','','Russia',643,'Asia/Omsk'),(11838,'Александрийская','Aleksandriyskaya','','Russia',643,'Europe/Moscow'),(436,'Александров','aleksandrov','','Russia',643,'Europe/Moscow'),(1237,'Александров-Гай','aleksandrov-gai','','Russia',643,'Europe/Moscow'),(9850,'Александровка','Aleksandrovka','','Russia',643,'Europe/Moscow'),(1651,'Александровск','aleksandrovsk','','Russia',643,'Asia/Yekaterinburg'),(1250,'Александровск-Сахалинский','aleksandrovsk-sahalinskiy','','Russia',643,'Asia/Sakhalin'),(12542,'Александровский','Aleksandrovskiy','','Russia',643,'Europe/Moscow'),(1518,'Александровский з-д','aleksandrovskiy z-d','','Russia',643,'Europe/Moscow'),(591,'Александровский Шлюз','aleksandrovski shliuz','','Russia',643,'Asia/Krasnoyarsk'),(1217,'Александровское','aleksandrovskoe','','Russia',643,'Europe/Moscow'),(1652,'Алексеевка','alekseevka','','Russia',643,'Europe/Moscow'),(1654,'Алексин','aleksin','','Russia',643,'Europe/Moscow'),(1655,'Аликово','alikovo','','Russia',643,'Europe/Moscow'),(1062,'Аллах-Юнь','allah-jun','','Russia',643,''),(1474,'Алтай','altaj','','Russia',643,'Asia/Omsk'),(474,'Алыгджер','alygdzer','','Russia',643,'Asia/Irkutsk'),(1656,'Альметьевск','altemevsk','','Russia',643,'Europe/Zaporozhye'),(1519,'Амазар','amazar','','Russia',643,'Asia/Yakutsk'),(1063,'Амга','amga','','Russia',643,'Asia/Yakutsk'),(918,'Амдерма','amderma','','Russia',643,'Europe/Moscow'),(1657,'Амурзет','amurzet','','Russia',643,'Asia/Vladivostok'),(1658,'Амурск','amursk','','Russia',643,'Asia/Vladivostok'),(1064,'Анабар','anabar','','Russia',643,'Asia/Yakutsk'),(1568,'Анадырь','anadyr','','Russia',643,'Asia/Anadyr'),(568,'Анапа','anapa','','Russia',643,'Europe/Moscow'),(10352,'Анастасиевская','Anastasievskaya','','Russia',643,''),(9990,'Анга','Anga','','Russia',643,'Asia/Irkutsk'),(1659,'Ангарск','angarsk','','Russia',643,'Asia/Irkutsk'),(1065,'Андрюшкино','andrjushkino','','Russia',643,'Asia/Magadan'),(1660,'Анжеро-Судженск','angero-sydzensk','','Russia',643,''),(1661,'Анива','aniva','','Russia',643,'Asia/Sakhalin'),(463,'Анна','anna','','Russia',643,'Europe/Moscow'),(1608,'Антипаюта','antipajuta','','Russia',643,''),(994,'Анучино','anucino','','Russia',643,'Europe/Moscow'),(840,'Апатиты','apatity','','Russia',643,'Europe/Moscow'),(1662,'Апрелевка','aprevelka','','Russia',643,'Europe/Moscow'),(86701,'Апрелевка','Aprelevka','','Russia',643,'Europe/Moscow'),(749,'Апука','apuka','','Russia',643,'Asia/Kamchatka'),(1663,'Апшеронск','apsheronsk','','Russia',643,'Europe/Moscow'),(12662,'Арамиль','Aramily','','Russia',643,''),(1502,'Аргаяш','argajash','','Russia',643,''),(13274,'Аргун','Argun','','Russia',643,'Asia/Shanghai'),(1664,'Ардатов','ardatov','','Russia',643,'Europe/Moscow'),(12169,'Ардон','Ardon','','Russia',643,'Europe/Moscow'),(1665,'Арзамас','arzamas','','Russia',643,'Europe/Moscow'),(1218,'Арзгир','arzgir','','Russia',643,'Europe/Moscow'),(788,'Арка','arka','','Russia',643,'Asia/Vladivostok'),(12546,'Аркадак','Arkadak','','Russia',643,'Europe/Volgograd'),(569,'Армавир','armavir','','Russia',643,'Europe/Moscow'),(789,'Арман','arman','','Russia',643,'Asia/Magadan'),(1666,'Армизонское','armizonskoe','','Russia',643,'Asia/Yekaterinburg'),(1667,'Аромашево','aromashevo','','Russia',643,'Asia/Yekaterinburg'),(995,'Арсеньев','arsenev','','Russia',643,''),(1668,'Арск','arsk','','Russia',643,'Europe/Moscow'),(524,'Артезиан','artesian','','Russia',643,'America/Chicago'),(996,'Артём','artem','','Russia',643,'Asia/Vladivostok'),(592,'Артемовск','artemovsk','','Russia',643,'Asia/Krasnoyarsk'),(1275,'Артемовский','artenovsky','','Russia',643,''),(1669,'Арти','arti','','Russia',643,'Asia/Yekaterinburg'),(13378,'Арфа','Harp','','Russia',643,'America/Los_Angeles'),(9602,'Архангел','Arhangel','','Russia',643,'Europe/Moscow'),(342,'Архангельск','arhangelsk','','Russia',643,'Europe/Moscow'),(1671,'Архангельское','arhangelskoe','','Russia',643,'Europe/Moscow'),(9852,'Архангельское','Arhangelyskoe','','Russia',643,'Europe/Moscow'),(313,'Архара','arhara','','Russia',643,''),(475,'Аршан','arshan','','Russia',643,'Asia/Irkutsk'),(1674,'Асбест','asbest','','Russia',643,'Asia/Yekaterinburg'),(12910,'Асино','Asino','','Russia',643,'Asia/Novosibirsk'),(1408,'Аскиз','askiz','','Russia',643,'Asia/Krasnoyarsk'),(1676,'Аскино','askino','','Russia',643,'Asia/Yekaterinburg'),(997,'Астраханка','astrahanka','','Russia',643,'Europe/Volgograd'),(373,'Астрахань','astrahan','','Russia',643,'Europe/Volgograd'),(10820,'Атка','Atka','','Russia',643,'Asia/Magadan'),(1677,'Аткарск','aktarsk','','Russia',643,'Europe/Volgograd'),(1678,'Атяшево','atiashevo','','Russia',643,'Europe/Moscow'),(1679,'Афанасьево','afanasievo','','Russia',643,'Europe/Moscow'),(10355,'Афипский','Afipskiy','','Russia',643,'Europe/Moscow'),(1680,'Ахтубинск','ahtubinsk','','Russia',643,'Europe/Volgograd'),(86699,'Ахтубинск','Akhtubinsk','','Russia',643,'Europe/Volgograd'),(426,'Ахты','ahty','','Russia',643,''),(10356,'Ахтырский','Ahtirskiy','','Russia',643,''),(593,'Ачинск','achinsk','','Russia',643,'Asia/Krasnoyarsk'),(12664,'Ачит','Acit','','Russia',643,'Asia/Ulaanbaatar'),(1681,'Аша','asha','','Russia',643,'Asia/Yekaterinburg'),(10358,'Аше','Ashe','','Russia',643,'Europe/Moscow'),(12308,'Аютинский','Aiutinskiy','','Russia',643,'Asia/Yekaterinburg'),(1420,'Аян','ajan','','Russia',643,'Asia/Sakhalin'),(454,'Бабаево','babaevo','','Russia',643,'Europe/Moscow'),(1686,'Бабаюрт','babaiurt','','Russia',643,'Asia/Tbilisi'),(476,'Бабушкин','babuskin','','Russia',643,'Asia/Irkutsk'),(1687,'Бавлы','bavli','','Russia',643,'Europe/Moscow'),(86705,'Бавлы','Bavly','','Russia',643,'Europe/Moscow'),(387,'Багдарин','bagdarin','','Russia',643,'Asia/Irkutsk'),(290,'Баево','baevo','','Russia',643,'Europe/Moscow'),(1689,'Базарные Матаки','bazarnie mataki','','Russia',643,'Europe/Moscow'),(12548,'Базарный Карабулак','Bazarniy Karabulak','','Russia',643,'Europe/Volgograd'),(10000,'Байкал','Baykal','','Russia',643,'Asia/Irkutsk'),(1690,'Байкалово','baikalovo','','Russia',643,'Asia/Yekaterinburg'),(477,'Байкальск','bajkalsk','','Russia',643,'Asia/Irkutsk'),(1591,'Байкит','bajkit','','Russia',643,'Asia/Krasnoyarsk'),(1691,'Баймак','baimak','','Russia',643,'Asia/Yekaterinburg'),(13236,'Бакал','Bakal','','Russia',643,'Asia/Yekaterinburg'),(379,'Бакалы','bakaly','','Russia',643,'Asia/Yekaterinburg'),(1692,'Баксан','baksan','','Russia',643,'Europe/Moscow'),(1422,'Бактор','baktor','','Russia',643,''),(1344,'Бакчар','bakchar','','Russia',643,'Asia/Novosibirsk'),(12070,'Бала','Bala','','Russia',643,'Asia/Vladivostok'),(10164,'Балабаново','Balabanovo','','Russia',643,'Europe/Moscow'),(478,'Балаганск','balagansk','','Russia',643,'Asia/Irkutsk'),(1238,'Балаково','balakovo','','Russia',643,'Europe/Volgograd'),(1693,'Балахна','balahna','','Russia',643,'Europe/Moscow'),(594,'Балахта','balahta','','Russia',643,''),(1694,'Балашиха','balashiha','','Russia',643,'Europe/Moscow'),(1239,'Балашов','balasov','','Russia',643,'Europe/Volgograd'),(1695,'Балезино','balezino','','Russia',643,'Europe/Samara'),(1520,'Балей','balej','','Russia',643,'Asia/Yakutsk'),(1696,'Балтай','baltai','','Russia',643,'Europe/Tallinn'),(1697,'Балтаси','baltasi','','Russia',643,'Europe/Moscow'),(654,'Балтийск','baltijsk','','Russia',643,'Europe/Kaliningrad'),(86704,'Балтийск','Baltiysk','','Russia',643,'Europe/Kaliningrad'),(790,'Балыгычан','balygychan','','Russia',643,'Asia/Magadan'),(2504,'Балыкесир','balikesir','','Russia',643,'Europe/Istanbul'),(885,'Барабинск','barabinsk','','Russia',643,'Asia/Novosibirsk'),(2432,'Барак','shack','','Russia',643,'America/Chicago'),(1569,'Бараниха','baraniha','','Russia',643,'Europe/Warsaw'),(12666,'Баранчинский','Barancinskiy','','Russia',643,''),(388,'Баргузин','barguzin','','Russia',643,'Asia/Irkutsk'),(1699,'Барда','barda','','Russia',643,'Asia/Yekaterinburg'),(690,'Барзас','barsaz','','Russia',643,''),(291,'Барнаул','barnaul','','Russia',643,'Asia/Omsk'),(1700,'Барыш','barih','','Russia',643,'Europe/Rome'),(1066,'Батагай','batagay','','Russia',643,'Asia/Vladivostok'),(1067,'Батагай-Алыта','batagaj-alyta','','Russia',643,'Asia/Vladivostok'),(1701,'Батайск','bataisk','','Russia',643,'Europe/Moscow'),(1068,'Батамай','batamaj','','Russia',643,''),(1424,'Батомга','batomga','','Russia',643,'Asia/Vladivostok'),(1345,'Батурино','baturino','','Russia',643,'Asia/Novosibirsk'),(1702,'Батырево','batirevo','','Russia',643,'Europe/Warsaw'),(595,'Бахта','bahta','','Russia',643,''),(1703,'Башмаково','bashmakovo','','Russia',643,'Europe/Moscow'),(10005,'Баянда','Baianda','','Russia',643,''),(479,'Баяндай','bajandaj','','Russia',643,''),(1409,'Беджа','beja','','Russia',643,'Europe/Riga'),(1704,'Беднодемьянск','bednodemiansk','','Russia',643,''),(1705,'Бежецк','bezetsk','','Russia',643,'Europe/Moscow'),(1706,'Безенчук','bezenchuk','','Russia',643,'Europe/Samara'),(1707,'Беково','bekovo','','Russia',643,'Europe/Moscow'),(570,'Белая глина','belaja-glina','','Russia',643,'Europe/Moscow'),(1069,'Белая Гора','belaja-gora','','Russia',643,'Asia/Magadan'),(1708,'Белая Калитва','belaia kalitva','','Russia',643,'Europe/Moscow'),(1709,'Белая Холуница','belaia holunitsia','','Russia',643,''),(416,'Белгород','belgorod','','Russia',643,'Europe/Moscow'),(1710,'Белебей','belebei','','Russia',643,'Asia/Yekaterinburg'),(1712,'Белинский','belinskiy','','Russia',643,'Europe/Moscow'),(691,'Белово','belovo','','Russia',643,'Asia/Novokuznetsk'),(760,'Белогорка','belogorka','','Russia',643,'Europe/Moscow'),(314,'Белогорск','belogorsk','','Russia',643,'Asia/Yakutsk'),(9853,'Белогорье','Belogorye','','Russia',643,''),(455,'Белозерск','belozersk','','Russia',643,'Europe/Moscow'),(1714,'Белокуриха','belokuriha','','Russia',643,'Asia/Omsk'),(86707,'Белокуриха','Belokurikha','','Russia',643,'Asia/Omsk'),(1715,'Беломорск','belomorsk','','Russia',643,'Europe/Moscow'),(1716,'Белорецк','beloreck','','Russia',643,'Asia/Yekaterinburg'),(86709,'Белорецк','Beloretsk','','Russia',643,'Asia/Yekaterinburg'),(1717,'Белореченск','belorecensk','','Russia',643,'Europe/Moscow'),(10166,'Белоусово','Belousovo','','Russia',643,'Europe/Moscow'),(9196,'Белоярск','Beloyarsk','','Russia',643,'Asia/Omsk'),(1718,'Белоярский','beloiarskiy','','Russia',643,'Asia/Yekaterinburg'),(9536,'Белые Берега','Belie Berega','','Russia',643,''),(1331,'Белый','belyj','','Russia',643,'Asia/Yekaterinburg'),(10282,'Белый','Belaya','','Russia',643,'Europe/Moscow'),(1346,'Белый Яр','belyj-jar','','Russia',643,'Asia/Novosibirsk'),(276,'Беля','belja','','Russia',643,'Europe/Tallinn'),(1719,'Беляевка','beliaevka','','Russia',643,'Asia/Yekaterinburg'),(1070,'Бердигестях','berdigestjah','','Russia',643,'Asia/Yakutsk'),(1720,'Бердск','berdsk','','Russia',643,'Asia/Novosibirsk'),(1721,'Бердюжье','berdiuze','','Russia',643,''),(967,'Березники','berezniki','','Russia',643,'Asia/Yekaterinburg'),(999,'Березняки','bereznjaki','','Russia',643,'Asia/Yekaterinburg'),(1722,'Березовка','berezovka','','Russia',643,'Asia/Krasnoyarsk'),(1475,'Берёзово','berezovo','','Russia',643,'Asia/Yekaterinburg'),(10240,'Березовский','Berezovskiy','','Russia',643,'Asia/Krasnoyarsk'),(1723,'Беринговский','beringovskiy','','Russia',643,'Asia/Anadyr'),(1724,'Беслан','beslan','','Russia',643,'Europe/Moscow'),(1725,'Бижбуляк','bizbuliak','','Russia',643,''),(292,'Бийск','bijsk','','Russia',643,'Asia/Omsk'),(294,'Бийск-Зональная','rijsk-zonalna','','Russia',643,''),(1425,'Бикин','bikin','','Russia',643,'Asia/Vladivostok'),(1571,'Билибино','bilibino','','Russia',643,'Asia/Anadyr'),(9939,'Бира','Bira','','Russia',643,'Asia/Vladivostok'),(1426,'Биробиджан','birobidzhan','','Russia',643,'Asia/Vladivostok'),(380,'Бирск','birsk','','Russia',643,'Asia/Yekaterinburg'),(1572,'Бисер','biser','','Russia',643,'Asia/Yekaterinburg'),(1276,'Бисерть','bisert','','Russia',643,'Asia/Yekaterinburg'),(1427,'Бичевая','bicevaja','','Russia',643,''),(390,'Бичура','bicura','','Russia',643,''),(9198,'Благовещенка','Blagoveshenka','','Russia',643,'Asia/Yakutsk'),(315,'Благовещенск','blagovescensk','','Russia',643,'Asia/Yakutsk'),(1726,'Благовещенск','blagoveshensk','','Russia',643,'Asia/Yakutsk'),(1219,'Благодарный','blagodarnyj','','Russia',643,'Europe/Moscow'),(1727,'Бобров','bobrov','','Russia',643,'Europe/Moscow'),(1728,'Богданович','bogdanovich','','Russia',643,'Asia/Yekaterinburg'),(12973,'Богородицк','Bogorodick','','Russia',643,'Europe/Moscow'),(1729,'Богородск','bogorodsk','','Russia',643,'Europe/Moscow'),(1730,'Богородское','bogorodskoe','','Russia',643,'Europe/Volgograd'),(596,'Боготол','bogotol','','Russia',643,'Asia/Krasnoyarsk'),(1731,'Боград','bograd','','Russia',643,'Asia/Krasnoyarsk'),(597,'Богучаны','bogucany','','Russia',643,''),(442,'Богучар','bogucar','','Russia',643,'Europe/Moscow'),(480,'Бодайбо','bodajbo','','Russia',643,'Asia/Irkutsk'),(1035,'Боковская','bokovskaja','','Russia',643,'Europe/Moscow'),(1732,'Бокситогорск','boksitogorsk','','Russia',643,'Europe/Moscow'),(1332,'Бологое','bologoe','','Russia',643,'Europe/Moscow'),(13126,'Болонь','Bolony','','Russia',643,'Europe/Moscow'),(886,'Болотное','bolotnoe','','Russia',643,'Asia/Novosibirsk'),(12975,'Болохово','Bolohovo','','Russia',643,''),(957,'Болхов','bolhov','','Russia',643,'Europe/Moscow'),(9786,'Большая','Bolyshaya','','Russia',643,'Asia/Almaty'),(1734,'Большая Атня','bolshaia atnia','','Russia',643,'Europe/Moscow'),(1230,'Большая Глушиха','bolshaya-glushitsa','','Russia',643,''),(598,'Большая Мурта','bolsaja-murta','','Russia',643,''),(1735,'Большая Соснова','bolshaia sosnova','','Russia',643,'Asia/Yekaterinburg'),(1736,'Большая Черниговка','bolshaia chernigovka','','Russia',643,'Asia/Vladivostok'),(666,'Большерецк','bolsherechk','','Russia',643,'Asia/Omsk'),(1737,'Большеречье','bolshereche','','Russia',643,'Asia/Omsk'),(1738,'Большие Березники','bolshie berezniki','','Russia',643,'Asia/Yekaterinburg'),(1307,'Большие Кайбицы','bolshie-kajbitsi','','Russia',643,''),(937,'Большие Уки','bolsie-uki','','Russia',643,''),(1405,'Большое Голоустное','bolshoe-goloustnoe','','Russia',643,''),(1740,'Большое Мурашкино','bolshoe murashkino','','Russia',643,''),(1741,'Большое Нагаткино','bolshoe nagatkino','','Russia',643,''),(1742,'Большое Солдатское','bolshoe soldatskoe','','Russia',643,''),(9672,'Большой','Bolyshoi','','Russia',643,'Asia/Kamchatka'),(2466,'Большой Камень','Bolshoy Kamen','','Russia',643,'Asia/Vladivostok'),(1410,'Большой Он','bolshoj-on','','Russia',643,''),(599,'Большой Порог','bolshoj-porog','','Russia',643,''),(600,'Большой Улуй','bolsoj-uluj','','Russia',643,''),(316,'Бомнак','bomnak','','Russia',643,'Asia/Yakutsk'),(601,'Бор','bor','','Russia',643,'Europe/Moscow'),(1523,'Борзя','borzja','','Russia',643,'Asia/Yakutsk'),(9493,'Борисовка','Borisovka','','Russia',643,'Europe/Moscow'),(464,'Борисоглебск','borisoglebsk','','Russia',643,'Europe/Moscow'),(9608,'Борисоглебский','Borisogleb','','Russia',643,'Europe/Moscow'),(1744,'Боровичи','borovichi','','Russia',643,'Europe/Moscow'),(10168,'Боровск','Borovsk','','Russia',643,'Europe/Moscow'),(13025,'Боровский','Borobskiy','','Russia',643,'Asia/Yekaterinburg'),(1072,'Борогонцы','borogoncy','','Russia',643,'Asia/Yakutsk'),(10478,'Бородинское сражение','Borodino','','Russia',643,'Europe/Moscow'),(1745,'Борское','borskoe','','Russia',643,'Europe/Samara'),(1746,'Ботлих','botlih','','Russia',643,'Europe/Moscow'),(481,'Бохан','bohan','','Russia',643,'Europe/Brussels'),(791,'Бохапча','bohapcha','','Russia',643,''),(317,'Братолюбовка','bratoljubovka','','Russia',643,'Asia/Yakutsk'),(482,'Братск','bratsk','','Russia',643,'Asia/Irkutsk'),(1503,'Бреды','bredy','','Russia',643,'Asia/Yekaterinburg'),(13390,'Брейтово','Breytovo','','Russia',643,'Europe/Moscow'),(1504,'Бродокалмак','brodokalmak','','Russia',643,'Asia/Yekaterinburg'),(1748,'Бронницы','bronici','','Russia',643,'Europe/Moscow'),(792,'Брохово','brohovo','','Russia',643,''),(1749,'Брюховецкая','briuhovetskaia','','Russia',643,'Europe/Moscow'),(10479,'Брянка','Brianka','','Russia',643,'Europe/Zaporozhye'),(420,'Брянск','brjansk','','Russia',643,'Europe/Moscow'),(919,'Бугрино','bugrino','','Russia',643,'Europe/Moscow'),(1308,'Бугульма','bugulma','','Russia',643,'Europe/Moscow'),(954,'Бугуруслан','buguruslan','','Russia',643,'Asia/Yekaterinburg'),(1220,'Будённовск','budennovsk','','Russia',643,'Europe/Moscow'),(1750,'Буздяк','buzdiak','','Russia',643,'Asia/Yekaterinburg'),(955,'Бузулук','busuluk','','Russia',643,'Asia/Yekaterinburg'),(1751,'Буинск','buinsk','','Russia',643,'Europe/Moscow'),(721,'Буй','buj','','Russia',643,'Europe/Moscow'),(427,'Буйнакск','bujnaksk','','Russia',643,'Europe/Moscow'),(86711,'Буйнакск','Buynaksk','','Russia',643,'Europe/Moscow'),(13129,'Булава','Bulava','','Russia',643,'Asia/Vladivostok'),(12669,'Буланаш','Bulanash','','Russia',643,'Asia/Yekaterinburg'),(1752,'Бураево','buraevo','','Russia',643,'Asia/Yekaterinburg'),(9202,'Бурла','Burla','','Russia',643,'Asia/Omsk'),(1429,'Бурукан','burukan','','Russia',643,'Asia/Yakutsk'),(12199,'Бута','Buta','','Russia',643,'Europe/Moscow'),(1753,'Бутурлино','buturlino','','Russia',643,'Europe/Moscow'),(1754,'Бутурлиновка','buturkinovka','','Russia',643,'Europe/Moscow'),(1073,'Бухта Амбарчик','buhta-ambarcik','','Russia',643,''),(1573,'Бухта Провидения','buhta-providenia','','Russia',643,''),(1074,'Буяга','bujaga','','Russia',643,''),(12639,'Быков','Bikov','','Russia',643,'Europe/Sofia'),(821,'Быково','bykovo','','Russia',643,'Europe/Volgograd'),(1755,'Быково','bikovo','','Russia',643,'Europe/Volgograd'),(86712,'Быково','Bykovo Airport','','Russia',643,'Europe/Moscow'),(318,'Бысса','byssa','','Russia',643,'Asia/Yakutsk'),(9999,'Бэр','Baer','','Russia',643,'Asia/Irkutsk'),(13049,'Вавож','Vavog','','Russia',643,''),(1756,'Вагай','vagai','','Russia',643,'Europe/Moscow'),(11257,'Вад','Vad','','Russia',643,'Europe/Moscow'),(1757,'Вадинск','vadinsk','','Russia',643,'Europe/Moscow'),(1251,'Вал','val','','Russia',643,'Asia/Sakhalin'),(1758,'Валдай','valdai','','Russia',643,'Europe/Moscow'),(86871,'Валдай','Valday','','Russia',643,'Europe/Moscow'),(1036,'Валуйки','valujki','','Russia',643,'Europe/Moscow'),(1574,'Валькаркай','valjkarkaij','','Russia',643,''),(1592,'Ванавара','vanavara','','Russia',643,'Asia/Krasnoyarsk'),(1348,'Ванжиль-Кынак','vanzil-kynak','','Russia',643,''),(13130,'Ванино','Vanino','','Russia',643,'Asia/Vladivostok'),(1759,'Варгаши','vargashi','','Russia',643,'Asia/Yekaterinburg'),(10364,'Варениковская','Varenokovskaya','','Russia',643,'Europe/Moscow'),(1760,'Варна','varna','','Russia',643,'Asia/Yekaterinburg'),(1761,'Варнавино','varnavino','','Russia',643,'Europe/Moscow'),(13131,'Васильевка','Vasilyevka','','Russia',643,'Europe/Zaporozhye'),(12201,'Васильево','Vasilyevo','','Russia',643,'Europe/Moscow'),(1376,'Ваховск','vahovsk','','Russia',643,''),(1762,'Ведено','vedeno','','Russia',643,'Europe/Moscow'),(1763,'Велиж','veliz','','Russia',643,'Europe/Moscow'),(13330,'Великая','Velikaya','','Russia',643,'Europe/Volgograd'),(987,'Великие Луки','velikie-luki','','Russia',643,'Europe/Moscow'),(883,'Великий Новгород','Velikiy novgorod','','Russia',643,'Europe/Moscow'),(456,'Великий Устюг','velikij-ustjug','','Russia',643,'Europe/Moscow'),(86872,'Великий Устюг','Velikiy Ustyug','','Russia',643,'Europe/Moscow'),(10109,'Великобритания','Uk','','Russia',643,'Asia/Irkutsk'),(13393,'Великое','Velikoe','','Russia',643,'Europe/Moscow'),(1593,'Вельмо','velmo','','Russia',643,'Europe/Helsinki'),(343,'Вельск','velsk','','Russia',643,'Europe/Moscow'),(887,'Венгерово','vengerovo','','Russia',643,'Asia/Novosibirsk'),(1764,'Вендинга','vendinga','','Russia',643,'Europe/Moscow'),(1765,'Венёв','venev','','Russia',643,'Europe/Moscow'),(969,'Верещагино','verescagino','','Russia',643,''),(1766,'Верх-Чебула','verh-chebula','','Russia',643,''),(1075,'Верхневилюйск','verhneviljujsk','','Russia',643,''),(12727,'Верхнеднепровский','Verhnedneprovskiy','','Russia',643,''),(1277,'Верхнее Дуброво','verhnee-dubrovo','','Russia',643,'Europe/Moscow'),(750,'Верхнее Пенжино','verhnee-penzino','','Russia',643,''),(603,'Верхнеимбатск','verhneimbatsk','','Russia',643,''),(1767,'Верхнеуральск','verhneuralsk','','Russia',643,'Asia/Yekaterinburg'),(1768,'Верхнеяркеево','verhneiarkeevo','','Russia',643,''),(1770,'Верхние Татышлы','verhnie tatishli','','Russia',643,''),(604,'Верхний Амыл','verhnij-amyl','','Russia',643,''),(374,'Верхний Баскунчак','verhnij-baskun','','Russia',643,''),(1771,'Верхний Ландех','verhnii landeh','','Russia',643,''),(1772,'Верхний Тагил','verhnii tagil','','Russia',643,'Asia/Yekaterinburg'),(86874,'Верхний Тагил','Verkhniy Tagil','','Russia',643,'Asia/Yekaterinburg'),(12203,'Верхний Услон','Verhniy Uslon','','Russia',643,'Europe/Moscow'),(1505,'Верхний Уфалей','verhnij-ufalej','','Russia',643,'Asia/Yekaterinburg'),(483,'Верхняя Гутара','verhnjaja-guta','','Russia',643,''),(12672,'Верхняя Пышма','Verhnyaya Pishma','','Russia',643,'Asia/Yekaterinburg'),(1773,'Верхняя Салда','verhniaia salda','','Russia',643,''),(12673,'Верхняя Синячиха','Verhnyaya Siniaciha','','Russia',643,''),(344,'Верхняя Тойма','verhnjaja-tojma','','Russia',643,'Europe/Moscow'),(12675,'Верхняя Тура','Verhnyaya Tura','','Russia',643,'Asia/Yekaterinburg'),(1774,'Верховажье','verhovazie','','Russia',643,''),(958,'Верховье','verhove','','Russia',643,'Europe/Brussels'),(1278,'Верхотурье','verhoture','','Russia',643,'Asia/Yekaterinburg'),(1076,'Верхоянск','verhojansk','','Russia',643,'Asia/Vladivostok'),(86876,'Верхоянск','Verkhoyansk','','Russia',643,'Asia/Vladivostok'),(1077,'Верхоянский Перевоз','verhojanskij-perevoz','','Russia',643,''),(1431,'Веселая Горка','veselaja-gorka','','Russia',643,'Europe/Volgograd'),(9685,'Весёлое','Veseloe','','Russia',643,'Europe/Simferopol'),(1776,'Веселый','veseliy','','Russia',643,'Asia/Vladivostok'),(548,'Весляна','vesljana','','Russia',643,''),(1777,'Весьегонск','vesiegonsk','','Russia',643,'Europe/Moscow'),(871,'Ветлуга','vetluga','','Russia',643,'Europe/Moscow'),(11262,'Ветлужский','Vetlugskiy','','Russia',643,''),(1778,'Вешенская','veshenskaia','','Russia',643,'Europe/Moscow'),(1779,'Вешкайма','veshkaima','','Russia',643,'Europe/Moscow'),(1780,'Видное','vidnoe','','Russia',643,'Europe/Moscow'),(11965,'Виктор','Viktor','','Russia',643,'Europe/Moscow'),(1377,'Викулово','vikulovo','','Russia',643,'Asia/Yekaterinburg'),(1078,'Вилюйск','viljujsk','','Russia',643,'Asia/Yakutsk'),(11263,'Виля','Vilia','','Russia',643,'Europe/Moscow'),(13029,'Винзили','Vinzili','','Russia',643,'Asia/Yekaterinburg'),(761,'Винницы','vinnicy','','Russia',643,'Europe/Moscow'),(10905,'Виноградов','Vinogradovo','','Russia',643,'Europe/Moscow'),(1279,'Висим','visim','','Russia',643,'Asia/Yekaterinburg'),(1079,'Витим','vitim','','Russia',643,'Asia/Yakutsk'),(10025,'Вихоревка','Vihorevka','','Russia',643,'Asia/Irkutsk'),(2387,'ВИЧ','hiv','','Russia',643,'Europe/Kiev'),(9956,'Вичуга','Vicuga','','Russia',643,'Europe/Moscow'),(1000,'Владивосток','vladivostok','','Russia',643,'Asia/Vladivostok'),(1215,'Владикавказ','vladikavkaz','','Russia',643,'Europe/Moscow'),(437,'Владимир','vladimir','','Russia',643,'Europe/Moscow'),(822,'Внуково','vnukovo','','Russia',643,'Europe/Moscow'),(86877,'Внуково','Vnukovo International Airport','','Russia',643,'Europe/Moscow'),(457,'Вожега','vozega','','Russia',643,''),(1782,'Вознесенское','voznesenskoe','','Russia',643,'Europe/Moscow'),(762,'Вознесенье','voznesene','','Russia',643,'Europe/Moscow'),(443,'Волгоград','volgograd','','Russia',643,'Europe/Volgograd'),(1783,'Волгодонск','volgodonsk','','Russia',643,'Europe/Moscow'),(10332,'Волгореченск','Volgorecensk','','Russia',643,'Europe/Moscow'),(2036,'Волжск','lopatino','','Russia',643,'Europe/Moscow'),(872,'Волжская ГМО','volzskaja-gmo','','Russia',643,'Asia/Yekaterinburg'),(1784,'Волжский','volzskiy','','Russia',643,'Europe/Volgograd'),(1372,'Волово','volovo','','Russia',643,'Europe/Moscow'),(458,'Вологда','vologda','','Russia',643,'Europe/Moscow'),(9206,'Володарка','Volodarka','','Russia',643,'Asia/Omsk'),(11265,'Володарск','Volodarsk','','Russia',643,'Europe/Moscow'),(823,'Волоколамск','volokolamsk','','Russia',643,'Europe/Moscow'),(9496,'Волоконовка','Volokonovka','','Russia',643,'Europe/Moscow'),(763,'Волосово','volosovo','','Russia',643,'Europe/Moscow'),(10484,'Волочанка','Volocanka','','Russia',643,''),(1786,'Волхов','volhov','','Russia',643,'Europe/Moscow'),(86878,'Волхов','Volkhov','','Russia',643,'Europe/Moscow'),(12676,'Волчанск','Volcansk','','Russia',643,'Asia/Yekaterinburg'),(293,'Волчиха','volciha','','Russia',643,''),(1787,'Вольск','volsk','','Russia',643,'Europe/Volgograd'),(12011,'Вольск','Volgsk','','Russia',643,'Europe/Volgograd'),(1476,'Воньеган','vonegan','','Russia',643,'Asia/Yekaterinburg'),(549,'Воркута','vorkuta','','Russia',643,'Europe/Moscow'),(605,'Ворогово','vorogovo','','Russia',643,'Asia/Krasnoyarsk'),(465,'Воронеж','voronez','','Russia',643,'Europe/Moscow'),(10173,'Воротынск','Vorotinsk','','Russia',643,'Europe/Moscow'),(11267,'Ворсма','Vorsma','','Russia',643,'Europe/Moscow'),(1788,'Воскресенск','voskresensk','','Russia',643,'Europe/Moscow'),(873,'Воскресенское','voskresenskoe','','Russia',643,'Europe/Moscow'),(1080,'Восточная','vostochnaja','','Russia',643,'Europe/Moscow'),(1394,'Воткинск','votkinsk','','Russia',643,'Europe/Samara'),(722,'Вохма','vohma','','Russia',643,'Europe/Tallinn'),(1790,'Всеволожск','vsevolozsk','','Russia',643,'Europe/Moscow'),(86879,'Всеволожск','Vsevolozhsk','','Russia',643,'Europe/Moscow'),(550,'Вуктыл','vuktyl','','Russia',643,'Europe/Moscow'),(1791,'Вуктыл','vuktil','','Russia',643,'Europe/Moscow'),(1792,'Вурнары','vurnari','','Russia',643,'Asia/Yekaterinburg'),(764,'Выборг','vyborg','','Russia',643,'Europe/Moscow'),(874,'Выкса','vyksa','','Russia',643,'Europe/Moscow'),(10636,'Вырица','Virica','','Russia',643,''),(1793,'Выселки','viselki','','Russia',643,'Europe/Moscow'),(1794,'Высоковск','visovsk','','Russia',643,''),(10175,'Высокое','Visokoe','','Russia',643,'Europe/Moscow'),(459,'Вытегра','vytegra','','Russia',643,'Europe/Moscow'),(1333,'Вышний Волочек','vysnij-volocek','','Russia',643,'Europe/Moscow'),(1432,'Вяземская','vjazemskaja','','Russia',643,'Asia/Vladivostok'),(13138,'Вяземский','Viazemskiy','','Russia',643,'Asia/Vladivostok'),(438,'Вязники','vjasniki','','Russia',643,''),(1303,'Вязьма','vjazma','','Russia',643,'Europe/Moscow'),(707,'Вятские Поляны','vjatskie-poljany','','Russia',643,'Europe/Volgograd'),(9957,'Гаврилов Посад','Gavrivov Posad','','Russia',643,'Europe/Moscow'),(86731,'Гаврилов-Ям','Gavrilov-Yam','','Russia',643,'Europe/Moscow'),(1304,'Гагарин Юрий Алексеевич','gagarin','','Russia',643,'Europe/Moscow'),(11205,'Гаджиево','Gadgievo','','Russia',643,''),(9501,'Гайворон','Gayvoron','','Russia',643,'Asia/Vladivostok'),(971,'Гайны','gajny','','Russia',643,'Europe/Warsaw'),(1795,'Галич','galich','','Russia',643,'Europe/Moscow'),(1280,'Гари','gari','','Russia',643,'Asia/Yekaterinburg'),(1796,'Гатчина','gatchina','','Russia',643,'Europe/Moscow'),(1797,'Гвардейск','gvardeisk','','Russia',643,'Europe/Kaliningrad'),(1433,'Гвасюги','gvasjugi','','Russia',643,''),(988,'Гдов','gdov','','Russia',643,'Europe/Moscow'),(11475,'Гей','Gay','','Russia',643,'Asia/Yekaterinburg'),(571,'Геленджик','gelendzik','','Russia',643,'Europe/Moscow'),(86732,'Геленджик','Gelendzhik','','Russia',643,'Europe/Moscow'),(1434,'Георгиевка','georgievka','','Russia',643,'Asia/Krasnoyarsk'),(1798,'Георгиевск','georgievsk','','Russia',643,'Europe/Moscow'),(1799,'Георгиевское','georgievskoe','','Russia',643,'Europe/Moscow'),(1800,'Гергебиль','gergebil','','Russia',643,'Europe/Moscow'),(1801,'Гиагинская','giaganskaia','','Russia',643,'Europe/Moscow'),(793,'Гижига','gizhiga','','Russia',643,'Asia/Magadan'),(1395,'Глазов','glazov','','Russia',643,'Europe/Samara'),(9294,'Глубокий','Glubokiy','','Russia',643,'Europe/Moscow'),(1803,'Голицыно','golicino','','Russia',643,''),(9799,'Голуби','Golubi','','Russia',643,'Europe/Moscow'),(1378,'Голышманово','golyshmanovo','','Russia',643,'Asia/Yekaterinburg'),(10488,'Гонда','Gonda','','Russia',643,'Asia/Irkutsk'),(1435,'Горин','gorin','','Russia',643,'Asia/Vladivostok'),(10926,'Горки','Gorki','','Russia',643,'Europe/Moscow'),(277,'Горно-Алтайск','gorno-altajsk','','Russia',643,'Asia/Omsk'),(86733,'Горно-Алтайск','Gorno-Altaysk','','Russia',643,'Asia/Omsk'),(1804,'Горнозаводск','gornozavodsk','','Russia',643,'Asia/Yekaterinburg'),(10371,'Горный','Gorniy','','Russia',643,'Asia/Omsk'),(9210,'Горняк','Gorniak','','Russia',643,'Asia/Omsk'),(1805,'Городец','gorodec','','Russia',643,'Europe/Moscow'),(963,'Городище','gorodisce','','Russia',643,'Europe/Moscow'),(9499,'Городище','Gorodiche','','Russia',643,''),(12840,'Городня','Gorodnya','','Russia',643,'Europe/Moscow'),(525,'Городовиковск','gorodovikovsk','','Russia',643,'Europe/Moscow'),(1806,'Гороховец','gorohovec','','Russia',643,'Europe/Moscow'),(1807,'Горшечное','gorshechnoe','','Russia',643,''),(572,'Горячий Ключ','gorjacij-kljuc','','Russia',643,'Europe/Moscow'),(391,'Горячинск','gorjacinsk','','Russia',643,''),(417,'Готня','gotnja','','Russia',643,'America/Sao_Paulo'),(392,'Гоуджекит','goudzhekit','','Russia',643,'Asia/Irkutsk'),(10242,'Грамотеино','Gramoteino','','Russia',643,'Asia/Novokuznetsk'),(1809,'Грахово','grahovo','','Russia',643,'Europe/Podgorica'),(12330,'Грачев','Gracev','','Russia',643,'Europe/Volgograd'),(1810,'Грачевка','grachevka','','Russia',643,'Europe/Moscow'),(10178,'Грачевка','Gracevka','','Russia',643,''),(1812,'Гремячинск','gremiachinsk','','Russia',643,'Asia/Yekaterinburg'),(9866,'Грибановский','Gribanovskiy','','Russia',643,'Europe/Moscow'),(345,'Гридино','gridino','','Russia',643,'Europe/Moscow'),(1498,'Грозный','groznyj','','Russia',643,'Europe/Moscow'),(1813,'Грязи','griazi','','Russia',643,'Europe/Moscow'),(9801,'Грязовец','Griazovec','','Russia',643,''),(972,'Губаха','gubaha','','Russia',643,'Asia/Yekaterinburg'),(86735,'Губаха','Gubakha','','Russia',643,'Asia/Yekaterinburg'),(1814,'Губкин','gubkin','','Russia',643,'Europe/Moscow'),(13358,'Губкинский','Gubkinskiy','','Russia',643,'Europe/Moscow'),(1815,'Гудермес','gudermes','','Russia',643,'Europe/Moscow'),(10184,'Гуково','Gukovo','','Russia',643,'Europe/Moscow'),(1816,'Гулькевичи','gulkevichi','','Russia',643,'Europe/Moscow'),(1817,'Гуниб','gunib','','Russia',643,'Europe/Moscow'),(1818,'Гурьевск','gurievsk','','Russia',643,'Asia/Novokuznetsk'),(10145,'Гусев','Gusev','','Russia',643,'Europe/Kaliningrad'),(12732,'Гусино','Gusino','','Russia',643,'Europe/Moscow'),(1819,'Гусиноозёрск','gusinoozersk','','Russia',643,'Asia/Irkutsk'),(439,'Гусь-Хрустальный','gus-hrustalnyi','','Russia',643,'Europe/Moscow'),(10934,'Давидово','Davidovo','','Russia',643,'Asia/Irkutsk'),(1820,'Давлеканово','davlekanovo','','Russia',643,'Asia/Yekaterinburg'),(11843,'Дагестанские Огни','Dagestanskie Ogni','','Russia',643,'Europe/Moscow'),(1821,'Дагомыс','dagomis','','Russia',643,''),(86722,'Дагомыс','Dagomys','','Russia',643,'Europe/Moscow'),(728,'Далматово','dalmatovo','','Russia',643,'Asia/Yekaterinburg'),(1822,'Дальнегорск','dalnegorsk','','Russia',643,'Asia/Vladivostok'),(1823,'Дальнее Константиново','dalnee konstantinovo','','Russia',643,'Europe/Moscow'),(1003,'Дальнереченск','dalnerecensk','','Russia',643,'Asia/Vladivostok'),(1824,'Данилов','danilov','','Russia',643,'Europe/Moscow'),(444,'Даниловка','danilovka','','Russia',643,'Europe/Volgograd'),(10936,'Данки','Danki','','Russia',643,'Europe/Moscow'),(1825,'Данков','dankov','','Russia',643,'Europe/Moscow'),(1526,'Дарасун','darasun','','Russia',643,'Asia/Yakutsk'),(708,'Даровское','darovskoe','','Russia',643,''),(13143,'Датта','Datta','','Russia',643,'Asia/Sakhalin'),(346,'Двинский Березняк','dvinskij-berezniak','','Russia',643,''),(9362,'Двинской','Dvinskoy','','Russia',643,'Europe/Moscow'),(9363,'Двинской Березник','Dvinskoy Bereznik','','Russia',643,'Europe/Moscow'),(1396,'Дебессы','debessy','','Russia',643,''),(12677,'Дегтярск','Degtiarsk','','Russia',643,'Asia/Yekaterinburg'),(1826,'Дедовичи','dedovichi','','Russia',643,'Europe/Moscow'),(10939,'Дедовск','Dedovsk','','Russia',643,'Europe/Moscow'),(1827,'Демидовы','demidov','','Russia',643,'Europe/Moscow'),(1379,'Демьянское','demjanskoe','','Russia',643,'Europe/Moscow'),(11355,'Демянск','Demiansk','','Russia',643,'Europe/Moscow'),(1082,'Депутатский','deputatskij','','Russia',643,'Asia/Vladivostok'),(428,'Дербент','derbent','','Russia',643,'Europe/Moscow'),(1828,'Дергачи','dergachi','','Russia',643,'Europe/Volgograd'),(12733,'Десногорск','Desnogorsk','','Russia',643,'Europe/Moscow'),(320,'Джалинда','dzalinda','','Russia',643,'Asia/Irkutsk'),(1437,'Джана','dzhana','','Russia',643,'Asia/Vladivostok'),(1084,'Джарджан','dzardzan','','Russia',643,''),(794,'Джека Лондона','dzheka-londona','','Russia',643,'Asia/Magadan'),(1085,'Джикимда','dzhikimda','','Russia',643,''),(573,'Джубга','dzgugba','','Russia',643,''),(1829,'Дзержинск','dzerzinsk','','Russia',643,'Europe/Moscow'),(86725,'Дзержинск','Dzerzhinsk','','Russia',643,'Europe/Moscow'),(10942,'Дзержинский','Dgerginskiy','','Russia',643,'Europe/Moscow'),(607,'Дзержинское','dzerzinskoe','','Russia',643,'Europe/Moscow'),(1830,'Дивногорск','divnogorsk','','Russia',643,'Asia/Krasnoyarsk'),(1221,'Дивное','divnoe','','Russia',643,''),(12173,'Дигора','Digora','','Russia',643,'Europe/Moscow'),(1831,'Диксон','dikson','','Russia',643,'Asia/Krasnoyarsk'),(1834,'Димитровград','dimitrovgrad','','Russia',643,'Europe/Moscow'),(1832,'Динская','dinskaia','','Russia',643,'Europe/Volgograd'),(1833,'Дмитриев-Льговский','dmitriev lgovskiy','','Russia',643,'Europe/Moscow'),(824,'Дмитров','dmitrov','','Russia',643,'Europe/Moscow'),(959,'Дмитровск-Орловский','dmitrovsk-orlovskiy','','Russia',643,'Europe/Moscow'),(751,'Днепродзержинск','kamenskoe','','Russia',643,'Asia/Kamchatka'),(989,'Дно','dno','','Russia',643,'Europe/Moscow'),(1835,'Добрянка','dobrianka','','Russia',643,'Asia/Yekaterinburg'),(888,'Довольное','dovolnoe','','Russia',643,'Asia/Novosibirsk'),(10944,'Долгопрудный','Dolgoprudniy','','Russia',643,'Europe/Moscow'),(574,'Должанская','dolzhanskaja','','Russia',643,'Europe/Volgograd'),(668,'Долиновка','dolinovka','','Russia',643,'Europe/Moscow'),(1836,'Долинск','dolinsk','','Russia',643,'Asia/Sakhalin'),(1837,'Домбай','dombai','','Russia',643,'Europe/Moscow'),(825,'Домодедово','domodedowo','','Russia',643,'Europe/Moscow'),(86724,'Домодедово','Domodedovo International Airport','','Russia',643,'Europe/Moscow'),(12338,'Донецк','Doneck','','Russia',643,'Europe/Moscow'),(1839,'Донской','donskoe','','Russia',643,'Europe/Moscow'),(12339,'Донской','Donskoi','','Russia',643,'Europe/Moscow'),(12984,'Донской','Donskoy','','Russia',643,'Europe/Moscow'),(1840,'Дорогобуж','dorogobuz','','Russia',643,'Europe/Moscow'),(1086,'Дорожный','dorozhnyi','','Russia',643,'Europe/Simferopol'),(10947,'Дрезна','Drezna','','Russia',643,'Europe/Moscow'),(12207,'Дрожжаное','Drogganoe','','Russia',643,'Asia/Harbin'),(10948,'Дружба','Drugda','','Russia',643,''),(1841,'Дубенки','dubenki','','Russia',643,'Europe/Moscow'),(10949,'Дубинино','Dubinino','','Russia',643,'Asia/Krasnoyarsk'),(1842,'Дубна','dubna','','Russia',643,'Europe/Moscow'),(1843,'Дубовка','dubovka','','Russia',643,'Europe/Volgograd'),(381,'Дуван','duvan','','Russia',643,'Asia/Yekaterinburg'),(9299,'Дугда','Dudga','','Russia',643,''),(1386,'Дудинка','dudinka','','Russia',643,'Asia/Krasnoyarsk'),(1844,'Дульдурга','duldurga','','Russia',643,'Asia/Yakutsk'),(10650,'Дунай','Dunay','','Russia',643,'Asia/Vladivostok'),(1845,'Духовщина','duhovshina','','Russia',643,'Europe/Moscow'),(1846,'Дылым','dilim','','Russia',643,'Asia/Magadan'),(1847,'Дюртюли','diurtiuli','','Russia',643,'Asia/Yekaterinburg'),(9551,'Дятьково','Duatykovo','','Russia',643,'Europe/Moscow'),(12342,'Егорлыкская','Egorlikskaya','','Russia',643,'Europe/Moscow'),(826,'Егорьевск','egorevsk','','Russia',643,'Europe/Moscow'),(575,'Ейск','ejsk','','Russia',643,'Europe/Moscow'),(86885,'Ейск','Yeysk','','Russia',643,'Europe/Moscow'),(1281,'Екатеринбург','ekaterinburg','','Russia',643,'Asia/Yekaterinburg'),(1438,'Екатерино-Никольское','ekaterino-nikolskoe','','Russia',643,''),(1848,'Екатеринославка','ekaterinoslavka','','Russia',643,'Asia/Yakutsk'),(1309,'Елабуга','elabuga','','Russia',643,'Europe/Moscow'),(1849,'Еланцы','elanci','','Russia',643,''),(445,'Елань','elan','','Russia',643,'Europe/Volgograd'),(12678,'Елань','Elany','','Russia',643,'Asia/Vladivostok'),(1053,'Елатьма','elatma','','Russia',643,'Europe/Moscow'),(776,'Елец','elec','','Russia',643,'Europe/Moscow'),(1850,'Елизово','elizovo','','Russia',643,'Asia/Kamchatka'),(1851,'Елово','elovo','','Russia',643,'Asia/Yekaterinburg'),(1852,'Елховка','elhovka','','Russia',643,'Europe/Moscow'),(1853,'Ельня','elnia','','Russia',643,'Europe/Luxembourg'),(12735,'Ельня','Elynya','','Russia',643,'Europe/Moscow'),(1854,'Еманжелинск','emazelinsk','','Russia',643,'Asia/Yekaterinburg'),(1855,'Емва','emva','','Russia',643,'Europe/Moscow'),(1856,'Емельяново','emelianovo','','Russia',643,''),(608,'Енисейск','enisejsk','','Russia',643,'Asia/Krasnoyarsk'),(1857,'Енотаевка','enotaevka','','Russia',643,'Europe/Volgograd'),(484,'Ербогачен','erbogacen','','Russia',643,''),(609,'Ермаковское','ermakovskoe','','Russia',643,'Europe/Volgograd'),(10183,'Ермолино','Ermolino','','Russia',643,'Europe/Moscow'),(321,'Ерофей Павлович','erofej-pavlovi','','Russia',643,''),(1858,'Ершичи','ershichi','','Russia',643,'Europe/Moscow'),(1240,'Ершов','ersov','','Russia',643,''),(10955,'Ершов','Ershov','','Russia',643,'Europe/Volgograd'),(1594,'Ессей','essej','','Russia',643,'America/New_York'),(1859,'Ессентуки','esentuki','','Russia',643,'Europe/Moscow'),(86884,'Ессентуки','Yessentuki','','Russia',643,'Europe/Moscow'),(1860,'Еткуль','etkul','','Russia',643,'Asia/Yekaterinburg'),(1373,'Ефремов','efremov','','Russia',643,'Europe/Moscow'),(12766,'Железноводск','Geleznovodsk','','Russia',643,'Europe/Moscow'),(1861,'Железногорск','geleznogorsk','','Russia',643,'Europe/Moscow'),(86893,'Железногорск','Zheleznogorsk','','Russia',643,'Europe/Moscow'),(655,'Железнодорожный','zheleznodorozhniy','','Russia',643,'Europe/Moscow'),(10146,'Железнодорожный','Geleznodorogniy','','Russia',643,'Europe/Moscow'),(1324,'Жердевка','zerdevka','','Russia',643,'Europe/Moscow'),(485,'Жигалово','zigalovo','','Russia',643,'Asia/Irkutsk'),(1087,'Жиганск','zhigansk','','Russia',643,'Asia/Yakutsk'),(1863,'Жигулевск','giguliovsk','','Russia',643,'Europe/Samara'),(86894,'Жигулёвск','Zhigulevsk','','Russia',643,'Europe/Samara'),(348,'Жижгин','zizgin','','Russia',643,''),(660,'Жиздра','zhisdra','','Russia',643,''),(12346,'Жирнов','Girnov','','Russia',643,''),(9700,'Жирновск','Girnovsk','','Russia',643,'Europe/Volgograd'),(421,'Жуковка','zukovka','','Russia',643,'Europe/Moscow'),(10492,'Жуковка','Gukovka','','Russia',643,''),(10963,'Жуковский','Gukovskiy','','Russia',643,'Europe/Moscow'),(1528,'Забайкальск','zabajkalsk','','Russia',643,'Asia/Yakutsk'),(1864,'Заветное','zavetnoe','','Russia',643,'Europe/Moscow'),(322,'Завитая','zavitaja','','Russia',643,'Europe/Riga'),(1865,'Завитинск','zavitinsk','','Russia',643,'Asia/Yakutsk'),(1866,'Заводоуковск','zavodoukovsk','','Russia',643,'Asia/Yekaterinburg'),(9214,'Заводской','Zavodskoi','','Russia',643,'Europe/Moscow'),(9961,'Заволжск','Zavolgsk','','Russia',643,'Europe/Moscow'),(11275,'Заволжье','Zavolgye','','Russia',643,''),(1867,'Задонск','zadonsk','','Russia',643,'Europe/Moscow'),(1869,'Заинск','zainsk','','Russia',643,'Europe/Moscow'),(1870,'Закаменск','zakamensk','','Russia',643,'Asia/Irkutsk'),(486,'Залари','zalari','','Russia',643,'Asia/Irkutsk'),(393,'Замакта','zamokta','','Russia',643,''),(964,'Заметчино','zametcino','','Russia',643,''),(10494,'Заозерный','Zaozerniy','','Russia',643,'Europe/Kiev'),(11208,'Заозёрск','Zaozersk','','Russia',643,'Europe/Moscow'),(1871,'Западная Двина','zapadnaia dvina','','Russia',643,'Europe/Moscow'),(11210,'Заполярный','Zapoliarniy','','Russia',643,'Europe/Moscow'),(1872,'Зарайск','zaraisk','','Russia',643,'Europe/Moscow'),(86892,'Зарайск','Zarajsk','','Russia',643,'Europe/Moscow'),(844,'Зареченск','zarechensk','','Russia',643,'Europe/Moscow'),(9962,'Заречный','Zarecniy','','Russia',643,'Asia/Vladivostok'),(12680,'Заречный','Zapecniy','','Russia',643,''),(295,'Заринск','zarinsk','','Russia',643,'Asia/Omsk'),(845,'Зашеек','zacheek','','Russia',643,''),(487,'Заярск','zajarsk','','Russia',643,'Europe/Moscow'),(12013,'Звенигово','Zvenigovo','','Russia',643,'Europe/Moscow'),(1873,'Звенигород','zvenigorod','','Russia',643,'Europe/Moscow'),(12350,'Зверево','Zverevo','','Russia',643,'Europe/Moscow'),(729,'Звериноголовское','zverinogolovskoe','','Russia',643,'Asia/Yekaterinburg'),(889,'Здвинск','zdvinsk','','Russia',643,'Asia/Novosibirsk'),(13081,'Зеленец','Zelenec','','Russia',643,'Europe/Prague'),(1874,'Зеленогорск','zelenogorsk','','Russia',643,'Europe/Moscow'),(1879,'Зеленоград','zelenograd','','Russia',643,'Europe/Moscow'),(10150,'Зеленоградск','Zelenogradsk','','Russia',643,'Europe/Kaliningrad'),(2495,'Зеленодольск','Zelenodol\'sk','','Russia',643,'Europe/Moscow'),(1876,'Зеленокумск','zelenokumsk','','Russia',643,'Europe/Moscow'),(1877,'Зеленчукская','zelenchukskaia','','Russia',643,'Europe/Moscow'),(1878,'Земетчино','zemetchino','','Russia',643,'Europe/Moscow'),(1038,'Зерноград','zernograd','','Russia',643,'Europe/Moscow'),(323,'Зея','zeja','','Russia',643,'Asia/Yakutsk'),(382,'Зилаир','zilair','','Russia',643,'Asia/Yekaterinburg'),(488,'Зима','zima','','Russia',643,'Asia/Irkutsk'),(9653,'Зима','Sima','','Russia',643,'Asia/Irkutsk'),(1039,'Зимовники','zimovniki','','Russia',643,'Europe/Moscow'),(1506,'Златоуст','zlatoust','','Russia',643,'Asia/Yekaterinburg'),(1880,'Злынка','zklinka','','Russia',643,''),(296,'Змеиногорск','zmeinogorsk','','Russia',643,'Asia/Omsk'),(1881,'Знаменка','znamenka','','Russia',643,'Europe/Moscow'),(9448,'Знаменск','Znamensk','','Russia',643,'Europe/Kaliningrad'),(1882,'Знаменский','znamenskoe','','Russia',643,'Asia/Yekaterinburg'),(1004,'Золотой','zolotoj','','Russia',643,'Asia/Vladivostok'),(12040,'Зубова Поляна','Zubovaya Poliana','','Russia',643,''),(1883,'Зубцов','zubcov','','Russia',643,''),(1088,'Зырянка','zyrjanka','','Russia',643,'Asia/Magadan'),(1884,'Зырянское','zirianskoe','','Russia',643,''),(1885,'Ибреси','ibresi','','Russia',643,'Europe/Moscow'),(2471,'Ивангород','Ivangorod','','Russia',643,'Europe/Moscow'),(1886,'Ивановка','ivanovka','','Russia',643,'Asia/Vladivostok'),(470,'Иваново','Ivanovo','','Russia',643,'Europe/Moscow'),(10970,'Ивантеевка','Ivanteevka','','Russia',643,'Europe/Moscow'),(1282,'Ивдель','ivdel','','Russia',643,'Asia/Yekaterinburg'),(1887,'Иволгинск','ivolginsk','','Russia',643,'Asia/Irkutsk'),(610,'Игарка','igarka','','Russia',643,'Asia/Krasnoyarsk'),(2469,'Иглино','Iglino','','Russia',643,'Asia/Yekaterinburg'),(324,'Игнашино','ignasino','','Russia',643,''),(1889,'Игра','igra','','Russia',643,'Europe/Samara'),(1477,'Игрим','igrim','','Russia',643,'Asia/Yekaterinburg'),(611,'Идринское','idrinskoe','','Russia',643,'Europe/Moscow'),(1397,'Ижевск','izhevsk','','Russia',643,'Europe/Samara'),(551,'Ижма','izhma','','Russia',643,'Europe/Moscow'),(11845,'Избербаш','Izberbash','','Russia',643,'Europe/Moscow'),(1890,'Измалково','izmalkovo','','Russia',643,'Europe/Moscow'),(1891,'Изобильный','izobilnii','','Russia',643,''),(489,'Ика','ika','','Russia',643,'Asia/Irkutsk'),(1892,'Ики-Бурул','iki-burul','','Russia',643,'Europe/Moscow'),(1893,'Икряное','ikrianoe','','Russia',643,'Europe/Zaporozhye'),(10495,'Иланский','Ilanskiy','','Russia',643,'Asia/Krasnoyarsk'),(1894,'Илек','ilek','','Russia',643,'Europe/Moscow'),(1575,'Илирней','ilirnej','','Russia',643,''),(446,'Иловля','ilovlja','','Russia',643,''),(1252,'Ильинский','ilyinskiy','','Russia',643,'Asia/Kamchatka'),(10377,'Ильич','Ilyic','','Russia',643,'Europe/Istanbul'),(10378,'Ильский','Ilyskiy','','Russia',643,''),(1439,'Им. Полины Осипенко','im-poliny-osipovoi','','Russia',643,''),(1527,'Именные суффиксы в японском языке','dono','','Russia',643,'Asia/Yakutsk'),(490,'Инга','inga','','Russia',643,'Europe/Moscow'),(920,'Индига','indiga','','Russia',643,'Europe/Moscow'),(1089,'Индигирская','indigirskaja','','Russia',643,''),(12807,'Инжавино','Ingavino','','Russia',643,'Europe/Moscow'),(1401,'Инза','inza','','Russia',643,'Europe/Moscow'),(12769,'Иноземцево','Inozemcevo','','Russia',643,'Europe/Moscow'),(1402,'Инсар','insar','','Russia',643,'Europe/Moscow'),(11424,'Инской','Inskoy','','Russia',643,'Asia/Novokuznetsk'),(1895,'Инта','inta','','Russia',643,'Europe/Moscow'),(1896,'Ипатово','ipativo','','Russia',643,'Europe/Moscow'),(612,'Ирбейское','irbejskoe','','Russia',643,'Asia/Krasnoyarsk'),(12684,'Ирбит','Irbit','','Russia',643,'Asia/Yekaterinburg'),(1283,'Ирбит-Фомино','irbit-fomino','','Russia',643,'Asia/Yekaterinburg'),(12574,'Иргиз','Irgiz','','Russia',643,'Asia/Aqtobe'),(491,'Иркутск','irkutsk','','Russia',643,'Asia/Irkutsk'),(12685,'ИС','Is','','Russia',643,'Asia/Yekaterinburg'),(1897,'Исаклы','isakli','','Russia',643,'Europe/Istanbul'),(1898,'Исетское','isetskoe','','Russia',643,'Asia/Yekaterinburg'),(939,'Исилькуль','isilkul','','Russia',643,'Asia/Omsk'),(1090,'Исить','isit','','Russia',643,'Asia/Yakutsk'),(890,'Искитим','iskitim','','Russia',643,'Asia/Novosibirsk'),(11546,'Исса','Issa','','Russia',643,'Europe/Moscow'),(1899,'Истра','istra','','Russia',643,'Europe/Moscow'),(1900,'Исянгулово','isiangulovo','','Russia',643,'Asia/Yekaterinburg'),(13083,'Ишеевка','Isheevka','','Russia',643,'Europe/Moscow'),(1380,'Ишим','isim','','Russia',643,'Asia/Yekaterinburg'),(1901,'Ишимбай','ishimbai','','Russia',643,'Asia/Yekaterinburg'),(780,'Йошкар-Ола','joskar-ola','','Russia',643,'Europe/Moscow'),(86886,'Йошкар-Ола','Yoshkar-Ola','','Russia',643,'Europe/Moscow'),(394,'Кабанск','kabansk','','Russia',643,'Asia/Irkutsk'),(1005,'Кавалерово','kavalerovo','','Russia',643,'Asia/Vladivostok'),(1902,'Кавказская','kavkazskaia','','Russia',643,'Europe/Moscow'),(11754,'Кага','Kaga','','Russia',643,'Asia/Yekaterinburg'),(1903,'Кадом','kadom','','Russia',643,'Europe/Moscow'),(9809,'Кадуй','Kaduy','','Russia',643,'Europe/Moscow'),(1040,'Казанская','kazanskaja','','Russia',643,'Europe/Moscow'),(1905,'Казанское','kazanskoe','','Russia',643,'Asia/Yekaterinburg'),(1310,'Казань','kasan','','Russia',643,'Europe/Moscow'),(10044,'Казачинск','Kazacinsk','','Russia',643,''),(492,'Казачинское','kazachinskoe','','Russia',643,'Asia/Irkutsk'),(613,'Казачинское','kasachinskoe','','Russia',643,'Asia/Irkutsk'),(614,'Казыр','kasyr','','Russia',643,''),(10498,'Кайеркан','Kayerkan','','Russia',643,'Asia/Krasnoyarsk'),(1529,'Кайластуй','kajlastuj','','Russia',643,'Europe/Helsinki'),(1530,'Калакан','kalakan','','Russia',643,'Asia/Yakutsk'),(466,'Калач','kalac','','Russia',643,'Europe/Volgograd'),(1906,'Калач-на-Дону','kalach- na - donu','','Russia',643,'Europe/Volgograd'),(86738,'Калач-на-Дону','Kalach-na-Donu','','Russia',643,'Europe/Volgograd'),(940,'Калачинск','kalachinsk','','Russia',643,'Asia/Omsk'),(1907,'Калга','kalga','','Russia',643,'Asia/Yakutsk'),(350,'Калгачиха','kalgachiha','','Russia',643,'Europe/Moscow'),(531,'Калевала','kalevala','','Russia',643,'Europe/Moscow'),(12355,'Калинин','Kalinin','','Russia',643,'Europe/Moscow'),(656,'Калининград','kaliningrad','','Russia',643,'Europe/Kaliningrad'),(9305,'Калинино','Kalinino','','Russia',643,'Europe/Moscow'),(1241,'Калининск','kalininsk','','Russia',643,'Europe/Volgograd'),(1908,'Калининская','kalininskaia','','Russia',643,'Europe/Moscow'),(12356,'Калининская','Kalininskaya','','Russia',643,'Europe/Moscow'),(10603,'Калиновка','Kalinovka','','Russia',643,'Asia/Irkutsk'),(10245,'Калтан','Kaltan','','Russia',643,'Asia/Novokuznetsk'),(661,'Калуга','kaluga','','Russia',643,'Europe/Moscow'),(1910,'Калязин','kaliazin','','Russia',643,'Europe/Moscow'),(12687,'Кама','Kama','','Russia',643,'Europe/Samara'),(13055,'Камбарка','Kambarka','','Russia',643,'Europe/Samara'),(1911,'Каменка','kamenka','','Russia',643,'Europe/Moscow'),(12358,'Каменоломни','Kamenolomni','','Russia',643,'Europe/Moscow'),(11808,'Каменск','Kamensk','','Russia',643,'Asia/Irkutsk'),(1284,'Каменск-Уральский','kamensk-uralskiy','','Russia',643,'Asia/Yekaterinburg'),(1041,'Каменск-Шахтинский','kamensk-sahtinskiy','','Russia',643,'Europe/Moscow'),(297,'Камень-на-Оби','kamen-na-obi','','Russia',643,'Asia/Omsk'),(11630,'Камень-Рыболов','Kameny-Ribolov','','Russia',643,''),(9625,'Камешково','Kameshkovo','','Russia',643,'Europe/Moscow'),(1912,'Камское Устье','kamskoe ustie','','Russia',643,'Europe/Moscow'),(1913,'Камызяк','kamiziak','','Russia',643,'Europe/Volgograd'),(447,'Камышин','kamysin','','Russia',643,'Europe/Volgograd'),(1285,'Камышлов','kamyslov','','Russia',643,'Asia/Yekaterinburg'),(1500,'Канас','kanas','','Russia',643,'Europe/Moscow'),(846,'Кандалакша','kandalaksa','','Russia',643,'Europe/Moscow'),(86742,'Кандалакша','Kandalaksha','','Russia',643,'Europe/Moscow'),(11757,'Кандры','Kandri','','Russia',643,'Asia/Karachi'),(847,'Каневка','kanevka','','Russia',643,'Europe/Moscow'),(576,'Каневская','kanevskaja','','Russia',643,'Europe/Moscow'),(921,'Канин Нос','kanin-nos','','Russia',643,'Europe/Moscow'),(1092,'Кансай','kanku','','Russia',643,'Africa/Johannesburg'),(615,'Канск','kansk','','Russia',643,'Asia/Krasnoyarsk'),(1411,'Кантегир','kantegir','','Russia',643,'Asia/Krasnoyarsk'),(9874,'Кантемировка','Kantemirovka','','Russia',643,'Europe/Moscow'),(9626,'Карабаново','Karabanovo','','Russia',643,'Europe/Moscow'),(12216,'Карабаш','Karabash','','Russia',643,'Asia/Yekaterinburg'),(1914,'Карабудахкент','karabudahkent','','Russia',643,''),(10500,'Карабула','Karabula','','Russia',643,'Asia/Krasnoyarsk'),(11869,'Карабулак','Karabulak','','Russia',643,'Europe/Moscow'),(1915,'Карагай','karagai','','Russia',643,'Asia/Yekaterinburg'),(1916,'Караидель','karaidel','','Russia',643,'Asia/Yekaterinburg'),(1917,'Каракулино','karakulino','','Russia',643,'Europe/Samara'),(10048,'Карам','Karam','','Russia',643,'Asia/Irkutsk'),(891,'Карасук','karasuk','','Russia',643,'Asia/Novosibirsk'),(11847,'Карата','Karahta','','Russia',643,'Europe/Warsaw'),(616,'Каратузское','karatuzskoe','','Russia',643,'Asia/Krasnoyarsk'),(1918,'Караул','karaul','','Russia',643,'Europe/Volgograd'),(395,'Карафтит','karaftit','','Russia',643,'Asia/Irkutsk'),(1919,'Карачаевск','karachevsk','','Russia',643,'Europe/Moscow'),(422,'Карачев','karachev','','Russia',643,'Europe/Moscow'),(11279,'Карга','Karga','','Russia',643,'Asia/Novosibirsk'),(1920,'Каргаполье','kargopolie','','Russia',643,'Europe/Moscow'),(1349,'Каргасок','kargasok','','Russia',643,'Asia/Novosibirsk'),(892,'Каргат','kargat','','Russia',643,'Asia/Novosibirsk'),(351,'Каргополь','kargopol','','Russia',643,'Europe/Moscow'),(1921,'Кармаскалы','karmaskali','','Russia',643,'Asia/Yekaterinburg'),(12688,'Карпинск','Karpinsk','','Russia',643,'Asia/Yekaterinburg'),(352,'Карпогоры','karpogory','','Russia',643,'Europe/Moscow'),(1507,'Карталы','kartaly','','Russia',643,'Asia/Yekaterinburg'),(1531,'Карымская','karymskaja','','Russia',643,'Asia/Kamchatka'),(10049,'Карымское','Karimskoe','','Russia',643,''),(1922,'Касимов','kasimov','','Russia',643,'Europe/Moscow'),(1923,'Касли','kasli','','Russia',643,'Asia/Yekaterinburg'),(1924,'Каспийск','kaspiisk','','Russia',643,'Europe/Moscow'),(86743,'Каспийск','Kaspiysk','','Russia',643,'Europe/Moscow'),(1925,'Касторное','kastornoe','','Russia',643,'Europe/Moscow'),(1926,'Касумкент','kasumket','','Russia',643,''),(1478,'Касым-хан','kasym','','Russia',643,'Asia/Yekaterinburg'),(10050,'Ката','Kata','','Russia',643,'Asia/Irkutsk'),(1508,'Катав-Ивановск','katav-ivanovsk','','Russia',643,'Asia/Yekaterinburg'),(1927,'Катайск','kataisk','','Russia',643,'Asia/Yekaterinburg'),(1532,'Катугино','katugino','','Russia',643,'Asia/Yakutsk'),(617,'Кача','kaca','','Russia',643,'Europe/Belgrade'),(1928,'Качканар','kachkanar','','Russia',643,'Asia/Yekaterinburg'),(493,'Качуг','kacug','','Russia',643,''),(1929,'Кашары','kashari','','Russia',643,'Europe/Kiev'),(1334,'Кашин','kasin','','Russia',643,'Europe/Moscow'),(827,'Кашира','kahira','','Russia',643,'Africa/Cairo'),(1930,'Кашхатау','kashatau','','Russia',643,'Asia/Novokuznetsk'),(1931,'Кваркено','kvarkeno','','Russia',643,'Asia/Yekaterinburg'),(796,'Кегали','kegali','','Russia',643,'Asia/Magadan'),(429,'Кеда','keda','','Russia',643,'Asia/Tbilisi'),(552,'Кедва-Вом','kedva-vom','','Russia',643,''),(797,'Кедон','kedon','','Russia',643,'Asia/Magadan'),(10247,'Кедровка','Kedrovka','','Russia',643,'Asia/Novokuznetsk'),(1932,'Кежма','kezma','','Russia',643,''),(1933,'Кез','kez','','Russia',643,'Europe/Samara'),(692,'Кемерово','kemerovo','','Russia',643,'Asia/Novokuznetsk'),(619,'Кемчуг','kemcug','','Russia',643,''),(11900,'Кемь','Kemy','','Russia',643,''),(353,'Кемь-Порт','kem-port','','Russia',643,'Europe/Moscow'),(1935,'Кесова Гора','kesova gora','','Russia',643,'Europe/Moscow'),(1936,'Кетченеры','ketcheneri','','Russia',643,''),(12578,'Киевка','Kievka','','Russia',643,'Europe/Moscow'),(1938,'Кизел','kizel','','Russia',643,'Asia/Yekaterinburg'),(1509,'Кизильское','kizilskoe','','Russia',643,''),(11849,'Кизилюрт','Kiziliurt','','Russia',643,'Europe/Moscow'),(430,'Кизляр','kizljar','','Russia',643,'Europe/Moscow'),(86755,'Кизляр','Kizlyar','','Russia',643,'Europe/Moscow'),(1939,'Кизнер','kizner','','Russia',643,'Europe/Samara'),(1940,'Кикнур','kiknur','','Russia',643,'Europe/Volgograd'),(709,'Кильмезь','kilmes','','Russia',643,'Europe/Volgograd'),(12990,'Кимовск','Kimovsk','','Russia',643,'Europe/Moscow'),(1941,'Кимры','kimri','','Russia',643,''),(86751,'Кимры','Kimry','','Russia',643,'Europe/Moscow'),(11588,'Кин','Kin','','Russia',643,'Europe/Moscow'),(766,'Кингисепп','kingisepp','','Russia',643,'Europe/Moscow'),(12505,'Кинель','Kinely','','Russia',643,'America/Chicago'),(471,'Кинешма','kinesma','','Russia',643,'Europe/Moscow'),(86752,'Кинешма','Kineshma','','Russia',643,'Europe/Moscow'),(1943,'Киргиз-Мияки','kirgiz-miaki','','Russia',643,''),(1944,'Киреевск','kireevsk','','Russia',643,'Europe/Moscow'),(494,'Киренск','kirensk','','Russia',643,'Asia/Irkutsk'),(1945,'Киржач','kirzach','','Russia',643,'Europe/Moscow'),(86754,'Киржач','Kirzhach','','Russia',643,'Europe/Moscow'),(1946,'Кириллов','kirilov','','Russia',643,'Europe/Moscow'),(10981,'Кирилловка','Kirillovka','','Russia',643,'Europe/Samara'),(767,'Кириши','kirishi','','Russia',643,'Europe/Moscow'),(710,'Киров','kirov','','Russia',643,'Europe/Volgograd'),(1947,'Кирово-Чепецк','kirovo-cepetsk','','Russia',643,'Europe/Volgograd'),(86753,'Кирово-Чепецк','Kirovo-Chepetsk','','Russia',643,'Europe/Volgograd'),(12689,'Кировоград','Kirovograd','','Russia',643,'Europe/Zaporozhye'),(1948,'Кировск','kirovsk','','Russia',643,'Europe/Moscow'),(1006,'Кировский','kirovskij','','Russia',643,'Asia/Vladivostok'),(9306,'Кировский','Kirovskiy','','Russia',643,'Asia/Vladivostok'),(711,'Кирс','kirs','','Russia',643,'Europe/Volgograd'),(1325,'Кирсанов','kirsanov','','Russia',643,'Europe/Moscow'),(693,'Киселёвск','kiselevsk','','Russia',643,'Asia/Novokuznetsk'),(980,'Кислица клубненосная','oca','','Russia',643,'Asia/Krasnoyarsk'),(9712,'Кислово','Kislovo','','Russia',643,'Europe/Volgograd'),(1949,'Кисловодск','kislovodsk','','Russia',643,'Europe/Moscow'),(1950,'Кичменгский Городок','kichmengskiy gorodok','','Russia',643,'Europe/Moscow'),(1951,'Киясово','kiasovo','','Russia',643,'Europe/Moscow'),(1952,'Клетня','kletnia','','Russia',643,'Europe/Warsaw'),(9557,'Климово','Klimovo','','Russia',643,'Europe/Moscow'),(828,'Клин','klin','','Russia',643,'Europe/Moscow'),(1953,'Клинцы','klinci','','Russia',643,'Europe/Moscow'),(298,'Ключи','kljuci','','Russia',643,'Asia/Kamchatka'),(670,'Ключи','kluchi','','Russia',643,'Asia/Kamchatka'),(10503,'Ключи','Kliuci','','Russia',643,''),(12506,'Клявлино','Kliavlino','','Russia',643,'Europe/Samara'),(849,'Ковда','kovda','','Russia',643,'Europe/Moscow'),(850,'Ковдор','kovdor','','Russia',643,'Europe/Moscow'),(1954,'Ковров','kovrov','','Russia',643,'Europe/Moscow'),(12362,'Ковылкин','Kovilkin','','Russia',643,''),(1955,'Ковылкино','kovilkovo','','Russia',643,''),(1479,'Когалым','kogalym','','Russia',643,'Asia/Yekaterinburg'),(1956,'Кодинск','kodinsk','','Russia',643,'Asia/Krasnoyarsk'),(1350,'Кожевниково','kozevnikovo','','Russia',643,'Asia/Novosibirsk'),(1957,'Козельск','kozelsk','','Russia',643,'Europe/Moscow'),(1958,'Козловка','kozlovka','','Russia',643,'Europe/Moscow'),(781,'Козьмодемьянск','kozmodemjzns','','Russia',643,'Europe/Moscow'),(1959,'Койгородок','koigorodok','','Russia',643,'Europe/Moscow'),(354,'Койнас','kojnas','','Russia',643,''),(1960,'Кола','kola','','Russia',643,'Europe/Moscow'),(620,'Колба','kolba','','Russia',643,'Asia/Novokuznetsk'),(922,'Колгуев Северный','kolguevb-sever','','Russia',643,''),(532,'Колежма','kolegma','','Russia',643,''),(10670,'Коли','Koli','','Russia',643,'Europe/Moscow'),(723,'Кологрив','kologriv','','Russia',643,'Europe/Moscow'),(829,'Коломна','kolomna','','Russia',643,'Europe/Moscow'),(1961,'Колосовка','kolosovka','','Russia',643,'Asia/Omsk'),(1351,'Колпашево','kolpasevo','','Russia',643,'Asia/Novosibirsk'),(2473,'Колпино','Kolpino','','Russia',643,'Europe/Moscow'),(893,'Колывань','kolyvan','','Russia',643,'Asia/Novosibirsk'),(1286,'Кольцово','kolcovo','','Russia',643,''),(11584,'Кольчуг','Kolycug','','Russia',643,'Europe/Helsinki'),(9627,'Кольчугино','Kolycugino','','Russia',643,''),(10505,'Кома','Koma','','Russia',643,'Asia/Krasnoyarsk'),(1412,'Коммунар','kommunar','','Russia',643,'Asia/Krasnoyarsk'),(1253,'Комрво','komrvo','','Russia',643,'Europe/Moscow'),(1510,'Комсомолец','komsomolec','','Russia',643,'Asia/Krasnoyarsk'),(9966,'Комсомольск','Komsomolysk','','Russia',643,'Asia/Vladivostok'),(1441,'Комсомольск-на-Амуре','komsomolsk-na-amure','','Russia',643,'Asia/Vladivostok'),(1962,'Комсомольский','kosmomolskiy','','Russia',643,'Asia/Qyzylorda'),(12043,'Комсомольский','Komsomolyskiy','','Russia',643,'Asia/Qyzylorda'),(1963,'Конаково','konakovo','','Russia',643,'Europe/Moscow'),(1964,'Кондинское','kondinskoe','','Russia',643,''),(1965,'Кондоль','kondol','','Russia',643,'Europe/Moscow'),(694,'Кондома','kondoma','','Russia',643,'Asia/Novokuznetsk'),(533,'Кондопога','kondopoga','','Russia',643,'Europe/Moscow'),(10189,'Кондрово','Kondrovo','','Russia',643,'Europe/Moscow'),(355,'Конево','konevo','','Russia',643,'Europe/Moscow'),(1966,'Коноша','konosha','','Russia',643,'Europe/Moscow'),(1967,'Константиновка','konstantinovka','','Russia',643,'Asia/Sakhalin'),(10292,'Константиновка','Kostantinovka','','Russia',643,'Asia/Sakhalin'),(1042,'Константиновск','konstantinovsk','','Russia',643,'Europe/Moscow'),(13246,'Копейск','Kopeysk','','Russia',643,'Asia/Yekaterinburg'),(1968,'Копьево','kopievo','','Russia',643,'Europe/Moscow'),(12460,'Кораблино','Korablino','','Russia',643,'Europe/Moscow'),(1969,'Коренево','korenovo','','Russia',643,'Europe/Zagreb'),(10993,'Коренёво','Koreniovo','','Russia',643,''),(1970,'Кореновск','korenovsk','','Russia',643,'Europe/Moscow'),(2475,'Коркино','Korkino','','Russia',643,'Asia/Yekaterinburg'),(1971,'Кормиловка','kormilovka','','Russia',643,'Asia/Omsk'),(1972,'Королёв','korolev','','Russia',643,'Europe/Moscow'),(1973,'Короча','korocha','','Russia',643,'Europe/Moscow'),(1254,'Корсаков','korsakov','','Russia',643,'Asia/Sakhalin'),(752,'Корф','korf','','Russia',643,'Asia/Anadyr'),(2474,'Корфовский','Korfovskiy','','Russia',643,'Asia/Vladivostok'),(1974,'Коряжма','koriazma','','Russia',643,'Europe/Moscow'),(973,'Коса','kosa','','Russia',643,'Asia/Yekaterinburg'),(553,'Кослан','koslan','','Russia',643,'Europe/Moscow'),(1975,'Костомукша','kostomursha','','Russia',643,'Europe/Moscow'),(86758,'Костомукша','Kostomuksha','','Russia',643,'Europe/Moscow'),(724,'Кострома','kostroma','','Russia',643,'Europe/Moscow'),(10996,'Котельники','Kotelyniki','','Russia',643,'Europe/Moscow'),(1976,'Котельниково','kotelnikovo','','Russia',643,'Europe/Volgograd'),(712,'Котельнич','kotelnic','','Russia',643,'Europe/Moscow'),(356,'Котлас','kotlas','','Russia',643,'Europe/Moscow'),(9717,'Котово','Kotovo','','Russia',643,'Europe/Volgograd'),(12809,'Котовск','Kotovsk','','Russia',643,'Europe/Moscow'),(9967,'Кохма','Kohma','','Russia',643,'Europe/Moscow'),(974,'Кочево','kochevo','','Russia',643,'Asia/Yekaterinburg'),(894,'Коченёво','kocenevo','','Russia',643,'Asia/Novosibirsk'),(11428,'Коченево','Kocenovo','','Russia',643,''),(895,'Кочки','kochki','','Russia',643,'Asia/Omsk'),(12776,'Кочубеевское','Kocubeevskoe','','Russia',643,''),(431,'Кочубей','kocubej','','Russia',643,''),(279,'Кош-Агач','kosh-agach','','Russia',643,'Asia/Omsk'),(1977,'Кошки','koshki','','Russia',643,'Europe/Samara'),(695,'Крапивино','krapivino','','Russia',643,'Europe/Moscow'),(10999,'Красково','Kraskovo','','Russia',643,'Europe/Moscow'),(423,'Красная Гора','krasnaja-gora','','Russia',643,'Europe/Moscow'),(1978,'Красная Горка','krasnaia gorka','','Russia',643,'Europe/Moscow'),(1979,'Красная Поляна','krasnaia poliana','','Russia',643,'Europe/Zaporozhye'),(12367,'Красная Поляна','Krasnaya Poliana','','Russia',643,'Europe/Volgograd'),(86760,'Красная Поляна','Krasnaya Polyana','','Russia',643,'Europe/Volgograd'),(1980,'Красноармейск','krasnoarmeisk','','Russia',643,'Europe/Volgograd'),(1981,'Красноборск','krasnoborsk','','Russia',643,'Europe/Moscow'),(10250,'Краснобродский','Krasnobrodskiy','','Russia',643,'Asia/Novokuznetsk'),(1982,'Красновишерск','krasnovishersk','','Russia',643,'Asia/Yekaterinburg'),(1222,'Красногвардейское','krasnogvardejskoe','','Russia',643,''),(1984,'Красногорск','krasnogorsk','','Russia',643,'Europe/Moscow'),(12017,'Красногорский','Krasnogorskiy','','Russia',643,'Asia/Yekaterinburg'),(577,'Краснодар','krasnodar','','Russia',643,'Europe/Moscow'),(696,'Красное','krasnoe','','Russia',643,'Asia/Anadyr'),(11002,'Краснозаводск','Krasnozavodsk','','Russia',643,'Europe/Moscow'),(11429,'Краснозерское','Krasnoozerskoe','','Russia',643,'Asia/Novosibirsk'),(10152,'Краснознаменск','Krasnoznamensk','','Russia',643,'Europe/Moscow'),(1985,'Краснокаменск','krasnokamensk','','Russia',643,'Asia/Yakutsk'),(1986,'Краснокамск','krasnokamsk','','Russia',643,'Asia/Yekaterinburg'),(896,'Красноозерск','krasnoozersk','','Russia',643,'Europe/Moscow'),(9718,'Краснооктябрьский','Krasnooktiabrskiy','','Russia',643,''),(13362,'Красноселькуп','Krasnoselykup','','Russia',643,'Europe/Moscow'),(1610,'Красноселькупск','krasnoselkups','','Russia',643,'Europe/Moscow'),(784,'Краснослободск','krasnoslobodsk','','Russia',643,'Europe/Volgograd'),(1987,'Краснотуранск','krasnoutransk','','Russia',643,'Asia/Krasnoyarsk'),(1988,'Краснотурьинск','krasnoturinsk','','Russia',643,'Asia/Yekaterinburg'),(1989,'Красноуральск','krasnouralsk','','Russia',643,'Asia/Yekaterinburg'),(1990,'Красноусольский','krasnousolskiy','','Russia',643,'Europe/Moscow'),(1287,'Красноуфимск','krasnoufimsk','','Russia',643,'Asia/Yekaterinburg'),(299,'Краснощеково','krasnoscekovo','','Russia',643,''),(852,'Краснощелье','krasnoscele','','Russia',643,'Europe/Moscow'),(621,'Красноярск','krasnojarsk','','Russia',643,'Asia/Krasnoyarsk'),(875,'Красные Баки','krasnye-baki','','Russia',643,'Europe/Moscow'),(1991,'Красный','krasniy','','Russia',643,'Europe/Moscow'),(1242,'Красный Кут','krasnyj-kut','','Russia',643,'Europe/Volgograd'),(9882,'Красный Лиман','Krasniy Liman','','Russia',643,'Europe/Moscow'),(11681,'Красный Луч','Krasniy Luc','','Russia',643,'Europe/Zaporozhye'),(9633,'Красный Октябрь','Krasniy Oktiabry','','Russia',643,'Europe/Moscow'),(12371,'Красный Сулин','Krasniy Sulin','','Russia',643,'Europe/Moscow'),(1335,'Красный Холм','krasnyj-holm','','Russia',643,''),(1533,'Красный Чикой','krasnyj-cikoj','','Russia',643,''),(1007,'Красный Яр','krasnyj-jar','','Russia',643,''),(9719,'Красный Яр','Krasniy Yar','','Russia',643,'Europe/Volgograd'),(9229,'Кременчуг','Kremenchug','','Russia',643,'Asia/Almaty'),(1095,'Крест-Хальджай','krest-haldzhai','','Russia',643,'Europe/Moscow'),(1992,'Крестцы','krestci','','Russia',643,''),(897,'Крещенка','krescenka','','Russia',643,'Europe/Vilnius'),(1993,'Кривошеино','krivosheino','','Russia',643,'Asia/Novosibirsk'),(12373,'Кривянская','Krivianskaya','','Russia',643,'Europe/Moscow'),(578,'Кропоткин Пётр Алексеевич','kropotkin','','Russia',643,'Europe/Moscow'),(1994,'Крутинка','krutinka','','Russia',643,'Asia/Omsk'),(1995,'Крыловская','krilovskaia','','Russia',643,'Europe/Moscow'),(10388,'Крыловская','Krilovskaya','','Russia',643,'Europe/Moscow'),(12375,'Крым','Krim','','Russia',643,'Europe/Simferopol'),(579,'Крымск','krymsk','','Russia',643,'Europe/Moscow'),(11291,'Кстово','Kstovo','','Russia',643,'Europe/Moscow'),(580,'Кубанская','kubanskaya','','Russia',643,'Europe/Moscow'),(1996,'Кубинка','kubinka','','Russia',643,'Europe/Moscow'),(1997,'Кувандык','kuvandik','','Russia',643,'Asia/Yekaterinburg'),(1998,'Кувшиново','kuvshinovo','','Russia',643,'Europe/Moscow'),(534,'Куганаволок','kugonavolok','','Russia',643,'Europe/Moscow'),(13310,'Кугеси','Kugesi','','Russia',643,'Europe/Moscow'),(975,'Кудымкар','kudymkar','','Russia',643,'Asia/Yekaterinburg'),(1999,'Куеда','kueda','','Russia',643,'Asia/Yekaterinburg'),(2000,'Куженер','kuzener','','Russia',643,''),(697,'Кузедеево','kusedeevo','','Russia',643,''),(2001,'Кузнецк','kuzneck','','Russia',643,'Europe/Moscow'),(86765,'Кузнецк','Kuznetsk','','Russia',643,'Europe/Moscow'),(1596,'Кузьмовка','kuzmovka','','Russia',643,'Europe/Zaporozhye'),(2003,'Куйбышево','kuibishevo','','Russia',643,''),(2004,'Куйтун','kuituk','','Russia',643,'Asia/Yakutsk'),(12225,'Кукмор','Kukmor','','Russia',643,'Europe/Moscow'),(2005,'Кулебаки','kulebaki','','Russia',643,'Europe/Moscow'),(12377,'Кулешовка','Kuleshovka','','Russia',643,'Europe/Moscow'),(12589,'Куликовка','Kulikovka','','Russia',643,'Europe/Moscow'),(495,'Култук','kultuk','','Russia',643,'Asia/Irkutsk'),(798,'Кулу','kulu','','Russia',643,'Asia/Magadan'),(2006,'Кулунда','kulunda','','Russia',643,'Asia/Omsk'),(713,'Кумены','kumeny','','Russia',643,'Europe/Volgograd'),(2007,'Кумертау','kumertau','','Russia',643,'Asia/Yekaterinburg'),(2008,'Кумух','kumuh','','Russia',643,''),(976,'Кунгур','kungur','','Russia',643,'Asia/Yekaterinburg'),(2009,'Кунгуртуг','kungurtug','','Russia',643,'Asia/Krasnoyarsk'),(898,'Купино','kupino','','Russia',643,'Asia/Novosibirsk'),(1442,'Кур','kur','','Russia',643,'Asia/Vladivostok'),(622,'Курагино','kuragino','','Russia',643,'Asia/Krasnoyarsk'),(730,'Курган','kurgan','','Russia',643,'Asia/Yekaterinburg'),(2011,'Курганинск','kurganinsk','','Russia',643,'Europe/Moscow'),(623,'Курейка','kureika','','Russia',643,'Asia/Krasnoyarsk'),(1255,'Курильск','kurilsk','','Russia',643,'Asia/Magadan'),(2012,'Курманаевка','kurmanaevka','','Russia',643,'Asia/Yekaterinburg'),(11012,'Куровское','Kurovskoe','','Russia',643,'Europe/Moscow'),(2013,'Курсавка','kursavka','','Russia',643,'Europe/Moscow'),(741,'Курск','kursk','','Russia',643,'Europe/Moscow'),(12778,'Курская','Kutskaya','','Russia',643,'Asia/Yekaterinburg'),(731,'Куртамыш','kurtamysh','','Russia',643,'Asia/Yekaterinburg'),(396,'Курумкан','kurumkan','','Russia',643,'Asia/Irkutsk'),(1443,'Курун-Урях','kurun-urjah','','Russia',643,'Asia/Vladivostok'),(13280,'Курчалой','Kurcaloy','','Russia',643,''),(2014,'Курчатов','kurchatov','','Russia',643,'Europe/Moscow'),(13250,'Куса','Kusa','','Russia',643,'Asia/Yekaterinburg'),(10390,'Кутаис','Kutais','','Russia',643,'Europe/Moscow'),(2015,'Кутулик','kutulik','','Russia',643,'Asia/Irkutsk'),(1288,'Кушва','kushva','','Russia',643,'Asia/Yekaterinburg'),(2016,'Кушнаренково','kushnarenkovo','','Russia',643,'Asia/Yekaterinburg'),(581,'Кущевская','kuscevskaja','','Russia',643,'Europe/Moscow'),(1316,'Кызыл','kyzyl','','Russia',643,'Asia/Krasnoyarsk'),(1536,'Кыра','kyra','','Russia',643,'Asia/Yakutsk'),(496,'Кырен','kyren','','Russia',643,'Asia/Irkutsk'),(1289,'Кытлым','kytlym','','Russia',643,'Asia/Yekaterinburg'),(899,'Кыштовка','kystovk','','Russia',643,'Asia/Novosibirsk'),(2018,'Кыштым','kishtim','','Russia',643,''),(86766,'Кыштым','Kyshtym','','Russia',643,'Asia/Yekaterinburg'),(1097,'Кюсюр','kjusjur','','Russia',643,'Europe/Moscow'),(397,'Кяхта','kjahta','','Russia',643,'Asia/Irkutsk'),(799,'Лабазная','labaznaja','','Russia',643,''),(2019,'Лабинск','labinsk','','Russia',643,'Europe/Moscow'),(2021,'Лагань','lazan','','Russia',643,'Europe/Prague'),(11907,'Ладва','Ladva','','Russia',643,'Europe/Moscow'),(10392,'Ладожская','Ladogskaya','','Russia',643,''),(13156,'Лазарев','lazarev','','Russia',643,'Asia/Sakhalin'),(2023,'Лазаревское','lazarevskoe','','Russia',643,'Europe/Moscow'),(1311,'Лаишево','laishevo','','Russia',643,'Europe/Moscow'),(9635,'Лакинск','Lakinsk','','Russia',643,'Europe/Moscow'),(714,'Лальск','lalsk','','Russia',643,'Europe/Volgograd'),(1481,'Ларьяк','larjak','','Russia',643,'Asia/Yekaterinburg'),(13210,'Лаут','Laut','','Russia',643,'Asia/Yekaterinburg'),(11908,'Лахденпохья','Lahdenpohya','','Russia',643,'Europe/Moscow'),(10253,'Лебеди','Lebedi','','Russia',643,'Europe/Moscow'),(2024,'Лебедянь','lebedian','','Russia',643,'Europe/Moscow'),(624,'Лебяжье','lebjazhe','','Russia',643,'Europe/Zaporozhye'),(778,'Лев Толстой','lev-tolstoj','','Russia',643,'Europe/Moscow'),(2025,'Леваши','levashi','','Russia',643,'Europe/Moscow'),(12780,'Левокумское','Levokumskoe','','Russia',643,'Europe/Moscow'),(2026,'Ленинградская','leningradskaia','','Russia',643,'Europe/Moscow'),(2027,'Лениногорск','leninogorsk','','Russia',643,'Europe/Moscow'),(2029,'Ленинск','leninsk','','Russia',643,'Europe/Volgograd'),(2028,'Ленинск-Кузнецкий','leninsk-kuzneckii','','Russia',643,'Europe/Volgograd'),(12104,'Ленинский','Leninskiy','','Russia',643,'Europe/Moscow'),(1444,'Ленинское','leninskoe','','Russia',643,'Asia/Vladivostok'),(1098,'Ленск','lensk','','Russia',643,'Asia/Yakutsk'),(12781,'Лермонтов Михаил Юрьевич','Lermontov','','Russia',643,'Europe/Moscow'),(1445,'Лермонтовка','lermontovka','','Russia',643,'Asia/Vladivostok'),(1008,'Лесё','laso','','Russia',643,'Europe/Vilnius'),(2030,'Лесное','lesnoe','','Russia',643,'Asia/Omsk'),(10295,'Лесной','Lesnoy','','Russia',643,'Europe/Volgograd'),(1009,'Лесозаводск','lesozavodsk','','Russia',643,'Asia/Vladivostok'),(10513,'Лесосибирск','Lesosibirsk','','Russia',643,'Asia/Krasnoyarsk'),(10517,'Лесосибирск','Maklakovo','','Russia',643,'Asia/Krasnoyarsk'),(2032,'Летняя Ставка','letniaia stavka','','Russia',643,''),(1482,'Леуши','leusi','','Russia',643,'Asia/Krasnoyarsk'),(357,'Лешуконское','lesukonskoe','','Russia',643,'Europe/Moscow'),(11635,'Ливадия','Livadiya','','Russia',643,'Asia/Vladivostok'),(2042,'Ливан','liban','','Russia',643,'Asia/Beirut'),(960,'Ливны','livny','','Russia',643,'Europe/Moscow'),(11018,'Ликино-Дулёво','Likino','','Russia',643,'Europe/Moscow'),(11019,'Ликино-Дулёво','Likino-Dulevo','','Russia',643,'Europe/Moscow'),(2033,'Лиман','liman','','Russia',643,'Europe/Volgograd'),(11295,'Линда','Linda','','Russia',643,'Europe/Moscow'),(9723,'Линёво','Liniovo','','Russia',643,'Europe/Moscow'),(11430,'Линево','Linevo','','Russia',643,'Asia/Novosibirsk'),(779,'Липецк','lipeck','','Russia',643,'Europe/Moscow'),(86769,'Липецк','Lipetsk','','Russia',643,'Europe/Moscow'),(467,'Лиски','liski','','Russia',643,'Europe/Moscow'),(10062,'Листвянка','Listvianka','','Russia',643,'Asia/Irkutsk'),(1446,'Литке','litke','','Russia',643,'Asia/Yekaterinburg'),(12381,'Лиховской','Lihovskoy','','Russia',643,'Europe/Moscow'),(2034,'Лихославль','lihoslavl','','Russia',643,'Europe/Moscow'),(9458,'Лобня','Marfino','','Russia',643,'Europe/Moscow'),(11020,'Лобня','Lobnya','','Russia',643,'Europe/Moscow'),(853,'Ловозеро','lovozero','','Russia',643,'Europe/Moscow'),(768,'Лодейное поле','lodejnoe-pole','','Russia',643,'Europe/Moscow'),(86770,'Лодейное Поле','Lodeynoye Pole','','Russia',643,'Europe/Moscow'),(9234,'Локоть','Lokoty','','Russia',643,'Europe/Moscow'),(325,'Локшак','loksak','','Russia',643,'Europe/Istanbul'),(13409,'Лом','Lom','','Russia',643,'Europe/Volgograd'),(2035,'Лонг-Юган','long-iugan','','Russia',643,''),(10393,'Лоо','Loo','','Russia',643,'Europe/Moscow'),(11021,'Лопатинский','Lopatinskiy','','Russia',643,'Europe/Moscow'),(326,'Лопча','lopcha','','Russia',643,'Asia/Yakutsk'),(11023,'Лосино-Петровский','Losinovo-Petrovskiy','','Russia',643,''),(625,'Лосиноборское','losinoborskoe','','Russia',643,'Asia/Krasnoyarsk'),(2037,'Лотошино','lotoshino','','Russia',643,'Europe/Moscow'),(2038,'Луга','luga','','Russia',643,'Europe/Moscow'),(13212,'Луговой','Lugovoy','','Russia',643,'Asia/Yekaterinburg'),(9394,'Луза','Luza','','Russia',643,'Europe/Volgograd'),(876,'Лукоянов','lukojanov','','Russia',643,'Europe/Moscow'),(2039,'Лух','luh','','Russia',643,'Europe/Kiev'),(2040,'Луховицы','luhovici','','Russia',643,'Europe/Moscow'),(11637,'Лучегорск','Lucegorsk','','Russia',643,''),(877,'Лысково','lyskovo','','Russia',643,'Europe/Moscow'),(2041,'Лысые Горы','lisie gori','','Russia',643,''),(977,'Лысьва','lysva','','Russia',643,'Asia/Yekaterinburg'),(11027,'Лыткарино','Litkarino','','Russia',643,'Europe/Moscow'),(11026,'Львовский','Lyvovskiy','','Russia',643,'Europe/Moscow'),(742,'Льгов','lgov','','Russia',643,'Europe/Moscow'),(2043,'Люберцы','liuberci','','Russia',643,'Europe/Moscow'),(11464,'Любинский','Liubinskiy','','Russia',643,'Europe/Moscow'),(10194,'Людиново','Liudinovo','','Russia',643,'Europe/Moscow'),(13058,'Люк','Liuk','','Russia',643,'Europe/Samara'),(10296,'Лянгасово','Liangasovo','','Russia',643,'Europe/Volgograd'),(12106,'Маар','Maar','','Russia',643,'Europe/Helsinki'),(800,'Магадан','magadan','','Russia',643,'Asia/Magadan'),(11870,'Магас','Magas','','Russia',643,'Europe/Moscow'),(327,'Магдагачи','magdagaci','','Russia',643,''),(1511,'Магнитогорск','magnitogorsk','','Russia',643,'Asia/Yekaterinburg'),(13159,'Маго','Mago','','Russia',643,'Asia/Vladivostok'),(801,'Мадаун','madaun','','Russia',643,'Asia/Magadan'),(2044,'Маджалис','mazdalis','','Russia',643,''),(328,'Мазаново','mazanovo','','Russia',643,'Asia/Yakutsk'),(274,'Майкоп','majkop','','Russia',643,'Europe/Moscow'),(86777,'Майкоп','Maykop','','Russia',643,'Europe/Moscow'),(2045,'Майма','maima','','Russia',643,'Asia/Omsk'),(1353,'Майск','majsk','','Russia',643,'Europe/Moscow'),(10134,'Майский','Mayskiy','','Russia',643,'Europe/Moscow'),(2046,'Майя','maia','','Russia',643,'Asia/Vladivostok'),(2047,'Макаров','makarov','','Russia',643,'Asia/Sakhalin'),(12230,'Макаровка','Makarovka','','Russia',643,'Europe/Moscow'),(10297,'Макарье','Makarye','','Russia',643,'Europe/Moscow'),(2048,'Макарьев','makariev','','Russia',643,'Europe/Moscow'),(1336,'Максатиха','maksatiha','','Russia',643,'Europe/Moscow'),(733,'Макушино','makusino','','Russia',643,'Asia/Yekaterinburg'),(86774,'Макушино','Makushino','','Russia',643,'Asia/Yekaterinburg'),(11029,'Малаховка','Malahovka','','Russia',643,'Europe/Moscow'),(2049,'Малая Вишера','malaia vishera','','Russia',643,'Europe/Moscow'),(86775,'Малая Вишера','Malaya Vishera','','Russia',643,'Europe/Moscow'),(2050,'Малая Сердоба','malaia serdoba','','Russia',643,'Europe/Moscow'),(11871,'Малгобек','Maglobek','','Russia',643,'Europe/Moscow'),(1011,'Малиново','malinovo','','Russia',643,'Asia/Vladivostok'),(10135,'Малка','Malka','','Russia',643,'Europe/Moscow'),(10298,'Малмыж','Malmig','','Russia',643,''),(2051,'Малоархангельск','maloarhangelsk','','Russia',643,'Europe/Moscow'),(662,'Малоярославец','malojaroslavec','','Russia',643,'Europe/Moscow'),(86776,'Малоярославец','Maloyaroslavets','','Russia',643,'Europe/Moscow'),(526,'Малые Дербеты','malye-derbety','','Russia',643,''),(2052,'Малые Кармакулы','malie karmakuli','','Russia',643,''),(497,'Мама','mama','','Russia',643,'Asia/Irkutsk'),(2053,'Мамадыш','mamandish','','Russia',643,''),(2054,'Мамоново','mamonovo','','Russia',643,'Asia/Novosibirsk'),(1537,'Мангут','mangut','','Russia',643,'Asia/Omsk'),(2055,'Мантурово','manturovo','','Russia',643,'Europe/Moscow'),(10067,'Маракан','Marakan','','Russia',643,'Asia/Irkutsk'),(2056,'Марево','marevo','','Russia',643,'Europe/Moscow'),(698,'Мариинск','mariinsk','','Russia',643,'Asia/Novokuznetsk'),(13311,'Мариинский Посад','Mariinskiy Posad','','Russia',643,'Europe/Moscow'),(1577,'Марково','markovo','','Russia',643,'Asia/Irkutsk'),(2057,'Маркс','marks','','Russia',643,'Europe/Volgograd'),(1611,'Марресаля','maresalja','','Russia',643,''),(10395,'Марьянская','Maryanskaya','','Russia',643,'Europe/Moscow'),(900,'Маслянино','masljanino','','Russia',643,'Asia/Novosibirsk'),(9971,'Массачусетский технологический институт','Mit','','Russia',643,'Asia/Omsk'),(1043,'Матвеев Курган','matveev-kurgan','','Russia',643,'Europe/Moscow'),(2058,'Матвеевка','matvevka','','Russia',643,'Asia/Vladivostok'),(1099,'Маха','macha','','Russia',643,'Europe/Moscow'),(432,'Махачкала','mahackala','','Russia',643,'Europe/Moscow'),(535,'Маячный','majachnyi','','Russia',643,''),(13214,'Мегион','Megion','','Russia',643,'Asia/Yekaterinburg'),(9637,'Медведево','Medvedevo','','Russia',643,'Europe/Moscow'),(10396,'Медведовская','Medvedovskaya','','Russia',643,'Europe/Moscow'),(536,'Медвежьегорск','medvezegorsk','','Russia',643,'Europe/Moscow'),(2059,'Медвенка','medvenka','','Russia',643,'Europe/Moscow'),(2060,'Медногорск','mednogorsk','','Russia',643,'Asia/Yekaterinburg'),(699,'Междуреченск','mezhdurechensk','','Russia',643,'Asia/Novokuznetsk'),(2061,'Междуреченский','mezdurechenskiy','','Russia',643,'Asia/Yekaterinburg'),(358,'Мезень','mezen','','Russia',643,'Europe/Moscow'),(2062,'Меленки','melenki','','Russia',643,'Europe/Moscow'),(383,'Мелеуз','meleuz','','Russia',643,'Asia/Yekaterinburg'),(1013,'Мельничное','melnichnoe','','Russia',643,''),(12232,'Менделеевск','Mendeleevsk','','Russia',643,'Europe/Moscow'),(2063,'Мензелинск','menzelinsk','','Russia',643,'Europe/Moscow'),(2064,'Меренга','merenga','','Russia',643,'Asia/Magadan'),(2065,'Месягутово','mesiagutovo','','Russia',643,'Asia/Yekaterinburg'),(1512,'Миасс','miass','','Russia',643,'Asia/Yekaterinburg'),(11985,'Микунь','Mikuny','','Russia',643,''),(1044,'Миллерово','millerovo','','Russia',643,'Europe/Moscow'),(675,'Мильково','milkovo','','Russia',643,'Asia/Kamchatka'),(1223,'Минеральные воды','mineralnye-vodi','','Russia',643,'Europe/Moscow'),(626,'Минусинск','minusinsk','','Russia',643,'Asia/Krasnoyarsk'),(13255,'Миньяр','Minyar','','Russia',643,'Asia/Yekaterinburg'),(1100,'Мирный','mirnvj','','Russia',643,'America/Los_Angeles'),(12511,'Мирный','Mirniy','','Russia',643,'Asia/Yakutsk'),(86781,'Мирный','Mirny','','Russia',643,'Asia/Yakutsk'),(2066,'Михайлов','mihailov','','Russia',643,'Europe/Moscow'),(2067,'Михайловка','mihailovka','','Russia',643,''),(9239,'Михайловка','Mihaylovka','','Russia',643,'Europe/Volgograd'),(1290,'Михайловск','mihajlovskoe','','Russia',643,''),(1326,'Мичуринск','micurinsk','','Russia',643,'Europe/Moscow'),(86780,'Мичуринск','Michurinsk','','Russia',643,'Europe/Moscow'),(2069,'Мишкино','mishkino','','Russia',643,'Asia/Yekaterinburg'),(2070,'Могойтуй','mogoitui','','Russia',643,'Asia/Yakutsk'),(1540,'Могоча','mogoca','','Russia',643,'Asia/Yakutsk'),(830,'Можайск','mozaisk','','Russia',643,'Europe/Moscow'),(86786,'Можайск','Mozajsk','','Russia',643,'Europe/Moscow'),(1398,'Можга','mozga','','Russia',643,'Europe/Samara'),(86787,'Можга','Mozhga','','Russia',643,'Europe/Samara'),(1216,'Моздок','mozdok','','Russia',643,'Europe/Moscow'),(12596,'Мокроус','Mokruss','','Russia',643,'Europe/Volgograd'),(2071,'Мокроусово','mokrousovo','','Russia',643,'Asia/Yekaterinburg'),(2072,'Мокшан','morshan','','Russia',643,'Europe/Zaporozhye'),(86782,'Мокшан','Mokshan','','Russia',643,'Europe/Moscow'),(1354,'Молчаново','molchanovo','','Russia',643,'Asia/Novosibirsk'),(2073,'Монастырщина','monastirshina','','Russia',643,''),(498,'Монды','mondy','','Russia',643,'Asia/Irkutsk'),(1256,'Монерон','moneron','','Russia',643,'Asia/Kamchatka'),(11052,'Монино','Monino','','Russia',643,'Europe/Moscow'),(854,'Мончегорск','moncegorsk','','Russia',643,'Europe/Moscow'),(2074,'Мончегорск','monchengorsk','','Russia',643,'Europe/Moscow'),(86783,'Мончегорск','Monchegorsk','','Russia',643,'Europe/Moscow'),(12048,'Морга','Morga','','Russia',643,'Europe/Moscow'),(2075,'Мордово','mordovo','','Russia',643,'Europe/Moscow'),(359,'Моржовец','morgovec','','Russia',643,''),(782,'Морки','morki','','Russia',643,'Europe/Moscow'),(1045,'Морозовск','morozovsk','','Russia',643,'Europe/Moscow'),(12233,'Морты','Morti','','Russia',643,'Europe/Moscow'),(1327,'Моршанск','morsansk','','Russia',643,'Europe/Moscow'),(86784,'Моршанск','Morshansk','','Russia',643,'Europe/Moscow'),(663,'Мосальск','mosalsk','','Russia',643,'Europe/Moscow'),(360,'Мосеево','moseevo','','Russia',643,'Europe/Moscow'),(2076,'Москаленки','moskalenki','','Russia',643,'Asia/Omsk'),(27,'Москва','Moscow','','Russia',643,'Europe/Moscow'),(2077,'Мостовской','mostovskoi','','Russia',643,'Europe/Moscow'),(86785,'Мостовской','Mostovskoy','','Russia',643,'Europe/Moscow'),(627,'Мотыгино','motygino','','Russia',643,'Asia/Krasnoyarsk'),(901,'Мошково','moskovo','','Russia',643,'Asia/Novosibirsk'),(2078,'Мраково','mrakovo','','Russia',643,'Asia/Yekaterinburg'),(1317,'Мугур-Аксы','mugur-aksy','','Russia',643,'Asia/Krasnoyarsk'),(361,'Мудьюг','mudjug','','Russia',643,'Europe/Moscow'),(1613,'Мужи','muzi','','Russia',643,'Africa/Johannesburg'),(2079,'Муравленко','muravlenko','','Russia',643,'Asia/Yekaterinburg'),(2080,'Мураши','murashi','','Russia',643,'Europe/Volgograd'),(855,'Мурманск','murmansk','','Russia',643,'Europe/Moscow'),(856,'Мурмаши','murmachi','','Russia',643,''),(2081,'Муром','murom','','Russia',643,'Europe/Moscow'),(2082,'Муромцево','muromcevo','','Russia',643,'Asia/Omsk'),(1312,'Муслюмово','musljumovo','','Russia',643,'Europe/Moscow'),(554,'Мутный Материк','mutnyi-materik','','Russia',643,''),(398,'Мухоршибирь','muhorshibir','','Russia',643,''),(961,'Мценск','mcensk','','Russia',643,'Europe/Moscow'),(86788,'Мценск','Mtsensk','','Russia',643,'Europe/Moscow'),(802,'Мыс Алевина','mys-alevina','','Russia',643,'Asia/Magadan'),(924,'Мыс Белый Нос','mys-belyi-nos','','Russia',643,'Asia/Yekaterinburg'),(803,'Мыс Братьев','mys-bratev','','Russia',643,'Asia/Yekaterinburg'),(1101,'Мыс Кигилях','mys-kigiljach','','Russia',643,'Asia/Yekaterinburg'),(925,'Мыс Костантиновский','mys-konstantinovskiy','','Russia',643,'Europe/Moscow'),(926,'Мыс Микулкин','mys-mikulkin','','Russia',643,'Europe/Moscow'),(628,'Мыс Стерлигова','mis-sterligova','','Russia',643,''),(1257,'Мыс Терпения','mys-terpenija','','Russia',643,'Asia/Yekaterinburg'),(1579,'Мыс Уэлен','mys-uelen','','Russia',643,'Asia/Anadyr'),(1580,'Мыс Шмидта','mys-smidta','','Russia',643,'Asia/Anadyr'),(86789,'Мыс Шмидта','Mys Shmidta','','Russia',643,'Asia/Anadyr'),(2083,'Мыски','miski','','Russia',643,'Europe/Riga'),(2084,'Мытищи','mitishi','','Russia',643,'Europe/Moscow'),(2085,'Мышкин','mishkin','','Russia',643,'Asia/Oral'),(2086,'Набережные Челны','Nabereznie Chelni','','Russia',643,'Europe/Moscow'),(86790,'Набережные Челны','Naberezhnye Chelny','','Russia',643,'Europe/Moscow'),(11303,'Навашино','Navashino','','Russia',643,'Europe/Moscow'),(2087,'Навля','navlia','','Russia',643,'Europe/Moscow'),(1103,'Нагорный','nagornyj','','Russia',643,'Asia/Yakutsk'),(2088,'Нагорск','nagorsk','','Russia',643,'Europe/Volgograd'),(715,'Нагорское','nagorskoe','','Russia',643,''),(11921,'Надвоицы','Nadvoici','','Russia',643,''),(1614,'Надым','nadym','','Russia',643,'Asia/Yekaterinburg'),(629,'Назарово','nasarovo','','Russia',643,'Asia/Krasnoyarsk'),(630,'Назимово','nazimovo','','Russia',643,'Asia/Krasnoyarsk'),(2089,'Назрань','nazran','','Russia',643,'Europe/Moscow'),(941,'Называевск','nazyuvaevsk','','Russia',643,'Asia/Omsk'),(522,'Нальчик','nalcik','','Russia',643,'Europe/Moscow'),(1104,'Намцы','namcy','','Russia',643,'Asia/Yakutsk'),(1355,'Напас','napas','','Russia',643,'Asia/Novosibirsk'),(10523,'Нарва','Narva','','Russia',643,'Europe/Tallinn'),(9461,'Нариманов','Narimanov','','Russia',643,'Europe/Volgograd'),(12468,'Нарма','Narma','','Russia',643,'Europe/Moscow'),(831,'Наро-Фоминск','naro-fominsk','','Russia',643,'Europe/Moscow'),(2090,'Наровчат','narovchat','','Russia',643,'Europe/Moscow'),(10136,'Нарткала','Nartkala','','Russia',643,'Europe/Moscow'),(2091,'Нарым','narim','','Russia',643,'Europe/Warsaw'),(86794,'Нарым','Narym','','Russia',643,'Asia/Novosibirsk'),(927,'Нарьян-Мар','naryan-mar','','Russia',643,'Europe/Moscow'),(2092,'Наурская','naurskaia','','Russia',643,'Europe/Moscow'),(11057,'Нахабино','Nahaino','','Russia',643,''),(1014,'Находка','nahodka','','Russia',643,'Asia/Vladivostok'),(2093,'Невель','nevel','','Russia',643,'Europe/Moscow'),(1258,'Невельск','nevelsk','','Russia',643,'Asia/Sakhalin'),(9319,'Невер','Never','','Russia',643,'Asia/Yakutsk'),(1224,'Невинномыск','nevinnomysok','','Russia',643,'Europe/Moscow'),(86800,'Невинномысск','Nevinnomyssk','','Russia',643,'Europe/Moscow'),(1291,'Невьянск','nevjansk','','Russia',643,'Asia/Yekaterinburg'),(12786,'Незлобная','Nezlobnaya','','Russia',643,'Europe/Moscow'),(2094,'Некрасовское','nekrasovskoe','','Russia',643,'Europe/Moscow'),(2095,'Нелидово','nelidovo','','Russia',643,'Europe/Moscow'),(1448,'Нелькан','nelkan','','Russia',643,'Asia/Vladivostok'),(2096,'Нема','nema','','Russia',643,'Europe/Volgograd'),(10155,'Неман','Neman','','Russia',643,'Europe/Kaliningrad'),(832,'Немчиновка','nemchinovka','','Russia',643,'Europe/Moscow'),(1413,'Ненастная','nenastnaja','','Russia',643,''),(10073,'Непа','Nepa','','Russia',643,'Asia/Irkutsk'),(1105,'Нера','nera','','Russia',643,'Asia/Magadan'),(2097,'Нерехта','nerehta','','Russia',643,'Europe/Moscow'),(1541,'Нерчинск','nercinsk','','Russia',643,'Asia/Yakutsk'),(86797,'Нерчинск','Nerchinsk','','Russia',643,'Asia/Yakutsk'),(1542,'Нерчинский Завод','nerchinskij-zavod','','Russia',643,'Asia/Yakutsk'),(2098,'Нерюнгри','neriungri','','Russia',643,'Asia/Yakutsk'),(10157,'Нестеров','Nesterov','','Russia',643,'Europe/Kaliningrad'),(2100,'Нефтегорск','neftegorsk','','Russia',643,'Europe/Samara'),(2101,'Нефтекамск','neftekamsk','','Russia',643,'Asia/Yekaterinburg'),(2102,'Нефтекумск','neftekumsk','','Russia',643,'Europe/Moscow'),(1483,'Нефтеюганск','neftejugansk','','Russia',643,'Asia/Yekaterinburg'),(86796,'Нефтеюганск','Nefteyugansk','','Russia',643,'Asia/Yekaterinburg'),(10339,'Нея','Neia','','Russia',643,'Europe/Moscow'),(1449,'Нижне-Тамбовское','nizhne-tambovskoe','','Russia',643,''),(399,'Нижнеангарск','nizhneangarsk','','Russia',643,'Asia/Irkutsk'),(1484,'Нижневартовск','niznevartovsk','','Russia',643,'Asia/Yekaterinburg'),(86802,'Нижневартовск','Nizhnevartovsk','','Russia',643,'Asia/Yekaterinburg'),(2103,'Нижнедевицк','niznevidetsk','','Russia',643,'Europe/Moscow'),(2104,'Нижнекамск','niznekamsk','','Russia',643,'Europe/Moscow'),(86801,'Нижнекамск','Nizhnekamsk','','Russia',643,'Europe/Moscow'),(1485,'Нижнесортымск','nizhnesortymsk','','Russia',643,''),(500,'Нижнеудинск','nizneudinsk','','Russia',643,'Asia/Irkutsk'),(1106,'Нижнеянск','nignejansk','','Russia',643,'Asia/Vladivostok'),(12699,'Нижние Серги','Nohnie Sergi','','Russia',643,''),(2105,'Нижний Ломов','niznii lomov','','Russia',643,''),(878,'Нижний Новгород','niznij-novgorod','','Russia',643,'Europe/Moscow'),(86803,'Нижний Новгород','Niznij Novgorod','','Russia',643,'Europe/Moscow'),(11987,'Нижний Одес','Nigniy Odes','','Russia',643,''),(1292,'Нижний Тагил','nizhnyj-tagil','','Russia',643,'Asia/Yekaterinburg'),(1543,'Нижний Цасучей','nizhij-casuche','','Russia',643,''),(448,'Нижний Чир','nizhny-chir','','Russia',643,'Europe/Volgograd'),(2106,'Нижняя Омка','nizniaia omka','','Russia',643,''),(12701,'Нижняя Салда','Nignyaya Salda','','Russia',643,''),(2107,'Нижняя Тавда','nizniaia tavda','','Russia',643,'Asia/Yekaterinburg'),(12702,'Нижняя Тура','Nignyaya Tura','','Russia',643,''),(858,'Никель','nikel','','Russia',643,'Europe/Moscow'),(9465,'Николаевка','Nikolaevka','','Russia',643,'Europe/Moscow'),(9742,'Николаевск','Nikolaevsk','','Russia',643,'Europe/Volgograd'),(1450,'Николаевск-на-Амуре','nikolaevsk-na-amure','','Russia',643,'Asia/Vladivostok'),(769,'Николаевский','nikolaevskoe','','Russia',643,'Europe/Moscow'),(725,'Николо-Полома','nikolo-poloma','','Russia',643,'Europe/Moscow'),(460,'Никольск','nikolsk','','Russia',643,'Europe/Moscow'),(679,'Никольский','nikolskoe','','Russia',643,'Asia/Kamchatka'),(9466,'Никольское','Nikolyskoe','','Russia',643,''),(12647,'Ниш','Nish','','Russia',643,'Europe/Belgrade'),(11065,'Новая','Novaya','','Russia',643,'Europe/Moscow'),(2109,'Новая Игирма','novaia igirma','','Russia',643,'Asia/Irkutsk'),(770,'Новая Ладога','novaja-ladoga','','Russia',643,'Europe/Moscow'),(12703,'Новая Ляля','Novaya Lyalya','','Russia',643,'Asia/Yekaterinburg'),(9903,'Новая Усмань','Novaya Usmany','','Russia',643,'Europe/Moscow'),(2110,'Новгород Великий','novgorod velikiy','','Russia',643,'Europe/Moscow'),(1259,'Новиково','novikovo','','Russia',643,'Asia/Omsk'),(10718,'Новинка','Novinka','','Russia',643,'Europe/Moscow'),(1225,'Ново-Александровск','novo-aleksandrovsk','','Russia',643,'Europe/Moscow'),(833,'Ново-Иерусалим','novo-jerusalim','','Russia',643,'Europe/Moscow'),(743,'Ново-Касторное','novo-kastornoe','','Russia',643,'Europe/Moscow'),(9242,'Новоалтайск','Novoaltaysk','','Russia',643,'Asia/Omsk'),(2111,'Новоаннинский','novoanenskiy','','Russia',643,'Europe/Volgograd'),(633,'Новобирилюссы','novobiriljusy','','Russia',643,'Asia/Krasnoyarsk'),(2113,'Нововоронеж','novovoronez','','Russia',643,'Europe/Moscow'),(9399,'Новодвинск','Novodvinsk','','Russia',643,'Europe/Moscow'),(10402,'Новодеревянковская','Novoderevyanovskaya','','Russia',643,'Europe/Moscow'),(9569,'Новозыбков','Novozibkov','','Russia',643,'Europe/Moscow'),(2115,'Новокубанск','novokubansk','','Russia',643,'Europe/Moscow'),(700,'Новокузнецк','novokuznetsk','','Russia',643,'Asia/Novokuznetsk'),(2476,'Новокуйбышевск','Novokuybyshevsk','','Russia',643,'Europe/Samara'),(10407,'Новоминская','Novominskaya','','Russia',643,'Europe/Moscow'),(10408,'Новомихайловский','Novomihaylovskiy','','Russia',643,'Europe/Moscow'),(11768,'Новомихайловский','Novomhaylovskiy','','Russia',643,'Europe/Moscow'),(2116,'Новомичуринск','novomichurinsk','','Russia',643,'Europe/Moscow'),(2117,'Новомосковск','novomoskovsk','','Russia',643,'Europe/Moscow'),(9744,'Новониколаевский','Novonikolaevskiy','','Russia',643,'Europe/Volgograd'),(2118,'Новонукутский','novonukutskiy','','Russia',643,'Asia/Irkutsk'),(2119,'Новоорск','novoorsk','','Russia',643,'Asia/Yekaterinburg'),(2120,'Новопавловск','novopavlovsk','','Russia',643,'Europe/Moscow'),(2121,'Новопокровка','novopokrovka','','Russia',643,'Europe/Moscow'),(2122,'Новопокровская','novopokrovskaia','','Russia',643,'Asia/Novosibirsk'),(9323,'Новороссийка','Novorossiyka','','Russia',643,'Asia/Yakutsk'),(582,'Новороссийск','novorossijsk','','Russia',643,'Europe/Moscow'),(86806,'Новороссийск','Novorossiysk','','Russia',643,'Europe/Moscow'),(400,'Новоселенгинск','novoselenginsk','','Russia',643,'Asia/Irkutsk'),(2123,'Новоселицкое','novoselickoe','','Russia',643,''),(2124,'Новоселово','novoselovo','','Russia',643,'Asia/Krasnoyarsk'),(2125,'Новосергиевка','novosergeevka','','Russia',643,'Europe/Moscow'),(902,'Новосибирск','novosibirsk','','Russia',643,'Asia/Novosibirsk'),(2126,'Новосиль','novosil','','Russia',643,'Europe/Moscow'),(10410,'Новотитаровская','Novotitarovskaya','','Russia',643,'Europe/Moscow'),(11435,'Новотроицк','Novotroick','','Russia',643,'Asia/Yekaterinburg'),(10302,'Новотроицкое','Novotroickoe','','Russia',643,''),(2128,'Новоузенск','novouzensk','','Russia',643,'Europe/Volgograd'),(13095,'Новоульяновск','Novoulyanovsk','','Russia',643,'Europe/Moscow'),(11497,'Новоуральск','Novouralysk','','Russia',643,''),(2129,'Новохоперск','novohopersk','','Russia',643,'Europe/Moscow'),(13313,'Новочебоксарск','Novoceboksarsk','','Russia',643,'Europe/Moscow'),(2130,'Новочеркасск','novocherkask','','Russia',643,'Europe/Moscow'),(501,'Новочунка','novochunka','','Russia',643,'Asia/Irkutsk'),(12402,'Новошахтинск','Novoshahtinsk','','Russia',643,'Europe/Moscow'),(2131,'Новые Бурасы','novie burasi','','Russia',643,'America/Recife'),(10257,'Новый','Noviy','','Russia',643,'Europe/Moscow'),(1356,'Новый Васюган','novyj-vasjugan','','Russia',643,''),(418,'Новый Оскол','novyj-oskol','','Russia',643,'Europe/Moscow'),(86807,'Новый Оскол','Novy Oskol','','Russia',643,'Europe/Moscow'),(1615,'Новый Порт','novyi-port','','Russia',643,'Asia/Yekaterinburg'),(783,'Новый Торьял','novyj-torjal','','Russia',643,''),(1616,'Новый Уренгой','novyi-urengoi','','Russia',643,'Asia/Yekaterinburg'),(86808,'Новый Уренгой','Novy Urengoy','','Russia',643,'Asia/Yekaterinburg'),(2132,'Ногинск','noginsk','','Russia',643,'Europe/Moscow'),(1260,'Ноглики','nogliki','','Russia',643,'Asia/Sakhalin'),(978,'Ножовка','nozovka','','Russia',643,'Europe/Kiev'),(716,'Нолинск','nolinsk','','Russia',643,'Europe/Volgograd'),(13370,'Нори','Nori','','Russia',643,'Asia/Yekaterinburg'),(1388,'Норильск','norilsk','','Russia',643,'Asia/Krasnoyarsk'),(330,'Норск','norsk','','Russia',643,'Asia/Yakutsk'),(1617,'Ноябрьск','nojabrsk','','Russia',643,'Asia/Yekaterinburg'),(12243,'Нурлат','Nurlat','','Russia',643,'Europe/Moscow'),(1261,'Ныврово','nyvrovo','','Russia',643,'Asia/Magadan'),(1618,'Ныда','nyda','','Russia',643,'Asia/Yekaterinburg'),(2133,'Ныроб','nirob','','Russia',643,'Africa/Nairobi'),(2134,'Нытва','nitva','','Russia',643,''),(2135,'Нюксеница','niuskenica','','Russia',643,''),(1107,'Нюрба','njurba','','Russia',643,'Asia/Yakutsk'),(1108,'Нюя','njuja','','Russia',643,'Asia/Yakutsk'),(2136,'Нягань','niagan','','Russia',643,'Asia/Yekaterinburg'),(1513,'Нязепетровск','njazepetrovsk','','Russia',643,'Asia/Yekaterinburg'),(1486,'Няксимволь','njaksimvol','','Russia',643,''),(362,'Няндома','njandoma','','Russia',643,'Europe/Moscow'),(2137,'Обливская','oblivskaia','','Russia',643,'Europe/Moscow'),(1451,'Облучье','obluce','','Russia',643,'Asia/Qyzylorda'),(2138,'Обнинск','obninsk','','Russia',643,'Europe/Moscow'),(745,'Обоянь','obojan','','Russia',643,'Europe/Moscow'),(11075,'Обухово','Obuhovo','','Russia',643,'Europe/Volgograd'),(11436,'Обь','Oby','','Russia',643,'Europe/Samara'),(555,'Обьячево','objacevo','','Russia',643,''),(904,'Огурцово','ogurcovo','','Russia',643,'Europe/Moscow'),(942,'Одесское','odesskoe','','Russia',643,'Europe/Moscow'),(2139,'Одинцово','odincovo','','Russia',643,'Europe/Moscow'),(11077,'Ожерелье','Ogerelye','','Russia',643,'Europe/Moscow'),(771,'Озерки','ozerki','','Russia',643,'Europe/Moscow'),(680,'Озерная','ozernaja','','Russia',643,'Asia/Yekaterinburg'),(12742,'Озёрный','Ozerniy','','Russia',643,''),(1389,'Озеро Таймыр','ozero-tajmyr','','Russia',643,'Asia/Krasnoyarsk'),(2141,'Озёрск','ozersk','','Russia',643,'Asia/Yekaterinburg'),(2142,'Озеры','oziori','','Russia',643,''),(1243,'Озинки','ozinki','','Russia',643,'Europe/Volgograd'),(1109,'Оймякон','ojmjakon','','Russia',643,'Asia/Magadan'),(2143,'Оконешниково','okoneshnikovo','','Russia',643,'Asia/Omsk'),(13413,'Октябрь','Oktiabry','','Russia',643,'Europe/Simferopol'),(12518,'Октябрьск','Oktiabrysk','','Russia',643,'Europe/Samara'),(681,'Октябрьская','oktjabrskaja','','Russia',643,'Europe/Moscow'),(2144,'Октябрьский','oktiebrskiy','','Russia',643,'Asia/Yekaterinburg'),(2145,'Октябрьский','oktiabrskiy','','Russia',643,'Asia/Yekaterinburg'),(9402,'Октябрьский','Oktyabrskiy','','Russia',643,'Europe/Moscow'),(11079,'Октябрьский','Oktiabryskiy','','Russia',643,'Asia/Yekaterinburg'),(1487,'Октябрьское','oktjabrskoe','','Russia',643,'Asia/Almaty'),(2148,'Окуловка','okulovka','','Russia',643,'Europe/Moscow'),(556,'Окунев Нос','okunev-nos','','Russia',643,'Europe/Moscow'),(804,'Ола','ola','','Russia',643,'Asia/Magadan'),(1110,'Олёкминск','olekminsk','','Russia',643,'Asia/Yakutsk'),(2149,'Оленегорск','olenegorsk','','Russia',643,'Europe/Moscow'),(1111,'Оленёк','olenek','','Russia',643,'Asia/Yakutsk'),(2150,'Оленино','olenino','','Russia',643,'Europe/Moscow'),(634,'Оленья Речка','olenja-rechka','','Russia',643,''),(1545,'Оловянная','olovjannaja','','Russia',643,'Asia/Yakutsk'),(537,'Олонец','olonec','','Russia',643,'Europe/Moscow'),(1015,'Ольга','olga','','Russia',643,'Asia/Vladivostok'),(2151,'Ольховатка','olhovatka','','Russia',643,''),(2152,'Ольховка','olhovka','','Russia',643,'Europe/Moscow'),(10591,'Ольховка','Olyhovka','','Russia',643,'Europe/Kiev'),(12743,'Ольша','Olysha','','Russia',643,''),(11246,'Ома','Oma','','Russia',643,'Europe/Moscow'),(1581,'Омолон','omolon','','Russia',643,'Asia/Magadan'),(943,'Омск','omsk','','Russia',643,'Asia/Omsk'),(805,'Омсукчан','omsukchan','','Russia',643,'Asia/Magadan'),(2153,'Омутнинск','omutninsk','','Russia',643,'Europe/Volgograd'),(281,'Онгудай','ongudaj','','Russia',643,'Asia/Omsk'),(363,'Онега','onega','','Russia',643,'Europe/Moscow'),(11820,'Онохой','Ohonoy','','Russia',643,''),(717,'Опарино','oparino','','Russia',643,'Europe/Volgograd'),(990,'Опочка','opochka','','Russia',643,'Europe/Moscow'),(2154,'Орда','orda','','Russia',643,'Asia/Yekaterinburg'),(469,'Орджоникидзевская','ordzhonikidzevskaia','','Russia',643,'Europe/Moscow'),(905,'Ордынское','ordynskoe','','Russia',643,'Asia/Novosibirsk'),(962,'Орёл','orel','','Russia',643,'Europe/Moscow'),(11529,'Орёл','Oriol','','Russia',643,'Europe/Moscow'),(956,'Оренбург','orenburg','','Russia',643,'Asia/Yekaterinburg'),(10723,'Орехово','Orehovo','','Russia',643,'Europe/Moscow'),(2155,'Орехово-Зуево','orehovo-zuevo','','Russia',643,'Europe/Moscow'),(502,'Орлик','orlik','','Russia',643,'Asia/Irkutsk'),(503,'Орлинга','orlinga','','Russia',643,'Asia/Irkutsk'),(12405,'Орловский','Orlovskiy','','Russia',643,'Europe/Moscow'),(2156,'Орск','orsk','','Russia',643,'Asia/Yekaterinburg'),(12880,'Орша','Orsha','','Russia',643,'Europe/Moscow'),(2157,'Оса (Ирк.)','osa','','Russia',643,'Asia/Yekaterinburg'),(10258,'Осинники','Osinniki','','Russia',643,'Asia/Novokuznetsk'),(753,'Оссора','ossora','','Russia',643,'Asia/Kamchatka'),(1337,'Осташков','ostaskov','','Russia',643,'Europe/Moscow'),(12745,'Остёр','Oster','','Russia',643,'Europe/Moscow'),(11698,'Остров','Ostrov','','Russia',643,'Europe/Moscow'),(806,'Остров  Спафарьева','o-spafareva','','Russia',643,'Asia/Magadan'),(1390,'Остров Диксон','ostrov-dikson','','Russia',643,'Asia/Krasnoyarsk'),(1391,'Остров Преображения','ostrov-preobragenia','','Russia',643,'Europe/Moscow'),(375,'Остров Тюлений','o-v-tjulenij','','Russia',643,'Europe/Volgograd'),(1112,'Острова Дунай','o-va-dunaj','','Russia',643,'Europe/Vienna'),(2158,'Острогожск','ostrozorsk','','Russia',643,''),(10414,'Отрадное','Otradnaya','','Russia',643,'Europe/Moscow'),(10726,'Отрадное','Otradnoe','','Russia',643,'Europe/Moscow'),(12520,'Отрадный','Otradniy','','Russia',643,'Europe/Samara'),(1262,'Оха','oha','','Russia',643,'Asia/Sakhalin'),(981,'Оханск','ohansk','','Russia',643,'Asia/Yekaterinburg'),(1016,'Охотничий','ohotnichij','','Russia',643,'Asia/Vladivostok'),(1453,'Охотск','ohotsk','','Russia',643,'Asia/Magadan'),(86812,'Охотск','Okhotsk','','Russia',643,'Asia/Magadan'),(2160,'Очер','ocher','','Russia',643,'Asia/Yekaterinburg'),(1054,'Павелец','pavelec','','Russia',643,''),(2161,'Павловка','pavlovka','','Russia',643,'Asia/Yekaterinburg'),(879,'Павлово','pavlovo','','Russia',643,'Europe/Moscow'),(468,'Павловск','pavlovsk','','Russia',643,'Europe/Moscow'),(2162,'Павловская','pavlovskaia','','Russia',643,'Europe/Moscow'),(11593,'Павловский','Pavlovskiy','','Russia',643,'Asia/Yekaterinburg'),(834,'Павловский Посад','pavlovskij-possad','','Russia',643,'Europe/Moscow'),(944,'Павлоградка','pavlogradka','','Russia',643,'Asia/Omsk'),(884,'Паган','bagan','','Russia',643,'Asia/Novosibirsk'),(539,'Паданы','padany','','Russia',643,'Europe/Moscow'),(860,'Падун','padun','','Russia',643,'Asia/Yekaterinburg'),(11923,'Пай','Pay','','Russia',643,'Europe/Moscow'),(754,'Палана','palana','','Russia',643,'Asia/Kamchatka'),(807,'Палатка','palatka','','Russia',643,'Asia/Magadan'),(449,'Палласовка','pallasovka','','Russia',643,'Europe/Volgograd'),(734,'Памятная','pamjatnaja','','Russia',643,''),(1620,'Пангоды','pangody','','Russia',643,'Asia/Yekaterinburg'),(9293,'Панцирникообразные','Gar','','Russia',643,'Asia/Yakutsk'),(1357,'Парабель','parabel','','Russia',643,'Asia/Novosibirsk'),(2163,'Параньга','paranga','','Russia',643,''),(1017,'Партизанск','partizansk','','Russia',643,'Asia/Vladivostok'),(2164,'Партизанское','partizanskoe','','Russia',643,'Europe/Sarajevo'),(2165,'Парфино','parfino','','Russia',643,'Europe/Moscow'),(965,'Пачелма','pacelma','','Russia',643,''),(10415,'Пашковский','Pashkovskiy','','Russia',643,'Europe/Moscow'),(1583,'Певек','pevek','','Russia',643,'Asia/Anadyr'),(966,'Пенза','penza','','Russia',643,'Europe/Moscow'),(12884,'Пено','Peno','','Russia',643,'Europe/Moscow'),(2166,'Первомайск','pervomaisk','','Russia',643,'Europe/Moscow'),(2167,'Первомайский','pervomaiskiy','','Russia',643,'Europe/Samara'),(1415,'Первомайское','pervomajskoe','','Russia',643,'Europe/Moscow'),(9247,'Первомайское','Pervomayskoe','','Russia',643,'Europe/Moscow'),(2477,'Первоуральск','Pervouralsk','','Russia',643,'Asia/Yekaterinburg'),(10083,'Перевоз','Perevoz','','Russia',643,'Europe/Moscow'),(2168,'Перегребное','peregrebnoe','','Russia',643,''),(1244,'Перелюб','pereljub','','Russia',643,''),(1603,'Переславль-Залесский','pereslavl-zaleskiy','','Russia',643,'Europe/Moscow'),(13169,'Переяславка','Pereyaslavka','','Russia',643,'Asia/Vladivostok'),(10731,'Пери','Peri','','Russia',643,'Europe/Moscow'),(982,'Пермь','perm','','Russia',643,'Asia/Yekaterinburg'),(2169,'Пестово','pestovo','','Russia',643,'Europe/Moscow'),(2170,'Пестравка','pestravka','','Russia',643,'Europe/Samara'),(11924,'Песчаное','Pescanoe','','Russia',643,''),(12407,'Песчанокопское','Pescanokopskoe','','Russia',643,''),(9750,'Петров Вал','Petrov Val','','Russia',643,'Europe/Volgograd'),(10084,'Петрово','Petrovo','','Russia',643,'Europe/Moscow'),(1245,'Петровск','petrovsk','','Russia',643,'Europe/Volgograd'),(2171,'Петровск-Забайкальский','petrovsk-zabaikalskiy','','Russia',643,'Europe/Volgograd'),(1546,'Петровский Завод','petrovskij-zavod','','Russia',643,'Asia/Yakutsk'),(2172,'Петровское','petrovskoe','','Russia',643,'Europe/Moscow'),(540,'Петрозаводск','petrozavodsk','','Russia',643,'Europe/Moscow'),(401,'Петропавловка','petropavlovka','','Russia',643,'Asia/Yakutsk'),(10085,'Петропавловск','Petropavlovsk','','Russia',643,'Asia/Vladivostok'),(682,'Петропавловск-Камчатский','petropavlovsk-kamchatskiy','','Russia',643,'Asia/Kamchatka'),(557,'Петрунь','petrun','','Russia',643,'Europe/Moscow'),(735,'Петухово','petuhovo','','Russia',643,'Asia/Yekaterinburg'),(440,'Петушки','petushki','','Russia',643,'Europe/Moscow'),(2173,'Печенга','pechenga','','Russia',643,'Europe/Moscow'),(558,'Печора','pecora','','Russia',643,'Europe/Moscow'),(86816,'Печора','Pechora','','Russia',643,'Europe/Moscow'),(2174,'Печоры','pechori','','Russia',643,'Europe/Moscow'),(10732,'Пикалёво','Pikalevo','','Russia',643,'Europe/Moscow'),(1263,'Пильво','pilvo','','Russia',643,'Asia/Sakhalin'),(364,'Пинега','pinega','','Russia',643,'Europe/Moscow'),(657,'Пионерский','pionerskij','','Russia',643,'Europe/Kaliningrad'),(635,'Пировское','pirovskoe','','Russia',643,'Europe/Moscow'),(2175,'Пителино','pitelino','','Russia',643,'Europe/Moscow'),(2176,'Питерка','piterka','','Russia',643,'Europe/Volgograd'),(11926,'Питкяранта','Pitkyaratna','','Russia',643,''),(1621,'Питляр','pitljar','','Russia',643,'America/Sao_Paulo'),(2177,'Плавск','plavsk','','Russia',643,'Europe/Moscow'),(13260,'Пласт','Plast','','Russia',643,'Asia/Yekaterinburg'),(10421,'Платнировская','Platnirovskaya','','Russia',643,'Europe/Moscow'),(2178,'Плес','ples','','Russia',643,'Europe/Moscow'),(2179,'Плесецк','pleseck','','Russia',643,'Europe/Moscow'),(86818,'Плесецк','Plesetsk','','Russia',643,'Europe/Moscow'),(2180,'Плешаново','pleshanovo','','Russia',643,'Europe/Moscow'),(2181,'Плюсса','pliusa','','Russia',643,'America/Sao_Paulo'),(2182,'Поворино','povorino','','Russia',643,'Europe/Moscow'),(2183,'Погар','pogar','','Russia',643,'Europe/Moscow'),(1264,'Погиби','pogibi','','Russia',643,'Asia/Magadan'),(1265,'Пограничное','pogranicnoe','','Russia',643,'Europe/Warsaw'),(1018,'Пограничный','pogranicnyj','','Russia',643,'Asia/Kamchatka'),(2184,'Подгоренский','podgorenskiy','','Russia',643,'Europe/Moscow'),(1359,'Подгорное','podgornoe','','Russia',643,'Asia/Almaty'),(2185,'Поддорье','podorie','','Russia',643,''),(11387,'Поддорье','Poddorye','','Russia',643,''),(2186,'Подольск','podolsk','','Russia',643,'Europe/Moscow'),(2187,'Подосиновец','podosinovech','','Russia',643,''),(2188,'Подпорожье','podporozie','','Russia',643,'Europe/Moscow'),(9651,'Покров Пресвятой Богородицы','Pokrov','','Russia',643,'Europe/Moscow'),(1547,'Покровка','pokrovka','','Russia',643,'Asia/Irkutsk'),(2189,'Покровск','pokrovsk','','Russia',643,'Asia/Yakutsk'),(1114,'Покровская','pokrovskaja','','Russia',643,'Europe/Volgograd'),(2190,'Покровское','pokrovskoe','','Russia',643,'Europe/Moscow'),(11388,'Пола','Pola','','Russia',643,'Europe/Moscow'),(12708,'Полевской','Polevskoy','','Russia',643,'Asia/Yekaterinburg'),(2191,'Полесск','polesk','','Russia',643,'Europe/Warsaw'),(1597,'Полигус','poligus','','Russia',643,'Asia/Krasnoyarsk'),(736,'Половинное','polovinnoe','','Russia',643,''),(945,'Полтавка','poltavka','','Russia',643,'Asia/Omsk'),(2192,'Полтавская','poltavvskaia','','Russia',643,'Europe/Moscow'),(10260,'Полысаево','Polisaevo','','Russia',643,'Asia/Novokuznetsk'),(11224,'Полярные Зори','Poliarnie Zori','','Russia',643,'Europe/Moscow'),(1115,'Полярный','poljarnyj','','Russia',643,'Europe/Moscow'),(559,'Помоздино','pomozdino','','Russia',643,'Europe/Moscow'),(2193,'Пономаревка','ponpmariovka','','Russia',643,'Asia/Yekaterinburg'),(11440,'Пономаревка','Ponomarevka','','Russia',643,'Asia/Yekaterinburg'),(746,'Поныри','ponyri','','Russia',643,'Europe/Moscow'),(2194,'Порецкое','poretskoe','','Russia',643,'Europe/Moscow'),(1266,'Поронайск','poronajsk','','Russia',643,'Asia/Sakhalin'),(2195,'Порхов','porhov','','Russia',643,'Europe/Moscow'),(10737,'Посёлок','Posiolok','','Russia',643,'Europe/Moscow'),(300,'Поспелиха','pospeliha','','Russia',643,'Asia/Yekaterinburg'),(2196,'Похвистнево','pohvistenovo','','Russia',643,'Europe/Samara'),(2197,'Почеп','pochep','','Russia',643,'Europe/Moscow'),(2198,'Починки','pochinki','','Russia',643,'Europe/Moscow'),(2199,'Починок','pochinok','','Russia',643,'Europe/Moscow'),(13416,'Пошехонье','Poshehonye','','Russia',643,'Europe/Moscow'),(1604,'Пошехонье-Володарск','pochehone-volodarsk','','Russia',643,'Europe/Moscow'),(331,'Поярково','pojarkovo','','Russia',643,'Europe/Zaporozhye'),(2200,'Правдинск','pravdinsk','','Russia',643,'Europe/Moscow'),(11100,'Правдинский','Pravdinskiy','','Russia',643,'Europe/Moscow'),(12789,'Прасковея','Praskoveya','','Russia',643,'Europe/Moscow'),(2201,'Преградная','pregradnaia','','Russia',643,'Europe/Moscow'),(1021,'Преображение','preobrazhenie','','Russia',643,'Europe/Samara'),(1548,'Приаргунск','priargunsk','','Russia',643,'Asia/Yakutsk'),(2478,'Приводино','Privodino','','Russia',643,'Europe/Moscow'),(472,'Приволжск','privolzhsk','','Russia',643,'Europe/Moscow'),(12025,'Приволжский','Privolgskiy','','Russia',643,''),(9834,'Прилуки','Priluki','','Russia',643,'Europe/Moscow'),(9754,'Приморск','Primorsk','','Russia',643,'Europe/Moscow'),(583,'Приморско-Ахтарск','primorsko-ahtarsk','','Russia',643,''),(2203,'Приозерск','priozersk','','Russia',643,'Europe/Moscow'),(11773,'Приютово','Priiutovo','','Russia',643,'Asia/Yekaterinburg'),(13345,'Провидения','Provideniya','','Russia',643,'Asia/Anadyr'),(2205,'Провидения Бухта','providenia buhta','','Russia',643,'Asia/Anadyr'),(9332,'Прогресс','Progress','','Russia',643,'Asia/Yakutsk'),(2206,'Прокопьевск','prokopievsk','','Russia',643,'Asia/Novokuznetsk'),(2207,'Пролетарск','proletarsk','','Russia',643,'Europe/Moscow'),(1360,'Промышленная','promyshlennaja','','Russia',643,'Asia/Novokuznetsk'),(11103,'Протвино','Protvino','','Russia',643,'Europe/Moscow'),(523,'Прохладная','prohladnaja','','Russia',643,'Europe/Moscow'),(10137,'Прохладный','Prohladniy','','Russia',643,'Asia/Krasnoyarsk'),(2208,'Прохоровка','prohorovka','','Russia',643,'Europe/Moscow'),(2209,'Пряжа','priaza','','Russia',643,'Europe/Moscow'),(10425,'Псебай','Psebay','','Russia',643,'Europe/Moscow'),(991,'Псков','pskov','','Russia',643,'Europe/Moscow'),(1246,'Пугачев','pugacev','','Russia',643,'Europe/Volgograd'),(1362,'Пудино','pudino','','Russia',643,'Asia/Novosibirsk'),(541,'Пудож','pudoz','','Russia',643,'Europe/Moscow'),(2210,'Пустошка','pustoshka','','Russia',643,'Europe/Moscow'),(2211,'Пучеж','puchez','','Russia',643,''),(2212,'Пушкино','pushkino','','Russia',643,'Europe/Moscow'),(992,'Пушкинские Горы','puskinskie-gory','','Russia',643,''),(684,'Пущино','puscino','','Russia',643,'Europe/Moscow'),(2213,'Пыталово','pitalovo','','Russia',643,'Europe/Moscow'),(726,'Пыщуг','pyscug','','Russia',643,''),(862,'Пялица','pjalica','','Russia',643,''),(1226,'Пятигорск','pjatigorsk','','Russia',643,'Europe/Moscow'),(86822,'Пятигорск','Pyatigorsk','','Russia',643,'Europe/Moscow'),(2215,'Радищево','radishevo','','Russia',643,'Europe/Sofia'),(1488,'Радужный','raduzhyi','','Russia',643,'Europe/Moscow'),(86823,'Радужный','Raduzhny','','Russia',643,'Asia/Yekaterinburg'),(2216,'Раевский','raevskiy','','Russia',643,'Asia/Yekaterinburg'),(9333,'Раздольное','Pazdolynoe','','Russia',643,''),(365,'Разнаволок','raznavolok','','Russia',643,'Europe/Moscow'),(2217,'Райчихинск','raihachinsk','','Russia',643,''),(9519,'Ракитное','Rakitnoe','','Russia',643,'Europe/Moscow'),(2218,'Раменское','ramenskoe','','Russia',643,'Europe/Moscow'),(12814,'Рассказово','Rasskazovo','','Russia',643,'Europe/Moscow'),(542,'Реболы','reboly','','Russia',643,'Europe/Moscow'),(301,'Ребриха','rebriha','','Russia',643,'Europe/Riga'),(1294,'Ревда','revda','','Russia',643,'Asia/Yekaterinburg'),(12891,'Редкино','Redkino','','Russia',643,'Europe/Moscow'),(2219,'Реж','rez','','Russia',643,'Asia/Yekaterinburg'),(1046,'Ремонтное','remontnoe','','Russia',643,''),(11114,'Реутов','Reutov','','Russia',643,'Europe/Moscow'),(2220,'Ржакса','rzaksa','','Russia',643,'Europe/Moscow'),(1338,'Ржев','rzev','','Russia',643,'Europe/Moscow'),(86827,'Ржев','Rzhev','','Russia',643,'Europe/Moscow'),(2221,'Ровеньки','povenki','','Russia',643,''),(2222,'Ровное','rovnoe','','Russia',643,'Europe/Moscow'),(302,'Родино','rodino','','Russia',643,'Asia/Omsk'),(2223,'Родники','rodniki','','Russia',643,'Europe/Moscow'),(402,'Романовка','romanovka','','Russia',643,'Europe/Volgograd'),(2224,'Романовская','romanovskaia','','Russia',643,'Europe/Moscow'),(9334,'Ромны','Romny','','Russia',643,'Asia/Yakutsk'),(1305,'Рославль','roslavl','','Russia',643,'Europe/Moscow'),(2225,'Россошь','rososh','','Russia',643,'Europe/Uzhgorod'),(9920,'Россошь','Rossoshi','','Russia',643,'Asia/Omsk'),(1605,'Ростов Великий','rostov','','Russia',643,'Europe/Moscow'),(1047,'Ростов-на-Дону','rostov-na-donu','','Russia',643,'Europe/Moscow'),(11121,'Рошаль','Roshaly','','Russia',643,''),(1227,'Рощино','roscino','','Russia',643,'Europe/Moscow'),(1247,'Ртищево','rtiscevo','','Russia',643,'Europe/Volgograd'),(303,'Рубцовск','rubcovsk','','Russia',643,'Asia/Omsk'),(1024,'Рудная Пристань','rudnaj-pristan','','Russia',643,''),(11650,'Рудный','Rudniy','','Russia',643,'Asia/Qyzylorda'),(9759,'Рудня','Rudya','','Russia',643,'Europe/Zaporozhye'),(2228,'Руза','ruza','','Russia',643,'Europe/Moscow'),(12054,'Рузаевка','Ruzaevka','','Russia',643,'Europe/Moscow'),(946,'Русская Поляна','pusskaja-poljana','','Russia',643,''),(2229,'Русский Камешкир','russkiy kemeshkir','','Russia',643,'Europe/Moscow'),(2230,'Рутул','rutul','','Russia',643,'Europe/Moscow'),(1606,'Рыбинск','rybinsk','','Russia',643,'Asia/Novosibirsk'),(2231,'Рыбная Слобода','ribnaia sloboda','','Russia',643,'Europe/Moscow'),(2232,'Рыбное','ribnoe','','Russia',643,'Europe/Ljubljana'),(747,'Рыльск','rylsk','','Russia',643,'Europe/Moscow'),(1055,'Ряжск','rjazsk','','Russia',643,'Europe/Moscow'),(86825,'Ряжск','Ryazhsk','','Russia',643,'Europe/Moscow'),(1056,'Рязань','rjazan','','Russia',643,'Europe/Moscow'),(2233,'Сакмара','sakmara','','Russia',643,'Asia/Yekaterinburg'),(2234,'Салават','salavat','','Russia',643,'Asia/Yekaterinburg'),(1624,'Салемал','salemal','','Russia',643,'Asia/Yekaterinburg'),(1625,'Салехард','salehard','','Russia',643,'Asia/Yekaterinburg'),(86830,'Салехард','Salekhard','','Russia',643,'Asia/Yekaterinburg'),(2235,'Сальск','salsk','','Russia',643,'Europe/Moscow'),(1233,'Самара','samara','','Russia',643,'Europe/Samara'),(2002,'Самара','kuibishev','','Russia',643,'Europe/Moscow'),(1025,'Самарка','samarka','','Russia',643,'Asia/Omsk'),(12418,'Самарское','Samarskoe','','Russia',643,'Europe/Sofia'),(12126,'Сангар','Sangar','','Russia',643,'Asia/Yakutsk'),(1116,'Сангары','sangary','','Russia',643,''),(773,'Санкт-Петербург','sankt-peterburg','','Russia',643,'Europe/Moscow'),(2236,'Санчурск','sanchursk','','Russia',643,'Europe/Volgograd'),(2237,'Сапожок','sapozok','','Russia',643,'Europe/Moscow'),(11503,'Сара','Sara','','Russia',643,'Europe/Moscow'),(2238,'Сараи','sarai','','Russia',643,'Europe/Moscow'),(11505,'Саракташ','Saraktash','','Russia',643,'Asia/Yekaterinburg'),(1489,'Саранпауль','saran-paul','','Russia',643,''),(785,'Саранск','saransk','','Russia',643,'Europe/Moscow'),(1399,'Сарапул','sarapul','','Russia',643,'Europe/Samara'),(1248,'Саратов','saratov','','Russia',643,'Europe/Volgograd'),(947,'Саргатское','sargatskoe','','Russia',643,'Asia/Omsk'),(2239,'Сарманово','sarmanovo','','Russia',643,'Europe/Moscow'),(880,'Саров','Sarov','','Russia',643,'Europe/Moscow'),(11598,'Сарс','Sars','','Russia',643,'Asia/Yekaterinburg'),(1318,'Сарыг-Сеп','saryg-sep','','Russia',643,'Asia/Krasnoyarsk'),(1118,'Саскылах','saskylah','','Russia',643,''),(1057,'Сасово','sasovo','','Russia',643,'Europe/Moscow'),(2240,'Сатка','satka','','Russia',643,'Asia/Yekaterinburg'),(2241,'Сафоново','safonovo','','Russia',643,'Europe/Moscow'),(2242,'Саяногорск','saianogorsk','','Russia',643,'Asia/Krasnoyarsk'),(2243,'Саянск','saiansk','','Russia',643,'Asia/Irkutsk'),(86832,'Саянск','Sayansk','','Russia',643,'Asia/Irkutsk'),(2244,'Светлогорск','svetlogorsk','','Russia',643,'Europe/Kaliningrad'),(1228,'Светлоград','svetlograd','','Russia',643,'Europe/Moscow'),(636,'Светлолобово','svetlolobovo','','Russia',643,'Asia/Irkutsk'),(505,'Светлый','svetlyj','','Russia',643,'Europe/Kaliningrad'),(2245,'Светлый','svetliy','','Russia',643,'Europe/Kaliningrad'),(2247,'Светлый Яр','svetliy iar','','Russia',643,''),(10757,'Светогорск','Svetogorsk','','Russia',643,'Europe/Moscow'),(10092,'Свирск','Svirsk','','Russia',643,'Asia/Irkutsk'),(1026,'Свиягино','svijagino','','Russia',643,''),(332,'Свободный','svobodnyj','','Russia',643,'Asia/Yakutsk'),(12617,'Свободный','Svobodniy','','Russia',643,'Asia/Yakutsk'),(12653,'Свободный','Svobodnaya','','Russia',643,'Asia/Sakhalin'),(2248,'Себеж','sebez','','Russia',643,'Europe/Moscow'),(907,'Северный','severnoe','','Russia',643,'Asia/Novosibirsk'),(11128,'Северный','Severniy','','Russia',643,'Asia/Krasnoyarsk'),(637,'Северо-Енисейск','severo-eniseji','','Russia',643,'Asia/Krasnoyarsk'),(1267,'Северо-Курильск','severo-kurilsk','','Russia',643,'Asia/Magadan'),(2249,'Северобайкальск','severobaikalsk','','Russia',643,'Asia/Irkutsk'),(366,'Северодвинск','severodvinsk','','Russia',643,'Europe/Moscow'),(2250,'Североморск','severomorsk','','Russia',643,'Europe/Moscow'),(1295,'Североуральск','severouralsk','','Russia',643,'Asia/Yekaterinburg'),(2251,'Северская','severskaia','','Russia',643,'Asia/Yekaterinburg'),(543,'Сегежа','segeza','','Russia',643,'Europe/Moscow'),(2252,'Седельниково','sedelnikovo','','Russia',643,'Asia/Omsk'),(808,'Сеймчан','sejmchan','','Russia',643,''),(1455,'Сектагли','sektagli','','Russia',643,'Asia/Vladivostok'),(11824,'Селенгинск','Selenginsk','','Russia',643,'Asia/Irkutsk'),(13223,'Селим','Salim','','Russia',643,'Asia/Ulaanbaatar'),(1400,'Селты','selty','','Russia',643,'Europe/Samara'),(9588,'Сельцо','Selyco','','Russia',643,''),(2253,'Семёнов','semenov','','Russia',643,'Europe/Moscow'),(11321,'Семёновка','Semenovka','','Russia',643,'Europe/Moscow'),(2254,'Семикаракорск','semikarakorsk','','Russia',643,'Europe/Moscow'),(9924,'Семилуки','Semiluki','','Russia',643,'Europe/Moscow'),(685,'Семячик','semjchik','','Russia',643,'Europe/Moscow'),(2255,'Сенгилей','sengelei','','Russia',643,'Europe/Moscow'),(450,'Серафимович','serafimovic','','Russia',643,''),(11775,'Серафимовский','Serafimovskiy','','Russia',643,'Asia/Yekaterinburg'),(11599,'Серга','Serga','','Russia',643,'Asia/Yekaterinburg'),(881,'Сергач','sergac','','Russia',643,'Europe/Prague'),(333,'Сергеевка','sergeevka','','Russia',643,'Europe/Moscow'),(2256,'Сергиев Посад','sergiev posad','','Russia',643,'Europe/Moscow'),(10965,'Сергиев Посад','Zagorsk','','Russia',643,'Europe/Moscow'),(433,'Сергокала','sergokala','','Russia',643,'Europe/Moscow'),(2257,'Сердобск','serdobsk','','Russia',643,'Europe/Moscow'),(2258,'Серебряные Пруды','seredrianie prudi','','Russia',643,''),(2259,'Сернур','sernur','','Russia',643,'Europe/Moscow'),(1584,'Серов','serov','','Russia',643,'Asia/Yekaterinburg'),(836,'Серпухов','serpuhov','','Russia',643,'Europe/Moscow'),(2260,'Серышево','serishevo','','Russia',643,'Europe/Volgograd'),(2261,'Сеченово','sechenovo','','Russia',643,'Europe/Moscow'),(1626,'Сеяха','sejxa','','Russia',643,'Asia/Qatar'),(2262,'Сибай','sibai','','Russia',643,'Asia/Yekaterinburg'),(86843,'Сибай','Sibay','','Russia',643,'Asia/Yekaterinburg'),(9386,'Сибсы','Kuya','','Russia',643,'Europe/Moscow'),(2263,'Сива','siva','','Russia',643,'Asia/Yekaterinburg'),(10761,'Сиверский','Siverskiy','','Russia',643,'Europe/Moscow'),(11346,'Синъань','Burga','','Russia',643,'Europe/Moscow'),(9412,'Сия','Siya','','Russia',643,'Europe/Moscow'),(334,'Сковородино','skovorodino','','Russia',643,'Asia/Yakutsk'),(2264,'Скопин','skopin','','Russia',643,'Europe/Moscow'),(9338,'Слава','Slava','','Russia',643,'Asia/Yakutsk'),(304,'Славгород','slavgorod','','Russia',643,'Asia/Omsk'),(10159,'Славск','Slavsk','','Russia',643,'Europe/Kaliningrad'),(11654,'Славянка','Slavyanka','','Russia',643,'Asia/Vladivostok'),(584,'Славянск-на-Кубани','slavjansk-na-kubany','','Russia',643,'Europe/Moscow'),(86844,'Славянск-на-Кубани','Slavyansk-na-Kubani','','Russia',643,'Europe/Moscow'),(1381,'Сладково','sladkovo','','Russia',643,'Asia/Yekaterinburg'),(2265,'Сланцы','slanci','','Russia',643,'Europe/Moscow'),(755,'Слаутное','slautnoe','','Russia',643,''),(2266,'Слободской','slobodskiy','','Russia',643,'Europe/Moscow'),(2267,'Слюдянка','sliudianka','','Russia',643,'Asia/Irkutsk'),(1456,'Смидович','smidovic','','Russia',643,''),(2268,'Смирных','smirnih','','Russia',643,''),(1306,'Смоленск','smolensk','','Russia',643,'Europe/Moscow'),(13262,'Снежинск','Sneginsk','','Russia',643,''),(86845,'Снежинск','Snezhinsk','','Russia',643,'Asia/Yekaterinburg'),(2270,'Снежногорск','sneznegorsk','','Russia',643,'Europe/Moscow'),(9654,'Собинка','Sobinka','','Russia',643,'Europe/Moscow'),(2271,'Соболево','sobolevo','','Russia',643,'Asia/Kamchatka'),(658,'Советск','sovetsk','','Russia',643,'Europe/Kaliningrad'),(10429,'Советская','Sovetskaya','','Russia',643,'Europe/Moscow'),(1457,'Советская Гавань','sovetskaja-gavan','','Russia',643,'Asia/Vladivostok'),(638,'Советская Речка','sovetskaja-rechka','','Russia',643,'Asia/Krasnoyarsk'),(2273,'Советский','sovetskiy','','Russia',643,'Europe/Moscow'),(1120,'Сого-Хая','sogo-haja','','Russia',643,''),(9254,'Соколово','Sokolovo','','Russia',643,'Asia/Omsk'),(12251,'Сокулка','Sokolka','','Russia',643,'Europe/Moscow'),(1458,'Солекуль','solekul','','Russia',643,''),(10430,'Солёное','Solionoe','','Russia',643,'America/Sao_Paulo'),(2274,'Солигалич','soligalich','','Russia',643,'Europe/Moscow'),(2275,'Соликамск','solikamsk','','Russia',643,'Asia/Yekaterinburg'),(506,'Солнечная','solnethnaya','','Russia',643,'Asia/Vladivostok'),(2276,'Солнечногорск','solnechnogorsk','','Russia',643,'Europe/Moscow'),(12794,'Солнечнодольск','Solnecnodolysk','','Russia',643,''),(2277,'Солнечный','solnechniy','','Russia',643,'Asia/Vladivostok'),(2278,'Соловки','solovki','','Russia',643,'Europe/Moscow'),(1549,'Соловьевск','solovevsk','','Russia',643,'Asia/Yakutsk'),(305,'Солонешное','soloneshnoe','','Russia',643,'Asia/Omsk'),(2490,'Солоновка','Solonovka','','Russia',643,'Asia/Omsk'),(2279,'Соль-Илецк','sol-iletsk','','Russia',643,'Asia/Yekaterinburg'),(2280,'Сольвычегодск','solvichegodsk','','Russia',643,''),(11393,'Сольцы','Solyci','','Russia',643,''),(9926,'Сомово','Somovo','','Russia',643,'Europe/Moscow'),(1392,'Сопочная карга','sopochnaj-karga','','Russia',643,''),(2281,'Сорочинск','sorochinsk','','Russia',643,'Asia/Yekaterinburg'),(12291,'Сорск','Sorsk','','Russia',643,'Asia/Krasnoyarsk'),(544,'Сортавала','sortavala','','Russia',643,'Europe/Moscow'),(10208,'Сосенский','Sosenskiy','','Russia',643,'Europe/Moscow'),(2283,'Сосково','soskovo','','Russia',643,'Europe/Moscow'),(11940,'Сосновец','Sosnovec','','Russia',643,'Europe/Warsaw'),(1319,'Сосновка','sosnovka','','Russia',643,'Europe/Moscow'),(774,'Сосново','sosnovo','','Russia',643,'Europe/Moscow'),(404,'Сосново-Озерское','sosnovo-ozersk','','Russia',643,'Europe/Moscow'),(10556,'Сосновоборск','Sosnoborsk','','Russia',643,'Asia/Krasnoyarsk'),(11941,'Сосновый','Sosnoviy','','Russia',643,'Asia/Irkutsk'),(2284,'Сосновый Бор','Sosnovii Bor','','Russia',643,'Europe/Moscow'),(10766,'Сосновый Бор','Sosnoviy  Bor','','Russia',643,'Europe/Moscow'),(86848,'Сосновый Бор','Sosnovy Bor','','Russia',643,'Europe/Moscow'),(2285,'Сосногорск','sosnogorsk','','Russia',643,'Europe/Moscow'),(1027,'Сосуново','sosunovo','','Russia',643,'Europe/Moscow'),(1490,'Сосьва','sosva','','Russia',643,'Asia/Yekaterinburg'),(11135,'Софрино','Sofrino','','Russia',643,'Europe/Moscow'),(585,'Сочи','Adler','','Russia',643,'Europe/Moscow'),(664,'Спас-Деменск','spas-demensk','','Russia',643,'Europe/Moscow'),(12478,'Спас-Клепики','Spas-Klepiki','','Russia',643,'Europe/Moscow'),(2286,'Спасск-Дальний','spask-dalniy','','Russia',643,'Asia/Vladivostok'),(12479,'Спасск-Рязанский','Spassk-Riazanskiy','','Russia',643,'Europe/Moscow'),(2491,'Спасский','Spasskiy','','Russia',643,'Asia/Yekaterinburg'),(11796,'Список персонажей «Блич»','Baunt','','Russia',643,'Asia/Irkutsk'),(1121,'Среднеколымск','srednekolymsk','','Russia',643,'Asia/Magadan'),(12714,'Среднеуральск','Sredneuralysk','','Russia',643,'Asia/Yekaterinburg'),(1363,'Средний Васюган','sredny-vasjugan','','Russia',643,''),(810,'Средникан','srednikan','','Russia',643,''),(2287,'Средняя Ахтуба','sredniaia ahtuba','','Russia',643,''),(1552,'Сретенск','sretensk','','Russia',643,'Asia/Yakutsk'),(1229,'Ставрополь','stavropol','','Russia',643,'Europe/Moscow'),(11137,'Старая Купавна','Staraya Kupavna','','Russia',643,'Europe/Moscow'),(2288,'Старая Русса','staraia rusa','','Russia',643,'Europe/Moscow'),(1339,'Старица','stariza','','Russia',643,'Europe/Moscow'),(1364,'Старица','starica','','Russia',643,'Europe/Moscow'),(10432,'Стародеревянковская','Staroderevyankovskaya','','Russia',643,'Europe/Moscow'),(2289,'Стародуб','starobud','','Russia',643,'Europe/Moscow'),(2290,'Старое Шайгово','stare shaigovo','','Russia',643,''),(2291,'Старожилово','starozilovo','','Russia',643,'Asia/Krasnoyarsk'),(2292,'Староминская','starominskaia','','Russia',643,'Europe/Moscow'),(2293,'Старосубхангулово','starosubhangulovo','','Russia',643,'Asia/Yekaterinburg'),(10435,'Старотитаровская','Starotitarovskaya','','Russia',643,'Europe/Moscow'),(10436,'Старощербиновская','Starocherbinovskaya','','Russia',643,''),(2294,'Староюрьево','staroiurievo','','Russia',643,'Asia/Yekaterinburg'),(419,'Старый Оскол','staryj-oskol','','Russia',643,'Europe/Moscow'),(86850,'Старый Оскол','Stary Oskol','','Russia',643,'Europe/Moscow'),(1365,'Степановка','stepanovka','','Russia',643,'Europe/Moscow'),(2295,'Стерлибашево','sterlibashivo','','Russia',643,''),(384,'Стерлитамак','sterlitamak','','Russia',643,'Asia/Yekaterinburg'),(1122,'Столб','stolb','','Russia',643,'Asia/Kamchatka'),(2296,'Стрежевой','strezevoi','','Russia',643,'Asia/Novosibirsk'),(639,'Стрелка','strelka','','Russia',643,'Asia/Krasnoyarsk'),(9524,'Строитель','Stroitely','','Russia',643,'Europe/Moscow'),(2297,'Струги-Красные','strugi-krasnie','','Russia',643,'Europe/Moscow'),(9657,'Струнино','Strunino','','Russia',643,'Europe/Moscow'),(2298,'Ступино','stupino','','Russia',643,'Europe/Moscow'),(2299,'Суворов Александр Васильевич','suvorov','','Russia',643,'Europe/Moscow'),(9841,'Суда','Suda','','Russia',643,'Europe/Moscow'),(9658,'Судогда','Sudogda','','Russia',643,'Europe/Moscow'),(2300,'Суздаль','suzdal','','Russia',643,'Europe/Moscow'),(908,'Сузун','suzun','','Russia',643,'Asia/Novosibirsk'),(2301,'Суксун','suksun','','Russia',643,'Asia/Yekaterinburg'),(11446,'Сумы','Sumi','','Russia',643,'Europe/Kiev'),(2302,'Суна','suna','','Russia',643,'Europe/Volgograd'),(1123,'Сунтар','suntar','','Russia',643,'Asia/Yakutsk'),(545,'Суоярви','suojarvi','','Russia',643,'Europe/Moscow'),(367,'Сура','sura','','Russia',643,'Europe/Moscow'),(2303,'Сураж','suraz','','Russia',643,'Europe/Moscow'),(1491,'Сургут','surgut','','Russia',643,'Asia/Yekaterinburg'),(9770,'Суровикино','Surovikino','','Russia',643,'Europe/Volgograd'),(11565,'Сурск','Sursk','','Russia',643,'Europe/Moscow'),(2304,'Сурское','surskoe','','Russia',643,'Europe/Moscow'),(811,'Сусуман','susuman','','Russia',643,'Asia/Magadan'),(2492,'Сухая','Suhaja','','Russia',643,''),(665,'Сухиничи','suhinici','','Russia',643,''),(640,'Сухобузимское','suhobuzimskoe','','Russia',643,''),(12427,'Сухой','Suhoy','','Russia',643,''),(12717,'Сухой Лог','Suhoy Log','','Russia',643,'Asia/Omsk'),(11147,'Сходня','Shodnia','','Russia',643,''),(1234,'Сызрань','syzran','','Russia',643,'Europe/Samara'),(561,'Сыктывкар','syktyvkar','','Russia',643,'Europe/Moscow'),(641,'Сым','sym','','Russia',643,'Asia/Krasnoyarsk'),(1297,'Сысерть','syrert','','Russia',643,'America/New_York'),(1492,'Сытомино','sytomino','','Russia',643,'Asia/Yekaterinburg'),(2306,'Сычевка','sichevka','','Russia',643,''),(2307,'Сюмси','siumsi','','Russia',643,'Europe/Samara'),(10769,'Сясьстрой','Siasystroy','','Russia',643,''),(1298,'Таборы','tabory','','Russia',643,'Asia/Yekaterinburg'),(1299,'Тавда','tavda','','Russia',643,'Asia/Yekaterinburg'),(1048,'Таганрог','taganrog','','Russia',643,'Europe/Moscow'),(1628,'Тазовский','tazovskiy','','Russia',643,'Asia/Yekaterinburg'),(701,'Тайга','tajga','','Russia',643,'Asia/Novokuznetsk'),(812,'Тайгонос','tajgonos','','Russia',643,''),(508,'Тайшет','tajshet','','Russia',643,'Europe/Zaporozhye'),(405,'Таксимо','taksimo','','Russia',643,'Asia/Irkutsk'),(813,'Талая','talaja','','Russia',643,'Asia/Kolkata'),(2309,'Талдом','taldom','','Russia',643,'Europe/Moscow'),(2310,'Талица','talica','','Russia',643,'Asia/Yekaterinburg'),(10559,'Талнах','Talnah','','Russia',643,'Asia/Krasnoyarsk'),(2311,'Таловая','talovaia','','Russia',643,'Europe/Moscow'),(814,'Талон','talon','','Russia',643,'Asia/Magadan'),(306,'Тальменка','talmenka','','Russia',643,'Asia/Omsk'),(2312,'Тамала','tamala','','Russia',643,'Europe/Moscow'),(10437,'Тамань','Tamany','','Russia',643,'Europe/Madrid'),(1629,'Тамбей','tambej','','Russia',643,''),(1330,'Тамбов','tambov','','Russia',643,'Europe/Moscow'),(2313,'Тамбовка','tambovka','','Russia',643,'Asia/Yakutsk'),(10097,'Танга','Tanga','','Russia',643,'Asia/Yakutsk'),(509,'Тангуй','tanguj','','Russia',643,''),(510,'Танхой','tanhoj','','Russia',643,''),(1585,'Танюрер','tanjuer','','Russia',643,''),(948,'Тара','tara','','Russia',643,'Asia/Krasnoyarsk'),(2314,'Тарбагатай','tabagatai','','Russia',643,'Europe/Helsinki'),(1630,'Тарко-Сале','tarko-sale','','Russia',643,'Asia/Yekaterinburg'),(2315,'Тарногский Городок','tarnogskiy gorodok','','Russia',643,'Europe/Moscow'),(2316,'Тарумовка','tarumovka','','Russia',643,'Europe/Moscow'),(642,'Тасеево','tassevo','','Russia',643,'Europe/Moscow'),(909,'Татарск','tatarsk','','Russia',643,'Asia/Novosibirsk'),(12796,'Тахта','Tahta','','Russia',643,'Asia/Beirut'),(2317,'Ташла','tashla','','Russia',643,'Asia/Yekaterinburg'),(2318,'Таштагол','tashtalog','','Russia',643,'Asia/Novokuznetsk'),(86855,'Таштагол','Tashtagol','','Russia',643,'Asia/Novokuznetsk'),(1416,'Таштып','tastyp','','Russia',643,''),(2319,'Тбилисская','tbiliskaia','','Russia',643,'Europe/Moscow'),(1340,'Тверь','tver','','Russia',643,'Europe/Moscow'),(2320,'Теберда','teberda','','Russia',643,'Europe/Moscow'),(949,'Тевриз','tevriz','','Russia',643,'Asia/Omsk'),(1366,'Тегульдет','tegulden','','Russia',643,''),(9985,'Тейково','Teikovo','','Russia',643,'Europe/Moscow'),(10102,'Тельма','Telyma','','Russia',643,''),(10267,'Темиртау','Temirtau','','Russia',643,'Asia/Novokuznetsk'),(2321,'Темкино','temkino','','Russia',643,'Europe/Moscow'),(786,'Темников','temnikov','','Russia',643,'Europe/Moscow'),(2322,'Темрюк','temriuk','','Russia',643,'Europe/Zaporozhye'),(86856,'Темрюк','Temryuk','','Russia',643,'Europe/Moscow'),(2323,'Теньгушево','tengushevo','','Russia',643,''),(1128,'Теплый Ключ','teplyi-kljuch','','Russia',643,''),(2324,'Тербуны','terbuni','','Russia',643,''),(2325,'Терек','terek','','Russia',643,'Europe/Moscow'),(2326,'Терекли-Мектеб','terekli- mekteb','','Russia',643,'Europe/Moscow'),(864,'Териберка','teriberka','','Russia',643,'Europe/Moscow'),(1029,'Терней','ternej','','Russia',643,'Asia/Vladivostok'),(86857,'Терней','Terney','','Russia',643,'Asia/Vladivostok'),(9930,'Терновка','Ternovka','','Russia',643,'Europe/Moscow'),(2327,'Терскол','terskol','','Russia',643,'Europe/Moscow'),(1313,'Тетюши','tetjusi','','Russia',643,'Europe/Moscow'),(1461,'Тивяку','tivjaku','','Russia',643,'Europe/Riga'),(757,'Тигиль','tigil','','Russia',643,'Asia/Kamchatka'),(1129,'Тикси','tiksi','','Russia',643,'Asia/Yakutsk'),(2328,'Тиличики','tilichiki','','Russia',643,'Asia/Anadyr'),(408,'Тилишма','tilishma','','Russia',643,'Asia/Irkutsk'),(748,'Тим','tim','','Russia',643,'Europe/Moscow'),(2329,'Тимашевск','timashevsk','','Russia',643,'Europe/Moscow'),(10160,'Тимирязево','Timiriazevo','','Russia',643,'Asia/Novosibirsk'),(1030,'Тимирязевский','timirjazevskij','','Russia',643,''),(13181,'Тир','Tir','','Russia',643,'Europe/Moscow'),(702,'Тисуль','tisul','','Russia',643,'Asia/Novokuznetsk'),(775,'Тихвин','tihvin','','Russia',643,'Europe/Moscow'),(586,'Тихорецк','tihoreck','','Russia',643,''),(2330,'Тлярата','tliarata','','Russia',643,'Europe/Moscow'),(1382,'Тобольск','tobolsk','','Russia',643,'Asia/Yekaterinburg'),(9417,'Това','Tova','','Russia',643,'Europe/Moscow'),(10210,'Товарково','Tovarkovo','','Russia',643,'Europe/Moscow'),(307,'Тогул','togul','','Russia',643,'Asia/Omsk'),(910,'Тогучин','togucin','','Russia',643,'Asia/Novosibirsk'),(12820,'Токаревка','Tokarevka','','Russia',643,'Europe/Moscow'),(2332,'Токма','tokma','','Russia',643,'Asia/Irkutsk'),(1130,'Токо','toko','','Russia',643,'Asia/Yakutsk'),(2333,'Токсово','toksovo','','Russia',643,'Europe/Moscow'),(2334,'Толбазы','tolbazi','','Russia',643,'Europe/Moscow'),(911,'Толмачёво','tolmachevo','','Russia',643,'Europe/Moscow'),(1631,'Толька','tolka','','Russia',643,'Europe/Warsaw'),(1235,'Тольятти','toljati','','Russia',643,'Europe/Samara'),(2335,'Томари','tomari','','Russia',643,'Asia/Sakhalin'),(11156,'Томилино','Tomilino','','Russia',643,'Europe/Moscow'),(1131,'Томмот','tommot','','Russia',643,'Asia/Yakutsk'),(511,'Томпа','tompa','','Russia',643,'Asia/Irkutsk'),(1132,'Томпо','tompo','','Russia',643,'Asia/Vladivostok'),(1367,'Томск','tomsk','','Russia',643,'Asia/Novosibirsk'),(1133,'Тонгулах','tongulah','','Russia',643,'Asia/Yakutsk'),(2336,'Тоншаево','tonshaevo','','Russia',643,'Europe/Moscow'),(1320,'Тоора-Хем','toora-hem','','Russia',643,''),(1368,'Топки','topki','','Russia',643,'Asia/Novokuznetsk'),(787,'Торбеево','torbeevo','','Russia',643,'Europe/Moscow'),(1341,'Торжок','torzhok','','Russia',643,'Europe/Moscow'),(1342,'Торопец','toropez','','Russia',643,'Europe/Moscow'),(2337,'Тосно','tosno','','Russia',643,'Europe/Moscow'),(461,'Тотьма','totma','','Russia',643,'Europe/Moscow'),(11512,'Тоцкое','Tockoe','','Russia',643,''),(13264,'Трёхгорный','Trehgorniy','','Russia',643,'Europe/Moscow'),(13389,'Трипура','Borok','','Russia',643,'Europe/Moscow'),(1514,'Троицк','troizk','','Russia',643,'Asia/Yekaterinburg'),(10564,'Троицк','Troick','','Russia',643,'Asia/Yekaterinburg'),(10440,'Троицкая','Troickaya','','Russia',643,'Europe/Kiev'),(562,'Троицко-Печорск','troicko-pecerske','','Russia',643,''),(11997,'Троицко-Печорск','Troicko-Pecorsk','','Russia',643,'Europe/Moscow'),(308,'Троицкое','troickoe','','Russia',643,'Asia/Almaty'),(424,'Трубчевск','trubcevsk','','Russia',643,'Europe/Moscow'),(12905,'Труд','Trud','','Russia',643,'Europe/Moscow'),(587,'Туапсе','tuapse','','Russia',643,'Europe/Moscow'),(1300,'Тугулым','tugulym','','Russia',643,'Asia/Yekaterinburg'),(2338,'Туймазы','tuimazi','','Russia',643,'Asia/Yekaterinburg'),(1374,'Тула','tula','','Russia',643,'Europe/Moscow'),(2339,'Тулпан','tulpan','','Russia',643,'Asia/Yekaterinburg'),(512,'Тулун','tulun','','Russia',643,'Asia/Irkutsk'),(11723,'Тульский','Tulyskiy','','Russia',643,'Europe/Moscow'),(1058,'Тума','tuma','','Russia',643,'Europe/Moscow'),(1463,'Тумнин','tumnin','','Russia',643,'Asia/Vladivostok'),(1553,'Тунгокочен','tungokocen','','Russia',643,''),(513,'Тунка','tunka','','Russia',643,'Asia/Irkutsk'),(1554,'Тупик','tupik','','Russia',643,'Asia/Yakutsk'),(1598,'Тура','tura','','Russia',643,'Asia/Krasnoyarsk'),(2340,'Туран','turan','','Russia',643,'Asia/Krasnoyarsk'),(1031,'Турий Рог','turij-rog','','Russia',643,''),(1301,'Туринск','turinsk','','Russia',643,'Asia/Yekaterinburg'),(11830,'Турка','Turka','','Russia',643,'Asia/Irkutsk'),(2342,'Турки','turki','','Russia',643,'Europe/Volgograd'),(282,'Турочак','turocak','','Russia',643,'Asia/Omsk'),(2343,'Турунтаево','turuntaevo','','Russia',643,'Asia/Irkutsk'),(643,'Туруханск','turuhansk','','Russia',643,'Asia/Krasnoyarsk'),(86860,'Туруханск','Turukhansk','','Russia',643,'Asia/Krasnoyarsk'),(368,'Турчасово','turcasovo','','Russia',643,''),(2344,'Тутаев','tutaev','','Russia',643,'Europe/Moscow'),(86861,'Тутаев','Tutayev','','Russia',643,'Europe/Moscow'),(1599,'Тутончаны','tutonchany','','Russia',643,'Asia/Krasnoyarsk'),(11160,'Тучково','Tuckovo','','Russia',643,'Europe/Moscow'),(2345,'Тымовское','timovskoe','','Russia',643,'Europe/Moscow'),(335,'Тында','tynda','','Russia',643,'Asia/Yakutsk'),(514,'Тырка','tyrka','','Russia',643,'Asia/Irkutsk'),(2346,'Тырныауз','tirniuaz','','Russia',643,''),(2347,'Тэли','teli','','Russia',643,'Asia/Krasnoyarsk'),(950,'Тюкалинск','tjukalinsk','','Russia',643,'Asia/Omsk'),(11513,'Тюльган','Tiulygan','','Russia',643,''),(2348,'Тюлячи','tiuliachi','','Russia',643,'Asia/Vladivostok'),(1383,'Тюмень','tjumen','','Russia',643,'Asia/Yekaterinburg'),(1135,'Тюмети','tjumeti','','Russia',643,'Asia/Yekaterinburg'),(644,'Тюхтет','tjuhtet','','Russia',643,''),(1369,'Тяжин','tjazin','','Russia',643,''),(409,'Уакит','uakit','','Russia',643,'Asia/Irkutsk'),(912,'Убинское','ubinskoe','','Russia',643,'Asia/Novosibirsk'),(2349,'Ува','uva','','Russia',643,'Europe/Samara'),(2350,'Уваровка','uvarovka','','Russia',643,'Europe/Moscow'),(2351,'Уварово','uvarovo','','Russia',643,'Europe/Moscow'),(2352,'Уват','uvat','','Russia',643,'Asia/Yekaterinburg'),(2353,'Увельский','uvelskiy','','Russia',643,'Asia/Yekaterinburg'),(1137,'Угино','ugino','','Russia',643,''),(1269,'Углегорск','uglegorsk','','Russia',643,'Asia/Sakhalin'),(2354,'Углич','uglich','','Russia',643,'Europe/Moscow'),(309,'Угловское','uglovskoe','','Russia',643,'Asia/Omsk'),(1494,'Угут','ugut','','Russia',643,'Asia/Yekaterinburg'),(12144,'Удачный','Udacniy','','Russia',643,'Europe/Moscow'),(11161,'Удельная','Udelynaia','','Russia',643,''),(12906,'Удомля','Udomlya','','Russia',643,'Europe/Moscow'),(1464,'Удское','udskoe','','Russia',643,''),(815,'Уега','uega','','Russia',643,'Asia/Vladivostok'),(645,'Ужур','uzur','','Russia',643,'Asia/Krasnoyarsk'),(2355,'Узловая','uzlovaia','','Russia',643,'Europe/Moscow'),(2357,'Уинское','uinskoe','','Russia',643,'Asia/Yekaterinburg'),(13266,'Уйское','Uyskoe','','Russia',643,'Europe/Moscow'),(11468,'Украинка','Urkainka','','Russia',643,'Europe/Samara'),(410,'Улан-Удэ','ulanude','','Russia',643,'Asia/Irkutsk'),(13183,'Улан-Удэ','Udinsk','','Russia',643,'Asia/Irkutsk'),(1555,'Улеты','ulety','','Russia',643,'Asia/Yakutsk'),(1465,'Улья','ulja','','Russia',643,'Europe/Tallinn'),(10775,'Ульяновка','Ulyanovka','','Russia',643,'Europe/Moscow'),(1404,'Ульяновск','ulyanovsk','','Russia',643,'Europe/Moscow'),(866,'Умба','umba','','Russia',643,'Europe/Moscow'),(425,'Унеча','unechja','','Russia',643,'Europe/Moscow'),(718,'Уни','uni','','Russia',643,'Europe/Volgograd'),(2359,'Упорово','uporovo','','Russia',643,'Asia/Yekaterinburg'),(867,'Ура-Губа','ura-guba','','Russia',643,'Europe/Moscow'),(2360,'Урай','urai','','Russia',643,'Asia/Yekaterinburg'),(11784,'Уральск','Uralysk','','Russia',643,'Asia/Oral'),(2361,'Уренгойское газовое месторождение','urengoi','','Russia',643,'Asia/Yekaterinburg'),(11330,'Урень','Ureny','','Russia',643,''),(2362,'Уржум','urzum','','Russia',643,'Europe/Volgograd'),(2363,'Уркарах','urkarah','','Russia',643,''),(1466,'Урми','urmi','','Russia',643,'Asia/Vladivostok'),(1270,'Уруп','urup','','Russia',643,'Asia/Magadan'),(2364,'Урус-Мартан','urus-martan','','Russia',643,'Europe/Moscow'),(2365,'Уруссу','urusu','','Russia',643,'Africa/Lubumbashi'),(451,'Урюпинск','urjupinsk','','Russia',643,'Europe/Volgograd'),(2366,'Усинск','usinsk','','Russia',643,'Europe/Moscow'),(2367,'Усман','usman','','Russia',643,'Europe/Moscow'),(2368,'Усолье','usolie','','Russia',643,'Asia/Yekaterinburg'),(515,'Усолье-Сибирское','usole-sibirskoe','','Russia',643,'Asia/Irkutsk'),(2369,'Успенское','uspenskoe','','Russia',643,'Europe/Moscow'),(2370,'Уссурийск','usuriisk','','Russia',643,'Asia/Vladivostok'),(2371,'Усть-Абакан','ust-akaban','','Russia',643,''),(412,'Усть-Баргузин','ust-barguzin','','Russia',643,'Asia/Irkutsk'),(758,'Усть-Воямполка','ustvajampolka','','Russia',643,''),(2372,'Усть-Джегута','ust-dzeguta','','Russia',643,'Europe/Moscow'),(12431,'Усть-Донецкий','Usty-Doneckiy','','Russia',643,'Europe/Moscow'),(516,'Усть-Илимск','ust-ilimsk','','Russia',643,'Asia/Irkutsk'),(951,'Усть-Ишим','ust-isim','','Russia',643,''),(2373,'Усть-Калманка','ust-kalmanka','','Russia',643,'Asia/Omsk'),(1600,'Усть-Камо','ust-kamo','','Russia',643,'Asia/Krasnoyarsk'),(687,'Усть-Камчатск','ust-kamcatsk','','Russia',643,'Asia/Kamchatka'),(283,'Усть-Кан','ust-kan','','Russia',643,'Asia/Omsk'),(1556,'Усть-Кара','ust-kara','','Russia',643,'Asia/Yekaterinburg'),(1557,'Усть-Каренга','ust-karenga','','Russia',643,'Asia/Yakutsk'),(13268,'Усть-Катав','Usty-Katav','','Russia',643,'Asia/Yekaterinburg'),(2374,'Усть-Кишерть','ust-kushert','','Russia',643,'Asia/Yekaterinburg'),(284,'Усть-Кокса','ust-koksa','','Russia',643,'Asia/Omsk'),(563,'Усть-Кулом','ust-kulom','','Russia',643,'Europe/Moscow'),(517,'Усть-Кут','ust-kut','','Russia',643,'Asia/Irkutsk'),(588,'Усть-Лабинск','ust-labinsk','','Russia',643,'Europe/Moscow'),(1138,'Усть-Мая','ust-maja','','Russia',643,'Asia/Vladivostok'),(1139,'Усть-Миль','ust-mil','','Russia',643,'Asia/Vladivostok'),(1140,'Усть-Мома','ust-moma','','Russia',643,'Europe/Rome'),(336,'Усть-Нюкжа','ust-njukza','','Russia',643,''),(1586,'Усть-Олой','ust-oloj','','Russia',643,'Europe/Helsinki'),(816,'Усть-Омчуг','ust-omchug','','Russia',643,'Asia/Magadan'),(1406,'Усть-Ордынский','ust-ordynskij','','Russia',643,'Asia/Irkutsk'),(914,'Усть-Тарка','ust-tarka','','Russia',643,'Asia/Novosibirsk'),(518,'Усть-Уда','ust-uda','','Russia',643,'Asia/Irkutsk'),(2375,'Усть-Улаган','ust-ulagan','','Russia',643,'Asia/Omsk'),(1467,'Усть-Умальта','ust-umalta','','Russia',643,''),(564,'Усть-Уса','ust-usa','','Russia',643,'Europe/Moscow'),(565,'Усть-Цильма','ust-cilma','','Russia',643,''),(1142,'Усть-Юдома','ust-judoma','','Russia',643,''),(2376,'Устюжна','ustiuzna','','Russia',643,'Europe/Moscow'),(86870,'Устюжна','Ustyuzhna','','Russia',643,'Europe/Moscow'),(1558,'Усугли','usugli','','Russia',643,'Asia/Yakutsk'),(385,'Уфа','ufa','','Russia',643,'Asia/Yekaterinburg'),(566,'Ухта','uhta','','Russia',643,'Europe/Moscow'),(11787,'Учалы','Ucali','','Russia',643,''),(1601,'Учами','uchami','','Russia',643,'Asia/Krasnoyarsk'),(2379,'Уэлен','гудут','','Russia',643,''),(86863,'Уэлен','Uelen','','Russia',643,'Asia/Anadyr'),(647,'Уяр','ujar','','Russia',643,'Asia/Krasnoyarsk'),(86730,'Фатеж','Fatezh','','Russia',643,'Europe/Moscow'),(2382,'Федоровка','fedodovka','','Russia',643,'Europe/Samara'),(12432,'Фёдоровка','Fedorovka','','Russia',643,'Europe/Samara'),(11602,'Фоки','Foki','','Russia',643,'Asia/Yekaterinburg'),(9597,'Фокино','Fokino','','Russia',643,'Asia/Vladivostok'),(452,'Фролово','frolovo','','Russia',643,'Europe/Volgograd'),(11167,'Фрязино','Friazino','','Russia',643,'Europe/Moscow'),(11168,'Фряново','Frianovo','','Russia',643,'Europe/Moscow'),(9986,'Фурманов','Furmanov','','Russia',643,'Europe/Moscow'),(1468,'Хабаровск','habarovsk','','Russia',643,'Asia/Vladivostok'),(275,'Хабары','habary','','Russia',643,''),(10442,'Хадыженск','Hadigensk','','Russia',643,''),(1417,'Хакасская','hakasskaja','','Russia',643,'Asia/Novosibirsk'),(519,'Хамар-Дабан','hamar-daban','','Russia',643,''),(9352,'Хани','Hany','','Russia',643,'Europe/Tallinn'),(1495,'Ханты-Мансийск','hanty-mansijsk','','Russia',643,'Asia/Yekaterinburg'),(376,'Харабали','harabali','','Russia',643,'Europe/Volgograd'),(434,'Хасавюрт','hasavjurt','','Russia',643,'Europe/Moscow'),(86748,'Хасавюрт','Khasavyurt','','Russia',643,'Europe/Moscow'),(2384,'Хасан','hasan','','Russia',643,'Europe/Helsinki'),(86747,'Хасан','Khasan','','Russia',643,'Asia/Vladivostok'),(1393,'Хатанга','hatanga','','Russia',643,'Asia/Krasnoyarsk'),(1249,'Хвалынск','hvalynsk','','Russia',643,'Europe/Volgograd'),(2385,'Хвойная','hvoinaia','','Russia',643,''),(2386,'Хворостянка','hvorostianka','','Russia',643,'Europe/Samara'),(818,'Хейджан','hejdzhan','','Russia',643,''),(1559,'Хилок','hilok','','Russia',643,'Asia/Yakutsk'),(2389,'Химки','himki','','Russia',643,'Europe/Moscow'),(2390,'Хиславичи','hislavichi','','Russia',643,'Europe/Moscow'),(1321,'Хову-Аксы','havu-aksy','','Russia',643,''),(2391,'Холм','holm','','Russia',643,'Europe/Moscow'),(2392,'Холм-Жирковский','holm-zirovskiy','','Russia',643,'Europe/Moscow'),(369,'Холмогоры','holmogory','','Russia',643,'Europe/Moscow'),(86749,'Холмогоры','Kholmogory','','Russia',643,'Europe/Moscow'),(1271,'Холмск','holmsk','','Russia',643,'Asia/Sakhalin'),(2393,'Хомутовка','homutovka','','Russia',643,'Europe/Moscow'),(13187,'Хор','Hor','','Russia',643,'Europe/Moscow'),(933,'Хорей-Вер','chorei-ver','','Russia',643,''),(414,'Хоринск','horinsk','','Russia',643,''),(1032,'Хороль','hkorol','','Russia',643,'Asia/Vladivostok'),(2394,'Хоста','hosta','','Russia',643,'Europe/Paris'),(10213,'Хотьково','Hotykovo','','Russia',643,'Europe/Moscow'),(10121,'Хужир','Hugir','','Russia',643,'Europe/Paris'),(1469,'Хуларин','hularin','','Russia',643,''),(13231,'Хулимсунт','Hulimsunt','','Russia',643,''),(2395,'Хунзах','hunzah','','Russia',643,''),(12276,'Хут','Hut','','Russia',643,'Europe/Moscow'),(1049,'Целина','celina','','Russia',643,'America/New_York'),(310,'Целинное','celinnoe','','Russia',643,'Asia/Almaty'),(705,'Центральный рудник','centralnyj-rudnik','','Russia',643,''),(2396,'Цивильск','tsivilsk','','Russia',643,'Europe/Moscow'),(1050,'Цимлянск','cimljansk','','Russia',643,'Europe/Moscow'),(86859,'Цимлянск','Tsimlyansk','','Russia',643,'Europe/Moscow'),(1470,'Циммермановка','cimmermanovka','','Russia',643,''),(868,'Цып-Наволок','zyp-navolok','','Russia',643,''),(869,'Чаваньга','chavanga','','Russia',643,'Europe/Moscow'),(2398,'Чагода','chagoda','','Russia',643,'Europe/Moscow'),(1322,'Чадан','chadan','','Russia',643,'Asia/Krasnoyarsk'),(1146,'Чаингда','chaingda','','Russia',643,''),(983,'Чайковский','chajkovskij','','Russia',643,''),(86714,'Чайковский','Chaykovskiy','','Russia',643,'Asia/Yekaterinburg'),(12435,'Чалтырь','Caltiry','','Russia',643,''),(2399,'Чамзинка','chamzinka','','Russia',643,'Europe/Moscow'),(915,'Чаны','cany','','Russia',643,'Asia/Novosibirsk'),(2467,'Чапаевск','Chapayevsk','','Russia',643,'Europe/Samara'),(10817,'Чаплыгин','Capligin','','Russia',643,''),(1561,'Чара','cara','','Russia',643,'Europe/Oslo'),(311,'Чарышское','charyshskoe','','Russia',643,'Asia/Omsk'),(1020,'Частично упорядоченное множество','poset','','Russia',643,''),(1587,'Чаун','chaun','','Russia',643,'Asia/Anadyr'),(2402,'Чебаркуль','chebarkul','','Russia',643,'Asia/Yekaterinburg'),(1501,'Чебоксары','cebokcary','','Russia',643,'Europe/Moscow'),(86715,'Чебоксары','Cheboksary','','Russia',643,'Europe/Moscow'),(2403,'Чегдомын','chegdomin','','Russia',643,'Asia/Vladivostok'),(2404,'Чекмагуш','chekmazush','','Russia',643,''),(1471,'Чекунда','cekunda','','Russia',643,''),(2405,'Челно-Вершины','chelno-vershini','','Russia',643,'Europe/Samara'),(86716,'Челюскин','Chelyuskin','','Russia',643,'Asia/Krasnoyarsk'),(1515,'Челябинск','cheljabinsk','','Russia',643,'Asia/Yekaterinburg'),(285,'Чемал','cemal','','Russia',643,'Asia/Omsk'),(1602,'Чемдальск','chemdalsk','','Russia',643,'Asia/Krasnoyarsk'),(520,'Червянка','chervjanka','','Russia',643,'Europe/Moscow'),(2407,'Чердаклы','cerdakli','','Russia',643,'Europe/Istanbul'),(984,'Чердынь','cerdyn','','Russia',643,''),(1418,'Черемушки','cheremushki','','Russia',643,'Asia/Krasnoyarsk'),(521,'Черемхово','cheremhovo','','Russia',643,'Asia/Irkutsk'),(13303,'Черемхово','Ceremhovo','','Russia',643,'Asia/Irkutsk'),(2408,'Черемшан','ceremshan','','Russia',643,''),(11451,'Черепаново','Cerepanovo','','Russia',643,'Asia/Novosibirsk'),(462,'Череповец','cerepovec','','Russia',643,'Europe/Moscow'),(10818,'Черкассы','Cerkassi','','Russia',643,'Asia/Baku'),(2409,'Черкесск','cerkesk','','Russia',643,'Europe/Moscow'),(86717,'Черкесск','Cherkessk','','Russia',643,'Europe/Moscow'),(952,'Черлак','cerlak','','Russia',643,''),(985,'Чермоз','cermoz','','Russia',643,''),(86718,'Чёрмоз','Chermoz','','Russia',643,'Asia/Yekaterinburg'),(2410,'Черниговка','cernigovka','','Russia',643,'Europe/Zaporozhye'),(9353,'Черниговка','Chernigovka','','Russia',643,'Asia/Vladivostok'),(11176,'Черноголовка','Cernogolovka','','Russia',643,'Europe/Moscow'),(12297,'Черногорск','Cernogorsk','','Russia',643,'Asia/Krasnoyarsk'),(986,'Чернушка','cernuska','','Russia',643,'Europe/Minsk'),(2411,'Черный Яр','cerniy iar','','Russia',643,''),(2412,'Чернышевск','cernishevsk','','Russia',643,''),(1147,'Чернышевский','chernishevskij','','Russia',643,'Asia/Yakutsk'),(9777,'Чернышковский','Cernishkovskiy','','Russia',643,''),(337,'Черняево','cernjaevo','','Russia',643,''),(9527,'Чернянка','Cernyanka','','Russia',643,''),(659,'Черняховск','chernjahovsk','','Russia',643,'Europe/Kaliningrad'),(86719,'Черняховск','Chernyakhovsk','','Russia',643,'Europe/Kaliningrad'),(1148,'Черский','cerskij','','Russia',643,'Asia/Magadan'),(86720,'Черский','Cherskiy','','Russia',643,'Asia/Magadan'),(1051,'Чертково','certkovo','','Russia',643,'Europe/Moscow'),(838,'Черусти','cherusti','','Russia',643,'Europe/Moscow'),(2415,'Чехов','cehov','','Russia',643,'Europe/Moscow'),(11452,'Чик','Cik','','Russia',643,'Asia/Novosibirsk'),(2416,'Чикола','cikola','','Russia',643,'Europe/Zagreb'),(916,'Чистоозерное','chistoozernoe','','Russia',643,'Asia/Novosibirsk'),(1314,'Чистополь','chistopol','','Russia',643,'Europe/Moscow'),(1563,'Чита','chita','','Russia',643,'Asia/Yakutsk'),(2417,'Чишмы','cishmi','','Russia',643,''),(2418,'Чкаловск','ckalovsk','','Russia',643,'Europe/Moscow'),(1149,'Чокурдах','cokurdah','','Russia',643,'Asia/Magadan'),(86721,'Чокурдах','Chokurdakh','','Russia',643,'Asia/Magadan'),(1033,'Чугуевка','cuguevka','','Russia',643,''),(2420,'Чудово','cudovo','','Russia',643,'Europe/Moscow'),(1315,'Чулпаново','culpanovo','','Russia',643,''),(917,'Чулым','culym','','Russia',643,'Asia/Novosibirsk'),(1150,'Чульман','culman','','Russia',643,'Asia/Yakutsk'),(1472,'Чумикан','chumikan','','Russia',643,'Asia/Vladivostok'),(1151,'Чумпурук','chumpuruk','','Russia',643,'Asia/Yakutsk'),(10124,'Чунский','Cunskiy','','Russia',643,''),(13074,'Чур','Cur','','Russia',643,'Asia/Manila'),(1152,'Чурапча','curapca','','Russia',643,'Asia/Yakutsk'),(2421,'Чусовой','cusovoi','','Russia',643,'Europe/Moscow'),(2422,'Чухлома','cuhloma','','Russia',643,'Europe/Stockholm'),(12155,'Чыаппара','Ciappara','','Russia',643,''),(1153,'Чюльбю','cjulbju','','Russia',643,'Europe/Riga'),(719,'Шабалино','sabalino','','Russia',643,'Europe/Moscow'),(2423,'Шаблыкино','shablikino','','Russia',643,'Europe/Moscow'),(2424,'Шагонар','shagonar','','Russia',643,'Asia/Krasnoyarsk'),(738,'Шадринск','sadrinsk','','Russia',643,'Asia/Yekaterinburg'),(1496,'Шаим','saim','','Russia',643,'Europe/Moscow'),(13286,'Шали','Shali','','Russia',643,'Europe/Moscow'),(648,'Шалинское','shalinskoe','','Russia',643,''),(1302,'Шамары','samary','','Russia',643,'Europe/Samara'),(370,'Шангалы','shangaly','','Russia',643,'Europe/Moscow'),(2425,'Шаран','sharan','','Russia',643,'Asia/Yekaterinburg'),(2427,'Шарлык','sharlik','','Russia',643,''),(649,'Шарыпово','sharypovo','','Russia',643,'Asia/Krasnoyarsk'),(727,'Шарья','sarja','','Russia',643,'Europe/Moscow'),(2428,'Шатки','shatki','','Russia',643,'Europe/Moscow'),(2429,'Шатой','shatoi','','Russia',643,'Europe/Moscow'),(739,'Шатрово','satrovo','','Russia',643,'Europe/Moscow'),(2430,'Шатура','shatura','','Russia',643,'Europe/Moscow'),(2431,'Шаховская','shahoskaia','','Russia',643,'Europe/Moscow'),(12656,'Шахтерск','Shahtersk','','Russia',643,'Europe/Zaporozhye'),(2487,'Шахтерский','Shakhterskiy','','Russia',643,'Europe/Moscow'),(1052,'Шахты','sahty','','Russia',643,'Europe/Moscow'),(86838,'Шахты','Shakhty','','Russia',643,'Europe/Moscow'),(882,'Шахунья','sakunja','','Russia',643,''),(12437,'Шебалин Виссарион Яковлевич','Shebalin','','Russia',643,'Europe/Moscow'),(286,'Шебалино','shebalino','','Russia',643,'Asia/Omsk'),(2433,'Шебекино','shebekino','','Russia',643,'Europe/Moscow'),(338,'Шевли','shevli','','Russia',643,'Asia/Vladivostok'),(9847,'Шексна','Sheksna','','Russia',643,'Europe/Moscow'),(312,'Шелаболиха','shelaboliha','','Russia',643,''),(1154,'Шелагонцы','selagoncy','','Russia',643,''),(10126,'Шелехов','Shelehov','','Russia',643,'Asia/Irkutsk'),(819,'Шелехова','chelehova','','Russia',643,'Europe/Moscow'),(2434,'Шелковская','shelkovskaia','','Russia',643,'Europe/Moscow'),(1564,'Шелопугино','selopugino','','Russia',643,'Asia/Yakutsk'),(13271,'Шемаха','Shemaha','','Russia',643,'Asia/Baku'),(2435,'Шемышейка','shemisheika','','Russia',643,'Europe/Zaporozhye'),(371,'Шенкурск','senkursk','','Russia',643,'Europe/Moscow'),(12538,'Шентала','Shentala','','Russia',643,'Europe/Samara'),(953,'Шербакуль','serbakul','','Russia',643,''),(10274,'Шерегеш','Sheregesh','','Russia',643,'Asia/Novokuznetsk'),(839,'Шереметьево','sheremetevo','','Russia',643,'Europe/Moscow'),(86841,'Шереметьево','Sheremetyevo International Airport','','Russia',643,'Europe/Moscow'),(13304,'Шерловая Гора','Sherlova Gora','','Russia',643,''),(10579,'Шила','Shila','','Russia',643,'Asia/Krasnoyarsk'),(1565,'Шилка','chilka','','Russia',643,'Asia/Yakutsk'),(2436,'Шилово','shilovo','','Russia',643,'Europe/Moscow'),(339,'Шимановск','simanovsk','','Russia',643,'Asia/Yakutsk'),(9267,'Шипуново','Shipunovo','','Russia',643,'Asia/Omsk'),(1419,'Шира','sira','','Russia',643,'Asia/Krasnoyarsk'),(772,'Шлиссельбург','petrokrepost','','Russia',643,'Europe/Moscow'),(2437,'Шлиссельбург','shliselburg','','Russia',643,''),(935,'Шойна','sojna','','Russia',643,'Europe/Moscow'),(12438,'Шолоховский','Sholohovskiy','','Russia',643,'Europe/Moscow'),(10786,'Шум','Shum','','Russia',643,'Europe/Moscow'),(13320,'Шумерля','Shumerlia','','Russia',643,'Europe/Moscow'),(650,'Шумиха','shumicha','','Russia',643,''),(740,'Шумиха','shumiha','','Russia',643,''),(2438,'Шумячи','shumiaci','','Russia',643,''),(12267,'Шуран','Shuran','','Russia',643,'Europe/Moscow'),(2439,'Шушенское','shushenskoe','','Russia',643,'Europe/Moscow'),(2440,'Шуя','shuia','','Russia',643,'Europe/Moscow'),(86842,'Шуя','Shuya','','Russia',643,'Europe/Moscow'),(13015,'Щекино','Chekino','','Russia',643,'Asia/Novosibirsk'),(11185,'Щелково','Chelkovo','','Russia',643,'Europe/Moscow'),(2441,'Щельяюр','sheliaiur','','Russia',643,''),(11187,'Щербинка','Cherbinka','','Russia',643,'Europe/Moscow'),(651,'Щетинкино','scetinkino','','Russia',643,''),(10615,'Щигры','Chigri','','Russia',643,''),(9936,'Щучье','Chucye','','Russia',643,''),(1156,'Ытык-Кель','ytyk-kel','','Russia',643,'Asia/Yakutsk'),(12160,'Ытык-Кюель','Itik-Kiuely','','Russia',643,''),(2443,'Эвенск','evensk','','Russia',643,'Asia/Magadan'),(1588,'Эгвекинот','egvekinot','','Russia',643,'Asia/Anadyr'),(1157,'Эйк','ejk','','Russia',643,''),(340,'Экимчан','ekimchan','','Russia',643,'Asia/Yakutsk'),(11188,'Электрогорск','Elektrogorsk','','Russia',643,'Europe/Moscow'),(11189,'Электросталь','Elektrostaly','','Russia',643,'Europe/Moscow'),(11190,'Электроугли','Elektrougli','','Russia',643,'Europe/Moscow'),(527,'Элиста','elista','','Russia',643,'Europe/Moscow'),(13191,'Эльбан','Elyban','','Russia',643,'Asia/Beirut'),(453,'Эльтон','elton','','Russia',643,'Europe/Volgograd'),(2444,'Эльхотово','elhotovo','','Russia',643,'Europe/Moscow'),(2445,'Энгельс Фридрих','engels','','Russia',643,'Europe/Volgograd'),(546,'Энгозеро','engozero','','Russia',643,'Europe/Moscow'),(1323,'Эрзин','ersin','','Russia',643,'Europe/Helsinki'),(2446,'Эртиль','ertil','','Russia',643,'Europe/Moscow'),(689,'Эссо','esso','','Russia',643,'Asia/Kamchatka'),(10572,'Эта','Heta','','Russia',643,'Asia/Krasnoyarsk'),(10318,'Юбилейный','Yubileyniy','','Russia',643,'Europe/Moscow'),(12165,'Юбилейный','Yubileynaya','','Russia',643,'Asia/Yekaterinburg'),(11604,'Юг','Yug','','Russia',643,'Asia/Yekaterinburg'),(1158,'Югоренок','jugorenok','','Russia',643,''),(2447,'Югорск','Iugorsk','','Russia',643,''),(2448,'Южа','iuza','','Russia',643,'Asia/Krasnoyarsk'),(1272,'Южно-Курильск','juzno-kurilsk','','Russia',643,''),(1273,'Южно-Сахалинск','juzhno-sahalinsk','','Russia',643,'Asia/Sakhalin'),(435,'Южно-Сухокумск','juzhno-suhokum','','Russia',643,''),(12659,'Южное','Yugnoe','','Russia',643,''),(1516,'Южноуральск','juzhnouralsk','','Russia',643,'Asia/Yekaterinburg'),(13272,'Южный','Yugniy','','Russia',643,''),(1497,'Юильск','julsk','','Russia',643,''),(2449,'Юкаменское','iukamenskoe','','Russia',643,'Europe/Moscow'),(12167,'Юр','Yur','','Russia',643,'Asia/Vladivostok'),(1371,'Юрга','jurga','','Russia',643,'Asia/Novokuznetsk'),(1159,'Юрты','jurty','','Russia',643,''),(441,'Юрьев-Польский','jurev-polskiy','','Russia',643,'Europe/Moscow'),(473,'Юрьевец','jurevec','','Russia',643,''),(2453,'Юрюзань','iuruzan','','Russia',643,''),(528,'Юста','justa','','Russia',643,'Asia/Manila'),(2454,'Юсьва','iusva','','Russia',643,'Europe/Moscow'),(547,'Юшкозеро','juskozero','','Russia',643,''),(820,'Ягодное','jagodnoe','','Russia',643,'Europe/Warsaw'),(2455,'Ядрин','iadrin','','Russia',643,'Europe/Moscow'),(2456,'Языково','iazikovo','','Russia',643,'Europe/Moscow'),(11606,'Яйва','Yayva','','Russia',643,'Asia/Yekaterinburg'),(287,'Яйлю','jajlju','','Russia',643,''),(1034,'Яковлевка','jakovlevka','','Russia',643,'Europe/Volgograd'),(1160,'Якутск','jakutsk','','Russia',643,'Asia/Yakutsk'),(567,'Якша','jaksha','','Russia',643,''),(2457,'Якшур-Бодья','iakshur-bodia','','Russia',643,'Europe/Samara'),(1384,'Ялуторовск','jalturovosk','','Russia',643,'Asia/Yekaterinburg'),(2458,'Яльчики','ialchiki','','Russia',643,'Europe/Moscow'),(2459,'Ямбург','iamburg','','Russia',643,'Europe/Sofia'),(386,'Янаул','janaul','','Russia',643,'Asia/Yekaterinburg'),(652,'Янов Стан','janov-stan','','Russia',643,''),(2460,'Яр','iar','','Russia',643,'Europe/Moscow'),(2461,'Яр-Сале','iar-sale','','Russia',643,''),(720,'Яранск','jaransk','','Russia',643,'Europe/Volgograd'),(372,'Яренск','jarensk','','Russia',643,'Europe/Moscow'),(2462,'Ярково','iarkovo','','Russia',643,'Asia/Yekaterinburg'),(1162,'Ярольин','jarolin','','Russia',643,''),(1607,'Ярославль','jaroslavl','','Russia',643,'Europe/Moscow'),(653,'Ярцево','jarcevo','','Russia',643,'Europe/Moscow'),(10583,'Ярцево','Yarcevo','','Russia',643,'Europe/Moscow'),(13017,'Ясногорск','Yasnogorsk','','Russia',643,'Europe/Moscow'),(1838,'Ясный','dombarovskiy','','Russia',643,'Asia/Yekaterinburg'),(2463,'Ясный','iasniy','','Russia',643,'Asia/Krasnoyarsk'),(86881,'Ясный','Yasny','','Russia',643,'Asia/Yekaterinburg'),(11196,'Яхрома','Yahroma','','Russia',643,''),(10276,'Яшкино','Yashkino','','Russia',643,'Asia/Novokuznetsk'),(529,'Яшкуль','jaskul','','Russia',643,'Europe/Moscow'),(706,'Яя','jaja','','Russia',643,'Asia/Novokuznetsk'),(2628,'Бутаре','Butare','','Rwanda',646,'Africa/Kigali'),(2630,'Кигали','Kigali','','Rwanda',646,'Africa/Kigali'),(2635,'Рухенгери','Ruhengeri','','Rwanda',646,'Africa/Kigali'),(16919,'Gheorgheni','Gheorgheni','','Romania',642,'Europe/Bucharest'),(17027,'Petrosani','Petrosani','','Romania',642,'Europe/Bucharest'),(17059,'Rosiori de Vede','Rosiori de Vede','','Romania',642,'Europe/Bucharest'),(17081,'Sebes','Sebes','','Romania',642,'Europe/Bucharest'),(17091,'Sighetu Marmatiei','Sighetu Marmatiei','','Romania',642,'Europe/Bucharest'),(17103,'Slatina','Slatina','','Romania',642,'Europe/Bucharest'),(17145,'Targu-Mures','Targu-Mures','','Romania',642,'Europe/Bucharest'),(7827,'Алба-Юлия','Alba Iulia','','Romania',642,'Europe/Bucharest'),(7828,'Александрия','Alexandria','','Romania',642,'Europe/Bucharest'),(7829,'Арад','Arad','','Romania',642,'Europe/Bucharest'),(7831,'Бакэу','Bacau','','Romania',642,'Europe/Bucharest'),(7832,'Бая-Маре','Baia Mare','','Romania',642,'Europe/Bucharest'),(7848,'Боровичи','Bozovici','','Romania',642,'Europe/Bucharest'),(7846,'Бород','Borod','','Romania',642,'Europe/Bucharest'),(7847,'Ботошани','Botosani','','Romania',642,'Europe/Bucharest'),(7849,'Брад','Brad','','Romania',642,'Europe/Bucharest'),(7850,'Брашов','Brasov','','Romania',642,'Europe/Bucharest'),(16849,'Брэила','Braila','','Romania',642,'Europe/Bucharest'),(7852,'Бузэу','Buzau','','Romania',642,'Europe/Bucharest'),(7823,'Бухарест','Bucharest','','Romania',642,'Europe/Bucharest'),(7824,'Бухарест','Bucuresti','','Romania',642,'Europe/Bucharest'),(7955,'Виделе','Videle','','Romania',642,'Europe/Bucharest'),(7954,'Вф. Ому','Vf. Omu','','Romania',642,'Europe/Bucharest'),(7887,'Галац','Galati','','Romania',642,'Europe/Bucharest'),(7888,'Гиургиу','Giurgiu','','Romania',642,'Europe/Bucharest'),(7874,'Дева','Deva','','Romania',642,'Europe/Bucharest'),(7873,'Деж','Dej','','Romania',642,'Europe/Bucharest'),(7878,'Дорохой','Dorohoi','','Romania',642,'Europe/Bucharest'),(7881,'Дробета Тр.Северин','Drobeta Tr. Severin','','Romania',642,'Europe/Bucharest'),(16911,'Дробета-Турну-Северин','Drobeta-Turnu Severin','','Romania',642,'Europe/Bucharest'),(7960,'Заранд','Zarand','','Romania',642,'Europe/Bucharest'),(7853,'Калафат','Calafat','','Romania',642,'Europe/Bucharest'),(7855,'Каракал','Caracal','','Romania',642,'Europe/Bucharest'),(7856,'Карансебеш','Caransebes','','Romania',642,'Europe/Bucharest'),(7861,'Кимпина','Campina','','Romania',642,'Europe/Bucharest'),(7864,'Клуж-Напока','Cluj-Napoca','','Romania',642,'Europe/Bucharest'),(7865,'Констанца','Constanta','','Romania',642,'Europe/Bucharest'),(7869,'Крайова','Craiova','','Romania',642,'Europe/Bucharest'),(7862,'Кымпулунг','Cimpulung','','Romania',642,'Europe/Bucharest'),(7854,'Кэлэраши','Calarasi','','Romania',642,'Europe/Bucharest'),(7905,'Лугож','Lugoj','','Romania',642,'Europe/Bucharest'),(7908,'Мангалия','Mangalia','','Romania',642,'Europe/Bucharest'),(7919,'Орадя','Oradea','','Romania',642,'Europe/Bucharest'),(17031,'Питешти','Pitesti','','Romania',642,'Europe/Bucharest'),(17033,'Плоешти','Ploiesti','','Romania',642,'Europe/Bucharest'),(17047,'Пьятра-Нямц','Piatra Neamt','','Romania',642,'Europe/Bucharest'),(17063,'Рымнику-Вылча','Ramnicu Valcea','','Romania',642,'Europe/Bucharest'),(98488,'Рымнику-Вылча','Rimnicu Vilcea','','Romania',642,'Europe/Bucharest'),(17079,'Сату-Маре','Satu Mare','','Romania',642,'Europe/Bucharest'),(17089,'Сибиу','Sibiu','','Romania',642,'Europe/Bucharest'),(17093,'Сигишоара','Sighisoara','','Romania',642,'Europe/Bucharest'),(17097,'Синая','Sinaia','','Romania',642,'Europe/Bucharest'),(17105,'Слобозия','Slobozia','','Romania',642,'Europe/Bucharest'),(7931,'Сулина','Sulina','','Romania',642,'Europe/Bucharest'),(7930,'Сучава','Suceava','','Romania',642,'Europe/Bucharest'),(7935,'Тимишоара','Timisoara','','Romania',642,'Europe/Bucharest'),(7944,'Титу','Titu','','Romania',642,'Europe/Bucharest'),(7948,'Турда','Turda','','Romania',642,'Europe/Bucharest'),(7936,'Тырговиште','Tirgoviste','','Romania',642,'Europe/Bucharest'),(7938,'Тыргу-Жиу','Tirgu Jiu','','Romania',642,'Europe/Bucharest'),(7940,'Тыргу-Муреш','Tirgu Mures','','Romania',642,'Europe/Bucharest'),(17435,'Фокшаны','Focsani','','Romania',642,'Europe/Bucharest'),(7899,'Яссы','Iasi','','Romania',642,'Europe/Bucharest'),(7820,'Сен-Дени','Saint-Denis','','Reunion',638,'Indian/Reunion'),(7963,'Сан-Томе','S. Tome','','Sao Tome And Principe',678,'Africa/Sao_Tome'),(7966,'Абха','Abha','','Saudi Arabia',682,'Asia/Riyadh'),(7969,'Аль Каусумах','Al Qaysumah','','Saudi Arabia',682,'Asia/Riyadh'),(7976,'Арар','Arar','','Saudi Arabia',682,'Asia/Riyadh'),(7977,'Биша','Bisha','','Saudi Arabia',682,'Asia/Riyadh'),(8007,'Вежх','Wejh','','Saudi Arabia',682,'Asia/Riyadh'),(7981,'Гассим','Gassim','','Saudi Arabia',682,'Asia/Riyadh'),(7982,'Гизан','Gizan','','Saudi Arabia',682,'Asia/Riyadh'),(7985,'Град','Hail','','Saudi Arabia',682,'Asia/Riyadh'),(7983,'Гурияат','Guriat','','Saudi Arabia',682,'Asia/Riyadh'),(7978,'Даммам','Dammam','','Saudi Arabia',682,'Asia/Riyadh'),(7987,'Джидда','Jeddah','','Saudi Arabia',682,'Asia/Riyadh'),(7988,'Кхамис Мусхаит','Khamis Mushait','','Saudi Arabia',682,'Asia/Riyadh'),(7992,'Медина','Madinah','','Saudi Arabia',682,'Asia/Riyadh'),(7993,'Мекка','Makkah','','Saudi Arabia',682,'Asia/Riyadh'),(7995,'Наджран','Najran','','Saudi Arabia',682,'Asia/Riyadh'),(7997,'Рафха','Rafha','','Saudi Arabia',682,'Asia/Riyadh'),(8001,'Табук','Tabuk','','Saudi Arabia',682,'Asia/Riyadh'),(8002,'Таиф','Taif','','Saudi Arabia',682,'Asia/Riyadh'),(8003,'Тема','Tayma','','Saudi Arabia',682,'Asia/Riyadh'),(8004,'Тураиф','Turaif','','Saudi Arabia',682,'Asia/Riyadh'),(7999,'Шарирах','Sharurah','','Saudi Arabia',682,'Asia/Riyadh'),(7967,'Эль-Хаса','Al Ahsa','','Saudi Arabia',682,'Asia/Riyadh'),(7998,'Эр-Рияд','Riyadh','','Saudi Arabia',682,'Asia/Riyadh'),(8008,'Янбу','Yenbo','','Saudi Arabia',682,'Asia/Riyadh'),(8009,'Дакар','Dakar','','Senegal',686,'Africa/Dakar'),(8011,'Диурбель','Diourbel','','Senegal',686,'Africa/Dakar'),(8012,'Каолак','Kaolack','','Senegal',686,'Africa/Dakar'),(8014,'Колда','Kolda','','Senegal',686,'Africa/Dakar'),(8015,'Лингере','Linguere','','Senegal',686,'Africa/Dakar'),(8016,'Матам','Matam','','Senegal',686,'Africa/Dakar'),(8017,'Подор','Podor','','Senegal',686,'Africa/Dakar'),(8018,'Сен-Луи','Saint-Louis','','Senegal',686,'Africa/Dakar'),(8019,'Тамбакунда','Tambacounda','','Senegal',686,'Africa/Dakar'),(99316,'NIS','Nis','','Serbia',688,'Europe/Belgrade'),(98881,'Белград','Belgrade','','Serbia',688,'Europe/Belgrade'),(99063,'Димитровград','Dimitrovgrad','','Serbia',688,'Europe/Belgrade'),(99659,'Зренянин','Zrenjanin','','Serbia',688,'Europe/Belgrade'),(99152,'Кралево','Kraljevo','','Serbia',688,'Europe/Belgrade'),(99153,'Крушевац','Krusevac','','Serbia',688,'Europe/Belgrade'),(99320,'Нови-Сад','Novi Sad','','Serbia',688,'Europe/Belgrade'),(99377,'Рума','Ruma','','Serbia',688,'Europe/Belgrade'),(98975,'Чачак','Cacak','','Serbia',688,'Europe/Belgrade'),(8037,'NIS','Nis','','Сербия и Черногория',891,''),(8022,'Бар','Bar','','Сербия и Черногория',891,''),(8023,'Белград','Beograd','','Сербия и Черногория',891,''),(8026,'Димитровград','Dimitrovgrad','','Сербия и Черногория',891,''),(8056,'Жабляк','Zabljak','','Сербия и Черногория',891,''),(8058,'Зренянин','Zrenjanin','','Сербия и Черногория',891,''),(8031,'Кралево','Kraljevo','','Сербия и Черногория',891,''),(8032,'Крушевац','Krusevac','','Сербия и Черногория',891,''),(8036,'Никшич','Niksic','','Сербия и Черногория',891,''),(8038,'Нови-Сад','Novi Sad','','Сербия и Черногория',891,''),(8039,'Палик','Palic','','Сербия и Черногория',891,''),(8040,'Печ','Pec','','Сербия и Черногория',891,''),(8020,'Подгорица','Podgorica','','Сербия и Черногория',891,''),(8044,'Призрен','Prizren','','Сербия и Черногория',891,''),(8043,'Приштина','Pristina','','Сербия и Черногория',891,''),(8048,'Сомбор','Sombor','','Сербия и Черногория',891,''),(8050,'Тиват','Tivat','','Сербия и Черногория',891,''),(8051,'Улцинь','Ulcinj','','Сербия и Черногория',891,''),(8027,'Херцег-Нови','Herceg Novi','','Сербия и Черногория',891,''),(107,'Сингапур','Singapore','','Singapore',702,'Asia/Singapore'),(8537,'','Dara','','Syrian Arab Republic',760,'Asia/Damascus'),(8534,'Алеппо','Aleppo (International Airport)','','Syrian Arab Republic',760,'Asia/Damascus'),(8536,'Дамаск','Damascus','','Syrian Arab Republic',760,'Asia/Damascus'),(8538,'Дейр-эз-Зор','Deir Ezzor','','Syrian Arab Republic',760,'Asia/Damascus'),(8547,'Латакия','Lattakia','','Syrian Arab Republic',760,'Asia/Damascus'),(8549,'Пальмира','Palmyra','','Syrian Arab Republic',760,'Asia/Damascus'),(8554,'Тартус','Tartous','','Syrian Arab Republic',760,'Asia/Damascus'),(8541,'Хама','Hama','','Syrian Arab Republic',760,'Asia/Damascus'),(8543,'Хомс','Homs','','Syrian Arab Republic',760,'Asia/Damascus'),(8550,'Эр-Ракка','Raqqa','','Syrian Arab Republic',760,'Asia/Damascus'),(99086,'Банска Штьявница','Banska Stiavnica','','Slovakia',703,'Europe/Bratislava'),(99087,'Бардейов','Bardejov','','Slovakia',703,'Europe/Bratislava'),(8071,'Братислава','Bratislava','','Slovakia',703,'Europe/Bratislava'),(99088,'Брезно','Brezno','','Slovakia',703,'Europe/Bratislava'),(99216,'Гандлова','Handlova','','Slovakia',703,'Europe/Bratislava'),(99217,'Гуменне','Humenne','','Slovakia',703,'Europe/Bratislava'),(8074,'Гурбаново','Hurbanovo','','Slovakia',703,'Europe/Bratislava'),(99952,'Жилина','Zilina','','Slovakia',703,'Europe/Bratislava'),(8078,'Кошице','Kosice','','Slovakia',703,'Europe/Bratislava'),(99378,'Левице','Levice','','Slovakia',703,'Europe/Bratislava'),(8081,'Лученец','Lucenec','','Slovakia',703,'Europe/Bratislava'),(8082,'Малацки','Malacky','','Slovakia',703,'Europe/Bratislava'),(99471,'Мартин','Martin','','Slovakia',703,'Europe/Bratislava'),(8085,'Нитра','Nitra','','Slovakia',703,'Europe/Bratislava'),(99516,'Нове Замки','Nove Zamky','','Slovakia',703,'Europe/Bratislava'),(8070,'Попрад','Poprad','','Slovakia',703,'Europe/Bratislava'),(8087,'Прешов','Presov','','Slovakia',703,'Europe/Bratislava'),(8088,'Прьевидза','Prievidza','','Slovakia',703,'Europe/Bratislava'),(8086,'Пьештяны','Piestany','','Slovakia',703,'Europe/Bratislava'),(99725,'Римавска Собота','Rimavska Sobota','','Slovakia',703,'Europe/Bratislava'),(99726,'Рожнява','Roznava','','Slovakia',703,'Europe/Bratislava'),(99792,'Сеница','Senica','','Slovakia',703,'Europe/Bratislava'),(8089,'Слиач','Sliac','','Slovakia',703,'Europe/Bratislava'),(99793,'Снина','Snina','','Slovakia',703,'Europe/Bratislava'),(99794,'Стропков','Stropkov','','Slovakia',703,'Europe/Bratislava'),(99901,'Топольчаны','Topolcany','','Slovakia',703,'Europe/Bratislava'),(8093,'Тренчин','Trencin','','Slovakia',703,'Europe/Bratislava'),(99903,'Трнава','Trnava','','Slovakia',703,'Europe/Bratislava'),(8072,'Хопок','Chopok','','Slovakia',703,'Europe/Bratislava'),(99154,'Чадца','Cadca','','Slovakia',703,'Europe/Bratislava'),(8090,'Штрбске Плесо','Strbske Pleso','','Slovakia',703,'Europe/Bratislava'),(8096,'Бовец','Bovec','','Slovenia',705,'Europe/Ljubljana'),(8101,'Кочевье','Kocevje','','Slovenia',705,'Europe/Ljubljana'),(99374,'Крань','Kranj','','Slovenia',705,'Europe/Ljubljana'),(8095,'Любляна','Ljubljana','','Slovenia',705,'Europe/Ljubljana'),(8105,'Марибор','Maribor','','Slovenia',705,'Europe/Ljubljana'),(8106,'Мурска-Собота','Murska Sobota','','Slovenia',705,'Europe/Ljubljana'),(8107,'Нова-Горица','Nova Gorica','','Slovenia',705,'Europe/Ljubljana'),(8108,'Ново Место','Novo Mesto','','Slovenia',705,'Europe/Ljubljana'),(8109,'Порторож','Portoroz','','Slovenia',705,'Europe/Ljubljana'),(8110,'Постойна','Postojna','','Slovenia',705,'Europe/Ljubljana'),(8097,'Целе','Celje','','Slovenia',705,'Europe/Ljubljana'),(74605,'Ash','Ash','','United States Of America',840,'America/New_York'),(71505,'Dodge','Dodge','','United States Of America',840,'America/Chicago'),(75457,'Dodge','Dodge','','United States Of America',840,'America/Chicago'),(68989,'Forbes','Forbes','','United States Of America',840,'America/Chicago'),(75487,'Forbes','Forbes','','United States Of America',840,'America/Chicago'),(78450,'GAP','Gap','','United States Of America',840,'America/New_York'),(60560,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(61390,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(66029,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(70348,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(74846,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(78463,'Gibson','Gibson','','United States Of America',840,'America/Chicago'),(56480,'Jack','Jack','','United States Of America',840,'America/Chicago'),(65460,'Lowe\'s','Lowes','','United States Of America',840,'America/Chicago'),(56060,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(57742,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(58712,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(63033,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(64000,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(68331,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(69207,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(70568,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(75010,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(75588,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(77195,'Marshall','Marshall','','United States Of America',840,'America/New_York'),(65499,'McKinney','McKinney','','United States Of America',840,'America/Chicago'),(61722,'OTO','Oto','','United States Of America',840,'America/Chicago'),(68457,'Palm','Palms','','United States Of America',840,'America/Detroit'),(79103,'Palm','Palm','','United States Of America',840,'America/New_York'),(63262,'Pontiac','Pontiac','','United States Of America',840,'America/Detroit'),(68487,'Pontiac','Pontiac','','United States Of America',840,'America/Detroit'),(70724,'Pontiac','Pontiac','','United States Of America',840,'America/Detroit'),(77733,'Post','Post','','United States Of America',840,'America/Los_Angeles'),(79188,'Presto','Presto','','United States Of America',840,'America/New_York'),(60799,'Rex','Rex','','United States Of America',840,'America/New_York'),(75152,'Rex','Rex','','United States Of America',840,'America/New_York'),(60800,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(63290,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(64165,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(70759,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(71770,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(75660,'Reynolds','Reynolds','','United States Of America',840,'America/New_York'),(64862,'Rock','Rock','','United States Of America',840,'America/Chicago'),(68528,'Rock','Rock','','United States Of America',840,'America/Chicago'),(67206,'Savage','Savage','','United States Of America',840,'America/New_York'),(69410,'Savage','Savage','','United States Of America',840,'America/New_York'),(71288,'Savage','Savage','','United States Of America',840,'America/New_York'),(79427,'Spring','Springs','','United States Of America',840,'America/New_York'),(58278,'Vista','Vista','','United States Of America',840,'America/Los_Angeles'),(70921,'Vista','Vista','','United States Of America',840,'America/Los_Angeles'),(59380,'Weston','Weston','','United States Of America',840,'America/New_York'),(59655,'Weston','Weston','','United States Of America',840,'America/New_York'),(60297,'Weston','Weston','','United States Of America',840,'America/New_York'),(60945,'Weston','Weston','','United States Of America',840,'America/New_York'),(62287,'Weston','Weston','','United States Of America',840,'America/New_York'),(67776,'Weston','Weston','','United States Of America',840,'America/New_York'),(68689,'Weston','Weston','','United States Of America',840,'America/New_York'),(70953,'Weston','Weston','','United States Of America',840,'America/New_York'),(71879,'Weston','Weston','','United States Of America',840,'America/New_York'),(76810,'Weston','Weston','','United States Of America',840,'America/New_York'),(77839,'Weston','Weston','','United States Of America',840,'America/New_York'),(79640,'Weston','Weston','','United States Of America',840,'America/New_York'),(56183,'Абвиль','Abbeville','','United States Of America',840,'America/Chicago'),(60320,'Абвиль','Abbeville','','United States Of America',840,'America/Chicago'),(65850,'Абвиль','Abbeville','','United States Of America',840,'America/Chicago'),(69560,'Абвиль','Abbeville','','United States Of America',840,'America/Chicago'),(79784,'Абвиль','Abbeville','','United States Of America',840,'America/Chicago'),(62014,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(64993,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(66838,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(69561,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(74586,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(75752,'Абердин','Aberdeen','','United States Of America',840,'America/Chicago'),(64354,'Абилин','Abilene','','United States Of America',840,'America/Chicago'),(62293,'Абингдон','Abingdon','','United States Of America',840,'America/New_York'),(66840,'Абингдон','Abingdon','','United States Of America',840,'America/New_York'),(59400,'Абингтон','Abington','','United States Of America',840,'America/New_York'),(59572,'Абингтон','Pomfret Center','','United States Of America',840,'America/New_York'),(67287,'Абингтон','Abington','','United States Of America',840,'America/New_York'),(77856,'Абингтон','Abington','','United States Of America',840,'America/New_York'),(62354,'Ава','Ava','','United States Of America',840,'America/Chicago'),(70044,'Ава','Ava','','United States Of America',840,'America/Chicago'),(73286,'Ава','Ava','','United States Of America',840,'America/Chicago'),(75795,'Ава','Ava','','United States Of America',840,'America/Chicago'),(58373,'Августа','Augusta','','United States Of America',840,'America/New_York'),(60351,'Августа','Augusta','','United States Of America',840,'America/New_York'),(62352,'Августа','Augusta','','United States Of America',840,'America/New_York'),(64386,'Августа','Augusta','','United States Of America',840,'America/New_York'),(65017,'Августа','Augusta','','United States Of America',840,'America/New_York'),(66366,'Августа','Augusta','','United States Of America',840,'America/New_York'),(67846,'Августа','Augusta','','United States Of America',840,'America/New_York'),(70041,'Августа','Augusta','','United States Of America',840,'America/New_York'),(70993,'Августа','Augusta','','United States Of America',840,'America/New_York'),(72287,'Августа','Augusta','','United States Of America',840,'America/New_York'),(75791,'Августа','Augusta','','United States Of America',840,'America/New_York'),(58990,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(61117,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(62353,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(63628,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(64387,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(66367,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(68752,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(70042,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(71387,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(73284,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(74612,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(75792,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(77473,'Аврора','Aurora','','United States Of America',840,'America/Denver'),(58972,'Агат','Agate','','United States Of America',840,'America/Denver'),(75370,'Агат','Agate','','United States Of America',840,'America/Denver'),(64357,'Агра','Agra','','United States Of America',840,'America/Chicago'),(76861,'Агра','Agra','','United States Of America',840,'America/Chicago'),(67804,'Ада','Ada','','United States Of America',840,'America/Chicago'),(68715,'Ада','Ada','','United States Of America',840,'America/Chicago'),(75753,'Ада','Ada','','United States Of America',840,'America/Chicago'),(76856,'Ада','Ada','','United States Of America',840,'America/Chicago'),(64995,'Адамс','Adams','','United States Of America',840,'America/New_York'),(67291,'Адамс','Adams','','United States Of America',840,'America/New_York'),(68716,'Адамс','Adams','','United States Of America',840,'America/New_York'),(71360,'Адамс','Adams','','United States Of America',840,'America/New_York'),(73217,'Адамс','Adams','','United States Of America',840,'America/New_York'),(75369,'Адамс','Adams','','United States Of America',840,'America/New_York'),(76858,'Адамс','Adams','','United States Of America',840,'America/New_York'),(77453,'Адамс','Adams','','United States Of America',840,'America/New_York'),(66081,'Айова','Iowa','','United States Of America',840,'America/Chicago'),(56188,'Акрон','Akron','','United States Of America',840,'America/New_York'),(58974,'Акрон','Akron','','United States Of America',840,'America/New_York'),(61073,'Акрон','Akron','','United States Of America',840,'America/New_York'),(63607,'Акрон','Akron','','United States Of America',840,'America/New_York'),(67809,'Акрон','Akron','','United States Of America',840,'America/New_York'),(73223,'Акрон','Akron','','United States Of America',840,'America/New_York'),(75759,'Акрон','Akron','','United States Of America',840,'America/New_York'),(77867,'Акрон','Akron','','United States Of America',840,'America/New_York'),(72856,'Аламогордо','Alamogordo','','United States Of America',840,'America/Denver'),(76866,'Алекс','Alex','','United States Of America',840,'America/Chicago'),(56106,'Александр','Port Alexander','','United States Of America',840,'America/Juneau'),(58353,'Александр','Alexander','','United States Of America',840,'America/New_York'),(61079,'Александр','Alexander','','United States Of America',840,'America/New_York'),(62304,'Александр','Alexander','','United States Of America',840,'America/New_York'),(64360,'Александр','Alexander','','United States Of America',840,'America/New_York'),(73231,'Александр','Alexander','','United States Of America',840,'America/New_York'),(74592,'Александр','Alexander','','United States Of America',840,'America/New_York'),(75372,'Александр','Alexander','','United States Of America',840,'America/New_York'),(56193,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(63611,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(64999,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(65857,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(68731,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(70010,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(71364,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(75761,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(77874,'Александрия','Alexandria','','United States Of America',840,'America/New_York'),(56195,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(64361,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(65001,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(66845,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(67817,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(71365,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(76868,'Аллен','Allen','','United States Of America',840,'America/Chicago'),(56197,'Алма','Alma','','United States Of America',840,'America/New_York'),(58357,'Алма','Alma','','United States Of America',840,'America/New_York'),(58977,'Алма','Alma','','United States Of America',840,'America/New_York'),(60331,'Алма','Alma','','United States Of America',840,'America/New_York'),(62310,'Алма','Alma','','United States Of America',840,'America/New_York'),(64362,'Алма','Alma','','United States Of America',840,'America/New_York'),(67822,'Алма','Alma','','United States Of America',840,'America/New_York'),(70013,'Алма','Alma','','United States Of America',840,'America/New_York'),(71367,'Алма','Alma','','United States Of America',840,'America/New_York'),(73237,'Алма','Alma','','United States Of America',840,'America/New_York'),(70240,'Алмаз','Diamond','','United States Of America',840,'America/Los_Angeles'),(76020,'Алмаз','Diamond','','United States Of America',840,'America/Los_Angeles'),(77554,'Алмаз','Diamond','','United States Of America',840,'America/Los_Angeles'),(77459,'Алоха','Aloha','','United States Of America',840,'America/Los_Angeles'),(64358,'Альберт','Albert','','United States Of America',840,'America/Chicago'),(76863,'Альберт','Albert','','United States Of America',840,'America/Chicago'),(57068,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(61076,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(62016,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(62301,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(63610,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(66358,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(67812,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(71362,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(73227,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(76864,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(77869,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(79714,'Альбион','Albion','','United States Of America',840,'America/Detroit'),(72858,'Альбукерке','Albuquerque','','United States Of America',840,'America/Denver'),(57070,'Альгамбра','Alhambra','','United States Of America',840,'America/Los_Angeles'),(62307,'Альгамбра','Alhambra','','United States Of America',840,'America/Los_Angeles'),(58923,'Альт','Viola','','United States Of America',840,'America/New_York'),(59727,'Альт','Viola','','United States Of America',840,'America/New_York'),(61947,'Альт','Viola','','United States Of America',840,'America/New_York'),(62280,'Альт','Viola','','United States Of America',840,'America/New_York'),(63515,'Альт','Viola','','United States Of America',840,'America/New_York'),(64945,'Альт','Viola','','United States Of America',840,'America/New_York'),(70015,'Альтенбург','Altenburg','','United States Of America',840,'America/Chicago'),(62311,'Альфа','Alpha','','United States Of America',840,'America/New_York'),(65004,'Альфа','Alpha','','United States Of America',840,'America/New_York'),(67825,'Альфа','Alpha','','United States Of America',840,'America/New_York'),(68733,'Альфа','Alpha','','United States Of America',840,'America/New_York'),(75765,'Альфа','Alpha','','United States Of America',840,'America/New_York'),(70020,'Амстердам','Amsterdam','','United States Of America',840,'America/New_York'),(73249,'Амстердам','Amsterdam','','United States Of America',840,'America/New_York'),(75774,'Амстердам','Amsterdam','','United States Of America',840,'America/New_York'),(57085,'Анахайм','Anaheim','','United States Of America',840,'America/Los_Angeles'),(68740,'Ангус','Angus','','United States Of America',840,'America/Chicago'),(55925,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(56203,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(57086,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(63615,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(70022,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(79789,'Андерсон','Anderson','','United States Of America',840,'America/Indiana/Indianapolis'),(62321,'Анкона','Ancona','','United States Of America',840,'America/Chicago'),(55921,'Анкоридж','Anchorage','','United States Of America',840,'America/Anchorage'),(62324,'Анна','Anna','','United States Of America',840,'America/Chicago'),(67175,'Анна','Princess Anne','','United States Of America',840,'America/New_York'),(75776,'Анна','Anna','','United States Of America',840,'America/Chicago'),(68741,'Аннандейл','Annandale','','United States Of America',840,'America/New_York'),(72279,'Аннандейл','Annandale','','United States Of America',840,'America/New_York'),(57090,'Аннаполис','Annapolis','','United States Of America',840,'America/New_York'),(62325,'Аннаполис','Annapolis','','United States Of America',840,'America/New_York'),(66847,'Аннаполис','Annapolis','','United States Of America',840,'America/New_York'),(70024,'Аннаполис','Annapolis','','United States Of America',840,'America/New_York'),(73257,'Антверпен','Antwerp','','United States Of America',840,'America/New_York'),(75778,'Антверпен','Antwerp','','United States Of America',840,'America/New_York'),(72011,'Антрим','Antrim','','United States Of America',840,'America/New_York'),(76877,'Апачи','Apache','','United States Of America',840,'America/Chicago'),(74600,'Апекс','Apex','','United States Of America',840,'America/New_York'),(74603,'Арарат','Ararat','','United States Of America',840,'America/New_York'),(62019,'Арбон','Arbon','','United States Of America',840,'America/Boise'),(63620,'Аргос','Argos','','United States Of America',840,'America/Indiana/Indianapolis'),(73262,'Аркада','Arcade','','United States Of America',840,'America/Los_Angeles'),(57098,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(59744,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(61099,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(63618,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(64372,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(65866,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(67832,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(70029,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(71376,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(75780,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(76879,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(77900,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(79791,'Аркадия','Arcadia','','United States Of America',840,'America/Los_Angeles'),(64376,'Арма','Arma','','United States Of America',840,'America/Chicago'),(77907,'Арма','Armagh','','United States Of America',840,'America/New_York'),(77910,'Арона','Arona','','United States Of America',840,'America/New_York'),(65013,'Асир','Asher','','United States Of America',840,'America/Chicago'),(76884,'Асир','Asher','','United States Of America',840,'America/Chicago'),(57108,'Атертон','Atherton','','United States Of America',840,'America/Los_Angeles'),(60347,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(62024,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(62348,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(63624,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(64382,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(65871,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(67838,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(70040,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(71385,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(73278,'Атланта','Atlanta','','United States Of America',840,'America/New_York'),(72283,'Атлантик-Сити','Atlantic City','','United States Of America',840,'America/New_York'),(56214,'Афины','Athens','','United States Of America',840,'America/New_York'),(60346,'Афины','Athens','','United States Of America',840,'America/New_York'),(62346,'Афины','Athens','','United States Of America',840,'America/New_York'),(63623,'Афины','Athens','','United States Of America',840,'America/New_York'),(65870,'Афины','Athens','','United States Of America',840,'America/New_York'),(66364,'Афины','Athens','','United States Of America',840,'America/New_York'),(67837,'Афины','Athens','','United States Of America',840,'America/New_York'),(73275,'Афины','Athens','','United States Of America',840,'America/New_York'),(75788,'Афины','Athens','','United States Of America',840,'America/New_York'),(77918,'Афины','Athens','','United States Of America',840,'America/New_York'),(77929,'Баден','Baden','','United States Of America',840,'America/New_York'),(72296,'Байонна','Bayonne','','United States Of America',840,'America/New_York'),(66856,'Балтимор','Baltimore','','United States Of America',840,'America/New_York'),(75801,'Балтимор','Baltimore','','United States Of America',840,'America/New_York'),(79795,'Бамберг','Bamberg','','United States Of America',840,'America/New_York'),(57123,'Бангор','Bangor','','United States Of America',840,'America/New_York'),(66370,'Бангор','Bangor','','United States Of America',840,'America/New_York'),(67853,'Бангор','Bangor','','United States Of America',840,'America/New_York'),(77936,'Бангор','Bangor','','United States Of America',840,'America/New_York'),(57126,'Бард','Bard','','United States Of America',840,'America/Denver'),(72877,'Бард','Bard','','United States Of America',840,'America/Denver'),(64392,'Барнс','Barnes','','United States Of America',840,'America/Chicago'),(62362,'Барри','Barry','','United States Of America',840,'America/Chicago'),(68765,'Барри','Barry','','United States Of America',840,'America/Chicago'),(55934,'Барроу','Barrow','','United States Of America',840,'America/Anchorage'),(77940,'Барто','Barto','','United States Of America',840,'America/Chicago'),(58379,'Бартон','Barton','','United States Of America',840,'America/Chicago'),(66863,'Бартон','Barton','','United States Of America',840,'America/Chicago'),(73303,'Бартон','Barton','','United States Of America',840,'America/Chicago'),(75807,'Бартон','Barton','','United States Of America',840,'America/Chicago'),(58380,'Бас','Bass','','United States Of America',840,'America/Chicago'),(65882,'Батон-Руж','Baton Rouge','','United States Of America',840,'America/Chicago'),(57148,'Беверли-Хиллз','Beverly Hills','','United States Of America',840,'America/Los_Angeles'),(59767,'Беверли-Хиллз','Beverly Hills','','United States Of America',840,'America/Los_Angeles'),(67884,'Беверли-Хиллз','Beverly Hills','','United States Of America',840,'America/Los_Angeles'),(61134,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(63638,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(65039,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(67317,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(67869,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(72021,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(73316,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(75818,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(77957,'Бедфорд','Bedford','','United States Of America',840,'America/Chicago'),(57120,'Бейкерсфилд','Bakersfield','','United States Of America',840,'America/Los_Angeles'),(70047,'Бейкерсфилд','Bakersfield','','United States Of America',840,'America/Los_Angeles'),(66378,'Белград','Belgrade','','United States Of America',840,'America/Denver'),(68775,'Белград','Belgrade','','United States Of America',840,'America/Denver'),(70055,'Белград','Belgrade','','United States Of America',840,'America/Denver'),(71002,'Белград','Belgrade','','United States Of America',840,'America/Denver'),(71404,'Белград','Belgrade','','United States Of America',840,'America/Denver'),(57136,'Белл','Bell','','United States Of America',840,'America/Los_Angeles'),(59762,'Белл','Bell','','United States Of America',840,'America/Los_Angeles'),(66377,'Белфаст','Belfast','','United States Of America',840,'America/Chicago'),(73318,'Белфаст','Belfast','','United States Of America',840,'America/Chicago'),(58394,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(62380,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(64401,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(67872,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(72303,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(73321,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(77962,'Бельвиль','Belleville','','United States Of America',840,'America/Chicago'),(59000,'Бельвю','Bellvue','','United States Of America',840,'America/Denver'),(59765,'Бельвю','Belleview','','United States Of America',840,'America/New_York'),(61136,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(62031,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(65046,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(67873,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(70058,'Бельвю','Belleview','','United States Of America',840,'America/New_York'),(71405,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(75825,'Бельвю','Bellevue','','United States Of America',840,'America/Los_Angeles'),(73328,'Берген','Bergen','','United States Of America',840,'America/New_York'),(70073,'Берёза','Birch Tree','','United States Of America',840,'America/Chicago'),(73400,'Бёрк','Burke','','United States Of America',840,'America/New_York'),(57145,'Беркли','Berkeley','','United States Of America',840,'America/Los_Angeles'),(62390,'Беркли','Berkeley','','United States Of America',840,'America/Los_Angeles'),(70065,'Беркли','Berkeley','','United States Of America',840,'America/Los_Angeles'),(60367,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(66871,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(67324,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(72024,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(72309,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(73330,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(75398,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(75836,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(77970,'Берлин','Berlin','','United States Of America',840,'America/New_York'),(59020,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(59424,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(61179,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(62451,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(63685,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(64434,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(65098,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(66413,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(67348,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(67922,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(72337,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(74672,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(75415,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(76928,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(78062,'Бёрлингтон','Burlington','','United States Of America',840,'America/New_York'),(62032,'Берн','Bern','','United States Of America',840,'America/Boise'),(63643,'Берн','Berne','','United States Of America',840,'America/Indiana/Indianapolis'),(64410,'Берн','Bern','','United States Of America',840,'America/Boise'),(73331,'Берн','Berne','','United States Of America',840,'America/Indiana/Indianapolis'),(67927,'Бёртон','Burton','','United States Of America',840,'America/Detroit'),(75898,'Бёртон','Burton','','United States Of America',840,'America/Detroit'),(69592,'Билокси','Biloxi','','United States Of America',840,'America/Chicago'),(56236,'Бирмингем','Birmingham','','United States Of America',840,'America/Chicago'),(61144,'Бирмингем','Birmingham','','United States Of America',840,'America/Chicago'),(67889,'Бирмингем','Birmingham','','United States Of America',840,'America/Chicago'),(72312,'Бирмингем','Birmingham','','United States Of America',840,'America/Chicago'),(75846,'Бирмингем','Birmingham','','United States Of America',840,'America/Chicago'),(58406,'Бисмарк','Bismarck','','United States Of America',840,'America/Chicago'),(62400,'Бисмарк','Bismarck','','United States Of America',840,'America/Chicago'),(70074,'Бисмарк','Bismarck','','United States Of America',840,'America/Chicago'),(75403,'Бисмарк','Bismarck','','United States Of America',840,'America/Chicago'),(71905,'Битти','Beatty','','United States Of America',840,'America/Los_Angeles'),(77480,'Битти','Beatty','','United States Of America',840,'America/Los_Angeles'),(70077,'Блэкберн','Blackburn','','United States Of America',840,'America/Chicago'),(72319,'Богота','Bogota','','United States Of America',840,'America/New_York'),(69598,'Бойл','Boyle','','United States Of America',840,'America/Chicago'),(62038,'Бойсе','Boise','','United States Of America',840,'America/Boise'),(59773,'Бока-Ратон','Boca Raton','','United States Of America',840,'America/New_York'),(58384,'Боксит','Bauxite','','United States Of America',840,'America/Chicago'),(59414,'Болтон','Bolton','','United States Of America',840,'Europe/London'),(67330,'Болтон','Bolton','','United States Of America',840,'Europe/London'),(69596,'Болтон','Bolton','','United States Of America',840,'Europe/London'),(74654,'Болтон','Bolton','','United States Of America',840,'Europe/London'),(59008,'Бонд','Bond','','United States Of America',840,'America/Chicago'),(57176,'Бор','Boron','','United States Of America',840,'Europe/Paris'),(70095,'Босс','Boss','','United States Of America',840,'America/Chicago'),(60381,'Бостон','Boston','','United States Of America',840,'America/New_York'),(63658,'Бостон','Boston','','United States Of America',840,'America/New_York'),(65075,'Бостон','Boston','','United States Of America',840,'America/New_York'),(67332,'Бостон','Boston','','United States Of America',840,'America/New_York'),(73360,'Бостон','Boston','','United States Of America',840,'America/New_York'),(56801,'Боуи','Bowie','','United States Of America',840,'America/Chicago'),(66883,'Боуи','Bowie','','United States Of America',840,'America/Chicago'),(75887,'Брайан','Bryan','','United States Of America',840,'America/New_York'),(59015,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(61168,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(62426,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(67340,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(67911,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(70110,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(73382,'Брайтон','Brighton','','United States Of America',840,'Europe/London'),(65079,'Бранденбург','Brandenburg','','United States Of America',840,'Europe/Berlin'),(57186,'Бреа','Brea','','United States Of America',840,'America/Los_Angeles'),(61166,'Бреда','Breda','','United States Of America',840,'Europe/Amsterdam'),(76920,'Брей','Bray','','United States Of America',840,'America/Chicago'),(56246,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(60389,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(63665,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(64420,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(65081,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(66397,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(75410,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(75872,'Бремен','Bremen','','United States Of America',840,'Europe/Berlin'),(57187,'Брентвуд','Brentwood','','United States Of America',840,'Europe/London'),(66888,'Брентвуд','Brentwood','','United States Of America',840,'Europe/London'),(73374,'Брентвуд','Brentwood','','United States Of America',840,'Europe/London'),(78032,'Брентвуд','Brentwood','','United States Of America',840,'Europe/London'),(56249,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(57188,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(59418,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(62424,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(67908,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(71428,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(72327,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(73379,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(75875,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(77493,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(78033,'Бриджпорт','Bridgeport','','United States Of America',840,'America/New_York'),(57190,'Брисбен','Brisbane','','United States Of America',840,'Australia/Brisbane'),(59420,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(59786,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(60391,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(62428,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(63669,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(66401,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(72029,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(78037,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(79719,'Бристоль','Bristol','','United States Of America',840,'Europe/London'),(73388,'Бронкс','Bronx','','United States Of America',840,'America/New_York'),(56252,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(59423,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(61172,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(63672,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(65084,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(66892,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(67916,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(69602,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(73392,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(75883,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(78045,'Бруклин','Brooklyn','','United States Of America',840,'America/New_York'),(57192,'Брукс','Brooks','','United States Of America',840,'America/Chicago'),(60395,'Брукс','Brooks','','United States Of America',840,'America/Chicago'),(65085,'Брукс','Brooks','','United States Of America',840,'America/Chicago'),(66403,'Брукс','Brooks','','United States Of America',840,'America/Chicago'),(68818,'Брукс','Brooks','','United States Of America',840,'America/Chicago'),(68826,'Бруно','Bruno','','United States Of America',840,'Europe/Rome'),(71436,'Бруно','Bruno','','United States Of America',840,'Europe/Rome'),(58420,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(61162,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(62420,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(63662,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(66395,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(72027,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(73364,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(75868,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(78023,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(79718,'Брэдфорд','Bradford','','United States Of America',840,'Europe/London'),(69604,'Брюс','Bruce','','United States Of America',840,'America/Chicago'),(62437,'Брюссель','Brussels','','United States Of America',840,'Europe/Brussels'),(64421,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(67338,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(68811,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(71427,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(73376,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(75873,'Брюстер','Brewster','','United States Of America',840,'America/New_York'),(62442,'Буда','Buda','','United States Of America',840,'Europe/Bucharest'),(61177,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(62443,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(63682,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(64427,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(65093,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(68828,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(70125,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(71032,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(73397,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(75414,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(75892,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(76925,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(79819,'Буффало','Buffalo','','United States Of America',840,'America/Chicago'),(65101,'Буш','Bush','','United States Of America',840,'America/Chicago'),(65915,'Буш','Bush','','United States Of America',840,'America/Chicago'),(67858,'Вадодара','Baroda','','United States Of America',840,'Asia/Kolkata'),(62008,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(63599,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(68711,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(69555,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(79694,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(79783,'Вайоминг','Wyoming','','United States Of America',840,'America/Denver'),(58255,'Валенсия','Valencia','','United States Of America',840,'Europe/Madrid'),(79557,'Валенсия','Valencia','','United States Of America',840,'Europe/Madrid'),(60275,'Вальпараисо','Valparaiso','','United States Of America',840,'America/Santiago'),(64288,'Вальпараисо','Valparaiso','','United States Of America',840,'America/Santiago'),(71855,'Вальпараисо','Valparaiso','','United States Of America',840,'America/Santiago'),(63501,'Варна','Varna','','United States Of America',840,'Europe/Sofia'),(63530,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(64305,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(65795,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(69511,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(70933,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(75321,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(76773,'Варшава','Warsaw','','United States Of America',840,'Europe/Warsaw'),(56758,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(61959,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(63535,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(64307,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(71868,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(76777,'Ватерлоо','Waterloo','','United States Of America',840,'America/Toronto'),(58286,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(58935,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(59639,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(60936,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(61957,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(63533,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(64306,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(64957,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(65539,'Вашингтон','Mount Washington','','United States Of America',840,'America/New_York'),(65796,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(66335,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(66795,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(68673,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(69983,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(70935,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(71866,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(72164,'Вашингтон','Mount Washington','','United States Of America',840,'America/New_York'),(72244,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(72816,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(75322,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(77421,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(79592,'Вашингтон','Washington','','United States Of America',840,'America/Los_Angeles'),(58292,'Веймар','Weimar','','United States Of America',840,'America/Chicago'),(59811,'Век','Century','','United States Of America',840,'America/Chicago'),(79830,'Век','Centenary','','United States Of America',840,'America/New_York'),(56765,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(59377,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(60294,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(63547,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(64964,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(65806,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(70945,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(71998,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(76787,'Веллингтон','Wellington','','United States Of America',840,'Pacific/Auckland'),(60923,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(63511,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(66788,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(67258,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(70919,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(72805,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(76760,'Вена','Vienna','','United States Of America',840,'Europe/Vienna'),(58265,'Венеция','Venice','','United States Of America',840,'Europe/Rome'),(60278,'Венеция','Venice','','United States Of America',840,'Europe/Rome'),(63502,'Венеция','Venice','','United States Of America',840,'Europe/Rome'),(66325,'Венеция','Venice','','United States Of America',840,'Europe/Rome'),(58266,'Вентура','Ventura','','United States Of America',840,'America/Los_Angeles'),(61941,'Вентура','Ventura','','United States Of America',840,'America/Los_Angeles'),(74814,'Вера','Faith','','United States Of America',840,'America/New_York'),(63508,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(65778,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(69975,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(70914,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(72804,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(75722,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(76757,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(79567,'Верона','Verona','','United States Of America',840,'Europe/Rome'),(59636,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(63509,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(64293,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(65779,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(70915,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(76758,'Версаль','Versailles','','United States Of America',840,'Europe/Paris'),(69488,'Веста','Vesta','','United States Of America',840,'America/Chicago'),(58303,'Вестминстер','Westminster','','United States Of America',840,'Europe/London'),(59379,'Вестминстер','Westminster','','United States Of America',840,'Europe/London'),(67268,'Вестминстер','Westminster','','United States Of America',840,'Europe/London'),(67775,'Вестминстер','Westminster','','United States Of America',840,'Europe/London'),(58269,'Виктор','Victor','','United States Of America',840,'America/Denver'),(59367,'Виктор','Victor','','United States Of America',840,'America/Denver'),(61942,'Виктор','Victor','','United States Of America',840,'America/Denver'),(62279,'Виктор','Victor','','United States Of America',840,'America/Denver'),(71329,'Виктор','Victor','','United States Of America',840,'America/Denver'),(63510,'Виктория','Victoria','','United States Of America',840,'Australia/Melbourne'),(64944,'Виктория','Victoria','','United States Of America',840,'Australia/Melbourne'),(69489,'Виктория','Victoria','','United States Of America',840,'Australia/Melbourne'),(69977,'Виктория','Victoria','','United States Of America',840,'Australia/Melbourne'),(66998,'Вилка','Fork','','United States Of America',840,'America/New_York'),(79900,'Вилка','Fork','','United States Of America',840,'America/New_York'),(72806,'Вилла','Villas','','United States Of America',840,'America/New_York'),(73200,'Вильянуэва','Villanueva','','United States Of America',840,'America/Bogota'),(58323,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(59387,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(59663,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(63577,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(65834,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(66824,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(67793,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(70967,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(72843,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(75350,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(76835,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(79674,'Виндзор','Windsor','','United States Of America',840,'America/Toronto'),(58576,'Виноград','Grapevine','','United States Of America',840,'America/Chicago'),(59729,'Винтертур','Winterthur','','United States Of America',840,'Europe/Zurich'),(58322,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(58959,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(62290,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(63576,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(64336,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(64983,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(65833,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(67792,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(72001,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(72261,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(76833,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(77847,'Винчестер','Winchester','','United States Of America',840,'Europe/London'),(59412,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(60368,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(63644,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(65054,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(66873,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(72025,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(77978,'Вифлеем','Bethlehem','','United States Of America',840,'America/New_York'),(70917,'Виши','Vichy','','United States Of America',840,'Europe/Paris'),(64150,'Волок','Portage','','United States Of America',840,'America/Chicago'),(66679,'Волок','Portage','','United States Of America',840,'America/Chicago'),(68492,'Волок','Portage','','United States Of America',840,'America/Chicago'),(76555,'Волок','Portage','','United States Of America',840,'America/Chicago'),(79179,'Волок','Portage','','United States Of America',840,'America/Chicago'),(65628,'Ворон','Raven','','United States Of America',840,'America/New_York'),(56778,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(59670,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(60961,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(63593,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(67283,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(69550,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(72267,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(76841,'Вудсток','Woodstock','','United States Of America',840,'America/New_York'),(58279,'Вулкан','Volcano','','United States Of America',840,'Pacific/Apia'),(61056,'Вулкан','Volcano','','United States Of America',840,'Pacific/Apia'),(68663,'Вулкан','Vulcan','','United States Of America',840,'Europe/Bucharest'),(70922,'Вулкан','Vulcan','','United States Of America',840,'Europe/Bucharest'),(67798,'Вустер','Worcester','','United States Of America',840,'America/New_York'),(79684,'Вустер','Worcester','','United States Of America',840,'America/New_York'),(78348,'Вяз','Elm','','United States Of America',840,'Europe/Vienna'),(73829,'Гаага','Hague','','United States Of America',840,'Europe/Amsterdam'),(75520,'Гаага','Hague','','United States Of America',840,'Europe/Amsterdam'),(58606,'Гавана','Havana','','United States Of America',840,'America/Havana'),(59941,'Гавана','Havana','','United States Of America',840,'America/Havana'),(62819,'Гавана','Havana','','United States Of America',840,'America/Havana'),(64604,'Гавана','Havana','','United States Of America',840,'America/Havana'),(75532,'Гавана','Havana','','United States Of America',840,'America/Havana'),(64568,'Газ','Gas','','United States Of America',840,'America/Chicago'),(63837,'Галвестон','Galveston','','United States Of America',840,'America/Chicago'),(59935,'Галфпорт','Gulfport','','United States Of America',840,'America/Chicago'),(69705,'Галфпорт','Gulfport','','United States Of America',840,'America/Chicago'),(58592,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(61428,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(62799,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(66057,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(68164,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(69048,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(72467,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(73834,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(78525,'Гамбург','Hamburg','','United States Of America',840,'Europe/Berlin'),(56443,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(59150,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(60582,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(61429,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(62801,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(63872,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(64597,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(67453,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(68165,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(69708,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(70394,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(71133,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(73836,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(74874,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(75523,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(76145,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(78526,'Гамильтон','Hamilton','','United States Of America',840,'America/Toronto'),(60980,'Гана','Hana','','United States Of America',840,'Atlantic/Reykjavik'),(59491,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(62807,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(63876,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(64598,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(66525,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(67040,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(67455,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(68168,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(69053,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(72109,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(72991,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(78529,'Ганновер','Hanover','','United States Of America',840,'America/Jamaica'),(64759,'Ганновер-Мюнден','Munden','','United States Of America',840,'America/New_York'),(59127,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(62739,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(64565,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(66023,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(67436,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(75499,'Гарднер','Gardner','','United States Of America',840,'America/New_York'),(60586,'Гарлем','Harlem','','United States Of America',840,'America/New_York'),(71136,'Гарлем','Harlem','','United States Of America',840,'America/New_York'),(58597,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(62811,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(70399,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(71580,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(74884,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(76153,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(77609,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(78536,'Гаррисберг','Harrisburg','','United States Of America',840,'America/New_York'),(58556,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(60556,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(64566,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(65284,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(69005,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(72440,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(72978,'Гарфилд','Garfield','','United States Of America',840,'America/Chicago'),(59940,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(61444,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(68183,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(69059,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(71584,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(73857,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(77098,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(78546,'Гастингс','Hastings','','United States Of America',840,'Pacific/Auckland'),(60557,'Гей','Gay','','United States Of America',840,'America/New_York'),(62740,'Гей','Gays','','United States Of America',840,'America/Chicago'),(74842,'Гейтс','Gates','','United States Of America',840,'America/New_York'),(77589,'Гейтс','Gates','','United States Of America',840,'America/New_York'),(62826,'Генри','Henry','','United States Of America',840,'America/New_York'),(71593,'Генри','Henry','','United States Of America',840,'America/New_York'),(65292,'Гент','Ghent','','United States Of America',840,'America/Chicago'),(69013,'Гент','Ghent','','United States Of America',840,'America/Chicago'),(73774,'Гент','Ghent','','United States Of America',840,'America/Chicago'),(58561,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(59129,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(62744,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(71555,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(71931,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(73769,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(76105,'Генуя','Genoa','','United States Of America',840,'Europe/Rome'),(69070,'Герман','Herman','','United States Of America',840,'America/Chicago'),(70415,'Герман','Hermann','','United States Of America',840,'America/Chicago'),(71594,'Герман','Herman','','United States Of America',840,'America/Chicago'),(78562,'Герман','Herman','','United States Of America',840,'America/Chicago'),(59159,'Геспер','Hesperus','','United States Of America',840,'America/Denver'),(71563,'Гётеборг','Gothenburg','','United States Of America',840,'Europe/Stockholm'),(59486,'Гилфорд','Guilford','','United States Of America',840,'America/New_York'),(63869,'Гилфорд','Guilford','','United States Of America',840,'America/New_York'),(66521,'Гилфорд','Guilford','','United States Of America',840,'America/New_York'),(70389,'Гилфорд','Guilford','','United States Of America',840,'America/New_York'),(73826,'Гилфорд','Guilford','','United States Of America',840,'America/New_York'),(59478,'Глазго','Glasgo','','United States Of America',840,'America/New_York'),(65295,'Глазго','Glasgow','','United States Of America',840,'Europe/London'),(70354,'Глазго','Glasgow','','United States Of America',840,'Europe/London'),(71121,'Глазго','Glasgow','','United States Of America',840,'Europe/London'),(78474,'Глазго','Glasgow','','United States Of America',840,'Europe/London'),(67440,'Глостер','Gloucester','','United States Of America',840,'Europe/London'),(74853,'Глостер','Gloucester','','United States Of America',840,'Europe/London'),(59170,'Говард','Howard','','United States Of America',840,'America/Chicago'),(60607,'Говард','Howard','','United States Of America',840,'America/Chicago'),(64629,'Говард','Howard','','United States Of America',840,'America/Chicago'),(76188,'Говард','Howard','','United States Of America',840,'America/Chicago'),(78601,'Говард','Howard','','United States Of America',840,'America/Chicago'),(56465,'Голливуд','Hollywood','','United States Of America',840,'America/Los_Angeles'),(59953,'Голливуд','Hollywood','','United States Of America',840,'America/Los_Angeles'),(67050,'Голливуд','Hollywood','','United States Of America',840,'America/Los_Angeles'),(79942,'Голливуд','Hollywood','','United States Of America',840,'America/Los_Angeles'),(73759,'Голуэй','Galway','','United States Of America',840,'Europe/Dublin'),(60992,'Гонолулу','Honolulu','','United States Of America',840,'Pacific/Honolulu'),(75616,'Гора','Mountain','','United States Of America',840,'America/New_York'),(63849,'Госпорт','Gosport','','United States Of America',840,'Europe/London'),(69691,'Готье','Gautier','','United States Of America',840,'America/Chicago'),(59137,'Гранада','Granada','','United States Of America',840,'America/Grenada'),(69028,'Гранада','Granada','','United States Of America',840,'America/Grenada'),(68147,'Гранд-Рапидс','Grand Rapids','','United States Of America',840,'America/Detroit'),(69033,'Гранд-Рапидс','Grand Rapids','','United States Of America',840,'America/Detroit'),(76121,'Гранд-Рапидс','Grand Rapids','','United States Of America',840,'America/Detroit'),(59141,'Гранит','Granite','','United States Of America',840,'America/Denver'),(77084,'Гранит','Granite','','United States Of America',840,'America/Denver'),(56430,'Грант','Grant','','United States Of America',840,'America/Chicago'),(59142,'Грант','Grant','','United States Of America',840,'America/Chicago'),(59925,'Грант','Grant','','United States Of America',840,'America/Chicago'),(61411,'Грант','Grant','','United States Of America',840,'America/Chicago'),(66045,'Грант','Grant','','United States Of America',840,'America/Chicago'),(68149,'Грант','Grant','','United States Of America',840,'America/Chicago'),(71566,'Грант','Grant','','United States Of America',840,'America/Chicago'),(72986,'Грант','Grants','','United States Of America',840,'America/Denver'),(77085,'Грант','Grant','','United States Of America',840,'America/Chicago'),(57508,'Гренада','Grenada','','United States Of America',840,'America/Grenada'),(69704,'Гренада','Grenada','','United States Of America',840,'America/Grenada'),(59483,'Гринвич','Greenwich','','United States Of America',840,'Europe/London'),(64590,'Гринвич','Greenwich','','United States Of America',840,'Europe/London'),(72459,'Гринвич','Greenwich','','United States Of America',840,'Europe/London'),(73818,'Гринвич','Greenwich','','United States Of America',840,'Europe/London'),(76135,'Гринвич','Greenwich','','United States Of America',840,'Europe/London'),(78511,'Гринок','Greenock','','United States Of America',840,'Europe/London'),(56433,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(59927,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(60574,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(63860,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(67033,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(74865,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(78512,'Гринсборо','Greensboro','','United States Of America',840,'America/New_York'),(63866,'Гриффит','Griffith','','United States Of America',840,'America/Chicago'),(57514,'Гуадалупе','Guadalupe','','United States Of America',840,'America/Guadeloupe'),(63839,'Гэри','Gary','','United States Of America',840,'America/Chicago'),(69008,'Гэри','Gary','','United States Of America',840,'America/Chicago'),(65177,'Давид','David','','United States Of America',840,'Europe/Bucharest'),(60505,'Дадли','Dudley','','United States Of America',840,'Europe/London'),(67397,'Дадли','Dudley','','United States Of America',840,'Europe/London'),(70251,'Дадли','Dudley','','United States Of America',840,'Europe/London'),(74774,'Дадли','Dudley','','United States Of America',840,'Europe/London'),(78288,'Дадли','Dudley','','United States Of America',840,'Europe/London'),(60478,'Даллас','Dallas','','United States Of America',840,'America/Chicago'),(61271,'Даллас','Dallas','','United States Of America',840,'America/Chicago'),(74759,'Даллас','Dallas','','United States Of America',840,'America/Chicago'),(77544,'Даллас','Dallas','','United States Of America',840,'America/Chicago'),(78229,'Даллас','Dallas','','United States Of America',840,'America/Chicago'),(58487,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(60480,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(66957,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(76002,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(77545,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(78233,'Дамаск','Damascus','','United States Of America',840,'Asia/Damascus'),(72062,'Дамбартон','Dunbarton','','United States Of America',840,'America/New_York'),(61273,'Дана','Dana','','United States Of America',840,'America/Chicago'),(62588,'Дана','Dana','','United States Of America',840,'America/Chicago'),(63754,'Дана','Dana','','United States Of America',840,'America/Chicago'),(65175,'Дана','Dana','','United States Of America',840,'America/Chicago'),(74760,'Дана','Dana','','United States Of America',840,'America/Chicago'),(59862,'Данди','Dundee','','United States Of America',840,'Europe/London'),(61316,'Данди','Dundee','','United States Of America',840,'Europe/London'),(62626,'Данди','Dundee','','United States Of America',840,'Europe/London'),(65201,'Данди','Dundee','','United States Of America',840,'Europe/London'),(68046,'Данди','Dundee','','United States Of America',840,'Europe/London'),(69664,'Данди','Dundee','','United States Of America',840,'Europe/London'),(73618,'Данди','Dundee','','United States Of America',840,'Europe/London'),(76031,'Данди','Dundee','','United States Of America',840,'Europe/London'),(77561,'Данди','Dundee','','United States Of America',840,'Europe/London'),(66972,'Дандолк','Dundalk','','United States Of America',840,'America/New_York'),(59863,'Данидин','Dunedin','','United States Of America',840,'Pacific/Auckland'),(61293,'Дания','Denmark','','United States Of America',840,'Europe/Copenhagen'),(66456,'Дания','Denmark','','United States Of America',840,'Europe/Copenhagen'),(73599,'Дания','Denmark','','United States Of America',840,'Europe/Copenhagen'),(79871,'Дания','Denmark','','United States Of America',840,'Europe/Copenhagen'),(62627,'Данфермлин','Dunfermline','','United States Of America',840,'Europe/London'),(57342,'Дарвин','Darwin','','United States Of America',840,'Australia/Darwin'),(68910,'Дарвин','Darwin','','United States Of America',840,'Australia/Darwin'),(57382,'Дарем','Durham','','United States Of America',840,'Europe/London'),(59450,'Дарем','Durham','','United States Of America',840,'Europe/London'),(64510,'Дарем','Durham','','United States Of America',840,'Europe/London'),(66465,'Дарем','Durham','','United States Of America',840,'Europe/London'),(70255,'Дарем','Durham','','United States Of America',840,'Europe/London'),(72063,'Дарем','Durham','','United States Of America',840,'Europe/London'),(73620,'Дарем','Durham','','United States Of America',840,'Europe/London'),(74777,'Дарем','Durham','','United States Of America',840,'Europe/London'),(77021,'Дарем','Durham','','United States Of America',840,'Europe/London'),(78297,'Дарем','Durham','','United States Of America',840,'Europe/London'),(69650,'Дарлинг','Darling','','United States Of America',840,'America/Chicago'),(63756,'Дарлингтон','Darlington','','United States Of America',840,'Europe/London'),(66960,'Дарлингтон','Darlington','','United States Of America',840,'Europe/London'),(70224,'Дарлингтон','Darlington','','United States Of America',840,'Europe/London'),(78238,'Дарлингтон','Darlington','','United States Of America',840,'Europe/London'),(79868,'Дарлингтон','Darlington','','United States Of America',840,'Europe/London'),(70248,'Даунинг','Downing','','United States Of America',840,'America/Chicago'),(61296,'Де-Мойн','Des Moines','','United States Of America',840,'America/Chicago'),(72946,'Де-Мойн','Des Moines','','United States Of America',840,'America/Chicago'),(78257,'Девон','Devon','','United States Of America',840,'Europe/London'),(61279,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(62070,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(63757,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(65180,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(66962,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(68913,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(71068,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(71916,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(72380,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(73585,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(76004,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(77547,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(78244,'Дейтон','Dayton','','United States Of America',840,'America/New_York'),(59847,'Дейтона-Бич','Daytona Beach','','United States Of America',840,'America/New_York'),(57351,'Дели','Delhi','','United States Of America',840,'America/New_York'),(61288,'Дели','Delhi','','United States Of America',840,'America/New_York'),(65960,'Дели','Delhi','','United States Of America',840,'America/New_York'),(73596,'Дели','Delhi','','United States Of America',840,'America/New_York'),(59076,'Денвер','Denver','','United States Of America',840,'America/Denver'),(59078,'Денвер','Denver International Airport','','United States Of America',840,'America/Denver'),(61294,'Денвер','Denver','','United States Of America',840,'America/Denver'),(63764,'Денвер','Denver','','United States Of America',840,'America/Denver'),(65188,'Денвер','Denver','','United States Of America',840,'America/Denver'),(70236,'Денвер','Denver','','United States Of America',840,'America/Denver'),(73600,'Денвер','Denver','','United States Of America',840,'America/Denver'),(74768,'Денвер','Denver','','United States Of America',840,'America/Denver'),(78253,'Денвер','Denver','','United States Of America',840,'America/Denver'),(64499,'Денис','Dennis','','United States Of America',840,'America/New_York'),(67389,'Денис','Dennis','','United States Of America',840,'America/New_York'),(69654,'Денис','Dennis','','United States Of America',840,'America/New_York'),(59449,'Дерби','Derby','','United States Of America',840,'Europe/London'),(61295,'Дерби','Derby','','United States Of America',840,'Europe/London'),(63767,'Дерби','Derby','','United States Of America',840,'Europe/London'),(64501,'Дерби','Derby','','United States Of America',840,'Europe/London'),(73604,'Дерби','Derby','','United States Of America',840,'Europe/London'),(76016,'Дерби','Derby','','United States Of America',840,'Europe/London'),(72058,'Дерри','Derry','','United States Of America',840,'Europe/London'),(72138,'Дерри','Londonderry','','United States Of America',840,'Europe/London'),(72945,'Дерри','Derry','','United States Of America',840,'Europe/London'),(76285,'Дерри','Londonderry','','United States Of America',840,'Europe/London'),(78255,'Дерри','Derry','','United States Of America',840,'Europe/London'),(56339,'Детройт','Detroit','','United States Of America',840,'America/Detroit'),(66458,'Детройт','Detroit','','United States Of America',840,'America/Detroit'),(68032,'Детройт','Detroit','','United States Of America',840,'America/Detroit'),(77552,'Детройт','Detroit','','United States Of America',840,'America/Detroit'),(57587,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(59180,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(63916,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(64643,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(65394,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(66083,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(68237,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(70459,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(73006,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(73945,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(74928,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(75545,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(76206,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(78638,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(79742,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(79954,'Джеймстаун','Jamestown','','United States Of America',840,'America/New_York'),(56481,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(57585,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(60615,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(65392,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(66082,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(68236,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(69109,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(69735,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(70454,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(71164,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(71618,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(72122,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(72504,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(74925,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(76201,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(78633,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(79952,'Джексон','Jackson','','United States Of America',840,'America/Chicago'),(58648,'Джерси','Jersey','','United States Of America',840,'Europe/Jersey'),(60623,'Джерси','Jersey','','United States Of America',840,'Europe/Jersey'),(72506,'Джерси-Сити','Jersey City','','United States Of America',840,'America/New_York'),(70461,'Джефферсон-Сити','Jefferson City','','United States Of America',840,'America/Chicago'),(71165,'Джефферсон-Сити','Jefferson City','','United States Of America',840,'America/Chicago'),(56487,'Джонс','Jones','','United States Of America',840,'America/Chicago'),(66090,'Джонс','Jones','','United States Of America',840,'America/Chicago'),(68243,'Джонс','Jones','','United States Of America',840,'America/Chicago'),(77136,'Джонс','Jones','','United States Of America',840,'America/Chicago'),(58651,'Джонсон','Johnson','','United States Of America',840,'America/Chicago'),(64647,'Джонсон','Johnson','','United States Of America',840,'America/Chicago'),(71620,'Джонсон','Johnson','','United States Of America',840,'America/Chicago'),(73957,'Джонсон','Johnson','','United States Of America',840,'America/Chicago'),(59184,'Джонстаун','Johnstown','','United States Of America',840,'America/New_York'),(71621,'Джонстаун','Johnstown','','United States Of America',840,'America/New_York'),(73960,'Джонстаун','Johnstown','','United States Of America',840,'America/New_York'),(76216,'Джонстаун','Johnstown','','United States Of America',840,'America/New_York'),(78653,'Джонстаун','Johnstown','','United States Of America',840,'America/New_York'),(61389,'Джордж','George','','United States Of America',840,'America/Chicago'),(57480,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(59130,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(59476,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(59693,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(59911,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(60559,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(62105,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(62745,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(63844,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(65290,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(66026,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(66511,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(67017,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(67437,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(69012,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(69692,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(73770,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(76106,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(78459,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(79911,'Джорджтаун','Georgetown','','United States Of America',840,'America/Guyana'),(56027,'Джуно','Juneau','','United States Of America',840,'America/Juneau'),(78658,'Джуно','Juneau','','United States Of America',840,'America/Juneau'),(56483,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(58643,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(59977,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(60616,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(62883,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(70455,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(73942,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(74927,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(76204,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(77628,'Джэксонвилл','Jacksonville','','United States Of America',840,'America/New_York'),(57362,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(61302,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(62612,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(65192,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(70243,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(71077,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(71504,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(72948,'Диксон','Dixon','','United States Of America',840,'America/Chicago'),(56741,'Долина','Valley','','United States Of America',840,'America/Denver'),(71854,'Долина','Valley','','United States Of America',840,'America/Denver'),(56344,'Дора','Dora','','United States Of America',840,'America/Chicago'),(70246,'Дора','Dora','','United States Of America',840,'America/Chicago'),(72950,'Дора','Dora','','United States Of America',840,'America/Chicago'),(64509,'Дрезден','Dresden','','United States Of America',840,'Europe/Berlin'),(66463,'Дрезден','Dresden','','United States Of America',840,'Europe/Berlin'),(73615,'Дрезден','Dresden','','United States Of America',840,'Europe/Berlin'),(76027,'Дрезден','Dresden','','United States Of America',840,'Europe/Berlin'),(58553,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(63834,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(66507,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(67004,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(71550,'Дружба','Friend','','United States Of America',840,'America/Chicago'),(73752,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(76092,'Дружба','Friendship','','United States Of America',840,'America/Chicago'),(71714,'Дуб','Oak','','United States Of America',840,'America/Chicago'),(57375,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(60504,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(63770,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(69660,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(72061,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(74773,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(76028,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(78287,'Дублин','Dublin','','United States Of America',840,'Europe/Dublin'),(58510,'Дувр','Dover','','United States Of America',840,'Europe/London'),(59685,'Дувр','Dover','','United States Of America',840,'Europe/London'),(59860,'Дувр','Dover','','United States Of America',840,'Europe/London'),(60501,'Дувр','Dover','','United States Of America',840,'Europe/London'),(62077,'Дувр','Dover','','United States Of America',840,'Europe/London'),(62618,'Дувр','Dover','','United States Of America',840,'Europe/London'),(64507,'Дувр','Dover','','United States Of America',840,'Europe/London'),(65194,'Дувр','Dover','','United States Of America',840,'Europe/London'),(67394,'Дувр','Dover','','United States Of America',840,'Europe/London'),(68927,'Дувр','Dover','','United States Of America',840,'Europe/London'),(70247,'Дувр','Dover','','United States Of America',840,'Europe/London'),(72059,'Дувр','Dover','','United States Of America',840,'Europe/London'),(72392,'Дувр','Dover','','United States Of America',840,'Europe/London'),(74771,'Дувр','Dover','','United States Of America',840,'Europe/London'),(76025,'Дувр','Dover','','United States Of America',840,'Europe/London'),(77015,'Дувр','Dover','','United States Of America',840,'Europe/London'),(78273,'Дувр','Dover','','United States Of America',840,'Europe/London'),(55978,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(56347,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(56838,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(60499,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(67393,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(68040,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(71508,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(75459,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(77014,'Дуглас','Douglas','','United States Of America',840,'America/Chicago'),(60506,'Дулут','Duluth','','United States Of America',840,'America/Chicago'),(68929,'Дулут','Duluth','','United States Of America',840,'America/Chicago'),(68907,'Дунай','Danube','','United States Of America',840,'America/Chicago'),(56840,'Дункан','Duncan','','United States Of America',840,'America/Vancouver'),(69663,'Дункан','Duncan','','United States Of America',840,'America/Vancouver'),(71511,'Дункан','Duncan','','United States Of America',840,'America/Vancouver'),(77019,'Дункан','Duncan','','United States Of America',840,'America/Vancouver'),(79877,'Дункан','Duncan','','United States Of America',840,'America/Vancouver'),(59087,'Дуранго','Durango','','United States Of America',840,'America/Monterrey'),(61319,'Дуранго','Durango','','United States Of America',840,'America/Monterrey'),(57344,'Дэвис','Davis','','United States Of America',840,'America/Chicago'),(62593,'Дэвис','Davis','','United States Of America',840,'America/Chicago'),(74763,'Дэвис','Davis','','United States Of America',840,'America/Chicago'),(77002,'Дэвис','Davis','','United States Of America',840,'America/Chicago'),(63773,'Дюнкерк','Dunkirk','','United States Of America',840,'Europe/Paris'),(66973,'Дюнкерк','Dunkirk','','United States Of America',840,'Europe/Paris'),(73619,'Дюнкерк','Dunkirk','','United States Of America',840,'Europe/Paris'),(76032,'Дюнкерк','Dunkirk','','United States Of America',840,'Europe/Paris'),(68608,'Ель','Spruce','','United States Of America',840,'America/New_York'),(56415,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(59910,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(60558,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(61388,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(62104,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(62743,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(63842,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(69011,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(71554,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(73768,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(76104,'Женева','Geneva','','United States Of America',840,'Europe/Zurich'),(60562,'Жирар','Girard','','United States Of America',840,'America/Chicago'),(62755,'Жирар','Girard','','United States Of America',840,'America/Chicago'),(64573,'Жирар','Girard','','United States Of America',840,'America/Chicago'),(76110,'Жирар','Girard','','United States Of America',840,'America/Chicago'),(78471,'Жирар','Girard','','United States Of America',840,'America/Chicago'),(69992,'Запад','West','','United States Of America',840,'America/Argentina/Cordoba'),(66352,'Зволле','Zwolle','','United States Of America',840,'Europe/Amsterdam'),(73214,'Зуни','Zuni','','United States Of America',840,'America/Denver'),(56180,'Ива','Willow','','United States Of America',840,'America/Chicago'),(58318,'Ива','Willows','','United States Of America',840,'America/Los_Angeles'),(61832,'Ива','Salix','','United States Of America',840,'America/Chicago'),(77443,'Ива','Willow','','United States Of America',840,'America/Chicago'),(79298,'Ива','Salix','','United States Of America',840,'America/Chicago'),(58641,'Иван','Ivan','','United States Of America',840,'Europe/Prague'),(58639,'Ида','Ida','','United States Of America',840,'Asia/Riyadh'),(58742,'Ида','Mount Ida','','United States Of America',840,'America/Chicago'),(66076,'Ида','Ida','','United States Of America',840,'Asia/Riyadh'),(68220,'Ида','Ida','','United States Of America',840,'Asia/Riyadh'),(62835,'Идальго','Hidalgo','','United States Of America',840,'America/Mexico_City'),(58649,'Иерусалим','Jerusalem','','United States Of America',840,'Asia/Gaza'),(76213,'Иерусалим','Jerusalem','','United States Of America',840,'Asia/Gaza'),(57976,'Изюм','Raisin','','United States Of America',840,'America/Chicago'),(59330,'Ил','Silt','','United States Of America',840,'America/Denver'),(56364,'Империя','Empire','','United States Of America',840,'America/Chicago'),(57414,'Империя','Empire','','United States Of America',840,'America/Chicago'),(59100,'Империя','Empire','','United States Of America',840,'America/Chicago'),(65990,'Империя','Empire','','United States Of America',840,'America/Chicago'),(68074,'Империя','Empire','','United States Of America',840,'America/Chicago'),(71925,'Империя','Empire','','United States Of America',840,'America/Chicago'),(76054,'Империя','Empire','','United States Of America',840,'America/Chicago'),(57579,'Инвернесс','Inverness','','United States Of America',840,'Europe/London'),(59973,'Инвернесс','Inverness','','United States Of America',840,'Europe/London'),(69731,'Инвернесс','Inverness','','United States Of America',840,'Europe/London'),(71162,'Инвернесс','Inverness','','United States Of America',840,'Europe/London'),(78623,'Индиана','Indiana','','United States Of America',840,'America/Indiana/Indianapolis'),(63911,'Индианаполис','Indianapolis','','United States Of America',840,'America/Indiana/Indianapolis'),(57577,'Индио','Indio','','United States Of America',840,'America/Los_Angeles'),(73930,'Интерлакен','Interlaken','','United States Of America',840,'America/New_York'),(67486,'Ипсуич','Ipswich','','United States Of America',840,'America/New_York'),(62877,'Ирвинг','Irving','','United States Of America',840,'America/Chicago'),(73934,'Ирвинг','Irving','','United States Of America',840,'America/Chicago'),(68235,'Итака','Ithaca','','United States Of America',840,'America/New_York'),(71617,'Итака','Ithaca','','United States Of America',840,'America/New_York'),(73940,'Итака','Ithaca','','United States Of America',840,'America/New_York'),(66087,'Йена','Jena','','United States Of America',840,'Europe/Berlin'),(56780,'Йорк','York','','United States Of America',840,'Europe/London'),(66834,'Йорк','York','','United States Of America',840,'Europe/London'),(66835,'Йорк','York Beach','','United States Of America',840,'America/New_York'),(71897,'Йорк','York','','United States Of America',840,'Europe/London'),(75747,'Йорк','York','','United States Of America',840,'Europe/London'),(79699,'Йорк','York','','United States Of America',840,'Europe/London'),(57591,'Йоханнесбург','Johannesburg','','United States Of America',840,'Africa/Johannesburg'),(68242,'Йоханнесбург','Johannesburg','','United States Of America',840,'Africa/Johannesburg'),(65105,'Кадис','Cadiz','','United States Of America',840,'Europe/Madrid'),(75902,'Кадис','Cadiz','','United States Of America',840,'Europe/Madrid'),(60406,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(62460,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(70135,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(71444,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(73408,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(75903,'Каир','Cairo','','United States Of America',840,'Africa/Cairo'),(70468,'Кайзер','Kaiser','','United States Of America',840,'Europe/Berlin'),(57332,'Калвер-сити','Culver City','','United States Of America',840,'America/Los_Angeles'),(66416,'Кале','Calais','','United States Of America',840,'Europe/Paris'),(62461,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(67931,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(68835,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(69609,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(70136,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(73410,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(75418,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(75905,'Каледония','Caledonia','','United States Of America',840,'America/New_York'),(61265,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(65169,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(66955,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(74755,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(75994,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(79727,'Камберленд','Cumberland','','United States Of America',840,'America/New_York'),(60410,'Камилла','Camilla','','United States Of America',840,'America/New_York'),(62472,'Кампус','Campus','','United States Of America',840,'America/Chicago'),(72033,'Кандия','Candia','','United States Of America',840,'America/New_York'),(56489,'Канзас','Kansas','','United States Of America',840,'America/Chicago'),(62900,'Канзас','Kansas','','United States Of America',840,'America/Chicago'),(76219,'Канзас','Kansas','','United States Of America',840,'America/Chicago'),(77137,'Канзас','Kansas','','United States Of America',840,'America/Chicago'),(64651,'Канзас-Сити','Kansas City','','United States Of America',840,'America/Chicago'),(70469,'Канзас-Сити','Kansas City','','United States Of America',840,'America/Chicago'),(59427,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(60412,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(62473,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(64443,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(66420,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(67353,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(67936,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(68842,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(69612,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(70146,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(73430,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(74684,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(75914,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(76942,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(78085,'Кантон','Canton','','United States Of America',840,'Asia/Shanghai'),(57234,'Каньон','Canyon','','United States Of America',840,'America/Boise'),(68843,'Каньон','Canyon','','United States Of America',840,'America/Boise'),(56271,'Кардифф','Cardiff','','United States Of America',840,'Europe/London'),(75548,'Карлсруэ','Karlsruhe','','United States Of America',840,'Europe/Berlin'),(69118,'Карлстад','Karlstad','','United States Of America',840,'Europe/Stockholm'),(63108,'Кармель','Mount Carmel','','United States Of America',840,'America/New_York'),(78965,'Кармель','Mount Carmel','','United States Of America',840,'America/New_York'),(80017,'Кармель','Mount Carmel','','United States Of America',840,'America/New_York'),(62902,'Карнак','Karnak','','United States Of America',840,'America/Chicago'),(79720,'Каролина','Carolina','','United States Of America',840,'America/Bogota'),(59029,'Карр','Carr','','United States Of America',840,'America/Chicago'),(57248,'Карсон','Carson','','United States Of America',840,'America/Los_Angeles'),(61195,'Карсон','Carson','','United States Of America',840,'America/Los_Angeles'),(69615,'Карсон','Carson','','United States Of America',840,'America/Los_Angeles'),(72903,'Карсон','Carson','','United States Of America',840,'America/Los_Angeles'),(75424,'Карсон','Carson','','United States Of America',840,'America/Los_Angeles'),(67943,'Карсон-Сити','Carson City','','United States Of America',840,'America/Los_Angeles'),(71912,'Карсон-Сити','Carson City','','United States Of America',840,'America/Los_Angeles'),(65123,'Картер','Carter','','United States Of America',840,'America/Denver'),(71040,'Картер','Carter','','United States Of America',840,'America/Denver'),(76949,'Картер','Carter','','United States Of America',840,'America/Denver'),(72904,'Касабланка','Casa Blanca','','United States Of America',840,'America/Mexico_City'),(65924,'Кастор','Castor','','United States Of America',840,'America/Chicago'),(56810,'Каталина','Catalina','','United States Of America',840,'Europe/Bucharest'),(61201,'Кедр','Cedar','','United States Of America',840,'America/Chicago'),(64448,'Кедр','Cedar','','United States Of America',840,'America/Chicago'),(67951,'Кедр','Cedar','','United States Of America',840,'America/Chicago'),(68849,'Кедр','Cedar','','United States Of America',840,'America/Chicago'),(68881,'Кёльн','Cologne','','United States Of America',840,'Europe/Rome'),(72369,'Кёльн','Cologne','','United States Of America',840,'Europe/Rome'),(61189,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(62046,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(62466,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(64441,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(66417,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(66906,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(67352,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(68838,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(71446,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(73415,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(75906,'Кембридж','Cambridge','','United States Of America',840,'Europe/London'),(59499,'Кенсингтон','Kensington','','United States Of America',840,'Europe/London'),(64654,'Кенсингтон','Kensington','','United States Of America',840,'Europe/London'),(67069,'Кенсингтон','Kensington','','United States Of America',840,'Europe/London'),(69126,'Кенсингтон','Kensington','','United States Of America',840,'Europe/London'),(76222,'Кенсингтон','Kensington','','United States Of America',840,'Europe/London'),(56493,'Кент','Kent','','United States Of America',840,'America/New_York'),(59500,'Кент','Kent','','United States Of America',840,'America/New_York'),(62911,'Кент','Kent','','United States Of America',840,'America/New_York'),(69127,'Кент','Kent','','United States Of America',840,'America/New_York'),(73974,'Кент','Kent','','United States Of America',840,'America/New_York'),(76223,'Кент','Kent','','United States Of America',840,'America/New_York'),(77638,'Кент','Kent','','United States Of America',840,'America/New_York'),(78671,'Кент','Kent','','United States Of America',840,'America/New_York'),(59426,'Кентербери','Canterbury','','United States Of America',840,'Europe/London'),(72035,'Кентербери','Canterbury','','United States Of America',840,'Europe/London'),(73551,'Керкира','Corfu','','United States Of America',840,'America/New_York'),(57605,'Керман','Kerman','','United States Of America',840,'Asia/Tehran'),(59994,'Ки-Уэст','Key West','','United States Of America',840,'America/New_York'),(69133,'Килкенни','Kilkenny','','United States Of America',840,'Europe/Dublin'),(59996,'Килларни','Killarney','','United States Of America',840,'America/Winnipeg'),(59190,'Ким','Kim','','United States Of America',840,'Asia/Novokuznetsk'),(56495,'Кимберли','Kimberly','','United States Of America',840,'America/Chicago'),(62146,'Кимберли','Kimberly','','United States Of America',840,'America/Chicago'),(77640,'Кимберли','Kimberly','','United States Of America',840,'America/Chicago'),(58661,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(60635,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(62148,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(62917,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(67490,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(68260,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(70481,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(72127,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(72517,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(73984,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(74213,'Кингстон','New Kingston','','United States Of America',840,'America/New_York'),(76233,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(77148,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(78676,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(79745,'Кингстон','Kingston','','United States Of America',840,'America/Jamaica'),(76997,'Кирилл','Cyril','','United States Of America',840,'America/Chicago'),(59042,'Кларк','Clark','','United States Of America',840,'America/Chicago'),(70180,'Кларк','Clark','','United States Of America',840,'America/Chicago'),(72358,'Кларк','Clark','','United States Of America',840,'America/Chicago'),(78138,'Кларк','Clark','','United States Of America',840,'America/Chicago'),(75956,'Клеве','Cleves','','United States Of America',840,'America/New_York'),(75003,'Клён','Maple','','United States Of America',840,'America/Chicago'),(59822,'Клермон','Clermont','','United States Of America',840,'America/New_York'),(60439,'Клермон','Clermont','','United States Of America',840,'America/New_York'),(61229,'Клермон','Clermont','','United States Of America',840,'America/New_York'),(65142,'Клермон','Clermont','','United States Of America',840,'America/New_York'),(56293,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(58465,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(60440,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(68870,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(69627,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(70187,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(72921,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(73505,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(74719,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(75435,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(75953,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(76970,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(79843,'Кливленд','Cleveland','','United States Of America',840,'America/New_York'),(75954,'Кливленд-Хайтс','Cleveland Heights','','United States Of America',840,'America/New_York'),(56294,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(58466,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(59434,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(61231,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(62538,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(63725,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(65144,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(65941,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(66438,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(66936,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(67375,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(67980,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(68872,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(69628,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(70191,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(71048,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(72366,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(73510,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(74722,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(75958,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(76971,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(78150,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(79845,'Клинтон','Clinton','','United States Of America',840,'America/Indiana/Indianapolis'),(72922,'Клиф','Cliff','','United States Of America',840,'America/Chicago'),(59443,'Ковентри','Coventry','','United States Of America',840,'Europe/London'),(79725,'Ковентри','Coventry','','United States Of America',840,'Europe/London'),(58434,'Колдуэлл','Caldwell','','United States Of America',840,'America/New_York'),(62045,'Колдуэлл','Caldwell','','United States Of America',840,'America/New_York'),(64440,'Колдуэлл','Caldwell','','United States Of America',840,'America/New_York'),(72340,'Колдуэлл','Caldwell','','United States Of America',840,'America/New_York'),(75904,'Колдуэлл','Caldwell','','United States Of America',840,'America/New_York'),(60451,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(61240,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(69633,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(70197,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(73529,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(75966,'Коллинз','Collins','','United States Of America',840,'America/Chicago'),(61241,'Коло','Colo','','United States Of America',840,'America/Denver'),(64475,'Колония','Colony','','United States Of America',840,'America/Chicago'),(72370,'Колония','Colonia','','United States Of America',840,'Europe/Berlin'),(76977,'Колония','Colony','','United States Of America',840,'America/Chicago'),(59050,'Колорадо-Спрингс','Colorado Springs','','United States Of America',840,'America/Denver'),(56305,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(57303,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(59439,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(61242,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(62552,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(65149,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(65945,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(66943,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(69635,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(70198,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(72372,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(74730,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(78168,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(79848,'Колумбия','Columbia','','United States Of America',840,'America/Bogota'),(58470,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(60453,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(63732,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(64476,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(65150,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(67990,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(69636,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(71054,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(71470,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(72373,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(72929,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(74731,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(75440,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(75971,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(78170,'Колумбус','Columbus','','United States Of America',840,'America/New_York'),(59436,'Колчестер','Colchester','','United States Of America',840,'Europe/London'),(62545,'Колчестер','Colchester','','United States Of America',840,'Europe/London'),(60448,'Кольбер','Colbert','','United States Of America',840,'America/Chicago'),(76973,'Кольбер','Colbert','','United States Of America',840,'America/Chicago'),(78167,'Кольмар','Colmar','','United States Of America',840,'Europe/Paris'),(59052,'Комо','Como','','United States Of America',840,'Europe/Rome'),(60007,'Комо','Lake Como','','United States Of America',840,'America/New_York'),(69638,'Комо','Como','','United States Of America',840,'Europe/Rome'),(74733,'Комо','Como','','United States Of America',840,'Europe/Rome'),(78705,'Комо','Lake Como','','United States Of America',840,'America/New_York'),(58474,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(67379,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(67998,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(70204,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(72052,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(74738,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(78182,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(79853,'Конвей','Conway','','United States Of America',840,'America/Chicago'),(57307,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(58473,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(60457,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(62555,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(67378,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(67995,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(71472,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(72050,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(74734,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(78173,'Конкорд','Concord','','United States Of America',840,'America/New_York'),(67997,'Константин','Constantine','','United States Of America',840,'Africa/Algiers'),(56827,'Конча','Concho','','United States Of America',840,'America/Chicago'),(76980,'Конча','Concho','','United States Of America',840,'America/Chicago'),(73547,'Копенгаген','Copenhagen','','United States Of America',840,'Europe/Copenhagen'),(65154,'Коринф','Corinth','','United States Of America',840,'America/Chicago'),(66443,'Коринф','Corinth','','United States Of America',840,'America/Chicago'),(69640,'Коринф','Corinth','','United States Of America',840,'America/Chicago'),(73552,'Коринф','Corinth','','United States Of America',840,'America/Chicago'),(74742,'Корнелиус','Cornelius','','United States Of America',840,'America/Los_Angeles'),(77528,'Корнелиус','Cornelius','','United States Of America',840,'America/Los_Angeles'),(59440,'Корнуолл','Cornwall','','United States Of America',840,'Europe/London'),(73554,'Корнуолл','Cornwall','','United States Of America',840,'Europe/London'),(78191,'Корнуолл','Cornwall','','United States Of America',840,'Europe/London'),(78214,'Корона','Crown','','United States Of America',840,'America/New_York'),(78193,'Корсика','Corsica','','United States Of America',840,'America/New_York'),(64223,'Коса','Shoals','','United States Of America',840,'America/Indiana/Vincennes'),(57989,'Красная Гора','Red Mountain','','United States Of America',840,'America/Denver'),(79863,'Крест','Cross','','United States Of America',840,'America/Chicago'),(62572,'Крит','Crete','','United States Of America',840,'Europe/Athens'),(71482,'Крит','Crete','','United States Of America',840,'Europe/Athens'),(68897,'Кросби','Crosby','','United States Of America',840,'America/Chicago'),(69644,'Кросби','Crosby','','United States Of America',840,'America/Chicago'),(75444,'Кросби','Crosby','','United States Of America',840,'America/Chicago'),(78212,'Кросби','Crosby','','United States Of America',840,'America/Chicago'),(59069,'Кроули','Crowley','','United States Of America',840,'America/Denver'),(65953,'Кроули','Crowley','','United States Of America',840,'America/Denver'),(59062,'Кроуфорд','Crawford','','United States Of America',840,'America/Indiana/Marengo'),(60467,'Кроуфорд','Crawford','','United States Of America',840,'America/Indiana/Marengo'),(69642,'Кроуфорд','Crawford','','United States Of America',840,'America/Indiana/Marengo'),(71479,'Кроуфорд','Crawford','','United States Of America',840,'America/Indiana/Marengo'),(76991,'Кроуфорд','Crawford','','United States Of America',840,'America/Indiana/Marengo'),(56776,'Крыло','Wing','','United States Of America',840,'America/Chicago'),(75742,'Крыло','Wing','','United States Of America',840,'America/Chicago'),(56322,'Куба','Cuba','','United States Of America',840,'America/Havana'),(62577,'Куба','Cuba','','United States Of America',840,'America/Havana'),(64488,'Куба','Cuba','','United States Of America',840,'America/Havana'),(70219,'Куба','Cuba','','United States Of America',840,'America/Havana'),(72940,'Куба','Cuba','','United States Of America',840,'America/Havana'),(73575,'Куба','Cuba','','United States Of America',840,'America/Havana'),(75993,'Куба','Cuba','','United States Of America',840,'America/Havana'),(57973,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(60195,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(63276,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(64158,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(65624,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(67633,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(68501,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(70743,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(76566,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(79204,'Куинси','Quincy','','United States Of America',840,'America/New_York'),(61250,'Купер','Cooper','','United States Of America',840,'America/Chicago'),(57333,'Купертино','Cupertino','','United States Of America',840,'America/Los_Angeles'),(61268,'Кушинг','Cushing','','United States Of America',840,'America/Chicago'),(66450,'Кушинг','Cushing','','United States Of America',840,'America/Chicago'),(68902,'Кушинг','Cushing','','United States Of America',840,'America/Chicago'),(76995,'Кушинг','Cushing','','United States Of America',840,'America/Chicago'),(62047,'Кэри','Carey','','United States Of America',840,'America/New_York'),(62489,'Кэри','Cary','','United States Of America',840,'America/New_York'),(69617,'Кэри','Cary','','United States Of America',840,'America/New_York'),(74692,'Кэри','Cary','','United States Of America',840,'America/New_York'),(75918,'Кэри','Carey','','United States Of America',840,'America/New_York'),(65121,'Кэрри','Carrie','','United States Of America',840,'Europe/Paris'),(61194,'Кэрролл','Carroll','','United States Of America',840,'America/New_York'),(71449,'Кэрролл','Carroll','','United States Of America',840,'America/New_York'),(75919,'Кэрролл','Carroll','','United States Of America',840,'America/New_York'),(63957,'Ла-Пас','Lapaz','','United States Of America',840,'Asia/Manila'),(67074,'Ла-Плата','La Plata','','United States Of America',840,'America/Argentina/Buenos_Aires'),(70495,'Ла-Плата','La Plata','','United States Of America',840,'America/Argentina/Buenos_Aires'),(73019,'Ла-Плата','La Plata','','United States Of America',840,'America/Argentina/Buenos_Aires'),(59702,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(60023,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(61531,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(63960,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(67078,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(69748,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(71180,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(71632,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(74014,'Лавр','Laurel','','United States Of America',840,'America/New_York'),(57627,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(58665,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(62925,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(65421,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(70493,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(74951,'Лагранж','La Grange','','United States Of America',840,'America/Chicago'),(66111,'Лакомб','Lacombe','','United States Of America',840,'America/Edmonton'),(69746,'Ламберт','Lambert','','United States Of America',840,'America/Chicago'),(71177,'Ламберт','Lambert','','United States Of America',840,'America/Chicago'),(57658,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(62945,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(64667,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(65423,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(67495,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(69155,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(70506,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(72129,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(74009,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(76254,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(78714,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(79971,'Ланкастер','Lancaster','','United States Of America',840,'Europe/London'),(61527,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(62947,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(64669,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(68281,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(69157,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(74011,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(74958,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(76256,'Лансинг','Lansing','','United States Of America',840,'America/Detroit'),(71948,'Лас-Вегас','Las Vegas','','United States Of America',840,'America/Los_Angeles'),(73025,'Лас-Вегас','Las Vegas','','United States Of America',840,'America/Los_Angeles'),(56499,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(57638,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(59200,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(60638,'Лафайет','La Fayette','','United States Of America',840,'America/New_York'),(62924,'Лафайет','La Fayette','','United States Of America',840,'America/New_York'),(63946,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(65420,'Лафайет','La Fayette','','United States Of America',840,'America/New_York'),(66112,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(69139,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(72518,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(73991,'Лафайет','La Fayette','','United States Of America',840,'America/New_York'),(76244,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(77644,'Лафайет','Lafayette','','United States Of America',840,'America/Chicago'),(61897,'Лебеди','Swan','','United States Of America',840,'America/Chicago'),(62529,'Лебеди','Cisne','','United States Of America',840,'America/Guayaquil'),(56511,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(60650,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(62964,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(63972,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(65439,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(67505,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(68293,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(69753,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(70527,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(71640,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(74028,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(74972,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(77171,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(77651,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(79979,'Лексингтон','Lexington','','United States Of America',840,'America/New_York'),(62959,'Лена','Lena','','United States Of America',840,'America/Chicago'),(66125,'Лена','Lena','','United States Of America',840,'America/Chicago'),(69752,'Лена','Lena','','United States Of America',840,'America/Chicago'),(63967,'Лео','Leo','','United States Of America',840,'America/New_York'),(61543,'Леон','Leon','','United States Of America',840,'America/New_York'),(64682,'Леон','Leon','','United States Of America',840,'America/New_York'),(74023,'Леон','Leon','','United States Of America',840,'America/New_York'),(77168,'Леон','Leon','','United States Of America',840,'America/New_York'),(63968,'Леопольд','Leopold','','United States Of America',840,'America/New_York'),(70522,'Леопольд','Leopold','','United States Of America',840,'America/New_York'),(63814,'Лес','Forest','','United States Of America',840,'America/New_York'),(66013,'Лес','Forest','','United States Of America',840,'America/New_York'),(69684,'Лес','Forest','','United States Of America',840,'America/New_York'),(76077,'Лес','Forest','','United States Of America',840,'America/New_York'),(67500,'Лестер','Leicester','','United States Of America',840,'Europe/London'),(74022,'Лестер','Leicester','','United States Of America',840,'Europe/London'),(74966,'Лестер','Leicester','','United States Of America',840,'Europe/London'),(60027,'Ли','Lee','','United States Of America',840,'America/New_York'),(62955,'Ли','Lee','','United States Of America',840,'America/New_York'),(66563,'Ли','Lee','','United States Of America',840,'America/New_York'),(67498,'Ли','Lee','','United States Of America',840,'America/New_York'),(72131,'Ли','Lee','','United States Of America',840,'America/New_York'),(59504,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(60646,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(62954,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(63964,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(64676,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(65428,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(66562,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(70515,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(71634,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(72130,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(72530,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(76262,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(77163,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(77650,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(78739,'Ливан','Lebanon','','United States Of America',840,'Asia/Beirut'),(57686,'Ливермор','Livermore','','United States Of America',840,'America/Los_Angeles'),(59214,'Ливермор','Livermore','','United States Of America',840,'America/Los_Angeles'),(61561,'Ливермор','Livermore','','United States Of America',840,'America/Los_Angeles'),(65446,'Ливермор','Livermore','','United States Of America',840,'America/Los_Angeles'),(66578,'Ливермор','Livermore','','United States Of America',840,'America/Los_Angeles'),(62978,'Ливерпуль','Liverpool','','United States Of America',840,'Europe/London'),(74045,'Ливерпуль','Liverpool','','United States Of America',840,'Europe/London'),(78785,'Ливерпуль','Liverpool','','United States Of America',840,'Europe/London'),(66132,'Ливония','Livonia','','United States Of America',840,'America/Detroit'),(68300,'Ливония','Livonia','','United States Of America',840,'America/Detroit'),(70537,'Ливония','Livonia','','United States Of America',840,'America/Detroit'),(74048,'Ливония','Livonia','','United States Of America',840,'America/Detroit'),(56504,'Лидс','Leeds','','United States Of America',840,'Europe/London'),(66564,'Лидс','Leeds','','United States Of America',840,'Europe/London'),(67499,'Лидс','Leeds','','United States Of America',840,'Europe/London'),(74021,'Лидс','Leeds','','United States Of America',840,'Europe/London'),(75567,'Лидс','Leeds','','United States Of America',840,'Europe/London'),(62967,'Лима','Lima','','United States Of America',840,'America/Lima'),(71185,'Лима','Lima','','United States Of America',840,'America/Lima'),(74031,'Лима','Lima','','United States Of America',840,'America/Lima'),(76274,'Лима','Lima','','United States Of America',840,'America/Lima'),(71653,'Лиман','Lyman','','United States Of America',840,'America/Chicago'),(79995,'Лиман','Lyman','','United States Of America',840,'America/Chicago'),(66568,'Лимерик','Limerick','','United States Of America',840,'Europe/Dublin'),(74032,'Лимерик','Limerick','','United States Of America',840,'Europe/Dublin'),(56513,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(57676,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(58685,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(59704,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(61551,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(62968,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(64690,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(66571,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(67506,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(68294,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(70533,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(71186,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(71642,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(72133,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(73027,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(79746,'Линкольн','Lincoln','','United States Of America',840,'America/Chicago'),(65464,'Линч','Lynch','','United States Of America',840,'America/Chicago'),(71654,'Линч','Lynch','','United States Of America',840,'America/Chicago'),(69765,'Лион','Lyon','','United States Of America',840,'Europe/Paris'),(61555,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(66130,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(66574,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(67086,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(72134,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(74038,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(75574,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(76277,'Лиссабон','Lisbon','','United States Of America',840,'Europe/Lisbon'),(60034,'Ллойд','Lloyd','','United States Of America',840,'America/Chicago'),(65448,'Ллойд','Lloyd','','United States Of America',840,'America/Chicago'),(71189,'Ллойд','Lloyd','','United States Of America',840,'America/Chicago'),(56522,'Логан','Logan','','United States Of America',840,'America/Chicago'),(61563,'Логан','Logan','','United States Of America',840,'America/Chicago'),(62983,'Логан','Logan','','United States Of America',840,'America/Chicago'),(64696,'Логан','Logan','','United States Of America',840,'America/Chicago'),(73032,'Логан','Logan','','United States Of America',840,'America/Chicago'),(76283,'Логан','Logan','','United States Of America',840,'America/Chicago'),(64697,'Лонг-Айленд','Long Island','','United States Of America',840,'America/Nassau'),(66581,'Лонг-Айленд','Long Island','','United States Of America',840,'America/Nassau'),(74058,'Лонг-Айленд-Сити','Long Island City','','United States Of America',840,'America/New_York'),(58690,'Лондон','London','','United States Of America',840,'Europe/London'),(65450,'Лондон','London','','United States Of America',840,'Europe/London'),(76284,'Лондон','London','','United States Of America',840,'Europe/London'),(57706,'Лос-Анджелес','Los Angeles','','United States Of America',840,'America/Los_Angeles'),(72149,'Луг','Meadows','','United States Of America',840,'America/New_York'),(56523,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(59218,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(60661,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(62993,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(64703,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(65456,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(69760,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(71651,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(76290,'Луисвилл','Louisville','','United States Of America',840,'America/Kentucky/Louisville'),(67092,'Лука','Luke','','United States Of America',840,'America/New_York'),(78807,'Луксор','Luxor','','United States Of America',840,'Africa/Cairo'),(73039,'Луна','Luna','','United States Of America',840,'America/Denver'),(71953,'Лунд','Lund','','United States Of America',840,'Europe/Stockholm'),(59210,'Льюис','Lewis','','United States Of America',840,'America/New_York'),(61546,'Льюис','Lewis','','United States Of America',840,'America/New_York'),(63970,'Льюис','Lewis','','United States Of America',840,'America/New_York'),(64686,'Льюис','Lewis','','United States Of America',840,'America/New_York'),(74026,'Льюис','Lewis','','United States Of America',840,'America/New_York'),(66583,'Любек','Lubec','','United States Of America',840,'America/New_York'),(61577,'Люксембург','Luxemburg','','United States Of America',840,'Europe/Luxembourg'),(57717,'Люцерн','Lucerne','','United States Of America',840,'Europe/Zurich'),(59221,'Люцерн','Lucerne','','United States Of America',840,'Europe/Zurich'),(63987,'Люцерн','Lucerne','','United States Of America',840,'Europe/Zurich'),(70550,'Люцерн','Lucerne','','United States Of America',840,'Europe/Zurich'),(66269,'Маврикий','Saint Maurice','','United States Of America',840,'Europe/Paris'),(71659,'Магнит','Magnet','','United States Of America',840,'America/Chicago'),(56530,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(58701,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(59706,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(61584,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(63010,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(65469,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(69191,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(69771,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(72554,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(74997,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(76306,'Магнолия','Magnolia','','United States Of America',840,'America/Chicago'),(61583,'Мадрид','Madrid','','United States Of America',840,'Europe/Madrid'),(71658,'Мадрид','Madrid','','United States Of America',840,'Europe/Madrid'),(74073,'Мадрид','Madrid','','United States Of America',840,'Europe/Madrid'),(62169,'Май','May','','United States Of America',840,'America/Chicago'),(77198,'Май','May','','United States Of America',840,'America/Chicago'),(56918,'Майами','Miami','','United States Of America',840,'America/New_York'),(60072,'Майами','Miami','','United States Of America',840,'America/New_York'),(64018,'Майами','Miami','','United States Of America',840,'America/New_York'),(70593,'Майами','Miami','','United States Of America',840,'America/New_York'),(73056,'Майами','Miami','','United States Of America',840,'America/New_York'),(77212,'Майами','Miami','','United States Of America',840,'America/New_York'),(60073,'Майами-Бич','Miami Beach','','United States Of America',840,'America/New_York'),(56913,'Майер','Mayer','','United States Of America',840,'America/Port-au-Prince'),(69209,'Майер','Mayer','','United States Of America',840,'America/Port-au-Prince'),(63049,'Маклин','McLean','','United States Of America',840,'America/Chicago'),(71674,'Маклин','McLean','','United States Of America',840,'America/Chicago'),(74117,'Маклин','McLean','','United States Of America',840,'America/Chicago'),(69208,'Макс','Max','','United States Of America',840,'America/Chicago'),(71668,'Макс','Max','','United States Of America',840,'America/Chicago'),(75590,'Макс','Max','','United States Of America',840,'America/Chicago'),(72556,'Малага','Malaga','','United States Of America',840,'Europe/Madrid'),(73041,'Малага','Malaga','','United States Of America',840,'Europe/Madrid'),(76308,'Малага','Malaga','','United States Of America',840,'Europe/Madrid'),(77660,'Малин','Malin','','United States Of America',840,'Europe/Bucharest'),(72565,'Мальборо','Marlboro','','United States Of America',840,'America/New_York'),(74098,'Мальборо','Marlboro','','United States Of America',840,'America/New_York'),(71661,'Мальмё','Malmo','','United States Of America',840,'Europe/Stockholm'),(78826,'Мангейм','Manheim','','United States Of America',840,'America/New_York'),(60054,'Манго','Mango','','United States Of America',840,'America/Puerto_Rico'),(58704,'Манила','Manila','','United States Of America',840,'Asia/Manila'),(72560,'Мантуя','Mantua','','United States Of America',840,'Europe/Rome'),(76314,'Мантуя','Mantua','','United States Of America',840,'Europe/Rome'),(63016,'Манхэттен','Manhattan','','United States Of America',840,'America/New_York'),(64713,'Манхэттен','Manhattan','','United States Of America',840,'America/New_York'),(71198,'Манхэттен','Manhattan','','United States Of America',840,'America/New_York'),(71955,'Манхэттен','Manhattan','','United States Of America',840,'America/New_York'),(57732,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(59508,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(60675,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(61588,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(63015,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(65474,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(66588,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(67096,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(67517,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(68316,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(69194,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(72146,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(74083,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(76312,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(77185,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(78825,'Манчестер','Manchester','','United States Of America',840,'Europe/London'),(60055,'Марафон','Marathon','','United States Of America',840,'America/Chicago'),(61595,'Марафон','Marathon','','United States Of America',840,'America/Chicago'),(74091,'Марафон','Marathon','','United States Of America',840,'America/Chicago'),(76317,'Марафон','Marathon','','United States Of America',840,'America/Chicago'),(60058,'Маргит','Margate','','United States Of America',840,'Europe/London'),(57738,'Марина','Marina','','United States Of America',840,'America/Los_Angeles'),(56537,'Марион','Marion','','United States Of America',840,'America/New_York'),(58709,'Марион','Marion','','United States Of America',840,'America/New_York'),(59511,'Марион','Marion','','United States Of America',840,'America/New_York'),(61599,'Марион','Marion','','United States Of America',840,'America/New_York'),(63027,'Марион','Marion','','United States Of America',840,'America/New_York'),(63997,'Марион','Marion','','United States Of America',840,'America/New_York'),(64720,'Марион','Marion','','United States Of America',840,'America/New_York'),(65478,'Марион','Marion','','United States Of America',840,'America/New_York'),(66152,'Марион','Marion','','United States Of America',840,'America/New_York'),(67521,'Марион','Marion','','United States Of America',840,'America/New_York'),(68326,'Марион','Marion','','United States Of America',840,'America/New_York'),(69775,'Марион','Marion','','United States Of America',840,'America/New_York'),(71199,'Марион','Marion','','United States Of America',840,'America/New_York'),(74097,'Марион','Marion','','United States Of America',840,'America/New_York'),(75008,'Марион','Marion','','United States Of America',840,'America/New_York'),(75586,'Марион','Marion','','United States Of America',840,'America/New_York'),(76321,'Марион','Marion','','United States Of America',840,'America/New_York'),(77665,'Марион','Marion','','United States Of America',840,'America/New_York'),(78839,'Марион','Marion','','United States Of America',840,'America/New_York'),(79999,'Марион','Marion','','United States Of America',840,'America/New_York'),(63029,'Марк','Mark','','United States Of America',840,'Europe/Stockholm'),(78844,'Марс','Mars','','United States Of America',840,'America/Chicago'),(63032,'Марсель','Marseilles','','United States Of America',840,'America/New_York'),(60681,'Мартин','Martin','','United States Of America',840,'America/New_York'),(65483,'Мартин','Martin','','United States Of America',840,'America/New_York'),(68332,'Мартин','Martin','','United States Of America',840,'America/New_York'),(75589,'Мартин','Martin','','United States Of America',840,'America/New_York'),(76325,'Мартин','Martin','','United States Of America',840,'America/New_York'),(78847,'Мартин','Martin','','United States Of America',840,'America/New_York'),(80000,'Мартин','Martin','','United States Of America',840,'America/New_York'),(57744,'Мартинес','Martinez','','United States Of America',840,'America/Los_Angeles'),(60682,'Мартинес','Martinez','','United States Of America',840,'America/Los_Angeles'),(56574,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(58745,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(60724,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(61666,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(63116,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(64057,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(65538,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(66613,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(70629,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(74189,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(76405,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(77690,'Маунт-Вернон','Mount Vernon','','United States Of America',840,'America/New_York'),(59235,'Мёд','Mead','','United States Of America',840,'America/Denver'),(71675,'Мёд','Mead','','United States Of America',840,'America/Denver'),(77205,'Мёд','Mead','','United States Of America',840,'America/Denver'),(63054,'Медина','Medinah','','United States Of America',840,'America/Chicago'),(74121,'Медина','Medina','','United States Of America',840,'Asia/Riyadh'),(75599,'Медина','Medina','','United States Of America',840,'Asia/Riyadh'),(76346,'Медина','Medina','','United States Of America',840,'Asia/Riyadh'),(57758,'Мекка','Mecca','','United States Of America',840,'Asia/Riyadh'),(64008,'Мекка','Mecca','','United States Of America',840,'Asia/Riyadh'),(58724,'Мельбурн','Melbourne','','United States Of America',840,'Australia/Melbourne'),(60067,'Мельбурн','Melbourne','','United States Of America',840,'Australia/Melbourne'),(61621,'Мельбурн','Melbourne','','United States Of America',840,'Australia/Melbourne'),(65506,'Мельбурн','Melbourne','','United States Of America',840,'Australia/Melbourne'),(70600,'Мельник','Miller','','United States Of America',840,'America/Chicago'),(71682,'Мельник','Miller','','United States Of America',840,'America/Chicago'),(64012,'Мемфис','Memphis','','United States Of America',840,'America/Chicago'),(68347,'Мемфис','Memphis','','United States Of America',840,'America/Chicago'),(70587,'Мемфис','Memphis','','United States Of America',840,'America/Chicago'),(71678,'Мемфис','Memphis','','United States Of America',840,'America/Chicago'),(74126,'Мемфис','Memphis','','United States Of America',840,'America/Chicago'),(58726,'Мена','Mena','','United States Of America',840,'America/New_York'),(57762,'Менло-Парк','Menlo Park','','United States Of America',840,'America/Los_Angeles'),(69221,'Ментор','Mentor','','United States Of America',840,'America/New_York'),(76351,'Ментор','Mentor','','United States Of America',840,'America/New_York'),(57765,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(60695,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(62175,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(69792,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(74129,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(77211,'Меридиан','Meridian','','United States Of America',840,'America/Chicago'),(57764,'Мерсед','Merced','','United States Of America',840,'America/Bogota'),(70591,'Мец','Metz','','United States Of America',840,'Europe/Paris'),(64733,'Мид','Meade','','United States Of America',840,'America/Chicago'),(63068,'Мидлотиан','Midlothian','','United States Of America',840,'Europe/London'),(67113,'Мидлотиан','Midlothian','','United States Of America',840,'Europe/London'),(60702,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(63069,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(64024,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(64737,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(68360,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(69225,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(70597,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(72154,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(73057,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(76366,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(78905,'Милан','Milan','','United States Of America',840,'Europe/Rome'),(75038,'Милуоки','Milwaukee','','United States Of America',840,'America/Chicago'),(61631,'Миля','Miles','','United States Of America',840,'America/Chicago'),(61638,'Минден','Minden','','United States Of America',840,'America/Chicago'),(66167,'Минден','Minden','','United States Of America',840,'America/Chicago'),(71686,'Минден','Minden','','United States Of America',840,'America/Chicago'),(71961,'Минден','Minden','','United States Of America',840,'America/Chicago'),(57776,'Минерал','Mineral','','United States Of America',840,'America/New_York'),(63080,'Минерал','Mineral','','United States Of America',840,'America/New_York'),(65520,'Минерва','Minerva','','United States Of America',840,'America/Chicago'),(74153,'Минерва','Minerva','','United States Of America',840,'America/Chicago'),(76378,'Минерва','Minerva','','United States Of America',840,'America/Chicago'),(64741,'Миннеаполис','Minneapolis','','United States Of America',840,'America/Chicago'),(69229,'Миннеаполис','Minneapolis','','United States Of America',840,'America/Chicago'),(75040,'Миннеаполис','Minneapolis','','United States Of America',840,'America/Chicago'),(66604,'Мино','Minot','','United States Of America',840,'America/Chicago'),(67549,'Мино','Minot','','United States Of America',840,'America/Chicago'),(75608,'Мино','Minot','','United States Of America',840,'America/Chicago'),(65547,'Мира','Myra','','United States Of America',840,'Europe/Stockholm'),(57779,'Миранда','Miranda','','United States Of America',840,'America/Caracas'),(60709,'Митчелл','Mitchell','','United States Of America',840,'America/Chicago'),(64033,'Митчелл','Mitchell','','United States Of America',840,'America/Chicago'),(71687,'Митчелл','Mitchell','','United States Of America',840,'America/Chicago'),(77679,'Митчелл','Mitchell','','United States Of America',840,'America/Chicago'),(75604,'Мичиган','Michigan','','United States Of America',840,'America/Detroit'),(74158,'Модена','Modena','','United States Of America',840,'Europe/Rome'),(78934,'Модена','Modena','','United States Of America',840,'Europe/Rome'),(57783,'Модесто','Modesto','','United States Of America',840,'America/Los_Angeles'),(63085,'Модесто','Modesto','','United States Of America',840,'America/Los_Angeles'),(59245,'Молина','Molina','','United States Of America',840,'America/Santiago'),(61651,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(62181,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(64046,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(69803,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(75613,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(76388,'Монпелье','Montpelier','','United States Of America',840,'Europe/Paris'),(70613,'Монреаль','Montreal','','United States Of America',840,'America/Montreal'),(58734,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(59523,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(60711,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(61647,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(64037,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(66170,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(66607,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(68368,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(71688,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(72159,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(74163,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(75045,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(76385,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(77220,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(77682,'Монро','Monroe','','United States Of America',840,'America/Detroit'),(57787,'Монровия','Monrovia','','United States Of America',840,'Africa/Monrovia'),(64040,'Монровия','Monrovia','','United States Of America',840,'Africa/Monrovia'),(67118,'Монровия','Monrovia','','United States Of America',840,'Africa/Monrovia'),(56562,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(63094,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(64043,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(66173,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(68370,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(69237,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(74167,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(78947,'Монтгомери','Montgomery','','United States Of America',840,'America/Chicago'),(69236,'Монтевидео','Montevideo','','United States Of America',840,'America/Montevideo'),(57793,'Монтерей','Monterey','','United States Of America',840,'America/Los_Angeles'),(64041,'Монтерей','Monterey','','United States Of America',840,'America/Los_Angeles'),(66172,'Монтерей','Monterey','','United States Of America',840,'America/Los_Angeles'),(67554,'Монтерей','Monterey','','United States Of America',840,'America/Los_Angeles'),(58735,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(60087,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(60713,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(61649,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(63095,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(64044,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(65526,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(66609,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(69238,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(69802,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(70611,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(73062,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(74168,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(80014,'Монтичелло','Monticello','','United States Of America',840,'America/New_York'),(66175,'Мора','Mora','','United States Of America',840,'America/Denver'),(69242,'Мора','Mora','','United States Of America',840,'America/Denver'),(70617,'Мора','Mora','','United States Of America',840,'America/Denver'),(73064,'Мора','Mora','','United States Of America',840,'America/Denver'),(60716,'Морган','Morgan','','United States Of America',840,'America/New_York'),(69243,'Морган','Morgan','','United States Of America',840,'America/New_York'),(78953,'Морган','Morgan','','United States Of America',840,'America/New_York'),(61656,'Морли','Morley','','United States Of America',840,'Europe/London'),(68374,'Морли','Morley','','United States Of America',840,'Europe/London'),(70619,'Морли','Morley','','United States Of America',840,'Europe/London'),(56567,'Моррис','Morris','','United States Of America',840,'America/New_York'),(59527,'Моррис','Morris','','United States Of America',840,'America/New_York'),(60718,'Моррис','Morris','','United States Of America',840,'America/New_York'),(63099,'Моррис','Morris','','United States Of America',840,'America/New_York'),(64052,'Моррис','Morris','','United States Of America',840,'America/New_York'),(69244,'Моррис','Morris','','United States Of America',840,'America/New_York'),(74177,'Моррис','Morris','','United States Of America',840,'America/New_York'),(77224,'Моррис','Morris','','United States Of America',840,'America/New_York'),(78955,'Моррис','Morris','','United States Of America',840,'America/New_York'),(59251,'Моррисон','Morrison','','United States Of America',840,'America/Chicago'),(61658,'Моррисон','Morrison','','United States Of America',840,'America/Chicago'),(63100,'Моррисон','Morrison','','United States Of America',840,'America/Chicago'),(70620,'Моррисон','Morrison','','United States Of America',840,'America/Chicago'),(77225,'Моррисон','Morrison','','United States Of America',840,'America/Chicago'),(63102,'Мортон','Morton','','United States Of America',840,'America/Chicago'),(69246,'Мортон','Morton','','United States Of America',840,'America/Chicago'),(69807,'Мортон','Morton','','United States Of America',840,'America/Chicago'),(74181,'Мортон','Morton','','United States Of America',840,'America/Chicago'),(78959,'Мортон','Morton','','United States Of America',840,'America/Chicago'),(58740,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(61659,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(62184,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(64751,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(68376,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(76393,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(78960,'Москва','Moscow','','United States Of America',840,'America/Los_Angeles'),(77691,'Мулино','Mulino','','United States Of America',840,'Europe/Moscow'),(73358,'Мумбаи','Bombay','','United States Of America',840,'Asia/Kolkata'),(62182,'Мур','Moore','','United States Of America',840,'America/Chicago'),(71217,'Мур','Moore','','United States Of America',840,'America/Chicago'),(77222,'Мур','Moore','','United States Of America',840,'America/Chicago'),(80016,'Мур','Moore','','United States Of America',840,'America/Chicago'),(57797,'Мурпарк','Moorpark','','United States Of America',840,'America/Los_Angeles'),(56529,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(57727,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(58698,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(59507,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(60048,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(60673,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(63008,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(63993,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(64710,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(66587,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(67095,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(69189,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(69769,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(70558,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(71657,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(72145,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(72553,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(74072,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(74995,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(76304,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(78816,'Мэдисон','Madison','','United States Of America',840,'America/Chicago'),(72343,'Мэй','Cape May','','United States Of America',840,'America/New_York'),(74076,'Мэн','Maine','','United States Of America',840,'America/New_York'),(74102,'Мэриленд','Maryland','','United States Of America',840,'America/New_York'),(75617,'Мюнхен','Munich','','United States Of America',840,'America/Chicago'),(73072,'Навахо','Navajo','','United States Of America',840,'America/Phoenix'),(65549,'Назарет','Nazareth','','United States Of America',840,'Asia/Jerusalem'),(68397,'Назарет','Nazareth','','United States Of America',840,'Asia/Jerusalem'),(78993,'Назарет','Nazareth','','United States Of America',840,'Asia/Jerusalem'),(65548,'Нанси','Nancy','','United States Of America',840,'Europe/Paris'),(79751,'Наррагансетт','Narragansett','','United States Of America',840,'America/New_York'),(59714,'Нассау','Nassau','','United States Of America',840,'America/Nassau'),(69254,'Нассау','Nassau','','United States Of America',840,'America/Nassau'),(74199,'Нассау','Nassau','','United States Of America',840,'America/Nassau'),(60098,'Неаполь','Naples','','United States Of America',840,'Europe/Rome'),(62193,'Неаполь','Naples','','United States Of America',840,'Europe/Rome'),(66614,'Неаполь','Naples','','United States Of America',840,'Europe/Rome'),(74197,'Неаполь','Naples','','United States Of America',840,'Europe/Rome'),(75068,'Неаполь','Naples','','United States Of America',840,'Europe/Rome'),(61674,'Невада','Nevada','','United States Of America',840,'America/Los_Angeles'),(70639,'Невада','Nevada','','United States Of America',840,'America/Los_Angeles'),(76420,'Невада','Nevada','','United States Of America',840,'America/Los_Angeles'),(76458,'Ней','Ney','','United States Of America',840,'America/New_York'),(57823,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(60733,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(63135,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(69257,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(70637,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(71700,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(78997,'Нельсон','Nelson','','United States Of America',840,'Pacific/Auckland'),(72616,'Нептун','Neptune','','United States Of America',840,'America/Chicago'),(75628,'Ниагара','Niagara','','United States Of America',840,'America/New_York'),(56080,'Николаев','Nikolai','','United States Of America',840,'America/Anchorage'),(57836,'Ницца','Nice','','United States Of America',840,'Europe/Paris'),(63159,'Нобл','Noble','','United States Of America',840,'America/Chicago'),(66196,'Нобл','Noble','','United States Of America',840,'America/Chicago'),(70657,'Нобл','Noble','','United States Of America',840,'America/Chicago'),(77244,'Нобл','Noble','','United States Of America',840,'America/Chicago'),(66189,'Новый Орлеан','New Orleans','','United States Of America',840,'America/Chicago'),(56497,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(58664,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(60637,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(61513,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(62923,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(67073,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(78685,'Ноксвилл','Knoxville','','United States Of America',840,'America/New_York'),(59553,'Норидж','Norwich','','United States Of America',840,'Europe/London'),(64783,'Норидж','Norwich','','United States Of America',840,'Europe/London'),(74272,'Норидж','Norwich','','United States Of America',840,'Europe/London'),(75632,'Норидж','Norwich','','United States Of America',840,'Europe/London'),(76482,'Норидж','Norwich','','United States Of America',840,'Europe/London'),(72632,'Норма','Norma','','United States Of America',840,'Europe/Rome'),(67600,'Нортгемптон','Northampton','','United States Of America',840,'America/New_York'),(79063,'Нортгемптон','Northampton','','United States Of America',840,'America/New_York'),(64780,'Нортон','Norton','','United States Of America',840,'America/Chicago'),(67604,'Нортон','Norton','','United States Of America',840,'America/Chicago'),(76480,'Нортон','Norton','','United States Of America',840,'America/Chicago'),(59541,'Норфолк','Norfolk','','United States Of America',840,'America/New_York'),(67575,'Норфолк','Norfolk','','United States Of America',840,'America/New_York'),(71708,'Норфолк','Norfolk','','United States Of America',840,'America/New_York'),(74244,'Норфолк','Norfolk','','United States Of America',840,'America/New_York'),(67138,'Ноттингем','Nottingham','','United States Of America',840,'Europe/London'),(72189,'Ноттингем','Nottingham','','United States Of America',840,'Europe/London'),(79068,'Ноттингем','Nottingham','','United States Of America',840,'Europe/London'),(63140,'Нью-Бедфорд','New Bedford','','United States Of America',840,'America/New_York'),(67562,'Нью-Бедфорд','New Bedford','','United States Of America',840,'America/New_York'),(79004,'Нью-Бедфорд','New Bedford','','United States Of America',840,'America/New_York'),(75071,'Нью-Берн','New Bern','','United States Of America',840,'America/New_York'),(74223,'Нью-Йорк','New York','','United States Of America',840,'America/New_York'),(62195,'Нью-Плимут','New Plymouth','','United States Of America',840,'Pacific/Auckland'),(76442,'Нью-Плимут','New Plymouth','','United States Of America',840,'Pacific/Auckland'),(59534,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(63146,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(64072,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(65556,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(68403,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(70646,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(74211,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(76430,'Нью-Хейвен','New Haven','','United States Of America',840,'America/New_York'),(57827,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(58756,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(59716,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(63152,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(67132,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(70651,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(72626,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(74228,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(76452,'Ньюарк','Newark','','United States Of America',840,'America/New_York'),(56586,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(57830,'Ньюкасл','Newcastle','','United States Of America',840,'Europe/London'),(59256,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(59715,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(64069,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(65554,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(66623,'Ньюкасл','Newcastle','','United States Of America',840,'Europe/London'),(71703,'Ньюкасл','Newcastle','','United States Of America',840,'Europe/London'),(72168,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(77240,'Ньюкасл','Newcastle','','United States Of America',840,'Europe/London'),(79011,'Ньюкасл','New Castle','','United States Of America',840,'America/New_York'),(58758,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(64088,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(65559,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(66625,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(68409,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(69272,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(71705,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(72176,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(72629,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(74234,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(75077,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(76455,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(77701,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(79044,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(79752,'Ньюпорт','Newport','','United States Of America',840,'America/New_York'),(66626,'Ньюри','Newry','','United States Of America',840,'Europe/London'),(79045,'Ньюри','Newry','','United States Of America',840,'Europe/London'),(80031,'Ньюри','Newry','','United States Of America',840,'Europe/London'),(56591,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(60737,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(61687,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(63154,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(64775,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(67568,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(69823,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(72177,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(72630,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(75078,'Ньютон','Newton','','United States Of America',840,'America/New_York'),(77237,'Нэш','Nash','','United States Of America',840,'America/New_York'),(79072,'Нюрнберг','Nuremberg','','United States Of America',840,'Europe/Berlin'),(56217,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(57112,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(60350,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(61114,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(62351,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(63627,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(64385,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(65016,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(66365,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(67308,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(67844,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(71386,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(72016,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(73282,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(77921,'Оберн','Auburn','','United States Of America',840,'America/Chicago'),(60144,'Овьедо','Oviedo','','United States Of America',840,'Europe/Madrid'),(59718,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(60122,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(69289,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(70666,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(71719,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(74284,'Одесса','Odessa','','United States Of America',840,'Europe/Simferopol'),(63183,'Один','Odin','','United States Of America',840,'America/Chicago'),(69290,'Один','Odin','','United States Of America',840,'America/Chicago'),(58779,'Озон','Ozone','','United States Of America',840,'America/Chicago'),(60125,'Окичоби','Okeechobee','','United States Of America',840,'America/New_York'),(77257,'Оклахома-Сити','Oklahoma City','','United States Of America',840,'America/Chicago'),(57861,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(58765,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(60116,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(61700,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(63177,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(65564,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(66644,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(67139,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(68428,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(69288,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(69829,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(71716,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(72644,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(77711,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(79757,'Окленд','Oakland','','United States Of America',840,'America/Los_Angeles'),(58776,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(59562,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(60145,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(60758,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(61725,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(64120,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(64806,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(66659,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(67146,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(67616,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(68454,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(69836,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(71735,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(72657,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(74315,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(75097,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(76511,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(79102,'Оксфорд','Oxford','','United States Of America',840,'Europe/London'),(57067,'Олбани','Albany','','United States Of America',840,'America/Denver'),(60328,'Олбани','Albany','','United States Of America',840,'America/Denver'),(62299,'Олбани','Albany','','United States Of America',840,'America/Denver'),(63609,'Олбани','Albany','','United States Of America',840,'America/Denver'),(64998,'Олбани','Albany','','United States Of America',840,'America/Denver'),(65856,'Олбани','Albany','','United States Of America',840,'America/Denver'),(68724,'Олбани','Albany','','United States Of America',840,'America/Denver'),(70008,'Олбани','Albany','','United States Of America',840,'America/Denver'),(73225,'Олбани','Albany','','United States Of America',840,'America/Denver'),(75760,'Олбани','Albany','','United States Of America',840,'America/Denver'),(76862,'Олбани','Albany','','United States Of America',840,'America/Denver'),(77457,'Олбани','Albany','','United States Of America',840,'America/Denver'),(65570,'Олимпия','Olympia','','United States Of America',840,'America/Los_Angeles'),(64105,'Ольденбург','Oldenburg','','United States Of America',840,'Europe/Berlin'),(58772,'Омаха','Omaha','','United States Of America',840,'America/Chicago'),(60755,'Омаха','Omaha','','United States Of America',840,'America/Chicago'),(63193,'Омаха','Omaha','','United States Of America',840,'America/Chicago'),(71723,'Омаха','Omaha','','United States Of America',840,'America/Chicago'),(74878,'Омен','Harbinger','','United States Of America',840,'America/New_York'),(57875,'Онтарио','Ontario','','United States Of America',840,'America/Toronto'),(74296,'Онтарио','Ontario','','United States Of America',840,'America/Toronto'),(76497,'Онтарио','Ontario','','United States Of America',840,'America/Toronto'),(77715,'Онтарио','Ontario','','United States Of America',840,'America/Toronto'),(61712,'Оран','Oran','','United States Of America',840,'Africa/Algiers'),(70672,'Оран','Oran','','United States Of America',840,'Africa/Algiers'),(57877,'Оранж','Orange','','United States Of America',840,'America/Chicago'),(59561,'Оранж','Orange','','United States Of America',840,'America/Chicago'),(67612,'Оранж','Orange','','United States Of America',840,'America/Chicago'),(72656,'Оранж','Orange','','United States Of America',840,'America/Chicago'),(63202,'Орегон','Oregon','','United States Of America',840,'America/Los_Angeles'),(70673,'Орегон','Oregon','','United States Of America',840,'America/Los_Angeles'),(76499,'Орегон','Oregon','','United States Of America',840,'America/Los_Angeles'),(64109,'Орест','Orestes','','United States Of America',840,'America/Indiana/Indianapolis'),(58281,'Орех','Walnut','','United States Of America',840,'America/Los_Angeles'),(61955,'Орех','Walnut','','United States Of America',840,'America/Los_Angeles'),(63521,'Орех','Walnut','','United States Of America',840,'America/Los_Angeles'),(64954,'Орех','Walnut','','United States Of America',840,'America/Los_Angeles'),(69980,'Орех','Walnut','','United States Of America',840,'America/Los_Angeles'),(60137,'Орландо','Orlando','','United States Of America',840,'America/New_York'),(60138,'Орландо','Orlando International Airport','','United States Of America',840,'America/New_York'),(65573,'Орландо','Orlando','','United States Of America',840,'America/New_York'),(77265,'Орландо','Orlando','','United States Of America',840,'America/New_York'),(57884,'Орлеан','Orleans','','United States Of America',840,'Europe/Paris'),(64111,'Орлеан','Orleans','','United States Of America',840,'Europe/Paris'),(67613,'Орлеан','Orleans','','United States Of America',840,'Europe/Paris'),(68441,'Орлеан','Orleans','','United States Of America',840,'Europe/Paris'),(71729,'Орлеан','Orleans','','United States Of America',840,'Europe/Paris'),(66206,'Оскар','Oscar','','United States Of America',840,'America/New_York'),(77267,'Оскар','Oscar','','United States Of America',840,'America/New_York'),(69303,'Осло','Oslo','','United States Of America',840,'Europe/Oslo'),(58374,'Остин','Austin','','United States Of America',840,'America/Chicago'),(58991,'Остин','Austin','','United States Of America',840,'America/Chicago'),(63629,'Остин','Austin','','United States Of America',840,'America/Chicago'),(65018,'Остин','Austin','','United States Of America',840,'America/Chicago'),(68753,'Остин','Austin','','United States Of America',840,'America/Chicago'),(71902,'Остин','Austin','','United States Of America',840,'America/Chicago'),(77924,'Остин','Austin','','United States Of America',840,'America/Chicago'),(65385,'Остров','Island','','United States Of America',840,'Atlantic/Reykjavik'),(63208,'Оттава','Ottawa','','United States Of America',840,'America/Toronto'),(64803,'Оттава','Ottawa','','United States Of America',840,'America/Toronto'),(76506,'Оттава','Ottawa','','United States Of America',840,'America/Toronto'),(57895,'Палермо','Palermo','','United States Of America',840,'Europe/Rome'),(66660,'Палермо','Palermo','','United States Of America',840,'Europe/Rome'),(75639,'Палермо','Palermo','','United States Of America',840,'Europe/Rome'),(57897,'Палм-Спрингс','Palm Springs','','United States Of America',840,'America/Los_Angeles'),(57899,'Пало-Альто','Palo Alto','','United States Of America',840,'America/Los_Angeles'),(57633,'Пальма','La Palma','','United States Of America',840,'America/Bogota'),(63214,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(64121,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(66661,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(68458,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(70686,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(71739,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(72659,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(74322,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(75098,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(79105,'Пальмира','Palmyra','','United States Of America',840,'Asia/Damascus'),(63219,'Пана','Pana','','United States Of America',840,'America/Chicago'),(60159,'Панама','Panama City','','United States Of America',840,'America/Chicago'),(61732,'Панама','Panama','','United States Of America',840,'America/Panama'),(63220,'Панама','Panama','','United States Of America',840,'America/Panama'),(71740,'Панама','Panama','','United States Of America',840,'America/Panama'),(74323,'Панама','Panama','','United States Of America',840,'America/Panama'),(77271,'Панама','Panama','','United States Of America',840,'America/Panama'),(64810,'Паола','Paola','','United States Of America',840,'Europe/Malta'),(58783,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(62206,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(63222,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(65580,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(66662,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(68461,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(69841,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(70687,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(76515,'Париж','Paris','','United States Of America',840,'Europe/Paris'),(56938,'Парк','Parks','','United States Of America',840,'America/Chicago'),(58786,'Парк','Parks','','United States Of America',840,'America/Chicago'),(64812,'Парк','Park','','United States Of America',840,'Asia/Karachi'),(71742,'Парк','Parks','','United States Of America',840,'America/Chicago'),(56937,'Паркер','Parker','','United States Of America',840,'America/Chicago'),(59281,'Паркер','Parker','','United States Of America',840,'America/Chicago'),(62207,'Паркер','Parker','','United States Of America',840,'America/Chicago'),(64813,'Паркер','Parker','','United States Of America',840,'America/Chicago'),(79109,'Паркер','Parker','','United States Of America',840,'America/Chicago'),(62208,'Парма','Parma','','United States Of America',840,'Europe/Rome'),(68462,'Парма','Parma','','United States Of America',840,'Europe/Rome'),(70689,'Парма','Parma','','United States Of America',840,'Europe/Rome'),(76517,'Парма','Parma','','United States Of America',840,'Europe/Rome'),(72665,'Патерсон','Paterson','','United States Of America',840,'America/New_York'),(63229,'Пауни','Pawnee','','United States Of America',840,'America/Chicago'),(77277,'Пауни','Pawnee','','United States Of America',840,'America/Chicago'),(70731,'Пауэлл','Powell','','United States Of America',840,'America/New_York'),(76560,'Пауэлл','Powell','','United States Of America',840,'America/New_York'),(76522,'Педро','Pedro','','United States Of America',840,'America/Sao_Paulo'),(60148,'Пейсли','Paisley','','United States Of America',840,'Europe/London'),(77722,'Пейсли','Paisley','','United States Of America',840,'Europe/London'),(60167,'Пенсакола','Pensacola','','United States Of America',840,'America/Indiana/Tell_City'),(58796,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(60170,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(60769,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(61742,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(63241,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(64821,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(66215,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(66671,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(68471,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(70699,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(74343,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(76527,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(77281,'Перри','Perry','','United States Of America',840,'America/Indiana/Tell_City'),(63239,'Перси','Percy','','United States Of America',840,'America/Chicago'),(75645,'Перт','Perth','','United States Of America',840,'Europe/London'),(61744,'Перу','Peru','','United States Of America',840,'America/Lima'),(63242,'Перу','Peru','','United States Of America',840,'America/Lima'),(64135,'Перу','Peru','','United States Of America',840,'America/Lima'),(64822,'Перу','Peru','','United States Of America',840,'America/Lima'),(66672,'Перу','Peru','','United States Of America',840,'America/Lima'),(71746,'Перу','Peru','','United States Of America',840,'America/Lima'),(74345,'Перу','Peru','','United States Of America',840,'America/Lima'),(67161,'Пинто','Pinto','','United States Of America',840,'Europe/Madrid'),(57938,'Пионер','Pioneer','','United States Of America',840,'America/New_York'),(66221,'Пионер','Pioneer','','United States Of America',840,'America/New_York'),(76539,'Пионер','Pioneer','','United States Of America',840,'America/New_York'),(75650,'Писек','Pisek','','United States Of America',840,'Europe/Prague'),(72193,'Питерборо','Peterborough','','United States Of America',840,'Europe/London'),(79150,'Питтсбург','Pittsburgh','','United States Of America',840,'America/New_York'),(61751,'Плано','Plano','','United States Of America',840,'America/Chicago'),(63254,'Плано','Plano','','United States Of America',840,'America/Chicago'),(57952,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(59570,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(60179,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(61755,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(63258,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(64147,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(66676,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(67627,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(68484,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(69332,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(71757,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(72200,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(74375,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(75129,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(76548,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(79161,'Плимут','Plymouth','','United States Of America',840,'Europe/London'),(74914,'Подкова','Horse Shoe','','United States Of America',840,'America/New_York'),(62209,'Пол','Paul','','United States Of America',840,'America/Denver'),(77576,'Поле','Fields','','United States Of America',840,'America/Chicago'),(70719,'Полк','Polk','','United States Of America',840,'America/New_York'),(71758,'Полк','Polk','','United States Of America',840,'America/New_York'),(76549,'Полк','Polk','','United States Of America',840,'America/New_York'),(79171,'Полк','Polk','','United States Of America',840,'America/New_York'),(63260,'Поло','Polo','','United States Of America',840,'America/Chicago'),(70721,'Поло','Polo','','United States Of America',840,'America/Chicago'),(57958,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(63261,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(64833,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(70722,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(72689,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(74379,'Помона','Pomona','','United States Of America',840,'America/Los_Angeles'),(68486,'Помпеи','Pompeii','','United States Of America',840,'Europe/Rome'),(58810,'Понка','Ponca','','United States Of America',840,'America/Chicago'),(71759,'Понка','Ponca','','United States Of America',840,'America/Chicago'),(72692,'Порт-Элизабет','Port Elizabeth','','United States Of America',840,'Africa/Johannesburg'),(60780,'Портал','Portal','','United States Of America',840,'America/New_York'),(75652,'Портал','Portal','','United States Of America',840,'America/New_York'),(66680,'Портер','Porter','','United States Of America',840,'America/Chicago'),(69335,'Портер','Porter','','United States Of America',840,'America/Chicago'),(77291,'Портер','Porter','','United States Of America',840,'America/Chicago'),(58813,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(59574,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(64151,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(66681,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(68493,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(70728,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(74397,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(75653,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(76557,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(77732,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(79182,'Портленд','Portland','','United States Of America',840,'America/Los_Angeles'),(61760,'Портсмут','Portsmouth','','United States Of America',840,'America/New_York'),(72201,'Портсмут','Portsmouth','','United States Of America',840,'America/New_York'),(76558,'Портсмут','Portsmouth','','United States Of America',840,'America/New_York'),(79761,'Портсмут','Portsmouth','','United States Of America',840,'America/New_York'),(74400,'Потсдам','Potsdam','','United States Of America',840,'Europe/Berlin'),(76559,'Потсдам','Potsdam','','United States Of America',840,'Europe/Berlin'),(64835,'Поттер','Potter','','United States Of America',840,'America/Chicago'),(71760,'Поттер','Potter','','United States Of America',840,'America/Chicago'),(71761,'Прага','Prague','','United States Of America',840,'Europe/Prague'),(77294,'Прага','Prague','','United States Of America',840,'Europe/Prague'),(56959,'Прескотт','Prescott','','United States Of America',840,'America/Phoenix'),(58820,'Прескотт','Prescott','','United States Of America',840,'America/Phoenix'),(61764,'Прескотт','Prescott','','United States Of America',840,'America/Phoenix'),(64840,'Прескотт','Prescott','','United States Of America',840,'America/Phoenix'),(68497,'Прескотт','Prescott','','United States Of America',840,'America/Phoenix'),(59576,'Престон','Preston','','United States Of America',840,'America/New_York'),(60784,'Престон','Preston','','United States Of America',840,'America/New_York'),(61765,'Престон','Preston','','United States Of America',840,'America/New_York'),(62224,'Престон','Preston','','United States Of America',840,'America/New_York'),(65615,'Престон','Preston','','United States Of America',840,'America/New_York'),(67172,'Престон','Preston','','United States Of America',840,'America/New_York'),(69336,'Престон','Preston','','United States Of America',840,'America/New_York'),(69868,'Престон','Preston','','United States Of America',840,'America/New_York'),(70735,'Престон','Preston','','United States Of America',840,'America/New_York'),(77295,'Престон','Preston','','United States Of America',840,'America/New_York'),(56636,'Причард','Prichard','','United States Of America',840,'America/Chicago'),(65629,'Равенна','Ravenna','','United States Of America',840,'Europe/Rome'),(68507,'Равенна','Ravenna','','United States Of America',840,'Europe/Rome'),(71766,'Равенна','Ravenna','','United States Of America',840,'Europe/Rome'),(76571,'Равенна','Ravenna','','United States Of America',840,'Europe/Rome'),(63277,'Радом','Radom','','United States Of America',840,'Europe/Warsaw'),(57905,'Рай','Paradise','','United States Of America',840,'America/Los_Angeles'),(64811,'Рай','Paradise','','United States Of America',840,'America/Los_Angeles'),(68460,'Рай','Paradise','','United States Of America',840,'America/Los_Angeles'),(71234,'Рай','Paradise','','United States Of America',840,'America/Los_Angeles'),(79107,'Рай','Paradise','','United States Of America',840,'America/Los_Angeles'),(63597,'Райт','Wrights','','United States Of America',840,'America/New_York'),(59301,'Ранд','Rand','','United States Of America',840,'America/New_York'),(58844,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(61817,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(63334,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(64870,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(65661,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(67650,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(69382,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(74492,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(79278,'Рассел','Russell','','United States Of America',840,'America/Chicago'),(56972,'Раунд-Рок','Round Rock','','United States Of America',840,'America/Chicago'),(60794,'Редан','Redan','','United States Of America',840,'Australia/Melbourne'),(64853,'Рединг','Reading','','United States Of America',840,'America/New_York'),(67637,'Рединг','Reading','','United States Of America',840,'America/New_York'),(68509,'Рединг','Reading','','United States Of America',840,'America/New_York'),(69348,'Рединг','Reading','','United States Of America',840,'America/New_York'),(79210,'Рединг','Reading','','United States Of America',840,'America/New_York'),(60801,'Рейн','Rhine','','United States Of America',840,'America/New_York'),(65642,'Река','River','','United States Of America',840,'Europe/Kiev'),(73116,'Рибера','Ribera','','United States Of America',840,'Europe/Rome'),(68520,'Рига','Riga','','United States Of America',840,'Europe/Riga'),(60816,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(61810,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(63320,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(64179,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(69885,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(74470,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(76599,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(77753,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(79261,'Рим','Rome','','United States Of America',840,'Europe/Rome'),(71975,'Рино','Reno','','United States Of America',840,'America/Los_Angeles'),(76578,'Рино','Reno','','United States Of America',840,'America/Los_Angeles'),(79223,'Рино','Reno','','United States Of America',840,'America/Los_Angeles'),(72717,'Рио-Гранде','Rio Grande','','United States Of America',840,'America/Denver'),(76587,'Рио-Гранде','Rio Grande','','United States Of America',840,'America/Denver'),(73118,'Рио-Ранчо','Rio Rancho','','United States Of America',840,'America/Denver'),(69882,'Рипли','Ripley','','United States Of America',840,'America/Chicago'),(74458,'Рипли','Ripley','','United States Of America',840,'America/Chicago'),(76588,'Рипли','Ripley','','United States Of America',840,'America/Chicago'),(77317,'Рипли','Ripley','','United States Of America',840,'America/Chicago'),(69358,'Рис','Rice','','United States Of America',840,'America/Chicago'),(58005,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(63291,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(64167,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(64858,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(65640,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(66691,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(67641,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(68517,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(69360,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(70764,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(76582,'Ричмонд','Richmond','','United States Of America',840,'America/New_York'),(56654,'Роанок','Roanoke','','United States Of America',840,'America/New_York'),(63305,'Роанок','Roanoke','','United States Of America',840,'America/New_York'),(64173,'Роанок','Roanoke','','United States Of America',840,'America/New_York'),(66250,'Роанок','Roanoke','','United States Of America',840,'America/New_York'),(62234,'Робертс','Roberts','','United States Of America',840,'America/Chicago'),(63307,'Робертс','Roberts','','United States Of America',840,'America/Chicago'),(71268,'Робертс','Roberts','','United States Of America',840,'America/Chicago'),(63308,'Робинсон','Robinson','','United States Of America',840,'America/Chicago'),(64861,'Робинсон','Robinson','','United States Of America',840,'America/Chicago'),(75664,'Робинсон','Robinson','','United States Of America',840,'America/Chicago'),(79253,'Робинсон','Robinson','','United States Of America',840,'America/Chicago'),(58835,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(59589,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(65652,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(69368,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(71777,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(73121,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(75666,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(76598,'Роджерс','Rogers','','United States Of America',840,'America/Chicago'),(61790,'Родос','Rhodes','','United States Of America',840,'Europe/Paris'),(68515,'Родос','Rhodes','','United States Of America',840,'Europe/Paris'),(71779,'Роза','Rose','','United States Of America',840,'Europe/Sofia'),(74476,'Роза','Rose','','United States Of America',840,'Europe/Sofia'),(77322,'Роза','Rose','','United States Of America',840,'Europe/Sofia'),(69373,'Розо','Roseau','','United States Of America',840,'America/Chicago'),(71275,'Рой','Roy','','United States Of America',840,'America/New_York'),(73124,'Рой','Roy','','United States Of America',840,'America/New_York'),(77318,'Рокки','Rocky','','United States Of America',840,'America/Montreal'),(59315,'Ромео','Romeo','','United States Of America',840,'America/Detroit'),(68535,'Ромео','Romeo','','United States Of America',840,'America/Detroit'),(75173,'Ронда','Ronda','','United States Of America',840,'Europe/Madrid'),(61813,'Роули','Rowley','','United States Of America',840,'America/New_York'),(67648,'Роули','Rowley','','United States Of America',840,'America/New_York'),(67642,'Рочдейл','Rochdale','','United States Of America',840,'Europe/London'),(63310,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(64174,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(65646,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(67643,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(68526,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(69364,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(72205,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(74460,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(79254,'Рочестер','Rochester','','United States Of America',840,'America/Chicago'),(56971,'Рузвельт','Roosevelt','','United States Of America',840,'America/Denver'),(69370,'Рузвельт','Roosevelt','','United States Of America',840,'America/Denver'),(72726,'Рузвельт','Roosevelt','','United States Of America',840,'America/Denver'),(74473,'Рузвельт','Roosevelt','','United States Of America',840,'America/Denver'),(77321,'Рузвельт','Roosevelt','','United States Of America',840,'America/Denver'),(60835,'Саванна','Savannah','','United States Of America',840,'America/New_York'),(63354,'Саванна','Savanna','','United States Of America',840,'America/Chicago'),(70814,'Саванна','Savannah','','United States Of America',840,'America/New_York'),(74519,'Саванна','Savannah','','United States Of America',840,'America/New_York'),(76629,'Саванна','Savannah','','United States Of America',840,'America/New_York'),(77333,'Саванна','Savanna','','United States Of America',840,'America/Chicago'),(74520,'Савона','Savona','','United States Of America',840,'Europe/Rome'),(68124,'Сад','Garden','','United States Of America',840,'America/Denver'),(67707,'Садбери','Sudbury','','United States Of America',840,'America/Toronto'),(62219,'Сайда','Pollock','','United States Of America',840,'America/Chicago'),(66229,'Сайда','Pollock','','United States Of America',840,'America/Chicago'),(70720,'Сайда','Pollock','','United States Of America',840,'America/Chicago'),(58036,'Сакраменто','Sacramento','','United States Of America',840,'America/Los_Angeles'),(65664,'Сакраменто','Sacramento','','United States Of America',840,'America/Los_Angeles'),(73127,'Сакраменто','Sacramento','','United States Of America',840,'America/Los_Angeles'),(79281,'Сакраменто','Sacramento','','United States Of America',840,'America/Los_Angeles'),(74503,'Саламанка','Salamanca','','United States Of America',840,'Europe/Madrid'),(58041,'Салинас','Salinas','','United States Of America',840,'America/Los_Angeles'),(63442,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(64251,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(65740,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(66767,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(70866,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(72230,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(76700,'Салливан','Sullivan','','United States Of America',840,'America/New_York'),(69892,'Сальтильо','Saltillo','','United States Of America',840,'America/New_York'),(79300,'Сальтильо','Saltillo','','United States Of America',840,'America/New_York'),(58349,'Самора','Zamora','','United States Of America',840,'Europe/Madrid'),(60214,'Сан-Антонио','San Antonio','','United States Of America',840,'America/Chicago'),(73131,'Сан-Антонио','San Antonio','','United States Of America',840,'America/Chicago'),(58048,'Сан-Бернардино','San Bernardino','','United States Of America',840,'America/Los_Angeles'),(58049,'Сан-Бруно','San Bruno','','United States Of America',840,'America/Los_Angeles'),(58053,'Сан-Диего','San Diego','','United States Of America',840,'America/Los_Angeles'),(73132,'Сан-Кристобаль','San Cristobal','','United States Of America',840,'America/Bogota'),(56982,'Сан-Луис','San Luis','','United States Of America',840,'America/Argentina/San_Luis'),(59320,'Сан-Луис','San Luis','','United States Of America',840,'America/Argentina/San_Luis'),(58074,'Сан-Марино','San Marino','','United States Of America',840,'Europe/San_Marino'),(58080,'Сан-Педро','San Pedro','','United States Of America',840,'America/Asuncion'),(58058,'Сан-Франциско','San Francisco','','United States Of America',840,'America/Los_Angeles'),(74536,'Сан-Франциско','Sea Cliff','','United States Of America',840,'America/New_York'),(58064,'Сан-Хосе','San Jose','','United States Of America',840,'America/Los_Angeles'),(63350,'Сан-Хосе','San Jose','','United States Of America',840,'America/Los_Angeles'),(73135,'Сан-Хосе','San Jose','','United States Of America',840,'America/Los_Angeles'),(67233,'Сандерленд','Sunderland','','United States Of America',840,'Europe/London'),(67708,'Сандерленд','Sunderland','','United States Of America',840,'Europe/London'),(60212,'Санкт-Петербург','Saint Petersburg','','United States Of America',840,'Europe/Moscow'),(79292,'Санкт-Петербург','Saint Petersburg','','United States Of America',840,'Europe/Moscow'),(58088,'Санта-Барбара','Santa Barbara','','United States Of America',840,'America/Los_Angeles'),(58089,'Санта-Клара','Santa Clara','','United States Of America',840,'America/Los_Angeles'),(73144,'Санта-Клара','Santa Clara','','United States Of America',840,'America/Los_Angeles'),(77763,'Санта-Клара','Santa Clara','','United States Of America',840,'America/Los_Angeles'),(58091,'Санта-Крус','Santa Cruz','','United States Of America',840,'America/Argentina/Rio_Gallegos'),(73145,'Санта-Крус','Santa Cruz','','United States Of America',840,'America/Argentina/Rio_Gallegos'),(58095,'Санта-Моника','Santa Monica','','United States Of America',840,'America/Los_Angeles'),(58098,'Санта-Роза','Santa Rosa','','United States Of America',840,'America/Los_Angeles'),(73147,'Санта-Роза','Santa Rosa','','United States Of America',840,'America/Los_Angeles'),(70811,'Санта-Фе','Santa Fe','','United States Of America',840,'America/Argentina/Cordoba'),(73146,'Санта-Фе','Santa Fe','','United States Of America',840,'America/Argentina/Cordoba'),(69405,'Сантьяго','Santiago','','United States Of America',840,'America/Santiago'),(60220,'Сарасота','Sarasota','','United States Of America',840,'America/New_York'),(74515,'Саратога-Спрингс','Saratoga Springs','','United States Of America',840,'America/New_York'),(65680,'Саул','Saul','','United States Of America',840,'Europe/Luxembourg'),(67693,'Саутгемптон','Southampton','','United States Of America',840,'Europe/London'),(79405,'Саутгемптон','Southampton','','United States Of America',840,'Europe/London'),(58684,'Свет','Light','','United States Of America',840,'America/Chicago'),(80035,'Север','North','','United States Of America',840,'America/New_York'),(67209,'Северн','Severn','','United States Of America',840,'America/New_York'),(75209,'Северн','Severn','','United States Of America',840,'America/New_York'),(56087,'Северный полюс','North Pole','','United States Of America',840,'America/Anchorage'),(60228,'Севилья','Seville','','United States Of America',840,'Europe/Madrid'),(60842,'Севилья','Seville','','United States Of America',840,'Europe/Madrid'),(76639,'Севилья','Seville','','United States Of America',840,'Europe/Madrid'),(64887,'Седан','Sedan','','United States Of America',840,'Europe/Paris'),(73151,'Седан','Sedan','','United States Of America',840,'Europe/Paris'),(56665,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(58853,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(59591,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(60213,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(61831,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(63349,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(64198,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(65672,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(67654,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(68556,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(70809,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(71790,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(72210,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(72737,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(73129,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(74504,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(76621,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(77761,'Сейлем','Salem','','United States Of America',840,'Asia/Kolkata'),(68555,'Сен-Луи','Saint Louis','','United States Of America',840,'America/Chicago'),(70802,'Сен-Луи','Saint Louis','','United States Of America',840,'America/Chicago'),(77327,'Сен-Луи','Saint Louis','','United States Of America',840,'America/Chicago'),(56978,'Сент-Джонс','Saint Johns','','United States Of America',840,'America/St_Johns'),(68553,'Сент-Джонс','Saint Johns','','United States Of America',840,'America/St_Johns'),(76617,'Сент-Джонс','Saint Johns','','United States Of America',840,'America/St_Johns'),(79288,'Сент-Джонс','Saint Johns','','United States Of America',840,'America/St_Johns'),(66703,'Сент-Олбанс','Saint Albans','','United States Of America',840,'Europe/London'),(70795,'Сент-Олбанс','Saint Albans','','United States Of America',840,'Europe/London'),(74498,'Сент-Олбанс','Saint Albans','','United States Of America',840,'Europe/London'),(64252,'Сера','Sulphur','','United States Of America',840,'America/Chicago'),(65741,'Сера','Sulphur','','United States Of America',840,'America/Chicago'),(66301,'Сера','Sulphur','','United States Of America',840,'America/Chicago'),(77372,'Сера','Sulphur','','United States Of America',840,'America/Chicago'),(61203,'Сидар-Рапидс','Cedar Rapids','','United States Of America',840,'America/Chicago'),(71452,'Сидар-Рапидс','Cedar Rapids','','United States Of America',840,'America/Chicago'),(60256,'Сидней','Sydney','','United States Of America',840,'Australia/Sydney'),(56685,'Сила','Silas','','United States Of America',840,'America/Chicago'),(78414,'Сила','Force','','United States Of America',840,'Europe/Paris'),(63395,'Симпсон','Simpson','','United States Of America',840,'America/Chicago'),(64897,'Симпсон','Simpson','','United States Of America',840,'America/Chicago'),(66284,'Симпсон','Simpson','','United States Of America',840,'America/Chicago'),(75219,'Симпсон','Simpson','','United States Of America',840,'America/Chicago'),(74186,'Синай','Mount Sinai','','United States Of America',840,'Africa/Cairo'),(63605,'Сион','Zion','','United States Of America',840,'America/New_York'),(64260,'Сиракузы','Syracuse','','United States Of America',840,'America/New_York'),(64919,'Сиракузы','Syracuse','','United States Of America',840,'America/New_York'),(70872,'Сиракузы','Syracuse','','United States Of America',840,'America/New_York'),(71834,'Сиракузы','Syracuse','','United States Of America',840,'America/New_York'),(76710,'Сиракузы','Syracuse','','United States Of America',840,'America/New_York'),(66712,'Скарборо','Scarborough','','United States Of America',840,'Europe/London'),(58856,'Скотт','Scott','','United States Of America',840,'America/Chicago'),(66275,'Скотт','Scott','','United States Of America',840,'America/Chicago'),(69904,'Скотт','Scott','','United States Of America',840,'America/Chicago'),(76632,'Скотт','Scott','','United States Of America',840,'America/Chicago'),(58857,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(61837,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(64886,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(75201,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(75682,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(79321,'Скрентон','Scranton','','United States Of America',840,'America/New_York'),(65708,'Смит','Smith','','United States Of America',840,'America/Chicago'),(71984,'Смит','Smith','','United States Of America',840,'America/Chicago'),(77349,'Снег','Snow','','United States Of America',840,'America/Denver'),(62067,'Совет','Council','','United States Of America',840,'America/Boise'),(74744,'Совет','Council','','United States Of America',840,'America/Boise'),(61863,'Солдат','Soldier','','United States Of America',840,'America/Chicago'),(64899,'Солдат','Soldier','','United States Of America',840,'America/Chicago'),(65713,'Солдат','Soldier','','United States Of America',840,'America/Chicago'),(61864,'Солон','Solon','','United States Of America',840,'America/New_York'),(66734,'Солон','Solon','','United States Of America',840,'America/New_York'),(76661,'Солон','Solon','','United States Of America',840,'America/New_York'),(59592,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(67204,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(67655,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(70810,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(72211,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(75188,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(79297,'Солсбери','Salisbury','','United States Of America',840,'Africa/Harare'),(58145,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(59340,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(64229,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(65714,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(67673,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(68593,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(72756,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(76663,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(79394,'Сомерсет','Somerset','','United States Of America',840,'America/New_York'),(60235,'Сорренто','Sorrento','','United States Of America',840,'Europe/Rome'),(66291,'Сорренто','Sorrento','','United States Of America',840,'Europe/Rome'),(66735,'Сорренто','Sorrento','','United States Of America',840,'Europe/Rome'),(75228,'София','Sophia','','United States Of America',840,'Europe/Sofia'),(60859,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(63412,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(65721,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(68604,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(70842,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(72766,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(75234,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(76674,'Спарта','Sparta','','United States Of America',840,'America/Chicago'),(61868,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(62256,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(64235,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(67698,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(71811,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(75236,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(76675,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(77356,'Спенсер','Spencer','','United States Of America',840,'America/Chicago'),(70844,'Спокан','Spokane','','United States Of America',840,'America/Los_Angeles'),(58873,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(59342,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(60860,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(62258,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(63417,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(65723,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(66294,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(66749,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(67699,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(69438,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(70845,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(71813,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(72224,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(72769,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(76679,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(77788,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(79426,'Спрингфилд','Springfield','','United States Of America',840,'America/New_York'),(60242,'Старк','Starke','','United States Of America',840,'America/Indiana/Knox'),(64907,'Старк','Stark','','United States Of America',840,'America/New_York'),(72774,'Стерлинг','Stirling','','United States Of America',840,'Europe/London'),(79441,'Стивенс','Stevens','','United States Of America',840,'America/Chicago'),(66759,'Стокгольм','Stockholm','','United States Of America',840,'Europe/Stockholm'),(72775,'Стокгольм','Stockholm','','United States Of America',840,'Europe/Stockholm'),(60869,'Стоун-Маунтин','Stone Mountain','','United States Of America',840,'America/New_York'),(76695,'Стронгсвилл','Strongsville','','United States Of America',840,'America/New_York'),(61877,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(62260,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(65728,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(73163,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(75244,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(75694,'Стэнли','Stanley','','United States Of America',840,'America/Chicago'),(71306,'Сула','Sula','','United States Of America',840,'Europe/Oslo'),(75702,'Суррей','Surrey','','United States Of America',840,'America/Vancouver'),(65330,'Счастье','Happy','','United States Of America',840,'America/Chicago'),(61901,'Табор','Tabor','','United States Of America',840,'America/Chicago'),(58904,'Такер','Tucker','','United States Of America',840,'America/New_York'),(60905,'Такер','Tucker','','United States Of America',840,'America/New_York'),(57011,'Такна','Tacna','','United States Of America',840,'America/Lima'),(60257,'Таллахасси','Tallahassee','','United States Of America',840,'America/New_York'),(77394,'Талса','Tulsa','','United States Of America',840,'America/Chicago'),(61902,'Тама','Tama','','United States Of America',840,'America/Chicago'),(60260,'Тампа','Tampa','','United States Of America',840,'America/New_York'),(64921,'Тампа','Tampa','','United States Of America',840,'America/New_York'),(63452,'Тампико','Tampico','','United States Of America',840,'America/Chicago'),(75285,'Таунсвилл','Townsville','','United States Of America',840,'Australia/Brisbane'),(57651,'Тахо','Lake Tahoe','','United States Of America',840,'America/Los_Angeles'),(57012,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(58892,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(66310,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(68625,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(69943,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(70876,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(71837,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(75706,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(79488,'Тейлор','Taylor','','United States Of America',840,'America/New_York'),(64922,'Текумсе','Tecumseh','','United States Of America',840,'America/Chicago'),(68626,'Текумсе','Tecumseh','','United States Of America',840,'America/Chicago'),(70878,'Текумсе','Tecumseh','','United States Of America',840,'America/Chicago'),(71838,'Текумсе','Tecumseh','','United States Of America',840,'America/Chicago'),(77381,'Текумсе','Tecumseh','','United States Of America',840,'America/Chicago'),(69946,'Терри','Terry','','United States Of America',840,'America/Chicago'),(71313,'Терри','Terry','','United States Of America',840,'America/Chicago'),(60898,'Тигр','Tiger','','United States Of America',840,'America/Chicago'),(56159,'Ток','Tok','','United States Of America',840,'Europe/Budapest'),(61919,'Толедо','Toledo','','United States Of America',840,'America/New_York'),(63472,'Толедо','Toledo','','United States Of America',840,'America/New_York'),(76724,'Толедо','Toledo','','United States Of America',840,'America/New_York'),(77809,'Толедо','Toledo','','United States Of America',840,'America/New_York'),(65758,'Томагавк','Tomahawk','','United States Of America',840,'America/Chicago'),(59629,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(61908,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(70882,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(75707,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(76715,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(79495,'Томпсон','Thompson','','United States Of America',840,'America/Winnipeg'),(67712,'Тонтон','Taunton','','United States Of America',840,'Europe/London'),(69463,'Тонтон','Taunton','','United States Of America',840,'Europe/London'),(63476,'Топика','Topeka','','United States Of America',840,'America/Chicago'),(64273,'Топика','Topeka','','United States Of America',840,'America/Chicago'),(64927,'Топика','Topeka','','United States Of America',840,'America/Chicago'),(71248,'Тополь','Poplar','','United States Of America',840,'Europe/London'),(61909,'Тор','Thor','','United States Of America',840,'Europe/Paris'),(64929,'Торонто','Toronto','','United States Of America',840,'America/Toronto'),(76728,'Торонто','Toronto','','United States Of America',840,'America/Toronto'),(73181,'Торреон','Torreon','','United States Of America',840,'America/Monterrey'),(58228,'Трейси','Tracy','','United States Of America',840,'America/Los_Angeles'),(61920,'Трейси','Tracy','','United States Of America',840,'America/Los_Angeles'),(69470,'Трейси','Tracy','','United States Of America',840,'America/Los_Angeles'),(58233,'Тринидад','Trinidad','','United States Of America',840,'America/Denver'),(59360,'Тринидад','Trinidad','','United States Of America',840,'America/Denver'),(61923,'Триполи','Tripoli','','United States Of America',840,'Africa/Tripoli'),(56729,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(62276,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(63486,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(64275,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(64933,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(66780,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(68641,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(70361,'Троя','Golden City','','United States Of America',840,'America/Chicago'),(70892,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(71321,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(72238,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(75290,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(76733,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(79526,'Троя','Troy','','United States Of America',840,'Europe/Istanbul'),(61926,'Труро','Truro','','United States Of America',840,'Europe/London'),(67719,'Труро','Truro','','United States Of America',840,'Europe/London'),(69960,'Тула','Tula','','United States Of America',840,'Europe/Moscow'),(63477,'Тулон','Toulon','','United States Of America',840,'Europe/Paris'),(62069,'Тупик','Culdesac','','United States Of America',840,'America/Los_Angeles'),(60907,'Турин','Turin','','United States Of America',840,'Europe/Rome'),(61927,'Турин','Turin','','United States Of America',840,'Europe/Rome'),(57028,'Тусон','Tucson','','United States Of America',840,'America/Phoenix'),(68697,'Уайтхолл','Whitehall','','United States Of America',840,'Europe/London'),(71339,'Уайтхолл','Whitehall','','United States Of America',840,'Europe/London'),(76816,'Уайтхолл','Whitehall','','United States Of America',840,'Europe/London'),(79650,'Уайтхолл','Whitehall','','United States Of America',840,'Europe/London'),(79659,'Уилкс-Барре','Wilkes Barre','','United States Of America',840,'America/New_York'),(58319,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(59728,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(63574,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(67789,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(75347,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(76831,'Уилмингтон','Wilmington','','United States Of America',840,'America/New_York'),(58957,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(64982,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(66345,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(68704,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(75348,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(77444,'Уилсон','Wilson','','United States Of America',840,'America/Chicago'),(57045,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(58315,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(61994,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(64332,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(69533,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(77845,'Уильямс','Williams','','United States Of America',840,'America/Chicago'),(57049,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(58960,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(63581,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(64340,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(71890,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(72844,'Уинслоу','Winslow','','United States Of America',840,'America/Phoenix'),(71882,'Уитни','Whitney','','United States Of America',840,'America/Chicago'),(79652,'Уитни','Whitney','','United States Of America',840,'America/Chicago'),(63562,'Уитон','Wheaton','','United States Of America',840,'America/Chicago'),(64971,'Уитон','Wheaton','','United States Of America',840,'America/Chicago'),(69529,'Уитон','Wheaton','','United States Of America',840,'America/Chicago'),(70956,'Уитон','Wheaton','','United States Of America',840,'America/Chicago'),(64976,'Уичита','Wichita','','United States Of America',840,'America/Chicago'),(58912,'Ульм','Ulm','','United States Of America',840,'America/Denver'),(71325,'Ульм','Ulm','','United States Of America',840,'America/Denver'),(61952,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(64952,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(65788,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(66334,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(69502,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(70926,'Уокер','Walker','','United States Of America',840,'America/Chicago'),(56756,'Уорд','Ward','','United States Of America',840,'America/Chicago'),(58932,'Уорд','Ward','','United States Of America',840,'America/Chicago'),(59374,'Уорд','Ward','','United States Of America',840,'America/Chicago'),(60935,'Уорик','Warwick','','United States Of America',840,'Europe/London'),(67261,'Уорик','Warwick','','United States Of America',840,'Europe/London'),(67736,'Уорик','Warwick','','United States Of America',840,'Europe/London'),(75729,'Уорик','Warwick','','United States Of America',840,'Europe/London'),(79776,'Уорик','Warwick','','United States Of America',840,'Europe/London'),(59641,'Уотербери','Waterbury','','United States Of America',840,'America/New_York'),(71867,'Уотербери','Waterbury','','United States Of America',840,'America/New_York'),(58287,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(59642,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(66797,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(68674,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(69985,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(76776,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(79597,'Уотерфорд','Waterford','','United States Of America',840,'Europe/Dublin'),(56759,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(58936,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(63538,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(66337,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(69517,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(70937,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(77424,'Уотсон','Watson','','United States Of America',840,'America/Chicago'),(60926,'Уэйко','Waco','','United States Of America',840,'America/Chicago'),(65786,'Уэйко','Waco','','United States Of America',840,'America/Chicago'),(70923,'Уэйко','Waco','','United States Of America',840,'America/Chicago'),(71860,'Уэйко','Waco','','United States Of America',840,'America/Chicago'),(75307,'Уэйко','Waco','','United States Of America',840,'America/Chicago'),(63542,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(66799,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(68680,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(71872,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(72820,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(76783,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(77428,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(79603,'Уэйн','Wayne','','United States Of America',840,'America/New_York'),(66801,'Уэллс','Wells','','United States Of America',840,'America/Chicago'),(68683,'Уэллс','Wells','','United States Of America',840,'America/Chicago'),(69524,'Уэллс','Wells','','United States Of America',840,'America/Chicago'),(71999,'Уэллс','Wells','','United States Of America',840,'America/Chicago'),(60296,'Уэст-Палм-Бич','West Palm Beach','','United States Of America',840,'America/New_York'),(64542,'Фалун','Falun','','United States Of America',840,'Europe/Stockholm'),(56947,'Феникс','Phoenix','','United States Of America',840,'America/Phoenix'),(67158,'Феникс','Phoenix','','United States Of America',840,'America/Phoenix'),(74353,'Феникс','Phoenix','','United States Of America',840,'America/Phoenix'),(77726,'Феникс','Phoenix','','United States Of America',840,'America/Phoenix'),(61364,'Фергюсон','Ferguson','','United States Of America',840,'America/New_York'),(65252,'Фергюсон','Ferguson','','United States Of America',840,'America/New_York'),(70309,'Фергюсон','Ferguson','','United States Of America',840,'America/New_York'),(74821,'Фергюсон','Ferguson','','United States Of America',840,'America/New_York'),(63462,'Фивы','Thebes','','United States Of America',840,'America/Chicago'),(69851,'Филадельфия','Philadelphia','','United States Of America',840,'America/New_York'),(70702,'Филадельфия','Philadelphia','','United States Of America',840,'America/New_York'),(74349,'Филадельфия','Philadelphia','','United States Of America',840,'America/New_York'),(79136,'Филадельфия','Philadelphia','','United States Of America',840,'America/New_York'),(66673,'Филлипс','Phillips','','United States Of America',840,'America/Denver'),(71748,'Филлипс','Phillips','','United States Of America',840,'America/Denver'),(59109,'Флеминг','Fleming','','United States Of America',840,'America/New_York'),(60537,'Флеминг','Fleming','','United States Of America',840,'America/New_York'),(76074,'Флеминг','Fleming','','United States Of America',840,'America/New_York'),(78405,'Флеминг','Fleming','','United States Of America',840,'America/New_York'),(68985,'Фленсбург','Flensburg','','United States Of America',840,'Europe/Berlin'),(62709,'Флора','Flora','','United States Of America',840,'Europe/Oslo'),(63809,'Флора','Flora','','United States Of America',840,'Europe/Oslo'),(66008,'Флора','Flora','','United States Of America',840,'Europe/Oslo'),(69682,'Флора','Flora','','United States Of America',840,'Europe/Oslo'),(56386,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(56849,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(59110,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(63810,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(64544,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(65263,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(67431,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(69683,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(70316,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(71098,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(72427,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(77577,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(79897,'Флоренция','Florence','','United States Of America',840,'Europe/Rome'),(73723,'Флорида','Florida','','United States Of America',840,'America/New_York'),(64541,'Фолл-Ривер','Fall River','','United States Of America',840,'America/New_York'),(67425,'Фолл-Ривер','Fall River','','United States Of America',840,'America/New_York'),(57445,'Фолсом','Folsom','','United States Of America',840,'America/Los_Angeles'),(66011,'Фолсом','Folsom','','United States Of America',840,'America/Los_Angeles'),(72969,'Фолсом','Folsom','','United States Of America',840,'America/Los_Angeles'),(78411,'Фолсом','Folsom','','United States Of America',840,'America/Los_Angeles'),(59118,'Фонтан','Fountain','','United States Of America',840,'America/Indiana/Indianapolis'),(59905,'Фонтан','Fountain','','United States Of America',840,'America/Indiana/Indianapolis'),(68104,'Фонтан','Fountain','','United States Of America',840,'America/Indiana/Indianapolis'),(68994,'Фонтан','Fountain','','United States Of America',840,'America/Indiana/Indianapolis'),(74829,'Фонтан','Fountain','','United States Of America',840,'America/Indiana/Indianapolis'),(57446,'Фонтана','Fontana','','United States Of America',840,'America/Los_Angeles'),(64545,'Фонтана','Fontana','','United States Of America',840,'America/Los_Angeles'),(57460,'Фортуна','Fortuna','','United States Of America',840,'Europe/Madrid'),(70324,'Фортуна','Fortuna','','United States Of America',840,'Europe/Madrid'),(75494,'Фортуна','Fortuna','','United States Of America',840,'Europe/Madrid'),(65272,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(70325,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(71547,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(77058,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(77582,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(79733,'Фостер','Foster','','United States Of America',840,'America/Chicago'),(56397,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(58551,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(60552,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(62099,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(62724,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(63826,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(64555,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(65277,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(66016,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(66502,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(67435,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(68109,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(68996,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(70327,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(71548,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(72084,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(72434,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(73740,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(74831,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(76084,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(78429,'Франклин','Franklin','','United States Of America',840,'America/Chicago'),(72083,'Франкония','Franconia','','United States Of America',840,'America/New_York'),(78428,'Франкония','Franconia','','United States Of America',840,'America/New_York'),(59122,'Фредерик','Frederick','','United States Of America',840,'America/New_York'),(62727,'Фредерик','Frederick','','United States Of America',840,'America/New_York'),(67002,'Фредерик','Frederick','','United States Of America',840,'America/New_York'),(77062,'Фредерик','Frederick','','United States Of America',840,'America/New_York'),(78431,'Фредерик','Frederick','','United States Of America',840,'America/New_York'),(57469,'Фресно','Fresno','','United States Of America',840,'America/Los_Angeles'),(76091,'Фресно','Fresno','','United States Of America',840,'America/Los_Angeles'),(63831,'Фритаун','Freetown','','United States Of America',840,'Africa/Freetown'),(56402,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(57472,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(58554,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(62731,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(63836,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(64559,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(65281,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(67008,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(68118,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(69688,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(70336,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(73753,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(76093,'Фултон','Fulton','','United States Of America',840,'America/Chicago'),(63835,'Фульда','Fulda','','United States Of America',840,'Europe/Berlin'),(69003,'Фульда','Fulda','','United States Of America',840,'Europe/Berlin'),(56404,'Фурман','Furman','','United States Of America',840,'America/New_York'),(79904,'Фурман','Furman','','United States Of America',840,'America/New_York'),(78612,'Хайд','Hyde','','United States Of America',840,'America/Chicago'),(65347,'Хайдельберг','Heidelberg','','United States Of America',840,'Europe/Berlin'),(69714,'Хайдельберг','Heidelberg','','United States Of America',840,'Europe/Berlin'),(57547,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(62836,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(63892,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(64617,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(67048,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(68195,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(72487,'Хайленд','Highlands','','United States Of America',840,'America/New_York'),(73876,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(74902,'Хайленд','Highlands','','United States Of America',840,'America/New_York'),(76170,'Хайленд','Highland','','United States Of America',840,'Europe/London'),(77873,'Халеб','Aleppo','','United States Of America',840,'Asia/Damascus'),(60608,'Халл','Hull','','United States Of America',840,'America/New_York'),(61469,'Халл','Hull','','United States Of America',840,'America/New_York'),(62860,'Халл','Hull','','United States Of America',840,'America/New_York'),(67479,'Халл','Hull','','United States Of America',840,'America/New_York'),(73919,'Хант','Hunt','','United States Of America',840,'America/Chicago'),(56474,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(58637,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(62864,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(65377,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(70444,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(76193,'Хантсвилл','Huntsville','','United States Of America',840,'America/Chicago'),(58601,'Харви','Harvey','','United States Of America',840,'America/Chicago'),(61443,'Харви','Harvey','','United States Of America',840,'America/Chicago'),(62817,'Харви','Harvey','','United States Of America',840,'America/Chicago'),(66061,'Харви','Harvey','','United States Of America',840,'America/Chicago'),(75529,'Харви','Harvey','','United States Of America',840,'America/Chicago'),(61437,'Харпер','Harper','','United States Of America',840,'America/Chicago'),(64601,'Харпер','Harper','','United States Of America',840,'America/Chicago'),(77608,'Харпер','Harper','','United States Of America',840,'America/Chicago'),(61439,'Харрис','Harris','','United States Of America',840,'America/New_York'),(68174,'Харрис','Harris','','United States Of America',840,'America/New_York'),(69057,'Харрис','Harris','','United States Of America',840,'America/New_York'),(70398,'Харрис','Harris','','United States Of America',840,'America/New_York'),(73851,'Харрис','Harris','','United States Of America',840,'America/New_York'),(74883,'Харрис','Harris','','United States Of America',840,'America/New_York'),(68179,'Харт','Hart','','United States Of America',840,'America/New_York'),(56447,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(58599,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(59492,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(61440,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(62813,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(64602,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(65341,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(68180,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(73854,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(76157,'Хартфорд','Hartford','','United States Of America',840,'America/New_York'),(59495,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(62821,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(63887,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(65346,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(66532,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(67044,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(71589,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(72112,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(75535,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(76166,'Хеврон','Hebron','','United States Of America',840,'Asia/Gaza'),(58612,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(59157,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(61452,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(62823,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(65351,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(67046,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(68187,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(69065,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(71591,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(71939,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(73866,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(74892,'Хендерсон','Henderson','','United States Of America',840,'America/Chicago'),(56878,'Херефорд','Hereford','','United States Of America',840,'Europe/London'),(59158,'Херефорд','Hereford','','United States Of America',840,'Europe/London'),(77613,'Херефорд','Hereford','','United States Of America',840,'Europe/London'),(78561,'Херефорд','Hereford','','United States Of America',840,'Europe/London'),(60988,'Хило','Hilo','','United States Of America',840,'Pacific/Honolulu'),(73883,'Хилтон','Hilton','','United States Of America',840,'America/Chicago'),(79939,'Хилтон-Хед-Айленд','Hilton Head Island','','United States Of America',840,'America/New_York'),(63897,'Хобарт','Hobart','','United States Of America',840,'America/Chicago'),(73887,'Хобарт','Hobart','','United States Of America',840,'America/Chicago'),(77112,'Хобарт','Hobart','','United States Of America',840,'America/Chicago'),(61455,'Холм','Hills','','United States Of America',840,'America/Chicago'),(69076,'Холм','Hills','','United States Of America',840,'America/Chicago'),(72114,'Холм','Hill','','United States Of America',840,'America/Denver'),(73897,'Холмс','Holmes','','United States Of America',840,'America/New_York'),(78583,'Холмс','Holmes','','United States Of America',840,'America/New_York'),(68206,'Хопкинс','Hopkins','','United States Of America',840,'America/Chicago'),(69090,'Хопкинс','Hopkins','','United States Of America',840,'America/Chicago'),(70432,'Хопкинс','Hopkins','','United States Of America',840,'America/Chicago'),(79944,'Хопкинс','Hopkins','','United States Of America',840,'America/Chicago'),(56019,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(56472,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(58629,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(59699,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(69091,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(69727,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(70436,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(76187,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(78599,'Хьюстон','Houston','','United States Of America',840,'America/Chicago'),(56279,'Центр','Centre','','United States Of America',840,'Europe/Paris'),(59033,'Центр','Center','','United States Of America',840,'Europe/Paris'),(65128,'Центр','Center','','United States Of America',840,'Europe/Paris'),(70164,'Центр','Center','','United States Of America',840,'Europe/Paris'),(71453,'Центр','Center','','United States Of America',840,'Europe/Paris'),(75430,'Центр','Center','','United States Of America',840,'Europe/Paris'),(72103,'Цех','Guild','','United States Of America',840,'America/New_York'),(61219,'Цинциннати','Cincinnati','','United States Of America',840,'America/New_York'),(75946,'Цинциннати','Cincinnati','','United States Of America',840,'America/New_York'),(71358,'Цюрих','Zurich','','United States Of America',840,'Europe/Zurich'),(59431,'Чаплин','Chaplin','','United States Of America',840,'America/New_York'),(65132,'Чаплин','Chaplin','','United States Of America',840,'America/New_York'),(58454,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(62506,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(66432,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(69621,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(70172,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(79834,'Чарлстон','Charleston','','United States Of America',840,'America/New_York'),(62507,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(65933,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(67365,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(67967,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(69623,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(72353,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(73470,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(78118,'Чатем','Chatham','','United States Of America',840,'America/New_York'),(76957,'Чаттануга','Chattanooga','','United States Of America',840,'America/New_York'),(56284,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(61214,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(67367,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(67969,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(73475,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(76959,'Челси','Chelsea','','United States Of America',840,'Europe/London'),(57269,'Честер','Chester','','United States Of America',840,'Europe/London'),(58458,'Честер','Chester','','United States Of America',840,'Europe/London'),(59433,'Честер','Chester','','United States Of America',840,'Europe/London'),(60429,'Честер','Chester','','United States Of America',840,'Europe/London'),(61216,'Честер','Chester','','United States Of America',840,'Europe/London'),(62054,'Честер','Chester','','United States Of America',840,'Europe/London'),(62513,'Честер','Chester','','United States Of America',840,'Europe/London'),(66922,'Честер','Chester','','United States Of America',840,'Europe/London'),(67370,'Честер','Chester','','United States Of America',840,'Europe/London'),(71043,'Честер','Chester','','United States Of America',840,'Europe/London'),(71461,'Честер','Chester','','United States Of America',840,'Europe/London'),(72044,'Честер','Chester','','United States Of America',840,'Europe/London'),(72356,'Честер','Chester','','United States Of America',840,'Europe/London'),(73482,'Честер','Chester','','United States Of America',840,'Europe/London'),(75937,'Честер','Chester','','United States Of America',840,'Europe/London'),(76961,'Честер','Chester','','United States Of America',840,'Europe/London'),(78123,'Честер','Chester','','United States Of America',840,'Europe/London'),(79838,'Честер','Chester','','United States Of America',840,'Europe/London'),(59432,'Чешир','Cheshire','','United States Of America',840,'America/New_York'),(67369,'Чешир','Cheshire','','United States Of America',840,'America/New_York'),(75936,'Чешир','Cheshire','','United States Of America',840,'America/New_York'),(77516,'Чешир','Cheshire','','United States Of America',840,'America/New_York'),(62517,'Чикаго','Chicago','','United States Of America',840,'America/Chicago'),(72046,'Чичестер','Chichester','','United States Of America',840,'Europe/London'),(73484,'Чичестер','Chichester','','United States Of America',840,'Europe/London'),(65522,'Чудо','Miracle','','United States Of America',840,'America/New_York'),(57279,'Чула-Виста','Chula Vista','','United States Of America',840,'America/Los_Angeles'),(78117,'Шарлеруа','Charleroi','','United States Of America',840,'Europe/Brussels'),(58455,'Шарлотт','Charlotte','','United States Of America',840,'America/New_York'),(61211,'Шарлотт','Charlotte','','United States Of America',840,'America/New_York'),(67964,'Шарлотт','Charlotte','','United States Of America',840,'America/New_York'),(73466,'Шарлотт','Charlotte','','United States Of America',840,'America/New_York'),(74706,'Шарлотт','Charlotte','','United States Of America',840,'America/New_York'),(63712,'Шарлоттсвилл','Charlottesville','','United States Of America',840,'America/New_York'),(56680,'Шеннон','Shannon','','United States Of America',840,'America/Chicago'),(60844,'Шеннон','Shannon','','United States Of America',840,'America/Chicago'),(63375,'Шеннон','Shannon','','United States Of America',840,'America/Chicago'),(69908,'Шеннон','Shannon','','United States Of America',840,'America/Chicago'),(75211,'Шеннон','Shannon','','United States Of America',840,'America/Chicago'),(58862,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(67214,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(68581,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(75687,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(76652,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(77778,'Шервуд','Sherwood','','United States Of America',840,'America/Chicago'),(58121,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(58860,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(63381,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(64220,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(66724,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(68580,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(70828,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(71294,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(74549,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(77777,'Шеридан','Sheridan','','United States Of America',840,'America/Denver'),(59598,'Шерман','Sherman','','United States Of America',840,'America/Los_Angeles'),(63382,'Шерман','Sherman','','United States Of America',840,'America/Los_Angeles'),(69913,'Шерман','Sherman','','United States Of America',840,'America/Los_Angeles'),(74550,'Шерман','Sherman','','United States Of America',840,'America/Los_Angeles'),(69417,'Шефер','Shafer','','United States Of America',840,'America/Chicago'),(56681,'Шеффилд','Sheffield','','United States Of America',840,'America/Chicago'),(61845,'Шеффилд','Sheffield','','United States Of America',840,'America/Chicago'),(63378,'Шеффилд','Sheffield','','United States Of America',840,'America/Chicago'),(67664,'Шеффилд','Sheffield','','United States Of America',840,'America/Chicago'),(79348,'Шеффилд','Sheffield','','United States Of America',840,'America/Chicago'),(58863,'Ширли','Shirley','','United States Of America',840,'America/Chicago'),(63386,'Ширли','Shirley','','United States Of America',840,'America/Chicago'),(64222,'Ширли','Shirley','','United States Of America',840,'America/Chicago'),(67668,'Ширли','Shirley','','United States Of America',840,'America/Chicago'),(74553,'Ширли','Shirley','','United States Of America',840,'America/Chicago'),(61836,'Шлезвиг','Schleswig','','United States Of America',840,'America/Chicago'),(69910,'Шоу','Shaw','','United States Of America',840,'America/Chicago'),(66277,'Шривпорт','Shreveport','','United States Of America',840,'America/Chicago'),(67669,'Шрусбери','Shrewsbury','','United States Of America',840,'Europe/London'),(72751,'Шрусбери','Shrewsbury','','United States Of America',840,'Europe/London'),(79361,'Шрусбери','Shrewsbury','','United States Of America',840,'Europe/London'),(64245,'Штендаль','Stendal','','United States Of America',840,'Europe/Berlin'),(58883,'Штутгарт','Stuttgart','','United States Of America',840,'Europe/Berlin'),(64912,'Штутгарт','Stuttgart','','United States Of America',840,'Europe/Berlin'),(59104,'Эванс','Evans','','United States Of America',840,'America/New_York'),(60528,'Эванс','Evans','','United States Of America',840,'America/New_York'),(66000,'Эванс','Evans','','United States Of America',840,'America/New_York'),(58534,'Эвансвилл','Evansville','','United States Of America',840,'America/Denver'),(62686,'Эвансвилл','Evansville','','United States Of America',840,'America/Denver'),(63796,'Эвансвилл','Evansville','','United States Of America',840,'America/Denver'),(68967,'Эвансвилл','Evansville','','United States Of America',840,'America/Denver'),(67423,'Эверетт','Everett','','United States Of America',840,'America/Los_Angeles'),(78372,'Эверетт','Everett','','United States Of America',840,'America/Los_Angeles'),(57391,'Эдвардс','Edwards AFB','','United States Of America',840,'America/Los_Angeles'),(63783,'Эдинбург','Edinburgh','','United States Of America',840,'Europe/London'),(57389,'Эдисон','Edison','','United States Of America',840,'America/New_York'),(60514,'Эдисон','Edison','','United States Of America',840,'America/New_York'),(71517,'Эдисон','Edison','','United States Of America',840,'America/New_York'),(72401,'Эдисон','Edison','','United States Of America',840,'America/New_York'),(76046,'Эдисон','Edison','','United States Of America',840,'America/New_York'),(65214,'Эдмонтон','Edmonton','','United States Of America',840,'America/Edmonton'),(64515,'Эдсон','Edson','','United States Of America',840,'America/Edmonton'),(71390,'Эйр','Ayr','','United States Of America',840,'Europe/London'),(75387,'Эйр','Ayr','','United States Of America',840,'Europe/London'),(57423,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(66492,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(70293,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(71536,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(72079,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(79730,'Эксетер','Exeter','','United States Of America',840,'Europe/London'),(58523,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(59099,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(62657,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(63786,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(65986,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(68949,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(72404,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(78339,'Элизабет','Elizabeth','','United States Of America',840,'America/New_York'),(71528,'Элирия','Elyria','','United States Of America',840,'America/New_York'),(76053,'Элирия','Elyria','','United States Of America',840,'America/New_York'),(58521,'Эль-Пасо','El Paso','','United States Of America',840,'America/Denver'),(62650,'Эль-Пасо','El Paso','','United States Of America',840,'America/Denver'),(56357,'Эльба','Elba','','United States Of America',840,'America/New_York'),(62084,'Эльба','Elba','','United States Of America',840,'America/New_York'),(71518,'Эльба','Elba','','United States Of America',840,'America/New_York'),(73667,'Эльба','Elba','','United States Of America',840,'America/New_York'),(57395,'Эльдорадо','El Dorado','','United States Of America',840,'America/Bogota'),(58520,'Эльдорадо','El Dorado','','United States Of America',840,'America/Bogota'),(62653,'Эльдорадо','Eldorado','','United States Of America',840,'America/Chicago'),(64518,'Эльдорадо','El Dorado','','United States Of America',840,'America/Bogota'),(76048,'Эльдорадо','Eldorado','','United States Of America',840,'America/Chicago'),(77028,'Эльдорадо','Eldorado','','United States Of America',840,'America/Chicago'),(62674,'Эмден','Emden','','United States Of America',840,'America/Chicago'),(70278,'Эмден','Emden','','United States Of America',840,'America/Chicago'),(74800,'Энка','Enka','','United States Of America',840,'Europe/Minsk'),(67830,'Энн-Арбор','Ann Arbor','','United States Of America',840,'America/Detroit'),(57415,'Энсинитас','Encinitas','','United States Of America',840,'America/Los_Angeles'),(59468,'Энфилд','Enfield','','United States Of America',840,'America/New_York'),(62678,'Энфилд','Enfield','','United States Of America',840,'America/New_York'),(72073,'Энфилд','Enfield','','United States Of America',840,'America/New_York'),(74798,'Энфилд','Enfield','','United States Of America',840,'America/New_York'),(74806,'Эр','Eure','','United States Of America',840,'Europe/Paris'),(74780,'Эрл','Earl','','United States Of America',840,'America/Chicago'),(57420,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(59469,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(61348,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(62683,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(66987,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(67422,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(70282,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(71090,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(73692,'Эссекс','Essex','','United States Of America',840,'America/New_York'),(74607,'Эшвилл','Asheville','','United States Of America',840,'America/New_York'),(70980,'Юкон','Yukon','','United States Of America',840,'America/Whitehorse'),(77452,'Юкон','Yukon','','United States Of America',840,'America/Whitehorse'),(79706,'Юкон','Yukon','','United States Of America',840,'America/Whitehorse'),(59986,'Юпитер','Jupiter','','United States Of America',840,'America/New_York'),(61935,'Ют','Ute','','United States Of America',840,'Africa/Lagos'),(61484,'Ямайка','Jamaica','','United States Of America',840,'America/Jamaica'),(73943,'Ямайка','Jamaica','','United States Of America',840,'America/Jamaica'),(79957,'Яна','Joanna','','United States Of America',840,'America/New_York'),(57053,'Янг','Young','','United States Of America',840,'America/Chicago'),(60315,'Янгстаун','Youngstown','','United States Of America',840,'America/New_York'),(76850,'Янгстаун','Youngstown','','United States Of America',840,'America/New_York'),(79703,'Янгстаун','Youngstown','','United States Of America',840,'America/New_York'),(8118,'Бербера','Berbera','','Somalia',706,'Africa/Mogadishu'),(8122,'Кисмайо','Chisimaio','','Somalia',706,'Europe/Rome'),(8131,'Могадишо','Mogadiscio','','Somalia',706,'Africa/Mogadishu'),(8127,'Харгейса','Hargeisa','','Somalia',706,'Africa/Mogadishu'),(8303,'','Abu Na','','Sudan',736,'Africa/Cairo'),(8307,'Атбара','Atbara','','Sudan',736,'Africa/Khartoum'),(8338,'Вад-Медани','Wad Medani','','Sudan',736,'Africa/Khartoum'),(8340,'Вау','Wau','','Sudan',736,'Africa/Khartoum'),(8320,'Джуба','Juba','','Sudan',736,'Africa/Khartoum'),(8313,'Ель Обейд','El Obeid','','Sudan',736,'Asia/Damascus'),(8306,'Запах','Aroma','','Sudan',736,'Africa/Khartoum'),(8321,'Кадугли','Kadugli','','Sudan',736,'Africa/Khartoum'),(8323,'Кассала','Kassala','','Sudan',736,'Africa/Khartoum'),(8326,'Малакал','Malakal','','Sudan',736,'Pacific/Palau'),(8327,'Ньяла','Nyala','','Sudan',736,'America/Los_Angeles'),(8328,'Порт-Судан','Port Sudan','','Sudan',736,'Africa/Khartoum'),(8331,'Ренк','Renk','','Sudan',736,'Europe/Berlin'),(8332,'Сеннар','Sennar','','Sudan',736,'Africa/Khartoum'),(8336,'Токар','Tokar','','Sudan',736,'Africa/Lagos'),(8324,'Хартум','Khartoum','','Sudan',736,'Africa/Khartoum'),(8312,'Эль-Фашер','El Fasher','','Sudan',736,'Africa/Khartoum'),(8061,'Бо','Bo','','Sierra Leone',694,'America/La_Paz'),(8063,'Дару','Daru','','Sierra Leone',694,'Europe/Dublin'),(8064,'Кабала','Kabala','','Sierra Leone',694,'Europe/Athens'),(8066,'Макени','Makeni','','Sierra Leone',694,'Africa/Freetown'),(8591,'Душанбе','Dushanbe','','Tajikistan',762,'Asia/Dushanbe'),(8600,'Истаравшан','Ura-Tyube','','Tajikistan',762,'Asia/Dushanbe'),(8592,'Исфара','Isfara','','Tajikistan',762,'Asia/Dushanbe'),(8595,'Куляб','Kulob','','Tajikistan',762,'Asia/Dushanbe'),(8596,'Курган-Тюбе','Qurghonteppa','','Tajikistan',762,'Asia/Dushanbe'),(8597,'Пархар','Farkhar','','Tajikistan',762,'Asia/Kabul'),(8593,'Хорог','Khorugh','','Tajikistan',762,'Asia/Dushanbe'),(8594,'Худжанд','Khujand','','Tajikistan',762,'Asia/Dushanbe'),(108868,'Худжанд','Khudzhand','','Tajikistan',762,'Asia/Dushanbe'),(8599,'Шаартуз','Shaartuz','','Tajikistan',762,'Asia/Dushanbe'),(8603,'Бангкок','Bangkok','','Thailand',764,'Asia/Bangkok'),(8615,'Кам Паенг Пхет','Kam Paeng Phet','','Thailand',764,''),(8616,'Канчанабури','Kanchanaburi','','Thailand',764,'Asia/Bangkok'),(8623,'Краби','Krabi','','Thailand',764,'Asia/Bangkok'),(8619,'Кхонкэн','Khon Kaen','','Thailand',764,'Asia/Bangkok'),(8625,'Лампанг','Lampang','','Thailand',764,'Asia/Bangkok'),(8626,'Лампхун','Lamphun','','Thailand',764,'Asia/Bangkok'),(8627,'Лоэ','Loei','','Thailand',764,'Europe/Paris'),(8631,'Мае Сот','Mae Sot','','Thailand',764,'Asia/Bangkok'),(8629,'Мае Хонг Сон','Mae Hong Son','','Thailand',764,'Asia/Bangkok'),(8632,'Мукдахан','Mukdahan','','Thailand',764,'Asia/Bangkok'),(8601,'Накхон','Nakhon','','Thailand',764,'Asia/Bangkok'),(55813,'Накхонситхаммарат','Nakhon Si Thammarat','','Thailand',764,'Asia/Bangkok'),(8633,'Нан','Nan','','Thailand',764,'Pacific/Fiji'),(8634,'Наратхиват','Narathiwat','','Thailand',764,'Asia/Bangkok'),(8635,'Нонг-Кхай','Nong Khai','','Thailand',764,'Asia/Bangkok'),(8637,'Паттайя','Pattaya','','Thailand',764,'Asia/Bangkok'),(8644,'Прачин Бури','Prachin Buri','','Thailand',764,'Asia/Bangkok'),(8645,'Прачяп Кхирикхан','Prachuap Khirikhan','','Thailand',764,'Asia/Bangkok'),(8638,'Пхаяо','Phayao','','Thailand',764,'Asia/Bangkok'),(8640,'Пхетчабури','Phetchaburi','','Thailand',764,'Asia/Bangkok'),(8641,'Пхитсанулок','Phitsanulok','','Thailand',764,'Asia/Bangkok'),(8643,'Пхукет','Phuket','','Thailand',764,'Asia/Bangkok'),(115190,'Пхукет','Thalang','','Thailand',764,'Asia/Bangkok'),(8647,'Районг','Rayong','','Thailand',764,'Asia/Bangkok'),(8648,'Рой Ет','Roi Et','','Thailand',764,'Asia/Bangkok'),(8630,'Сае Сариянг','Mae Sariang','','Thailand',764,'Asia/Bangkok'),(8621,'Самуй','Ko Samui','','Thailand',764,'Asia/Bangkok'),(8652,'Сонгкхла','Songkhla','','Thailand',764,'Asia/Bangkok'),(8653,'Супхан Бури','Suphan Buri','','Thailand',764,'Asia/Bangkok'),(8654,'Сураттхани','Surat Thani','','Thailand',764,'Asia/Bangkok'),(8655,'Сурин','Surin','','Thailand',764,'Europe/Paris'),(8656,'Так','Tak','','Thailand',764,'Asia/Bangkok'),(8659,'Тханг Пха Пхум','Thong Pha Phum','','Thailand',764,'Asia/Bangkok'),(8661,'Убонратчатхани','Ubon Ratchathani','','Thailand',764,'Asia/Bangkok'),(8662,'Удонтхани','Udon Thani','','Thailand',764,'Asia/Bangkok'),(8613,'Хатъяй','Hat Yai','','Thailand',764,'Asia/Bangkok'),(8614,'Хуа-Хин','Hua Hin','','Thailand',764,'Asia/Bangkok'),(8606,'Чайяпхум','Chaiyaphum','','Thailand',764,'Asia/Bangkok'),(8607,'Чантхабури','Chanthaburi','','Thailand',764,'Asia/Bangkok'),(8608,'Чиангмай','Chiang Mai','','Thailand',764,'Asia/Bangkok'),(8610,'Чонбури','Chon Buri','','Thailand',764,'Asia/Bangkok'),(8665,'Атакпаме','Atakpame','','Togo',768,'Africa/Lome'),(8666,'Дапаон','Dapaon','','Togo',768,'Atlantic/Canary'),(8667,'Кара','Kara','','Togo',768,'Europe/Budapest'),(8669,'Ломе','Lome','','Togo',768,'Africa/Lome'),(8670,'Манго','Mango','','Togo',768,'America/Puerto_Rico'),(8672,'Сокоде','Sokode','','Togo',768,'Africa/Lome'),(8715,'Беджа','Beja','','Tunisia',788,'Europe/Lisbon'),(8716,'Бизерта','Bizerte','','Tunisia',788,'Africa/Tunis'),(8719,'Габес','Gabes','','Tunisia',788,'Africa/Tunis'),(8720,'Гафса','Gafsa','','Tunisia',788,'Africa/Tunis'),(8717,'Джерба','Djerba Mellita','','Tunisia',788,'Africa/Tunis'),(8722,'Кайруан','Kairouan','','Tunisia',788,'Africa/Tunis'),(8723,'Кебили','Kebili','','Tunisia',788,'Africa/Tunis'),(8724,'Келибия','Kelibia','','Tunisia',788,'Africa/Tunis'),(8726,'Монастир','Monastir','','Tunisia',788,'Africa/Tunis'),(8727,'Набуль','Nabeul','','Tunisia',788,'Africa/Tunis'),(8728,'Ремада','Remada','','Tunisia',788,'Africa/Tunis'),(13502,'Сус','Sousse','','Tunisia',788,'Africa/Tunis'),(8729,'Сфакс','Sfax','','Tunisia',788,'Africa/Tunis'),(8732,'Табарка','Tabarka','','Tunisia',788,'Africa/Tunis'),(8734,'Тозеур','Tozeur','','Tunisia',788,'Africa/Tunis'),(8735,'Тунис','Tunis','','Tunisia',788,'Africa/Tunis'),(8733,'Тхала','Thala','','Tunisia',788,'Africa/Tunis'),(53317,'','Сейди','','Turkmenistan',795,''),(8704,'Атамурат','Kerki','','Turkmenistan',795,'Europe/Moscow'),(8676,'Ашхабад','Ashgabat','','Turkmenistan',795,'Asia/Ashgabat'),(108871,'Ашхабад','Ashkhabad','','Turkmenistan',795,'Asia/Ashgabat'),(8677,'Байрамалы','Bajramaly','','Turkmenistan',795,'Asia/Ashgabat'),(8678,'Бахерден','Bakherden','','Turkmenistan',795,'Asia/Ashgabat'),(8682,'Бырдалык','Byrdalyk','','Turkmenistan',795,'Asia/Ashgabat'),(8696,'Газанджык','Gazandzhyk','','Turkmenistan',795,'Asia/Ashgabat'),(8697,'Гушги','Gyshgy','','Turkmenistan',795,'Asia/Ashgabat'),(8698,'Гызыларбат','Gyzylarbat','','Turkmenistan',795,'Asia/Ashgabat'),(8687,'Дарганата','Darganata','','Turkmenistan',795,'Asia/Ashgabat'),(8688,'Дашогуз','Dashkhovuz','','Turkmenistan',795,'Asia/Ashgabat'),(8692,'Екезхе','Ekezhe','','Turkmenistan',795,''),(8694,'Ербент','Erbent','','Turkmenistan',795,'Asia/Ashgabat'),(8701,'Кака','Kaka','','Turkmenistan',795,'Africa/Lagos'),(8683,'Карсанга','Carsanga','','Turkmenistan',795,'Asia/Ashgabat'),(53303,'Мары','Mary','','Turkmenistan',795,'Asia/Ashgabat'),(8709,'Сарагт','Saragt','','Turkmenistan',795,''),(8711,'Тагта','Tagtabazar','','Turkmenistan',795,'Asia/Ashgabat'),(8712,'Теджен','Tedzhen','','Turkmenistan',795,'Asia/Kabul'),(8685,'Туркменабад','Chardzhev','','Turkmenistan',795,'Asia/Ashgabat'),(8713,'Туркменбаши','T?rkmenba?y Turkmenistan','','Turkmenistan',795,'Asia/Ashgabat'),(8714,'Учаджи','Uchadzhi','','Turkmenistan',795,'Asia/Ashgabat'),(8686,'Чешме','Cheshme','','Turkmenistan',795,'Asia/Tehran'),(2517,'İnebolu','inebolu','','Turkey',792,'Europe/Istanbul'),(3081,'Агри','Agri','','Turkey',792,'Europe/Istanbul'),(2496,'Адана','adana','','Turkey',792,'Europe/Istanbul'),(2540,'Адапазары','adapazari','','Turkey',792,'Europe/Istanbul'),(2499,'Айдын','aydin','','Turkey',792,'Europe/Istanbul'),(2500,'Акхисар','akhisar','','Turkey',792,'Europe/Istanbul'),(81,'Аланья','Alanya','','Turkey',792,'Europe/Istanbul'),(3082,'Амасья','Amasya','','Turkey',792,'Europe/Istanbul'),(2565,'Анамур','Anamur','','Turkey',792,'Europe/Istanbul'),(2501,'Анкара/Эсенбога','ankara-esenboga','','Turkey',792,'Europe/Istanbul'),(2502,'Анкара/Этимесгут','anka-raetimesgut','','Turkey',792,''),(85,'Анталья','Antalya','','Turkey',792,'Europe/Istanbul'),(3083,'Артвин','Artvin','','Turkey',792,'Europe/Istanbul'),(2503,'Афьон-Карахисар','afyon','','Turkey',792,'Europe/Istanbul'),(2542,'Балыкесир','balikesir','','Turkey',792,'Europe/Istanbul'),(2505,'Бандырма','bandirma','','Turkey',792,'Europe/Istanbul'),(2567,'Бафра','Bafra','','Turkey',792,'Europe/Athens'),(86,'Белек','Belek','','Turkey',792,'Europe/Istanbul'),(108990,'Бергама','Bergama','','Turkey',792,'Europe/Istanbul'),(2568,'Бисмил','Bismil','','Turkey',792,'Europe/Istanbul'),(2506,'Бодрум','bodrum','','Turkey',792,'Europe/Istanbul'),(2507,'Болу','bolu','','Turkey',792,'Europe/Istanbul'),(2508,'Бурса','bursa','','Turkey',792,'Europe/Istanbul'),(2543,'Бэтмен','batman','','Turkey',792,'Europe/Istanbul'),(2510,'Газиантеп','gaziantep','','Turkey',792,'Europe/Istanbul'),(3087,'Гемерек','Gemerek','','Turkey',792,'Europe/Istanbul'),(3088,'Гиресун','Giresun','','Turkey',792,'Europe/Istanbul'),(2545,'Даламан','dalaman','','Turkey',792,'Europe/Istanbul'),(2546,'Денизли','denizli','','Turkey',792,'Europe/Istanbul'),(2513,'Дикили','dikili','','Turkey',792,'Europe/Istanbul'),(2514,'Диярбакыр','diyarbakir','','Turkey',792,'Europe/Istanbul'),(2515,'Зонгулдак','zonguldak','','Turkey',792,'Europe/Istanbul'),(2516,'Измир','izmir','','Turkey',792,'Europe/Istanbul'),(2575,'Измит','Izmit','','Turkey',792,'Europe/Istanbul'),(2511,'Имброс','gokceada','','Turkey',792,'Europe/Istanbul'),(2547,'Инчирлык','inchirlik','','Turkey',792,'Europe/Istanbul'),(2518,'Искендерун','iskenderun','','Turkey',792,'Europe/Istanbul'),(3106,'Йозгат','Yozgat','','Turkey',792,'Europe/Istanbul'),(2520,'Кайсери','kayseri','','Turkey',792,'Europe/Istanbul'),(2548,'Карс','Kars','','Turkey',792,'Europe/Istanbul'),(2576,'Картал','Kartal','','Turkey',792,'Europe/Istanbul'),(3095,'Кастамону','Kastamonu','','Turkey',792,'Europe/Istanbul'),(82,'Кемер','Kemer','','Turkey',792,'Europe/Istanbul'),(2593,'Кириш','kirish','','Turkey',792,''),(2577,'Киршехир','Kirsehir','','Turkey',792,'Europe/Istanbul'),(2521,'Конья','konya','','Turkey',792,'Europe/Istanbul'),(2549,'Кушадасы','kushadasi','','Turkey',792,'Europe/Istanbul'),(109004,'Кушадасы','Kusadasi','','Turkey',792,'Europe/Istanbul'),(3097,'Кыркларели','Kirklareli','','Turkey',792,'Europe/Istanbul'),(2551,'Кырыккалле','kirikale','','Turkey',792,'Europe/Istanbul'),(2552,'Кютахья','kiutahlia','','Turkey',792,'Europe/Istanbul'),(109006,'Лапсеки','Lapseki','','Turkey',792,'Europe/Istanbul'),(2522,'Малатья','malatya','','Turkey',792,'Europe/Istanbul'),(2579,'Манавгат','Manavgat','','Turkey',792,'Europe/Istanbul'),(2553,'Маниса','manisa','','Turkey',792,'Europe/Istanbul'),(3101,'Мардин','Mardin','','Turkey',792,'Europe/Istanbul'),(80,'Мармарис','Marmaris','','Turkey',792,'Europe/Istanbul'),(2523,'Мерзифон','merzifon','','Turkey',792,'Europe/Istanbul'),(2555,'Мерсин','mersin','','Turkey',792,'Europe/Istanbul'),(109007,'Милас','Milas','','Turkey',792,'Europe/Istanbul'),(2525,'Мугла','mugla','','Turkey',792,'Europe/Istanbul'),(2580,'Мус','Mus','','Turkey',792,'Europe/Istanbul'),(2581,'Невшехир','Nevsehir','','Turkey',792,'Europe/Istanbul'),(3103,'Нигде','Nigde','','Turkey',792,'Europe/Istanbul'),(2556,'Орду','ordu','','Turkey',792,'Europe/Istanbul'),(2557,'Паландокен','palandoken','','Turkey',792,'Europe/Istanbul'),(2584,'Сакарья','Sakarya','','Turkey',792,'Europe/Istanbul'),(2526,'Самсун','samsun','','Turkey',792,'Europe/Istanbul'),(2558,'Сарыкамыш','sarikamish','','Turkey',792,'Europe/Istanbul'),(2527,'Сивас','sivas','','Turkey',792,'Europe/Istanbul'),(83,'Сиде','Side','','Turkey',792,'Europe/Tallinn'),(2559,'Сиирт','siirt','','Turkey',792,'Europe/Istanbul'),(2528,'Силифке','silifke','','Turkey',792,'Europe/Istanbul'),(2529,'Синоп','sinop','','Turkey',792,'Europe/Istanbul'),(84,'Стамбул','Istanbul','','Turkey',792,'Europe/Istanbul'),(2586,'Тарсус','Tarsus','','Turkey',792,'America/Chicago'),(3104,'Татван','Tatvan','','Turkey',792,'Europe/Istanbul'),(2530,'Текирдаг','tekirdag','','Turkey',792,'Europe/Istanbul'),(2560,'Токат','tokat','','Turkey',792,'Europe/Istanbul'),(2587,'Торбалы','Torbali','','Turkey',792,'Europe/Istanbul'),(2531,'Трабзон','trabzon','','Turkey',792,'Europe/Istanbul'),(2561,'Улудаг','uludag','','Turkey',792,'Europe/Istanbul'),(2588,'Урла','Urla','','Turkey',792,'Europe/Istanbul'),(2532,'Ушак','usak','','Turkey',792,'Europe/Istanbul'),(2562,'Фетхие','fehtie','','Turkey',792,'Europe/Istanbul'),(109000,'Фетхие','Fethiye','','Turkey',792,'Europe/Istanbul'),(3086,'Финике','Finike','','Turkey',792,'Europe/Istanbul'),(2509,'Фургон','van','','Turkey',792,'Asia/Vientiane'),(3092,'Хопа','Hopa','','Turkey',792,'Europe/Istanbul'),(2533,'Чанаккале','canakkale','','Turkey',792,'Europe/Istanbul'),(2563,'Чорлу','corly','','Turkey',792,'Europe/Paris'),(2534,'Чорум','corum','','Turkey',792,'Europe/Istanbul'),(2570,'Чубук','Cubuk','','Turkey',792,'Europe/Istanbul'),(3105,'Шанлыурфа','Urfa','','Turkey',792,'Europe/Istanbul'),(3093,'Ыгдыр','Igdir','','Turkey',792,'Europe/Istanbul'),(2519,'Ыспарта','isparta','','Turkey',792,'Europe/Istanbul'),(2535,'Эдирне','edirne','','Turkey',792,'Europe/Istanbul'),(2571,'Элмадаг','Elmadag','','Turkey',792,'Europe/Istanbul'),(2536,'Элязыг','elazig','','Turkey',792,'Europe/Istanbul'),(2537,'Эрзинджан','erzincan','','Turkey',792,'Europe/Istanbul'),(2538,'Эрзурум','erzurum','','Turkey',792,'Europe/Istanbul'),(2539,'Эскишехир','eskisehir','','Turkey',792,'Europe/Istanbul'),(8736,'Аруа','Arua','','Uganda',800,'Africa/Kampala'),(8738,'Гулу','Gulu','','Uganda',800,'Africa/Kampala'),(8739,'Джинджа','Jinja','','Uganda',800,'Africa/Kampala'),(8741,'Кампала','Kampala','','Uganda',800,'Africa/Kampala'),(8742,'Касесе','Kasese','','Uganda',800,'Africa/Kampala'),(8744,'Мбарара','Mbarara','','Uganda',800,'Africa/Kampala'),(8746,'Сороти','Soroti','','Uganda',800,'Africa/Kampala'),(8737,'Энтеббе','Entebbe','','Uganda',800,'Africa/Kampala'),(9052,'','Syr-Dar','','Uzbekistan',860,''),(9027,' Бузаубай','Buzaubaj','','Uzbekistan',860,''),(9022,'Ак-Байтал','Ak-Bajtal','','Uzbekistan',860,''),(9024,'Андижан','Andijan','','Uzbekistan',860,'Asia/Tashkent'),(9026,'Бухара','Bukhara','','Uzbekistan',860,'Asia/Samarkand'),(9031,'Джизак','Jizzakh','','Uzbekistan',860,'Asia/Samarkand'),(9037,'Каракул','Karakul','','Uzbekistan',860,'Asia/Samarkand'),(9038,'Карши','Qarshi','','Uzbekistan',860,'Asia/Samarkand'),(9039,'Коканд','Kokand','','Uzbekistan',860,'Asia/Tashkent'),(9040,'Кунград','Kungrad','','Uzbekistan',860,'Asia/Samarkand'),(9045,'Навои','Navoiy','','Uzbekistan',860,'Asia/Samarkand'),(9044,'Наманган','Namangan','','Uzbekistan',860,'Asia/Tashkent'),(9046,'Нукус','Nukus','','Uzbekistan',860,'Asia/Samarkand'),(9047,'Нурата','Nurata','','Uzbekistan',860,'Asia/Samarkand'),(9049,'Пскем','Pskem','','Uzbekistan',860,'Asia/Tashkent'),(9050,'Самарканд','Samarkand','','Uzbekistan',860,'Asia/Samarkand'),(9053,'Тамбу','Tamdy','','Uzbekistan',860,'Asia/Samarkand'),(9054,'Ташкент','Tashkent','','Uzbekistan',860,'Asia/Tashkent'),(9055,'Термез','Termez','','Uzbekistan',860,'Asia/Samarkand'),(9056,'Ургенч','Urgench','','Uzbekistan',860,'Asia/Samarkand'),(9057,'Ургут','Urgut','','Uzbekistan',860,'Asia/Samarkand'),(9032,'Фергана','Fergana','','Uzbekistan',860,'Asia/Tashkent'),(13863,'Хива','Khiva','','Uzbekistan',860,'Asia/Samarkand'),(9028,'Чимбай','Chimbaj','','Uzbekistan',860,'Asia/Tashkent'),(9034,'Янгиер','Jangier','','Uzbekistan',860,'Asia/Tashkent'),(3209,'Авдеевка','Avdiivka','Донецкая область','Ukraine',804,'Europe/Kiev'),(38,'Ай-Петри','Ai-Petri','Крым','Ukraine',804,'Europe/Kiev'),(1163,'Александрия','Oleksandriia','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3210,'Александровка','Aleksandrovka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3373,'Александровск','Aleksandrovsk','Луганская область','Ukraine',804,'Europe/Kiev'),(13509,'Александровск','Oleksandrivsk','','Ukraine',804,'Europe/Kiev'),(13511,'Алмазная','Almazna','','Ukraine',804,'Europe/Kiev'),(3111,'Алупка','Alupka','','Ukraine',804,'Europe/Kiev'),(33,'Алушта','Alushta','Крым','Ukraine',804,'Europe/Kiev'),(116,'Алчевск','Alchevsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3401,'Алчевск','Kommunarsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3212,'Амвросиевка','Amvrosievka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3458,'Ананьев','Ananiv','Одесская область','Ukraine',804,'Europe/Kiev'),(3253,'Андрушовка','Andrushivka','Житомирская область','Ukraine',804,'Europe/Kiev'),(117,'Антрацит','Antratsyt','Луганская область','Ukraine',804,'Europe/Kiev'),(3178,'Апостолово','Apostolove','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3443,'Арбузинка','Arbuzinka','Николаевская область','Ukraine',804,'Europe/Kiev'),(3112,'Армянск','Armyansk','','Ukraine',804,'Europe/Kiev'),(50,'Артёмовск','Artemivsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(13513,'Артёмовск','Artemivsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3460,'Арциз','Artsyz','Одесская область','Ukraine',804,'Europe/Kiev'),(69,'Аскания-Нова','Askania-Nova','Херсонская область','Ukraine',804,'Europe/Kiev'),(1164,'Ахтырка','Okhtyrka','Сумская область','Ukraine',804,'Europe/Kiev'),(3114,'Балаклава','Balaklava','','Ukraine',804,'Europe/Kiev'),(3554,'Балаклея','Balakliia','Харьковская область','Ukraine',804,'Europe/Kiev'),(3461,'Балта','Balta','Одесская область','Ukraine',804,'Europe/Kiev'),(3133,'Бар','Bar','Винницкая область','Ukraine',804,'Europe/Kiev'),(3254,'Барановка','Baranivka','Житомирская область','Ukraine',804,'Europe/Kiev'),(3555,'Барвенково','Barvinkove','Харьковская область','Ukraine',804,'Europe/Kiev'),(3330,'Барышевка','Barishevka','Киевская область','Ukraine',804,'Europe/Kiev'),(3632,'Бахмач','Bakhmach','Черниговская область','Ukraine',804,'Europe/Kiev'),(3115,'Бахчисарай','Bakhchisaray','','Ukraine',804,'Europe/Kiev'),(3444,'Баштанка','Bashtanka','Николаевская область','Ukraine',804,'Europe/Kiev'),(34,'Белая Церковь','Bila Tserkva','Киевская область','Ukraine',804,'Europe/Kiev'),(168,'Белгород-Днестровский','Bilhorod-Dnistrovskyi','Одесская область','Ukraine',804,'Europe/Kiev'),(3374,'Беловодск','Belovodsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3116,'Белогорск','Bilohirsk','','Ukraine',804,'Europe/Kiev'),(3595,'Белогорье','Belogorye','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3577,'Белозерка','Belozerka','Херсонская область','Ukraine',804,'Europe/Kiev'),(3377,'Белокуракино','Belokurakino','Луганская область','Ukraine',804,'Europe/Kiev'),(233,'Белополье','Bilopillia','Сумская область','Ukraine',804,'Europe/Kiev'),(3462,'Беляевка','Beliaevka','Одесская область','Ukraine',804,'Europe/Kiev'),(1165,'Бердичев','Berdychiv','Житомирская область','Ukraine',804,'Europe/Kiev'),(18,'Бердянск','Berdyansk','Запорожская область','Ukraine',804,'Europe/Kiev'),(234,'Берегово','Berehove','Закарпатская область','Ukraine',804,'Europe/Kiev'),(68,'Бережаны','Berezhany','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3331,'Березань','Berezan','Киевская область','Ukraine',804,'Europe/Kiev'),(3463,'Березино','Berezino','Одесская область','Ukraine',804,'Europe/Kiev'),(3445,'Березне','Berezne','Николаевская область','Ukraine',804,'Europe/Kiev'),(3464,'Березовка','Berezovka','Одесская область','Ukraine',804,'Europe/Kiev'),(13515,'Берестечко','Berestechko','','Ukraine',804,'Europe/Kiev'),(3578,'Берислав','Beryslav','Херсонская область','Ukraine',804,'Europe/Kiev'),(3134,'Бершадь','Bershad','Винницкая область','Ukraine',804,'Europe/Kiev'),(3556,'Близнюки','Blizniuky','Харьковская область','Ukraine',804,'Europe/Kiev'),(235,'Бобринец','Bobrynets','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3634,'Бобровица','Bobrovytsia','Черниговская область','Ukraine',804,'Europe/Kiev'),(111,'Богодухов','Bohodukhiv','Харьковская область','Ukraine',804,'Europe/Kiev'),(3308,'Богородчаны','Bororodchany','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3332,'Богуслав','Bohuslav','Киевская область','Ukraine',804,'Europe/Kiev'),(3465,'Болград','Bolhrad','Одесская область','Ukraine',804,'Europe/Kiev'),(3309,'Болехов','Bolekhiv','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3635,'Борзна','Borzna','Черниговская область','Ukraine',804,'Europe/Kiev'),(3418,'Борислав','Boryslav','Львовская область','Ukraine',804,'Europe/Kiev'),(3596,'Борисов','Borisov','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(35,'Борисполь','Boryspil','Киевская область','Ukraine',804,'Europe/Kiev'),(3333,'Боровая','Borovaia','Киевская область','Ukraine',804,'Europe/Kiev'),(3558,'Боровая','Borovaya','Харьковская область','Ukraine',804,'Europe/Kiev'),(3466,'Бородинское сражение','Borodino','Одесская область','Ukraine',804,'Europe/Kiev'),(3334,'Бородянка','Borodianka','Киевская область','Ukraine',804,'Europe/Kiev'),(3535,'Борщёв','Borschiv','Тернопольская область','Ukraine',804,'Europe/Kiev'),(159,'Боярка','Boiarka','Киевская область','Ukraine',804,'Europe/Kiev'),(3446,'Братское','Bratskoe','Николаевская область','Ukraine',804,'Europe/Kiev'),(118,'Бровары','Brovary','Киевская область','Ukraine',804,'Europe/Kiev'),(60,'Броды','Brody','Львовская область','Ukraine',804,'Europe/Kiev'),(3257,'Брусилов','Brusilov','Житомирская область','Ukraine',804,'Europe/Kiev'),(3135,'Брэила','Brailov','Винницкая область','Ukraine',804,'Europe/Kiev'),(1166,'Брянка','Brianka','Луганская область','Ukraine',804,'Europe/Kiev'),(3313,'Бурштын','Burshtyn','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3520,'Бурынь','Buryn','Сумская область','Ukraine',804,'Europe/Kiev'),(160,'Буск','Busk','Львовская область','Ukraine',804,'Europe/Kiev'),(13429,'Буча','Bucha','','Ukraine',804,'Europe/Kiev'),(3536,'Бучач','Buchach','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3561,'Валки','Valky','Харьковская область','Ukraine',804,'Europe/Kiev'),(3636,'Варва','Varva','Черниговская область','Ukraine',804,'Europe/Kiev'),(3291,'Васильевка','Vasylivka','Запорожская область','Ukraine',804,'Europe/Kiev'),(119,'Васильков','Vasylkiv','Киевская область','Ukraine',804,'Europe/Kiev'),(3181,'Васильковка','Vasilkovka','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3614,'Ватутино','Vatutine','Черкасская область','Ukraine',804,'Europe/Kiev'),(3655,'Вашковцы','Vashkivtsi','Черновицкая область','Ukraine',804,'Europe/Kiev'),(70,'Великая Александровка','Velyka Oleksandrivka','Херсонская область','Ukraine',804,'Europe/Kiev'),(3486,'Великая Багачка','Velikaya Bagachka','Полтавская область','Ukraine',804,'Europe/Kiev'),(3579,'Великая Лепетиха','Velikaya Lepetiha','Херсонская область','Ukraine',804,'Europe/Kiev'),(3467,'Великая Михайловка','Velikaya Mihailovka','Одесская область','Ukraine',804,'Europe/Kiev'),(3221,'Великая Новоселка','Velikaya Novoselka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3521,'Великая Писаревка','Velikaya Pisarevka','Сумская область','Ukraine',804,'Europe/Kiev'),(3279,'Великий Березный','Velikiy Berezniy','Закарпатская область','Ukraine',804,'Europe/Kiev'),(237,'Великий Бурлук','Velykyi-burluk','Харьковская область','Ukraine',804,'Europe/Kiev'),(3182,'Верхнеднепровск','Verkhnodniprovsk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3580,'Верхний Рогачик','Verhniy Rogachik','Херсонская область','Ukraine',804,'Europe/Kiev'),(3315,'Верховина','Verkhovyna','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3448,'Веселиново','Veselinovo','Николаевская область','Ukraine',804,'Europe/Kiev'),(3292,'Веселое','Veseloe','Запорожская область','Ukraine',804,'Europe/Kiev'),(238,'Веселый Подол','Veselyi-podil','Полтавская область','Ukraine',804,'Europe/Kiev'),(3656,'Вижница','Vyzhnytsia','Черновицкая область','Ukraine',804,'Europe/Kiev'),(1167,'Вилково','Vylkove','Одесская область','Ukraine',804,'Europe/Kiev'),(10,'Винница','Vinnytsia','Винницкая область','Ukraine',804,'Europe/Kiev'),(3281,'Виноградов','Vynohradiv','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3597,'Виньковцы','Vinykovcy','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(120,'Вишнёвое','Vyshneve','Киевская область','Ukraine',804,'Europe/Kiev'),(46,'Владимир-Волынский','Volodymyr-Volynskyi','Волынская область','Ukraine',804,'Europe/Kiev'),(3507,'Владимирец','Vadimerech','Ровенская область','Ukraine',804,'Europe/Kiev'),(3449,'Вознесенск','Voznesensk','Николаевская область','Ukraine',804,'Europe/Kiev'),(3223,'Волноваха','Volnovakha','Донецкая область','Ukraine',804,'Europe/Kiev'),(1168,'Воловец','Volovec','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3335,'Володарка','Volodarka','Киевская область','Ukraine',804,'Europe/Kiev'),(3385,'Володарск','Volodarsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3260,'Володарск-Волынский','Volodarsk-Volinskiy','Житомирская область','Ukraine',804,'Europe/Kiev'),(3224,'Володарское','Volodarskoe','Донецкая область','Ukraine',804,'Europe/Kiev'),(3598,'Волочиск','Volochysk','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3562,'Волчанск','Vovchansk','Харьковская область','Ukraine',804,'Europe/Kiev'),(3184,'Вольногорск','Vilnohirsk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(13519,'Вольнянск','Vilniansk','','Ukraine',804,'Europe/Kiev'),(3522,'Ворожба','Vorozba','Сумская область','Ukraine',804,'Europe/Kiev'),(3523,'Воронеж','Voroneg','Сумская область','Ukraine',804,'Europe/Kiev'),(121,'Ворохта','Vorokhta','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3450,'Врадиевка','Vradievka','Николаевская область','Ukraine',804,'Europe/Kiev'),(3581,'Высокополье','Visokopolye','Херсонская область','Ukraine',804,'Europe/Kiev'),(13521,'Вышгород','Vyshhorod','','Ukraine',804,'Europe/Kiev'),(3488,'Гадяч','Hadiach','Полтавская область','Ukraine',804,'Europe/Kiev'),(239,'Гайворон','Haivoron','Кировоградская область','Ukraine',804,'Europe/Kiev'),(45,'Гайсин','Haisyn','Винницкая область','Ukraine',804,'Europe/Kiev'),(3318,'Галич','Halych','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3117,'Гаспра','Gaspra','','Ukraine',804,'Europe/Kiev'),(3305,'Гёйтепе','Prishib','Запорожская область','Ukraine',804,'Europe/Kiev'),(169,'Геническ','Henichesk','Херсонская область','Ukraine',804,'Europe/Kiev'),(3389,'Георгиевка','Georgievka','Луганская область','Ukraine',804,'Europe/Kiev'),(3657,'Герца','Hertsa','Черновицкая область','Ukraine',804,'Europe/Kiev'),(3489,'Глобино','Hlobyne','Полтавская область','Ukraine',804,'Europe/Kiev'),(3524,'Глухов','Hlukhiv','Сумская область','Ukraine',804,'Europe/Kiev'),(3658,'Глыбокая','Hlyboka','Черновицкая область','Ukraine',804,'Europe/Kiev'),(3582,'Голая Пристань','Hola Prystan','Херсонская область','Ukraine',804,'Europe/Kiev'),(3356,'Голованевск','Golovanevsk','Кировоградская область','Ukraine',804,'Europe/Kiev'),(122,'Горловка','Horlivka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3583,'Горностаевка','Gornostaevka','Херсонская область','Ukraine',804,'Europe/Kiev'),(3423,'Горняк','Gorniak','Львовская область','Ukraine',804,'Europe/Kiev'),(3320,'Городенка','Horodenka','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3615,'Городище','Horodysche','Черкасская область','Ukraine',804,'Europe/Kiev'),(3638,'Городня','Horodnia','Черниговская область','Ukraine',804,'Europe/Kiev'),(3599,'Городок','Horodok','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3165,'Горохов','Horokhiv','Волынская область','Ukraine',804,'Europe/Kiev'),(3508,'Гоща','Goscha','Ривненская область','Ukraine',804,'Europe/Kiev'),(3492,'Гребёнка','Hrebinka','Полтавская область','Ukraine',804,'Europe/Kiev'),(3293,'Гуляйполе','Huliaipole','Запорожская область','Ukraine',804,'Europe/Kiev'),(3119,'Гурзуф','Gurzuf','','Ukraine',804,'Europe/Kiev'),(3540,'Гусятин','Gusiatyn','Тернопольская область','Ukraine',804,'Europe/Kiev'),(240,'Дарьевка','Darivka','Херсонская область','Ukraine',804,'Europe/Kiev'),(241,'Дебальцево','Debaltseve','Донецкая область','Ukraine',804,'Europe/Kiev'),(3509,'Демидовка','Demidovka','Ровенская область','Ukraine',804,'Europe/Kiev'),(3601,'Деражня','Derazhnia','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3564,'Дергачи','Derhachi','Харьковская область','Ukraine',804,'Europe/Kiev'),(39,'Джанкой','Dzhankoy','Крым','Ukraine',804,'Europe/Kiev'),(3229,'Дзержинск','Dzerzhynsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3493,'Диканька','Dikanka','Полтавская область','Ukraine',804,'Europe/Kiev'),(1169,'Димитров','Dymytrov','Донецкая область','Ukraine',804,'Europe/Kiev'),(123,'Днепродзержинск','Dniprodzerzhynsk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(16,'Днепропетровск','Dnipropetrovsk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3357,'Добровеличковка','Dbrovelichkova','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3230,'Доброполье','Dobropillia','Донецкая область','Ukraine',804,'Europe/Kiev'),(3231,'Докучаевск','Dokuchaevsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(13531,'Долина','Dolyna','','Ukraine',804,'Europe/Kiev'),(3358,'Долинская','Dolynska','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3451,'Доманевка','Domanevka','Николаевская область','Ukraine',804,'Europe/Kiev'),(7,'Донецк','Donetsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3232,'Донской','Donskoe','Донецкая область','Ukraine',804,'Europe/Kiev'),(3616,'Драбов','Drabov','Черкасская область','Ukraine',804,'Europe/Kiev'),(242,'Дрогобыч','Drohobych','Львовская область','Ukraine',804,'Europe/Kiev'),(86698,'Дрогобыч','Drogobych','','Ukraine',804,'Europe/Kiev'),(161,'Дружба','Druzhba','Сумская область','Ukraine',804,'Europe/Kiev'),(1170,'Дружковка','Druzhkivka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3510,'Дубно','Dubno','Ровенская область','Ukraine',804,'Europe/Kiev'),(3511,'Дубровица','Dubrovytsia','Ровенская область','Ukraine',804,'Europe/Kiev'),(3602,'Дунаевцы','Dunaivtsi','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(26,'Евпатория','Eupatoria','Крым','Ukraine',804,'Europe/Kiev'),(3452,'Еланец','Elanec','Николаевская область','Ukraine',804,'Europe/Kiev'),(3264,'Емильчино','Emilychino','Житомирская область','Ukraine',804,'Europe/Kiev'),(1171,'Енакиево','Yenakiieve','Донецкая область','Ukraine',804,'Europe/Kiev'),(243,'Жашков','Zhashkiv','Черкасская область','Ukraine',804,'Europe/Kiev'),(13535,'Ждановка','Zhdanivka','','Ukraine',804,'Europe/Kiev'),(1172,'Железный порт','Zhelezniy port','Херсонская область','Ukraine',804,'Europe/Kiev'),(1173,'Жёлтые Воды','Zhovti Vody','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3426,'Жидачов','Gidacov','Львовская область','Ukraine',804,'Europe/Kiev'),(3,'Житомир','Zhytomyr','Житомирская область','Ukraine',804,'Europe/Kiev'),(124,'Жмеринка','Zhmerynka','Винницкая область','Ukraine',804,'Europe/Kiev'),(3427,'Жовква','Zhovkva','Львовская область','Ukraine',804,'Europe/Kiev'),(3541,'Залещики','Zalischyky','Тернопольская область','Ukraine',804,'Europe/Kiev'),(17,'Запорожье','Zaporizhia','Запорожская область','Ukraine',804,'Europe/Kiev'),(3512,'Заречное','Zarechnoe','Ровенская область','Ukraine',804,'Europe/Kiev'),(1174,'Заставна','Zastavna','Черновицкая область','Ukraine',804,'Europe/Kiev'),(1175,'Затока','Zatoka','Одесская область','Ukraine',804,'Europe/Kiev'),(3565,'Зачепиловка','Zacepilovka','Харьковская область','Ukraine',804,'Europe/Kiev'),(125,'Збараж','Zbarazh','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3543,'Зборов','Zboriv','Тернопольская область','Ukraine',804,'Europe/Kiev'),(244,'Звенигородка','Zvenyhorodka','Черкасская область','Ukraine',804,'Europe/Kiev'),(3339,'Згуровка','Zgurovka','Киевская область','Ukraine',804,'Europe/Kiev'),(3513,'Здолбунов','Zdolbuniv','Ровенская область','Ukraine',804,'Europe/Kiev'),(3494,'Зеньков','Zinkiv','Полтавская область','Ukraine',804,'Europe/Kiev'),(3566,'Змиев','Zmiiv','Харьковская область','Ukraine',804,'Europe/Kiev'),(114,'Знаменка','Znamianka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(74,'Золотоноша','Zolotonosha','Черкасская область','Ukraine',804,'Europe/Kiev'),(3428,'Золочев','Zolochiv','Львовская область','Ukraine',804,'Europe/Kiev'),(3567,'Золочев','Zolocev','Харьковская область','Ukraine',804,'Europe/Kiev'),(3236,'Зуевка','Zuevka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3167,'Иваничи','Ivanichy','Волынская область','Ukraine',804,'Europe/Kiev'),(3340,'Иванков','Ivankov','Киевская область','Ukraine',804,'Europe/Kiev'),(32,'Ивано-Франковск','Ivano-Frankivsk','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3429,'Ивано-Франковск','Ivano-Frankovsk','Львовская область','Ukraine',804,'Europe/Kiev'),(63,'Измаил','Izmail','Одесская область','Ukraine',804,'Europe/Kiev'),(112,'Изюм','Izium','Харьковская область','Ukraine',804,'Europe/Kiev'),(3603,'Изяслав','Iziaslav Ukraine','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3143,'Ильинцы','Iliyncy','Винницкая область','Ukraine',804,'Europe/Kiev'),(126,'Ильичёвск','Illichivsk','Одесская область','Ukraine',804,'Europe/Kiev'),(3193,'Ингулец','Ingulec','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(13430,'Инкерман','Inkerman','','Ukraine',804,'Europe/Kiev'),(127,'Ирпень','Irpin','Киевская область','Ukraine',804,'Europe/Kiev'),(3283,'Иршава','Irshava','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3641,'Ичня','Ichnia','Черниговская область','Ukraine',804,'Europe/Kiev'),(3341,'Кагарлык','Kaharlyk','Киевская область','Ukraine',804,'Europe/Kiev'),(3453,'Казанка','Kazanka','Николаевская область','Ukraine',804,'Europe/Kiev'),(1176,'Казатин','Koziatyn','Винницкая область','Ukraine',804,'Europe/Kiev'),(3585,'Каланчак','Kalanchak','Херсонская область','Ukraine',804,'Europe/Kiev'),(3144,'Калиновка','Kalynivka','Винницкая область','Ukraine',804,'Europe/Kiev'),(1177,'Калуш','Kalush','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(73,'Каменец-Подольский','Kamianets-Podilskyi','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3620,'Каменка','Kamianka','Черкасская область','Ukraine',804,'Europe/Kiev'),(3430,'Каменка-Бугская','Kamianka-Buzka','Львовская область','Ukraine',804,'Europe/Kiev'),(3295,'Каменка-Днепровская','Kamianka-Dniprovska','Запорожская область','Ukraine',804,'Europe/Kiev'),(1178,'Камень-Каширский','Kamin-Kashyrskyi','Волынская область','Ukraine',804,'Europe/Kiev'),(1179,'Канев','Kaniv','Черкасская область','Ukraine',804,'Europe/Kiev'),(3495,'Карловка','Karlivka','Полтавская область','Ukraine',804,'Europe/Kiev'),(3621,'Катеринополь','Katerinopoy','Черкасская область','Ukraine',804,'Europe/Kiev'),(3587,'Каховка','Kakhovka','Херсонская область','Ukraine',804,'Europe/Kiev'),(3109,'Кача','Kacha','','Ukraine',804,'Europe/Kiev'),(3569,'Кегичёвка','Kegicheka','Харьковская область','Ukraine',804,'Europe/Kiev'),(3659,'Кельменцы','Kelymency','Черновицкая область','Ukraine',804,'Europe/Kiev'),(41,'Керчь','Kerch','Крым','Ukraine',804,'Europe/Kiev'),(3168,'Киверцы','Kivertsi','Волынская область','Ukraine',804,'Europe/Kiev'),(23,'Киев','Kiev','Киевская область','Ukraine',804,'Europe/Kiev'),(3470,'Килия','Kiliya','Одесская область','Ukraine',804,'Europe/Kiev'),(245,'Кирилловка','Kyrylivka','Запорожская область','Ukraine',804,'Europe/Kiev'),(3298,'Кирилловка','Kirillovka','Запорожская область','Ukraine',804,'Europe/Kiev'),(14,'Кировоград','Kirovohrad','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3240,'Кировск','Kirovsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3122,'Кировское','Kirovske','','Ukraine',804,'Europe/Kiev'),(3660,'Кицмань','Kitsman','Черновицкая область','Ukraine',804,'Europe/Kiev'),(246,'Клепинино','Klepynine','Крым','Ukraine',804,'Europe/Kiev'),(247,'Кобеляки','Kobeliaky','Полтавская область','Ukraine',804,'Europe/Kiev'),(1180,'Коблево','Koblevo','Николаевская область','Ukraine',804,'Europe/Kiev'),(47,'Ковель','Kovel','Волынская область','Ukraine',804,'Europe/Kiev'),(3471,'Кодыма','Kodyma','Одесская область','Ukraine',804,'Europe/Kiev'),(3642,'Козелец','Kozelec','Черниговская область','Ukraine',804,'Europe/Kiev'),(3496,'Козельщина','Kozelshina','Полтавская область','Ukraine',804,'Europe/Kiev'),(3344,'Козин','Kozin','Киевская область','Ukraine',804,'Europe/Kiev'),(3546,'Козлов','Kozlov','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3547,'Козова','Kozova','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3123,'Коктебель','Koktebel','','Ukraine',804,'Europe/Kiev'),(3570,'Коломак','Kolomak','Харьковская область','Ukraine',804,'Europe/Kiev'),(56,'Коломыя','Kolomyia','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3472,'Коминтерновское','Kominternovskoe','Одесская область','Ukraine',804,'Europe/Kiev'),(248,'Комиссаровка','Komisarivka','Луганская область','Ukraine',804,'Europe/Kiev'),(3363,'Компанеевка','Kompaneevka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(1181,'Комсомольск','Komsomolsk','Полтавская область','Ukraine',804,'Europe/Kiev'),(1214,'Комсомольский','Komsomolskiy','Донецкая область','Ukraine',804,'Europe/Kiev'),(67,'Конотоп','Konotop','Сумская область','Ukraine',804,'Europe/Kiev'),(1182,'Константиновка','Kostiantynivka','Донецкая область','Ukraine',804,'Europe/Kiev'),(13431,'Кореиз','Koreiz','','Ukraine',804,'Europe/Kiev'),(3516,'Корец','Korets','Ровенская область','Ukraine',804,'Europe/Kiev'),(3643,'Короп','Korop','Черниговская область','Ukraine',804,'Europe/Kiev'),(1183,'Коростень','Korosten','Житомирская область','Ukraine',804,'Europe/Kiev'),(3267,'Коростышев','Korostyshiv','Житомирская область','Ukraine',804,'Europe/Kiev'),(3622,'Корсунь-Шевченковский','Korsun-Shevchenkivskyi','Черкасская область','Ukraine',804,'Europe/Kiev'),(3644,'Корюковка','Koriukivka','Черниговская область','Ukraine',804,'Europe/Kiev'),(1184,'Косов','Kosiv','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3517,'Костополь','Kostopil','Ровенская область','Ukraine',804,'Europe/Kiev'),(3497,'Котельва','Kotelyva','Полтавская область','Ukraine',804,'Europe/Kiev'),(3473,'Котовск','Kotovsk','Одесская область','Ukraine',804,'Europe/Kiev'),(128,'Краматорск','Kramatorsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3604,'Красилов','Krasyliv','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(51,'Красноармейск','Krasnoarmiisk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3124,'Красногвардейское','Krasnogvardeyiskoe','','Ukraine',804,'Europe/Kiev'),(113,'Красноград','Krasnohrad','Харьковская область','Ukraine',804,'Europe/Kiev'),(1185,'Краснодон','Krasnodon','Луганская область','Ukraine',804,'Europe/Kiev'),(3571,'Краснокутск','Krasnokutsk','Харьковская область','Ukraine',804,'Europe/Kiev'),(3125,'Красноперекопск','Krasnoperekopsk','','Ukraine',804,'Europe/Kiev'),(3527,'Краснополье','Krasnopolye','Сумская область','Ukraine',804,'Europe/Kiev'),(3474,'Красные Окны','Krasnye Okny','Одесская область','Ukraine',804,'Europe/Kiev'),(3241,'Красный Лиман','Krasnyi Lyman','Донецкая область','Ukraine',804,'Europe/Kiev'),(129,'Красный Луч','Krasnyi Luch','Луганская область','Ukraine',804,'Europe/Kiev'),(249,'Кременец','Kremenets','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3402,'Кременная','Kremennaia','Луганская область','Ukraine',804,'Europe/Kiev'),(64,'Кременчуг','Kremenchuk','Полтавская область','Ukraine',804,'Europe/Kiev'),(3454,'Кривое Озеро','Krivoe Ozero','Николаевская область','Ukraine',804,'Europe/Kiev'),(29,'Кривой Рог','Kryvyi Rih','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3196,'Кринички','Krinichky','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3528,'Кролевец','Krolevets','Сумская область','Ukraine',804,'Europe/Kiev'),(1186,'Кузнецовск','Kuznetsovsk','Ривненская область','Ukraine',804,'Europe/Kiev'),(3299,'Куйбышево','Kuibishevo','Запорожская область','Ukraine',804,'Europe/Kiev'),(3645,'Куликовка','Kulikova','Черниговская область','Ukraine',804,'Europe/Kiev'),(250,'Купянск','Kupiansk','Харьковская область','Ukraine',804,'Europe/Kiev'),(13539,'Ладыжин','Ladyzhyn','','Ukraine',804,'Europe/Kiev'),(1187,'Лазурное','Lazurnoe','Херсонская область','Ukraine',804,'Europe/Kiev'),(3548,'Лановцы','Lanivtsi','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3529,'Лебедин','Lebedyn','Сумская область','Ukraine',804,'Europe/Kiev'),(3126,'Ленино','Lenino','','Ukraine',804,'Europe/Kiev'),(3605,'Летичев','Letychiv','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(13432,'Ливадия','Livadiya','','Ukraine',804,'Europe/Kiev'),(3530,'Липовая Долина','Lipovaia Dolina','Сумская область','Ukraine',804,'Europe/Kiev'),(3147,'Липовец','Lipovec','Винницкая область','Ukraine',804,'Europe/Kiev'),(130,'Лисичанск','Lysychansk','Луганская область','Ukraine',804,'Europe/Kiev'),(3148,'Литин','Litin','Винницкая область','Ukraine',804,'Europe/Kiev'),(251,'Лозовая','Lozova','Харьковская область','Ukraine',804,'Europe/Kiev'),(3169,'Локачи','Lokachy','Волынская область','Ukraine',804,'Europe/Kiev'),(3498,'Лохвица','Lokhvytsia','Полтавская область','Ukraine',804,'Europe/Kiev'),(65,'Лубны','Lubny','Полтавская область','Ukraine',804,'Europe/Kiev'),(31,'Луганск','Luhansk','Луганская область','Ukraine',804,'Europe/Kiev'),(3268,'Лугины','Luginy','Житомирская область','Ukraine',804,'Europe/Kiev'),(3403,'Лутугино','Lutuhyne','Луганская область','Ukraine',804,'Europe/Kiev'),(28,'Луцк','Lutsk','Волынская область','Ukraine',804,'Europe/Kiev'),(3624,'Лысянка','Lisianka','Черкасская область','Ukraine',804,'Europe/Kiev'),(15,'Львов','Lviv','Львовская область','Ukraine',804,'Europe/Kiev'),(3269,'Любар','Liubar','Житомирская область','Ukraine',804,'Europe/Kiev'),(162,'Любашевка','Liubashivka','Одесская область','Ukraine',804,'Europe/Kiev'),(3475,'Любашевка','Liubashovka','Одесская область','Ukraine',804,'Europe/Kiev'),(3170,'Любешов','Liubeshov','Волынская область','Ukraine',804,'Europe/Kiev'),(3171,'Любомль','Liuboml','Волынская область','Ukraine',804,'Europe/Kiev'),(3572,'Люботин','Liubotyn','Харьковская область','Ukraine',804,'Europe/Kiev'),(3197,'Магдалиновка','Magdalinovka','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3345,'Макаров','Makarov','Киевская область','Ukraine',804,'Europe/Kiev'),(131,'Макеевка','Makiivka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3364,'Малая Виска','Mala Vyska','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3270,'Малин','Malyn','Житомирская область','Ukraine',804,'Europe/Kiev'),(3242,'Мангуш','Mangush','Донецкая область','Ukraine',804,'Europe/Kiev'),(3172,'Маневичи','Manevichy','Волынская область','Ukraine',804,'Europe/Kiev'),(3625,'Маньковка','Manykovka','Черкасская область','Ukraine',804,'Europe/Kiev'),(132,'Марганец','Marhanets','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(20,'Мариуполь','Mariupol','Донецкая область','Ukraine',804,'Europe/Kiev'),(3404,'Марковка','Markovka','Луганская область','Ukraine',804,'Europe/Kiev'),(3243,'Марьинка','Maryinka','Донецкая область','Ukraine',804,'Europe/Kiev'),(3127,'Массандра','Massandra','','Ukraine',804,'Europe/Kiev'),(3499,'Машевка','Mashevka','Полтавская область','Ukraine',804,'Europe/Kiev'),(3284,'Межгорье','Mezgorie','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3198,'Межевая','Megevaya','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(55,'Мелитополь','Melitopol','Запорожская область','Ukraine',804,'Europe/Kiev'),(3405,'Меловое','Melovoe','Луганская область','Ukraine',804,'Europe/Kiev'),(3646,'Мена','Mena','Черниговская область','Ukraine',804,'Europe/Kiev'),(163,'Мерефа','Merefa','Харьковская область','Ukraine',804,'Europe/Kiev'),(133,'Миргород','Myrhorod','Полтавская область','Ukraine',804,'Europe/Kiev'),(165,'Мироновка','Myronivka','Киевская область','Ukraine',804,'Europe/Kiev'),(3300,'Михайловка','Mihailovka','Запорожская область','Ukraine',804,'Europe/Kiev'),(3518,'Млинов','Mlinov','Ровенская область','Ukraine',804,'Europe/Kiev'),(164,'Могилёв-Подольский','Mohyliv-Podilskyi','Винницкая область','Ukraine',804,'Europe/Kiev'),(13543,'Молодогвардейск','Molodohvardiysk','','Ukraine',804,'Europe/Kiev'),(13545,'Молочанск','Molochansk','','Ukraine',804,'Europe/Kiev'),(3549,'Монастыриска','Monastyryska','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3626,'Монастырище','Monastyrysche','Черкасская область','Ukraine',804,'Europe/Kiev'),(1188,'Моршин','Morshyn','Львовская область','Ukraine',804,'Europe/Kiev'),(3431,'Мостиска','Mostyska','Львовская область','Ukraine',804,'Europe/Kiev'),(134,'Мукачево','Mukachevo','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3324,'Надворная','Nadvornaia','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3271,'Народичи','Narodichy','Житомирская область','Ukraine',804,'Europe/Kiev'),(3531,'Недригайлов','Nedrigailov','Сумская область','Ukraine',804,'Europe/Kiev'),(77,'Нежин','Nizhyn','Черниговская область','Ukraine',804,'Europe/Kiev'),(3150,'Немиров','Nemyriv','Винницкая область','Ukraine',804,'Europe/Kiev'),(1189,'Нетешин','Netishyn','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3128,'Нижнегорский','Nignegorskiy','','Ukraine',804,'Europe/Kiev'),(3588,'Нижние Серогозы','Nignye Serogzy','Херсонская область','Ukraine',804,'Europe/Kiev'),(11,'Николаев','Mykolaiv','Николаевская область','Ukraine',804,'Europe/Kiev'),(13549,'Николаев','Mykolaiv','','Ukraine',804,'Europe/Kiev'),(3476,'Николаевка','Nikolaevka','Одесская область','Ukraine',804,'Europe/Kiev'),(48,'Никополь','Nikopol','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3573,'Новая Водолага','Novaya Vodolaga','Харьковская область','Ukraine',804,'Europe/Kiev'),(72,'Новая Каховка','Nova Kakhovka','Херсонская область','Ukraine',804,'Europe/Kiev'),(3455,'Новая Одесса','Nova Odesa','Николаевская область','Ukraine',804,'Europe/Kiev'),(252,'Новая Ушица','Nova-ushytsia','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(13551,'Новгород-Северский','Novhorod-Siverskyi','','Ukraine',804,'Europe/Kiev'),(3365,'Новгородка','Novgorodka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3244,'Новоазовск','Novoazovsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3406,'Новоайдар','Novoaidar','Луганская область','Ukraine',804,'Europe/Kiev'),(3366,'Новоархангельск','Novoarhangelysk','Кировоградская область','Ukraine',804,'Europe/Kiev'),(135,'Нововолынск','Novovolynsk','Волынская область','Ukraine',804,'Europe/Kiev'),(3589,'Нововоронцовка','Novovoroncovka','Херсонская область','Ukraine',804,'Europe/Kiev'),(52,'Новоград-Волынский','Novohrad-Volynskyi','Житомирская область','Ukraine',804,'Europe/Kiev'),(13553,'Новогродовка','Novohrodivka','','Ukraine',804,'Europe/Kiev'),(3661,'Новоднестровск','Novodnistrovsk','Черновицкая область','Ukraine',804,'Europe/Kiev'),(253,'Новомиргород','Novomyrhorod','Кировоградская область','Ukraine',804,'Europe/Kiev'),(1190,'Новомосковск','Novomoskovsk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3301,'Новониколаевка','Novonikolaevka','Запорожская область','Ukraine',804,'Europe/Kiev'),(3407,'Новопсков','Novopskov','Луганская область','Ukraine',804,'Europe/Kiev'),(1191,'Новоселица','Novoselytsia','Черновицкая область','Ukraine',804,'Europe/Kiev'),(3590,'Новотроицкое','Novotroickoe','Херсонская область','Ukraine',804,'Europe/Kiev'),(3367,'Новоукраинка','Novoukrainka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3500,'Новые Санжары','Novye Sangary','Полтавская область','Ukraine',804,'Europe/Kiev'),(3456,'Новый Буг','Novyi Buh','Николаевская область','Ukraine',804,'Europe/Kiev'),(3648,'Носовка','Nosivka','Черниговская область','Ukraine',804,'Europe/Kiev'),(3347,'Обухов','Obukhiv','Киевская область','Ukraine',804,'Europe/Kiev'),(3477,'Овидиополь','Ovidiopoly','Одесская область','Ukraine',804,'Europe/Kiev'),(53,'Овруч','Ovruch','Житомирская область','Ukraine',804,'Europe/Kiev'),(25,'Одесса','Odessa','Одесская область','Ukraine',804,'Europe/Kiev'),(254,'Олевск','Olevsk','Житомирская область','Ukraine',804,'Europe/Kiev'),(3368,'Ольшанка','Olyshanka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3369,'Онуфриевка','Onufrievka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(3151,'Оратов','Oratov','Винницкая область','Ukraine',804,'Europe/Kiev'),(3199,'Орджоникидзе','Ordzhonikidze','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3302,'Орехов','Orikhiv','Запорожская область','Ukraine',804,'Europe/Kiev'),(3501,'Оржица','Orgica','Полтавская область','Ukraine',804,'Europe/Kiev'),(3519,'Острог','Ostrog','Ровенская область','Ukraine',804,'Europe/Kiev'),(1192,'Очаков','Ochakiv','Николаевская область','Ukraine',804,'Europe/Kiev'),(49,'Павлоград','Pavlohrad','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(13433,'Партенит','Partenid','','Ukraine',804,'Europe/Kiev'),(115,'Первомайск','Pervomaisk','Николаевская область','Ukraine',804,'Europe/Kiev'),(13557,'Первомайск','Pervomaisk','','Ukraine',804,'Europe/Kiev'),(3574,'Первомайский','Pervomaiskyi','Харьковская область','Ukraine',804,'Europe/Kiev'),(3129,'Первомайское','Pervomaiskoe','','Ukraine',804,'Europe/Kiev'),(3408,'Перевальск','Perevalsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3433,'Перемышляны','Pereishliany','Львовская область','Ukraine',804,'Europe/Kiev'),(3285,'Перечин','Perechyn','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3348,'Переяслав-Хмельницкий','Pereiaslav-Khmelnytskyi','Киевская область','Ukraine',804,'Europe/Kiev'),(3200,'Першотравенск','Pershotravensk','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3370,'Петрово','Petrovo','Кировоградская область','Ukraine',804,'Europe/Kiev'),(13561,'Петровское','Petrovske','','Ukraine',804,'Europe/Kiev'),(3201,'Петропавловка','Petropavlovka','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(1193,'Пирятин','Pyriatyn','Полтавская область','Ukraine',804,'Europe/Kiev'),(3153,'Погребище','Pohrebysche','Винницкая область','Ukraine',804,'Europe/Kiev'),(3550,'Подволочиск','Podvolochinsk','Тернопольская область','Ukraine',804,'Europe/Kiev'),(13563,'Подгайцы','Pidhaitsi','','Ukraine',804,'Europe/Kiev'),(136,'Подобовец','Podobovec','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3202,'Покровское','Pokrovskoe','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3349,'Полесское','Polesskoe','Киевская область','Ukraine',804,'Europe/Kiev'),(3303,'Пологи','Polohy','Запорожская область','Ukraine',804,'Europe/Kiev'),(3606,'Полонное','Polonne','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(1,'Полтава','Poltava','Полтавская область','Ukraine',804,'Europe/Kiev'),(3409,'Попасная','Popasna','Луганская область','Ukraine',804,'Europe/Kiev'),(3272,'Попельня','Popelynya','Житомирская область','Ukraine',804,'Europe/Kiev'),(13565,'Почаев','Pochaiv','','Ukraine',804,'Europe/Kiev'),(3304,'Приазовское','Priazovskoe','Запорожская область','Ukraine',804,'Europe/Kiev'),(78,'Прилуки','Pryluky','Черниговская область','Ukraine',804,'Europe/Kiev'),(1195,'Приморск','Prymorsk','Запорожская область','Ukraine',804,'Europe/Kiev'),(13569,'Припять','Prypiat','','Ukraine',804,'Europe/Kiev'),(3434,'Пустомыты','Pustomyty','Львовская область','Ukraine',804,'Europe/Kiev'),(3532,'Путивль','Putyvl','Сумская область','Ukraine',804,'Europe/Kiev'),(3662,'Путила','Putila','Черновицкая область','Ukraine',804,'Europe/Kiev'),(3203,'Пятихатки','Piatykhatky','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(61,'Рава-Русская','Rava-Ruska','Львовская область','Ukraine',804,'Europe/Kiev'),(3435,'Рава-Русская','Rava-Russkaya','Львовская область','Ukraine',804,'Europe/Kiev'),(3436,'Радехов','Radekhiv','Львовская область','Ukraine',804,'Europe/Kiev'),(13571,'Радивилов','Radyvyliv','','Ukraine',804,'Europe/Kiev'),(3273,'Радомышль','Radomyshl','Житомирская область','Ukraine',804,'Europe/Kiev'),(3478,'Раздельная','Razdelnaya','Одесская область','Ukraine',804,'Europe/Kiev'),(3130,'Раздольное','Razdolnoe','','Ukraine',804,'Europe/Kiev'),(3350,'Ракитное','Rakitnoe','Киевская область','Ukraine',804,'Europe/Kiev'),(3173,'Ратно','Ratno','Волынская область','Ukraine',804,'Europe/Kiev'),(255,'Рахов','Rakhiv','Львовская область','Ukraine',804,'Europe/Kiev'),(1196,'Рени','Reni','Одесская область','Ukraine',804,'Europe/Kiev'),(3649,'Репки','Repky','Черниговская область','Ukraine',804,'Europe/Kiev'),(3502,'Решетиловка','Reshetilovka','Полтавская область','Ukraine',804,'Europe/Kiev'),(13573,'Ржищев','Rzhyschiv','','Ukraine',804,'Europe/Kiev'),(1197,'Ровеньки','Rovenky','Луганская область','Ukraine',804,'Europe/Kiev'),(6,'Ровно','Rivne','Ривненская область','Ukraine',804,'Europe/Kiev'),(3325,'Рогатин','Rohatyn','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3174,'Рожище','Rozhysche','Волынская область','Ukraine',804,'Europe/Kiev'),(3326,'Рожнятов','Rozniakov','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(257,'Ромны','Romny','Сумская область','Ukraine',804,'Europe/Kiev'),(1198,'Рубежное','Rubizhne','Луганская область','Ukraine',804,'Europe/Kiev'),(3274,'Ружин','Rugin','Житомирская область','Ukraine',804,'Europe/Kiev'),(3479,'Саврань','Savrany','Одесская область','Ukraine',804,'Europe/Kiev'),(58,'Саки','Saky','Крым','Ukraine',804,'Europe/Kiev'),(3437,'Самбор','Sambir','Львовская область','Ukraine',804,'Europe/Kiev'),(3480,'Сарата','Sarata','Одесская область','Ukraine',804,'Europe/Kiev'),(66,'Сарны','Sarny','Ривненская область','Ukraine',804,'Europe/Kiev'),(3575,'Сахновщина','Sahnovshina','Харьковская область','Ukraine',804,'Europe/Kiev'),(1199,'Свалява','Svaliava','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3410,'Сватово','Svatove','Луганская область','Ukraine',804,'Europe/Kiev'),(1200,'Свердловск','Sverdlovsk','Луганская область','Ukraine',804,'Europe/Kiev'),(57,'Светловодск','Svitlovodsk','Кировоградская область','Ukraine',804,'Europe/Kiev'),(273,'Свитязь','Svitjaz','Волынская область','Ukraine',804,'Europe/Kiev'),(22,'Севастополь','Sevastopol','Крым','Ukraine',804,'Europe/Kiev'),(1201,'Северодонецк','Sievierodonetsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3248,'Селидово','Selydove','Донецкая область','Ukraine',804,'Europe/Kiev'),(258,'Семёновка','Semenivka','Черниговская область','Ukraine',804,'Europe/Kiev'),(1202,'Сергеевка','Sergeevka','Одесская область','Ukraine',804,'Europe/Kiev'),(3533,'Середина-Буда','Seredyna-Buda','Сумская область','Ukraine',804,'Europe/Kiev'),(3131,'Симеиз','Simeiz','','Ukraine',804,'Europe/Kiev'),(24,'Симферополь','Simferopol','Крым','Ukraine',804,'Europe/Kiev'),(3204,'Синельниково','Synelnykove','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(137,'Синяк','Syniak','Закарпатская область','Ukraine',804,'Europe/Kiev'),(1203,'Скадовск','Skadovsk','Херсонская область','Ukraine',804,'Europe/Kiev'),(1204,'Скалат','Skalat','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3351,'Сквира','Skvyra','Киевская область','Ukraine',804,'Europe/Kiev'),(62,'Сколе','Skole','Львовская область','Ukraine',804,'Europe/Kiev'),(138,'Славское','Slavske','Львовская область','Ukraine',804,'Europe/Kiev'),(3608,'Славута','Slavuta','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(1205,'Славутич','Slavutych','Киевская область','Ukraine',804,'Europe/Kiev'),(3411,'Славяносербск','Slavianoserbsk','Луганская область','Ukraine',804,'Europe/Kiev'),(139,'Славянск','Sloviansk','Донецкая область','Ukraine',804,'Europe/Kiev'),(75,'Смела','Smila Ukraine','Черкасская область','Ukraine',804,'Europe/Kiev'),(1206,'Снежное','Snizhne','Донецкая область','Ukraine',804,'Europe/Kiev'),(3327,'Снятын','Sniatyn','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3132,'Советский','Sovetskiy','','Ukraine',804,'Europe/Kiev'),(3438,'Сокаль','Sokal','Львовская область','Ukraine',804,'Europe/Kiev'),(3663,'Сокиряны','Sokyriany','Черновицкая область','Ukraine',804,'Europe/Kiev'),(13605,'Соледар','Soledar','','Ukraine',804,'Europe/Kiev'),(3650,'Сосница','Sosnica','Черниговская область','Ukraine',804,'Europe/Kiev'),(3352,'Ставище','Stavishe','Киевская область','Ukraine',804,'Europe/Kiev'),(3412,'Станично-Луганское','Stanichno-Luganskoe','Луганская область','Ukraine',804,'Europe/Kiev'),(3175,'Старая Выжевка','Staraya Vigevka','Волынская область','Ukraine',804,'Europe/Kiev'),(3609,'Старая Синява','Staraya Siniava','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3413,'Старобельск','Starobilsk','Луганская область','Ukraine',804,'Europe/Kiev'),(3249,'Старобешево','Starobeshevo','Донецкая область','Ukraine',804,'Europe/Kiev'),(3610,'Староконстантинов','Starokostiantyniv','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(13607,'Старый Крым','Staryi Krym','','Ukraine',804,'Europe/Kiev'),(3439,'Старый Самбор','Staryi Sambir','Львовская область','Ukraine',804,'Europe/Kiev'),(141,'Стаханов','Stakhanov Ukraine','Луганская область','Ukraine',804,'Europe/Kiev'),(1207,'Сторожинец','Storozhynets','Черновицкая область','Ukraine',804,'Europe/Kiev'),(140,'Стрый','Stryi','Львовская область','Ukraine',804,'Europe/Kiev'),(3440,'Стрый','Striy','Львовская область','Ukraine',804,'Europe/Kiev'),(59,'Судак','Sudak','Крым','Ukraine',804,'Europe/Kiev'),(4,'Сумы','Sumy','Сумская область','Ukraine',804,'Europe/Kiev'),(13613,'Счастье','Shchastia','','Ukraine',804,'Europe/Kiev'),(13593,'Таврийск','Tavriisk','','Ukraine',804,'Europe/Kiev'),(3652,'Талалаевка','Talalaevka','Черниговская область','Ukraine',804,'Europe/Kiev'),(3627,'Тальное','Talne','Черкасская область','Ukraine',804,'Europe/Kiev'),(3353,'Тараща','Tarascha','Киевская область','Ukraine',804,'Europe/Kiev'),(3481,'Тарутино','Tarutino','Одесская область','Ukraine',804,'Europe/Kiev'),(3482,'Татарбунары','Tatarbunary','Одесская область','Ukraine',804,'Europe/Kiev'),(3250,'Тельманово','Telymanovo','Донецкая область','Ukraine',804,'Europe/Kiev'),(3611,'Теофиполь','Teofipoly','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3155,'Теплик','Teplik','Винницкая область','Ukraine',804,'Europe/Kiev'),(13595,'Теплогорск','Teplohirsk','','Ukraine',804,'Europe/Kiev'),(13597,'Теплодар','Teplodar','','Ukraine',804,'Europe/Kiev'),(3551,'Теребовля','Terebovlia','Тернопольская область','Ukraine',804,'Europe/Kiev'),(13599,'Терновка','Ternivka','','Ukraine',804,'Europe/Kiev'),(13,'Тернополь','Ternopil','Тернопольская область','Ukraine',804,'Europe/Kiev'),(260,'Тетерев','Teteriv','Житомирская область','Ukraine',804,'Europe/Kiev'),(3354,'Тетиев','Tetiiv','Киевская область','Ukraine',804,'Europe/Kiev'),(3328,'Тлумач','Tlumach','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3306,'Токмак','Tokmak','Запорожская область','Ukraine',804,'Europe/Kiev'),(3206,'Томаковка','Tomakova','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3156,'Томашполь','Tmashpoly','Винницкая область','Ukraine',804,'Europe/Kiev'),(1208,'Торез','Torez','Донецкая область','Ukraine',804,'Europe/Kiev'),(3414,'Троицкое','Troichkoe','Луганская область','Ukraine',804,'Europe/Kiev'),(3157,'Тростянец','Trostianec','Винницкая область','Ukraine',804,'Europe/Kiev'),(3205,'Трохимброд','Sofievka','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(142,'Трускавец','Truskavets','Львовская область','Ukraine',804,'Europe/Kiev'),(3158,'Тульчин','Tulchyn','Винницкая область','Ukraine',804,'Europe/Kiev'),(3176,'Турийск','Turiysk','Волынская область','Ukraine',804,'Europe/Kiev'),(261,'Турка','Turka','Львовская область','Ukraine',804,'Europe/Kiev'),(3286,'Тячев','Tiachiv','Закарпатская область','Ukraine',804,'Europe/Kiev'),(13585,'Угледар','Vuhledar','','Ukraine',804,'Europe/Kiev'),(30,'Ужгород','Uzhhorod','Закарпатская область','Ukraine',804,'Europe/Kiev'),(13434,'Украинка','Ukrainka','','Ukraine',804,'Europe/Kiev'),(3371,'Ульяновка','Ulyanovka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(76,'Умань','Uman','Черкасская область','Ukraine',804,'Europe/Kiev'),(3372,'Устиновка','Ustinovka','Кировоградская область','Ukraine',804,'Europe/Kiev'),(1211,'Фастов','Fastiv','Киевская область','Ukraine',804,'Europe/Kiev'),(43,'Феодосия','Feodosiya','Крым','Ukraine',804,'Europe/Kiev'),(143,'Форос','Foros','Крым','Ukraine',804,'Europe/Kiev'),(3483,'Фрунзовка','Frunzovka','Одесская область','Ukraine',804,'Europe/Kiev'),(3251,'Харцызск','Khartsyzk','Донецкая область','Ukraine',804,'Europe/Kiev'),(19,'Харьков','Kharkiv','Харьковская область','Ukraine',804,'Europe/Kiev'),(8,'Херсон','Kherson','Херсонская область','Ukraine',804,'Europe/Kiev'),(262,'Хмельник','Khmilnyk','Винницкая область','Ukraine',804,'Europe/Kiev'),(12,'Хмельницкий','Khmelnytskyi','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3503,'Хорол','Khorol','Полтавская область','Ukraine',804,'Europe/Kiev'),(144,'Хотин','Khotyn','Черновицкая область','Ukraine',804,'Europe/Kiev'),(3628,'Христиновка','Khrystynivka','Черкасская область','Ukraine',804,'Europe/Kiev'),(263,'Хуст','Khust','Закарпатская область','Ukraine',804,'Europe/Kiev'),(3207,'Царичанка','Carichanka','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3591,'Цюрупинск','Tsiurupynsk','Херсонская область','Ukraine',804,'Europe/Kiev'),(3592,'Чаплинка','Caplinka','Херсонская область','Ukraine',804,'Europe/Kiev'),(264,'Чаплино','Chaplyno','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3612,'Чемеровцы','Chemerovcy','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3275,'Червоноармейск','Chernoarmeysk','Житомирская область','Ukraine',804,'Europe/Kiev'),(145,'Червоноград','Chervonohrad','Львовская область','Ukraine',804,'Europe/Kiev'),(2,'Черкассы','Cherkasy','Черкасская область','Ukraine',804,'Europe/Kiev'),(5,'Чернигов','Chernihiv','Черниговская область','Ukraine',804,'Europe/Kiev'),(3307,'Черниговка','Chernigovka','Запорожская область','Ukraine',804,'Europe/Kiev'),(3629,'Чернобай','Chernobay','Черкасская область','Ukraine',804,'Europe/Kiev'),(36,'Чернобыль','Chernobyl','Киевская область','Ukraine',804,'Europe/Kiev'),(9,'Черновцы','Chernivtsi','Черновицкая область','Ukraine',804,'Europe/Kiev'),(44,'Черноморское','Chornomorske','Крым','Ukraine',804,'Europe/Kiev'),(3504,'Чернухи','Chernuhy','Полтавская область','Ukraine',804,'Europe/Kiev'),(3276,'Черняхов','Cherniahov','Житомирская область','Ukraine',804,'Europe/Kiev'),(3160,'Чечельник','Chechelnik','Винницкая область','Ukraine',804,'Europe/Kiev'),(265,'Чигирин','Chyhyryn','Черкасская область','Ukraine',804,'Europe/Kiev'),(3287,'Чоп','Chop','Закарпатская область','Ukraine',804,'Europe/Kiev'),(266,'Чортков','Chortkiv','Тернопольская область','Ukraine',804,'Europe/Kiev'),(3552,'Чортков','Cortkov','Тернопольская область','Ukraine',804,'Europe/Kiev'),(166,'Чугуев','Chuhuiv','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3277,'Чуднов','Chudnov','Житомирская область','Ukraine',804,'Europe/Kiev'),(3505,'Чутово','Chutovo','Полтавская область','Ukraine',804,'Europe/Kiev'),(3161,'Шаргород','Sharhorod','Винницкая область','Ukraine',804,'Europe/Kiev'),(146,'Шахтёрск','Shakhtarsk','Донецкая область','Ukraine',804,'Europe/Kiev'),(3177,'Шацк','Shatsk','Волынская область','Ukraine',804,'Europe/Kiev'),(3576,'Шевченково','Shevchenkove','Харьковская область','Ukraine',804,'Europe/Kiev'),(167,'Шепетовка','Shepetivka','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3208,'Широкое','Shirikoe','Днепропетровская область','Ukraine',804,'Europe/Kiev'),(3484,'Ширяево','Shiriaevo','Одесская область','Ukraine',804,'Europe/Kiev'),(3506,'Шишаки','Shishaky','Полтавская область','Ukraine',804,'Europe/Kiev'),(147,'Шостка','Shostka','Сумская область','Ukraine',804,'Europe/Kiev'),(3630,'Шпола','Shpola','Черкасская область','Ukraine',804,'Europe/Kiev'),(3553,'Шумск','Shumsk','Тернопольская область','Ukraine',804,'Europe/Kiev'),(1213,'Щёлкино','Shcholkine','Крым','Ukraine',804,'Europe/Kiev'),(79,'Щорс','Schors','Черниговская область','Ukraine',804,'Europe/Kiev'),(148,'Энергодар','Enerhodar','Запорожская область','Ukraine',804,'Europe/Kiev'),(149,'Южноукраинск','Yuzhnoukrainsk','Николаевская область','Ukraine',804,'Europe/Kiev'),(3442,'Яворов','Yavoriv','Львовская область','Ukraine',804,'Europe/Kiev'),(37,'Яготин','Yahotyn','Киевская область','Ukraine',804,'Europe/Kiev'),(21,'Ялта','Yalta','Крым','Ukraine',804,'Europe/Kiev'),(3162,'Ямполь','Yampil Vinnytsia Oblast','Винницкая область','Ukraine',804,'Europe/Kiev'),(150,'Яремча','Yaremche','Ивано-Франковская область','Ukraine',804,'Europe/Kiev'),(3613,'Ярмолинцы','Iarmolincy','Хмельницкая область','Ukraine',804,'Europe/Kiev'),(3252,'Ясиноватая','Yasynuvata','Донецкая область','Ukraine',804,'Europe/Kiev'),(54,'Ясиня','Yasnya','Закарпатская область','Ukraine',804,'Europe/Kiev'),(87095,'Вааса','Vaasa','','Finland',246,'Europe/Helsinki'),(87096,'Вантаа','Vantaa','','Finland',246,'Europe/Helsinki'),(87097,'Варкаус','Varkaus','','Finland',246,'Europe/Helsinki'),(87034,'Иматра','Imatra','','Finland',246,'Europe/Helsinki'),(87048,'Каяани','Kajaani','','Finland',246,'Europe/Helsinki'),(87051,'Кеми','Kemi','','Finland',246,'Europe/Moscow'),(87055,'Коккола','Kokkola','','Finland',246,'Europe/Helsinki'),(87057,'Куопио','Kuopio','','Finland',246,'Europe/Helsinki'),(87062,'Лахти','Lahti','','Finland',246,'Europe/Helsinki'),(87069,'Миккели','Mikkeli','','Finland',246,'Europe/Helsinki'),(87074,'Оулу','Oulu','','Finland',246,'Europe/Helsinki'),(87076,'Порвоо','Porvoo','','Finland',246,'Europe/Helsinki'),(87075,'Пори','Pori','','Finland',246,'Europe/Helsinki'),(87078,'Раахе','Raahe','','Finland',246,'Europe/Helsinki'),(87081,'Рованиеми','Rovaniemi','','Finland',246,'Europe/Helsinki'),(87085,'Савонлинна','Savonlinna','','Finland',246,'Europe/Helsinki'),(87084,'Сало','Salo','','Finland',246,'Europe/Helsinki'),(87088,'Светогорск','Svetogorsk','','Finland',246,'Europe/Moscow'),(87091,'Турку','Turku','','Finland',246,'Europe/Helsinki'),(87029,'Хельсинки','Helsinki','','Finland',246,'Europe/Helsinki'),(87027,'Эспоо','Espoo','','Finland',246,'Europe/Helsinki'),(87040,'Ювяскюля','Jyvaskyla','','Finland',246,'Europe/Helsinki'),(41159,'Ablis','Ablis','','France',250,'Europe/Paris'),(41161,'Ablon-sur-Seine','Ablon-sur-Seine','','France',250,'Europe/Paris'),(41163,'Abrest','Abrest','','France',250,'Europe/Paris'),(41165,'Abscon','Abscon','','France',250,'Europe/Paris'),(41155,'Abzac','Abzac','','France',250,'Europe/Paris'),(41553,'Achenheim','Achenheim','','France',250,'Europe/Paris'),(41557,'Acheres','Acheres','','France',250,'Europe/Paris'),(41555,'Achicourt','Achicourt','','France',250,'Europe/Paris'),(41523,'Acigne','Acigne','','France',250,'Europe/Paris'),(41201,'Agde','Agde','','France',250,'Europe/Paris'),(41339,'Agnetz','Agnetz','','France',250,'Europe/Paris'),(41351,'Agny','Agny','','France',250,'Europe/Paris'),(41551,'Ahun','Ahun','','France',250,'Africa/Lagos'),(41599,'Aiffres','Aiffres','','France',250,'Europe/Paris'),(41577,'Aiguefonde','Aiguefonde','','France',250,'Europe/Paris'),(41575,'Aigueperse','Aigueperse','','France',250,'Europe/Paris'),(41569,'Aigues-Vives','Aigues-Vives','','France',250,'Europe/Paris'),(41589,'Ailly-sur-Somme','Ailly-sur-Somme','','France',250,'Europe/Paris'),(41591,'Aimargues','Aimargues','','France',250,'Europe/Paris'),(41597,'Airaines','Airaines','','France',250,'Europe/Paris'),(41595,'Airvault','Airvault','','France',250,'Europe/Paris'),(87250,'AIX','Aix','','France',250,'Europe/Paris'),(41241,'Albens','Albens','','France',250,'Europe/Paris'),(41249,'Albias','Albias','','France',250,'Europe/Paris'),(41245,'Alby-sur-Cheran','Alby-sur-Cheran','','France',250,'Europe/Paris'),(41239,'Ales','Ales','','France',250,'Europe/Paris'),(41259,'Alfortville','Alfortville','','France',250,'Europe/Paris'),(41251,'Algrange','Algrange','','France',250,'Europe/Paris'),(41221,'Alixan','Alixan','','France',250,'Europe/Paris'),(41665,'Allan','Allan','','France',250,'Europe/Paris'),(41223,'Allassac','Allassac','','France',250,'Europe/Paris'),(41231,'Allennes-les-Marais','Allennes-les-Marais','','France',250,'Europe/Paris'),(41225,'Allevard','Allevard','','France',250,'Europe/Paris'),(41227,'Allex','Allex','','France',250,'Europe/Paris'),(41229,'Allinges','Allinges','','France',250,'Europe/Paris'),(41235,'Allonnes','Allonnes','','France',250,'Europe/Paris'),(41237,'Allouagne','Allouagne','','France',250,'Europe/Paris'),(41255,'Alsting','Alsting','','France',250,'Europe/Paris'),(41265,'Amancy','Amancy','','France',250,'Europe/Paris'),(41261,'Amanvillers','Amanvillers','','France',250,'Europe/Paris'),(41269,'Ambazac','Ambazac','','France',250,'Europe/Paris'),(41267,'Ambes','Ambes','','France',250,'Europe/Paris'),(41275,'Ambierle','Ambierle','','France',250,'Europe/Paris'),(41277,'Amblainville','Amblainville','','France',250,'Europe/Paris'),(41279,'Ambleteuse','Ambleteuse','','France',250,'Europe/Paris'),(41285,'Amboise','Amboise','','France',250,'Europe/Paris'),(41281,'Ambronay','Ambronay','','France',250,'Europe/Paris'),(41303,'Amfreville-la-Mi-Voie','Amfreville-la-Mi-Voie','','France',250,'Europe/Paris'),(41291,'Amilly','Amilly','','France',250,'Europe/Paris'),(41293,'Ammerschwihr','Ammerschwihr','','France',250,'Europe/Paris'),(41295,'Amneville','Amneville','','France',250,'Europe/Paris'),(41301,'Amou','Amou','','France',250,'Africa/Niamey'),(41297,'Amplepuis','Amplepuis','','France',250,'Europe/Paris'),(41299,'Ampuis','Ampuis','','France',250,'Europe/Paris'),(41381,'Ancenis','Ancenis','','France',250,'Europe/Paris'),(41317,'Andard','Andard','','France',250,'Europe/Paris'),(41321,'Andernos-les-Bains','Andernos-les-Bains','','France',250,'Europe/Paris'),(41319,'Andeville','Andeville','','France',250,'Europe/Paris'),(41323,'Andilly','Andilly','','France',250,'Europe/Paris'),(41327,'Andolsheim','Andolsheim','','France',250,'Europe/Paris'),(41331,'Andresy','Andresy','','France',250,'Europe/Paris'),(41329,'Andreze','Andreze','','France',250,'Europe/Paris'),(41333,'Andrezieux-Boutheon','Andrezieux-Boutheon','','France',250,'Europe/Paris'),(41335,'Anduze','Anduze','','France',250,'Europe/Paris'),(41341,'Angers','Angers','','France',250,'Europe/Paris'),(41343,'Angerville','Angerville','','France',250,'Europe/Paris'),(41345,'Angicourt','Angicourt','','France',250,'Europe/Paris'),(41309,'Angles','Angles','','France',250,'Europe/Paris'),(41315,'Angoulins-sur-Mer','Angoulins-sur-Mer','','France',250,'Europe/Paris'),(41311,'Angres','Angres','','France',250,'Europe/Paris'),(41399,'Aniane','Aniane','','France',250,'Europe/Paris'),(41375,'Annay','Annay','','France',250,'Europe/Paris'),(41371,'Annecy-le-Vieux','Annecy-le-Vieux','','France',250,'Europe/Paris'),(41367,'Annemasse','Annemasse','','France',250,'Europe/Paris'),(41363,'Annequin','Annequin','','France',250,'Europe/Paris'),(41361,'Anneyron','Anneyron','','France',250,'Europe/Paris'),(41365,'Annoeullin','Annoeullin','','France',250,'Europe/Paris'),(41373,'Annonay','Annonay','','France',250,'Europe/Paris'),(41377,'Anor','Anor','','France',250,'Europe/Paris'),(41393,'Anould','Anould','','France',250,'Europe/Paris'),(41379,'Anse','Anse','','France',250,'Europe/Paris'),(41385,'Anthy-sur-Leman','Anthy-sur-Leman','','France',250,'Europe/Paris'),(41389,'Antony','Antony','','France',250,'Europe/Paris'),(41347,'Anzin','Anzin','','France',250,'Europe/Paris'),(41405,'Appoigny','Appoigny','','France',250,'Europe/Paris'),(41403,'Apprieu','Apprieu','','France',250,'Europe/Paris'),(41411,'Aramon','Aramon','','France',250,'Europe/Paris'),(41451,'Arc-les-Gray','Arc-les-Gray','','France',250,'Europe/Paris'),(41457,'Arcachon','Arcachon','','France',250,'Europe/Paris'),(41517,'Arches','Arches','','France',250,'Europe/Paris'),(41461,'Arconnay','Arconnay','','France',250,'Europe/Paris'),(41463,'Arcueil','Arcueil','','France',250,'Europe/Paris'),(41427,'Ardres','Ardres','','France',250,'Europe/Paris'),(41519,'Ares','Ares','','France',250,'America/Fortaleza'),(41435,'Argences','Argences','','France',250,'Europe/Paris'),(41423,'Argentan','Argentan','','France',250,'Europe/Paris'),(41443,'Argentre','Argentre','','France',250,'Europe/Paris'),(41473,'Armbouts-Cappel','Armbouts-Cappel','','France',250,'Europe/Paris'),(41477,'Arnage','Arnage','','France',250,'Europe/Paris'),(41475,'Arnas','Arnas','','France',250,'Europe/Paris'),(41479,'Arneke','Arneke','','France',250,'Europe/Paris'),(41487,'Aron','Aron','','France',250,'Europe/Paris'),(41489,'Arpajon','Arpajon','','France',250,'Europe/Paris'),(41459,'Arques','Arques','','France',250,'Europe/Paris'),(41495,'Arradon','Arradon','','France',250,'Europe/Paris'),(41497,'Arrou','Arrou','','France',250,'Europe/Paris'),(41499,'Arsac','Arsac','','France',250,'Europe/Paris'),(41503,'Arthes','Arthes','','France',250,'Europe/Paris'),(41511,'Artix','Artix','','France',250,'Europe/Paris'),(41521,'Arudy','Arudy','','France',250,'Europe/Paris'),(41421,'Arvert','Arvert','','France',250,'Europe/Paris'),(41419,'Arveyres','Arveyres','','France',250,'Europe/Paris'),(41527,'Assat','Assat','','France',250,'Europe/Paris'),(41529,'Asson','Asson','','France',250,'Europe/Paris'),(41531,'Astaffort','Astaffort','','France',250,'Europe/Paris'),(41535,'Athis-Mons','Athis-Mons','','France',250,'Europe/Paris'),(41539,'Attainville','Attainville','','France',250,'Europe/Paris'),(41543,'Attiches','Attiches','','France',250,'Europe/Paris'),(41545,'Attichy','Attichy','','France',250,'Europe/Paris'),(41603,'Aubais','Aubais','','France',250,'Europe/Paris'),(41615,'Auberchicourt','Auberchicourt','','France',250,'Europe/Paris'),(41613,'Aubergenville','Aubergenville','','France',250,'Europe/Paris'),(41631,'Aubers','Aubers','','France',250,'Europe/Paris'),(41611,'Aubervilliers','Aubervilliers','','France',250,'Europe/Paris'),(41629,'Aubiere','Aubiere','','France',250,'Europe/Paris'),(41619,'Aubigne-Racan','Aubigne-Racan','','France',250,'Europe/Paris'),(41621,'Aubigny','Aubigny','','France',250,'Europe/Paris'),(41607,'Aubin','Aubin','','France',250,'Europe/Paris'),(41625,'Aubord','Aubord','','France',250,'Europe/Paris'),(41627,'Auboue','Auboue','','France',250,'Europe/Paris'),(41633,'Aubusson','Aubusson','','France',250,'Europe/Paris'),(41617,'Auby','Auby','','France',250,'Europe/Paris'),(41657,'Aucamville','Aucamville','','France',250,'Europe/Paris'),(41639,'Audenge','Audenge','','France',250,'Europe/Paris'),(41641,'Audincourt','Audincourt','','France',250,'Europe/Paris'),(41645,'Audruicq','Audruicq','','France',250,'Europe/Paris'),(41707,'Auffargis','Auffargis','','France',250,'Europe/Paris'),(41683,'Augny','Augny','','France',250,'Europe/Paris'),(41667,'Aulnat','Aulnat','','France',250,'Europe/Paris'),(41673,'Aulnay','Aulnay','','France',250,'Europe/Paris'),(41675,'Aulnay-sous-Bois','Aulnay-sous-Bois','','France',250,'Europe/Paris'),(41669,'Aulnoy-lez-Valenciennes','Aulnoy-lez-Valenciennes','','France',250,'Europe/Paris'),(41685,'Auneau','Auneau','','France',250,'Europe/Paris'),(41681,'Auneuil','Auneuil','','France',250,'Europe/Paris'),(41691,'Aurec-sur-Loire','Aurec-sur-Loire','','France',250,'Europe/Paris'),(41689,'Aureilhan','Aureilhan','','France',250,'Europe/Paris'),(41697,'Aussillon','Aussillon','','France',250,'Europe/Paris'),(41699,'Aussonne','Aussonne','','France',250,'Europe/Paris'),(41701,'Auterive','Auterive','','France',250,'Europe/Paris'),(41703,'Autrans','Autrans','','France',250,'Europe/Paris'),(41637,'Auvers-sur-Oise','Auvers-sur-Oise','','France',250,'Europe/Paris'),(41655,'Auzielle','Auzielle','','France',250,'Europe/Paris'),(41167,'Avallon','Avallon','','France',250,'Europe/Paris'),(41169,'Avanne-Aveney','Avanne-Aveney','','France',250,'Europe/Paris'),(41173,'Avanton','Avanton','','France',250,'Europe/Paris'),(41175,'Avelin','Avelin','','France',250,'Europe/Paris'),(41171,'Avensan','Avensan','','France',250,'Europe/Paris'),(41181,'Avermes','Avermes','','France',250,'Europe/Paris'),(41179,'Avesnelles','Avesnelles','','France',250,'Europe/Paris'),(41177,'Avesnes-les-Aubert','Avesnes-les-Aubert','','France',250,'Europe/Paris'),(41189,'Avion','Avion','','France',250,'Europe/Madrid'),(41185,'Avize','Avize','','France',250,'Europe/Paris'),(41191,'Avon','Avon','','France',250,'America/Denver'),(41193,'Avord','Avord','','France',250,'Europe/Paris'),(41195,'Avoriaz','Avoriaz','','France',250,'Europe/Paris'),(41199,'Avrille','Avrille','','France',250,'Europe/Paris'),(41151,'Ax-les-Thermes','Ax-les-Thermes','','France',250,'Europe/Paris'),(41727,'Aytre','Aytre','','France',250,'Europe/Paris'),(41869,'Bachant','Bachant','','France',250,'Europe/Paris'),(41741,'Bagard','Bagard','','France',250,'Europe/Paris'),(41745,'Bage-la-Ville','Bage-la-Ville','','France',250,'Europe/Paris'),(41791,'Bagneux','Bagneux','','France',250,'Europe/Paris'),(41803,'Bagnolet','Bagnolet','','France',250,'Europe/Paris'),(41805,'Bagnols-sur-Ceze','Bagnols-sur-Ceze','','France',250,'Europe/Paris'),(41867,'Baho','Baho','','France',250,'Europe/Paris'),(41915,'Baillargues','Baillargues','','France',250,'Europe/Paris'),(41929,'Bailleul','Bailleul','','France',250,'Europe/Paris'),(41931,'Bailleul-sur-Therain','Bailleul-sur-Therain','','France',250,'Europe/Paris'),(41937,'Bailly','Bailly','','France',250,'Europe/Paris'),(41939,'Bailly-Romainvilliers','Bailly-Romainvilliers','','France',250,'Europe/Paris'),(41907,'Baixas','Baixas','','France',250,'Europe/Paris'),(41771,'Balan','Balan','','France',250,'Europe/Bucharest'),(41775,'Balaruc-le-Vieux','Balaruc-le-Vieux','','France',250,'Europe/Paris'),(41773,'Balaruc-les-Bains','Balaruc-les-Bains','','France',250,'Europe/Paris'),(41783,'Balbigny','Balbigny','','France',250,'Europe/Paris'),(41785,'Baldersheim','Baldersheim','','France',250,'Europe/Paris'),(41781,'Ballainvilliers','Ballainvilliers','','France',250,'Europe/Paris'),(41779,'Ballancourt-sur-Essonne','Ballancourt-sur-Essonne','','France',250,'Europe/Paris'),(41787,'Balma','Balma','','France',250,'Europe/Paris'),(41789,'Ban-Saint-Martin','Ban-Saint-Martin','','France',250,'Europe/Paris'),(41793,'Banyuls de la Marenda','Banyuls de la Marenda','','France',250,'Europe/Paris'),(41825,'Barbaste','Barbaste','','France',250,'Europe/Paris'),(41827,'Barbatre','Barbatre','','France',250,'Europe/Paris'),(41823,'Barbazan-Debat','Barbazan-Debat','','France',250,'Europe/Paris'),(41831,'Barberaz','Barberaz','','France',250,'Europe/Paris'),(41829,'Barbezieux-Saint-Hilaire','Barbezieux-Saint-Hilaire','','France',250,'Europe/Paris'),(41833,'Barby','Barby','','France',250,'Europe/Berlin'),(41837,'Barjac','Barjac','','France',250,'Europe/Paris'),(41839,'Barlin','Barlin','','France',250,'Europe/Berlin'),(41843,'Barr','Barr','','France',250,'Europe/Paris'),(41845,'Barraux','Barraux','','France',250,'Europe/Paris'),(41847,'Barsac','Barsac','','France',250,'Europe/Paris'),(41849,'Bart','Bart','','France',250,'Europe/Paris'),(41853,'Basse-Ham','Basse-Ham','','France',250,'Europe/Paris'),(41857,'Bassens','Bassens','','France',250,'Europe/Paris'),(42133,'Bauge','Bauge','','France',250,'Europe/Paris'),(42165,'Baule','Baule','','France',250,'Europe/Paris'),(42121,'Bauvin','Bauvin','','France',250,'Europe/Paris'),(41731,'Bavans','Bavans','','France',250,'Europe/Paris'),(41733,'Bavent','Bavent','','France',250,'Europe/Paris'),(41735,'Bavilliers','Bavilliers','','France',250,'Europe/Paris'),(41749,'Bazancourt','Bazancourt','','France',250,'Europe/Paris'),(41747,'Bazas','Bazas','','France',250,'Europe/Paris'),(41753,'Bazemont','Bazemont','','France',250,'Europe/Paris'),(41755,'Baziege','Baziege','','France',250,'Europe/Paris'),(42151,'Beaucourt','Beaucourt','','France',250,'Europe/Paris'),(42149,'Beaucouze','Beaucouze','','France',250,'Europe/Paris'),(42135,'Beaujeu','Beaujeu','','France',250,'Europe/Paris'),(42153,'Beaulieu','Beaulieu','','France',250,'Europe/Paris'),(42169,'Beaulieu-sur-Mer','Beaulieu-sur-Mer','','France',250,'Europe/Paris'),(42161,'Beaulon','Beaulon','','France',250,'Europe/Paris'),(42173,'Beaumont','Beaumont','','France',250,'America/Chicago'),(42231,'Beaupreau','Beaupreau','','France',250,'Europe/Paris'),(42119,'Beauval','Beauval','','France',250,'Europe/Paris'),(42117,'Beauvallon','Beauvallon','','France',250,'Europe/Paris'),(42127,'Beauvoir-sur-Mer','Beauvoir-sur-Mer','','France',250,'Europe/Paris'),(42123,'Beauvois-en-Cambresis','Beauvois-en-Cambresis','','France',250,'Europe/Paris'),(42125,'Beauvoisin','Beauvoisin','','France',250,'Europe/Paris'),(42139,'Beauzac','Beauzac','','France',250,'Europe/Paris'),(42141,'Beauzelle','Beauzelle','','France',250,'Europe/Paris'),(41881,'Begles','Begles','','France',250,'Europe/Paris'),(41951,'Belbeuf','Belbeuf','','France',250,'Europe/Paris'),(41911,'Beligneux','Beligneux','','France',250,'Europe/Paris'),(41909,'Belin-Beliet','Belin-Beliet','','France',250,'Europe/Paris'),(41923,'Bellegarde','Bellegarde','','France',250,'Europe/Paris'),(41917,'Belleu','Belleu','','France',250,'Europe/Paris'),(41921,'Belleville-sur-Meuse','Belleville-sur-Meuse','','France',250,'Europe/Paris'),(41927,'Belley','Belley','','France',250,'Europe/Paris'),(41967,'Benejacq','Benejacq','','France',250,'Europe/Paris'),(41965,'Benet','Benet','','France',250,'Europe/Paris'),(41971,'Bennecourt','Bennecourt','','France',250,'Europe/Paris'),(41975,'Benouville','Benouville','','France',250,'Europe/Paris'),(41983,'Bergerac','Bergerac','','France',250,'Europe/Paris'),(41981,'Bergheim','Bergheim','','France',250,'Europe/Berlin'),(41987,'Berlaimont','Berlaimont','','France',250,'Europe/Paris'),(41995,'Bernieres-sur-Mer','Bernieres-sur-Mer','','France',250,'Europe/Paris'),(41991,'Bernin','Bernin','','France',250,'Europe/Paris'),(41993,'Bernis','Bernis','','France',250,'Europe/Paris'),(41997,'Bersee','Bersee','','France',250,'Europe/Paris'),(41999,'Berson','Berson','','France',250,'Europe/Paris'),(42001,'Berstett','Berstett','','France',250,'Europe/Paris'),(42003,'Bertrange','Bertrange','','France',250,'Europe/Luxembourg'),(42005,'Bertry','Bertry','','France',250,'Europe/Paris'),(42009,'Bessan','Bessan','','France',250,'Europe/Paris'),(42011,'Bessancourt','Bessancourt','','France',250,'Europe/Paris'),(42013,'Besseges','Besseges','','France',250,'Europe/Paris'),(42017,'Bessenay','Bessenay','','France',250,'Europe/Paris'),(42019,'Bessieres','Bessieres','','France',250,'Europe/Paris'),(42021,'Betheny','Betheny','','France',250,'Europe/Paris'),(42023,'Bethisy-Saint-Pierre','Bethisy-Saint-Pierre','','France',250,'Europe/Paris'),(42025,'Bethoncourt','Bethoncourt','','France',250,'Europe/Paris'),(42033,'Betschdorf','Betschdorf','','France',250,'Europe/Paris'),(42029,'Betton','Betton','','France',250,'Europe/Paris'),(41875,'Beuvrages','Beuvrages','','France',250,'Europe/Paris'),(41877,'Beuvry','Beuvry','','France',250,'Europe/Paris'),(41899,'Beynes','Beynes','','France',250,'Europe/Paris'),(41901,'Beynost','Beynost','','France',250,'Europe/Paris'),(41893,'Bezons','Bezons','','France',250,'Europe/Paris'),(41895,'Bezouce','Bezouce','','France',250,'Europe/Paris'),(42035,'Bienville','Bienville','','France',250,'America/Chicago'),(42047,'Bierne','Bierne','','France',250,'Europe/Paris'),(42049,'Biesheim','Biesheim','','France',250,'Europe/Paris'),(42045,'Bievres','Bievres','','France',250,'Europe/Paris'),(42039,'Biganos','Biganos','','France',250,'Europe/Paris'),(42041,'Biguglia','Biguglia','','France',250,'Europe/Paris'),(42067,'Bihorel','Bihorel','','France',250,'Europe/Paris'),(42079,'Billere','Billere','','France',250,'Europe/Paris'),(42057,'Billom','Billom','','France',250,'Europe/Paris'),(42053,'Billy-Berclau','Billy-Berclau','','France',250,'Europe/Paris'),(42055,'Billy-Montigny','Billy-Montigny','','France',250,'Europe/Paris'),(42059,'Binic','Binic','','France',250,'Europe/Paris'),(42063,'Biot','Biot','','France',250,'Europe/Paris'),(42065,'Biscarrosse','Biscarrosse','','France',250,'Europe/Paris'),(42075,'Bischoffsheim','Bischoffsheim','','France',250,'Europe/Paris'),(42069,'Bitschwiller-les-Thann','Bitschwiller-les-Thann','','France',250,'Europe/Paris'),(42037,'Biviers','Biviers','','France',250,'Europe/Paris'),(42097,'Blainville-sur-Orne','Blainville-sur-Orne','','France',250,'Europe/Paris'),(42089,'Blanquefort','Blanquefort','','France',250,'Europe/Paris'),(42085,'Blanzat','Blanzat','','France',250,'Europe/Paris'),(42087,'Blanzy','Blanzy','','France',250,'Europe/Paris'),(42093,'Blaringhem','Blaringhem','','France',250,'Europe/Paris'),(42105,'Blaye','Blaye','','France',250,'Europe/London'),(42081,'Blendecques','Blendecques','','France',250,'Europe/Paris'),(42107,'Blere','Blere','','France',250,'Europe/Paris'),(42113,'Boe','Boe','','France',250,'America/La_Paz'),(42159,'Bollwiller','Bollwiller','','France',250,'Europe/Paris'),(42189,'Bompas','Bompas','','France',250,'Europe/Paris'),(42197,'Bon-Encontre','Bon-Encontre','','France',250,'Europe/Paris'),(42229,'Bonchamp-les-Laval','Bonchamp-les-Laval','','France',250,'Europe/Paris'),(42201,'Bondoufle','Bondoufle','','France',250,'Europe/Paris'),(42203,'Bondues','Bondues','','France',250,'Europe/Paris'),(42199,'Bondy','Bondy','','France',250,'Europe/Paris'),(42219,'Bonnelles','Bonnelles','','France',250,'Europe/Paris'),(42209,'Bonnes','Bonnes','','France',250,'Europe/Paris'),(42221,'Bonnetable','Bonnetable','','France',250,'Europe/Paris'),(42217,'Bonneuil-sur-Marne','Bonneuil-sur-Marne','','France',250,'Europe/Paris'),(42211,'Bonneval','Bonneval','','France',250,'America/Chicago'),(42213,'Bonneville','Bonneville','','France',250,'America/Boise'),(42195,'Bons-en-Chablais','Bons-en-Chablais','','France',250,'Europe/Paris'),(42227,'Bonson','Bonson','','France',250,'Europe/Paris'),(42111,'Boos','Boos','','France',250,'Europe/Berlin'),(42235,'Boran-sur-Oise','Boran-sur-Oise','','France',250,'Europe/Paris'),(42237,'Borgo','Borgo','','France',250,'Europe/Paris'),(92527,'GAP','Gap','','France',250,'Europe/Paris'),(92837,'Germ','Germ','','France',250,'Europe/Berlin'),(40489,'Ibos','Ibos','','France',250,'Europe/Paris'),(40499,'Idron','Idron','','France',250,'Europe/Paris'),(40557,'Iffendic','Iffendic','','France',250,'Europe/Paris'),(40555,'Ifs','Ifs','','France',250,'Europe/Paris'),(40529,'Igny','Igny','','France',250,'Europe/Paris'),(40497,'Igoville','Igoville','','France',250,'Europe/Paris'),(40511,'Illange','Illange','','France',250,'Europe/Paris'),(40521,'Ille-sur-Tet','Ille-sur-Tet','','France',250,'Europe/Paris'),(40517,'Illfurth','Illfurth','','France',250,'Europe/Paris'),(40515,'Illkirch-Graffenstaden','Illkirch-Graffenstaden','','France',250,'Europe/Paris'),(40513,'Illzach','Illzach','','France',250,'Europe/Paris'),(40559,'Imphy','Imphy','','France',250,'Europe/Paris'),(40485,'Ingrandes','Ingrandes','','France',250,'Europe/Paris'),(40483,'Ingre','Ingre','','France',250,'Europe/Paris'),(40523,'Inguiniel','Inguiniel','','France',250,'Europe/Paris'),(40481,'Ingwiller','Ingwiller','','France',250,'Europe/Paris'),(40533,'Irodouer','Irodouer','','France',250,'Europe/Paris'),(40487,'Is-sur-Tille','Is-sur-Tille','','France',250,'Europe/Paris'),(40537,'Isbergues','Isbergues','','France',250,'Europe/Paris'),(40503,'Isigny-le-Buat','Isigny-le-Buat','','France',250,'Europe/Paris'),(40505,'Isigny-sur-Mer','Isigny-sur-Mer','','France',250,'Europe/Paris'),(40519,'Isle','Isle','','France',250,'Europe/Paris'),(40531,'Isneauville','Isneauville','','France',250,'Europe/Paris'),(40535,'Isse','Isse','','France',250,'Europe/Paris'),(40543,'Issoire','Issoire','','France',250,'Europe/Paris'),(40541,'Issou','Issou','','France',250,'Europe/Paris'),(40545,'Issoudun','Issoudun','','France',250,'Europe/Paris'),(40547,'Iteuil','Iteuil','','France',250,'Europe/Paris'),(40551,'Ittenheim','Ittenheim','','France',250,'Europe/Paris'),(40553,'Itteville','Itteville','','France',250,'Europe/Paris'),(40549,'Itxassou','Itxassou','','France',250,'Europe/Paris'),(40493,'Ivry-sur-Seine','Ivry-sur-Seine','','France',250,'Europe/Paris'),(40495,'Iwuy','Iwuy','','France',250,'Europe/Paris'),(40507,'Izeaux','Izeaux','','France',250,'Europe/Paris'),(40501,'Izernore','Izernore','','France',250,'Europe/Paris'),(40509,'Izon','Izon','','France',250,'Europe/Paris'),(40563,'Jacob-Bellecombette','Jacob-Bellecombette','','France',250,'Europe/Paris'),(40565,'Jacou','Jacou','','France',250,'Europe/Paris'),(40567,'Jallais','Jallais','','France',250,'Europe/Paris'),(40569,'Janville','Janville','','France',250,'Europe/Paris'),(40571,'Janville-sur-Juine','Janville-sur-Juine','','France',250,'Europe/Paris'),(40573,'Janze','Janze','','France',250,'Europe/Paris'),(40579,'Jard-sur-Mer','Jard-sur-Mer','','France',250,'Europe/Paris'),(40581,'Jardin','Jardin','','France',250,'America/Bogota'),(40577,'Jargeau','Jargeau','','France',250,'Europe/Paris'),(40583,'Jarnac','Jarnac','','France',250,'Europe/Paris'),(40585,'Jarny','Jarny','','France',250,'Europe/Paris'),(40587,'Jarrie','Jarrie','','France',250,'Europe/Paris'),(40575,'Jarville-la-Malgrange','Jarville-la-Malgrange','','France',250,'Europe/Paris'),(40589,'Jassans-Riottier','Jassans-Riottier','','France',250,'Europe/Paris'),(40605,'Jaunay-Clan','Jaunay-Clan','','France',250,'Europe/Paris'),(40595,'Jaux','Jaux','','France',250,'Europe/Paris'),(40561,'Javene','Javene','','France',250,'Europe/Paris'),(40591,'Jeumont','Jeumont','','France',250,'Europe/Paris'),(40593,'Joeuf','Joeuf','','France',250,'Europe/Paris'),(40617,'Joigny','Joigny','','France',250,'Europe/Paris'),(40613,'Joinville','Joinville','','France',250,'America/Sao_Paulo'),(40615,'Joinville-le-Pont','Joinville-le-Pont','','France',250,'Europe/Paris'),(40597,'Jonage','Jonage','','France',250,'Europe/Paris'),(40603,'Jonchery-sur-Vesle','Jonchery-sur-Vesle','','France',250,'Europe/Paris'),(40601,'Jonquieres-Saint-Vincent','Jonquieres-Saint-Vincent','','France',250,'Europe/Paris'),(40599,'Jonzac','Jonzac','','France',250,'Europe/Paris'),(40607,'Josselin','Josselin','','France',250,'Europe/Paris'),(40621,'Jouarre','Jouarre','','France',250,'Europe/Paris'),(40619,'Jouars-Pontchartrain','Jouars-Pontchartrain','','France',250,'Europe/Paris'),(40609,'Joue-les-Tours','Joue-les-Tours','','France',250,'Europe/Paris'),(40611,'Joue-sur-Erdre','Joue-sur-Erdre','','France',250,'Europe/Paris'),(40623,'Jouy','Jouy','','France',250,'Europe/Paris'),(40629,'Jouy-aux-Arches','Jouy-aux-Arches','','France',250,'Europe/Paris'),(40633,'Jouy-en-Josas','Jouy-en-Josas','','France',250,'Europe/Paris'),(40627,'Jouy-le-Chatel','Jouy-le-Chatel','','France',250,'Europe/Paris'),(40625,'Jouy-le-Moutier','Jouy-le-Moutier','','France',250,'Europe/Paris'),(40631,'Jouy-sur-Morin','Jouy-sur-Morin','','France',250,'Europe/Paris'),(40643,'Joyeuse','Joyeuse','','France',250,'Europe/Paris'),(40665,'Juan-les-Pins','Juan-les-Pins','','France',250,'Europe/Paris'),(40653,'Juigne-sur-Loire','Juigne-sur-Loire','','France',250,'Europe/Paris'),(40647,'Juillan','Juillan','','France',250,'Europe/Paris'),(40649,'Juilly','Juilly','','France',250,'Europe/Paris'),(40641,'Jujurieux','Jujurieux','','France',250,'Europe/Paris'),(40655,'Jullouville','Jullouville','','France',250,'Europe/Paris'),(40635,'Jumelles','Jumelles','','France',250,'Europe/Paris'),(40657,'Jumieges','Jumieges','','France',250,'Europe/Paris'),(40659,'Jurancon','Jurancon','','France',250,'Europe/Paris'),(40661,'Jussac','Jussac','','France',250,'Europe/Paris'),(40663,'Jussey','Jussey','','France',250,'Europe/Paris'),(40639,'Juvignac','Juvignac','','France',250,'Europe/Paris'),(40637,'Juvisy-sur-Orge','Juvisy-sur-Orge','','France',250,'Europe/Paris'),(40645,'Juziers','Juziers','','France',250,'Europe/Paris'),(98269,'NAnt','Nant','','France',250,'Europe/Paris'),(41001,'Oberbronn','Oberbronn','','France',250,'Europe/Paris'),(40999,'Oberhaslach','Oberhaslach','','France',250,'Europe/Paris'),(41007,'Oberhausbergen','Oberhausbergen','','France',250,'Europe/Paris'),(41009,'Oberhoffen-sur-Moder','Oberhoffen-sur-Moder','','France',250,'Europe/Paris'),(41003,'Obermodern-Zutzendorf','Obermodern-Zutzendorf','','France',250,'Europe/Paris'),(41005,'Obernai','Obernai','','France',250,'Europe/Paris'),(41011,'Oberschaeffolsheim','Oberschaeffolsheim','','France',250,'Europe/Paris'),(41013,'Objat','Objat','','France',250,'Europe/Paris'),(41023,'Octeville-sur-Mer','Octeville-sur-Mer','','France',250,'Europe/Paris'),(41015,'Odos','Odos','','France',250,'Europe/Paris'),(41147,'Oeyreluy','Oeyreluy','','France',250,'Europe/Paris'),(41117,'Offemont','Offemont','','France',250,'Europe/Paris'),(41119,'Offranville','Offranville','','France',250,'Europe/Paris'),(41123,'Oignies','Oignies','','France',250,'Europe/Paris'),(41129,'Oissel','Oissel','','France',250,'Europe/Paris'),(41127,'Oissery','Oissery','','France',250,'Europe/Paris'),(41025,'Olemps','Olemps','','France',250,'Europe/Paris'),(41027,'Olivet','Olivet','','France',250,'America/Chicago'),(41029,'Ollainville','Ollainville','','France',250,'Europe/Paris'),(41033,'Olonne-sur-Mer','Olonne-sur-Mer','','France',250,'Europe/Paris'),(41031,'Olonzac','Olonzac','','France',250,'Europe/Paris'),(41035,'Ondres','Ondres','','France',250,'Europe/Paris'),(41041,'Onnaing','Onnaing','','France',250,'Europe/Paris'),(41037,'Onzain','Onzain','','France',250,'Europe/Paris'),(41043,'Oradour-sur-Vayres','Oradour-sur-Vayres','','France',250,'Europe/Paris'),(41049,'Orbec','Orbec','','France',250,'Europe/Paris'),(41047,'Orbey','Orbey','','France',250,'Europe/Paris'),(41085,'Orcet','Orcet','','France',250,'Europe/Paris'),(41093,'Orchamps-Vennes','Orchamps-Vennes','','France',250,'Europe/Paris'),(41095,'Orchies','Orchies','','France',250,'Europe/Paris'),(41087,'Orcines','Orcines','','France',250,'Europe/Paris'),(41057,'Orgelet','Orgelet','','France',250,'Europe/Paris'),(41059,'Orgeres','Orgeres','','France',250,'Europe/Paris'),(41061,'Orgerus','Orgerus','','France',250,'Europe/Paris'),(41055,'Orgeval','Orgeval','','France',250,'Europe/Paris'),(41063,'Origny-Sainte-Benoite','Origny-Sainte-Benoite','','France',250,'Europe/Paris'),(41065,'Orleat','Orleat','','France',250,'Europe/Paris'),(41069,'Orleix','Orleix','','France',250,'Europe/Paris'),(41073,'Orlienas','Orlienas','','France',250,'Europe/Paris'),(41071,'Orly','Orly','','France',250,'Europe/Paris'),(41075,'Ormes','Ormes','','France',250,'Europe/Paris'),(41077,'Ormesson-sur-Marne','Ormesson-sur-Marne','','France',250,'Europe/Paris'),(41079,'Ornans','Ornans','','France',250,'Europe/Paris'),(41081,'Ornex','Ornex','','France',250,'Europe/Paris'),(41083,'Orry-la-Ville','Orry-la-Ville','','France',250,'Europe/Paris'),(41089,'Orsay','Orsay','','France',250,'Europe/Paris'),(41091,'Orthez','Orthez','','France',250,'Europe/Paris'),(41051,'Orval','Orval','','France',250,'Europe/Paris'),(41053,'Orvault','Orvault','','France',250,'Europe/Paris'),(41039,'Osny','Osny','','France',250,'Europe/Paris'),(41097,'Osseja','Osseja','','France',250,'Europe/Paris'),(41099,'Ossun','Ossun','','France',250,'Europe/Paris'),(41103,'Ostricourt','Ostricourt','','France',250,'Europe/Paris'),(41101,'Ostwald','Ostwald','','France',250,'Europe/Paris'),(41105,'Othis','Othis','','France',250,'Europe/Paris'),(41109,'Ottange','Ottange','','France',250,'Europe/Paris'),(41111,'Ottmarsheim','Ottmarsheim','','France',250,'Europe/Paris'),(41113,'Ottrott','Ottrott','','France',250,'Europe/Paris'),(41133,'Oudon','Oudon','','France',250,'Europe/Paris'),(41139,'Ouistreham','Ouistreham','','France',250,'Europe/Paris'),(41141,'Oullins','Oullins','','France',250,'Europe/Paris'),(41143,'Ouroux-sur-Saone','Ouroux-sur-Saone','','France',250,'Europe/Paris'),(41145,'Outarville','Outarville','','France',250,'Europe/Paris'),(41107,'Outreau','Outreau','','France',250,'Europe/Paris'),(41131,'Ouveillan','Ouveillan','','France',250,'Europe/Paris'),(41135,'Ouzouer-le-Marche','Ouzouer-le-Marche','','France',250,'Europe/Paris'),(41137,'Ouzouer-sur-Loire','Ouzouer-sur-Loire','','France',250,'Europe/Paris'),(41121,'Oye-Plage','Oye-Plage','','France',250,'Europe/Paris'),(41125,'Oyonnax','Oyonnax','','France',250,'Europe/Paris'),(41017,'Ozoir-la-Ferriere','Ozoir-la-Ferriere','','France',250,'Europe/Paris'),(41019,'Ozouer-le-Voulgis','Ozouer-le-Voulgis','','France',250,'Europe/Paris'),(40433,'Quarouble','Quarouble','','France',250,'Europe/Paris'),(40439,'Quelaines-Saint-Gault','Quelaines-Saint-Gault','','France',250,'Europe/Paris'),(40447,'Querqueville','Querqueville','','France',250,'Europe/Paris'),(40449,'Querrien','Querrien','','France',250,'Europe/Paris'),(40445,'Quesnoy-sur-Deule','Quesnoy-sur-Deule','','France',250,'Europe/Paris'),(40451,'Quessoy','Quessoy','','France',250,'Europe/Paris'),(40453,'Questembert','Questembert','','France',250,'Europe/Paris'),(40455,'Quetigny','Quetigny','','France',250,'Europe/Paris'),(40457,'Quettehou','Quettehou','','France',250,'Europe/Paris'),(40435,'Queven','Queven','','France',250,'Europe/Paris'),(40437,'Quevert','Quevert','','France',250,'Europe/Paris'),(40459,'Quiberon','Quiberon','','France',250,'Europe/Paris'),(40463,'Quievrechain','Quievrechain','','France',250,'Europe/Paris'),(40461,'Quievy','Quievy','','France',250,'Europe/Paris'),(40465,'Quillan','Quillan','','France',250,'Europe/Paris'),(40477,'Quimperle','Quimperle','','France',250,'Europe/Paris'),(40441,'Quincampoix','Quincampoix','','France',250,'Europe/Paris'),(40471,'Quincieux','Quincieux','','France',250,'Europe/Paris'),(40469,'Quincy-sous-Senart','Quincy-sous-Senart','','France',250,'Europe/Paris'),(40467,'Quincy-Voisins','Quincy-Voisins','','France',250,'Europe/Paris'),(40443,'Quinsac','Quinsac','','France',250,'Europe/Paris'),(40475,'Quintin','Quintin','','France',250,'Europe/Paris'),(40473,'Quissac','Quissac','','France',250,'Europe/Paris'),(40711,'Taden','Taden','','France',250,'Europe/Paris'),(40779,'Taissy','Taissy','','France',250,'Europe/Paris'),(40715,'Talange','Talange','','France',250,'Europe/Paris'),(40713,'Talant','Talant','','France',250,'Europe/Paris'),(40719,'Talence','Talence','','France',250,'Europe/Paris'),(40717,'Talensac','Talensac','','France',250,'Europe/Paris'),(40721,'Talloires','Talloires','','France',250,'Europe/Paris'),(40723,'Taluyers','Taluyers','','France',250,'Europe/Paris'),(40729,'Taninges','Taninges','','France',250,'Europe/Paris'),(40735,'Tarare','Tarare','','France',250,'Europe/Paris'),(40737,'Tarascon-sur-Ariege','Tarascon-sur-Ariege','','France',250,'Europe/Paris'),(40741,'Targon','Targon','','France',250,'Europe/Paris'),(40743,'Tarnos','Tarnos','','France',250,'Europe/Paris'),(40745,'Tartas','Tartas','','France',250,'Europe/Paris'),(40747,'Tassin-la-Demi-Lune','Tassin-la-Demi-Lune','','France',250,'Europe/Paris'),(40749,'Tatinghem','Tatinghem','','France',250,'Europe/Paris'),(40699,'Taule','Taule','','France',250,'Europe/Paris'),(40811,'Taulignan','Taulignan','','France',250,'Europe/Paris'),(40827,'Taupont','Taupont','','France',250,'Europe/Paris'),(40707,'Tavaux','Tavaux','','France',250,'Europe/Paris'),(40709,'Tavel','Tavel','','France',250,'Europe/Paris'),(40705,'Taverny','Taverny','','France',250,'Europe/Paris'),(40763,'Telgruc-sur-Mer','Telgruc-sur-Mer','','France',250,'Europe/Paris'),(40761,'Teloche','Teloche','','France',250,'Europe/Paris'),(40727,'Templemars','Templemars','','France',250,'Europe/Paris'),(40725,'Templeuve','Templeuve','','France',250,'Europe/Paris'),(40765,'Tence','Tence','','France',250,'Europe/Paris'),(40773,'Tergnier','Tergnier','','France',250,'Europe/Paris'),(40775,'Ternay','Ternay','','France',250,'Europe/Paris'),(40777,'Terrasson-Lavilledieu','Terrasson-Lavilledieu','','France',250,'Europe/Paris'),(40771,'Terville','Terville','','France',250,'Europe/Paris'),(40781,'Teteghem','Teteghem','','France',250,'Europe/Paris'),(40759,'Teyran','Teyran','','France',250,'Europe/Paris'),(40731,'Thann','Thann','','France',250,'Europe/Paris'),(40733,'Thaon-les-Vosges','Thaon-les-Vosges','','France',250,'Europe/Paris'),(40751,'Theding','Theding','','France',250,'Europe/Paris'),(40757,'Theix','Theix','','France',250,'Europe/Paris'),(40755,'Theys','Theys','','France',250,'Europe/Paris'),(40753,'Thezan-les-Beziers','Thezan-les-Beziers','','France',250,'Europe/Paris'),(40995,'Thiais','Thiais','','France',250,'Europe/Paris'),(40997,'Thiant','Thiant','','France',250,'Europe/Paris'),(40783,'Thiberville','Thiberville','','France',250,'Europe/Paris'),(40971,'Thiers','Thiers','','France',250,'Europe/Paris'),(40789,'Thierville-sur-Meuse','Thierville-sur-Meuse','','France',250,'Europe/Paris'),(40799,'Thil','Thil','','France',250,'Europe/Paris'),(40793,'Thise','Thise','','France',250,'Europe/Paris'),(40785,'Thiviers','Thiviers','','France',250,'Europe/Paris'),(40795,'Thizy','Thizy','','France',250,'Europe/Paris'),(40931,'Thoiry','Thoiry','','France',250,'Europe/Paris'),(40815,'Thomery','Thomery','','France',250,'Europe/Paris'),(40817,'Thones','Thones','','France',250,'Europe/Paris'),(40825,'Thonon-les-Bains','Thonon-les-Bains','','France',250,'Europe/Paris'),(40829,'Thorens-Glieres','Thorens-Glieres','','France',250,'Europe/Paris'),(40831,'Thorigne-sur-Due','Thorigne-sur-Due','','France',250,'Europe/Paris'),(40835,'Thorigny-sur-Marne','Thorigny-sur-Marne','','France',250,'Europe/Paris'),(104145,'Thou','Thou','','France',250,'Europe/Paris'),(40933,'Thouarce','Thouarce','','France',250,'Europe/Paris'),(40929,'Thouare-sur-Loire','Thouare-sur-Loire','','France',250,'Europe/Paris'),(40927,'Thouars','Thouars','','France',250,'Europe/Paris'),(40961,'Thourotte','Thourotte','','France',250,'Europe/Paris'),(40973,'Thuellin','Thuellin','','France',250,'Europe/Paris'),(40975,'Thuir','Thuir','','France',250,'Europe/Paris'),(40983,'Thumeries','Thumeries','','France',250,'Europe/Paris'),(40985,'Thure','Thure','','France',250,'Europe/Paris'),(40987,'Thurins','Thurins','','France',250,'Europe/Paris'),(40989,'Thury-Harcourt','Thury-Harcourt','','France',250,'Europe/Paris'),(40787,'Thyez','Thyez','','France',250,'Europe/Paris'),(40801,'Tignes','Tignes','','France',250,'Europe/Paris'),(40803,'Tignieu-Jameyzieu','Tignieu-Jameyzieu','','France',250,'Europe/Paris'),(40791,'Tigy','Tigy','','France',250,'Europe/Paris'),(40797,'Tilloy-les-Mofflaines','Tilloy-les-Mofflaines','','France',250,'Europe/Paris'),(40769,'Tinchebray','Tinchebray','','France',250,'Europe/Paris'),(40805,'Tinqueux','Tinqueux','','France',250,'Europe/Paris'),(40767,'Tinteniac','Tinteniac','','France',250,'Europe/Paris'),(40809,'Tocane-Saint-Apre','Tocane-Saint-Apre','','France',250,'Europe/Paris'),(40813,'Tomblaine','Tomblaine','','France',250,'Europe/Paris'),(40823,'Tonnay-Charente','Tonnay-Charente','','France',250,'Europe/Paris'),(40819,'Tonneins','Tonneins','','France',250,'Europe/Paris'),(40821,'Tonnerre','Tonnerre','','France',250,'Europe/Paris'),(40839,'Torcy','Torcy','','France',250,'Europe/Paris'),(40843,'Torfou','Torfou','','France',250,'Europe/Paris'),(40833,'Torigni-sur-Vire','Torigni-sur-Vire','','France',250,'Europe/Paris'),(40837,'Torreilles','Torreilles','','France',250,'Europe/Paris'),(40845,'Tosse','Tosse','','France',250,'Europe/Paris'),(40965,'Toucy','Toucy','','France',250,'Europe/Paris'),(40969,'Toufflers','Toufflers','','France',250,'Europe/Paris'),(40939,'Toulaud','Toulaud','','France',250,'Europe/Paris'),(40937,'Toulenne','Toulenne','','France',250,'Europe/Paris'),(40943,'Toulon-sur-Arroux','Toulon-sur-Arroux','','France',250,'Europe/Paris'),(40945,'Toulouges','Toulouges','','France',250,'Europe/Paris'),(40935,'Touques','Touques','','France',250,'Europe/Paris'),(40841,'Tourbes','Tourbes','','France',250,'Europe/Paris'),(40955,'Tourlaville','Tourlaville','','France',250,'Europe/Paris'),(40957,'Tournefeuille','Tournefeuille','','France',250,'Europe/Paris'),(40959,'Tournus','Tournus','','France',250,'Europe/Paris'),(40963,'Tourouvre','Tourouvre','','France',250,'Europe/Paris'),(40951,'Toury','Toury','','France',250,'Europe/Paris'),(40967,'Toussieu','Toussieu','','France',250,'Europe/Paris'),(40851,'Tracy-le-Mont','Tracy-le-Mont','','France',250,'Europe/Paris'),(40883,'Trainou','Trainou','','France',250,'Europe/Paris'),(40849,'Tramoyes','Tramoyes','','France',250,'Europe/Paris'),(40703,'Trappes','Trappes','','France',250,'Europe/Paris'),(40853,'Trebes','Trebes','','France',250,'Europe/Bucharest'),(40855,'Trebeurden','Trebeurden','','France',250,'Europe/Paris'),(40895,'Treffiagat','Treffiagat','','France',250,'Europe/Paris'),(40893,'Trefflean','Trefflean','','France',250,'Europe/Paris'),(40859,'Tregastel','Tregastel','','France',250,'Europe/Paris'),(40861,'Treguier','Treguier','','France',250,'Europe/Paris'),(40863,'Tregunc','Tregunc','','France',250,'Europe/Paris'),(40867,'Treillieres','Treillieres','','France',250,'Europe/Paris'),(40865,'Treize-Septiers','Treize-Septiers','','France',250,'Europe/Paris'),(40869,'Trelaze','Trelaze','','France',250,'Europe/Paris'),(40873,'Trelissac','Trelissac','','France',250,'Europe/Paris'),(40871,'Trelivan','Trelivan','','France',250,'Europe/Paris'),(40875,'Trelon','Trelon','','France',250,'Europe/Paris'),(40847,'Tremblay','Tremblay','','France',250,'Europe/Paris'),(40877,'Trementines','Trementines','','France',250,'Europe/Paris'),(40879,'Tremeven','Tremeven','','France',250,'Europe/Paris'),(40881,'Tremuson','Tremuson','','France',250,'Europe/Paris'),(40885,'Trept','Trept','','France',250,'Europe/Paris'),(40887,'Tresques','Tresques','','France',250,'Europe/Paris'),(40889,'Tressange','Tressange','','France',250,'Europe/Paris'),(40891,'Tresserve','Tresserve','','France',250,'Europe/Paris'),(40701,'Tresses','Tresses','','France',250,'Europe/Paris'),(40857,'Trevoux','Trevoux','','France',250,'Europe/Paris'),(40899,'Trie-Chateau','Trie-Chateau','','France',250,'Europe/Paris'),(40907,'Triel-sur-Seine','Triel-sur-Seine','','France',250,'Europe/Paris'),(40897,'Trieux','Trieux','','France',250,'Europe/Paris'),(40903,'Trignac','Trignac','','France',250,'Europe/Paris'),(40901,'Trilport','Trilport','','France',250,'Europe/Paris'),(40905,'Trith-Saint-Leger','Trith-Saint-Leger','','France',250,'Europe/Paris'),(40909,'Troarn','Troarn','','France',250,'Europe/Paris'),(40911,'Tronville-en-Barrois','Tronville-en-Barrois','','France',250,'Europe/Paris'),(40913,'Trosly-Breuil','Trosly-Breuil','','France',250,'Europe/Paris'),(40921,'Trouillas','Trouillas','','France',250,'Europe/Paris'),(40917,'Trouville-sur-Mer','Trouville-sur-Mer','','France',250,'Europe/Paris'),(40919,'Trouy','Trouy','','France',250,'Europe/Paris'),(40925,'Truchtersheim','Truchtersheim','','France',250,'Europe/Paris'),(40923,'Truyes','Truyes','','France',250,'Europe/Paris'),(40977,'Tucquegnieux','Tucquegnieux','','France',250,'Europe/Paris'),(40993,'Tuffe','Tuffe','','France',250,'Europe/Paris'),(40979,'Tulette','Tulette','','France',250,'Europe/Paris'),(40981,'Tullins','Tullins','','France',250,'Europe/Paris'),(40991,'Turckheim','Turckheim','','France',250,'Europe/Paris'),(40697,'Uchaud','Uchaud','','France',250,'Europe/Paris'),(40671,'Uckange','Uckange','','France',250,'Europe/Paris'),(40667,'Ugine','Ugine','','France',250,'Europe/Paris'),(40675,'Ully-Saint-Georges','Ully-Saint-Georges','','France',250,'Europe/Paris'),(40677,'Ungersheim','Ungersheim','','France',250,'Europe/Paris'),(40679,'Unieux','Unieux','','France',250,'Europe/Paris'),(40687,'Urcuit','Urcuit','','France',250,'Europe/Paris'),(40689,'Urrugne','Urrugne','','France',250,'Europe/Paris'),(40681,'Urt','Urt','','France',250,'Europe/Paris'),(40683,'Urville-Nacqueville','Urville-Nacqueville','','France',250,'Europe/Paris'),(40685,'Urzy','Urzy','','France',250,'Europe/Paris'),(40691,'Ussac','Ussac','','France',250,'Europe/Paris'),(40693,'Ussel','Ussel','','France',250,'Europe/Paris'),(40695,'Ustaritz','Ustaritz','','France',250,'Europe/Paris'),(40673,'Uxegney','Uxegney','','France',250,'Europe/Paris'),(40669,'Uzerche','Uzerche','','France',250,'Europe/Paris'),(40355,'Wahagnies','Wahagnies','','France',250,'Europe/Paris'),(40331,'Wallers','Wallers','','France',250,'Europe/Paris'),(40333,'Walscheid','Walscheid','','France',250,'Europe/Paris'),(40335,'Wambrechies','Wambrechies','','France',250,'Europe/Paris'),(40337,'Warhem','Warhem','','France',250,'Europe/Paris'),(40339,'Warmeriville','Warmeriville','','France',250,'Europe/Paris'),(40341,'Wasquehal','Wasquehal','','France',250,'Europe/Paris'),(40343,'Wasselonne','Wasselonne','','France',250,'Europe/Paris'),(40345,'Wassy','Wassy','','France',250,'Europe/Paris'),(40347,'Watten','Watten','','France',250,'Europe/Paris'),(40351,'Wattignies','Wattignies','','France',250,'Europe/Paris'),(40353,'Wattrelos','Wattrelos','','France',250,'Europe/Paris'),(40349,'Wattwiller','Wattwiller','','France',250,'Europe/Paris'),(40327,'Wavrechain-sous-Denain','Wavrechain-sous-Denain','','France',250,'Europe/Paris'),(40325,'Wavrin','Wavrin','','France',250,'Europe/Paris'),(40329,'Waziers','Waziers','','France',250,'Europe/Paris'),(40359,'Weitbruch','Weitbruch','','France',250,'Europe/Paris'),(40365,'Wervicq-Sud','Wervicq-Sud','','France',250,'Europe/Paris'),(40367,'Westhoffen','Westhoffen','','France',250,'Europe/Paris'),(40369,'Wettolsheim','Wettolsheim','','France',250,'Europe/Paris'),(40357,'Weyersheim','Weyersheim','','France',250,'Europe/Paris'),(40377,'Wignehies','Wignehies','','France',250,'Europe/Paris'),(40373,'Wimereux','Wimereux','','France',250,'Europe/Paris'),(40375,'Wimille','Wimille','','France',250,'Europe/Paris'),(40361,'Wingles','Wingles','','France',250,'Europe/Paris'),(40363,'Wintzenheim','Wintzenheim','','France',250,'Europe/Paris'),(40391,'Wisches','Wisches','','France',250,'Europe/Paris'),(40381,'Wissous','Wissous','','France',250,'Europe/Paris'),(40383,'Witry-les-Reims','Witry-les-Reims','','France',250,'Europe/Paris'),(40387,'Wittelsheim','Wittelsheim','','France',250,'Europe/Paris'),(40385,'Wittenheim','Wittenheim','','France',250,'Europe/Paris'),(40389,'Wittisheim','Wittisheim','','France',250,'Europe/Paris'),(40371,'Wizernes','Wizernes','','France',250,'Europe/Paris'),(40397,'Woincourt','Woincourt','','France',250,'Europe/Paris'),(40399,'Woippy','Woippy','','France',250,'Europe/Paris'),(40393,'Wolfisheim','Wolfisheim','','France',250,'Europe/Paris'),(40395,'Wormhout','Wormhout','','France',250,'Europe/Paris'),(40401,'Woustviller','Woustviller','','France',250,'Europe/Paris'),(40321,'Xertigny','Xertigny','','France',250,'Europe/Paris'),(40323,'Xonrupt-Longemer','Xonrupt-Longemer','','France',250,'Europe/Paris'),(106487,'Y','Y','','France',250,'Europe/Paris'),(40429,'Ychoux','Ychoux','','France',250,'Europe/Paris'),(40409,'Ydes','Ydes','','France',250,'Europe/Paris'),(40413,'Yenne','Yenne','','France',250,'Europe/Paris'),(40415,'Yerville','Yerville','','France',250,'Europe/Paris'),(40411,'Yevres','Yevres','','France',250,'Europe/Paris'),(40427,'Yffiniac','Yffiniac','','France',250,'Europe/Paris'),(40423,'Yssingeaux','Yssingeaux','','France',250,'Europe/Paris'),(40425,'Ytrac','Ytrac','','France',250,'Europe/Paris'),(40431,'Yutz','Yutz','','France',250,'Europe/Paris'),(40403,'Yvetot','Yvetot','','France',250,'Europe/Paris'),(40407,'Yvrac','Yvrac','','France',250,'Europe/Paris'),(40405,'Yvre-le-Polin','Yvre-le-Polin','','France',250,'Europe/Paris'),(40421,'Yzernay','Yzernay','','France',250,'Europe/Paris'),(40417,'Yzeure','Yzeure','','France',250,'Europe/Paris'),(40419,'Yzeures-sur-Creuse','Yzeures-sur-Creuse','','France',250,'Europe/Paris'),(40313,'Zillisheim','Zillisheim','','France',250,'Europe/Paris'),(40315,'Zonza','Zonza','','France',250,'Europe/Paris'),(40319,'Zutkerque','Zutkerque','','France',250,'Europe/Paris'),(40317,'Zuydcoote','Zuydcoote','','France',250,'Europe/Paris'),(87112,'Абвиль','Abbeville','','France',250,'America/New_York'),(41187,'Авиньон','Avignon','','France',250,'Europe/Paris'),(88284,'Авон','Avosnes','','France',250,'Europe/Paris'),(87181,'Аже','Agey','','France',250,'Africa/Niamey'),(5138,'Ажен','Agen','','France',250,'Europe/Paris'),(87259,'Ажен','Ajain','','France',250,'Europe/Paris'),(41213,'Алансон','Alencon','','France',250,'Europe/Paris'),(87271,'Альберт','Albert','','France',250,'America/Chicago'),(87273,'Альби','Albi','','France',250,'Europe/Paris'),(92745,'Альт','Genis','','France',250,'Europe/Paris'),(94232,'Амар','Hamars','','France',250,'Europe/Paris'),(41305,'Амьен','Amiens','','France',250,'Europe/Paris'),(41307,'Англет','Anglet','','France',250,'Europe/Paris'),(41313,'Ангулем','Angouleme','','France',250,'Europe/Paris'),(94267,'Аннап','Hannapes','','France',250,'Europe/Paris'),(87546,'Ансан','Ansan','','France',250,'Europe/Paris'),(87428,'Ансе','Ancey','','France',250,'Europe/Paris'),(41369,'Анси','Annecy','','France',250,'Europe/Paris'),(41387,'Антиб','Antibes','','France',250,'Europe/Paris'),(41401,'Аоста','Aoste','','France',250,'Europe/Rome'),(87668,'Арбон','Arbon','','France',250,'Europe/Paris'),(87727,'Ардон','Ardon','','France',250,'Europe/Moscow'),(87749,'Аржан','Argens','','France',250,'Europe/Paris'),(41439,'Аржантёй','Argenteuil','','France',250,'Europe/Paris'),(94369,'Ари','Hary','','France',250,'Europe/Paris'),(87695,'Арко','Arceau','','France',250,'Europe/Paris'),(41493,'Аррас','Arras','','France',250,'Europe/Paris'),(87151,'Аси','Acy','','France',250,'Europe/Paris'),(87197,'Ахе','Ahe','','France',250,'Europe/Berlin'),(41559,'Аяччо','Ajaccio','','France',250,'Europe/Paris'),(42551,'Байё','Bayeux','','France',250,'Europe/Paris'),(88729,'Байон','Bayon','','France',250,'Asia/Phnom_Penh'),(41763,'Байонна','Bayonne','','France',250,'America/New_York'),(88624,'Бали','Basly','','France',250,'Europe/Paris'),(88522,'Бан','Bans','','France',250,'Europe/Paris'),(88505,'Банат','Banat','','France',250,'America/Menominee'),(88427,'Баньо','Bagnot','','France',250,'Europe/Paris'),(88532,'Бар','Bar','','France',250,'Europe/Budapest'),(41813,'Бар-лё-Дюк','Bar-le-Duc','','France',250,'Europe/Paris'),(88559,'Бард','Bard','','France',250,'Europe/Paris'),(88589,'Барон','Baron','','France',250,'Europe/Paris'),(88610,'Барри','Barry','','France',250,'America/Chicago'),(88603,'Барро','Barro','','France',250,'America/La_Paz'),(88633,'Бас','Basses','','France',250,'Europe/Paris'),(88629,'Бас-Тер','Basse-Terre','','France',250,'America/Guadeloupe'),(41865,'Бастия','Bastia','','France',250,'Europe/Paris'),(5157,'Безансон','Besancon','','France',250,'Europe/Paris'),(41897,'Безье','Beziers','','France',250,'Europe/Paris'),(89325,'Бей','Bey','','France',250,'Europe/Paris'),(88999,'Беллу','Bellou','','France',250,'Europe/Paris'),(89020,'Бельведер','Belvedere','','France',250,'America/Los_Angeles'),(41955,'Бельвиль','Belleville','','France',250,'America/Toronto'),(5155,'Бельфор','Belfort','','France',250,'Europe/Paris'),(41871,'Бельфор','Bais','','France',250,'Europe/Paris'),(89050,'Бене','Benay','','France',250,'Europe/Paris'),(89067,'Бенон','Benon','','France',250,'Europe/Paris'),(5158,'Биарриц','Biarritz','','France',250,'Europe/Paris'),(89551,'Бле','Blay','','France',250,'Europe/Paris'),(42103,'Блуа','Blois','','France',250,'Europe/Paris'),(42129,'Бове','Beauvais','','France',250,'Europe/Paris'),(88824,'Боже','Beaugeay','','France',250,'Europe/Paris'),(42163,'Болонья','Le Bono','','France',250,'America/Chicago'),(89714,'Болонья','Bologne','','France',250,'Europe/Paris'),(42191,'Бон','Beaune','','France',250,'Europe/Paris'),(89812,'Бор','Bords','','France',250,'Europe/Paris'),(89819,'Бор','Boron','','France',250,'Europe/Paris'),(42385,'Брюгге','Bruges','','France',250,'Europe/Brussels'),(42517,'Бурж','Bourges','','France',250,'Europe/Paris'),(89918,'Буэ','Bouhet','','France',250,'Europe/Paris'),(89919,'Буэ','Bouhey','','France',250,'Europe/Paris'),(105581,'Ванд','Vendes','','France',250,'Europe/Paris'),(105584,'Вандёвр','Vendeuvre','','France',250,'Europe/Paris'),(5310,'Ванн','Vannes','','France',250,'Europe/Paris'),(105572,'Ванс','Vence','','France',250,'Europe/Paris'),(105298,'Варез','Varaize','','France',250,'Europe/Paris'),(105338,'Варзе','Varzay','','France',250,'Europe/Paris'),(105832,'Везин','Vesines','','France',250,'Europe/Paris'),(105834,'Велю','Veslud','','France',250,'Europe/Paris'),(48851,'Верден','Verdun','','France',250,'Europe/Paris'),(105696,'Верия','Veria','','France',250,'Europe/Paris'),(105758,'Верно','Vernot','','France',250,'Europe/Paris'),(105793,'Версаль','Versailles','','France',250,'Europe/Paris'),(106024,'Винья','Vignats','','France',250,'Europe/Paris'),(49155,'Виши','Vichy','','France',250,'Europe/Paris'),(105958,'Вьенна','Vienne','','France',250,'Europe/Vienna'),(46471,'Гавр','Le Havre','','France',250,'Europe/Paris'),(92608,'Газ','Gas','','France',250,'America/Chicago'),(94275,'Ганс','Hans','','France',250,'Europe/Paris'),(92726,'Ген','Gene','','France',250,'Europe/Paris'),(94663,'Герма','Herme','','France',250,'Europe/Paris'),(94702,'Гессен','Hesse','','France',250,'Europe/Berlin'),(93190,'Глен','Glennes','','France',250,'Europe/Paris'),(93205,'Гло','Glos','','France',250,'Europe/Paris'),(99633,'Горох','Peas','','France',250,'Europe/Paris'),(93463,'Гранд','Grand','','France',250,'Europe/Athens'),(44779,'Грасс','Grasse','','France',250,'Europe/Paris'),(96947,'Грасс','Magagnosc','','France',250,'Europe/Paris'),(44789,'Гренобль','Grenoble','','France',250,'Europe/Paris'),(93387,'Гуи','Gouy','','France',250,'Europe/Paris'),(91434,'Даммар','Dammard','','France',250,'Europe/Paris'),(43841,'Дижон','Dijon','','France',250,'Europe/Paris'),(43923,'Дрё','Dreux','','France',250,'Europe/Paris'),(43977,'Дюнкерк','Dunkerque','','France',250,'Europe/Paris'),(97159,'Дюнкерк','Malo-les-Bains','','France',250,'Europe/Paris'),(92326,'Ева','Eve','','France',250,'Europe/Paris'),(93092,'Жирон','Giron','','France',250,'America/Bogota'),(95440,'Жор','Jort','','France',250,'Europe/Paris'),(95462,'Жуэ','Jouey','','France',250,'Europe/Paris'),(40491,'Иври','Ivry-la-Bataille','','France',250,'Europe/Paris'),(95278,'Изёр','Izeure','','France',250,'Europe/Paris'),(106494,'Йер','Yerres','','France',250,'Europe/Paris'),(90462,'Кайенна','Cayenne','','France',250,'America/Cayenne'),(42641,'Кале','Calais','','France',250,'Europe/Paris'),(42685,'Камбре','Cambrai','','France',250,'Europe/Paris'),(42689,'Кан','Caen','','France',250,'Europe/Paris'),(90122,'Канал','Canals','','France',250,'Europe/Paris'),(13485,'Канны','Cannes','','France',250,'Europe/Paris'),(42623,'Каор','Cahors','','France',250,'Europe/Paris'),(42749,'Каркассон','Carcassonne','','France',250,'Europe/Paris'),(90335,'Кастеллан','Castellane','','France',250,'Europe/Paris'),(90362,'Кастильоне','Castiglione','','France',250,'Europe/Rome'),(90367,'Кастр','Castres','','France',250,'Europe/Paris'),(40479,'Кемпер','Quimper','','France',250,'Europe/Paris'),(42837,'Клермон-Ферран','Clermont-Ferrand','','France',250,'Europe/Paris'),(42977,'Коньяк','Cognac','','France',250,'Europe/Paris'),(100713,'Куинси','Quincy','','France',250,'America/New_York'),(43209,'Куршевель','Courchevel','','France',250,'America/Los_Angeles'),(46585,'Ла-Рошель','La Rochelle','','France',250,'Europe/Paris'),(96091,'Ла-Сиота','La Ciotat','','France',250,'Europe/Paris'),(46613,'Лаваль','Laval','','France',250,'America/Montreal'),(96268,'Лагранж','La Grange','','France',250,'America/Chicago'),(96891,'Лак','Lacs','','France',250,'Europe/Paris'),(96874,'Лакомб','Lacombe','','France',250,'America/Edmonton'),(46679,'Лампертхайм','Lampertheim','','France',250,'Europe/Berlin'),(46775,'Лан','Laon','','France',250,'Europe/Paris'),(46685,'Ланс','Lens','','France',250,'Europe/Paris'),(96654,'Латур','La Tour','','France',250,'Europe/Paris'),(5232,'Ле-Ман','Le Mans','','France',250,'Europe/Paris'),(46909,'Либурн','Libourne','','France',250,'Europe/Paris'),(5238,'Лилль','Lille','','France',250,'Europe/Paris'),(5239,'Лимож','Limoges','','France',250,'Europe/Paris'),(46971,'Лион','Lyon','','France',250,'Europe/Paris'),(47027,'Лон-ле-Сонье','Lons-le-Saunier','','France',250,'Europe/Paris'),(96955,'Магнит','Magnet','','France',250,'America/Chicago'),(45167,'Макон','Macon','','France',250,'America/New_York'),(97180,'Мана','Mana','','France',250,'America/New_York'),(97647,'Мария','Mary','','France',250,'Asia/Ashgabat'),(96377,'Марка','La Marche','','France',250,'Europe/Rome'),(97325,'Марка','Marches','','France',250,'Europe/Paris'),(97528,'Марон','Maron','','France',250,'Europe/Paris'),(97548,'Марс','Mars','','France',250,'America/Chicago'),(97564,'Марсе','Marsais','','France',250,'Europe/Paris'),(45347,'Марсель','Marseille','','France',250,'Europe/Paris'),(97621,'Мартиг','Martigues','','France',250,'Europe/Paris'),(97615,'Мартиньи','Martigny','','France',250,'Europe/Paris'),(97893,'Медан','Medan','','France',250,'Asia/Jakarta'),(97089,'Мезе','Maizet','','France',250,'Europe/Paris'),(97097,'Мези','Maizy','','France',250,'Europe/Paris'),(96911,'Мейс','Mace','','France',250,'Europe/Paris'),(45453,'Мелён','Melun','','France',250,'Europe/Paris'),(45475,'Ментона','Menton','','France',250,'Europe/Paris'),(5249,'Мец','Metz','','France',250,'Europe/Paris'),(45565,'Мийо','Millau','','France',250,'Europe/Paris'),(45613,'Мо','Meaux','','France',250,'Europe/Paris'),(45831,'Монпелье','Montpellier','','France',250,'Europe/Paris'),(45835,'Монреаль','Montreal','','France',250,'America/Montreal'),(45827,'Монтобан','Montauban','','France',250,'Europe/Paris'),(97789,'Мот','Mautes','','France',250,'Europe/Paris'),(46097,'Нанси','Nancy','','France',250,'Europe/Paris'),(46099,'Нант','Nantes','','France',250,'Europe/Paris'),(46107,'Нантер','Nanterre','','France',250,'Europe/Paris'),(98298,'Нанту','Nantoux','','France',250,'Europe/Paris'),(46121,'Невер','Nevers','','France',250,'Europe/Paris'),(98553,'Ней','Ney','','France',250,'America/New_York'),(98456,'Нёйи-сюр-Сен','Neuilly-sur-Seine','','France',250,'Europe/Paris'),(98460,'Нёль','Neulles','','France',250,'Europe/Paris'),(98574,'Николь','Nicole','','France',250,'America/New_York'),(46331,'Ним','Nimes','','France',250,'Europe/Paris'),(98572,'Нисе','Nicey','','France',250,'Europe/Paris'),(46211,'Ницца','Nice','','France',250,'Europe/Paris'),(46305,'Нуайон','Noyon','','France',250,'Europe/Paris'),(98799,'Нумеа','Noumea','','France',250,'Pacific/Noumea'),(5263,'Ньор','Niort','','France',250,'Europe/Paris'),(87958,'Об','Aube','','France',250,'Europe/Paris'),(87953,'Обань','Aubagne','','France',250,'Europe/Paris'),(87968,'Обервиль','Auberville','','France',250,'Europe/Paris'),(99357,'Оз','Oz','','France',250,'Europe/Paris'),(98956,'Ои','Ohis','','France',250,'Europe/Paris'),(99074,'Оранж','Orange','','France',250,'America/Chicago'),(99071,'Орен','Orain','','France',250,'Europe/Paris'),(41693,'Орийак','Aurillac','','France',250,'Europe/Paris'),(41067,'Орлеан','Orleans','','France',250,'Europe/Paris'),(41659,'Осер','Auxerre','','France',250,'Europe/Paris'),(95219,'Остров','Island','','France',250,'Atlantic/Reykjavik'),(94487,'Отьон','Haution','','France',250,'Europe/Paris'),(41709,'Ош','Auch','','France',250,'Europe/Paris'),(99568,'Пак','Pasques','','France',250,'Europe/Paris'),(99567,'Пали','Pasly','','France',250,'Europe/Paris'),(47633,'Памье','Pamiers','','France',250,'Europe/Paris'),(99460,'Панж','Panges','','France',250,'Europe/Paris'),(99474,'Папеэте','Papeete','','France',250,'Pacific/Tahiti'),(99559,'Парв','Parves','','France',250,'Europe/Paris'),(13484,'Париж','Paris','','France',250,'Europe/Paris'),(47717,'Перигё','Perigueux','','France',250,'Europe/Paris'),(99727,'Перн','Pern','','France',250,'Europe/Paris'),(99745,'Перпиньян','Perpignan','','France',250,'Europe/Paris'),(100161,'Плевен','Pleven','','France',250,'Europe/Sofia'),(48017,'По','Pau','','France',250,'Europe/Madrid'),(48135,'Понтуаз','Pontoise','','France',250,'Europe/Paris'),(100468,'Порт','Port','','France',250,'Europe/Bucharest'),(100499,'Порт','Ports','','France',250,'Europe/Paris'),(100479,'Порт-Луи','Port-Louis','','France',250,'Indian/Mauritius'),(100497,'Порту','Porto','','France',250,'America/Fortaleza'),(48253,'Пуатье','Poitiers','','France',250,'Europe/Paris'),(100258,'Пуэнт-Нуар','Pointe-Noire','','France',250,'Africa/Brazzaville'),(100801,'Рамас','Ramasse','','France',250,'Europe/Paris'),(48339,'Рамбуйе','Rambouillet','','France',250,'Europe/Paris'),(101152,'Рё','Reux','','France',250,'Europe/Paris'),(48389,'Реймс','Reims','','France',250,'Europe/Paris'),(101058,'Реми','Remies','','France',250,'Europe/Paris'),(101079,'Реми','Remy','','France',250,'Europe/Paris'),(48411,'Ренн','Rennes','','France',250,'Europe/Paris'),(101941,'Ри','Ryes','','France',250,'Europe/Paris'),(101324,'Ривас','Rivas','','France',250,'Europe/Paris'),(101313,'Риу','Rioux','','France',250,'Europe/Paris'),(101621,'Ро','Rots','','France',250,'Europe/Paris'),(48507,'Родез','Rodez','','France',250,'Europe/Paris'),(101183,'Родос','Rhodes','','France',250,'Europe/Paris'),(48619,'Ройя','Royat','','France',250,'Europe/Paris'),(101416,'Рок','Rocques','','France',250,'Europe/Paris'),(98818,'Роман','Novel','','France',250,'Europe/Zurich'),(101480,'Роман','Roman','','France',250,'Europe/Bucharest'),(101483,'Роман','Romans','','France',250,'Europe/Paris'),(48597,'Рошфор','Rochefort','','France',250,'Europe/Paris'),(48621,'Руайян','Royan','','France',250,'Europe/Paris'),(48609,'Руан','Rouen','','France',250,'Europe/Paris'),(48623,'Рубе','Roubaix','','France',250,'Europe/Paris'),(99104,'Руда','Ore','','France',250,'America/Los_Angeles'),(102036,'Сафр','Saffres','','France',250,'Europe/Paris'),(49517,'Севр','Sevres','','France',250,'Europe/Paris'),(49527,'Седан','Sedan','','France',250,'Europe/Paris'),(49739,'Сен-Дени','Saint-Denis','','France',250,'Europe/Paris'),(49753,'Сен-Дье-де-Вож','Saint-Die-des-Vosges','','France',250,'Europe/Paris'),(103047,'Сен-Дье-де-Вож','Saint-Die','','France',250,'Europe/Paris'),(49905,'Сен-Жермен-ан-Ле','Saint-Germain-en-Laye','','France',250,'Europe/Paris'),(50045,'Сен-Клу','Saint-Cloud','','France',250,'America/Chicago'),(50093,'Сен-Ло','Saint-Lo','','France',250,'Europe/Paris'),(50137,'Сен-Мало','Saint-Malo','','France',250,'Europe/Paris'),(99479,'Сен-Мало','Parame','','France',250,'Europe/Paris'),(5296,'Сен-Назер','St-Nazaire','','France',250,'Europe/Paris'),(50657,'Сент','Saintes','','France',250,'Europe/Paris'),(103132,'Сент-Этьен','Saint-Etienne','','France',250,'Europe/Paris'),(50699,'Сет','Sete','','France',250,'Europe/Paris'),(50787,'Сомюр','Saumur','','France',250,'Europe/Paris'),(50841,'Страсбург','Strasbourg','','France',250,'Europe/Paris'),(103629,'Тайи','Tailly','','France',250,'Europe/Paris'),(103660,'Тальме','Talmay','','France',250,'Europe/Paris'),(103922,'Тан','Thaon','','France',250,'Europe/Paris'),(40739,'Тарб','Tarbes','','France',250,'Europe/Paris'),(103914,'Тен','Thaims','','France',250,'Europe/Paris'),(103822,'Тенд','Tende','','France',250,'Europe/Paris'),(103915,'Тере','Thaire','','France',250,'Europe/Paris'),(104064,'Тио','Thio','','France',250,'Pacific/Noumea'),(40807,'Тионвиль','Thionville','','France',250,'Europe/Paris'),(103936,'Торон','Thauron','','France',250,'Europe/Paris'),(104144,'Тост','Thoste','','France',250,'Europe/Paris'),(104749,'Тризе','Trizay','','France',250,'Europe/Paris'),(104706,'Трир','Treves','','France',250,'Europe/Paris'),(40915,'Труа','Troyes','','France',250,'Europe/Paris'),(104814,'Труа-Ривьер','Trois-Rivieres','','France',250,'America/Montreal'),(40941,'Тулон','Toulon','','France',250,'Europe/Paris'),(40947,'Тулуза','Toulouse','','France',250,'Europe/Paris'),(104341,'Туль','Toul','','France',250,'Europe/Paris'),(5305,'Тур','Tours','','France',250,'Europe/Paris'),(40953,'Туркуэн','Tourcoing','','France',250,'Europe/Paris'),(104867,'Тюль','Tulle','','France',250,'Europe/Paris'),(99277,'Уж','Ouges','','France',250,'Europe/Paris'),(104921,'Ур','Ur','','France',250,'Europe/Zurich'),(99077,'Урбан','Orban','','France',250,'Europe/Paris'),(94944,'Ури','Houry','','France',250,'Europe/Paris'),(44461,'Фрежюс','Frejus','','France',250,'Europe/Paris'),(94197,'Хаген','Hagen','','France',250,'Europe/Berlin'),(44943,'Хагенау','Haguenau','','France',250,'Europe/Paris'),(94238,'Хамельн','Hamelin','','France',250,'Europe/Paris'),(94660,'Херм','Herm','','France',250,'Europe/Guernsey'),(94879,'Хоста','Hosta','','France',250,'Europe/Paris'),(90523,'Целле','Celle','','France',250,'Europe/Berlin'),(90542,'Центр','Centres','','France',250,'Europe/Paris'),(43395,'Шалон-ан-Шампань','Chalons-en-Champagne','','France',250,'Europe/Paris'),(90700,'Шалон-ан-Шампань','Chalons-sur-Marne','','France',250,'Europe/Paris'),(43397,'Шалон-сюр-Сон','Chalon-sur-Saone','','France',250,'Europe/Paris'),(90712,'Шамбер','Chambeire','','France',250,'Europe/Paris'),(43405,'Шамбери','Chambery','','France',250,'Europe/Paris'),(43415,'Шамони','Chamonix-Mont-Blanc','','France',250,'Europe/Paris'),(90754,'Шамони','Chamonix','','France',250,'America/Los_Angeles'),(91045,'Шарлевиль-Мезьер','Charleville-Mezieres','','France',250,'Europe/Paris'),(43527,'Шартр','Chartres','','France',250,'Europe/Paris'),(43547,'Шательро','Chatellerault','','France',250,'Europe/Paris'),(91181,'Шато','Chateau','','France',250,'Europe/Paris'),(43629,'Шатору','Chateauroux','','France',250,'Europe/Paris'),(44239,'Э','Eu','','France',250,'Europe/Vienna'),(92325,'Эванс','Evans','','France',250,'America/New_York'),(43999,'Эврё','Evreux','','France',250,'Europe/Paris'),(87252,'Экс-ан-Прованс','Aix-en-Provence','','France',250,'Europe/Paris'),(94746,'Элан','Heuland','','France',250,'Europe/Paris'),(94209,'Эн','Haimps','','France',250,'Europe/Paris'),(44109,'Эперне','Epernay','','France',250,'Europe/Paris'),(44113,'Эпиналь','Epinal','','France',250,'Europe/Paris'),(87240,'Эран','Airan','','France',250,'Europe/Paris'),(91968,'Эрн','Ernes','','France',250,'Europe/Paris'),(92172,'Эссе','Essey','','France',250,'Europe/Paris'),(44203,'Этамп','Etampes','','France',250,'Europe/Paris'),(86949,'Дубровник','Dubrovnik','','Croatia',191,'Europe/Zagreb'),(86983,'Загреб','Zagreb','','Croatia',191,'Europe/Zagreb'),(86982,'Задар','Zadar','','Croatia',191,'Europe/Zagreb'),(86954,'Карловац','Karlovac','','Croatia',191,'Europe/Zagreb'),(86956,'Лабин','Labin','','Croatia',191,'Europe/Zagreb'),(86959,'Марина','Marina','','Croatia',191,'America/Los_Angeles'),(86962,'Осиек','Osijek','','Croatia',191,'Europe/Zagreb'),(86968,'Порторож','Portoroz','','Croatia',191,'Europe/Ljubljana'),(86969,'Пула','Pula','','Croatia',191,'Europe/Zagreb'),(86975,'Риека','Rijeka','','Croatia',191,'Europe/Zagreb'),(4936,'Славонски-Брод','Slavonski Brod','','Croatia',191,'Europe/Zagreb'),(86980,'Сплит','Split','','Croatia',191,'America/Santiago'),(4249,'','N','','Central African Republic',140,'America/New_York'),(4239,'Бамбари','Bambari','','Central African Republic',140,'Africa/Bangui'),(4241,'Банги','Bangui','','Central African Republic',140,'Africa/Bangui'),(4242,'Берберати','Berberati','','Central African Republic',140,'Africa/Bangui'),(4243,'Бирао','Birao','','Central African Republic',140,'Africa/Bangui'),(4244,'Босангоа','Bossangoa','','Central African Republic',140,'Africa/Bangui'),(4247,'Бриа','Bria','','Central African Republic',140,'Europe/Moscow'),(4246,'Буар','Bouar','','Central African Republic',140,'Asia/Beirut'),(4250,'Обо','Obo','','Central African Republic',140,'Africa/Lagos'),(4254,'ATI','Ati','','Chad',148,'Europe/Athens'),(4252,'Абеше','Abeche','','Chad',148,'Africa/Ndjamena'),(4261,'Мао Цзэдун','Mao','','Chad',148,'Europe/Madrid'),(4263,'Мунду','Moundou','','Chad',148,'Africa/Ndjamena'),(4265,'Нджамена','Ndjamena','','Chad',148,'Africa/Ndjamena'),(4266,'Пала','Pala','','Chad',148,'Europe/Tallinn'),(4267,'Сарх','Sarh','','Chad',148,'Africa/Ndjamena'),(4259,'Фая','Faya','','Chad',148,'Africa/Ndjamena'),(109,'Бар','Bar','','Montenegro',499,'Europe/Budapest'),(108,'Будва','Budva','','Montenegro',499,'Europe/Podgorica'),(96390,'Никшич','Niksic','','Montenegro',499,'Europe/Podgorica'),(96484,'Подгорица','Podgorica','','Montenegro',499,'Europe/Podgorica'),(96525,'Тиват','Tivat','','Montenegro',499,'Europe/Podgorica'),(96582,'Улцинь','Ulcinj','','Montenegro',499,'Europe/Podgorica'),(86963,'Бероун','Beroun','','Czech Republic',203,'Europe/Prague'),(86964,'Бржецлав','Breclav','','Czech Republic',203,'Europe/Prague'),(86965,'Брно','Brno','','Czech Republic',203,'Europe/Prague'),(86984,'Годонин','Hodonin','','Czech Republic',203,'Europe/Prague'),(4953,'Градец-Кралове','Hradec Kralove','','Czech Republic',203,'Europe/Prague'),(86987,'Есеник','Jesenik','','Czech Republic',203,'Europe/Prague'),(86988,'Йичин','Jicin','','Czech Republic',203,'Europe/Prague'),(86991,'Карвина','Karvina','','Czech Republic',203,'Europe/Prague'),(86990,'Карловы Вары','Karlovy Vary','','Czech Republic',203,'Europe/Prague'),(86992,'Кладно','Kladno','','Czech Republic',203,'Europe/Prague'),(86993,'Клатови','Klatovy','','Czech Republic',203,'Europe/Prague'),(86995,'Колин','Kolin','','Czech Republic',203,'Europe/Prague'),(86997,'Либерец','Liberec','','Czech Republic',203,'Europe/Prague'),(4962,'Марианске-Лазне','Marianske Lazne','','Czech Republic',203,'Europe/Prague'),(4968,'Марианске-Лазне','Plzen-Line','','Czech Republic',203,'Europe/Prague'),(87002,'Оломоуц','Olomouc','','Czech Republic',203,'Europe/Prague'),(87003,'Опава','Opava','','Czech Republic',203,'Europe/Prague'),(87004,'Острава','Ostrava','','Czech Republic',203,'Europe/Prague'),(87005,'Пардубице','Pardubice','','Czech Republic',203,'Europe/Prague'),(87007,'Писек','Pisek','','Czech Republic',203,'Europe/Prague'),(13500,'Прага','Prague','','Czech Republic',203,'Europe/Prague'),(87014,'Страконице','Strakonice','','Czech Republic',203,'Europe/Prague'),(87018,'Табор','Tabor','','Czech Republic',203,'America/Chicago'),(87020,'Трутнов','Trutnov','','Czech Republic',203,'Europe/Prague'),(87019,'Тршебич','Trebic','','Czech Republic',203,'Europe/Prague'),(87023,'Усти-над-Лабем','Usti nad Labem','','Czech Republic',203,'Europe/Prague'),(86972,'Хеб','Cheb','','Czech Republic',203,'Europe/Prague'),(86973,'Хомутов','Chomutov','','Czech Republic',203,'Europe/Prague'),(86966,'Ческе-Будеёвице','Budweis','','Czech Republic',203,'Europe/Prague'),(87015,'Шумперк','Sumperk','','Czech Republic',203,'Europe/Prague'),(101129,'Аарау','Aarau','','Switzerland',756,'Europe/Zurich'),(8479,'Альтдорф','Altdorf','','Switzerland',756,'Europe/Berlin'),(101189,'Баден','Baden','','Switzerland',756,'Europe/Paris'),(101190,'Базель','Basel','','Switzerland',756,'Europe/Zurich'),(101191,'Беллинцона','Bellinzona','','Switzerland',756,'Europe/Zurich'),(8481,'Берн','Bern','','Switzerland',756,'Europe/Zurich'),(101192,'Биль','Biel','','Switzerland',756,'Europe/Moscow'),(103012,'Вербье','Verbier','','Switzerland',756,'Europe/Zurich'),(8531,'Винау','Wynau','','Switzerland',756,'Europe/Zurich'),(103113,'Винтертур','Winterthur','','Switzerland',756,'Europe/Zurich'),(8495,'Гренхен','Grenchen','','Switzerland',756,'Europe/Zurich'),(101585,'Гриндельвальд','Grindelwald','','Switzerland',756,'Europe/Zurich'),(8496,'Гютч','Guetsch','','Switzerland',756,'Europe/Zurich'),(101338,'Делемон','Delemont','','Switzerland',756,'Europe/Zurich'),(8489,'Дисентис','Disentis','','Switzerland',756,'Europe/Zurich'),(8474,'Женева','Geneve','','Switzerland',756,'Europe/Zurich'),(101584,'Женева','Geneva','','Switzerland',756,'Europe/Zurich'),(102846,'Зарнен','Sarnen','','Switzerland',756,'Europe/Zurich'),(102848,'Золотурн','Solothurn','','Switzerland',756,'Europe/Zurich'),(8498,'Интерлакен','Interlaken','','Switzerland',756,'America/New_York'),(101988,'Кёниц','Koniz','','Switzerland',756,'Europe/Zurich'),(8486,'Киметта','Cimetta','','Switzerland',756,'Europe/Rome'),(101249,'Коппе','Coppet','','Switzerland',756,'Europe/Zurich'),(8502,'Ла Доле','La Dole','','Switzerland',756,'Europe/Paris'),(8500,'Ла-Шо-де-Фон','La Chaux-De-Fonds','','Switzerland',756,'Europe/Zurich'),(102112,'Лакс','Laax','','Switzerland',756,'Europe/Zurich'),(102115,'Листаль','Liestal','','Switzerland',756,'Europe/Zurich'),(8506,'Лозанна','Lausanne','','Switzerland',756,'Europe/Zurich'),(8475,'Локарно','Locarno','','Switzerland',756,'Europe/Zurich'),(8509,'Лугано','Lugano','','Switzerland',756,'Europe/Zurich'),(102117,'Люцерн','Luzern','','Switzerland',756,'Europe/Zurich'),(8511,'Монтана','Montana','','Switzerland',756,'America/Denver'),(102258,'Монтрё','Montreux','','Switzerland',756,'Europe/Zurich'),(8513,'Нёвшатель','Neuchatel','','Switzerland',756,'Europe/Zurich'),(102473,'Ольтен','Olten','','Switzerland',756,'Europe/Zurich'),(8514,'Пайерне','Payerne','','Switzerland',756,'Europe/Zurich'),(102693,'Райнфельден','Rheinfelden','','Switzerland',756,'Europe/Berlin'),(8521,'Сан-Бернардино','San Bernardino','','Switzerland',756,'America/Los_Angeles'),(8519,'Санкт-Галлен','Saint Gallen','','Switzerland',756,'Europe/Zurich'),(102850,'Санкт-Галлен','St. Gallen','','Switzerland',756,'Europe/Zurich'),(8525,'Санкт-Мориц','St. Moritz','','Switzerland',756,'Europe/Zurich'),(8524,'Сион','Sion','','Switzerland',756,'Europe/Zurich'),(102918,'Устер','Uster','','Switzerland',756,'Europe/Zurich'),(8491,'Фахи','Fahy','','Switzerland',756,'Europe/Dublin'),(101517,'Фрибур','Fribourg','','Switzerland',756,'Europe/Zurich'),(101644,'Хорген','Horgen','','Switzerland',756,'Europe/Zurich'),(103188,'Церматт','Zermatt','','Switzerland',756,'Europe/Zurich'),(103189,'Цолликон','Zollikon','','Switzerland',756,'Europe/Zurich'),(103190,'Цуг','Zug','','Switzerland',756,'Europe/Zurich'),(8476,'Цюрих','Zurich','','Switzerland',756,'Europe/Zurich'),(102851,'Штанс','Stans','','Switzerland',756,'Europe/Vienna'),(8477,'Эгль','Aigle','','Switzerland',756,'Europe/Zurich'),(8499,'Юнгфрауйох','Jungfraujoch','','Switzerland',756,'Europe/Zurich'),(8348,'Абиску','Abisko','','Sweden',752,'Europe/Stockholm'),(8352,'Аржеплог','Arjeplog','','Sweden',752,'Europe/Stockholm'),(8356,'Боден','Boden','','Sweden',752,'Europe/Stockholm'),(8357,'Бурлэнге','Borlange','','Sweden',752,'Europe/Stockholm'),(100746,'Бурос','Boras','','Sweden',752,'Europe/Stockholm'),(102279,'Варберг','Varberg','','Sweden',752,'Europe/Stockholm'),(8467,'Вастерас','Vasteras / Hasslo','','Sweden',752,'Europe/Stockholm'),(8468,'Векшё','Vaxjo','','Sweden',752,'Europe/Stockholm'),(102283,'Вестерос','Vasteras','','Sweden',752,'Europe/Stockholm'),(8346,'Висбю','Visby','','Sweden',752,'Europe/Stockholm'),(8368,'Гаддеде','Gaddede','','Sweden',752,'Europe/Stockholm'),(8369,'Галливаре','Gallivare','','Sweden',752,'Europe/Stockholm'),(8371,'Гётеборг','Goteborg','','Sweden',752,'Europe/Stockholm'),(100992,'Гётеборг','Gothenburg','','Sweden',752,'Europe/Stockholm'),(8372,'Готска-Сандён','Gotska Sandon','','Sweden',752,'Europe/Stockholm'),(8373,'Гуннарн','Gunnarn','','Sweden',752,'Europe/Stockholm'),(8370,'Евле','Gavle','','Sweden',752,'Europe/Stockholm'),(8360,'Есбун','Edsbyn','','Sweden',752,'Europe/Stockholm'),(8392,'Жунсель','Junsele','','Sweden',752,'Europe/Stockholm'),(8393,'Кальмар','Kalmar','','Sweden',752,'Europe/Stockholm'),(101254,'Карлскруна','Karlskrona','','Sweden',752,'Europe/Stockholm'),(101255,'Карлстад','Karlstad','','Sweden',752,'Europe/Stockholm'),(8405,'Квиккжок','Kvikkjokk','','Sweden',752,'Europe/Stockholm'),(8342,'Кируна','Kiruna','','Sweden',752,'Europe/Stockholm'),(101260,'Кристианстад','Kristianstad','','Sweden',752,'Europe/Stockholm'),(8402,'Куггорен','Kuggoren','','Sweden',752,'Europe/Stockholm'),(8407,'Линкопинг','Linkoping / Malmen','','Sweden',752,'Europe/Stockholm'),(8343,'Лулео','Lulea','','Sweden',752,'Europe/Stockholm'),(8412,'Малилла','Malilla','','Sweden',752,'Europe/Stockholm'),(8414,'Малунг','Malung','','Sweden',752,'America/Chicago'),(8413,'Мальмё','Malmo','','Sweden',752,'Europe/Stockholm'),(8378,'Нано','Hano','','Sweden',752,'Europe/Stockholm'),(8421,'Норрчёпинг','Norrkoping','','Sweden',752,'Europe/Stockholm'),(101521,'Нючёпинг','Nykoping','','Sweden',752,'Europe/Stockholm'),(8436,'Роннеби','Ronneby','','Sweden',752,'Europe/Stockholm'),(8439,'Сатенас','Satenas','','Sweden',752,'Europe/Stockholm'),(8453,'Свег','Sveg','','Sweden',752,'Europe/Stockholm'),(8454,'Свенска Хогарна','Svenska Hogarna','','Sweden',752,''),(8445,'Содерхамн','Soderhamn','','Sweden',752,'Europe/Stockholm'),(101949,'Соллентуна','Sollentuna','','Sweden',752,'Europe/Stockholm'),(101958,'Соль','Sunne','','Sweden',752,'Europe/Stockholm'),(8345,'Стокгольм','Stockholm','','Sweden',752,'Europe/Stockholm'),(101956,'Сундбюберг','Sundbyberg','','Sweden',752,'Europe/Stockholm'),(101957,'Сундсвалль','Sundsvall','','Sweden',752,'Europe/Stockholm'),(8461,'Торуп','Torup','','Sweden',752,'Europe/Copenhagen'),(102066,'Треллеборг','Trelleborg','','Sweden',752,'Europe/Stockholm'),(102067,'Трольхеттан','Trollhattan','','Sweden',752,'Europe/Stockholm'),(102211,'Уддевалла','Uddevalla','','Sweden',752,'Europe/Stockholm'),(102215,'Умео','Umea','','Sweden',752,'Europe/Stockholm'),(8465,'Уппсала','Uppsala','','Sweden',752,'Europe/Stockholm'),(8364,'Фалстербо','Falsterbo','','Sweden',752,'Europe/Stockholm'),(8365,'Фалун','Falun','','Sweden',752,'Europe/Stockholm'),(8377,'Хальмстад','Halmstad (Swedish Air Force Base)','','Sweden',752,''),(101118,'Хальмстад','Halmstad','','Sweden',752,'Europe/Stockholm'),(8379,'Хапаранде','Haparanda','','Sweden',752,'Europe/Stockholm'),(8382,'Хеден','Heden','','Sweden',752,'Europe/Stockholm'),(8383,'Хельсингборг','Helsingborg','','Sweden',752,'Europe/Stockholm'),(8384,'Хемаван','Hemavan','','Sweden',752,'Europe/Stockholm'),(8385,'Хобург','Hoburg','','Sweden',752,'Europe/Berlin'),(8386,'Холмогадд','Holmogadd','','Sweden',752,'Europe/Stockholm'),(101946,'Шеллефтео','Skelleftea','','Sweden',752,'Europe/Stockholm'),(8350,'Энгельхольм','Angelholm','','Sweden',752,'Europe/Stockholm'),(8425,'Эребру','Orebro','','Sweden',752,'Europe/Stockholm'),(101588,'Эрншёльдсвик','Ornskoldsvik','','Sweden',752,'Europe/Stockholm'),(100827,'Эскильстуна','Eskilstuna','','Sweden',752,'Europe/Stockholm'),(8344,'Эстерсунд','Ostersund','','Sweden',752,'Europe/Stockholm'),(101124,'Ю','Hjo','','Sweden',752,'Europe/Stockholm'),(8282,'Анурадхапура','Anuradhapura','','Sri Lanka',144,'Asia/Colombo'),(8284,'Баттикалоа','Batticaloa','','Sri Lanka',144,'Asia/Colombo'),(8287,'Галле','Galle','','Sri Lanka',144,'Asia/Colombo'),(8289,'Джафна','Jaffna','','Sri Lanka',144,'Asia/Colombo'),(8290,'Канди','Kandy','','Sri Lanka',144,'Asia/Colombo'),(8291,'Катунаяке','Katunayake','','Sri Lanka',144,'Asia/Colombo'),(8285,'Коломбо','Colombo','','Sri Lanka',144,'Asia/Colombo'),(8292,'Курунегала','Kurunegala','','Sri Lanka',144,'Asia/Colombo'),(8294,'Маннар','Mannar','','Sri Lanka',144,'Asia/Colombo'),(8299,'Ратнапура','Ratnapura','','Sri Lanka',144,'Asia/Colombo'),(8300,'Трикомали','Trincomalee','','Sri Lanka',144,'Asia/Colombo'),(5034,'Бата','Bata','','Equatorial Guinea',226,'Europe/Budapest'),(87094,'Курессааре','Kuressaare','','Estonia',233,'Europe/Tallinn'),(87092,'Кярдла','Kardla','','Estonia',233,'Europe/Tallinn'),(87098,'Маарду','Maardu','','Estonia',233,'Europe/Tallinn'),(87099,'Нарва','Narva','','Estonia',233,'Europe/Tallinn'),(5047,'Пярну','Parnu','','Estonia',233,'Europe/Tallinn'),(87172,'Таллин','Tallinn','','Estonia',233,'Europe/Tallinn'),(87173,'Тарту','Tartu','','Estonia',233,'Europe/Tallinn'),(5064,'Ауаса','Awassa','','Ethiopia',231,'Africa/Addis_Ababa'),(5070,'Гондэр','Gondar','','Ethiopia',231,'Europe/Madrid'),(5074,'Джимма','Jimma','','Ethiopia',231,'Africa/Addis_Ababa'),(5068,'Дыре-Дауа','Dire Dawa','','Ethiopia',231,'Africa/Addis_Ababa'),(8141,'Блумфонтейн','Bloemfontein Airport','','South Africa',710,'Africa/Johannesburg'),(8233,'Велком','Welkom','','South Africa',710,'Africa/Johannesburg'),(8139,'Вифлеем','Bethlehem','','South Africa',710,'America/New_York'),(8154,'Дуглас','Douglas','','South Africa',710,'America/Chicago'),(8155,'Дурбан','Durban (International Airport)','','South Africa',710,'Africa/Johannesburg'),(8149,'Каролина','Carolina','','South Africa',710,'America/Bogota'),(8148,'Кейптаун','Cape Town','','South Africa',710,'Africa/Johannesburg'),(8169,'Кимберли','Kimberley','','South Africa',710,'Africa/Johannesburg'),(8170,'Клерксдорп','Klerksdorp','','South Africa',710,'Africa/Johannesburg'),(8173,'Ледисмит','Ladysmith','','South Africa',710,'Africa/Johannesburg'),(8180,'Мара','Mara','','South Africa',710,'Africa/Dar_es_Salaam'),(8184,'Мидделбург','Middelburg','','South Africa',710,'Europe/Amsterdam'),(8186,'Нельспрут','Nelspruit','','South Africa',710,'Africa/Johannesburg'),(8187,'Ньюкасл','Newcastle','','South Africa',710,'Europe/London'),(8193,'Питерсбург','Pietersburg','','South Africa',710,'Europe/Amsterdam'),(8197,'Порт-Элизабет','Port Elizabeth','','South Africa',710,'Africa/Johannesburg'),(8202,'Почефструм','Potchefstroom','','South Africa',710,'Africa/Johannesburg'),(8204,'Претория','Pretoria','','South Africa',710,'Africa/Johannesburg'),(8207,'Ричардс-Бэй','Richard Bay','','South Africa',710,'America/Detroit'),(8209,'Робертсон','Robertson','','South Africa',710,'America/New_York'),(8210,'Рюстенбург','Rustenburg','','South Africa',710,'Africa/Johannesburg'),(8218,'Таунг','Taung','','South Africa',710,'Africa/Johannesburg'),(8161,'Франкфорт','Frankfort','','South Africa',710,'America/New_York'),(8256,'','Mokp','','South Korea',411,'Asia/Seoul'),(8264,'','Sach','','South Korea',411,'Europe/Rome'),(8236,'Андон','Andong','','South Korea',411,'Asia/Seoul'),(8277,'Вандо','Wando','','South Korea',411,'Asia/Seoul'),(8278,'Вонджу','Wonju','','South Korea',411,'Asia/Seoul'),(8246,'Инчхон','Inchon','','South Korea',411,'America/Chicago'),(8281,'Йосу','Yosu','','South Korea',411,'Europe/Madrid'),(8253,'Кванджу','Kwangju','','South Korea',411,'Asia/Seoul'),(8249,'Коян','Kojin','','South Korea',411,'Asia/Seoul'),(8251,'Кунсан','Kunsan','','South Korea',411,'Asia/Seoul'),(8255,'Масан','Masan','','South Korea',411,'Asia/Seoul'),(8262,'Пусан','Pusan','','South Korea',411,'Asia/Manila'),(8261,'Пхохан','Pohang','','South Korea',411,'Asia/Seoul'),(8265,'Сеул','Seoul','','South Korea',411,'Asia/Seoul'),(8270,'Сувон','Suwon','','South Korea',411,'Asia/Seoul'),(8271,'Тэгу','Taegu','','South Korea',411,'Europe/Bucharest'),(8273,'Тэджон','Taejon','','South Korea',411,'America/New_York'),(8274,'Улцинь','Ulchin','','South Korea',411,'Asia/Harbin'),(8276,'Ульсан','Ulsan','','South Korea',411,'Asia/Seoul'),(8238,'Чинджу','Chinju','','South Korea',411,'Asia/Seoul'),(8241,'Чонджу','Chonju','','South Korea',411,'Asia/Seoul'),(8239,'Чхорвон','Cholwon','','South Korea',411,'Asia/Seoul'),(8242,'Чхунчхон','Chunchon','','South Korea',411,'Asia/Seoul'),(8244,'Чхунчхон','Chupungnyong','','South Korea',411,'Asia/Seoul'),(108643,'Кингстон','Kingston','','Jamaica',388,'America/Jamaica'),(108644,'Монтего-Бэй','Montego Bay','','Jamaica',388,'America/Jamaica'),(108646,'Негрил','Negril','','Jamaica',388,'America/Jamaica'),(108647,'Очо-Риос','Ocho Rios','','Jamaica',388,'America/Jamaica'),(108650,'Рединг','Reading','','Jamaica',388,'America/New_York'),(115303,'Вакаяма','Wakayama','','Japan',392,'Asia/Tokyo'),(6827,'Иокогама','Yokohama','','Japan',392,'Asia/Tokyo'),(6828,'Йокосука','Yokosuka','','Japan',392,'Asia/Tokyo'),(115234,'Кавагути','Kawaguchi','','Japan',392,'Asia/Tokyo'),(115235,'Кавасаки','Kawasaki','','Japan',392,'Asia/Tokyo'),(6679,'Канадзава','Kanazawa','','Japan',392,'Asia/Tokyo'),(6685,'Катсута','Katsuura','','Japan',392,'Asia/Tokyo'),(6701,'Киото','Kyoto','','Japan',392,'Asia/Tokyo'),(115238,'Китакюсю','Kitakyushu','','Japan',392,'Asia/Tokyo'),(115239,'Кобе','Kobe','','Japan',392,'Asia/Tokyo'),(115242,'Кумамото','Kumamoto','','Japan',392,'Asia/Tokyo'),(6699,'Кусиро','Kushiro','','Japan',392,'Asia/Tokyo'),(6706,'Мацумото','Matsumoto','','Japan',392,'Asia/Tokyo'),(115250,'Мацуяма','Matsuyama','','Japan',392,'Asia/Tokyo'),(115253,'Мито','Mito','','Japan',392,'Asia/Tokyo'),(6724,'Миядзаки','Miyazaki','','Japan',392,'Asia/Tokyo'),(115254,'Мориока','Morioka','','Japan',392,'Asia/Tokyo'),(115256,'Нагано','Nagano','','Japan',392,'Asia/Tokyo'),(115258,'Нагасаки','Nagasaki','','Japan',392,'Asia/Tokyo'),(115260,'Нагоя','Nagoya','','Japan',392,'Asia/Tokyo'),(115261,'Наха','Naha','','Japan',392,'Asia/Tokyo'),(6749,'Оита','Oita','','Japan',392,'Asia/Tokyo'),(115269,'Окаяма','Okayama','','Japan',392,'Asia/Tokyo'),(115275,'Осака','Osaka','','Japan',392,'Asia/Tokyo'),(115280,'Сакаи','Sakai','','Japan',392,'Asia/Tokyo'),(6771,'Саппоро','Sapporo','','Japan',392,'Asia/Tokyo'),(6792,'Такамацу','Takamatsu','','Japan',392,'Asia/Tokyo'),(115289,'Такаока','Takaoka','','Japan',392,'Asia/Tokyo'),(115292,'Токио','Tokyo','','Japan',392,'Asia/Tokyo'),(6798,'Токусима','Tokushima','','Japan',392,'Asia/Tokyo'),(6800,'Томакомай','Tomakomai','','Japan',392,'Asia/Tokyo'),(6802,'Тояма','Toyama','','Japan',392,'Europe/Stockholm'),(115205,'Фукуока','Fukuoka','','Japan',392,'Asia/Tokyo'),(6636,'Фусики','Fushiki','','Japan',392,'Asia/Tokyo'),(6645,'Хамамацу','Hamamatsu','','Japan',392,'Asia/Tokyo'),(115215,'Химедзи','Himeji','','Japan',392,'Asia/Tokyo'),(115216,'Хиросима','Hiroshima','','Japan',392,'Asia/Tokyo');

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 2
	                         AND delta_set = 'Main';
-- Fragment ends: 2 --
-- Fragment begins: 3 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (3, 'Main', NOW(), 'dbdeploy', '3-storage_table.sql');
--
ALTER TABLE `storages` ADD `for_simple_storage` tinyint default 1;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 3
	                         AND delta_set = 'Main';
-- Fragment ends: 3 --
-- Fragment begins: 4 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (4, 'Main', NOW(), 'dbdeploy', '4-tv_archive.sql');
--
ALTER TABLE `itv` ADD `enable_tv_archive` tinyint default 0;

CREATE TABLE IF NOT EXISTS `tv_archive`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `storage_name` varchar(128) NOT NULL default '',
    `start_time` timestamp default 0,
    `end_time` timestamp default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`ch_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 4
	                         AND delta_set = 'Main';
-- Fragment ends: 4 --
-- Fragment begins: 5 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (5, 'Main', NOW(), 'dbdeploy', '5-external_storage.sql');
--
ALTER TABLE `storages` ADD `external` tinyint default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 5
	                         AND delta_set = 'Main';
-- Fragment ends: 5 --
-- Fragment begins: 6 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (6, 'Main', NOW(), 'dbdeploy', '6-playback_limit.sql');
--
ALTER TABLE `users` ADD `playback_limit` tinyint default 5;
ALTER TABLE `users` ADD `screensaver_delay` tinyint default 10;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 6
	                         AND delta_set = 'Main';
-- Fragment ends: 6 --
-- Fragment begins: 7 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (7, 'Main', NOW(), 'dbdeploy', '7-wowza_tmp_link.sql');
--
ALTER TABLE `itv` ADD `wowza_tmp_link` tinyint default 0;
ALTER TABLE `itv` ADD `wowza_dvr` tinyint default 0;
ALTER TABLE `itv` ADD `monitoring_status` tinyint default 0;
ALTER TABLE `itv` ADD `monitoring_status_updated` datetime;
ALTER TABLE `itv` ADD `enable_monitoring` tinyint default 0;
ALTER TABLE `itv` ADD `monitoring_url` varchar(128) NOT NULL default '';

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 7
	                         AND delta_set = 'Main';
-- Fragment ends: 7 --
-- Fragment begins: 8 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (8, 'Main', NOW(), 'dbdeploy', '8-account.sql');
--
ALTER TABLE `users` ADD `phone` varchar(64) NOT NULL default '';

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 8
	                         AND delta_set = 'Main';
-- Fragment ends: 8 --
-- Fragment begins: 9 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (9, 'Main', NOW(), 'dbdeploy', '9-vclub_filter.sql');
--
ALTER TABLE `video` ADD `for_sd_stb` tinyint default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 9
	                         AND delta_set = 'Main';
-- Fragment ends: 9 --
-- Fragment begins: 10 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (10, 'Main', NOW(), 'dbdeploy', '10-wowza_load_balancing.sql');
--
ALTER TABLE `itv` ADD `enable_wowza_load_balancing` tinyint default 0;
ALTER TABLE `itv` ADD `quality` varchar(16) default 'high';
ALTER TABLE `users` ADD `tv_quality` varchar(16) default 'high';

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 10
	                         AND delta_set = 'Main';
-- Fragment ends: 10 --
-- Fragment begins: 11 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (11, 'Main', NOW(), 'dbdeploy', '11-users.sql');
--
ALTER TABLE `users` ADD `fname` varchar(64) NOT NULL default '';
ALTER TABLE `storages` ADD `wowza_server` tinyint default 0;
ALTER TABLE `storages` ADD `archive_stream_server` varchar(128) NOT NULL default '';
ALTER TABLE `itv` DROP `quality`;
ALTER TABLE `itv` ADD `cmd_1` varchar(128) NOT NULL default '';
ALTER TABLE `itv` ADD `cmd_2` varchar(128) NOT NULL default '';
ALTER TABLE `itv` ADD `cmd_3` varchar(128) NOT NULL default '';
ALTER TABLE `stream_error` ADD `event` tinyint unsigned default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 11
	                         AND delta_set = 'Main';
-- Fragment ends: 11 --
-- Fragment begins: 12 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (12, 'Main', NOW(), 'dbdeploy', '12-auth.sql');
--
ALTER TABLE `users` ADD `login` varchar(64) NOT NULL default '';
ALTER TABLE `users` ADD `password` varchar(64) NOT NULL default '';
ALTER TABLE `users` DROP INDEX `mac`;
ALTER TABLE `users` ADD KEY `mac` (`mac`);

CREATE TABLE IF NOT EXISTS `user_modules`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `restricted` text NOT NULL,
    `disabled` text NOT NULL,
    `changed` timestamp NOT NULL,
    UNIQUE KEY (`uid`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `video_on_tasks`(
    `id` int NOT NULL auto_increment,
    `video_id` int NOT NULL default 0,
    `date_on`  date,
    `added` timestamp NOT NULL,
    UNIQUE KEY (`video_id`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 12
	                         AND delta_set = 'Main';
-- Fragment ends: 12 --
-- Fragment begins: 13 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (13, 'Main', NOW(), 'dbdeploy', '13-stb_type.sql');
--
ALTER TABLE `users` ADD `stb_type` varchar(32) NOT NULL default '';
ALTER TABLE `users` ADD `serial_number` varchar(32) NOT NULL default '';
ALTER TABLE `events` ADD `auto_hide_timeout` int NOT NULL default 0;
ALTER TABLE `storages` ADD `not_for_mag100` tinyint default 0;

CREATE TABLE IF NOT EXISTS `censored_channels`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `list` text NOT NULL,
    `exclude` text NOT NULL,
    `changed` timestamp NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 13
	                         AND delta_set = 'Main';
-- Fragment ends: 13 --
-- Fragment begins: 14 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (14, 'Main', NOW(), 'dbdeploy', '14-stb_banks.sql');
--
ALTER TABLE `users` ADD `num_banks` tinyint default 0;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 14
	                         AND delta_set = 'Main';
-- Fragment ends: 14 --
-- Fragment begins: 15 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (15, 'Main', NOW(), 'dbdeploy', '15-access_tokens.sql');
--
CREATE TABLE IF NOT EXISTS `access_tokens`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `token` varchar(128) NOT NULL default '',
    `expires` timestamp default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`token`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `clients`(
    `id` int NOT NULL auto_increment,
    `secret` varchar(256) NOT NULL default '',
    `description` text,
    `added` datetime,
    `active` tinyint default 1,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `image_update_settings`(
    `id` int NOT NULL auto_increment,
    `enable` tinyint default 0,
    `require_image_version` varchar(32) NOT NULL default '',
    `require_image_date` varchar(128) NOT NULL default '',
    `image_version_contains` varchar(32) NOT NULL default '',
    `image_description_contains` varchar(128) NOT NULL default '',
    `update_type` varchar(64) NOT NULL default 'http_update',
    `changed` timestamp not null,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE users modify image_version varchar(64) NOT NULL default '';


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 15
	                         AND delta_set = 'Main';
-- Fragment ends: 15 --
-- Fragment begins: 16 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (16, 'Main', NOW(), 'dbdeploy', '16-storages.sql');
--
CREATE TABLE IF NOT EXISTS `storages_failure`(
    `id` int NOT NULL auto_increment,
    `storage_id` int NOT NULL default 0,
    `description` text not null,
    `added` timestamp not null,
    PRIMARY KEY (`id`),
    INDEX storage(`storage_id`, `added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 16
	                         AND delta_set = 'Main';
-- Fragment ends: 16 --
-- Fragment begins: 17 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (17, 'Main', NOW(), 'dbdeploy', '17-access_key.sql');
--
ALTER TABLE `access_tokens` ADD `secret_key` varchar(128) NOT NULL default '';
ALTER TABLE `access_tokens` ADD `time_delta` varchar(128) NOT NULL default '';
ALTER TABLE `access_tokens` ADD `started` timestamp default 0;

CREATE TABLE IF NOT EXISTS `developer_api_key`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `api_key` varchar(128) NOT NULL default '',
    `comment` text not null,
    `expires` timestamp default 0,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`api_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 17
	                         AND delta_set = 'Main';
-- Fragment ends: 17 --
-- Fragment begins: 18 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (18, 'Main', NOW(), 'dbdeploy', '18-tv_logos.sql');
--
ALTER TABLE `itv` ADD `logo` varchar(128) NOT NULL default '';

ALTER TABLE `administrators` ADD `debug_key` varchar(128) NOT NULL default '';

UPDATE `administrators` SET `debug_key`=md5(rand()) WHERE `access`=0;

CREATE TABLE IF NOT EXISTS `user_downloads`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `downloads` text not null,
    `modified` timestamp not null,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 18
	                         AND delta_set = 'Main';
-- Fragment ends: 18 --
-- Fragment begins: 19 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (19, 'Main', NOW(), 'dbdeploy', '19-fake_archive.sql');
--
ALTER TABLE `storages` ADD `fake_tv_archive` tinyint default 0;

ALTER TABLE `video` ADD `kinopoisk_id` varchar(64) not null default '';
ALTER TABLE `video` ADD `rating_kinopoisk` varchar(64) not null default '';
ALTER TABLE `video` ADD `rating_count_kinopoisk` varchar(64) not null default '';
ALTER TABLE `video` ADD `rating_imdb` varchar(64) not null default '';
ALTER TABLE `video` ADD `rating_count_imdb` varchar(64) not null default '';

ALTER TABLE `video` ADD `rating_last_update` timestamp default 0;

CREATE TEMPORARY TABLE `tmp_itv_subscription` AS SELECT * FROM `itv_subscription` GROUP BY `uid`;
TRUNCATE `itv_subscription`;
ALTER TABLE `itv_subscription` DROP INDEX `uid`;
ALTER TABLE `itv_subscription` ADD UNIQUE INDEX (`uid`);
INSERT INTO `itv_subscription` SELECT * FROM `tmp_itv_subscription`;
DROP TABLE `tmp_itv_subscription`;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 19
	                         AND delta_set = 'Main';
-- Fragment ends: 19 --
-- Fragment begins: 20 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (20, 'Main', NOW(), 'dbdeploy', '20-media_favorites.sql');
--
CREATE TABLE IF NOT EXISTS `media_favorites`(
    `id` int NOT NULL auto_increment,
    `uid` int NOT NULL default 0,
    `favorites` text not null,
    `modified` timestamp not null,
    PRIMARY KEY (`id`),
    UNIQUE KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 20
	                         AND delta_set = 'Main';
-- Fragment ends: 20 --
-- Fragment begins: 21 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (21, 'Main', NOW(), 'dbdeploy', '21-tv_reminder.sql');
--
ALTER TABLE `epg` ADD `real_id` varchar(64) not null default '';
UPDATE `epg` SET `real_id`=CONCAT(ch_id, '_', UNIX_TIMESTAMP(`time`)), `time`=`time`;
ALTER TABLE `tv_reminder` ADD `tv_program_real_id` varchar(64) not null default '';
UPDATE `tv_reminder` SET `tv_program_real_id` = (SELECT `real_id` FROM `epg` WHERE `id`=`tv_program_id`);
DELETE FROM `tv_reminder` WHERE `tv_program_real_id`='';
ALTER TABLE `users_rec` ADD `program_real_id` varchar(64) not null default '';

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 21
	                         AND delta_set = 'Main';
-- Fragment ends: 21 --
-- Fragment begins: 22 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (22, 'Main', NOW(), 'dbdeploy', '22-refresh_token.sql');
--
ALTER TABLE `access_tokens` ADD `refresh_token` varchar(128) not null default '';

CREATE TABLE IF NOT EXISTS `tariff_plan`(
  `id` int NOT NULL auto_increment,
  `external_id` varchar(64) not null default '',
  `name` varchar(64) not null default '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `services_package`(
  `id` int NOT NULL auto_increment,
  `external_id` varchar(64) not null default '',
  `name` varchar(64) not null default '',
  `description` text not null,
  `type` varchar(64) not null default '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `package_in_plan`(
  `id` int NOT NULL auto_increment,
  `package_id` int NOT NULL DEFAULT 0,
  `plan_id` int NOT NULL DEFAULT 0,
  `optional` tinyint default 0,
  `modified` timestamp not null,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `service_in_package`(
  `id` int NOT NULL auto_increment,
  `service_id` varchar(64) not null default '',
  `package_id` int NOT NULL DEFAULT 0,
  `type` varchar(64) not null default '',
  `modified` timestamp not null,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_package_subscription`(
  `id` int NOT NULL auto_increment,
  `user_id` int NOT NULL DEFAULT 0,
  `package_id` int NOT NULL DEFAULT 0,
  `modified` timestamp not null,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `users` ADD `tariff_plan_id` int not null default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 22
	                         AND delta_set = 'Main';
-- Fragment ends: 22 --
-- Fragment begins: 23 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (23, 'Main', NOW(), 'dbdeploy', '23-correct_time.sql');
--
ALTER TABLE `itv` ADD `correct_time` int not null default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 23
	                         AND delta_set = 'Main';
-- Fragment ends: 23 --
-- Fragment begins: 24 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (24, 'Main', NOW(), 'dbdeploy', '24-account_number.sql');
--
ALTER TABLE `users` MODIFY `ls` VARCHAR(64) NOT NULL DEFAULT '';

ALTER TABLE `tariff_plan` ADD `user_default` tinyint default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 24
	                         AND delta_set = 'Main';
-- Fragment ends: 24 --
-- Fragment begins: 25 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (25, 'Main', NOW(), 'dbdeploy', '25-epg_claims.sql');
--
ALTER TABLE `media_claims` ADD `no_epg` int not null default 0;
ALTER TABLE `media_claims` ADD `wrong_epg` int not null default 0;
ALTER TABLE `daily_media_claims` ADD `no_epg` int not null default 0;
ALTER TABLE `daily_media_claims` ADD `wrong_epg` int not null default 0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 25
	                         AND delta_set = 'Main';
-- Fragment ends: 25 --
-- Fragment begins: 26 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (26, 'Main', NOW(), 'dbdeploy', '26-last_channel.sql');
--
ALTER TABLE `last_id` ADD `uid` int not null default 0;
UPDATE `last_id` SET `uid`=(SELECT id FROM `users` where mac=ident limit 1);
ALTER TABLE `last_id` DROP KEY `ident`;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 26
	                         AND delta_set = 'Main';
-- Fragment ends: 26 --
-- Fragment begins: 27 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (27, 'Main', NOW(), 'dbdeploy', '27-spdif.sql');
--
ALTER TABLE `users` MODIFY `audio_out` int NOT NULL default 1;
UPDATE `users` SET audio_out=1 WHERE audio_out=0;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 27
	                         AND delta_set = 'Main';
-- Fragment ends: 27 --
-- Fragment begins: 28 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (28, 'Main', NOW(), 'dbdeploy', '28-user_comment.sql');
--
ALTER TABLE `users` ADD `comment` text not null;
ALTER TABLE `epg_setting` ADD `id_prefix` VARCHAR(64) NOT NULL DEFAULT '';

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 28
	                         AND delta_set = 'Main';
-- Fragment ends: 28 --
-- Fragment begins: 29 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (29, 'Main', NOW(), 'dbdeploy', '29-cleanup_db.sql');
--
DELETE FROM `user_log` WHERE `time`<FROM_UNIXTIME(UNIX_TIMESTAMP(NOW())-86400);
OPTIMIZE TABLE `user_log`;

TRUNCATE `stream_error`;

DELETE FROM `events` WHERE `eventtime`<now();
OPTIMIZE TABLE `events`;

CREATE TABLE IF NOT EXISTS `ch_links`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `priority` int NOT NULL default 0,
    `url` varchar(255) NOT NULL default '',
    `status` tinyint default 1,
    `use_http_tmp_link` tinyint default 0,
    `wowza_tmp_link` tinyint default 0,
    `user_agent_filter` varchar(32) NOT NULL default '',
    `monitoring_url` varchar(128) NOT NULL default '',
    `use_load_balancing` tinyint default 0,
    `changed` timestamp NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

TRUNCATE `ch_links`;

INSERT INTO `ch_links` (`ch_id`, `url`, `use_http_tmp_link`, `wowza_tmp_link`, `monitoring_url`) SELECT id, cmd, use_http_tmp_link, wowza_tmp_link, monitoring_url  FROM `itv`;

CREATE TABLE IF NOT EXISTS `streaming_servers`(
  `id` int NOT NULL auto_increment,
  `name` varchar(128) not null default '',
  `address` varchar(128) not null default '',
  `max_sessions` int not null default 0,
  `status` tinyint default 1,
  `live_status` tinyint default 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ch_link_on_streamer`(
  `id` int NOT NULL auto_increment,
  `link_id` int not null default 0,
  `streamer_id` tinyint default 0,
  `modified` timestamp not null,
  INDEX (`link_id`),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `users` ADD `now_playing_link_id` int not null default 0;
ALTER TABLE `users` ADD `now_playing_streamer_id` int not null default 0;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 29
	                         AND delta_set = 'Main';
-- Fragment ends: 29 --
-- Fragment begins: 30 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (30, 'Main', NOW(), 'dbdeploy', '30-zones.sql');
--

CREATE TABLE IF NOT EXISTS `stream_zones`(
    `id` int NOT NULL auto_increment,
    `name` varchar(128) not null default '',
    `default_zone` tinyint default 0,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `countries_in_zone`(
    `id` int NOT NULL auto_increment,
    `country_id` int not null default 0,
    `zone_id` int not null default 0,
    INDEX (`country_id`),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `streaming_servers` ADD `stream_zone` int not null default 0;

ALTER TABLE `ch_links` ADD `enable_monitoring` tinyint default 0;

UPDATE `itv` SET monitoring_status=1;

UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 30
	                         AND delta_set = 'Main';
-- Fragment ends: 30 --
-- Fragment begins: 31 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (31, 'Main', NOW(), 'dbdeploy', '31-indexes.sql');
--

ALTER TABLE `itv` ADD INDEX base_ch (`base_ch`);
ALTER TABLE `ch_links` ADD INDEX (`ch_id`);
ALTER TABLE `ch_links` ADD INDEX ch_id_status (`ch_id`, `status`);

ALTER TABLE `epg` ADD INDEX real_id (`real_id`);

ALTER TABLE `tv_reminder` ADD INDEX tv_program_real_id (`tv_program_real_id`);
ALTER TABLE `tv_reminder` ADD INDEX ch_id_real_id (`tv_program_real_id`, `ch_id`);
ALTER TABLE `tv_reminder` ADD INDEX mac_time (`mac`, `fire_time`);

ALTER TABLE `storages` ADD INDEX status_simple (`status`, `for_simple_storage`);

ALTER TABLE `radio` ADD `volume_correction` int NOT NULL default 0;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 31
	                         AND delta_set = 'Main';
-- Fragment ends: 31 --
-- Fragment begins: 32 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (32, 'Main', NOW(), 'dbdeploy', '32-services.sql');
--

ALTER TABLE `services_package` ADD `all_services` tinyint default 0;

ALTER TABLE `users` MODIFY `comment` text;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 32
	                         AND delta_set = 'Main';
-- Fragment ends: 32 --
-- Fragment begins: 33 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (33, 'Main', NOW(), 'dbdeploy', '33-text.sql');
--

ALTER TABLE `video` MODIFY `series` text;
ALTER TABLE `video` MODIFY `rate` text;

ALTER TABLE `itv` MODIFY `descr` text;

ALTER TABLE `events` MODIFY `msg` text;

ALTER TABLE `fav_itv` MODIFY `fav_ch` text;
ALTER TABLE `fav_vclub` MODIFY `fav_video` text;

ALTER TABLE `moderators_history` MODIFY `comment` text;

ALTER TABLE `itv_subscription` MODIFY `sub_ch` text;
ALTER TABLE `itv_subscription` MODIFY `bonus_ch` text;

ALTER TABLE `rss_cache_weather` MODIFY `content` text;
ALTER TABLE `rss_cache_horoscope` MODIFY `content` text;

ALTER TABLE `anec` MODIFY `anec_body` text;
ALTER TABLE `course_cache` MODIFY `content` text;

ALTER TABLE `storage_cache` MODIFY `storage_data` text;

ALTER TABLE `user_modules` MODIFY `restricted` text;
ALTER TABLE `user_modules` MODIFY `disabled` text;

ALTER TABLE `censored_channels` MODIFY `list` text;
ALTER TABLE `censored_channels` MODIFY `exclude` text;

ALTER TABLE `storages_failure` MODIFY `description` text;

ALTER TABLE `developer_api_key` MODIFY `comment` text;

ALTER TABLE `user_downloads` MODIFY `downloads` text;

ALTER TABLE `media_favorites` MODIFY `favorites` text;

ALTER TABLE `services_package` MODIFY `description` text;

ALTER TABLE `users` MODIFY `comment` text;

ALTER TABLE `itv` ADD `allow_pvr` tinyint default 0;

UPDATE `itv` SET allow_pvr=1 WHERE mc_cmd!='';

ALTER TABLE `video_log` ADD `video_name` varchar(128) not null default '';


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 33
	                         AND delta_set = 'Main';
-- Fragment ends: 33 --
-- Fragment begins: 34 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (34, 'Main', NOW(), 'dbdeploy', '34-archive.sql');
--

ALTER TABLE `tv_archive` DROP INDEX `ch_id`;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 34
	                         AND delta_set = 'Main';
-- Fragment ends: 34 --
-- Fragment begins: 35 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (35, 'Main', NOW(), 'dbdeploy', '35-users_created.sql');
--

ALTER TABLE `users` ADD `just_started` tinyint default 0;
ALTER TABLE `users` ADD `last_watchdog` timestamp;
ALTER TABLE `users` ADD `created` timestamp;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 35
	                         AND delta_set = 'Main';
-- Fragment ends: 35 --
-- Fragment begins: 36 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (36, 'Main', NOW(), 'dbdeploy', '36-rating.sql');
--

ALTER TABLE `video` ADD `age` VARCHAR(32) default '';
ALTER TABLE `video` ADD `rating_mpaa` VARCHAR(32) default '';

ALTER TABLE `services_package` ADD `service_type` VARCHAR(32) default 'periodic';


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 36
	                         AND delta_set = 'Main';
-- Fragment ends: 36 --
-- Fragment begins: 37 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (37, 'Main', NOW(), 'dbdeploy', '37-video_rent.sql');
--

ALTER TABLE `services_package` ADD `rent_duration` int NOT NULL default 0;

CREATE TABLE IF NOT EXISTS `video_rent`(
  `id` int NOT NULL auto_increment,
  `uid` int NOT NULL default 0,
  `video_id` int NOT NULL default 0,
  `price` varchar(32) NOT NULL default '',
  `rent_history_id` int NOT NULL default 0,
  `rent_date` timestamp default 0,
  `rent_end_date` timestamp default 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `video_rent_history`(
  `id` int NOT NULL auto_increment,
  `uid` int NOT NULL default 0,
  `video_id` int NOT NULL default 0,
  `price` varchar(32) NOT NULL default '',
  `rent_date` timestamp default 0,
  `rent_end_date` timestamp default 0,
  `start_watching_date` timestamp default 0,
  `watched` tinyint default 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `image_update_settings` ADD `stb_type` VARCHAR(64) NOT NULL DEFAULT '';


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 37
	                         AND delta_set = 'Main';
-- Fragment ends: 37 --
-- Fragment begins: 38 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (38, 'Main', NOW(), 'dbdeploy', '38-local_pvr.sql');
--

ALTER TABLE `users_rec` ADD `local` tinyint default 0;
ALTER TABLE `users_rec` ADD `file` varchar(255) NOT NULL default '';
ALTER TABLE `users_rec` ADD `internal_id` varchar(32) NOT NULL default '';
ALTER TABLE `itv` ADD `allow_local_pvr` tinyint default 1;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 38
	                         AND delta_set = 'Main';
-- Fragment ends: 38 --
-- Fragment begins: 39 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (39, 'Main', NOW(), 'dbdeploy', '39-apache_port.sql');
--

ALTER TABLE `storages` ADD `apache_port` varchar(8) NOT NULL default '88';

CREATE TABLE IF NOT EXISTS `pvr_storages`(
    `id` int NOT NULL auto_increment,
    `ch_id` int NOT NULL default 0,
    `storage_name` varchar(128) NOT NULL default '',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO pvr_storages (ch_id, storage_name) SELECT itv.id, storage_name FROM itv CROSS JOIN storages WHERE storages.status=1 AND for_records=1 AND allow_pvr=1;


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 39
	                         AND delta_set = 'Main';
-- Fragment ends: 39 --
-- Fragment begins: 40 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (40, 'Main', NOW(), 'dbdeploy', '40-balancer_monitoring.sql');
--

ALTER TABLE `ch_links` ADD `enable_balancer_monitoring` tinyint default 0;
ALTER TABLE `ch_link_on_streamer` ADD `monitoring_status` tinyint default 1;

DELETE FROM `ch_links` WHERE `ch_id` not in (SELECT `id` FROM `itv`);


UPDATE changelog
	                         SET complete_dt = NOW()
	                         WHERE change_number = 40
	                         AND delta_set = 'Main';
-- Fragment ends: 40 --
-- Fragment begins: 41 --
INSERT INTO changelog
                                (change_number, delta_set, start_dt, applied_by, description) VALUES (41, 'Main', NOW(),